//=============================================================================
// ** RPG Maker MZ - Hakubox_Component_Extras_Switch.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制功能 - 定制额外开关插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制额外开关插件。
 * 
 */
// #endregion
(() => {

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Component_Extras_Switch";

  const typeDefine = {
  };
  // #endregion

  // #region 插件参数

  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);
  
  // #endregion

  // #region 系统菜单

  /** 系统菜单场景 */
  class Scene_Haku_Extras_Switch extends Scene_Base {
    initialize() {
      super.initialize();

      this.animeType = 'in';

      this.btns = [
        {
          id: 1, text: '夜晚必定夜袭', desc: '',
          getValue() {
            return $gameSwitches.value(16);
          },
          setValue(val) {
            $gameSwitches.setValue(16, val);
          },
          condition() {
            return true;
          }
        }, {
          id: 2, text: '透视眼镜', desc: '',
          getValue() {
            return $gameSwitches.value(17);
          },
          setValue(val) {
            $gameSwitches.setValue(17, val);
          },
          condition() {
            return $gameSwitches.value(8);
          }
        }, {
          id: 3, text: '千夏巨乳化', desc: '',
          getValue() {
            return $gameSwitches.value(18);
          },
          setValue(val) {
            $gameSwitches.setValue(18, val);
          },
          condition() {
            return $gameSwitches.value(20);
          }
        }, {
          id: 4, text: '时间停止', desc: '',
          getValue() {
            return $gameSwitches.value(19);
          },
          setValue(val) {
            $gameSwitches.setValue(19, val);
          },
          condition() {
            return $gameSwitches.value(22);
          }
        },
      ];

      this.animeInOutInfo = useAnime({
        frameDelay: 0,
        frameCount: 15,
        easingType: 'Quadratic',
        inout: 'InOut',
      }, progress => {
        const _baseY = (Graphics.height - 410) / 2;
        const _baseY2 = (Graphics.height - 410) / 2;
        if (this.animeType === 'in') {
          this.menuContainer.alpha = progress;
          this.menuContainer.y = parseInt(_baseY + 50 - progress * 50);
          
          this._windowBgSprite.alpha = progress;
          this._windowBgSprite.y = parseInt(_baseY2 + 50 - progress * 50);
          
          this._backgroundSprite.opacity = 255 - progress * 80;
        } else if (this.animeType === 'out') {
          this.menuContainer.alpha = 1 - progress;
          this.menuContainer.y = parseInt(_baseY + progress * 50);
          
          this._windowBgSprite.alpha = 1 - progress;
          this._windowBgSprite.y = parseInt(_baseY2 + progress * 50);
          
          this._backgroundSprite.opacity = 255 - 80 + progress * 80;
          if (progress >= 1) {
            $gameData.tempSceneInfo.canUse = false;
            SceneManager.pop();
          }
        }
      });
    }

    start() {
      super.start();
      // this.startFadeOut(this.fadeSpeed(), false);
    }

    create() {
      super.create();
      this.createBackground();
      this.createWindowBackground();
      this.createWindowLayer();
      this.createCommandWindow();
    }

    /** 半透明背景 */
    createBackground() {
      // this._backgroundFilter = new PIXI.filters.BlurFilter();
      this._backgroundSprite = new Sprite();
      this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
      this._backgroundSprite.filters = []; // this._backgroundFilter
      this.addChild(this._backgroundSprite);
      // this.setBackgroundOpacity(192);
    }

    /** 系统窗口背景 */
    createWindowBackground() {
      this._windowBgSprite = new Sprite();
      this.addChild(this._windowBgSprite);
      ImageManager.loadImgCb('ui/extra_switch/background', (bitmap) => {
        this._windowBgSprite.bitmap = new Bitmap(bitmap.width, bitmap.height);
        this._windowBgSprite.alpha = 0;
        this._windowBgSprite.x = (Graphics.width - 400) / 2;
        this._windowBgSprite.y = (Graphics.height - 410) / 2;

        this._windowBgSprite.bitmap.blt(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0);
        let _count = 0;
        const _btns = this.btns.filter(item => item.condition());
        for (let i = 0; i < _btns.length - 1; i++) {
          _count++;
          this._windowBgSprite.bitmap.fillRect(
            22, 128 + 55 * i, 
            350, 1, 
            'rgba(0,0,0,0.3)'
          );
        }
      });
    }

    setBackgroundOpacity(opacity) {
      this._backgroundSprite.opacity = opacity;
    }

    sysMenuBgRect() {
      const ww = 690;
      const wh = 428;
      const wx = Graphics.width / 2 - ww / 2;
      const wy = Graphics.height / 2 - wh / 2;
      return new Rectangle(wx, wy, ww, wh);
    }

    sysMenuRect() {
      const ww = 345;
      const wh = 300;
      const wx = Graphics.width / 2 - ww / 2 + 22;
      const wy = Graphics.height / 2 - wh / 2 + 70;
      return new Rectangle(wx, wy, ww, wh);
    }

    createCommandWindow() {
      if (this.menuContainer) {
        this.menuContainer.removeChildren();
      } else {
        this.menuContainer = new HakuContainer({
          x: (Graphics.width - 400) / 2,
          y: (Graphics.height - 410) / 2,
        });
        this.menuContainer.alpha = 0;
        this.addChild(this.menuContainer);
      }
      
      // 关闭按钮
      const _closeBtn = new HakuSprite({
        useHover: true, x: 440, y: -60, me: this,
        normalBitmap: ImageManager.loadPicture('ui/sys_menu/sys_btn_close'),
        hoverBitmap: ImageManager.loadPicture('ui/sys_menu/sys_btn_close_active'),
        onTap: () => {
          SoundManager.playCancel();
          this.animeInOutInfo.start();
          this.animeType = 'out';
        }
      });
      this.menuContainer.addChild(_closeBtn);

      // 添加标题
      const _spriteTitle = new Sprite(new Bitmap(400, 50));
      _spriteTitle.x = 0;
      _spriteTitle.y = 20;
      _spriteTitle.bitmap.smooth = false;
      _spriteTitle.bitmap.textColor = '#FFFFFF';
      _spriteTitle.bitmap.fontFace = 'ChillRoundF';
      _spriteTitle.bitmap.fontSize = 26;
      _spriteTitle.bitmap.outlineWidth = 5;
      _spriteTitle.bitmap.outlineColor = '#665258';

      const _titleText = TranslateUtils.getText('额外游戏开关');
      _spriteTitle.bitmap.drawText(_titleText, 0, 0, 400, 50, 'center');
      const _titleWidth = _spriteTitle.bitmap.measureTextWidth(_titleText);
      _spriteTitle.bitmap.bltImg('ui/extra_switch/icon_tip', undefined, {
        x: (400 - _titleWidth) / 2 - 30, y : 16,
        width: 20, height: 21,
      });
      _spriteTitle.bitmap.bltImg('ui/extra_switch/icon_tip', undefined, {
        x: 200 + _titleWidth / 2 + 10, y : 16,
        width: 20, height: 21,
      });
      this.menuContainer.addChild(_spriteTitle);

      let _index = -1;
      for (let i = 0; i < this.btns.length; i++) {
        const item = this.btns[i];
        
        if (item.condition()) {
          _index++;
          const _btnContainer = new HakuContainer({
            useHover: true, x: 20, y: 80 + _index * 55, me: this,
            onHover() {
              _sprite.alpha = 1;
            },
            disabled() { return item.disabled; },
            onBlur() {
              _sprite.alpha = 0;
            },
            onTap() {
              const _val = item.getValue();
              item.setValue(!_val);
              item.switchSprite.bitmap = ImageManager.loadPicture(`ui/extra_switch/switch_${!_val ? 'on' : 'off'}`);

              if (item.onTap) item.onTap.call(this.me);
            }
          });
          this.btns[i].container = _btnContainer;

          // 添加背景
          const _sprite = new Sprite(ImageManager.loadPicture(`ui/extra_switch/item_bg`));
          _sprite.bitmap.smooth = false;
          _sprite.alpha = 0;
          this.btns[i].bgSprite = _sprite;
          _btnContainer.addChild(_sprite);
          
          // 添加图标
          const _iconSprite = new Sprite(ImageManager.loadPicture('ui/extra_switch/icon_tip'));
          _iconSprite.bitmap.smooth = false;
          _iconSprite.x = 18;
          _iconSprite.y = 10;
          _btnContainer.addChild(_iconSprite);
          
          // 添加文字
          const _textSprite = new Sprite(new Bitmap(194, 40));
          _textSprite.bitmap.smooth = false;
          this.btns[i].textSprite = _textSprite;
          _textSprite.x = 25;
          _textSprite.y = 0;
          _textSprite.bitmap.fontFace = 'ChillRoundF';
          _textSprite.bitmap.fontSize = 20;
          _textSprite.bitmap.outlineWidth = 0;
          _textSprite.bitmap.outlineColor = 'rgba(0,0,0,0)';
          _textSprite.bitmap.textColor = '#665258';
          _textSprite.bitmap.drawText(item.text, 20, 0, 350, 40, 'left');
          _btnContainer.addChild(_textSprite);
          
          // 添加假开关
          const _val = item.getValue();
          const _switchSprite = new Sprite(ImageManager.loadPicture(`ui/extra_switch/switch_${_val ? 'on' : 'off'}`));
          _switchSprite.bitmap.smooth = false;
          this.btns[i].switchSprite = _switchSprite;
          _switchSprite.x = 290;
          _switchSprite.y = 5;
          _btnContainer.addChild(_switchSprite);

          this.menuContainer.addChild(_btnContainer);
        }
      }

      this.animeInOutInfo.start();
    }

    commandSave() {
      SceneManager.push(Scene_Save);
    }

    commandLoad() {
      SceneManager.push(Scene_Load);
    }

    commandOptions() {
      SceneManager.push(Scene_Options);
    }

    commandReturnTitle() {
      SceneManager.goto(Scene_Title);
    }

    update() {
      super.update();

      this._tempHoverElementId = undefined;

      this.animeInOutInfo.update();

      if (TouchInput.isCancelled() || Input.isTriggered('cancel')) {
        SoundManager.playCancel();
        this.animeInOutInfo.start();
        this.animeType = 'out';
      }

      const _x = TouchInput.x;
      const _y = TouchInput.y;

      if (TouchInput.isTriggered()) {
        if (
          _x < (Graphics.width - 400) / 2 || _x > (Graphics.width + 400) / 2 || 
          _y < (Graphics.height - 410) / 2 || _y > (Graphics.height + 410) / 2
        ) {
          SoundManager.playCancel();
          this.animeInOutInfo.start();
          this.animeType = 'out';
        }
      }
    }
  }
  window.Scene_Haku_Extras_Switch = Scene_Haku_Extras_Switch;

  // #endregion

})();