//=============================================================================
// ** RPG Maker MZ - Hakubox_Component_Log.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制功能 - 定制历史记录插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制历史记录插件。
 * 
 */
// #endregion
(() => {

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Component_Log";

  const typeDefine = {
  };
  // #endregion

  // #region 插件参数

  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);
  
  // #endregion


  const Game_Interpreter_command101 = Game_Interpreter.prototype.command101;
  Game_Interpreter.prototype.command101 = function(params) {
    const _re = Game_Interpreter_command101.call(this, params);

    let _tachieInfo = SceneManager._scene.spine;

    if (_tachieInfo) {
      _tachieInfo = _tachieInfo.tachieInfo;
    }
    
    if (_tachieInfo && _tachieInfo.spineName && _tachieInfo.spineName !== '\\N[1]') {
      Utils_History.addMessageHistory({
        name: params[4],
        spineName: _tachieInfo.spineName,
        head: _tachieInfo.skin.slice(0),
        message: $gameMessage._texts.join('\n'),
        audio: AudioManager.historyCV || undefined
      });
    } else {
      Utils_History.addMessageHistory({
        name: params[4],
        message: $gameMessage._texts.join('\n'),
        audio: AudioManager.historyCV || undefined
      });
    }
    AudioManager.historyCV = undefined;

    return _re;
  };

  
  /**
   * 商品购买场景
   */
  class Scene_Haku_Log extends Scene_Base {
    initialize() {
      super.initialize();

      this._disabledFade = true;

      this.pageIndex = 0;
      this.maxPageIndex = 2;

      this.pageWidth = 1000;
      this.pageHeight = 510;

      this.animeType = 'in';

      this.animeInOutInfo = useAnime({
        frameDelay: 0,
        frameCount: 2,
        easingType: 'Quadratic',
        inout: 'InOut',
      }, progress => {
        const _baseY = (Graphics.height - this.pageHeight) / 2 + 40;
        if (this.animeType === 'in') {
          this._messageWindow.alpha = progress;
          // this._messageWindow.y = parseInt(_baseY - 30 + progress * 30);
          if ($historyMessage.messages.length > 3) this.scroll.contents.alpha = progress;
          this.scroll.y = parseInt(160 - 30 + progress * 30);
        } else if (this.animeType === 'out') {
          this._messageWindow.alpha = 1 - progress;
          // this._messageWindow.y = parseInt(_baseY - progress * 30);
          if ($historyMessage.messages.length > 3) this.scroll.contents.alpha = 1 - progress;
          this.scroll.y = parseInt(160 - progress * 30);
          if (progress >= 1) {
            $gameSystem.enableMenu();
            SceneManager.pop();
          }
        }
      });
    }

    cancelMessageWait() {

    }

    create() {
      $gameSystem.disableMenu();
      super.create();
      this.createBackground();
      this.createLogWindow();

      this.scroll = useScrollBar(new Rectangle(1130, 160, 30, 450), {
        direction: 'horizontal',
        barImage: 'ui/common/scroll_vertical_bar',
        thumbImage: 'ui/common/scroll_vertical_thumb2',
        pageHeight: this._messageWindow.height,
        dragMove(val) {
          console.log('进度', val);
        }
      });
      this.scroll.contents.alpha = $historyMessage.messages.length > 3 ? 1 : 0;
      this.addChild(this.scroll.contents);
      this._messageWindow.bindScroll(this.scroll);

      
      const btn = new HakuComponent.Button({
        style: { backgroundImage: '/img/pictures/ui/common/btn_back' },
        'hover:style': { backgroundImage: '/img/pictures/ui/common/btn_back_active' },
        'tap:style': { backgroundImage: '/img/pictures/ui/common/btn_back_active' },
      });
      btn.width = 200;
      btn.height = 64;
      btn.x = 1090;
      btn.y = 20;
      btn.on('tap', () => {
        SoundManager.playCancel();
        this.animeInOutInfo.start();
        this.animeType = 'out';
      });
      this.addChild(btn);
    }

    update() {
      super.update();

      this.animeInOutInfo.update();

      if (TouchInput.isCancelled() || Input.isTriggered('cancel')) {
        SoundManager.playCancel();
        this.animeInOutInfo.start();
        this.animeType = 'out';
      }
    }

    /** 透明背景 */
    createBackground() {
      this._backgroundSprite = new Sprite(ImageManager.loadPicture('ui/background'));
      this.addChildAt(this._backgroundSprite, 0);
      
      this._panelSprite = new Sprite(ImageManager.loadPicture('ui/history_message/bg'));
      this._panelSprite.x = 0;
      this._panelSprite.y = 0;
      this.addChildAt(this._panelSprite, 1);
      
      this._titleSprite = new Sprite(ImageManager.loadPicture('ui/title_txt/history_message_title_zh-CN'));
      this._titleSprite.x = 100;
      this._titleSprite.y = 42;
      this.addChildAt(this._titleSprite, 2);
    }

    /** 获取历史记录窗口的矩形 */
    shopWindowRect() {
      const wx = (Graphics.width - this.pageWidth) / 2 - 50;
      const wy = (Graphics.height - this.pageHeight) / 2  + 40;
      const ww = this.pageWidth;
      const wh = this.pageHeight;
      return new Rectangle(wx, wy, ww, wh);
    }

    /** 创建历史记录页面 */
    createLogWindow() {
      const rect = this.shopWindowRect();
      this._messageWindow = new Window_Haku_Log(rect, this.pageWidth, this.pageHeight);
      this._messageWindow.alpha = 0;
      this.addChild(this._messageWindow);
      this.animeInOutInfo.start();
    }
  }
  window.Scene_Haku_Log = Scene_Haku_Log;

  /** 历史记录栏页面 */
  class Window_Haku_Log extends Window_Selectable {
    initialize(rect, pageWidth, pageHeight) {
      super.initialize(rect);
      // this.openness = 0;
      this.opacity = 0;
      this.pageWidth = pageWidth;
      this.pageHeight = pageHeight;

      this.contents.smooth = false;
      this.contents.fontFace = 'ChillRoundF';
      this.contents.fontSize = 28;
      this.contents.outlineWidth = 1;
      this.contents.outlineColor = 'rgba(0,0,0,0)';
      
      this.activeIndex = -1;
      this._index = -1;
      this._hoverIndexes = [];

      this._list = cloneLoop($historyMessage.messages || []);

      this.windowContainer = new PIXI.Container();
      this.addChildAt(this.windowContainer, 0);
      
      this.refresh();
    }

    dragMove(scrollTop, smooth = false) {
      if (smooth) {
        this.smoothScrollTo(0, scrollTop);
      } else {
        this.scrollTo(0, scrollTop);
      }
    }

    destroy() {
      super.destroy();

      if (this.scroll) {
        this.scroll.destroy();
      }
    }

    /** 绑定滚动条 */
    bindScroll(scroll) {
      this.scroll = scroll;
      this.scroll._dragMove = this.dragMove.bind(this);
      this.scroll.contentHeight = this.overallHeight();
    }

    updatePadding() {
      this.padding = 6;
    }

    itemHeight() {
      return 170;
    }
    rowSpacing() {
      return 10;
    }

    maxItems() {
      return this._list.length;
    }

    refresh() {
      super.refresh();
      
      if (this.scroll) {
        this.scroll.contentHeight = this.overallHeight();
      }
    }

    updateOrigin() {
      const blockWidth = this.scrollBlockWidth() || 1;
      const blockHeight = 1; // this.scrollBlockHeight() || 
      const baseX = this._scrollX - (this._scrollX % blockWidth);
      const baseY = this._scrollY - (this._scrollY % blockHeight);
      if (baseX !== this._scrollBaseX || baseY !== this._scrollBaseY) {
        this.updateScrollBase(baseX, baseY);
        this.paint();
      }
      this.origin.x = this._scrollX % blockWidth;
      this.origin.y = this._scrollY % blockHeight;
    }

    update() {
      super.update();

      const _x = TouchInput.x;
      const _y = TouchInput.y;
      const _iconWidth = 55;
      const _iconHeight = 56;
      
      
      const topIndex = this.topIndex();
      for (let i = 0; i < this.maxVisibleItems(); i++) {
        const index = topIndex + i;
        if (index < this.maxItems()) {
          const rect = this.itemLineRect(index);

          const _item = this._list[index];

          if (_item.audio) {
            const _name = this.getName(_item.name);
            const _nameWidth = this.contents.measureTextWidth(_name || '');

            const _itemHeight = this.itemHeight();
            const _itemX = rect.x + 255 + _nameWidth;
            const _itemY = rect.y - 80 + _itemHeight;

            if (
              _x > _itemX && _x < _itemX + _iconWidth && 
              _y > _itemY && _y < _itemY + _iconHeight
            ) {
              this.activeIndex = index;
              Utils_Cursor.cursorType = "pointer";
              if (!this._hoverIndexes[index]) {
                SoundManager.playCursor();
                this.contents.clearRect(_itemX - 84, _itemY + 32 - _itemHeight, 35, 36);
                this.contents.bltImg('ui/history_message/btn_audio_active', undefined, {
                  x: _itemX - 84, y: _itemY + 32 - _itemHeight, width: 35, height: 36
                });
              }
              
              this._hoverIndexes[index] = true;

              if (TouchInput.isTriggered()) {
                SoundManager.playOk();
                AudioManager.playCv({
                  name: _item.audio.cvName,
                  volume: Number(_item.audio.cvVolumn || 100) || 100,
                  pitch: 100,
                  pan: 0
                });
              }
            } else if (this._hoverIndexes[index]) {
              Utils_Cursor.cursorType = "default";
              this.contents.clearRect(_itemX - 84, _itemY + 32 - _itemHeight, 35, 36);
              this.contents.bltImg('ui/history_message/btn_audio', undefined, {
                x: _itemX - 84, y: _itemY + 32 - _itemHeight, width: 35, height: 36
              });
              this._hoverIndexes[index] = false;
            }
          }
        }
      }

      if (this.scroll) {
        this.scroll.update(this._scrollY);
      }

    }

    drawBackgroundRect(rect) {
      // const x = rect.x + 10;
      // const y = rect.y + 10;
      
    }

    getName(name) {
      let _name = name;

      let _match = /\N\[(\d+)\]/.exec(_name);
      if (_match) {
        if (_match[1]) {
          return $gameActors.actor(1).name(Number(_match[1]));
        }
      }
      return _name;
    }

    getActorName(name) {
      if (name === '加奈') return 'kana';
      else if (name === '千夏') return 'chinatsu';
      else if (name === '由纪') return 'yuki';
      else if (name === '艾露') return 'ere';
      else return '';
    }

    drawItem(index) {
      const rect = this.itemLineRect(index);
      this.resetTextColor();

      const _item = this._list[index];
      
      // 名称
      this.drawTextEx(_item.name, rect.x + 145, rect.y - 50, rect.width, {
        fontFace: 'ChillRoundF',
        fontSize: 28,
        textColor: '#665258'
      });

      const _name = this.getName(_item.name);
      const _nameWidth = this.contents.measureTextWidth(_name || '');
      
      // 对话内容
      let _message = _item.message;
      if (_item.message.includes('\\N[1]')) {
        _message = TranslateUtils.getText(_item.message.replace(/\\N[1]/g, '$1'), $gameActors.actor(1).name());
      }
      this.drawTextEx(_message, rect.x + 145, rect.y - 12, 800, {
        fontFace: 'ChillRoundF',
        fontSize: 20,
        textColor: '#665258'
      });

      const _actorName = this.getActorName(_item.name);

      if (_name && _actorName) {
        this.contents.bltImg('ui/history_message/head_bg', undefined, {
          x: rect.x + 4, y: rect.y - 52, width: 128, height: 128
        });
      }

      if (_item.audio) {
        this.contents.bltImg('ui/history_message/btn_audio', undefined, {
          x: rect.x + 145 + _nameWidth + 10, y: rect.y - 50 + 2, width: 35, height: 36
        });
      }

      if (_actorName && _item.head) {
        this.contents.bltImgList(_item.head.map(i => `tachie/${_actorName}-portrait/${i}`), undefined, {
          x: rect.x + 10, y: rect.y - 45, width: 114, height: 114
        });
        // for (let i = 0; i < _item.head.length; i++) {
        //   if (_item.head[i]) {
        //     this.contents.bltImg(`tachie/kana/${_item.head[i]}`, undefined, {
        //       x: rect.x + 10, y: rect.y - 45, width: 114, height: 114
        //     });
        //   }
        // }
      }
      
      this.contents.fillRect(10, rect.y + 98, this.width - 20, 1, '#CDCDCD');
    }
  }
  window.Window_Haku_Log = Window_Haku_Log;

  
  // #region 存储数据相关

  /** 默认创建参数 */
  const defaultCreatedParams = {
    messages: [],
    prevVisible: false,
  };
  const _DataManager_createGameObjects = DataManager.createGameObjects;
  DataManager.createGameObjects = function () {
    _DataManager_createGameObjects.call(this);
    $historyMessage = defaultCreatedParams;
  };
  const _DataManager_makeSaveContents = DataManager.makeSaveContents;
  DataManager.makeSaveContents = function () {
    const contents = _DataManager_makeSaveContents.call(this);
    contents.$historyMessage = $historyMessage;
    return contents;
  };
  const _DataManager_extractSaveContents = DataManager.extractSaveContents;
  DataManager.extractSaveContents = function (contents) {
    _DataManager_extractSaveContents.call(this, contents);
    if (!contents.$historyMessage) return;
    $historyMessage = contents.$historyMessage;
  };

  // #endregion

  /**
   * 历史记录操作类
   */
  class Utils_History {
    /** 最大数据条数 */
    static get maxCount() {
      return 300;
    }
    /** 清空 */
    static clear() {
      $historyMessage.messages = [];
    }
    /** 新增历史记录 */
    static addMessageHistory({ name, spineName, message, head, audio }) {
      if ($historyMessage.messages.length > Utils_History.maxCount) {
        $historyMessage.messages.splice(Utils_History.maxCount, $historyMessage.messages.length - Utils_History.maxCount);
      }
      $historyMessage.messages.unshift({
        name, message, head, audio, spineName
      });
    };
  }
  window.Utils_History = Utils_History;

})();