//=============================================================================
// ** RPG Maker MZ - Hakubox_Config.js
//=============================================================================
// #region 脚本注释
/*:
 * @plugindesc 游戏额外配置插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】游戏额外配置插件。
 * 
 * 
 * @command playCV
 * @text 播放CV语音
 * @desc 播放CV语音
 * 
 * @arg actor
 * @text 角色名称
 * @desc 角色名称
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @option 路人 - npc
 * @value npc
 * @option 无 - none
 * @value none
 * @default kana
 * 
 * @arg cvName
 * @text CV文件名称
 * @desc CV文件名称
 * @type file
 * @dir audio/cv/
 * 
 * @arg cvVolume
 * @text CV音量大小
 * @desc CV音量大小
 * @type number
 * @default 100
 * 
 * 
 * @command stopCV
 * @text 停止播放CV语音
 * @desc 停止播放CV语音
 * 
 * 
 * @command stopBgs
 * @text 完全停止播放Bgs背景音
 * @desc 完全停止播放Bgs背景音
 * 
 * 
 * @command changeCVVolume
 * @text 调整当前CV音量
 * @desc 调整当前CV音量
 * 
 * @arg volume
 * @text 音量大小
 * @desc 音量大小
 * @type number
 * @min -100
 * @max 100
 * @default 100
 * 
 * 
 * @command changeBGMVolume
 * @text 调整当前BGM音量百分比
 * @desc 调整当前BGM音量百分比
 * 
 * @arg volume
 * @text 音量大小百分比
 * @desc 音量大小百分比
 * @type number
 * @min -1000
 * @max 1000
 * @default 100
 * 
 * @arg duration
 * @text 修改时长
 * @desc 修改时长，帧数
 * @type number
 * @min 0
 * @max 1000
 * @default 30
 * 
 * 
 */
// #endregion

(() => {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Config";

  // #region 音频部分

  AudioManager._cvBuffer = null;
  AudioManager._mainVolume = 100;
  AudioManager._cvVolume = 100;
  AudioManager._currentCv = null;

  // ———— 音频相关 ————
  Object.defineProperty(AudioManager, "mainVolume", {
    get: function () {
      return this._mainVolume;
    },
    set: function (value) {
      this._mainVolume = value;
      this.updateBgmParameters(this._currentBgm);
      this.updateBgsParameters(this._currentBgs);
      this.updateCvParameters(this._currentCv);
      this.updateMeParameters(this._currentMe);
    },
    configurable: true
  });
  Object.defineProperty(AudioManager, "bgmVolume", {
    get: function() {
      return Math.floor(this._bgmVolume * AudioManager.mainVolume / 100);
    },
    set: function(value) {
      this._bgmVolume = value;
      this.updateBgmParameters(this._currentBgm);
    },
    configurable: true
  });
  Object.defineProperty(AudioManager, "cvVolume", {
    get: function () {
      return Math.floor(this._cvVolume * AudioManager.mainVolume / 100);
    },
    set: function (value) {
      this._cvVolume = value;
      this.updateMeParameters(this._currentCv);
    },
    configurable: true
  });
  Object.defineProperty(AudioManager, "seVolume", {
    get: function() {
      return Math.floor(this._seVolume * AudioManager.mainVolume / 100);
    },
    set: function(value) {
      this._seVolume = value;
    },
    configurable: true
  });

  AudioManager.updateBgmParameters = function(bgm) {
    this.updateBufferParameters(this._bgmBuffer, this.bgmVolume, bgm);
  };
  AudioManager.updateBgsParameters = function(bgs) {
    this.updateBufferParameters(this._bgsBuffer, this.bgsVolume, bgs);
  };
  AudioManager.updateMeParameters = function(me) {
    this.updateBufferParameters(this._meBuffer, this.meVolume, me);
  };
  AudioManager.updateCvParameters = function (cv) {
    this.updateBufferParameters(this._cvBuffer, this.cvVolume, cv);
  };
  AudioManager.updateSeParameters = function(buffer, se) {
    this.updateBufferParameters(buffer, this.seVolume, se);
  };


  // ———— 配置相关 ————
  Object.defineProperty(ConfigManager, "mainVolume", {
    get: function() {
      return AudioManager._mainVolume;
    },
    set: function(value) {
      AudioManager.mainVolume = value;
    },
    configurable: true
  });
  Object.defineProperty(ConfigManager, "bgmVolume", {
    get: function() {
      return AudioManager._bgmVolume;
    },
    set: function(value) {
      AudioManager.bgmVolume = value;
    },
    configurable: true
  });
  Object.defineProperty(ConfigManager, "bgsVolume", {
    get: function() {
      return AudioManager._bgsVolume;
    },
    set: function(value) {
      AudioManager.bgsVolume = value;
    },
    configurable: true
  });
  Object.defineProperty(ConfigManager, "cvVolume", {
    get: function() {
      return AudioManager._cvVolume;
    },
    set: function(value) {
      AudioManager.cvVolume = value;
    },
    configurable: true
  });
  Object.defineProperty(ConfigManager, "seVolume", {
    get: function() {
      return AudioManager._seVolume;
    },
    set: function(value) {
      AudioManager.seVolume = value;
    },
    configurable: true
  });


  ConfigManager.makeData = function() {
    const config = {};
    config.alwaysDash = this.alwaysDash;
    config.commandRemember = this.commandRemember;
    config.touchUI = this.touchUI;
    config.mainVolume = this.mainVolume;
    config.bgmVolume = this.bgmVolume;
    config.bgsVolume = this.bgsVolume;
    config.cvVolume = this.cvVolume;
    config.meVolume = this.meVolume;
    config.seVolume = this.seVolume;
    return config;
  };
  ConfigManager.applyData = function(config) {
    this.alwaysDash = this.readFlag(config, "alwaysDash", false);
    this.commandRemember = this.readFlag(config, "commandRemember", false);
    this.touchUI = this.readFlag(config, "touchUI", true);
    
    this.mainVolume = this.readVolume(config, "mainVolume");
    this.bgmVolume = this.readVolume(config, "bgmVolume");
    this.bgsVolume = this.readVolume(config, "bgsVolume");
    this.cvVolume = this.readVolume(config, "cvVolume");
    this.meVolume = this.readVolume(config, "meVolume");
    this.seVolume = this.readVolume(config, "seVolume");
  };
  AudioManager.stopAll = function() {
    this.stopMe();
    this.stopBgm();
    this.stopBgs();
    this.stopCv();
    this.stopSe();
  };
  AudioManager.checkErrors = function() {
    const buffers = [this._bgmBuffer, this._bgsBuffer, this._meBuffer, this._cvBuffer];
    buffers.push(...this._seBuffers);
    buffers.push(...this._staticBuffers);
    for (const buffer of buffers) {
      if (buffer && buffer.isError()) {
        this.throwLoadError(buffer);
      }
    }
  };
  Scene_Base.prototype.fadeOutAll = function() {
    const time = this.slowFadeSpeed() / 60;
    AudioManager.fadeOutBgm(time);
    AudioManager.fadeOutBgs(time);
    AudioManager.fadeOutCv(time);
    AudioManager.fadeOutMe(time);
    this.startFadeOut(this.slowFadeSpeed());
  };

  Game_System.prototype.saveBgs = function() {
    this._savedBgs = AudioManager.saveBgs();
  };
  Game_System.prototype.replayBgs = function() {
    if (this._savedBgs) {
      AudioManager.replayBgs(this._savedBgs);
      this._savedBgs = null;
    }
  };

  AudioManager.playBgs = function(bgs, pos) {
    if (this.isCurrentBgs(bgs)) {
      this.updateBgsParameters(bgs);
    } else {
      this.stopBgs();
      if (bgs.name) {
        AudioManager._isFreezeBgs = false;
        this._bgsBuffer = this.createBuffer("bgs/", bgs.name);
        this.updateBgsParameters(bgs);
        this._bgsBuffer.play(true, pos || 0);
      }
    }
    this.updateCurrentBgs(bgs, pos);
  };

  AudioManager.playMe = function(me) {
    this.stopMe();
    if (me.name) {
      if (this.isCurrentMe(me)) {
        this.updateMeParameters(me);
      }
      this._meBuffer = this.createBuffer("me/", me.name);
      this.updateMeParameters(me);
      this._meBuffer.play(false);
      this._meBuffer.addStopListener(this.stopMe.bind(this));
    }
  };

  AudioManager.playCv = function (cv, config, callback) {
    let _cv = undefined;
    let _pos = 0;

    if (typeof cv === 'string') {
      _cv = { name: cv, volume: 100, pitch: 100, pan: 0 };
    } else if (typeof cv === 'object') {
      _cv = cv;
    }

    if (typeof config === 'number') {
      _pos = config;
    } else if (typeof config === 'object') {
      if (config.pos) {
        _pos = config.pos;
      }
      if (config.volume) {
        _cv.volume = config.volume;
      }
    }

    if (this.isCurrentCv(_cv)) {
      this.updateCvParameters(_cv);
    } else {
      this.stopCv();
      if (_cv.name) {
        if (this._bgsBuffer && this._currentBgs) {
          if ($gameSystem.saveBgs && this._bgsBuffer && this._bgsBuffer.isPlaying() && !this._isFreezeBgs) {
            $gameSystem.saveBgs();
            AudioManager.stopBgs();
          }
        }

        this._cvBuffer = this.createBuffer("cv/", _cv.name);
        this.updateCvParameters(_cv);
        this._cvBuffer.play(false, _pos || 0);
        this._cvBuffer.addStopListener(() => {
          if ($gameSystem.replayBgs && !this._isFreezeBgs) {
            $gameSystem.replayBgs();
          }
          if (callback) {
            callback.call(this._cvBuffer);
          }
          // this.stopCv.bind(this);
        });
        return this._cvBuffer;
      }
    }
    this.updateCurrentCv(cv, _pos);
  };
  AudioManager.fadeOutCv = function(duration) {
    if (this._cvBuffer) {
      this._cvBuffer.fadeOut(duration);
    }
  };
  AudioManager.updateCurrentCv = function (cv, pos) {
    this._currentCv = {
      name: cv.name,
      volume: cv.volume,
      pitch: cv.pitch,
      pan: cv.pan,
      pos: pos
    };
  };
  AudioManager.isCurrentMe = function (me) {
    return (
      this._currentMe &&
      this._meBuffer &&
      this._currentMe.name === me.name
    );
  };
  AudioManager.isCurrentCv = function (cv) {
    return (
      this._currentCv &&
      this._cvBuffer &&
      this._currentCv.name === cv.name
    );
  };

  AudioManager.fadeOutCv = function (duration) {
    if (this._cvBuffer) {
      this._cvBuffer.fadeOut(duration);
    }
  };

  AudioManager.stopCv = function () {
    if (this._cvBuffer) {
      this._cvBuffer.destroy();
      this._cvBuffer = null;
      if (
        this._cvBuffer &&
        this._currentCv &&
        !this._cvBuffer.isPlaying()
      ) {
        this._cvBuffer.play(true, this._currentCv.pos);
        this._cvBuffer.fadeIn(this._replayFadeTime);
      }
    }
  };

  /** 历史播放CV */
  AudioManager.historyCV = '';

  // #endregion


  // #region 配置窗口相关

  Scene_Options.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
    this.createBackground();
    this.createOptionsWindow();
  };

  Scene_Options.prototype.createButtons = function() {};

  Scene_Options.prototype.createBackground = function() {
    const _bitmap = ImageManager.loadPicture('ui/background');
    const _sprite = new Sprite(_bitmap);
    _sprite.x = 0;
    _sprite.y = 0;
    this.addChildAt(_sprite, 0);
  };
  
  Scene_Options.prototype.createOptionsWindow = function() {
    this._optionsWindow = new Window_Haku_Options();
    this._optionsWindow.setHandler("cancel", this.popScene.bind(this));
    this.addChild(this._optionsWindow);
    this._optionsWindow.x = 0;
    this._optionsWindow.y = 0;
    this._optionsWindow.show();
    this._optionsWindow.activate();
  };

  Scene_Options.prototype.createBackBtn = function() {
    const _bitmap = ImageManager.loadPicture('ui/title/btn_back');
    const _sprite = new Sprite(_bitmap);
    _sprite.x = 20;
    _sprite.y = 20;
  };

  /** 语言项 */
  const languageItems = [
    {
      label: '',
      checked: '/img/pictures/ui/config/language-btn/radio_ja_checked',
      unchecked: '/img/pictures/ui/config/language-btn/radio_ja_unchecked',
      checked_hover: '/img/pictures/ui/config/language-btn/radio_ja_checked_hover',
      unchecked_hover: '/img/pictures/ui/config/language-btn/radio_ja_unchecked_hover',
      value: 'ja-JP'
    },
    {
      label: '',
      checked: '/img/pictures/ui/config/language-btn/radio_en_checked',
      unchecked: '/img/pictures/ui/config/language-btn/radio_en_unchecked',
      checked_hover: '/img/pictures/ui/config/language-btn/radio_en_checked_hover',
      unchecked_hover: '/img/pictures/ui/config/language-btn/radio_en_unchecked_hover',
      value: 'en-US'
    },
    {
      label: '',
      checked: '/img/pictures/ui/config/language-btn/radio_tw_checked',
      unchecked: '/img/pictures/ui/config/language-btn/radio_tw_unchecked',
      checked_hover: '/img/pictures/ui/config/language-btn/radio_tw_checked_hover',
      unchecked_hover: '/img/pictures/ui/config/language-btn/radio_tw_unchecked_hover',
      value: 'zh-TW'
    },
    {
      label: '',
      checked: '/img/pictures/ui/config/language-btn/radio_zh_checked',
      unchecked: '/img/pictures/ui/config/language-btn/radio_zh_unchecked',
      checked_hover: '/img/pictures/ui/config/language-btn/radio_zh_checked_hover',
      unchecked_hover: '/img/pictures/ui/config/language-btn/radio_zh_unchecked_hover',
      value: 'zh-CN'
    },
    {
      label: '',
      checked: '/img/pictures/ui/config/language-btn/radio_ko_checked',
      unchecked: '/img/pictures/ui/config/language-btn/radio_ko_unchecked',
      checked_hover: '/img/pictures/ui/config/language-btn/radio_ko_checked_hover',
      unchecked_hover: '/img/pictures/ui/config/language-btn/radio_ko_unchecked_hover',
      value: 'ko-KR'
    },
  ];

  /** 配置窗口 */
  class Window_Haku_Options extends Window_Base {
    initialize() {
      this._handlers = {};
      super.initialize(new Rectangle(0, 0, Graphics.width, Graphics.height));
      this.opacity = 0;

      this.refresh();
      this.initComponents();
    }
    setHandler(symbol, method) {
      this._handlers[symbol] = method;
    }
    isHandled(symbol) {
      return !!this._handlers[symbol];
    }
    callHandler(symbol) {
      if (this.isHandled(symbol)) {
        this._handlers[symbol]();
      }
    }

    initComponents() {
      this._backgroundSprite = new Sprite(ImageManager.loadPicture('ui/background'));
      this.addChildAt(this._backgroundSprite, 0);
      
      this._panelSprite = new Sprite(ImageManager.loadPicture('ui/extras/background'));
      this._panelSprite.x = 0;
      this._panelSprite.y = 0;
      this.addChildAt(this._panelSprite, 1);
      
      this._titleSprite = new Sprite(ImageManager.loadPicture('ui/title_txt/config_title_zh-CN'));
      this._titleSprite.x = 110;
      this._titleSprite.y = 35;
      this.addChildAt(this._titleSprite, 2);


      const btn = new HakuComponent.Button({
        style: {
          backgroundImage: '/img/pictures/ui/common/btn_back'
        },
        'hover:style': {
          backgroundImage: '/img/pictures/ui/common/btn_back_active'
        },
        'tap:style': {
          backgroundImage: '/img/pictures/ui/common/btn_back_active'
        },
      });
      btn.width = 200;
      btn.height = 64;
      btn.x = 1090;
      btn.y = 20;
      btn.on('tap', () => {
        SoundManager.playCancel();
        SceneManager.pop();
      });
      this.addChild(btn);

      this.volumeSlider1 = this.createVolumeSlider(450, 158, (val) => {
        ConfigManager.mainVolume = val;
      });

      this.volumeSlider2 = this.createVolumeSlider(450, 202, (val) => {
        ConfigManager.bgmVolume = val;
      });

      this.volumeSlider3 = this.createVolumeSlider(450, 246, (val) => {
        ConfigManager.cvVolume = val;
        ConfigManager.meVolume = val;
      });

      this.volumeSlider4 = this.createVolumeSlider(450, 290, (val) => {
        ConfigManager.seVolume = val;
      });

      // this.femaleVoiceSelect = this.createRadioButtonGroup(300, 335, (val) => {
      //   ConfigManager.femaleVoice = val === 'on';
      //   console.log(val === 'on' ? '女主语音开' : '女主语音关');
      // }, [
      //   {
      //     label: '',
      //     checked: '/img/pictures/languages/zh-CN/ui/common/button_1_on_active',
      //     unchecked: '/img/pictures/languages/zh-CN/ui/common/button_1_on_normal',
      //     checked_hover: '/img/pictures/languages/zh-CN/ui/common/button_1_on_active_hover',
      //     unchecked_hover: '/img/pictures/languages/zh-CN/ui/common/button_1_on_normal_hover',
      //     value: 'on'
      //   }, {
      //     label: '',
      //     checked: '/img/pictures/languages/zh-CN/ui/common/button_1_off_active',
      //     unchecked: '/img/pictures/languages/zh-CN/ui/common/button_1_off_normal',
      //     checked_hover: '/img/pictures/languages/zh-CN/ui/common/button_1_off_active_hover',
      //     unchecked_hover: '/img/pictures/languages/zh-CN/ui/common/button_1_off_normal_hover',
      //     value: 'off'
      //   },
      // ]);

      this.languageSelect = this.createRadioButtonGroup(300, 455, (val) => {
        if (!val) return;
        ConfigManager.language = val;
        TranslateUtils.setLanguage(val);
        ConfigManager.save();
        this.refresh();
      }, languageItems);


      this.volumeSlider1.value = AudioManager._mainVolume;
      this.volumeSlider2.value = AudioManager._bgmVolume;
      this.volumeSlider3.value = AudioManager._meVolume;
      this.volumeSlider4.value = AudioManager._seVolume;
      this.languageSelect.value = ConfigManager.languageCode;
    }

    /** 创建音量拖拽条 */
    createVolumeSlider(x, y, onChange) {
      const slider = new HakuComponent.Silder({
        width: 720,
        height: 16,
        thumbImage: '/img/pictures/ui/config/slider/slider_rail',
        trackImage: '/img/pictures/ui/config/slider/slider_track',
        barImage: '/img/pictures/ui/config/slider/slider_handle',
        barImage_hover: '/img/pictures/ui/config/slider/slider_handle_hover',
        text: '',
        textWidth: 90,
        style: {
          fontColor: '#665258',
          fontSize: 26,
          textAlign: 'right',
          textX: 20
        },
      });
      slider.width = 720;
      slider.height = 16;
      slider.x = x;
      slider.y = y;
      slider.on('change', onChange);
      this.addChild(slider);

      return slider;
    }

    createRadioButtonGroup(x, y, onChange, items) {
      const radioButton = new HakuComponent.RadioButton({
        x, y, 
        padding: 20,
        itemPadding: [20, 40],
        maxCol: 4,
        itemWidth: 200,
        itemHeight: 57,
        items,
      });
      radioButton.x = x;
      radioButton.y = y;
      radioButton.on('change', onChange);
      this.addChild(radioButton);

      return radioButton;
    }

    refresh() {
      this.contents.clear();

      if (this._titleSprite) {
        this._titleSprite.bitmap = ImageManager.loadPicture('ui/title_txt/config_title_zh-CN');
      }
      
      if (this.bgSprite) {
        this.bgSprite.destroy();
      }
      const _bitmap = ImageManager.loadPicture('ui/config/page_zh-CN');
      this.bgSprite = new Sprite(_bitmap);
      this.bgSprite.x = 0;
      this.bgSprite.y = 0;
      this.addChild(this.bgSprite);
    };

    handle() {
      if (TouchInput.isCancelled() || Input.isPressed('cancel')) {
        SoundManager.playCancel();
        this.callHandler('cancel');
      }
    }

    update() {
      super.update();
      this.handle();
    }
  }

  // const ConfigManager_makeData = ConfigManager.makeData;
  // ConfigManager.makeData = function() {
  //   const config = ConfigManager_makeData.call(this);
  //   config.languageIndex = this.languageIndex;
  //   translateModule.setLanguage(this.languageIndex);
  //   return config;
  // };

  // const ConfigManager_applyData = ConfigManager.applyData;
  // ConfigManager.applyData = function(config) {
  //   ConfigManager_applyData.call(this, config);
  //   this.languageIndex = config.languageIndex || 0;
  //   translateModule.setLanguage(this.languageIndex);
  // };

  // #endregion

  

  // #region 存储数据相关

  const _DataManager_createGameObjects = DataManager.createGameObjects;
  DataManager.createGameObjects = function () {
    _DataManager_createGameObjects.call(this);
    $gameData = cloneLoop(window.__TEMP_GAME_DATA);
  };
  const _DataManager_makeSaveContents = DataManager.makeSaveContents;
  DataManager.makeSaveContents = function () {
    const contents = _DataManager_makeSaveContents.call(this);
    let _spines = [];
    if (SceneManager._scene.spine) {
      _spines.push(SceneManager._scene.spine);
    }
    // contents.screenShot = SceneManager._screenShotBase64;
    contents.$gameData = $gameData;
    return contents;
  };
  const _DataManager_extractSaveContents = DataManager.extractSaveContents;
  DataManager.extractSaveContents = function (contents) {
    _DataManager_extractSaveContents.call(this, contents);
    if (!contents.$gameData) return;
    $gameData = contents.$gameData;
  };

  // #endregion



  class Hakubox_Config {
    /**
     * 播放CV
     */
    static playCV(cv) {
      AudioManager.playCv({
        name: cv.cvName,
        volume: cv.cvVolume ? Number(cv.cvVolume) : AudioManager.cvVolume,
        pitch: 100,
        pan: 0,
      });
    }
    /**
     * 停止播放CV
     */
    static stopCV() {
      AudioManager.stopCv();
    }
    /**
     * 修改当前CV音量
     */
    static changeCVVolume(volume) {
      if (AudioManager._cvBuffer) {
        AudioManager._cvBuffer.volume += Number(volume);
      }
    }
    /**
     * 修改当前BGM音量百分比
     * @param {number} volume 调整后的音量百分比
     * @param {number} duration 调整时长
     */
    static changeBGMVolume(volume, duration) {
      if (!duration) {
        if (AudioManager._bgmBuffer) {
          AudioManager._bgmBuffer.volume = Number(AudioManager._bgmBuffer.volume * volume);
        }
      } else {
        const _newVolume = AudioManager.bgmVolume / 100 * volume;
        const _oldVolume = AudioManager._bgmBuffer.volume;

        useTimeout(() => {
          AudioManager._bgmBuffer.volume = _newVolume;
        }, duration, (progress, frameIndex) => {
          if (frameIndex % 5 === 0) {
            const _val = _oldVolume + (_newVolume - _oldVolume) * progress;
            AudioManager._bgmBuffer.volume = Number(_val.toFixed(2));
          }
        });
      }
    }
  }
  window.Hakubox_Config = Hakubox_Config;

  if (Utils.RPGMAKER_NAME === "MZ") {
    // 播放CV音频
    PluginManager.registerCommand(PluginName, 'playCV', function (args) {
      AudioManager.historyCV = args;
      Hakubox_Config.playCV(args);
    });
    // 修改当前CV音量
    PluginManager.registerCommand(PluginName, 'changeCVVolume', function (args) {
      Hakubox_Config.changeCVVolume(args.volume / 100);
    });
    // 停止CV音频
    PluginManager.registerCommand(PluginName, 'stopCV', function (args) {
      AudioManager.historyCV = '';
      Hakubox_Config.stopCV(args);
    });
    // 修改当前BGM音量
    PluginManager.registerCommand(PluginName, 'changeBGMVolume', function (args) {
      Hakubox_Config.changeBGMVolume(args.volume / 100, args.duration ? Number(args.duration) : 0);

      // console.timeEnd('changeBGMVolume');
      // console.time('changeBGMVolume');
      if (args.duration) {
        this.wait(args.duration);
      }
      return true;
    });

    // 完全停止播放Bgs
    PluginManager.registerCommand(PluginName, 'stopBgs', function (args) {
      AudioManager._isFreezeBgs = true;
      AudioManager.stopBgs();
    });

  }
})();