//=============================================================================
// ** RPG Maker MZ - Hakubox_Core.js
//=============================================================================
// #region 脚本注释
/*:
 * @plugindesc 白箱游戏核心插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * 
 * @command clearScene
 * @text 通关事件
 * @desc 通关事件
 * 
 * @arg sceneId
 * @desc 通关事件ID
 * @desc 通关事件ID
 * @type text
 * 
 */
(() => {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Core";
  
  window.randomId = function() {
    return (Math.random().toString(36) + Math.random().toString(36)).replace(/[^a-z]+/g, '').substring(0, 10);
  };

  Utils.isNwjs = function() {
    return window.nw && typeof require === "function" && typeof process === "object";
  };

  SceneManager.isGameScene = function(scene) {
    const _scene = scene || this._scene;
    if (typeof _scene === 'function') {
      return _scene.name === 'Scene_MainScene' || _scene.__proto__.name === 'Scene_MainScene' || 
             _scene.name === 'Scene_SceneThink' || _scene.__proto__.name === 'Scene_SceneThink';
    } else {
      return _scene instanceof Scene_MainScene || _scene instanceof Scene_SceneThink;
    }
  }

  SceneManager.isNotScene = function(scene) {
    return false;
  }

  ImageManager.loadBitmap = function(folder, filename) {
    let _folder = folder;
    if (_folder && _folder.startsWith("/")) {
      _folder = _folder.substring(1);
    }
    if (filename) {
      const url = _folder + Utils.encodeURI(filename) + ".png";
      return this.loadBitmapFromUrl(url);
    } else {
      return this._emptyBitmap;
    }
  };

  Game_Interpreter.prototype.executeCommand = function() {
    const command = this.currentCommand();
    if (command) {
      this._indent = command.indent;
      const methodName = "command" + command.code;
      if (typeof this[methodName] === "function") {
        if (!this[methodName](command.parameters)) {
          return false;
        }
      }
      if ($gameSystem._tempEventType) {
        if ($gameSystem._tempEventType === 'main') {
          $gameMap._interpreter._index = $gameSystem._tempEventIndex;
        } else if ($gameSystem._tempEventType === 'child') {
          $gameMap._interpreter._childInterpreter._index = $gameSystem._tempEventIndex;
        }
        $gameSystem._tempEventType = undefined;
        $gameSystem._tempEventIndex = undefined;
      } else {
        this._index++;
      }
    } else {
      this.terminate();
    }
    return true;
  };

  // #region 系统底层调整

  Scene_Map.prototype.create = function () {
    Scene_Message.prototype.create.call(this);
    this._transfer = $gamePlayer.isTransferring();
    if (this._transfer) {
      DataManager.loadMapData($gamePlayer.newMapId());
      this.onTransfer();
    } else {
      DataManager.loadMapData($gameMap.mapId());
    }
  }

  Game_Map.prototype.updateGame = function (sceneActive) {
    this.refreshIfNeeded();
    if (sceneActive) {
      this.updateInterpreter();
    }
    this.updateEvents();
  };

  // #endregion


  // #region 保存额外的信息
  
  DataManager._extraInfo = undefined;

  DataManager.loadExtraInfo = function() {
    return new Promise(resolve => {
      TranslateUtils.loadLocalTranslateFile(() => {
        resolve();
      });
    });
  };

  DataManager.loadLanguageInfo = function() {
    StorageManager.loadObject("extra").then(extraInfo => {
      this._extraInfo = extraInfo || DataManager.makeExtraInfo();
      return 0;
    }).catch(() => {
      this._extraInfo = DataManager.makeExtraInfo();
    });
  };

  DataManager.isLanguageInfoLoaded = function() {
    return Object.keys(TranslateUtils.keys || {}).length > 1;
  };
  

  DataManager.saveExtraInfo = function() {
    StorageManager.saveObject("extra", this._extraInfo);
  };

  DataManager.isExtraInfoLoaded = function() {
    return !!this._extraInfo;
  };

  DataManager.makeExtraInfo = function() {
    const info = {};
    info.clearSceneList = [];
    info.clearCourseList = [];
    // 是否解锁全部关卡
    info.isClearAll = false;
    return info;
  };

  // 解锁全部场景
  DataManager.isClearAllScene = function() {
    return this._extraInfo.isClearAll === true;
  };
  DataManager.clearAllScene = function() {
    this._extraInfo.isClearAll = true;
    DataManager.saveExtraInfo();
  };
  // 解锁某个场景
  DataManager.clearScene = function(sceneId) {
    if (!this._extraInfo.clearSceneList) this._extraInfo.clearSceneList = [];
    if (!this._extraInfo.clearSceneList.includes(sceneId)) {
      this._extraInfo.clearSceneList.push(sceneId);
    }
    DataManager.saveExtraInfo();
  };
  // 判断某个场景是否解锁
  DataManager.isClearScene = function(sceneId) {
    return this._extraInfo.isClearAll || this._extraInfo.clearSceneList.includes(sceneId);
  };
  // 判断是否通过教程
  DataManager.isClearCourse = function(courseId) {
    if (!this._extraInfo.clearCourseList) this._extraInfo.clearCourseList = [];
    return this._extraInfo.clearCourseList.includes(courseId);
  };
  // 解锁某个教程
  DataManager.clearCourse = function(courseId) {
    if (!this._extraInfo.clearCourseList) this._extraInfo.clearCourseList = [];
    if (!this._extraInfo.clearCourseList.includes(courseId)) {
      this._extraInfo.clearCourseList.push(courseId);
    }
    DataManager.saveExtraInfo();
  };
  // 删除某个教程（反向解锁）
  DataManager.removeCourse = function(courseId) {
    if (!this._extraInfo.clearCourseList) this._extraInfo.clearCourseList = [];
    const _index = this._extraInfo.clearCourseList.indexOf(courseId);
    if (_index >= 0) {
      this._extraInfo.clearCourseList.splice(_index, 1);
    }
    DataManager.saveExtraInfo();
  };

  Scene_Boot.prototype.updateDocumentTitle = function() {
    document.title = TranslateUtils.getText($dataSystem.gameTitle) + ' v' + gameVersion;
  };

  Scene_Boot.prototype.loadPlayerData = function() {
    $dataSystem.gameTitle = "与傲娇妹妹的治愈日常";
    DataManager.loadLanguageInfo();
    DataManager.loadGlobalInfo();
    DataManager.loadExtraInfo();
    ConfigManager.load();
  };

  Scene_Boot.prototype.isPlayerDataLoaded = function() {
    return DataManager.isGlobalInfoLoaded() && DataManager.isLanguageInfoLoaded() && DataManager.isExtraInfoLoaded() && ConfigManager.isLoaded();
  };


  // #endregion


  // #region 修改切换场景的功能，添加回调函数

  Game_System.prototype.hasTachie = function() {
    const _spine = SceneManager._scene.spine;
    if (!_spine) return false;
    else if (_spine.alpha == 0) return false;
    else if (!_spine.tachieInfo) return false;
    else return true;
  };
  Game_System.prototype.saveTachie = function(scene) {
    const _tachie = SceneManager._scene.spine;

    if (_tachie && _tachie.tachieInfo) {
      this._savedTachie = cloneLoop(_tachie.tachieInfo);
    }
    this._savedTachie.sceneName = scene.constructor.name;
  };
  // Game_System.prototype.resetTachie = function() {
  //   const _tachie = this._savedTachie;

  //   // 如果原先有存数据且当前场景没有显示立绘，则显示原先存的数据
  //   if (_tachie && SceneManager._scene.spine && !SceneManager._scene.spine.alpha) {
  //     Utils_Tachie.loadTachie.call(this, _tachie.spineName.replace('Tachie', ''), {
  //       location: _tachie.location,
  //       motion: _tachie.motion,
  //       skin: _tachie.skin,
  //       alpha: 1
  //     });
  //     this._savedTachie = null;
  //   } else if (_tachie && SceneManager._scene.spine && SceneManager._scene.spine.alpha) {
  //     SpineManager.changeSkin(SceneManager._scene.spine, _tachie.skin);
  //   }
  // };

  let scene_callback = undefined;
  SceneManager.onSceneStart = function() {
    Graphics.endLoading();
    Graphics.setStage(this._scene);
    if (scene_callback) {
      scene_callback.call(SceneManager._scene, SceneManager._scene);
      scene_callback = undefined;
    }
  };
  // 清空所有场景信息（用于返回标题页）
  SceneManager.clearSceneInfo = function() {
    if (SceneManager._scene._messageWindow) SceneManager._scene._messageWindow.terminateMessage();
    $gameMessage.clear();
    $gameData.isEventBusy = false;
    $gameMessage.isStopMessage = false;
    $gameSystem._savedBgm = null;
    $gameSystem._savedBgs = null;
    $gameMap._interpreter.clear();
    SceneManager.pop();
    AudioManager.stopAll();
  };
  SceneManager.add = function(scene, callback) {
    if (callback) scene_callback = callback;
    this._stack.push(this._scene.constructor);
    this.go(scene, callback);
  };
  const SceneManager_goto = SceneManager.goto;
  SceneManager.goto = function(scene) {
    if (!scene) {
      return;
    }

    if ($gameSystem) {
      // 判断当前场景不是游戏场景，上一个场景为游戏场景 且 当前正在播放BGM
      if (SceneManager.isGameScene() && !SceneManager.isGameScene(scene) && AudioManager._bgmBuffer) {
        if ($gameSystem.saveBgm) $gameSystem.saveBgm();
      } else if (!SceneManager.isGameScene() && $gameSystem._savedBgm) {
      } else {
        $gameSystem._savedBgm = null;
      }

      let _newSceneName = '';
      if (typeof scene === 'function') {
        _newSceneName = scene.name;
      } else {
        _newSceneName = scene;
      }

      if ($gameData.__loadSaveSuccess === undefined || $gameData.__loadSaveSuccess === true) {
        if (!SceneManager.isGameScene(scene) && SceneManager.isGameScene()) {
          SceneManager._scene.saveTempInfo();
        } else if (SceneManager.isGameScene(scene) && $gameData.tempSceneInfo.sceneName !== _newSceneName) {
          $gameData.tempSceneInfo = window.__createBlankTempSceneInfo();
          $gameData.tempSceneInfo.canUse = false;
          // $gameData.tempSceneInfo.gameSceneName = _scene.sceneInfo.name;
        } else if (SceneManager.isGameScene(scene) && !SceneManager.isGameScene() && $gameData.tempSceneInfo.sceneName === _newSceneName) {
          $gameData.tempSceneInfo.canUse = true;
        } else {
          $gameData.tempSceneInfo.canUse = false;
        }
      } else if ($gameData.__loadSaveSuccess === false) {
        $gameData.tempSceneInfo.canUse = true;
      }


      // 如果【没有数据】且【之前的场景是游戏场景】 且【新场景不是游戏场景】 且【之前的场景有立绘】，则保存立绘信息
      // if (!$gameSystem._savedTachie && SceneManager.isGameScene() && !SceneManager.isGameScene(scene) && $gameSystem.hasTachie()) {
      //   $gameSystem.saveTachie(scene);
      // }
      // 如果【有数据】且【新场景是游戏场景】 且【两边的名字对不上】 ，则清除立绘信息
      // if ($gameSystem._savedTachie && SceneManager.isGameScene(scene) && $gameSystem._savedTachie.sceneName !== scene.constructor.name) {
      //   $gameSystem._savedTachie = null;
      // }
    }

    SceneManager_goto.call(this, scene);
  };
  SceneManager.go = function(scene, callback) {
    if (!scene) {
      return;
    }

    if (callback) scene_callback = callback;
    SceneManager.goto.call(this, scene);
  };

  SceneManager.back = function(callback) {
    if (this._stack.length > 0) {
      this.go(this._stack.pop(), callback);
    } else {
      this.exit();
    }
  };
  // #endregion
  
  const Scene_Boot_loadGameFonts = Scene_Boot.prototype.loadGameFonts;
  Scene_Boot.prototype.loadGameFonts = function() {
    Scene_Boot_loadGameFonts.call(this);
    
    // 萝莉体
    FontManager.load('loli', 'loli.ttc');
    // 思源黑体VF
    FontManager.load('Source Han Sans VF', 'SourceHanSans-VF.otf');
    // 寒蝉全圆体
    FontManager.load('ChillRoundF', 'ChillRoundFRegular.ttf');
    // 汉仪粗圆简
    FontManager.load('HYCuYuanJ', 'HYCuYuanJ.ttf');
    // 小濑字体
    FontManager.load('Kose', 'Kosefont-JP.ttf');
  };
  
  Window_Base.prototype.resetFontSettings = function(config) {
    this.contents.fontFace = $gameSystem.mainFontFace();
    this.contents.fontSize = $gameSystem.mainFontSize();
    this.resetTextColor();
    if (config) {
      Object.entries(config).forEach(([key, value]) => {
        this.contents[key] = value;
      });
    }
  };

  
  Window_Base.prototype.flushTextState = function(textState, char) {
    const text = textState.buffer;
    const rtl = textState.rtl;
    const height = textState.height;
    const x = rtl ? textState.x - width : textState.x;
    const y = textState.y;

    if (char) {
      const width = this.textWidth(char);
      if (textState.drawing) {
        this.contents.drawText(char, x, y, width, height);
      }
      textState.x += rtl ? -width : width;
      if ((textState.x + this.padding * 2 + width >= textState.startX + textState.width) && textState.width && !(this instanceof Window_NameBox)) {
        textState.x = textState.startX;
        textState.y += this.calcTextHeight(textState);
      }
      textState.buffer = this.createTextBuffer(rtl);
      
      if (this instanceof Window_NameBox) {
        const _width = this.textWidth(textState.text);
        if (textState.width < _width) {
          textState.outputWidth = _width;
        }
      }
    } else {
      const width = this.textWidth(text);
      if (textState.drawing) {
        this.contents.drawText(text, x, y, width, height);
      }
      textState.x += rtl ? -width : width;
      textState.buffer = this.createTextBuffer(rtl);
      const outputWidth = Math.abs(textState.x - textState.startX);
      if (textState.outputWidth < outputWidth) {
        textState.outputWidth = outputWidth;
      }
      textState.outputHeight = y - textState.startY + height;
    }
  };
  Window_Base.prototype.processCharacter = function(textState) {
    const c = textState.text[textState.index++];
    if (c.charCodeAt(0) < 0x20) {
      this.flushTextState(textState);
      this.processControlCharacter(textState, c);
    } else {
      this.flushTextState(textState, c);
    }
  };
  Window_Base.prototype.createTextState = function(text, x, y, width) {
    if (!width) width = this.width;
    const rtl = Utils.containsArabic(text);
    const textState = {};
    textState.text = this.convertEscapeCharacters(text);
    textState.index = 0;
    textState.x = rtl ? x + width : x;
    textState.y = y;
    textState.width = width;
    textState.height = this.calcTextHeight(textState);
    textState.startX = textState.x;
    textState.startY = textState.y;
    textState.rtl = rtl;
    textState.buffer = this.createTextBuffer(rtl);
    textState.drawing = true;
    textState.outputWidth = 0;
    textState.outputHeight = 0;
    return textState;
  };
  Window_Base.prototype.drawTextEx = function(text, x, y, width, config) {
    this.resetFontSettings(config);
    const textState = this.createTextState(text, x, y, width);
    this.processAllText(textState);
    return textState.outputWidth;
  };

  // #region Sprite增加文本输出
  Sprite.prototype.lineHeight = function() {
    return 36;
  };
  Sprite.prototype.resetTextColor = function() {
    this.bitmap.textColor = ColorManager.normalColor();
    this.bitmap.outlineColor = ColorManager.outlineColor();
  };
  Sprite.prototype.maxFontSizeInLine = function(line) {
    let maxFontSize = this.bitmap.fontSize;
    const regExp = /\x1b({|}|FS)(\[(\d+)])?/gi;
    for (;;) {
        const array = regExp.exec(line);
        if (!array) {
            break;
        }
        const code = String(array[1]).toUpperCase();
        if (code === "{") {
            this.makeFontBigger();
        } else if (code === "}") {
            this.makeFontSmaller();
        } else if (code === "FS") {
            this.bitmap.fontSize = parseInt(array[3]);
        }
        if (this.bitmap.fontSize > maxFontSize) {
            maxFontSize = this.bitmap.fontSize;
        }
    }
    return maxFontSize;
  };
  Sprite.prototype.createTextBuffer = function(rtl) {
    // U+202B: RIGHT-TO-LEFT EMBEDDING
    return rtl ? "\u202B" : "";
  };
  Sprite.prototype.resetFontSettings = function() {
    this.bitmap.fontFace = $gameSystem.mainFontFace();
    this.bitmap.fontSize = $gameSystem.mainFontSize();
    this.resetTextColor();
  };
  Sprite.prototype.textWidth = function(text) {
    return this.bitmap.measureTextWidth(text);
  };
  Sprite.prototype.obtainEscapeCode = function(textState) {
    const regExp = /^[$.|^!><{}\\]|^[A-Z]+/i;
    const arr = regExp.exec(textState.text.slice(textState.index));
    if (arr) {
        textState.index += arr[0].length;
        return arr[0].toUpperCase();
    } else {
        return "";
    }
  };
  Sprite.prototype.processNewLine = function(textState) {
    textState.x = textState.startX;
    textState.y += textState.height;
    textState.height = this.calcTextHeight(textState);
  };
  Sprite.prototype.calcTextHeight = function(textState) {
    const lineSpacing = this.lineHeight() - $gameSystem.mainFontSize();
    const lastFontSize = this.bitmap.fontSize;
    const lines = textState.text.slice(textState.index).split("\n");
    const textHeight = this.maxFontSizeInLine(lines[0]) + lineSpacing;
    this.bitmap.fontSize = lastFontSize;
    return textHeight;
  };
  Sprite.prototype.makeFontBigger = function() {
    if (this.bitmap.fontSize <= 96) {
      this.bitmap.fontSize += 12;
    }
  };

  Sprite.prototype.makeFontSmaller = function() {
    if (this.bitmap.fontSize >= 24) {
      this.bitmap.fontSize -= 12;
    }
  };
  Sprite.prototype.processEscapeCharacter = function(code, textState) {
    switch (code) {
      case "C":
        this.processColorChange(this.obtainEscapeParam(textState));
        break;
      case "I":
        this.processDrawIcon(this.obtainEscapeParam(textState), textState);
        break;
      case "PX":
        textState.x = this.obtainEscapeParam(textState);
        break;
      case "PY":
        textState.y = this.obtainEscapeParam(textState);
        break;
      case "FS":
        this.bitmap.fontSize = this.obtainEscapeParam(textState);
        break;
      case "{":
        this.makeFontBigger();
        break;
      case "}":
        this.makeFontSmaller();
        break;
    }
  };
  Sprite.prototype.processControlCharacter = function(textState, c) {
    if (c === "\n") {
      this.processNewLine(textState);
    }
    if (c === "\x1b") {
      const code = this.obtainEscapeCode(textState);
      this.processEscapeCharacter(code, textState);
    }
  };
  Sprite.prototype.actorName = function(n) {
    const actor = n >= 1 ? $gameActors.actor(n) : null;
    return actor ? actor.name() : "";
  };
  Sprite.prototype.convertEscapeCharacters = function(text) {
    /* eslint no-control-regex: 0 */
    text = text.replace(/\\/g, "\x1b");
    text = text.replace(/\x1b\x1b/g, "\\");
    while (text.match(/\x1bV\[(\d+)\]/gi)) {
      text = text.replace(/\x1bV\[(\d+)\]/gi, (_, p1) =>
        $gameVariables.value(parseInt(p1))
      );
    }
    text = text.replace(/\x1bN\[(\d+)\]/gi, (_, p1) =>
      this.actorName(parseInt(p1))
    );
    text = text.replace(/\x1bP\[(\d+)\]/gi, (_, p1) =>
      this.partyMemberName(parseInt(p1))
    );
    text = text.replace(/\x1bG/gi, TextManager.currencyUnit);
    return text;
  };
  Sprite.prototype.createTextState = function(text, x, y, width) {
    const rtl = Utils.containsArabic(text);
    const textState = {};
    textState.text = this.convertEscapeCharacters(text);
    textState.index = 0;
    textState.x = rtl ? x + width : x;
    textState.y = y;
    textState.width = width;
    textState.height = this.calcTextHeight(textState);
    textState.startX = textState.x;
    textState.startY = textState.y;
    textState.rtl = rtl;
    textState.buffer = this.createTextBuffer(rtl);
    textState.drawing = true;
    textState.outputWidth = 0;
    textState.outputHeight = 0;
    return textState;
  };
  Sprite.prototype.flushTextState = function(textState, char) {
    const text = textState.buffer;
    const rtl = textState.rtl;
    const height = textState.height;
    const x = rtl ? textState.x - width : textState.x;
    const y = textState.y;

    if (char) {
      const width = this.textWidth(char);
      if (textState.drawing) {
        this.bitmap.drawText(char, x, y, width, height);
      }
      textState.x += rtl ? -width : width;
      if (textState.x >= textState.startX + textState.width) {
        textState.x = textState.startX;
        textState.y += this.calcTextHeight(textState);
      }
      textState.buffer = this.createTextBuffer(rtl);
    } else {
      const width = this.textWidth(text);
      if (textState.drawing) {
        this.bitmap.drawText(text, x, y, width, height);
      }
      textState.x += rtl ? -width : width;
      textState.buffer = this.createTextBuffer(rtl);
      const outputWidth = Math.abs(textState.x - textState.startX);
      if (textState.outputWidth < outputWidth) {
        textState.outputWidth = outputWidth;
      }
      textState.outputHeight = y - textState.startY + height;
    }
  };
  Sprite.prototype.processCharacter = function(textState) {
    const c = textState.text[textState.index++];
    if (c.charCodeAt(0) < 0x20) {
      this.flushTextState(textState);
      this.processControlCharacter(textState, c);
    } else {
      this.flushTextState(textState, c);
    }
  };
  Sprite.prototype.processAllText = function(textState) {
    while (textState.index < textState.text.length) {
      this.processCharacter(textState);
    }
    this.flushTextState(textState);
    return textState.outputWidth;
  };
  
  /**
   * 输入换行的文本
   * @param {string} text 文本内容
   * @param {number} x X坐标
   * @param {number} y Y坐标
   * @param {number} width 宽度
   */
  Sprite.prototype.drawTextEx = function(text, x, y, width) {
    // this.resetFontSettings();
    const textState = this.createTextState(text, x, y, width);
    this.processAllText(textState);
    return textState;
  };

  // #endregion
  
  // #region 画面变化
  const Game_Screen_update = Game_Screen.prototype.update;
  Game_Screen.prototype.update = function() {
    Game_Screen_update.call(this);

    if (this._gameTransformDuration > 0) {
      const d = this._gameTransformDuration;
      
      const t1 = this._bgScaleTarget;
      const r1 = Number(((this._bgScale * (d - 1) + t1) / d).toFixed(5));
      if (this._bgScale !== r1) {
        this._bgScale = r1;
      }

      const t2 = this._bgTransformXTarget;
      const r2 = Number(((this._bgTransformX * (d - 1) + t2) / d).toFixed(5));
      if (this._bgTransformX !== r2) {
        this._bgTransformX = r2;
      }

      const t3 = this._bgTransformYTarget;
      const r3 = Number(((this._bgTransformY * (d - 1) + t3) / d).toFixed(5));
      if (this._bgTransformY !== r3) {
        this._bgTransformY = r3;
      }
      
      this._gameTransformDuration--;
    }
  };

  const Game_Screen_clear = Game_Screen.prototype.clear;
  Game_Screen.prototype.clear = function() {
    Game_Screen_clear.call(this);

    this.clearGameTransform();
  };

  Game_Screen.prototype.startGameTransform = function(bgScale, bgTransformX, bgTransformY, duration = 30) {
    if (bgScale) this._bgScaleTarget = bgScale;
    if (bgTransformX !== undefined) this._bgTransformXTarget = -bgTransformX;
    if (bgTransformY !== undefined) this._bgTransformYTarget = -bgTransformY;
    this._gameTransformDuration = duration;
  };

  Game_Screen.prototype.clearGameTransform = function() {
    this._bgScale = 1;
    this._bgScaleTarget = 1;
    this._bgTransformX = 0;
    this._bgTransformXTarget = 0;
    this._bgTransformY = 0;
    this._bgTransformYTarget = 0;
  };

  Game_Screen.prototype.bgScale = function() {
    return this._bgScale;
  };
  Game_Screen.prototype.bgTransformX = function() {
    return this._bgTransformX;
  };
  Game_Screen.prototype.bgTransformY = function() {
    return this._bgTransformY;
  };
  // #endregion
  

  // #region HakuScroll
  /**
   * 标准滚动条
   */
  class HakuScroll extends PIXI.Container {
    constructor({
      x = 0, y = 0, me, disabled, bitmap, isSys, onChange, onUpdate,
      direction, barImage, progressImage, thumbImage, defaultValue, min, max, precision, padding
    } = {}) {
      super();
      
      this._min = min || 0;
      this._max = max || 100;
      this._precision = precision || 0;
      this._padding = padding || 10;
      /** 方向 @type {'vertical' | 'horizontal'} */
      this.direction = direction || "vertical";

      let _barImageUrl = barImage;
      if (!barImage) {
        if (this.direction === "vertical") {
          _barImageUrl = 'ui/common/scroll_vertical_bar';
        } else if (this.direction === "horizontal") {
          _barImageUrl = 'ui/common/scroll_horizontal_bar';
        }
      }
      this.barImage = ImageManager.loadPicture(_barImageUrl);

      let _thumbImageUrl = thumbImage;
      if (!_thumbImageUrl) {
        if (this.direction === "vertical") {
          _thumbImageUrl = 'ui/common/scroll_vertical_thumb';
        } else if (this.direction === "horizontal") {
          _thumbImageUrl = 'ui/common/scroll_horizontal_thumb';
        }
      }
      this.thumbImage = ImageManager.loadPicture(_thumbImageUrl);

      if (progressImage) {
        this.progressImage = ImageManager.loadPicture(progressImage);
      }

      if (x) this.x = x;
      if (y) this.y = y;

      this.__cid = randomId();
      this.__isSys = isSys || false;

      this._onUpdate = onUpdate;
      this._onChange = onChange;

      this._disabled = disabled;
      this._me = me;

      this._scene = SceneManager._scene;

      this._scrollLoc = 0;

      // 常规背景
      if (bitmap) {
        if (bitmap instanceof Bitmap) {
          this.addChild(new Sprite(bitmap));
        } else if (typeof bitmap === "string") {
          ImageManager.loadImgCb(bitmap, (image) => {
            this.addChild(new Sprite(image));
          });
        }
      }

      this._onMouseDown = this.onMouseDown.bind(this);
      this._onMouseUp = this.onMouseUp.bind(this);
      this._onMouseMove = this.onMouseMove.bind(this);
      
      // 绑定事件
      document.addEventListener('mousedown', this._onMouseDown);
      document.addEventListener('mouseup', this._onMouseUp);
      document.addEventListener('mousemove', this._onMouseMove);

      // 创建拖拽条
      this.thumbSprite = new Sprite(this.thumbImage);
      this.addChild(this.thumbSprite);

      if (this.direction === "vertical") {
        this.thumbSprite.x = 0;
        this.thumbSprite.y = this.padding;
      } else if (this.direction === "horizontal") {
        this.thumbSprite.x = this.padding;
        this.thumbSprite.y = 0;
      }
        
      if (progressImage) {
        this.progressSprite = new Sprite();
        if (this.direction === "vertical") {
          this.progressSprite.x = 0;
          this.progressSprite.y = this.padding;
        } else if (this.direction === "horizontal") {
          this.progressSprite.x = this.padding;
          this.progressSprite.y = 0;
        }
        this.addChild(this.progressSprite);
      }

      this.barSprite = new Sprite(this.barImage);
      this.addChild(this.barSprite);
      
      Promise.all([
        ImageManager.loadImg(_thumbImageUrl),
        ImageManager.loadImg(_barImageUrl)
      ]).then(([thumbImage, barImage]) => {
        if (this.direction === "vertical") {
          this.contentWidth = thumbImage.height;
          this.contentHeight = thumbImage.width;
          this.thumbSprite.x = (this.width - thumbImage.width) / 2;
          this._scrollBarWidth = barImage.height;
          
          if (progressImage) {
            this.progressSprite.x = (this.width - thumbImage.width) / 2;
          }
        } else if (this.direction === "horizontal") {
          this.contentWidth = thumbImage.width;
          this.contentHeight = thumbImage.height;
          this.thumbSprite.y = (this.height - thumbImage.height) / 2;
          this._scrollBarWidth = barImage.width;
          
          if (progressImage) {
            this.progressSprite.y = (this.height - thumbImage.height) / 2;
          }
        }

        this.progressSprite.bitmap = new Bitmap(thumbImage.width, thumbImage.height);
      
        this.value = defaultValue || 0;
        setTimeout(() => {
          this.updateThumbPosition();
        }, 10);
      });
    }

    get min() {
      return this._min;
    }
    get max() {
      return this._max;
    }
    get value() {
      return this._value;
    }
    set value(value) {
      let _val = value;
      if (_val < this.min) {
        _val = this.min;
      } else if (_val > this.max) {
        _val = this.max;
      }
      this._value = _val;
      this.onChange(_val);
      this.updateThumbPosition();
    }
    get padding() {
      return this._padding;
    }
    /** 是否只读 @type {boolean} */
    get readonly() {
      if (!this._readonly) return false;
      return this._readonly.call(this._me || this);
    }
    /** 是否禁用 @type {boolean} */
    get disabled() {
      if (!this._disabled) return false;
      return this._disabled.call(this._me || this);
    }
    get me() {
      return this._me || this;
    }
    get scene() {
      return this._scene;
    }
    get progressImgIsReady() {
      if (this.progressSprite && this.progressSprite.bitmap && this.progressImage.isReady()) {
        return true;
      } else {
        return false;
      }
    }
    /** 刷新回调 */
    onUpdate() {
      if (this._onUpdate) {
        this._onUpdate();
      }
    }
    /** 滚动回调 */
    onChange(val) {
      if (this._onChange) {
        this._onChange(val);
      }
    }

    destroy() {
      super.destroy();
      document.removeEventListener('mousedown', this._onMouseDown);
      document.removeEventListener('mouseup', this._onMouseUp);
      document.removeEventListener('mousemove', this._onMouseMove);
    }

    onMouseDown(e) {
      if (this.disabled || this.readonly) return;

      let _x = this.worldTransform.tx;
      let _y = this.worldTransform.ty;

      if (e.button && e.button !== 0) return;

      if (e.x >= _x && e.x <= _x + this.width) {
        if (this.direction === "vertical") {
          if (e.y >= _y + this._scrollLoc && e.y <= _y + this._scrollLoc + this._scrollBarWidth) {
            this.isStartDragScroll = true;
            this.startDragVal = e.y - _y - this._scrollLoc - this.padding;
            this.prevDragVal = this._scrollLoc;
          } else if (e.y >= _y && e.y <= _y + this.contentWidth) {
            this.isStartDragScroll = false;
            this.setScroll(e.y - _y - this._scrollBarWidth / 2);
          }
        } else if (this.direction === "horizontal") {
          if (e.x >= _x + this._scrollLoc && e.x <= _x + this._scrollLoc + this._scrollBarWidth) {
            this.isStartDragScroll = true;
            this.startDragVal = e.x - _x - this._scrollLoc - this.padding;
            this.prevDragVal = this._scrollLoc;
          } else if (e.x >= _x && e.x <= _x + this.contentWidth) {
            this.isStartDragScroll = true;
            this.startDragVal = this._scrollBarWidth / 2;
            this.prevDragVal = this._scrollLoc;
            this.setScroll(e.x - _x - this._scrollBarWidth / 2);
          }
        }
      }
    }
    onMouseUp(e) {
      if (this.isStartDragScroll) {
        this.isStartDragScroll = false;
        this.handleHover(false, true);
      }
    }
    onMouseMove(e) {
      if (this.isStartDragScroll) {
        if (!this.worldTransform) return;

        let moveVal = 0;
        if (this.direction === "vertical") {
          let _y = this.worldTransform.ty;
          moveVal = e.y - _y - this.prevDragVal - this.startDragVal;
        } else if (this.direction === "horizontal") {
          let _x = this.worldTransform.tx;
          moveVal = e.x - _x - this.prevDragVal - this.startDragVal;
        }
        this.setScroll(this.prevDragVal + moveVal);
      }
    }
    /** 设置滚动位置 */
    setScroll(scrollTop) {
      this._scrollLoc = scrollTop;
      if (scrollTop < 0) {
        this._scrollLoc = 0;
      } else if (scrollTop > this.contentWidth - this._scrollBarWidth + this.padding * 2) {
        this._scrollLoc = this.contentWidth - this._scrollBarWidth + this.padding * 2;
      }

      const _progress = this._scrollLoc / (this.contentWidth - this._scrollBarWidth + this.padding * 2);
      const _val = Number((_progress * this.max + this.min).toFixed(this._precision));
      const _oldVal = this._value;
      this._value = _val;
      if (_val !== _oldVal) {
        this.onChange(_val);
        this.updateThumbPosition();
      }
    }

    /** 更新滚动条的位置 */
    updateThumbPosition() {
      if (this.direction === "vertical") {
        this.barSprite.y = ((this._value - this.min) / this.max) * (this.contentWidth - this._scrollBarWidth + this.padding * 2);
          if (this.progressImgIsReady) {
            this.progressSprite.bitmap.clear();
            this.progressSprite.bitmap.blt(this.progressImage, 
              0, 0, this.contentHeight, this.barSprite.y + this.padding / 2,
              0, 0, this.contentHeight, this.barSprite.y + this.padding / 2,
            );
          }
      } else if (this.direction === "horizontal") {
        this.barSprite.x = ((this._value - this.min) / this.max) * (this.contentWidth - this._scrollBarWidth + this.padding * 2);
        if (this.progressImgIsReady) {
          this.progressSprite.bitmap.clear();
          this.progressSprite.bitmap.blt(this.progressImage, 
            0, 0, this.barSprite.x + this.padding / 2, this.contentHeight,
            0, 0, this.barSprite.x + this.padding / 2, this.contentHeight,
          );
        }
      }
    }

    /** 鼠标点击 */
    handleTap(disabled) {
      if (!this.onTap) return;

      if (disabled) {
        SoundManager.playBuzzer();
      } else {
        SoundManager.playOk();
        this.onTap();
      }
    }

    /** 鼠标悬停 */
    handleHover(inArea, isDisabled) {
      if (inArea) {
        if (this.scene._tempHoverElementId) {
          return;
        }
        this.scene._tempHoverElementId = this.__cid;

        if (this.scene.hoverElementId !== this.__cid) {
          if (this.scene.hoverElement && this.scene.hoverElement.onBlur) {
            this.scene.hoverElement.onBlur();
          }
          this.scene.hoverElementId = this.__cid;
          this.scene.hoverElement = this;
          
          if (isDisabled === true) {
            Utils_Cursor.cursorType = 'disabled';
          } else {
            SoundManager.playCursor();
            Utils_Cursor.cursorType = 'pointer';
          }
        } else {
          if (isDisabled === true) {
            if (Utils_Cursor.cursorType != 'disabled') {
              Utils_Cursor.cursorType = 'disabled';
            }
          } else if (isDisabled === false) {
            if (Utils_Cursor.cursorType != 'pointer') {
              Utils_Cursor.cursorType = 'pointer';
            }
          }
        }
      } else if (!this.scene._tempHoverElementId) {
        if (this.scene.hoverElementId === this.__cid) {
          Utils_Cursor.cursorType = 'default';
          this.scene.hoverElementId = '';
        }
      }
    }

    /** 更新方法 */
    update() {
      this.onUpdate();

      if (!this.__isSys) {
        if ($gameData.isEventBusy || this.scene._isBusy || $gameMap.isEventRunning()) return;
      }
      
      if (!this.parent || !this.parent.visible || !this.visible || this.alpha <= 0 || this.scene.visibleDialog) return;

      if (!this.worldTransform || this.readonly) return;

      let _x = this.worldTransform.tx;
      let _y = this.worldTransform.ty;
      
      const _disabled = this.disabled;

      const _inArea = TouchInput.x >= _x && TouchInput.x <= _x + this.width && TouchInput.y >= _y && TouchInput.y <= _y + this.height;

      if (_inArea) {
        if (TouchInput.isTriggered()) {
          this.handleTap(_disabled);
        } else {
          this.handleHover(true, _disabled);
        }
      } else if (!this.isStartDragScroll) {
        this.handleHover(false, _disabled);
      }
    }
  }
  window.HakuScroll = HakuScroll;
  // #endregion
  

  // #region HakuContainer
  /**
   * 标准游戏容器
   */
  class HakuContainer extends PIXI.Container {
    constructor({ x = 0, y = 0, width, height, useHover = false, me, zIndex = 0, disabled, readonly, alpha, bitmap, isSys,
      update, onHover, onForceHover, onBlur, onTap
    } = {
      useHover: false, zIndex: 0
    }) {
      super();

      if (x) this.x = x;
      if (y) this.y = y;
      if (width) this._cWidth = width;
      if (height) this._cHeight = height;

      this._useHover = useHover || false;
      this.__cid = randomId();
      this.zIndex = zIndex || 0;
      this.__isSys = isSys || false;
      this.alpha = alpha || 1;

      this._update = update || (() => {});
      this._onHover = onHover || (() => {});
      this._onForceHover = onForceHover;
      this._onBlur = onBlur || (() => {});
      this._onTap = onTap;

      this._disabled = disabled;
      this._readonly = readonly;
      this._me = me;

      this._scene = SceneManager._scene;

      if (bitmap) {
        if (bitmap instanceof Bitmap) {
          this.addChild(new Sprite(bitmap));
        } else if (typeof bitmap === "string") {
          ImageManager.loadImgCb(bitmap, (image) => {
            this.addChild(new Sprite(image));
          });
        }
      }
    }

    get cWidth() {
      return this._cWidth || this.width;
    }
    get cHeight() {
      return this._cHeight || this.height;
    }

    readonly() {
      if (!this._readonly) return false;
      return this._readonly.call(this._me || this);
    }
    get disabled() {
      if (!this._disabled) return false;
      return this._disabled.call(this._me || this);
    }

    get me() {
      return this._me || this;
    }

    get onUpdate() {
      return this._update;
    }

    /** 鼠标移入回调 */
    get onHover() {
      return this._onHover;
    }
    set onHover(value) {
      this._onHover = value;
    }
    get onForceHover() {
      return this._onForceHover;
    }
    set onForceHover(value) {
      this._onForceHover = value;
    }
    /** 鼠标移出回调 */
    get onBlur() {
      return this._onBlur;
    }
    set onBlur(value) {
      this._onBlur = value;
    }
    /** 鼠标点击回调 */
    get onTap() {
      return this._onTap;
    }
    set onTap(value) {
      this._onTap = value;
    }

    /** 使用鼠标悬停 */
    get useHover() {
      return this._useHover;
    }
    set useHover(value) {
      this._useHover = value;
    }

    get scene() {
      return this._scene;
    }

    /** 鼠标悬停 */
    handleHover(inArea, isDisabled) {
      if (inArea) {
        if (this.scene._tempHoverElementId) {
          return;
        }
        this.scene._tempHoverElementId = this.__cid;

        if (this.scene.hoverElementId !== this.__cid) {
          if (this.scene.hoverElement && this.scene.hoverElement.onBlur) {
            this.scene.hoverElement.onBlur();
          }
          this.scene.hoverElementId = this.__cid;
          this.scene.hoverElement = this;
          
          if (this.onForceHover) {
            this.onForceHover();
          } else if (isDisabled === true) {
            Utils_Cursor.cursorType = 'disabled';
          } else {
            SoundManager.playCursor();
            this.onHover();
            Utils_Cursor.cursorType = 'pointer';
          }
        } else {
          if (isDisabled === true) {
            if (Utils_Cursor.cursorType != 'disabled') {
              Utils_Cursor.cursorType = 'disabled';
            }
          } else if (isDisabled === false) {
            if (Utils_Cursor.cursorType != 'pointer') {
              Utils_Cursor.cursorType = 'pointer';
            }
          }
        }
      } else if (!this.scene._tempHoverElementId) {
        if (this.scene.hoverElementId === this.__cid) {
          Utils_Cursor.cursorType = 'default';
          this.scene.hoverElementId = '';
          if (isDisabled !== true) {
            this.onBlur();
          }
        }
      }
    }

    /** 鼠标点击 */
    handleTap(disabled) {
      if (!this.onTap) return;

      if (disabled) {
        SoundManager.playBuzzer();
      } else {
        SoundManager.playOk();
        this.onTap();
      }
    }

    /** 更新方法 */
    update() {

      let _isCheck = true;
      if (!this.__isSys) {
        if ($gameData.isEventBusy || this.scene._isBusy || $gameMap.isEventRunning()) _isCheck = false;
      }
      
      if (!this.parent || !this.worldVisible || this.alpha <= 0 || this.scene.visibleDialog) _isCheck = false;

      if (_isCheck) {
        let _isSkip = false;

        if (!this.worldTransform || (this.readonly && this.readonly() === true)) _isSkip = true;

        let _x = this.worldTransform.tx;
        let _y = this.worldTransform.ty;
        
        const _disabled = this.disabled;

        if (this.useHover && !_isSkip) {

          const _inArea = TouchInput.x >= _x && TouchInput.x <= _x + this.cWidth && TouchInput.y >= _y && TouchInput.y <= _y + this.cHeight;

          if (_inArea) {
            if (TouchInput.isTriggered()) {
              this.handleTap(_disabled);
            } else {
              this.handleHover(true, _disabled);
            }
          } else {
            this.handleHover(false, _disabled);
          }
        }
      }

      this.onUpdate();

      this.updateChildren();
    }

    updateChildren() {
      for (let i = 0; i < this.children.length; i++) {
        const child = this.children[i];
        if (child.update && child.alpha > 0) child.update();
      }
    }
  }
  window.HakuContainer = HakuContainer;
  // #endregion

  // #region HakuSprite
  /**
   * 标准游戏精灵图
   */
  class HakuSprite extends Sprite {
    initialize({ 
      x = 0, y = 0, width, height, me, useHover = false, zIndex = 0, disabled, readonly, isSys, 
      normalBitmap, hoverBitmap, tapBitmap, disabledBitmap, onHover, onBlur, onTap, onDisabledTap
    }) {
      this._me = me;

      super.initialize();

      this.setImg(normalBitmap);

      this._useHover = useHover || false;
      this.__cid = randomId();
      this.zIndex = zIndex || 0;
      this.__isSys = isSys || false;

      this._onHover = onHover || (() => {});
      this._onBlur = onBlur || (() => {});
      this._onDisabledTap = onDisabledTap || (() => {});
      this._onTap = onTap || (() => {});

      this._normalBitmap = normalBitmap;
      this._hoverBitmap = hoverBitmap;
      this._tapBitmap = tapBitmap;
      this._disabledBitmap = disabledBitmap;

      this._disabled = disabled;
      this._readonly = readonly;

      this._scene = SceneManager._scene;

      if (x) this.x = x;
      if (y) this.y = y;
      if (width) this._cWidth = width;
      if (height) this._cHeight = height;
    }

    get cWidth() {
      return this._cWidth || this.width;
    }
    get cHeight() {
      return this._cHeight || this.height;
    }

    get normalBitmap() {
      if (typeof this._normalBitmap === 'function') {
        return this._normalBitmap.call(this);
      } else {
        return this._normalBitmap;
      }
    }

    get disabledBitmap() {
      if (typeof this._disabledBitmap === 'function') {
        return this._disabledBitmap.call(this);
      } else {
        return this._disabledBitmap;
      }
    }

    /** 设置图片 */
    setImg(bitmap) {
      if (!bitmap) return;
      if (bitmap instanceof Bitmap) {
        this.bitmap = bitmap;
      } else if (typeof bitmap === "function") {
        this.bitmap = bitmap.call(this);
      } else if (typeof bitmap === "string") {
        this.bitmap = ImageManager.loadPicture(bitmap);
      }
    }

    readonly() {
      if (!this._readonly) return false;
      return this._readonly.call(this._me || this);
    }
    disabled() {
      if (!this._disabled) return false;
      return this._disabled.call(this._me || this);
    }

    get me() {
      return this._me || this;
    }

    /** 鼠标移入回调 */
    get onHover() {
      return this._onHover;
    }
    set onHover(value) {
      this._onHover = value;
    }
    /** 鼠标移出回调 */
    get onBlur() {
      return this._onBlur;
    }
    set onBlur(value) {
      this._onBlur = value;
    }
    /** 鼠标点击回调 */
    get onTap() {
      return this._onTap;
    }
    set onTap(value) {
      this._onTap = value;
    }
    /** 鼠标点击禁用回调 */
    get onDisabledTap() {
      return this._onDisabledTap;
    }
    set onDisabledTap(value) {
      this._onDisabledTap = value;
    }

    /** 使用鼠标悬停 */
    get useHover() {
      return this._useHover;
    }
    set useHover(value) {
      this._useHover = value;
    }

    get scene() {
      return this._scene;
    }

    /** 鼠标悬停 */
    handleHover(inArea, isDisabled) {
      if (inArea) {
        if (this.scene._tempHoverElementId) {
          return;
        }
        this.scene._tempHoverElementId = this.__cid;

        if (this.scene.hoverElementId !== this.__cid) {
          if (this.scene.hoverElement) {
            const _prevEl = this.scene.hoverElement;
            if (_prevEl.setImg) {
              if (_prevEl.disabled() === true) {
                _prevEl.setImg(_prevEl.disabledBitmap);
              } else {
                _prevEl.setImg(_prevEl.normalBitmap);
              }
            }
            if (_prevEl.onBlur) _prevEl.onBlur();
          }
          this.scene.hoverElementId = this.__cid;
          this.scene.hoverElement = this;

          if (isDisabled === true) {
            this.setImg(this.disabledBitmap);
            Utils_Cursor.cursorType = 'disabled';
          } else {
            SoundManager.playCursor();
            this.onHover();
            this.setImg(this._hoverBitmap);
            Utils_Cursor.cursorType = 'pointer';
          }
        } else {
          if (isDisabled === true) {
            if (Utils_Cursor.cursorType != 'disabled') {
              Utils_Cursor.cursorType = 'disabled';
            }
          } else if (isDisabled === false) {
            if (Utils_Cursor.cursorType != 'pointer') {
              Utils_Cursor.cursorType = 'pointer';
            }
          }
        }
      } else if (!this.scene._tempHoverElementId) {
        if (this.scene.hoverElementId === this.__cid) {
          Utils_Cursor.cursorType = 'default';
          this.scene.hoverElementId = '';
          if (isDisabled === true) {
            this.setImg(this.disabledBitmap);
          } else {
            this.setImg(this.normalBitmap);
          }
        } 
        // else {
        //   if (isDisabled === true) {
        //     this.setImg(this.disabledBitmap);
        //   } else {
        //     this.setImg(this.normalBitmap);
        //   }
        // }
      }
    }

    /** 鼠标点击 */
    handleTap(disabled) {
      if (disabled === true) {
        SoundManager.playBuzzer();
        this.onDisabledTap();
      } else {
        SoundManager.playOk();
        this.onTap();
      }
    }

    /** 刷新背景图 */
    refresh() {
      const _disabled = this.disabled();

      if (_disabled === true) {
        this.setImg(this.disabledBitmap);
      } else {
        this.setImg(this.normalBitmap);
      }
    }

    /** 更新方法 */
    update() {
      super.update();

      if (!this.__isSys) {
        if ($gameData.isEventBusy || this.scene._isBusy || $gameMap.isEventRunning()) return;
      }
      
      if (!this.parent || !this.worldVisible || !this.useHover || !this.visible || this.alpha <= 0 || this.scene.visibleDialog) return;

      if (this.readonly && this.readonly() === true) return;

      const _disabled = this.disabled();

      if (_disabled === true) {
        this.setImg(this.disabledBitmap);
      }

      let _x = this.worldTransform.tx;
      let _y = this.worldTransform.ty;

      const _inArea = TouchInput.x >= _x && TouchInput.x <= _x + this.cWidth && TouchInput.y >= _y && TouchInput.y <= _y + this.cHeight;

      if (_inArea) {
        if (TouchInput.isTriggered()) {
          this.handleTap(_disabled);
        } else {
          this.handleHover(true, _disabled);
        }
      } else {
        this.handleHover(false, _disabled);
      }
    }
  }
  window.HakuSprite = HakuSprite;
  // #endregion

  /**
   * Spine动画容器
   */
  class SpineContainer extends PIXI.Container {
    /**
     * 更新方法
     */
    update() {
      const children = this.children;
      for (let i = 0, length = children.length; i < length; i++) {
        const spine = children[i];
        if (spine === void 0) continue;
        if (spine.update) spine.update();
      }
    }
  }
  window.SpineContainer = SpineContainer;


  const Scene_Title_initialize = Scene_Title.prototype.initialize;
  Scene_Title.prototype.initialize = function() {
    Scene_Title_initialize.call(this);
    
    Utils_Tachie.initGameData();
  };

  const moduleTicker = {
    _tickers: [],
    on(callback) {
      for (let i = 0; i < this._tickers.length; i++) {
        if (this._tickers[i] === undefined) {
          this._tickers[i] = callback;
          return;
        }
      }
      this._tickers.push(callback);
    },
    off(callback) {
      const _index = this._tickers.indexOf(callback);
      if (_index >= 0) {
        this._tickers.splice(_index, 1);
      }
    },
    update() {
      for (let i = 0; i < this._tickers.length; i++) {
        if (this._tickers[i]) this._tickers[i]();
      }
    },
  };
  window.moduleTicker = moduleTicker;

  const Scene_Base_update = Scene_Base.prototype.update;
  Scene_Base.prototype.update = function() {
    Scene_Base_update.call(this);
    // 调用模块更新
    window.moduleTicker.update();
  };

  // 切换场景
  Scene_Base.prototype.changeRMScene = function(newScene, { fade = 60 }, callback) {
    if (!(Scene_Base.prototype.isPrototypeOf(newScene.prototype))) throw new Error('scene is not a RM Scene');

    if (fade) {
      this.setBrightness(0, fade, () => {
        $gameScreen._brightness = 0;    // 设置黑屏
        SceneManager.add(newScene, () => {
          SceneManager._scene._overallColorFilter.setBrightness(0);
          callback && callback();
        });
        this.setBrightness(255, fade);    // 渐入
      });
    } else {
      SceneManager.add(newScene, callback);
    }
  };

  // #region 增加公共事件回调
  // 调整公共事件，增加事件回调
  const _Game_Temp_initialize = Game_Temp.prototype.initialize;
  Game_Temp.prototype.initialize = function() {
    _Game_Temp_initialize.call(this);
    this._commonEventCallbacks = {};
  };

  Game_Interpreter.prototype.setupReservedCommonEvent = function() {
    if ($gameTemp.isCommonEventReserved()) {
      const commonEvent = $gameTemp.retrieveCommonEvent();
      if (commonEvent) {
        if (commonEvent.isEvent) {
          this._commonEventId = commonEvent.id;
        }
        this.setup(commonEvent.list);
        return true;
      }
    }
    return false;
  };

  // Game_Temp.prototype.retrieveCommonEvent = function() {
  //   const _last = this._commonEventQueue.shift();
  //   if (typeof _last === "number") {
  //     return $dataCommonEvents[_last];
  //   } else
  // };

  Game_Interpreter.prototype.setup = function(list, eventId, callback) {
    this.clear();
    this._mapId = $gameMap.mapId();
    this._eventId = eventId || randomId() || 0;
    this._list = list;
    if (callback) {
      this._commonEventId = this._eventId;
      $gameTemp._commonEventCallbacks[this._eventId] = callback;
    }
    this.loadImages();
  };

  // 预约公共事件时添加回调
  Game_Temp.prototype.execCommonEvent = function(commonEventId, callback) {
    this.reserveCommonEvent(commonEventId);
    // this._eventId = commonEventId || randomId() || 0;
    this._commonEventId = commonEventId;
    this._commonEventCallbacks[commonEventId] = callback;
  };

  // 预约公共事件时添加回调
  // Game_Temp.prototype.execCommonEvent = function(eventList, callback) {
  //   const commonEventId = randomId();
  //   this.reserveCustomEvent({ id: commonEventId, list: eventList });
  //   this._commonEventQueue
  //   this._commonEventCallbacks[commonEventId] = callback;
  // };

  // 在解释器完成时触发回调
  const _Game_Interpreter_terminate = Game_Interpreter.prototype.terminate;
  Game_Interpreter.prototype.terminate = function() {
    // 检查是否有回调需要执行
    if (this._commonEventId && $gameTemp._commonEventCallbacks[this._commonEventId]) {
      const callback = $gameTemp._commonEventCallbacks[this._commonEventId];
      delete $gameTemp._commonEventCallbacks[this._commonEventId];
      callback();
    }
    _Game_Interpreter_terminate.call(this);
  };
  // #endregion


  if (Utils.RPGMAKER_NAME === "MZ") {
    PluginManager.registerCommand(PluginName, 'startGameTransform', function(args) {
      $gameScreen.startGameTransform(
        args.bgScale ? (Number(args.bgScale) / 100) : undefined, 
        args.bgTransformX ? Number(args.bgTransformX) : undefined, 
        args.bgTransformY ? Number(args.bgTransformY) : undefined, 
        args.duration ? Number(args.duration) : undefined
      );
    });
    PluginManager.registerCommand(PluginName, 'clearScene', function(args) {
      if (!DataManager.isClearScene(args.sceneId)) {
        DataManager.clearScene(args.sceneId);
      }
    });
    
  }
})();