/**
 * 冒险数据：森林
 */
const adventure_data = [
  {
    title: '无人涉足的森林',
    mapId: 1,
    bgm: 'BGM_forest',
    background: 'adventure/bg/01_4',
    platformBackground: 'adventure/card_bg/01_g',
    tachieBackground: 'adventure/card_bg/01',
    cardBackground: 'adventure/card_bg/01_s',
    enterCell: [0, 5, 10],
    enterPrepareCommonEvent: 10,   // 进入准备事件（用于初始化进入开关）
    enterEnterSwitch: 11,          // 进入的开关ID
    enterEvent: 'a1',              // 进入的事件ID，开关为true则可以进入
    levelPrepareCommonEvent: 10,   // 离开准备事件（用于初始化离开开关）
    levelEnterSwitch: 12,          // 离开的开关ID
    levelEvent: 'leave-map',       // 离开的事件（必须要出来的开关打开）
    // 格子类
    cellData: {
      events: {
        1: {
          eventId: 1,
          name: '完成任务',
          enableSwitch: 14,
          execCommonEvent: 14
        }
      },
      items: [ // 物品列表
        { itemId: 1, name: '体力药剂', live: [8, 10, 12], img: 'card_monster_1' },
      ],
      monsters: [ // 怪物列表
        { monsterId: 1, name: '恶犬', live: [-8, -10, -12], img: 'card_monster_1' },
        { monsterId: 2, name: '怪物', live: [-15], img: 'card_monster_2' },
      ],
      trap: [ // 陷阱列表
        { trapId: 1 },
      ],
      floor: [ // 楼梯列表
        {
          floorId: 1,
          name: '离开',
          goto: -1,
          commonEvent: 15,
          gotoSwitch: 16,
          img: 'card_floor_1'
        }, {
          floorId: 1,
          name: '上楼',
          goto: [1, 10, 10],
          commonEvent: 15,
          gotoSwitch: 16,
          img: 'card_floor_1'
        }
      ]
    },
    /**
     * 事件列表（a:主线剧情、b:支线剧情、c:特殊事件）
     * @type { { id: string, desc?: string, commonEventId?: number, execute: (scene, callback) => void, repeatType: 'always'|'once'|'map'|'floor' }[] }
     */
    events: [
      // 主线剧情
      { id: 'leave-map', desc: '离开森林剧情', commonEventId: 316 },
      { id: 'a1', desc: '进入森林剧情', commonEventId: 314, repeatType: 'once' },
      { id: 'a2', desc: '进入森林二层', commonEventId: 317, repeatType: 'once' },
      { id: 'a3', desc: '进入森林三层', commonEventId: 319, repeatType: 'once' },

      // 支线剧情

      // 特殊剧情
      { id: 'c0', desc: '第一次碰到野猪', repeatType: 'once', execute(scene, callback) {
        Utils_Tachie.startAction('rumble', scene.tachieContainer, {
          duration: 50,
          loop: 1,
          power: 12,
          frequency: 1
        });
        $gameTemp.execCommonEvent(318, callback);
      } },
      { id: 'c1', desc: '落水', repeatType: 'once', execute(scene, callback) {
        Utils_Tachie.startAction('rumble', scene.tachieContainer, {
          duration: 50,
          loop: 1,
          power: 12,
          frequency: 1
        });
        scene.addState('wet', 10);
        $gameTemp.execCommonEvent(320, callback);
      } },
      { id: 'c2', desc: '受伤', repeatType: 'once', execute(scene, callback) {
        Utils_Tachie.startAction('rumble', scene.tachieContainer, {
          duration: 50,
          loop: 1,
          power: 12,
          frequency: 1
        });
        scene.addState('wound', 10);
        $gameTemp.execCommonEvent(321, callback);
      } },
    ],
    /**
     * 卡片列表
     * @type { { id: number, name: string, type: string, desc: string, repeatType: 'always'|'once'|'map'|'floor' }[] }
     */
    cells: [
      // 空白区域 Empty
      { id: '00', type: 'empty', desc: '空白区域' },
      // 障碍物 Block
      { id: 'B1', type: 'block', name: 'tree01', img: 'adventure/card_item/hinder_01', maskImg: 'adventure/card_item/hinder_01_mask' },
      { id: 'B2', type: 'block', name: 'tree02', img: 'adventure/card_item/hinder_02', maskImg: 'adventure/card_item/hinder_02_mask' },
      { id: 'B3', type: 'block', name: 'stone01', img: 'adventure/card_item/b3', maskImg: 'adventure/card_item/b3_mask' },
      // 怪物 Monster
      { id: 'M1', type: 'monster', title: '野猪', repeatType: 'map', img: 'adventure/card_item/m1', img_l: 'adventure/card_item/m1_l' },
      { id: 'M2', type: 'monster', title: '蜜蜂', repeatType: 'map', img: 'adventure/card_item/m2', img_l: 'adventure/card_item/m2_l' },
      // 物品 Item
      { id: 'I1', type: 'item', repeatType: 'once', desc: '饭团', img: 'adventure/card_item/item_01', itemId: 1 },
      { id: 'I2', type: 'item', repeatType: 'once', desc: '蜂蜜', img: 'adventure/card_item/item_01', itemId: 35 },
      // 移动 move
      { id: 'F0', type: 'move', title: '离开森林', img: 'adventure/card_item/move_02', moveTo: 'leave-map' },
      {
        id: 'F1', type: 'move',
        title(levelIndex) { return levelIndex <= 0 ? '下一层' : '上一层'; }, desc: '到第一层',
        img(levelIndex) { return `adventure/card_item/move_${levelIndex <= 0 ? '01' : '02'}` }, moveTo: [0,1,0]
      }, {
        id: 'F2', type: 'move', title(levelIndex) { return levelIndex <= 1 ? '下一层' : '上一层'; }, desc: '到第二层',
        img(levelIndex) { return `adventure/card_item/move_${levelIndex <= 1 ? '01' : '02'}` }, moveTo: [0,2,1], event: 'a2'
      }, {
        id: 'F3', type: 'move', title(levelIndex) { return levelIndex <= 2 ? '下一层' : '上一层'; }, desc: '到第三层',
        img(levelIndex) { return `adventure/card_item/move_${levelIndex <= 2 ? '01' : '02'}` }, moveTo: [0,2,2], event: 'a3'
      }, {
        id: 'F4', type: 'move', title(levelIndex) { return levelIndex <= 3 ? '下一层' : '上一层'; }, desc: '到第四层',
        img(levelIndex) { return `adventure/card_item/move_${levelIndex <= 3 ? '01' : '02'}` }, moveTo: [0,2,3]
      }, {
        id: 'F5', type: 'move', title(levelIndex) { return levelIndex <= 4 ? '下一层' : '上一层'; }, desc: '到第五层',
        img(levelIndex) { return `adventure/card_item/move_${levelIndex <= 4 ? '01' : '02'}` }, moveTo: [0,2,4]
      },
      // 陷阱 Trap
      { id: 'T1', type: 'trap', title: '水坑', img: 'adventure/card_item/08', floorId: 1, event: 'c1' },
      { id: 'T2', type: 'trap', title: '陷阱', img: 'adventure/card_item/09', floorId: 1, event: 'c2' },
      // 事件 Event
      { id: 'E1', type: 'event', repeatType: 'once', title: '野猪', img: 'adventure/card_item/m1', event: 'c0' },
      { id: 'E2', type: 'event', repeatType: 'once', title: '大石块', img: 'adventure/card_item/e2' },
      { id: 'E3', type: 'event', repeatType: 'once', title: '发光的鹿', img: 'adventure/card_item/e3' },
      // H事件 H-Event
      { id: 'H1', type: 'event', repeatType: 'once', title: '一起休息', img: 'adventure/card_item/h1' },
    ],
    levels: [
      {
        title: '无人涉足的森林 - 1层',
        bgImg: 'bg_floor1',
        fgImg: 'fg_floor1',
        colCount: 3,
        map: [
          [ 'B1', '00', 'B1' ],
          [ 'B1', '00', 'B1' ],
          [ 'B1', 'E1', 'B1' ],
          [ 'B1', '00', 'B1' ],
          [ '00', 'B2', '00' ],
          [ 'M2', '00', 'I1' ],
          [ 'B1', '00', 'B1' ],
          [ 'T1', 'B2', '00' ],
          [ 'B1', '00', 'M1' ],
          [ '00', 'F2', '00' ],
          [ 'B1', '00', 'B1' ],
          [ '00', 'F0', '00' ],
        ],
        hideMap: [
          [ 0, 0, 0 ],
          [ 0, 0, 0 ],
          [ 0, 0, 0 ],
          [ 0, 0, 0 ],
          [ 0, 0, 0 ],
          [ 1, 0, 0 ],
          [ 0, 0, 0 ],
          [ 0, 0, 0 ], 
          [ 0, 0, 1 ],
          [ 0, 0, 0 ],
          [ 0, 0, 0 ],
          [ 0, 0, 0 ],
        ]
      }, {
        title: '无人涉足的森林 - 2层',
        bgImg: 'bg_floor1',
        fgImg: 'fg_floor1',
        colCount: 5,
        map: [
          [ 'B1', '00', '00', '00', 'B1' ],
          [ 'B1', '00', 'B1', '00', 'B1' ],
          [ 'B1', 'I1', 'B1', '00', 'B1' ],
          [ 'B1', '00', 'B1', 'T1', 'B1' ],
          [ 'B1', '00', 'B1', '00', 'B1' ],
          [ '00', 'B1', 'M1', '00', 'B1' ],
          [ 'T1', '00', '00', 'T1', 'T1' ],
          [ 'B1', '00', 'M1', '00', 'B1' ],
          [ '00', 'I1', '00', '00', 'B1' ],
          [ 'B1', '00', '00', '00', 'B1' ],
          [ 'B1', '00', '00', '00', 'B1' ],
          [ '00', 'B1', '00', '00', 'B1' ],
          [ 'M1', '00', '00', 'F3', 'B1' ],
          [ 'B1', '00', '00', '00', 'B1' ],
          [ 'B1', 'F1', '00', '00', '00' ],
        ],
        hideMap: [
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 1, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 1, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 1, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
        ]
      }, {
        title: '无人涉足的森林 - 3层',
        bgImg: 'bg_floor1',
        fgImg: 'fg_floor1',
        colCount: 5,
        map: [
          [ '00', 'B1', '00', '00', 'I1' ],
          [ 'T1', '00', 'T2', 'M2', '00' ],
          [ '00', 'B1', '00', 'E2', 'T1' ],
          [ 'B1', '00', 'E1', 'M1', '00' ],
          [ 'T2', 'M2', '00', '00', 'B2' ],
          [ 'B1', '00', 'M1', 'T1', 'T2' ],
          [ '00', 'T1', 'I1', '00', 'B1' ],
          [ '00', 'M1', '00', 'E1', '00' ],
          [ 'T2', 'B1', 'T1', 'B1', '00' ],
          [ '00', 'M2', '00', 'E2', 'T2' ],
          [ 'M1', '00', 'M1', 'T1', 'M2' ],
          [ '00', 'B1', '00', 'B1', '00' ],
          [ 'T2', 'T1', 'E1', '00', 'F2' ],
          [ 'B1', '00', '00', '00', 'E1' ], // F4
        ],
        hideMap: [
          [ 1, 0, 1, 1, 0 ],
          [ 1, 1, 1, 1, 0 ],
          [ 0, 0, 1, 1, 1 ],
          [ 0, 1, 0, 1, 1 ],
          [ 1, 1, 1, 1, 0 ],
          [ 0, 1, 1, 0, 1 ],
          [ 1, 1, 1, 1, 0 ],
          [ 1, 1, 1, 0, 1 ],
          [ 1, 0, 1, 0, 1 ],
          [ 1, 1, 1, 1, 1 ],
          [ 1, 1, 1, 1, 1 ],
          [ 0, 0, 1, 0, 1 ],
          [ 0, 1, 1, 1, 0 ],
          [ 0, 1, 1, 1, 1 ],
        ]
      }, {
        title: '无人涉足的森林 - 4层',
        bgImg: 'bg_floor1',
        fgImg: 'fg_floor1',
        colCount: 5,
        map: [
          [ '00', '00', '00', '00', '00' ],
          [ '00', 'M1', '00', 'I1', 'B1' ],
          [ 'B1', '00', 'T1', 'B1', '00' ],
          [ '00', 'M2', 'B1', '00', 'T1' ],
          [ 'I1', 'B1', 'I1', 'M1', '00' ],
          [ 'B1', '00', 'B2', '00', 'B1' ],
          [ '00', 'B1', '00', 'M1', '00' ],
          [ '00', 'M1', 'B1', 'I1', '00' ],
          [ '00', 'M2', '00', 'B1', '00' ],
          [ 'M1', '00', 'I1', '00', 'B1' ],
          [ '00', '00', '00', 'B1', '00' ],
          [ '00', 'M1', 'B1', '00', 'T1' ],
          [ 'I1', 'B1', 'F5', '00', '00' ],
          [ 'B1', '00', '00', '00', 'M1' ],
          [ '00', 'B1', 'M1', '00', '00' ],
          [ 'T1', '00', 'B1', 'I1', 'T1' ],
          [ 'B1', '00', 'I1', 'B1', '00' ],
          [ 'B1', '00', 'F0', '00', 'B1' ],
        ],
        hideMap: [
          [ 0, 0, 0, 1, 0 ],
          [ 0, 0, 1, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 1, 0, 0, 0 ],
          [ 1, 0, 0, 1, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 1, 0, 0, 0 ],
          [ 0, 1, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 1, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 1, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
        ]
      }, {
        title: '无人涉足的森林 - 5层',
        bgImg: 'bg_floor1',
        fgImg: 'fg_floor1',
        colCount: 5,
        map: [
          [ '00', 'B2', '00', '00', '00'],
          [ '00', 'M1', '00', 'I1', 'B1'],
          [ 'B1', '00', 'T1', 'B1', '00'],
          [ '00', 'M1', 'B1', '00', 'M1'],
          [ 'I1', 'B1', 'I1', 'I1', '00'],
          [ 'B1', '00', 'B2', '00', 'B1'],
          [ '00', 'B1', '00', 'M1', '00'],
          [ '00', 'M1', 'B1', 'I1', 'M2'],
          [ '00', 'M2', '00', 'B1', '00'],
          [ 'M1', '00', 'I1', '00', 'B1'],
          [ '00', 'B1', '00', 'B1', '00'],
          [ '00', 'M1', 'B1', '00', 'M2'],
          [ 'I1', 'B1', 'F4', 'M1', '00'],
          [ 'B1', '00', 'I1', '00', 'M1'],
          [ '00', 'B1', 'M1', 'I1', '00'],
          [ '00', '00', 'B1', '00', 'T1'],
          [ 'B1', '00', 'M1', 'B1', '00'],
          [ 'B1', 'I1', 'M1', '00', 'B1'], 
          [ '00', 'T1', '00', 'B1', '00'],
          [ 'M1', '00', 'B1', '00', '00'],
          [ '00', 'B1', '00', '00', 'B1'],
          [ 'B1', '00', 'F0', '00', '00'],
        ],
        hideMap: [
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 1, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 1 ],
          [ 0, 1, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 1 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
          [ 0, 0, 0, 0, 0 ],
        ]
      }
    ]
  }
];

window.adventure_data = adventure_data;