//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 游戏缓存数据插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MV MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】数据缓存插件。
 * 
 * 该插件用于缓存游戏数据，包括游戏核心、是否全部解锁、已发生事件、好感度数据等。
 * 
 * 
 * @command addChatCount
 * @text 增加聊天次数
 * @desc 增加聊天次数
 * 
 * @arg actor
 * @text 目标角色
 * @type select
 * @option 加奈（加奈/カナ）
 * @value kana
 * @option 千夏（千夏/ちなつ）
 * @value chinatsu
 * @option 由纪（由紀/ゆき）
 * @value yuki
 * @option 艾露（エーレ）
 * @value ere
 * 
 * 
 */
// #endregion


/** 创建空的临时数据 */
window.__createBlankTempSceneInfo = () => {
  return {
    /** 是否已初始化 */
    isInit: false,
    /** 是否可使用 */
    canUse: false,
    /** 场景名称 */
    sceneName: undefined,
    /** 背景 */
    background: undefined,
    /** 前景 */
    foreground: undefined,
    /** 背景音乐 */
    bgmName: undefined,
    /** 背景音乐播放位置 */
    bgmPosition: undefined,
    /** 背景音乐 */
    bgsName: undefined,
    /** 背景音乐播放位置 */
    bgsPosition: undefined,

    /** 动画信息表 */
    spineInfos: {},
    /** 动画列表（当前画面中的） */
    spineList: [],

    /** Spine动画名称 */
    spineName: undefined,
    /** Spine动画皮肤 */
    spineSkin: undefined,

    /** 妹妹在房间里的状态（在房间处理） */
    sisterLoc: undefined,
    /** 是否显示妹妹的立绘（在房间处理） */
    visibleSisterTachie: undefined,
  };
};

window.__TEMP_GAME_DATA = {
  /** 游戏核心 */
  gameCore: {
    /** 是否已初始化 */
    isInit: false,
  },
  /** 临时背景 */
  tempBackground: '',
  /** 临时前景 */
  tempForeground: '',
  /** 是否全部解锁 */
  isAllUnlocked: false,
  /** 是否有事件正在执行 */
  isEventBusy: false,
  /** 自动播放时间 */
  autoPlayTime: 0,
  /** 自动播放时间延迟（速度） */
  autoPlayTimeDelay: 10,
  /** 已发生事件 */
  triggerEventList: {},
  /** 成就 */
  achievements: [],
  /** 想法 */
  thought: {
    /** 角色 - 加奈 */
    kana: {
      /** 当前想法 */
      currentThoughtId: 0,
      /** 触发时间 */
      execTime: 0,
      /** 持续时间 */
      duration: 0,
      /** 优先级 */
      priority: 0,
    }
  },
  /** 好感度数据 */
  favors: {

  },
  /** 今天的数据 */
  todayData: {
    /** 是否已清除 */
    isSaved: false,
    /** 加奈交互信息 */
    kanaInteract: {},
    /** 加奈相关数据 */
    kanaData: {
      /** 聊天次数 */
      chatCount: 0,
    },
    /** 千夏相关数据 */
    chinatsuData: {
      /** 聊天次数 */
      chatCount: 0
    },
    /** 由纪相关数据 */
    yukiData: {
      /** 聊天次数 */
      chatCount: 0
    },
    /** 艾露相关数据 */
    ereData: {
      /** 聊天次数 */
      chatCount: 0
    },
    /** 是否使用了安眠药 */
    useSleepPill: false,
    /** 是否喝过茶了（饮料） */
    useTea: false,
    /** 是否送过礼物给加奈了 */
    useGiftToKana: false,
    /** 是否送过礼物给加奈了 */
    useGiftToChinatsu: false,
    /** 是否送过礼物给加奈了 */
    useGiftToYuki: false,
    /** 是否送过礼物给艾露了 */
    useGiftToEre: false,
    /** 加奈已经吃过晚餐了 */
    haveDinner: false,
  },
  /** 汇总数据 */
  totalData: {
    /** 加奈特殊心情日期 */
    kanaMoodDay: 0,
    /** 加奈交互信息 */
    kanaInteract: {

    },
    /** 加奈相关数据 */
    kanaData: {
      /** 聊天次数 */
      chatCount: 0,
      /** 嘴部经验 */
      mouthCount: 0,
      /** 胸部经验 */
      chestCount: 0,
      /** 小穴经验 */
      pussyCount: 0,
      /** 臀部经验 */
      assCount: 0,
    },
    /** 千夏相关数据 */
    chinatsuData: {
      /** 聊天次数 */
      chatCount: 0
    },
    /** 由纪相关数据 */
    yukiData: {
      /** 聊天次数 */
      chatCount: 0
    },
  },
  /** 商店库存 */
  repertories: {
    /** 千夏 - 百货商店库存 */
    chinatsu: {
      1: 3, 2: 3, 3: 3, 7: 3, 14: 1, 15: 1
    },
    /** 由纪 - 神秘商店库存 */
    yuki: {
      20: 1
    },
    /** 艾露 - 服装店库存 */
    ere: {
      22: 1,
    }
  },
  /** 使用过的道具，用于判断是否第一次使用 */
  usedItems: [],
  /** 日记列表 */
  diaryList: [
    { contents: ['a_1', 'a_2'], day: 1, stateList: [] },
    { contents: ['a_3', 'a_4'], day: 3, stateList: [] },
    { contents: ['a_5', 'a_5'], day: 5, stateList: [] },
  ],
  /** 临时场景信息 */
  tempSceneInfo: window.__createBlankTempSceneInfo(),
  /** 冒险相关信息 */
  adventureInfo: {
    /** 已经使用过的卡片 */
    useCells: {},
    /** 已经调用过的事件 */
    useEvents: {},
  },
  /** 任务相关信息 */
  questModule: {
    questList: [
      { questId: "1", state: "inprogress" }
    ],
  },
};
window.$gameData = cloneLoop(window.__TEMP_GAME_DATA);

(() => {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_GameData";


  class Utils_GameData {
    /** 清空当天的数据 */
    static clearTodayData(obj = {}) {
      $gameData.todayData = {
        kanaInteract: {},
        chinatsuData: {},
        yukiData: {},
        ...obj,
      };
    }
    /**
     * 增加聊天次数
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} actor 角色名称
     */
    static addChatCount(actor) {
      // 增加临时次数
      const _actorTodayData = $gameData.todayData[actor + 'Data'];
      if (!_actorTodayData.chatCount) _actorTodayData.chatCount = 0;
      _actorTodayData.chatCount++;

      // 增加统计次数
      const _actorTotalData = $gameData.totalData[actor + 'Data'];
      if (!_actorTotalData.chatCount) _actorTotalData.chatCount = 0;
      _actorTotalData.chatCount++;
    }
    /**
     * 判断是否达到聊天次数上限
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} actor 角色名称
     * @param {number} [maxCount=3] 最大次数
     */
    static isChatLimit(actor, maxCount = 3) {
      let _actorData = $gameData.todayData[actor + 'Data'];
      if (!_actorData) {
        $gameData.todayData[actor + 'Data'] = { chatCount: 0 };
        _actorData = $gameData.todayData[actor + 'Data'];
      }
      if (!_actorData.chatCount) return false;

      return _actorData.chatCount >= maxCount;
    }
  }
  window.Utils_GameData = Utils_GameData;

  if (Utils.RPGMAKER_NAME === "MZ") {
    PluginManager.registerCommand(PluginName, 'addChatCount', args => {
      const _actor = Number(args.actor);
      Utils_Favor.addFavor(_actor);
    });
  }
})();