//=============================================================================
// ** RPG Maker MZ - Hakubox_MessageBox.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制文本对话框插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制文本对话框插件。
 * 
 */
// #endregion

(function () {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_MessageBox";

  const typeDefine = {
  };
  // #endregion

  // #region 插件参数

  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);

  // 移除alt键加速
  Input.keyMapper[18] = 'alt';

  /** 往前查询合适的事件索引 */
  const getPrevIndex = function(interpreter) {
    const _index = interpreter._index;
    const _list = interpreter._list;

    let _prevIndex = _index;

    const _checkItem = function(item) {
      if ([401, 402, 408, 657].includes(item.code)) return true;
      else if ([102, 103, 104].includes(item.code)) {
        if (_list[_prevIndex - 1] && (_list[_prevIndex - 1].code === 101 || _list[_prevIndex - 1].code === 401)) {
          return true;
        }
      }
      return false;
    };

    while (_list[_prevIndex] && _prevIndex > 0 && _checkItem(_list[_prevIndex])) {
      _prevIndex--;
    }

    return _prevIndex;
  };

  /** 消息按钮列表 */
  const __messageButtons = [
    {
      name: "自动",
      imageNormal: "ui/talk/talk_btn_auto_default",
      imageActive: "ui/talk/talk_btn_auto_active",
      get visible() { return true },
      isActive() {
        return this.isAutoPlay;
      },
      onTap() {
        this.isAutoPlay = !this.isAutoPlay;
      }
    }, {
      name: "快进",
      imageNormal: "ui/talk/talk_btn_skip_default",
      imageActive: "ui/talk/talk_btn_skip_active",
      get visible() { return true },
      isActive() {
        return this.isSkip;
      },
      onTap() {
        this.isSkip = !this.isSkip;
      }
    },
    {
      name: "保存",
      imageNormal: "ui/talk/talk_btn_save_default",
      imageActive: "ui/talk/talk_btn_save_active",
      get visible() { return !(SceneManager._scene instanceof Scene_SceneThink) && !$gameTemp._isDisabledGotoPage; },
      tooltip: "保存",
      onTap() {
        SceneManager._scene.saveTempInfo();
        if ($gameMap._interpreter._list) {
          if ($gameMap._interpreter._childInterpreter) {
            $gameSystem._tempEventType = "child";
            $gameSystem._tempEventIndex = getPrevIndex($gameMap._interpreter._childInterpreter);
          } else {
            $gameSystem._tempEventType = "main";
            $gameSystem._tempEventIndex = getPrevIndex($gameMap._interpreter);
          }
        } else {
          $gameSystem._tempEventType = undefined;
          $gameSystem._tempEventIndex = undefined;
        }
        SceneManager.push(Scene_Save);
      }
    }, {
      name: "读取",
      imageNormal: "ui/talk/talk_btn_load_default",
      imageActive: "ui/talk/talk_btn_load_active",
      get visible() { return !(SceneManager._scene instanceof Scene_SceneThink) && !$gameTemp._isDisabledGotoPage; },
      tooltip: "读取",
      onTap() {
        SceneManager._scene.saveTempInfo();
        SceneManager.push(Scene_Load);
      }
    },
    {
      name: "日志",
      imageNormal: "ui/talk/talk_btn_review_default",
      imageActive: "ui/talk/talk_btn_review_active",
      get visible() { return !(SceneManager._scene instanceof Scene_SceneThink) && !$gameTemp._isDisabledGotoPage; },
      tooltip: "日志",
      onTap() {
        SceneManager._scene.saveTempInfo();
        SceneManager.push(Scene_Haku_Log);
      }
    }, {
      name: "系统",
      imageNormal: "ui/talk/talk_btn_config_default",
      imageActive: "ui/talk/talk_btn_config_active",
      get visible() { return !(SceneManager._scene instanceof Scene_SceneThink) && !$gameTemp._isDisabledGotoPage; },
      tooltip: "系统菜单",
      onTap() {
        SceneManager._scene.saveTempInfo();
        SceneManager.push(Scene_Haku_SysMenu);
      }
    }
  ];

  const SkipKey = "control";

  Game_Temp.prototype.disabledGotoPage = function() {
    $gameTemp._isDisabledGotoPage = true;
    SceneManager._scene._messageWindow.createMessageButtons();
  }

  Game_Temp.prototype.enabledGotoPage = function() {
    $gameTemp._isDisabledGotoPage = false;
    SceneManager._scene._messageWindow.createMessageButtons();
  }

  Scene_Message.prototype.messageWindowRect = function () {
    const ww = this instanceof Scene_Haku_Adventure ? 849 : Graphics.boxWidth;
    const wh = this.calcWindowHeight(4, false) + 8;
    const wx = this instanceof Scene_Haku_Adventure ? 0 : (Graphics.boxWidth - ww) / 2;
    const wy = 0;
    return new Rectangle(wx, wy, ww, wh);
  };

  const _Window_Message_initialize = Window_Message.prototype.initialize;
  Window_Message.prototype.initialize = function (rect) {
    _Window_Message_initialize.call(this, rect);

    this.messageButtons = __messageButtons;

    this.uiContainer = new HakuContainer();
    this.addChildToBack(this.uiContainer);

    this.initCommandTag();

    this.createMessageButtons();

    this.padding = SceneManager._scene instanceof Scene_Haku_Adventure ? 30 : 8;

    /** 开启自动播放 */
    this._isAutoPlay = false;
    /** 开启快进 */
    this._isSkip = false;

    /** 左上角显示正在进行的小三角形 */
    this.tagAnimeInfo = {
      isStart: false,
      frameCounter: 0,
      frameDelay: 20,
      frameIndex: 0,
      frameCount: 3,
    };

    Object.defineProperties(this, {
      isAutoPlay: {
        get() {
          return this._isAutoPlay;
        },
        set(value) {
          this._isAutoPlay = value;
          if (value) {
            this.showCommandTag();
          } else {
            this.hideCommandTag();
          }
        }
      },
      isSkip: {
        get() {
          return this._isSkip;
        },
        set(value) {
          this._isSkip = value;
          if (value) {
            this.showCommandTag();
          } else {
            this.hideCommandTag();
          }
        }
      }
    });
  };

  // 初始化左上角的小功能标签
  Window_Message.prototype.initCommandTag = function () {
    if (!SceneManager._scene.uiContainer) {
      throw new Error("需要先初始化UI层，未找到uiContainer");
    }

    // 左上角用于显示是否在自动/跳过的标签
    this.tagContainer = new PIXI.Container();
    this.tagContainer.alpha = 0;

    SceneManager._scene.topUIContainer.addChild(this.tagContainer);
    // this.uiContainer.addChild(this.tagContainer);

    const _sprite = new Sprite(ImageManager.loadPicture('ui/talk/talk_tag'));
    _sprite.x = 0;
    _sprite.y = 56;
    this.tagContainer.addChild(_sprite);

    this.tagTextSprite = new Sprite(new Bitmap(100, 56));
    this.tagTextSprite.x = 0;
    this.tagTextSprite.y = _sprite.y + 2;
    this.tagTextSprite.bitmap.fontFace = 'loli';
    this.tagTextSprite.bitmap.fontSize = 22;
    this.tagContainer.addChild(this.tagTextSprite);

    this.tagArrowSprite = new Sprite(new Bitmap(100, 56));
    this.tagArrowSprite.x = 200 - this.tagTextSprite.width;
    this.tagArrowSprite.y = _sprite.y + 1;
    this.tagContainer.addChild(this.tagArrowSprite);
  };
  Window_Message.prototype.updateCommandTag = function () {
    if (this.tagAnimeInfo.isStart) {
      this.tagAnimeInfo.frameCounter++;
      if (this.tagAnimeInfo.frameCounter > this.tagAnimeInfo.frameDelay) {
        this.tagArrowSprite.bitmap.clear();

        this.tagAnimeInfo.frameCounter = 0;
        this.tagAnimeInfo.frameIndex++;
        if (this.tagAnimeInfo.frameIndex > this.tagAnimeInfo.frameCount) {
          this.tagAnimeInfo.frameIndex = 0;
        }

        const _arrowBitmap = ImageManager.loadPicture(`ui/talk/talk_tag_arrow`);
        for (let i = 0; i < this.tagAnimeInfo.frameIndex; i++) {
          this.tagArrowSprite.bitmap.blt(_arrowBitmap,
            0, 0, _arrowBitmap.width, _arrowBitmap.height,
            i * _arrowBitmap.width, 17, _arrowBitmap.width, _arrowBitmap.height
          );
        }
      }
    }
  };
  Window_Message.prototype.showCommandTag = function () {
    this.tagTextSprite.bitmap.clear();
    if (this.isAutoPlay) {
      this.tagTextSprite.bitmap.drawText('自动', 5, 0, 80, 56, 'right');
    } else if (this.isSkip) {
      this.tagTextSprite.bitmap.drawText('快进', 5, 0, 80, 56, 'right');
    }
    this.tagAnimeInfo.frameCounter = 0;
    this.tagAnimeInfo.frameIndex = 0;
    this.tagContainer.alpha = 1;
    this.tagAnimeInfo.isStart = true;
  };
  Window_Message.prototype.hideCommandTag = function () {
    this.tagTextSprite.bitmap.clear();
    this.tagAnimeInfo.frameCounter = 0;
    this.tagAnimeInfo.frameIndex = 0;
    this.tagAnimeInfo.isStart = false;
    this.tagContainer.alpha = 0;
  };

  /** 创建按钮组 */
  Window_Message.prototype.createMessageButtons = function () {
    let _alpha = 0;
    if (this.messageButtonContainer) {
      _alpha = this.messageButtonContainer.alpha;
      this.messageButtonContainer.removeChildren();
    } else {
      this.messageButtonContainer = new PIXI.Container();
      this.messageButtonContainer.y = this.y + this.height - 15;
      this.uiContainer.addChild(this.messageButtonContainer);
    }

    this.messageButtonContainer.alpha = _alpha;

    const _btns = this.messageButtons;
    let _index = _btns.length - 1;
    for (let i = _btns.length - 1; i >= 0; i--) {
      const item = _btns[i];
      if (item.visible !== undefined && !item.visible) continue;

      let _itemBg = item.imageNormal;
      if (item.disabled === true) {
        _itemBg = item.imageDisabled;
      }
      if (_btns[i].sprite && _btns[i].sprite.transform) {
        _btns[i].sprite.destroy();
        _btns[i].sprite = null;
      }
      const _sprite = new Sprite(ImageManager.loadPicture(_itemBg));
      _btns[i].sprite = _sprite;
      _sprite.x = this.width - (_btns.length - _index) * 40 - 5;
      _sprite.y = 0;
      this.messageButtonContainer.addChild(_sprite);
      _index--;
    }
  };


  // #region Update部分
  const _Window_Message_update = Window_Message.prototype.update;
  Window_Message.prototype.update = function () {
    const _re = this.updateButtons();

    // 检测是否按下了Ctrl键
    if ($gameMessage.isBusy()) {
      if (Input.isPressed(SkipKey) && !this.isSkip) {
        this.isKeyDown_Control = true;
        this.isSkip = true;
      }
      if (this.isKeyDown_Control && !Input.isPressed(SkipKey)) {
        this.isKeyDown_Control = false;
        this.isSkip = false;
      }
    }

    this.updateCommandTag();

    // 判断对话是否完全结束
    if (!$gameMessage.isBusy()) {
      if (SceneManager._scene.showGameUI && !this.isShowMessage()) {
        this.isAutoPlay = false;
        this.isSkip = false;
        SceneManager._scene.showGameUI();
        
        if (this._closing) {
          this.messageButtonContainer.alpha = 0;
        }
      }
      
      if (SceneManager._scene instanceof Scene_Haku_Adventure && !this.isShowMessage() && !$gameData.isEventBusy) {
        SceneManager._scene.uiPanel.alpha = 1;
      }
    }

    if (_re !== false && $gameMessage.isStopMessage !== true) {
      _Window_Message_update.call(this);
    }
  };

  Window_Message.prototype.updateButtons = function () {
    if (!$gameMessage.isBusy()) return;

    const _mouseX = TouchInput.x;
    const _mouseY = TouchInput.y;
    // 更新男主行为按钮
    const _btns = this.messageButtons.filter(i => i.visible === undefined || i.visible);
    for (let i = 0; i < _btns.length; i++) {
      const item = _btns[i];
      // 光标进入范围内
      if (item.sprite.inArea(_mouseX, _mouseY, this.x + this.messageButtonContainer.x, this.y + this.messageButtonContainer.y)) {
        // 点击
        if (TouchInput.isTriggered()) {
          // 禁用状态
          if (item.disabled === true) {
            SoundManager.playBuzzer();
            continue;
          } else {
            SoundManager.playOk();
            item.onTap.call(this);
            return false;
          }
        }
        if (item.disabled !== true) {
          if (!item.isHover) {
            if (item.imageActive) {
              item.sprite.bitmap = ImageManager.loadPicture(item.imageActive);
            }
            if (item.tooltip && SceneManager._scene.setTooltip) {
              SceneManager._scene.setTooltip(item.tooltip);
            }
            SoundManager.playCursor();
          }
          item.isHover = true;
        }
      } else {
        if (item.isActive && item.isActive.call(this) && item.imageActive) {
          item.sprite.bitmap = ImageManager.loadPicture(item.imageActive);
        } else {
          item.sprite.bitmap = ImageManager.loadPicture(item.imageNormal);
        }
        if (item.isHover) {
          if (SceneManager._scene.setTooltip) {
            SceneManager._scene.setTooltip();
          }
          item.isHover = false;
          item.sprite.bitmap = ImageManager.loadPicture(item.imageNormal);
        }
      }
    }
  };

  const _Window_Message_initMembers = Window_Message.prototype.initMembers;
  Window_Message.prototype.initMembers = function () {
    _Window_Message_initMembers.call(this);

    this._commandContainer = null;
  };

  Window_Message.prototype.updateBackground = function () {
    this.setBackgroundType($gameMessage.background());
  };

  Window_Message.prototype.updatePlacement = function () {
    const goldWindow = this._goldWindow;
    this._positionType = $gameMessage.positionType();
    if (this._positionType === 2) {
      this.y = Graphics.height - this.height - 30;
    } else {
      this.y = (this._positionType * (Graphics.boxHeight - this.height)) / 2;
    }
    if (goldWindow) {
      goldWindow.y = this.y > 0 ? 0 : Graphics.boxHeight - goldWindow.height;
    }
  };

  Window_Message.prototype.setBackgroundType = function () {
    this.opacity = 0;
    this.showBackgroundDimmer();
  };

  Window_Message.prototype.newLineX = function (textState) {
    return SceneManager._scene instanceof Scene_Haku_Adventure ? 0 : 200;
  };

  Window_Base.prototype.makeFontBigger = function () {
    this.contents.fontSize += 8;
  };

  Window_Base.prototype.makeFontSmaller = function () {
    this.contents.fontSize -= 8;
  };

  Window_Message.prototype.showBackgroundDimmer = function (backgroundType) {
    if (!this._dimmerSprite) {
      this._dimmerSprite = new Sprite();
      this._dimmerSprite.bitmap = new Bitmap(this.width + 8, this.height + 30);
      this._dimmerSprite.bitmap.smooth = false;
      this._dimmerSprite.bitmap.bltImg('ui/talk/talk_message_mask');
      this._dimmerSprite.x = -4;
      this._dimmerSprite.y = -29.5;
      this.addChildToBack(this._dimmerSprite);
    }
    this._dimmerSprite.visible = true;
    this.updateBackgroundDimmer();
  };

  Window_Message.prototype.addChildToBack = function (child) {
    const containerIndex = this.children.indexOf(this._container);
    return this.addChildAt(child, containerIndex + 1);
  };

  const _Window_Message_startMessage = Window_Message.prototype.startMessage;
  Window_Message.prototype.startMessage = function () {
    if (SceneManager._scene.hideGameUI) {
      SceneManager._scene.hideGameUI();
    }
    _Window_Message_startMessage.call(this);
    this.contents.fontFace = 'Source Han Sans VF';
    this.contents.textColor = 'rgba(255, 255, 255, 1)';
    this.contents.fontSize = SceneManager._scene instanceof Scene_Haku_Adventure ? 23 : 24;
    this.contents.outlineWidth = 3;
    this.contents.outlineColor = 'rgb(0, 0, 0)';
    
    
    if ($gameMessage.positionType() == 2) {
      this.messageButtonContainer.alpha = 1;
    } else {
      this.messageButtonContainer.alpha = 0;
    }
    
    if (SceneManager._scene instanceof Scene_Haku_Adventure) {
      SceneManager._scene.uiPanel.alpha = 0;
    }

    // 到下一句话时停止气泡
    Utils_Balloon.stop();

    this._messageAutoCount = this._textState.text.length * 3 + 50;
  };

  /** 是否在显示对话 */
  Window_Message.prototype.isShowMessage = function () {
    if (SceneManager._scene._messageWindow) {
      return SceneManager._scene._messageWindow.isOpen();
    }
    return false;
  }

  Window_NameBox.prototype.start = function () {
    this.updatePlacement();
    this.updateBackground();
    this.createContents();
    this.refresh();
  };

  // #region 姓名框调整

  Scene_Message.prototype.createNameBoxWindow = function () {
    this._nameBoxWindow = new Window_NameBox();
    this.addChild(this._nameBoxWindow);
  };

  // 姓名框
  Window_NameBox.prototype.updateBackground = function () {
    this.setBackgroundType($gameMessage.background());
  };

  Window_NameBox.prototype.setBackgroundType = function () {
    this.opacity = 0;
    this.showBackgroundDimmer();
  };

  Window_NameBox.prototype.refresh = function () {
    const rect = this.baseTextRect();
    this.contents.clear();
    // this.openness = this._name ? 255 : 0;
    this.drawTextEx(this._name, rect.x, rect.y, rect.width);
  };

  Window_NameBox.prototype.windowHeight = function() {
    return 70;
  };

  Window_NameBox.prototype.showBackgroundDimmer = function (backgroundType) {
    if (!this._dimmerSprite) {
      this._dimmerSprite = new Sprite();
      this._dimmerSprite.bitmap = new Bitmap(this.width, this.height);
      this._dimmerSprite.bitmap.smooth = false;
      this._dimmerSprite.x = 0;
      this._dimmerSprite.y = 0;
      this.addChildToBack(this._dimmerSprite);
    }
    if (this._dimmerSprite) {
      this._dimmerSprite.bitmap.clear();
      this._dimmerSprite.bitmap = new Bitmap(this.width, this.height);
      this._dimmerSprite.bitmap.smooth = false;
      this._dimmerSprite.bitmap.bltImg('ui/talk/talk_message_name_mask', undefined, { width: this._dimmerSprite.width, height: 60 });
      this._dimmerSprite.visible = true;
    }
    this.updateBackgroundDimmer();
  };

  Window_NameBox.prototype.updatePlacement = function () {
    this.width = this.windowWidth();
    this.height = this.windowHeight();
    const messageWindow = this._messageWindow;
    if ($gameMessage.isRTL()) {
      this.x = messageWindow.x + messageWindow.width - this.width;
    } else {
      if (SceneManager._scene instanceof Scene_Haku_Adventure) {
        this.x = 20 + messageWindow.x;
      } else {
        this.x = 200 + messageWindow.x;
      }
    }
    if (messageWindow.y > 0) {
      if (SceneManager._scene instanceof Scene_Haku_Adventure) {
        this.y = messageWindow.y - this.height + 30;
      } else {
        this.y = messageWindow.y - this.height + 10;
      }
    } else {
      this.y = messageWindow.y + messageWindow.height;
    }
  };

  Window_NameBox.prototype.textSizeEx = function (text) {
    this.resetFontSettings();
    this.contents.fontFace = 'Source Han Sans VF';
    this.contents.fontSize = 32;
    const textState = this.createTextState(text, 0, 0, 0);
    textState.drawing = false;
    this.processAllText(textState);
    return { width: textState.outputWidth, height: textState.outputHeight };
  }

  Window_NameBox.prototype.drawTextEx = function (text, x, y, width) {
    this.resetFontSettings();
    this.contents.fontFace = 'Source Han Sans VF';
    this.contents.textColor = 'rgba(255, 255, 255, 1)';
    this.contents.fontSize = 32;
    this.contents.outlineWidth = 3;
    this.contents.outlineColor = 'rgb(0, 0, 0)';

    const textState = this.createTextState(text, x, y, width);
    this.processAllText(textState);
    return textState.outputWidth;
  };

  // #endregion

  // 不绘制脸图
  Window_Message.prototype.drawMessageFace = function () { };



  // #region 选项框

  // 下一次选项的配置列表
  Window_ChoiceList.prototype.nextItemConfigList = [];
  window.setChoiceListConfig = function (configList) {
    Window_ChoiceList.prototype.nextItemConfigList = configList;
  }

  const Window_ChoiceList_initialize = Window_ChoiceList.prototype.initialize;
  Window_ChoiceList.prototype.initialize = function () {
    Window_ChoiceList_initialize.call(this);
    this.opacity = 0;
    this.cursorSprite = new Sprite(ImageManager.loadPicture('ui/choice/choice_cursor'));
    this.cursorSprite.x = -30;
    this.cursorSprite.y = 25;
    this.cursorSprite.alpha = 0;
    this.addChild(this.cursorSprite);
  };
  Window_ChoiceList.prototype.updateBackground = function () {
    if (this._backgroundSprite) {
      this._backgroundSprite.destroy();
    }

    const _baseBgBitmap = ImageManager.loadPicture('ui/choice/choice_panel_backgroundpng');
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.y = -50;
    this.addChildAt(this._backgroundSprite, 0);
    const _height = $gameMessage.choices().length * this.itemHeight() + ($gameMessage.choices().length - 1) * 15 + 100;

    if (SceneManager._scene instanceof Scene_Haku_Adventure) {
      this._backgroundSprite.x = -60;
      _baseBgBitmap.addLoadListener(() => {
        this._backgroundSprite.bitmap = new Bitmap(855, _height);
        this._backgroundSprite.bitmap.blt(_baseBgBitmap, 
          0, 0, _baseBgBitmap.width, _baseBgBitmap.height, 
          0, 0, 855, _height
        );
      });
    } else {
      this._backgroundSprite.x = -(Graphics.width - 740) / 2;
      _baseBgBitmap.addLoadListener(() => {
        this._backgroundSprite.bitmap = new Bitmap(Graphics.width, _height);
        this._backgroundSprite.bitmap.blt(_baseBgBitmap, 
          0, 0, _baseBgBitmap.width, _baseBgBitmap.height, 
          0, 0, Graphics.width, _height
        );
      });
    }
  };
  Window_ChoiceList.prototype.updatePlacement = function () {
    
    if (SceneManager._scene instanceof Scene_Haku_Adventure) {
      this.x = 60;
      this.y = 260 - ($gameMessage.choices().length - 3) * this.itemHeight();
    } else {
      this.x = (Graphics.width - 740) / 2;
      this.y = (Graphics.height - 400) / 2;
    }
    
    this.width = 740;
    this.height = 400;
  };
  Window_ChoiceList.prototype.itemHeight = function () {
    return 76;
  };
  Window_ChoiceList.prototype.rowSpacing = function () {
    return 20;
  };
  Window_ChoiceList.prototype.select = function (index) {
    if (this._index !== index) {
      SoundManager.playCursor();
      const _oldIndex = this._index;
      this._index = index;
      this.drawItemBackground(_oldIndex);
      this.drawItemBackground(this._index);
      this._oldIndex = _oldIndex;
      if (this.cursorSprite) {
        if (index == -1) this.cursorSprite.alpha = 0;
        else if (this.cursorSprite.alpha === 0) this.cursorSprite.alpha = 1;
        this.cursorSprite.y = index * this.itemHeight() + 25;
      }
    }
  };
  Window_ChoiceList.prototype.drawItemBackground = function (index) {
    const rect = this.itemRect(index);
    this.drawBackgroundRect(rect, index);
  };
  Window_ChoiceList.prototype.drawBackgroundRect = function (rect, index) {
    if (!this._list[index]) return;

    let _itemImgSrc = '';
    const _itemConfig = Window_ChoiceList.prototype.nextItemConfigList[index];
    if (index === this.index()) {
      if (_itemConfig) {
        if (_itemConfig.disabled) {
          _itemImgSrc = 'ui/choice/choice_item_disabled_active';
        } else if (_itemConfig.color === 'orange') {
          _itemImgSrc = 'ui/choice/choice_item_orange_active';
        } else if (_itemConfig.color === 'blue') {
          _itemImgSrc = 'ui/choice/choice_item_blue_active';
        } else if (_itemConfig.color === 'pink') {
          _itemImgSrc = 'ui/choice/choice_item_pink_active';
        } else {
          _itemImgSrc = 'ui/choice/choice_item_orange_active';
        }
      } else {
        _itemImgSrc = 'ui/choice/choice_item_orange_active';
      }
    } else {
      if (_itemConfig) {
        if (_itemConfig.disabled) {
          _itemImgSrc = 'ui/choice/choice_item_disabled_active';
        } else if (_itemConfig.color === 'orange') {
          _itemImgSrc = 'ui/choice/choice_item_orange_normal';
        } else if (_itemConfig.color === 'blue') {
          _itemImgSrc = 'ui/choice/choice_item_blue_normal';
        } else if (_itemConfig.color === 'pink') {
          _itemImgSrc = 'ui/choice/choice_item_pink_normal';
        } else {
          _itemImgSrc = 'ui/choice/choice_item_orange_normal';
        }
      } else {
        _itemImgSrc = 'ui/choice/choice_item_orange_normal';
      }
    }
    this.contentsBack.bltImg(_itemImgSrc, undefined, {
      clear: true, x: rect.x, y: rect.y, width: rect.width, height: rect.height
    });
  };
  Window_Command.prototype.isCurrentItemEnabled = function () {
    if (this.currentData()) {
      if (this.currentData().enabled) {
        if (this.nextItemConfigList) {
          const _item = this.nextItemConfigList[this.index()];
          if (_item && _item.disabled !== undefined) {
            return !_item.disabled;
          }
        }
        return true;
      }
      return false;
    } else {
      return false;
    }
  };
  Window_ChoiceList.prototype.drawItem = function (index) {
    const rect = this.itemLineRect(index);
    this.contents.fontFace = 'Source Han Sans VF';
    this.contents.fontSize = 20;
    this.contents.outlineWidth = 4;
    if (this.nextItemConfigList) {
      const _item = this.nextItemConfigList[index];
      if (_item && _item.disabled) {
        this.contents.outlineColor = 'rgba(0, 0, 0, 0.3)';
        this.drawText(_item.disabledText || this.commandName(index), rect.x, rect.y, rect.width, 'center');
      } else {
        this.contents.outlineColor = 'rgba(0, 0, 0, 0.6)';
        this.drawText(this.commandName(index), rect.x, rect.y, rect.width, 'center');
      }
    } else {
      this.drawText(this.commandName(index), rect.x, rect.y, rect.width, 'center');
    }
  };
  const Window_ChoiceList_close = Window_ChoiceList.prototype.close;
  Window_ChoiceList.prototype.close = function () {
    Window_ChoiceList_close.call(this);
    setChoiceListConfig([]);
  }


  // #endregion



  // #region 加速/跳过功能

  // const _SceneManager_determineRepeatNumber = SceneManager.determineRepeatNumber;
  // SceneManager.determineRepeatNumber = function(deltaTime) {
  //   const result = _SceneManager_determineRepeatNumber.call(this, deltaTime);
  //   if (this._scene && this._scene.isAnyWindowActive()) {
  //     return result;
  //   }
  //   if (Input.isLongPressed(SkipKey)) {
  //     return result * 2;
  //   } else {
  //     return result;
  //   }
  // };

  const Original_isTriggered = Window_Message.prototype.isTriggered;
  Window_Message.prototype.isTriggered = function () {
    if (this.isSkip) {
      this._pauseSkip = false;
      return true;
    }
    if (this.isAutoPlay && this._messageAutoCount <= 0) {
      if (!AudioManager.isExistVoice()) {
        // this.initializeMessageAutoCount();
        return true;
      }
    }

    return Original_isTriggered.call(this);
  };


  const _Window_Message_updateWait = Window_Message.prototype.updateWait;
  Window_Message.prototype.updateWait = function () {
    if (this.parent instanceof Scene_SceneThink || this.parent instanceof Scene_MainScene) {
      const _scene = this.parent;

      if ($gameMessage.isBusy()) {
        if (_scene.titleContainer) _scene.titleContainer.alpha = 0;
      }

      if (TouchInput.isTriggered() && !this.visibleMessageWindow) {
        this.visibleMessageWindow = true;
        _scene._nameBoxWindow.alpha = 1;
        _scene._messageWindow.alpha = 1;
        if (_scene.tooltipContainer) _scene.tooltipContainer.alpha = 1;
        if (_scene.titleContainer) _scene.titleContainer.alpha = 1;
        if (_scene.backBtn) _scene.backBtn.alpha = 1;
      } else if (TouchInput.isCancelled() && $gameMessage.isBusy()) {
        this.visibleMessageWindow = this.visibleMessageWindow !== false ? false : true;
        _scene._nameBoxWindow.alpha = this.visibleMessageWindow !== false ? 1 : 0;
        _scene._messageWindow.alpha = this.visibleMessageWindow !== false ? 1 : 0;
        if (_scene.tooltipContainer) _scene.tooltipContainer.alpha = this.visibleMessageWindow !== false ? 1 : 0;
        // if (_scene.titleContainer) _scene.titleContainer.alpha = this.visibleMessageWindow !== false ? 1 : 0;
        if (_scene.backBtn) _scene.backBtn.alpha = this.visibleMessageWindow !== false ? 1 : 0;
      }
    }
    // this.updateSkipAuto();
    // this.updateSwitchPicture();
    if (this.isSkip) {
      this._waitCount = 0;
    }
    return _Window_Message_updateWait.apply(this, arguments);
  };

  Window_Message.prototype.updateShowFast = function () {
    if (this.isSkip || this.isTriggered()) {
      this._showFast = true;
    }
  };

  Scene_Base.prototype.isAnyWindowActive = function () {
    if (this._windowLayer) {
      return this._windowLayer.children.some(win => {
        return win instanceof Window_Selectable && win.active;
      });
    } else {
      return false;
    }
  };

  const _Window_Message_updateInput = Window_Message.prototype.updateInput;
  Window_Message.prototype.updateInput = function () {
    if (this.isAutoPlay && this._messageAutoCount > 0 && this.visible) this._messageAutoCount--;
    return _Window_Message_updateInput.apply(this, arguments);
  };

  AudioManager.isExistVoice = function () {
    if (!AudioManager._voiceBuffers) {
      return false;
    }
    this.filterPlayingVoice();
    return this._voiceBuffers.some(function (buffer) {
      return !buffer._sourceNode.loop;
    });
  }

  // #endregion

  class Utils_MessageBox {
  }
  window.Utils_MessageBox = Utils_MessageBox;

  if (Utils.RPGMAKER_NAME === "MZ") {
  }
})();