//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Balloon.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 气泡插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】气泡相关插件。
 * 
 * 
 * 
 * @command show
 * @text 显示气泡
 * @desc 显示气泡
 * 
 * @arg balloonName
 * @text 气泡名称
 * @desc 气泡名称
 * @type select
 * @option 兴奋（左
 * @value e01_L
 * @option 兴奋（右
 * @value e01_R
 * @option 惊讶1
 * @value e02
 * @option 惊讶2
 * @value e03
 * @option 新主意
 * @value e04
 * @option 晕眩
 * @value e05
 * @option 疑问1
 * @value e06
 * @option 疑问2
 * @value e07
 * @option 喜欢
 * @value e08
 * @option 鲜花
 * @value e09
 * @option 混乱1
 * @value e10
 * @option 生气
 * @value e11
 * @option 流汗
 * @value e12
 * @option 慌张（左
 * @value e13_L
 * @option 慌张（右
 * @value e13_R
 * @option 轻微生气（左
 * @value e14_L
 * @option 轻微生气（右
 * @value e14_R
 * @option 心碎
 * @value e15
 * @option 音符
 * @value e16
 * @option 冒泡
 * @value e17
 * @option 麻了（左
 * @value e18_L
 * @option 麻了（右
 * @value e18_R
 * @option 兴高采烈（左
 * @value e19_L
 * @option 兴高采烈（右
 * @value e19_R
 * @option 糟心
 * @value e20
 * @option 睡觉
 * @value e21
 * @option 混乱
 * @value e22
 * @option 思考
 * @value e23
 * @option 星星
 * @value e24
 * @option 爆炸
 * @value e25
 * @option 生气惊讶（左
 * @value e26_L
 * @option 生气惊讶（右
 * @value e26_R
 * 
 * @arg loc
 * @text 气泡位置
 * @desc 气泡位置
 * @type select
 * @option 左边
 * @value left
 * @option 右边
 * @value right
 * @default left
 * 
 * 
 * 
 * @command stop
 * @text 停止气泡
 * @desc 停止气泡
 * 
 * 
 */
// #endregion
(() => {

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Module_Balloon";
  

  /**
   * 气泡数据
   */
  const __Data_Balloon = {
    // 兴奋（左
    'e01_L': { img: 'emo_001_L_ss', desc: '兴奋（左', loc: 'left', widthCount: 5, heightCount: 6 },
    // 兴奋（右
    'e01_R': { img: 'emo_001_R_ss', desc: '兴奋（右', loc: 'right', widthCount: 5, heightCount: 6 },
    // 惊讶1
    'e02': { img: 'emo_002_ss', desc: '惊讶1', widthCount: 5, heightCount: 6 },
    // 惊讶2
    'e03': { img: 'emo_003_ss', desc: '惊讶2', widthCount: 5, heightCount: 6 },
    // 新主意
    'e04': { img: 'emo_004_ss', desc: '新主意', widthCount: 5, heightCount: 6 },
    // 晕眩
    'e05': { img: 'emo_005_ss', desc: '晕眩', widthCount: 5, heightCount: 6 },
    // 疑问1
    'e06': { img: 'emo_006_ss', desc: '疑问1', widthCount: 5, heightCount: 6 },
    // 疑问2
    'e07': { img: 'emo_007_ss', desc: '疑问2', widthCount: 5, heightCount: 6 },
    // 喜欢
    'e08': { img: 'emo_008_ss', desc: '喜欢', widthCount: 5, heightCount: 6 },
    // 鲜花
    'e09': { img: 'emo_009_ss', desc: '鲜花', widthCount: 5, heightCount: 6 },
    // 混乱1
    'e10': { img: 'emo_010_ss', desc: '混乱1', widthCount: 5, heightCount: 6 },
    // 生气
    'e11': { img: 'emo_011_ss', desc: '生气', widthCount: 5, heightCount: 6 },
    // 流汗
    'e12': { img: 'emo_012_ss', desc: '流汗', widthCount: 5, heightCount: 6 },
    // 慌张（左
    'e13_L': { img: 'emo_013_L_ss', desc: '慌张（左', loc: 'left', widthCount: 5, heightCount: 6 },
    // 慌张（右
    'e13_R': { img: 'emo_013_R_ss', desc: '慌张（右', loc: 'right', widthCount: 5, heightCount: 6 },
    // 轻微生气（左
    'e14_L': { img: 'emo_014_L_ss', desc: '轻微生气（左', loc: 'left', widthCount: 5, heightCount: 6 },
    // 轻微生气（右
    'e14_R': { img: 'emo_014_R_ss', desc: '轻微生气（右', loc: 'right', widthCount: 5, heightCount: 6 },
    // 心碎
    'e15': { img: 'emo_015_ss', desc: '心碎', widthCount: 5, heightCount: 8 },
    // 音符
    'e16': { img: 'emo_016_ss', desc: '音符', widthCount: 5, heightCount: 6 },
    // 冒泡
    'e17': { img: 'emo_017_ss', desc: '冒泡', widthCount: 6, heightCount: 8 },
    // 麻了（左
    'e18_L': { img: 'emo_018_L_ss', loc: 'left', desc: '麻了（左', widthCount: 5, heightCount: 6 },
    // 麻了（右
    'e18_L': { img: 'emo_018_R_ss', loc: 'right', desc: '麻了（右', widthCount: 5, heightCount: 6 },
    // 兴高采烈（左
    'e19_L': { img: 'emo_019_L_ss', loc: 'left', desc: '兴高采烈（左', widthCount: 5, heightCount: 6 },
    // 兴高采烈（右
    'e19_L': { img: 'emo_019_R_ss', loc: 'right', desc: '兴高采烈（右', widthCount: 5, heightCount: 6 },
    // 糟心
    'e20': { img: 'emo_020_ss', desc: '糟心', widthCount: 6, heightCount: 8 },
    // 睡觉
    'e21': { img: 'emo_021_ss', desc: '睡觉', widthCount: 6, heightCount: 8 },
    // 混乱
    'e22': { img: 'emo_022_ss', desc: '混乱2', widthCount: 5, heightCount: 6 },
    // 思考
    'e23': { img: 'emo_023_ss', desc: '思考', widthCount: 6, heightCount: 8 },
    // 星星
    'e24': { img: 'emo_024_ss', desc: '星星', widthCount: 5, heightCount: 6 },
    // 爆炸
    'e25': { img: 'emo_025_ss', desc: '爆炸', widthCount: 5, heightCount: 6 },
    // 生气惊讶（左
    'e26_L': { img: 'emo_026_L_ss', loc: 'left', desc: '生气惊讶（左', widthCount: 5, heightCount: 6 },
    // 生气惊讶（右
    'e26_L': { img: 'emo_026_R_ss', loc: 'right', desc: '生气惊讶（右', widthCount: 5, heightCount: 6 },
  };

  /**
   * 气泡模块
   */
  const balloonModule = {
    /**
     * 当前定时器（不允许两个气泡同时进行）
     */
    timer: undefined,
    /**
     * 当前气泡
     */
    sprite: undefined,
    /** 
     * 根据Sprite显示气泡
     * @param {string} balloonName 气泡名称
     * @param {Object} param1 
     * @param {'left'|'right'} [param1.loc='left'] 气泡方位
     * @param {number} [param1.loopCount=1] 气泡显示次数
     * @param {Function} [param1.callback=null] 回调函数
     * @param {Sprite|Container} [param1.sprite] 对应精灵
     * @param {number} [param1.speed = 3] 播放帧数间隔
     */
    show(balloonName, { loc = 'left', loopCount = 1, callback, sprite, speed = 3 }) {
      const _balloon = __Data_Balloon[balloonName];
      ImageManager.loadImg(`balloon/${_balloon.img}`).then(img => {
        const _cellScale = 2;
        const _cellWidth = img.width / _balloon.widthCount;
        const _cellHeight = img.height / _balloon.heightCount;
        const _cellCount = _balloon.widthCount * _balloon.heightCount;
        const _frameCount = _balloon.widthCount * _balloon.heightCount * speed;
        
        const _sprite = new Sprite(new Bitmap(_cellWidth / _cellScale, _cellHeight / _cellScale));
        this.sprite = _sprite;
        if (sprite) {
          _sprite.y = 10;
          if (loc === 'left') {
            _sprite.x = -30;
          } else if (loc === 'right') {
            _sprite.x = sprite.width + 30;
          }
          sprite.addChild(_sprite);
        } else if (SceneManager._scene._speakerContainer) {
          const _spine = SceneManager._scene._speakerContainer.children.find(i => i.constructor.name === '_Spine');
          if (_spine) {
            _sprite.y = _spine.y - _spine.height + 10;
            if (loc === 'left') {
              _sprite.x = _spine.x - _spine.width / 2 - 30;
            } else if (loc === 'right') {
              _sprite.x = _spine.x + _spine.width / 2 + 30;
            }
            SceneManager._scene._speakerContainer.addChild(_sprite);
          }
        }
        const _timer = useTimeout(() => {
          _sprite.destroy();
          if (callback) callback();
        }, _balloon.widthCount * _balloon.heightCount * speed, progress => {
          if (progress * _frameCount % 5 != 0) return;
          
          const _cellIndex = Math.floor(progress * _frameCount / speed);
          const _cellX = (_cellIndex % _balloon.widthCount) * _cellWidth;
          const _cellY = Math.floor(_cellIndex / _balloon.widthCount) * _cellHeight;

          _sprite.bitmap.clear();
          _sprite.bitmap.blt(img, 
            _cellX, _cellY, _cellWidth, _cellHeight,
            0, 0, _cellWidth / _cellScale, _cellHeight / _cellScale
          );
        });

        this.timer = _timer;
        return _timer;
      });
    },
    /** 
     * 根据位置显示气泡
     * @param {string} balloonName 气泡名称
     * @param {Object} param1 
     * @param {'left'|'right'} [param1.loc='left'] 气泡方位
     * @param {number} [param1.loopCount=1] 气泡显示次数
     * @param {Function} [param1.callback=null] 回调函数
     * @param {Sprite|Container} [param1.parent] 父容器
     * @param {number} [param1.speed = 3] 播放帧数间隔
     */
    showByLoc(balloonName, { left, top, loopCount = 1, callback, parent, speed = 3 }) {
      const _balloon = __Data_Balloon[balloonName];
      ImageManager.loadImg(`balloon/${_balloon.img}`).then(img => {
        const _cellScale = 2;
        const _cellWidth = img.width / _balloon.widthCount;
        const _cellHeight = img.height / _balloon.heightCount;
        const _cellCount = _balloon.widthCount * _balloon.heightCount;
        const _frameCount = _balloon.widthCount * _balloon.heightCount * speed;
        
        const _sprite = new Sprite(new Bitmap(_cellWidth / _cellScale, _cellHeight / _cellScale));
        _sprite.x = left;
        _sprite.y = top;
        parent.addChild(_sprite);

        const _timer = useTimeout(() => {
          _sprite.destroy();
          if (callback) callback();
        }, _balloon.widthCount * _balloon.heightCount * speed, progress => {
          if (progress * _frameCount % 5 != 0) return;
          
          const _cellIndex = Math.floor(progress * _frameCount / speed);
          const _cellX = (_cellIndex % _balloon.widthCount) * _cellWidth;
          const _cellY = Math.floor(_cellIndex / _balloon.widthCount) * _cellHeight;

          _sprite.bitmap.clear();
          _sprite.bitmap.blt(img, 
            _cellX, _cellY, _cellWidth, _cellHeight,
            0, 0, _cellWidth / _cellScale, _cellHeight / _cellScale
          );
        });

        this.timer = _timer;
        return _timer;
      });
    },
    /**
     * 停止气泡
     */
    stop() {
      if (this.timer && this.sprite) {
        this.timer.stop();
        if (this.sprite._texture) this.sprite.destroy();
        this.timer = undefined;
        this.sprite = undefined;
      }
    }
  };

  /**
   * 气泡工具类
   */
  class Utils_Balloon {
    /** 
     * 显示气泡
     * @param {string} balloonName 气泡名称
     * @param {Object} param1 
     * @param {'left'|'right'} [param1.loc='left'] 气泡方位
     * @param {number} [param1.loopCount=1] 气泡显示次数
     * @param {Function} [param1.callback=null] 回调函数
     * @param {Sprite|Container} [param1.sprite] 对应精灵
     * @param {number} [param1.speed = 5] 播放帧数间隔
     */
    static show(balloonName, { loc = 'left', loopCount = 1, callback, sprite, speed = 3 }) {
      balloonModule.show(balloonName, { loc, loopCount, callback, sprite, speed });
    }
    /** 
     * 根据位置显示气泡
     * @param {string} balloonName 气泡名称
     * @param {Object} param1 
     * @param {'left'|'right'} [param1.loc='left'] 气泡方位
     * @param {number} [param1.loopCount=1] 气泡显示次数
     * @param {Function} [param1.callback=null] 回调函数
     * @param {Sprite|Container} [param1.parent] 父容器
     * @param {number} [param1.speed = 3] 播放帧数间隔
     */
    static showByLoc(balloonName, { left, top, loopCount = 1, callback, parent, speed = 3 }) {
      balloonModule.showByLoc(balloonName, { left, top, loopCount, callback, parent, speed });
    }
    /**
     * 停止进行中的气泡
     */
    static stop() {
      balloonModule.stop();
    }
  };
  window.Utils_Balloon = Utils_Balloon;

  if (Utils.RPGMAKER_NAME === "MZ") {
    PluginManager.registerCommand(PluginName, 'show', args => {
      balloonModule.show(args.balloonName, {
        loc: args.loc,
        callback: args.callback
      });
    });
    PluginManager.registerCommand(PluginName, 'stop', args => {
      balloonModule.stop();
    });
  }
})();