//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_ChatMessage.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 集成对话插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】集成对话插件。
 * 
 */
(() => {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Module_ChatMessage";


  /** 加奈的对话列表 */
  const __chatList = [
    {
      id: '准备和加奈聊天',
      actor: 'kana',
      texts: [
        { text: '老哥有什么想说的吗？', face: '13' },
        { text: '怎么了吗？', face: '13' },
        { text: '咦…要和你可爱的妹妹聊点什么吗？', face: '15' },
        { text: '嗯？', face: '13' },
      ]
    },
    {
      id: '加奈的随机对话',
      actor: 'kana',
      texts: [
        { mood: 'happy', text: '偶尔也会觉得笨蛋老哥还不错呢～', face: '18' },
        { mood: 'normal', text: '嗯？', face: '14' },
        { mood: 'normal', text: '有什么事情吗？', face: '13' },
        { mood: 'normal', text: '盯——', face: '03' },
        { mood: 'normal', text: '笨蛋老哥总是脑袋空空的…', face: '20' },
        { mood: 'normal', text: 'Ciallo～', face: '15' },
        { mood: 'normal', text: '比起咖喱乌冬来说，更想吃寿司！', face: '18' },
        { mood: 'normal', text: '呐呐～偶尔也多给我些零花钱嘛～', face: '10' },
        { mood: 'sad', text: '笨蛋……', face: '10' },
        { mood: 'sad', text: '……', face: '10' },
        { mood: 'sad', text: '什么嘛', face: '04' },
      ]
    },
    {
      id: '回家太晚的担心',
      actor: 'kana',
      texts: [
        { mood: 'happy', text: '真是的～又是这么晚才回家…', face: '20' },
        { mood: 'normal', text: '真是的～又是这么晚才回家…', face: '20' },
        { mood: 'normal', text: '欢迎回家，这么晚才回来，稍微有点担心哥哥呢…', face: '10' },
        { mood: 'happy', text: '欢迎回家～虽然哥哥应该是有事情做，不过不可以太晚回家哦～我…我会想哥哥的…', face: '10' },
        { mood: 'sad', text: '哼…这么晚才回来……', face: '03' },
      ]
    }, {
      id: '欢迎回家',
      actor: 'kana',
      texts: [
        { mood: 'normal', text: '欢迎回家～', face: '10' },
        { mood: 'happy', text: '哥哥有没有给我带什么好吃的回来呢～', face: '10' },
        { mood: 'sad', text: '哼…我才不管你…', face: '03' },
        { mood: 'sad', text: '哼…', face: '03' },
        { mood: 'sad', text: '……', face: '03' },
      ]
    }, {
      id: '晚上出门的担心',
      actor: 'kana',
      texts: [
        { mood: 'happy', text: '已经很晚了呢，要现在出门吗？～', face: '10' },
        { mood: 'normal', text: '已经很晚了呢，要现在出门吗？～', face: '10' },
        { mood: 'sad', text: '哼～', face: '11' },
        { mood: 'sad', text: '……', face: '09' },
      ]
    }, {
      id: '加奈-路上小心',
      actor: 'kana',
      texts: [
        { mood: 'happy', text: '笨蛋哥哥路上小心哦～', face: '13' },
        { mood: 'normal', text: '笨蛋哥哥路上小心哦～', face: '13' },
        { mood: 'sad', text: '哼～', face: '11' },
        { mood: 'sad', text: '……', face: '09' },
      ]
    }, {
      id: '千夏-路上小心',
      actor: 'chinatsu',
      texts: [
        { text: '哥哥回家路上要注意安全哦～', face: '13' },
      ]
    }, {
      id: '由纪-路上小心',
      actor: 'yuki',
      texts: [
        { text: '\\}唉…要走了吗？', face: '05' },
      ]
    }, {
      id: '加奈回家了',
      actor: 'kana',
      texts: [
        { mood: 'happy', text: '我回来咯，老哥给我拿瓶冰可乐～', face: '15' },
        { mood: 'normal', text: '我回来咯，老哥给我拿瓶冰可乐～', face: '15' },
        { mood: 'sad', text: '哼～', face: '11' },
      ]
    }, {
      id: '有什么事情明天再说',
      actor: 'kana',
      texts: [
        { mood: 'happy', text: '真是的～唔…笨蛋哥哥……已经很晚了哦，有什么事情明天再说啦', face: '10' },
        { mood: 'normal', text: '唔…笨蛋哥哥……已经很晚了哦，有什么事情明天再说啦', face: '10' },
        { mood: 'sad', text: '哼～', face: '10' },
      ]
    }, {
      id: '现在加奈什么都不想说',
      actor: 'kana',
      texts: [
        { text: '哼…', face: '11' },
        { text: '……', face: '10' },
        { text: '没什么想说的…', face: '11' },
      ]
    }, {
      id: '我先出门咯',
      actor: 'kana',
      texts: [
        { mood: 'happy', text: '先出门啦～会给哥哥带零食回来的～', face: '18' },
        { mood: 'normal', text: '哥哥，我先出门咯！', face: '19' },
        { mood: 'normal', text: '笨蛋哥哥，那我就先出门咯～一个人在家要照顾好自己呢', face: '15' },
        { mood: 'sad', text: '哼～', face: '11' },
        { mood: 'sad', text: '……', face: '10' },
      ]
    }, {
      id: '加奈身体接触',
      actor: 'kana',
      texts: [
        { mood: 'happy', text: '那个……就拜托了呢～', face: ['20', 'a1'] },
        { mood: 'normal', text: '要摸摸头吗？也不是不可以呢', face: ['20', 'a1'] },
        { mood: 'sad', text: '笨蛋哥哥…什么都不懂……', face: '04' },
      ]
    }, {
      id: '加奈做爱',
      actor: 'kana',
      texts: [
        { mood: 'happy', text: '姆…真是的…H……', face: ['20', 'a1'] },
        { mood: 'normal', text: '姆…真是的…H……', face: ['20', 'a1'] },
        { mood: 'sad', text: '笨蛋哥哥就只会欺负人…', face: ['07', 'a4'] },
      ]
    }, {
      id: '安慰生气的加奈',
      actor: 'actor',
      texts: [
        { text: '加奈似乎有些生气的样子，唉，好好安慰下她好了…' },
      ]
    }, {
      id: '安慰生气的加奈-成功',
      actor: 'actor',
      texts: [
        { text: '（一段时间过后，加奈终于冷静了下来…以后还是尽量不要惹她生气比较好…）' },
      ]
    }, {
      id: '安慰生气的加奈-失败',
      actor: 'actor',
      texts: [
        { text: '（似乎没什么作用，好像比想象中还要生气啊…）' },
      ]
    }, {
      id: '和千夏聊天',
      actor: 'chinatsu',
      texts: [
        { favor: 1, text: [
          { text: '对了～哥哥过来是有什么需要的吗？', face: '04' },
          { text: '诶？只是来见我的吗？', face: '13' },
          { text: '唔～哥哥别开这种玩笑逗我了啦～', face: '07' },
        ] },
        { favor: 1, text: [
          { text: '最近便利店这边的事情不算太忙，哥哥不用太过担心哦～', face: '02' },
          { text: '毕竟最近有哥哥在帮忙，我的工作也轻松了很多呢～', face: '05' },
          { text: '等下班了我请哥哥喝点什么吧～' },
        ] },
        { favor: 1, text: [
          { text: '有时间了和哥哥还有加奈酱一起出去玩吧～', face: '02' },
          { text: '感觉海边假日什么的和夏天真的很搭哦～', face: '05' },
          { text: '啊对了，哥哥你有什么想去的地方吗？' },
        ] },
        { favor: 2, text: [
          { text: '欢迎光临～哥哥经常来照顾我的生意呢，真是非常感谢呢～', face: '04' },
          { text: '对了，哥哥如果有什么想要的可以和我说哦！', face: '05' },
          { text: '唔～哥哥别开这种玩笑逗我了啦～', face: '07' },
        ] },
        { favor: 2, text: [
          { text: '哥哥最近有什么安排吗？不……我只是想找个时间和哥哥一起度过而已……', face: '12' },
          { text: '最近看到哥哥你和加奈在一起的时候，心里总是痒痒的……', face: '07' },
          { text: '如果，我真的是哥哥的妹妹的话，那就好了呢……', face: '12' },
        ] },
        { favor: 2, text: [
          { text: '哥哥……不，没什么！真的是，我的脸怎么这么红啊……', face: ['12', 'a3'] },
          { text: '难道说，我……那个，哥哥……你对我怎么看？', face: ['07', 'a3'] },
          { text: '就是，那个……不！没什么，就当我什么都没说吧！', face: '11' },
        ] },
        { favor: 3, text: [
          { text: '啊，哥哥你来了呢……嘿嘿～', face: '05' },
          { text: '只要看到哥哥你，我一整天的疲惫都烟消云散了呢～' },
          { text: '最喜欢你了呢～哥哥～', face: ['05', 'a3'] },
        ] },
        { favor: 3, text: [
          { text: '和哥哥在一起度过的日子，是我最幸福的时光。', face: ['05', 'a3'] },
          { text: '光是这样子，凝视着哥哥你的双眼，我就感到满心的幸福……' },
          { text: '要是时光能停留在这一刻就好了呢……', face: ['12', 'a3'] },
        ] },
        { favor: 3, text: [
          { text: '哥哥有什么梦想吗？', face: ['05', 'a3'] },
          { text: '我的梦想是努力工作，攒够了钱，能和喜欢的人一起走遍天涯海角……' },
          { text: '我希望，那时候站在我身边的人，能是哥哥你哦，嘿嘿～' },
        ] },
      ]
    }, {
      id: '和由纪聊天',
      actor: 'yuki',
      texts: [
        { favor: 1, text: [
          { text: '呼……呼……啊，抱歉，刚刚又犯迷糊了……', face: '03' },
          { text: '抱歉，无聊的时候总是容易打瞌睡……' },
          { text: '请小哥你不要介意呢……呼…', face: '05' },
          { text: '呼…呼……', face: '04' },
        ] },
        { favor: 1, text: [
          { text: '虽然经营着这种店铺，但真的不太喜欢这些色色的东西…', face: '06' },
          { text: '咦…？你说也可以试着用用看吗？', face: '08' },
          { text: '真是的…说什么呢……', face: '12' },
        ] },
        { favor: 1, text: [
          { text: '说起来，小哥你多大了呢？', face: '02' },
          { text: '诶？我已经比小哥你大了吗？呜……', face: '09' },
          { text: '明明记忆里才刚毕业没多久来着…已经成为能被称为阿姨的年纪了呢……', face: '05' },
        ] },
        { favor: 1, text: [
          { text: '家里门关了吗……会不会遭小偷啊……什么时候下班呢……', face: '15' },
          { text: '啊，抱歉……又开始走神了……毕竟晚上经营的店铺人比较少。', face: '03' },
          { text: '反正也没什么客人，稍微偷个懒应该没什么问题吧～', face: '06' },
        ] },
        { favor: 2, text: [
          { text: '最近……总是会梦到关于小哥您的事情呢……', face: '07' },
          { text: '说起来，小哥经常来我家店铺光临，您的女朋友用得上这么多东西吗？' },
          { text: '诶？您没有女朋友吗？啊……那小哥回头要不要一起去附近的公园坐坐呢？', face: '09' },
        ] },
        { favor: 2, text: [
          { text: '因为帮忙经营着这种店铺，所以经常被身边的人以奇怪的眼光看待呢……', face: '06' },
          { text: '很多客人都曾经要过我的联系方式，认为我是那种女孩子，结果全都被我拒绝了呢。', face: '05' },
          { text: '想要的果然还是那种甜甜的恋爱呢…' },
        ] },
        { favor: 2, text: [
          { text: '明明连恋爱都还没谈过，却总是被叫阿姨什么的……伤心……', face: '05' },
          { text: '我明明都还没满25岁吧？…咦小哥你说我只是看起来比较成熟而已？', face: '07' },
          { text: '就当做小哥你是在夸我吧~' },
        ] },
        { favor: 3, text: [
          { text: '身边的朋友一个个都已经结婚生子了呢……', face: '05' },
          { text: '毕竟都已经快要二十五岁了，至少也要有个男朋友了……' },
          { text: '唉…是这家店带来的诅咒吗……呐，小哥…你觉得我怎么样呢？', face: '06' },
        ] },
        { favor: 3, text: [
          { text: '我想，我能不能更多了解小哥您一些呢？毕竟……我…我…呜…有点害羞……说不出来……', face: ['03', 'a1'] },
          { text: '诶？可以吗……嘿嘿～小哥你真的很温柔呢～', face: ['01', 'a1'] },
          { text: '那以后找个机会一起出去一趟吧～我想听听关于小哥你的事情～', face: '07' },
        ] },
        { favor: 3, text: [
          { text: '最近，在面对小哥你的时候……已经不会走神和瞌睡了呢……', face: '02' },
          { text: '可能是因为，小哥你的缘故吧……毕竟，我已经……喜，喜欢上你了嘛……', face: ['03', 'a1'] },
          { text: '呜呜…果然，直接说出来还是好害羞啊……', face: '02' },
        ] },
      ]
    }, {
      id: '和艾露聊天',
      actor: 'ere',
      texts: [
        { favor: 1, text: [
          { text: '能和前辈再次相遇，艾露真的很开心哦。', face: '02' },
          { text: '前辈也是和以前一样，一点都没有改变呢。', face: '06' },
          { text: '艾露会记住和前辈相处的每一个瞬间的。', face: ['06', 'a4'] },
        ] },
        { favor: 1, text: [
          { text: '话说，前辈最近在干什么呢？便利店的员工吗？', face: '08' },
          { text: '以前辈的才华，不应该连工作都找不到吧？', face: '04' },
          { text: '黑心公司吗……原来还发生了这种事啊……真是令人气愤呢。', face: '03' },
        ] },
        { favor: 1, text: [
          { text: '前辈似乎还有个妹妹来着，能介绍给我认识一下吗？', face: '06' },
          { text: '听说……她和你没有血缘关系，还住在前辈的家里，是真的吗？', face: '01' },
          { text: '这样啊…女孩子吗…要不要我也过去住呢…？开玩笑的～', face: '06' },
        ] },
        { favor: 2, text: [
          { text: '前辈，最近你有时间吗？艾露想和你一起出去约个会什么的。', face: '08' },
          { text: '不会干什么的哦，就是吃个饭，看个电影，顺带开个房什么的～♡', face: '02' },
          { text: '……前辈不会拒绝艾露的…诶，今天刚好没空吗？', face: '07' },
        ] },
        { favor: 2, text: [
          { text: '前辈啊，你身边的女孩子真的很多呢，稍微保持点距离会比较好哦～', face: '08' },
          { text: '毕竟，如果距离太近的话，艾露可是会伤心的……到时候会发生什么，艾露可不确定哦～', face: ['06', 'a2'] },
          { text: '嘿嘿～♡前辈的身边只需要有艾露在就好了，对吧？', face: ['06', 'a4'] },
        ] },
        { favor: 2, text: [
          { text: '前辈和妹妹的关系真好啊……稍微有点好过头了呢……', face: '06' },
          { text: '毕竟，正常的哥哥是不会在三更半夜跑进妹妹的房间干涩涩的事情的，对吧？', face: '06' },
          { text: '艾露是怎么知道的？这是秘密哦～前辈也知道，所谓秘密，就是不能随意公之于众的事情……对吧～♡', face: ['06', 'a2'] },
        ] },
        { favor: 3, text: [
          { text: '前辈～♡艾露小姐很想你哦～♡有空多陪陪艾露好不好嘛～♡', face: '06' },
          { text: '艾露的房间随时为你开放哦～♡只要你愿意，我们现在就可以去共享二人世界～♡' },
          { text: '不行吗？呜……前辈真会吊人性子～♡', face: ['07', 'a4'] },
        ] },
        { favor: 3, text: [
          { text: '艾露现在已经不会因为前辈身边的女孩子吃醋了呢，不是艾露不爱前辈了哦～♡', face: '08' },
          { text: '只是稍微想想，喜欢前辈的女孩子越多，就证明前辈约优秀。', face: ['08', 'a4'] },
          { text: '艾露喜欢的前辈本来就是一个优秀的男人，所以女人多也是很正常的呢。', face: '07' },
        ] },
        { favor: 3, text: [
          { text: '就目前的形势来看，和前辈最亲密的果然还是妹妹酱啊……', face: '04' },
          { text: '呜呜呜……天降青梅什么的还是太过分了啦！不过艾露可不会这么轻易认输哦！', face: '07' },
          { text: '反正前辈也是色鬼呢！事不宜迟，我们赶紧做爱吧前辈！哎呀……疼……QAQ', face: ['07', 'a3'] },
        ] },
      ]
    }, 
    // 冒险相关
    {
      id: '遭遇怪物',
      texts: [
        { text: '一只$1挡住了去路。你下意识将$2护在身后，她的气息轻拂在你的身后。' },
        { text: '你们与$1不期而遇。$2惊呼一声，柔软的乳房紧贴着你的后背。' },
        { text: '空气中弥漫开$1的野性气息令你如临大敌，但$2的气息令你安心了不少。' },
        { text: '危险！是$1！$2害怕地攥紧了你的手，她似乎在颤抖。' },
        { text: '从灌木丛钻出来了一只$1！你迅速将$2揽入怀中，感受着她的体温，你充满了勇气。' },
      ]
    }, {
      id: '逃离成功',
      texts: [
        { text: '一场果断的冲刺逃离$1，你们成功逃脱。$2庆幸的抚慰着自己的胸口，汗水浸湿了她的衣物。' },
        { text: '你们飞快地跑远了，$1并未继续追赶。$2紧抓着你的衣角，身体依旧在颤抖。' },
        { text: '你们成功甩开了$1。停下后，$2紧抓着你的手臂，依偎在你的身旁寻找安全感。' },
        { text: '一阵亡命飞奔，你们终于安全。她靠在你背上，她的气息萦绕在你的鼻腔，你有些兴奋起来了。' },
        { text: '身后的$1的气息消失了。$2松开你的衣角，手心满是黏腻的汗水，脸上却露出了安心的笑容。' },
      ]
    }, {
      id: '逃离失败',
      texts: [
        { text: '面对$1漫长的追逐耗尽了你们的体力，直到它离开，你们才终于得以逃跑。' },
        { text: '面对$1狼狈的奔逃中，$2的裙角被树枝划破。但为了求生，她也只能强忍着羞耻，在你的怀里躲过一劫。' },
        { text: '逃跑过程远比想象的更艰难。你们摔作一团才躲过追击，$2的身体紧贴着你，也不知是幸运还是不幸。' },
        { text: '直到体力耗尽，$1才放弃追赶。你搀扶着几乎脱力的$2，安抚着她惊魂未定的情绪。' },
        { text: '这次面对$1的逃亡狼狈不堪。你的腿上被划伤，$2心疼的用手帕为你擦拭，在她的眼中，你感受到了交换劫后余生的喜悦。' },
      ]
    }, {
      id: '威慑成功',
      texts: [
        { text: '你的怒吼震慑住了$1。转过头，你看到$2眼中闪烁着异样的光彩，既有崇拜，也有几分不可思议。' },
        { text: '$1竟真的被你们吓跑了！危机解除后，她露出庆幸的表情与你相视一笑。' },
        { text: '威慑成功！你们相视一笑，紧绷的气氛瞬间瓦解。她紧紧的抱住了你，眼中闪着劫后余生的泪花。' },
        { text: '你的威慑成功吓退了$1。$2欣喜雀跃，在你的脸上亲了一口，意识到自己的行为后又害羞了起来。' },
        { text: '你们的镇定自若竟真的奏效了！$1危机解除后，$2对你刮目相看，微红的脸颊中裹挟着几分暧昧。' },
      ]
    }, {
      id: '威慑失败',
      texts: [
        { text: '威慑彻底激怒了对方，你们被迫开始了更加狼狈的逃亡。' },
        { text: '威慑失败！被惹怒的$1向你们扑来，你只能抱着$2就地一滚，悻悻逃走。' },
        { text: '叫声彻底激怒了$1！你来不及多想，抱起因害怕而无法动弹的$2仓惶而逃。' },
        { text: '威慑失败，反而招来更猛烈的攻击。你带着被吓傻的她躲在了草丛中，感受着$2的颤抖与体温，直到$1彻底离开后你们才敢逃走。' },
        { text: '你的吼声像个笑话，$1猛冲过来。你只能急中生智，让其撞晕在树墩上，随后带着$2仓惶离开。' },
      ]
    }, {
      id: '安抚成功',
      texts: [
        { text: '你的善意似乎传达到了，$1安静地离去。身后传来$2如释重负的轻柔吐息。' },
        { text: '安抚$1成功了。$2一直紧攥着你手臂的手终于放松，而那份柔软的触感却还遗留在你的心中。' },
        { text: '你的善意被接收，$1悄然退去。她紧绷的身体终于放松，胸口的起伏也逐渐平息下来。' },
        { text: '安抚成功了。$1离开了这里，而$2紧紧的抱住了你，没有说话，似乎在向你渴求安慰。' },
        { text: '$1带着一丝困惑离开了。你们在原地站了许久，庆幸$1的通情达理，也在自己的劫后余生。' },
      ]
    }, {
      id: '安抚失败',
      texts: [
        { text: '你的善意被当成了软弱，$1变得更具攻击性，你们只能仓惶逃窜。' },
        { text: '安抚$1失败！恐惧令你们狼狈的逃跑，直到身后的脚步声消失，你们才敢停下歇息。' },
        { text: '安抚失败了，$1突然发起攻击，你闪避不即受伤了，直到一切平息之后，她才能心疼的为你包扎伤口。' },
        { text: '你的示好被当成了挑衅。你只能迅速将她护在身后，想方设法逃离了对方的追捕。' },
        { text: '它似乎更愤怒了。你只能带着$2爬到树上，等待着对方的离开，在彻底安全之前，她都蜷缩在你的怀里不停的颤抖。' },
      ]
    }, {
      id: '落入陷阱',
      texts: [
      ]
    },
    
  ];

  /** 对话列表工具类 */
  class Utils_ChatMessage {
    static getActorName(actor) {
      if (actor === 'actor') {
        return $gameActors.actor(1).name();
      } else if (actor === 'kana') {
        return '加奈';
      } else if (actor === 'chinatsu') {
        return '千夏';
      } else if (actor === 'yuki') {
        return '由纪';
      }
    }
    /** 获取对话 */
    static getChat(id, params = []) {
      const _chatInfo = __chatList.find(i => i.id === id);

      if (!_chatInfo) throw new Error(`找不到对话：${id}`);

      if (params && typeof params === 'string') params = [params];

      const _obj = {};
      const _list = [];
      let _mood = '';
      let _favorLevel = '';
      
      // 获取角色信息
      _obj.actor = _chatInfo.actor;
      if (_chatInfo.actor === 'kana') {
        _obj.name = '加奈';
        _favorLevel = Utils_Favor.kanaFavorLevel;
        _mood = Utils_Favor.kanaMood;
      } else if (_chatInfo.actor === 'chinatsu') {
        _obj.name = '千夏';
        _favorLevel = Utils_Favor.chinatsuFavorLevel;
      } else if (_chatInfo.actor === 'yuki') {
        _obj.name = '由纪';
        _favorLevel = Utils_Favor.yukiFavorLevel;
      } else if (_chatInfo.actor === 'ere') {
        _obj.name = '艾露';
        _favorLevel = Utils_Favor.ereFavorLevel;
      }
      
      // 循环筛选
      for (let i = 0; i < _chatInfo.texts.length; i++) {
        const _item = _chatInfo.texts[i];
        if (_item.mood && _item.mood !== _mood) continue;
        if (_item.favor && _item.favor !== _favorLevel) continue;
        _list.push(_item);
      }
      const _re = _list[Math.floor(Math.random() * _list.length)];

      // 找不到符合条件的
      if (!_re) {
        throw new Error(`找不到符合条件的对话："${id}"，心情：${_mood}，好感度级别：${_favorLevel}`);
      }

      if (Array.isArray(_re.text)) {
        return _re.text.map(i => {
          const _face = i.face || _obj.face;
          const _actor = i.actor || _obj.actor;
          const _name = Utils_ChatMessage.getActorName(_actor);
          return {
            text: params ? TranslateUtils.getText(i.text, params) : i.text,
            face: _face && (typeof _face === 'string') ? [_face] : _face,
            name: _name || _obj.name,
            actor: i.actor || _obj.actor,
          };
        });
      } else {
        _re.name = _obj.name;
        _re.actor = _obj.actor;
        // 表情从字符串转数组
        if (_re.face && (typeof _re.face === 'string')) {
          _re.face = [_re.face];
        }
        if (params) {
          _re.text = TranslateUtils.getText(_re.text, params);
        }
        return [_re];
      }
    }
  }
  window.Utils_ChatMessage = Utils_ChatMessage;

})();