//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Favor.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 鼠标光标插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】鼠标光标插件。
 * 
 */
// #endregion
(() => {
  const _cursorDom = document.getElementById('sys-cursor');
  if (!_cursorDom) {
    const Utils_Cursor = {
      mouseX: 0,
      mouseY: 0,
      cursorType: ''
    }
    window.Utils_Cursor = Utils_Cursor;
    return;
  }


  const Scene_initialize = Scene_Base.prototype.initialize;
  Scene_Base.prototype.initialize = function () {
    Scene_initialize.call(this);

    // 切换光标
    cursorModule.cursorType = 'default';
  };

  Window_Selectable.prototype.onTouchSelect = function (trigger) {
    this._doubleTouch = false;
    if (this.isCursorMovable() && this.inArea(TouchInput.x, TouchInput.y)) {
      const lastIndex = this.index();
      const hitIndex = this.hitIndex();
      if (hitIndex >= 0) {
        if (hitIndex === this.index()) {
          this._doubleTouch = true;
        }
        this.select(hitIndex);
        cursorModule.cursorType = 'pointer';
      } else {
        cursorModule.cursorType = 'default';
      }
      if (trigger && this.index() !== lastIndex) {
        this.playCursorSound();
      }
    }
  };

  // 获取 NW.js 窗口对象
  let win = undefined;
  if (typeof nw === "object" && nw.Window && nw.Window.get && Utils.isNwjs()) {
    win = nw.Window.get();
  }

  window.addEventListener('error', function (event) {
    cursorModule.hasError = true;

    _cursorDom.style.display = 'none';
    
    if (win) win.cursor = 'default';
    document.body.style.cursor = 'default';
    document.documentElement.style.cursor = 'default';
    _cursorDom.style.cursor = 'default';
  });

  const cursorModule = {
    /** 是否有错误信息 */
    hasError: false,
    _cursorType: 'default',
    /** 光标类型 @type {'default'|'disabled'|'pointer'|'hand'} */
    get cursorType() {
      return this._cursorType;
    },
    set cursorType(value) {
      if (value !== this._cursorType) {
        _cursorDom.classList.remove('cursor-' + this._cursorType);
        _cursorDom.classList.add('cursor-' + value);
        this._cursorType = value;
      }
    },
    _mouseX: 0,
    /** 光标X坐标 */
    get mouseX() {
      return this._mouseX;
    },
    set mouseX(value) {
      if (value !== this._mouseX) {
        this._mouseX = value;
        _cursorDom.style.left = `${value}px`;
      }
    },
    _mouseY: 0,
    get mouseY() {
      return this._mouseY;
    },
    set mouseY(value) {
      if (value !== this._mouseY) {
        this._mouseY = value;
        _cursorDom.style.top = `${value}px`;
      }
    },
    _isInWindow: true,
    /** 光标是否在窗口中 */
    get isInWindow() {
      return this._isInWindow;
    },
    set isInWindow(value) {
      if (value !== this._isInWindow) {
        this._isInWindow = value;
        this.toggleSysCursor(value);
      }
    },
    toggleSysCursor(isHide = true) {
      if (isHide && !cursorModule.hasError) {
        _cursorDom.classList.add('block');
        _cursorDom.classList.remove('none');

        // win.cursor = 'default';
        // document.body.style.cursor = 'default';
        // document.documentElement.style.cursor = 'default';
        // _cursorDom.style.cursor = 'default';
        // setTimeout(() => {
          if (win) win.cursor = 'none';
          document.body.style.cursor = 'none';
          document.documentElement.style.cursor = 'none';
          _cursorDom.style.cursor = 'none';
        // }, 50);
      } else {
        _cursorDom.classList.add('none');
        _cursorDom.classList.remove('block');
        // win.cursor = 'none';
        // document.body.style.cursor = 'none';
        // document.documentElement.style.cursor = 'none';
        // _cursorDom.style.cursor = 'none';
        // setTimeout(() => {
          if (win) win.cursor = 'default';
          document.body.style.cursor = 'default';
          document.documentElement.style.cursor = 'default';
          _cursorDom.style.cursor = 'default';
        // }, 50);
      }
    }
  };


  if (win && win.on && (typeof win.on === 'function')) {
    win.on('focus', function() {
      if (!cursorModule.hasError) {
        win.cursor = 'default';
        document.body.style.cursor = 'default';
        document.documentElement.style.cursor = 'default';
        _cursorDom.style.cursor = 'default';
        setTimeout(() => {
          win.cursor = 'none';
          document.body.style.cursor = 'none';
          document.documentElement.style.cursor = 'none';
          _cursorDom.style.cursor = 'none';
        }, 50);
      }
    });
    win.on('blur', function() {
      if (!cursorModule.hasError) {
        win.cursor = 'default';
        document.body.style.cursor = 'default';
        document.documentElement.style.cursor = 'default';
        _cursorDom.style.cursor = 'default';
        setTimeout(() => {
          win.cursor = 'none';
          document.body.style.cursor = 'none';
          document.documentElement.style.cursor = 'none';
          _cursorDom.style.cursor = 'none';
        }, 50);
      }
    });
  }
  // document.addEventListener('focus', function (event) {
  //   cursorModule.isFocused = false;
  //   setTimeout(() => {
  //     cursorModule.isFocused = true;
  //   }, 30);
  // });
  // document.addEventListener('blur', function (event) {
  //   // cursorModule.isFocused = false;
  // });

  document.addEventListener('touchstart', function (e) {
    cursorModule.isInWindow = false;
  });
  document.addEventListener('pointerleave', function (e) {
    if (e.pageX < 0 || e.pageY < 0 || e.pageX >= window.innerWidth || e.pageY >= window.innerHeight) {
      cursorModule.isInWindow = false;
    }
  });
  document.addEventListener('pointerenter', function (e) {
    if (!cursorModule.isInWindow) {
      cursorModule.isInWindow = true;
    }
  });
  document.addEventListener('pointermove', (e) => {
    if (cursorModule.isInWindow) {
      cursorModule.isInWindow = true;
      const _x = e.clientX;
      const _y = e.clientY;

      cursorModule.mouseX = _x;
      cursorModule.mouseY = _y;
    }
  });

  let _prevIsInWindow = false;

  const callback = () => {
    setTimeout(() => {
      callback();
    }, 100);

    if (cursorModule.isInWindow) {
      cursorModule.toggleSysCursor(true);
    } else {
      cursorModule.toggleSysCursor(false);
    }
  };

  try {
    callback();

    setTimeout(() => {
      if (window.top.document.hasFocus()) {
        cursorModule._isInWindow = false;
        cursorModule.isInWindow = true;
      }
    }, 500);
  } catch (error) {}

  /**
   * 光标工具类
   */
  class Utils_Cursor {
    /** 鼠标X坐标 */
    static get mouseX() {
      return cursorModule.mouseX;
    }
    static set mouseX(value) {
      cursorModule.mouseX = value;
    }
    /** 鼠标Y坐标 */
    static get mouseY() {
      return cursorModule.mouseY;
    }
    static set mouseY(value) {
      cursorModule.mouseY = value;
    }
    /** 光标类型 */
    static get cursorType() {
      return cursorModule.cursorType;
    }
    static set cursorType(value) {
      cursorModule.cursorType = value;
    }
  }
  window.Utils_Cursor = Utils_Cursor;

})();