//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Effect.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 特殊特效插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】特殊特效相关插件。
 * 
 * 
 * @command startEntranceEffect
 * @text 开始播放第一次的出场特效
 * @desc 开始播放第一次的出场特效
 * 
 * @arg actor
 * @text 出场角色
 * @type select
 * @option 加奈
 * @value kana
 * @option 千夏
 * @value chinatsu
 * @option 由纪
 * @value yuki
 * @option 艾露
 * @value ere
 * @default kana
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command endEntranceEffect
 * @text 结束播放第一次的出场特效
 * @desc 结束播放第一次的出场特效
 * 
 * @arg actor
 * @text 出场角色
 * @type select
 * @option 加奈
 * @value kana
 * @option 千夏
 * @value chinatsu
 * @option 由纪
 * @value yuki
 * @option 艾露
 * @value ere
 * @default kana
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command backgroundRippleEffect
 * @text 背景图波纹扩散特效
 * @desc 背景图波纹扩散特效
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command foregroundRippleEffect
 * @text 前景图波纹扩散特效
 * @desc 前景图波纹扩散特效
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command pictureRippleEffect
 * @text 图片多重波纹扩散特效
 * @desc 图片多重波纹扩散特效
 * 
 * @arg index
 * @text 图片索引
 * @desc 图片索引
 * @type number
 * @default 1
 * @min 1
 * @max 50
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @option 等待
 * @value true
 * @option 不等待
 * @value false
 * @default true
 * 
 * 
 */
// #endregion
(() => {

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Module_Effect";
  
  const typeDefine = {
  };
  // #endregion

  // #region 插件参数

  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);

  /** 特效表 */
  const effectMap = {
    /** 加奈出场特效 */
    kanaEntrance: {
      duration: 80,
      cache: {},
      prepare(callback, container) {
        Promise.all([
          ImageManager.loadImg('actor/kana/entrance/bg'),
          ImageManager.loadImg('actor/kana/entrance/top_bar'),
          ImageManager.loadImg('actor/kana/entrance/bottom_bar'),
          ImageManager.loadImg('actor/kana/entrance/tachie'),
          ImageManager.loadImg('actor/kana/entrance/title'),
        ]).then(imgs => {
          this.cache.bg = new Sprite(imgs[0]);
          this.cache.bg.alpha = 0;
          container.addChild(this.cache.bg);

          this.cache.top_bar = new Sprite(imgs[1]);
          this.cache.top_bar.alpha = 0;
          container.addChild(this.cache.top_bar);

          this.cache.bottom_bar = new Sprite(imgs[2]);
          this.cache.bottom_bar.alpha = 0;
          this.cache.bottom_bar.y = Graphics.height - this.cache.bottom_bar.height;
          container.addChild(this.cache.bottom_bar);
          
          this.cache.tachie = new Sprite(imgs[3]);
          this.cache.tachie.alpha = 0;
          this.cache.tachie.y = 100;
          container.addChild(this.cache.tachie);
          
          this.cache.title = new Sprite(imgs[4]);
          this.cache.title.alpha = 0;
          this.cache.title.y = 220;
          container.addChild(this.cache.title);
          
          callback(imgs);
        })
      },
      start(container, progress, frameIndex) {
        if (frameIndex >= 40 && frameIndex < 80) {
          this.cache.bg.alpha = (frameIndex - 40) / 40;
        }

        if (frameIndex >= 0 && frameIndex < 20) {
          this.cache.top_bar.x = frameIndex * 5 - 100;
          this.cache.top_bar.alpha = frameIndex / 20;
        }
        if (frameIndex >= 20 && frameIndex < 40) {
          this.cache.bottom_bar.x = 100 - frameIndex * 5;
          this.cache.bottom_bar.alpha = (frameIndex - 20) / 20;
        }
        if (frameIndex >= 40 && frameIndex < 60) {
          this.cache.tachie.x = 100 + (frameIndex - 40) * 5;
          this.cache.tachie.alpha = (frameIndex - 40) / 20;
        }
        if (frameIndex >= 60 && frameIndex < 80) {
          this.cache.title.x = 700 - (frameIndex - 60) * 5;
          this.cache.title.alpha = (frameIndex - 60) / 20;
        }
      },
      end(container, progress, frameIndex) {
        if (frameIndex >= 40 && frameIndex < 80) {
          this.cache.bg.alpha = (80 - frameIndex) / 40;
        }

        if (frameIndex >= 0 && frameIndex < 20) {
          this.cache.top_bar.x = -frameIndex * 5;
          this.cache.top_bar.alpha = (1 - frameIndex / 20);
        }
        if (frameIndex >= 20 && frameIndex < 40) {
          this.cache.bottom_bar.x = (frameIndex - 20) * 5;
          this.cache.bottom_bar.alpha = (1 - (frameIndex - 20) / 20);
        }
        if (frameIndex >= 40 && frameIndex < 60) {
          this.cache.tachie.x = 200 - (frameIndex - 40) * 5;
          this.cache.tachie.alpha = (1 - (frameIndex - 40) / 20);
        }
        if (frameIndex >= 60 && frameIndex < 80) {
          this.cache.title.x = 600 + (frameIndex - 60) * 5;
          this.cache.title.alpha = (1 - (frameIndex - 60) / 20);
        }
      },
    },
    /** 千夏出场特效 */
    chinatsuEntrance: {
      duration: 80,
      cache: {},
      prepare(callback, container) {
        Promise.all([
          ImageManager.loadImg('actor/chinatsu/entrance/bg'),
          ImageManager.loadImg('actor/chinatsu/entrance/top_bar'),
          ImageManager.loadImg('actor/chinatsu/entrance/bottom_bar'),
          ImageManager.loadImg('actor/chinatsu/entrance/tachie'),
          ImageManager.loadImg('actor/chinatsu/entrance/title_zh-CN'),
        ]).then(imgs => {
          this.cache.bg = new Sprite(imgs[0]);
          this.cache.bg.alpha = 0;
          container.addChild(this.cache.bg);

          this.cache.top_bar = new Sprite(imgs[1]);
          this.cache.top_bar.alpha = 0;
          container.addChild(this.cache.top_bar);

          this.cache.bottom_bar = new Sprite(imgs[2]);
          this.cache.bottom_bar.alpha = 0;
          this.cache.bottom_bar.y = Graphics.height - this.cache.bottom_bar.height;
          container.addChild(this.cache.bottom_bar);
          
          this.cache.tachie = new Sprite(imgs[3]);
          this.cache.tachie.alpha = 0;
          this.cache.tachie.y = 100;
          container.addChild(this.cache.tachie);
          
          this.cache.title = new Sprite(imgs[4]);
          this.cache.title.alpha = 0;
          this.cache.title.y = 220;
          container.addChild(this.cache.title);
          
          callback(imgs);
        })
      },
      start(container, progress, frameIndex) {
        if (frameIndex >= 40 && frameIndex < 80) {
          this.cache.bg.alpha = (frameIndex - 40) / 40;
        }

        if (frameIndex >= 0 && frameIndex < 20) {
          this.cache.top_bar.x = frameIndex * 5 - 100;
          this.cache.top_bar.alpha = frameIndex / 20;
        }
        if (frameIndex >= 20 && frameIndex < 40) {
          this.cache.bottom_bar.x = 100 - frameIndex * 5;
          this.cache.bottom_bar.alpha = (frameIndex - 20) / 20;
        }
        if (frameIndex >= 40 && frameIndex < 60) {
          this.cache.tachie.x = -20 + (frameIndex - 40) * 5;
          this.cache.tachie.alpha = (frameIndex - 40) / 20;
        }
        if (frameIndex >= 60 && frameIndex < 80) {
          this.cache.title.x = 580 - (frameIndex - 60) * 5;
          this.cache.title.alpha = (frameIndex - 60) / 20;
        }
      },
      end(container, progress, frameIndex) {
        if (frameIndex >= 40 && frameIndex < 80) {
          this.cache.bg.alpha = (80 - frameIndex) / 40;
        }

        if (frameIndex >= 0 && frameIndex < 20) {
          this.cache.top_bar.x = -frameIndex * 5;
          this.cache.top_bar.alpha = (1 - frameIndex / 20);
        }
        if (frameIndex >= 20 && frameIndex < 40) {
          this.cache.bottom_bar.x = (frameIndex - 20) * 5;
          this.cache.bottom_bar.alpha = (1 - (frameIndex - 20) / 20);
        }
        if (frameIndex >= 40 && frameIndex < 60) {
          this.cache.tachie.x = 80 - (frameIndex - 39) * 5;
          this.cache.tachie.alpha = (1 - (frameIndex - 40) / 20);
        }
        if (frameIndex >= 60 && frameIndex < 80) {
          this.cache.title.x = 480 + (frameIndex - 59) * 5;
          this.cache.title.alpha = (1 - (frameIndex - 60) / 20);
        }
      },
    },
    /** 图片多重波纹扩散特效 */
    imageRipple: {
      duration: 50,
      cache: {},
      prepare(callback, container, { type, index = 0, count = 2, hue = false }) {
        const _scene = SceneManager._scene;
        const _bgList = [];
        
        container.x = Graphics.width / 2;
        container.y = Graphics.height / 2;

        if (type === 'picture') {
          const _picture = SceneManager._scene._pictureContainer.children[index];
          
          _picture.addChild(container);

          for (let o = 1; o <= count; o++) {
            this.cache[`l${o}`] = new PIXI.Container();
            const _sprite = new Sprite(_picture.bitmap);
            if (hue && !isNaN(hue)) {
              _sprite.filters = [new PIXI.filters.ColorMatrixFilter()];
              _sprite.filters[0].hue.call(_sprite.filters[0], hue);
              _sprite._refresh();
            }
            _sprite.x = _picture.x;
            _sprite.y = _picture.y;
            _sprite.anchor.set(0.5, 0.5);
            this.cache[`l${o}`].addChild(_sprite);
            container.addChild(this.cache[`l${o}`]);
          }
          
          callback([_picture]);
        } else {
          if (type === 'backgroundAndForeground' || type === 'background') {
            _scene.gameBackground.addChild(container);
            if ($gameData.tempBackground) {
              if (typeof $gameData.tempBackground === 'string') {
                _bgList.push($gameData.tempBackground);
              } else if (Array.isArray($gameData.tempBackground)) {
                _bgList.splice(0, 0, $gameData.tempBackground);
              }
            } else {
              if (typeof _scene.sceneInfo.background === 'string') {
                _bgList.push(_scene.sceneInfo.background);
              } else if (Array.isArray(_scene.sceneInfo.background)) {
                _bgList.splice(0, 0, _scene.sceneInfo.background);
              }
            }
          }
          
          if (type === 'backgroundAndForeground' || type === 'foreground') {
            _scene.gameForeground.addChild(container);
            if ($gameData.tempForeground) {
              if (typeof $gameData.tempForeground === 'string') {
                _bgList.push($gameData.tempForeground);
              } else if (Array.isArray($gameData.tempForeground)) {
                _bgList.splice(0, 0, $gameData.tempForeground);
              }
            } else {
              if (typeof _scene.sceneInfo.foreground === 'string') {
                _bgList.push(_scene.sceneInfo.foreground);
              } else if (Array.isArray(_scene.sceneInfo.foreground)) {
                _bgList.splice(0, 0, _scene.sceneInfo.foreground);
              }
            }
          }

          Promise.all(_bgList.map(src => ImageManager.loadImg(src))).then(imgs => {
            for (let o = 1; o <= count; o++) {
              this.cache[`l${o}`] = new PIXI.Container();
              for (let i = 0; i < imgs.length; i++) {
                const img = imgs[i];
                const _sprite = new Sprite(img);
                if (hue && !isNaN(hue)) {
                  _sprite.filters = [new PIXI.filters.ColorMatrixFilter()];
                  _sprite.filters[0].hue.call(_sprite.filters[0], hue);
                  _sprite._refresh();
                }
                _sprite.anchor.set(0.5, 0.5);
                this.cache[`l${o}`].addChild(_sprite);
              }
              container.addChild(this.cache[`l${o}`]);
            }
            
            callback(imgs);
          });
        }

      },
      start(container, progress, frameIndex, { count = 2, hue = false }) {
        const _scale = 0.15;

        for (let o = 1; o <= count; o++) {
          const _delay = (o - 1) * 13;
          if (frameIndex >= _delay && frameIndex <= 30 + _delay) {
            const _progress = (frameIndex - _delay) / 30;
            this.cache[`l${count + 1 - o}`].scale.set(1 + _progress * _scale, 1 + _progress * _scale);
            this.cache[`l${count + 1 - o}`].alpha = 1 - _progress;
          }
        }
      },
      end(container) {
      }
    },
    /** 图片哈气扩散 */
    imageHalitus: {
      duration: 100,
      cache: {},
      prepare(callback, container, { index = 0, hue = false }) {
        // const _scene = SceneManager._scene;
        // _scene.gameBackground.addChild(container);
        
        // const _picture = SceneManager._scene._pictureContainer.children[index];
        
        // this.cache[`l${o}`] = new PIXI.Container();
        // const _sprite = new Sprite(_picture.bitmap);

        // _sprite.x = _picture.x;
        // _sprite.y = _picture.y;
        // _sprite.anchor.set(0.5, 0.5);

        const _pic = $gameScreen.picture(index);
        _pic.move(1, _pic._x, _pic._y, _pic._scaleX, _pic._scaleY, _pic._opacity, _pic._blendMode, 100, 1);
        // _pic._origin = 1;
        // _pic._targetOpacity = 0;
        // _pic._duration = 0;
        
        // const _scale = (1 + progress * 0.4) * 100;

        // _pic._targetScaleX = 150;
        // _pic._targetScaleY = 150;
        
        // _pic._targetOpacity = 0;
        // _pic._duration = 100;

        // this.cache.picture = _pic;

        callback();
      },
      start(container, progress, frameIndex, { hue = false }) {
        // const _pic = this.cache.picture;

        // if (frameIndex >= 20) {
        //   _pic._targetOpacity = progress * 2 * 255;
        // } else {
        //   _pic._targetOpacity = (1 - (progress - 0.5) * 2) * 255;
        // }
        // _pic._duration = 0;
      },
      end(container) {
      }
    }
  };
  
  const specialEffectModule = {
    /**
     * 开始特效
     * @param {string} name 特效名称
     * @param {object} config 参数
     * @param {Function} callback 回调函数
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    startEffect(name, config, callback, interpreter) {
      if (config.isWait === undefined) config.isWait = true;

      const _effect = effectMap[name];
      if (_effect.cache.isStart) {
        console.warn(`特效 ${name} 已经开始播放`);
        return;
      }
      _effect.cache.isStart = true;
      const _container = new PIXI.Container();
      _effect.cache.container = _container;
      SceneManager._scene.addChild(_container);
      
      if (interpreter && config.isWait && interpreter.wait) interpreter.wait(_effect.duration);
      
      const _start = () => {
        useTimeout(() => {
          callback && callback();
        }, _effect.duration, (progress, frameIndex) => {
          _effect.start.call(_effect, _container, progress, frameIndex, config);
        });
      };

      if (_effect.prepare) {
        _effect.prepare.call(_effect, _start, _container, config);
      } else {
        _start();
      }
    },
    /**
     * 结束特效
     * @param {string} name 特效名称
     * @param {object} config 参数
     * @param {Function} callback 回调函数
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    endEffect(name, config, callback, interpreter) {
      if (config.isWait === undefined) config.isWait = true;

      const _effect = effectMap[name];
      if (interpreter && config.isWait) interpreter.wait(_effect.duration);
      
      useTimeout(() => {
        _effect.cache.container.destroy();
        _effect.cache = {};
        _effect.cache.isStart = false;
        callback && callback();
      }, _effect.duration, (progress, frameIndex) => {
        _effect.end.call(_effect, _effect.cache.container, progress, frameIndex, config);
      });
    }
  };


  class Utils_Effect {
    /** 开始出场特效 */
    static startEntranceEffect(actor) {
      specialEffectModule.startEffect(actor + 'Entrance', {}, () => {}, this);
    }
    /** 结束出场特效 */
    static endEntranceEffect(actor) {
      specialEffectModule.endEffect(actor + 'Entrance', {}, () => {}, this);
    }
    /** 背景图扩散特效 */
    static backgroundRippleEffect() {
      specialEffectModule.startEffect('imageRipple', {
        type: 'background'
      }, () => {
        specialEffectModule.endEffect('imageRipple', {
          type: 'background'
        });
      }, this);
    }
    /** 前景图扩散特效 */
    static foregroundRippleEffect() {
      specialEffectModule.startEffect('imageRipple', {
        type: 'foreground'
      }, () => {
        specialEffectModule.endEffect('imageRipple', {
          type: 'foreground'
        });
      }, this);
    }
    /** 图片多重波纹扩散特效 */
    static pictureRippleEffect({ index }) {
      specialEffectModule.startEffect('imageRipple', {
        type: 'picture',
        index: index || 0
      }, () => {
        specialEffectModule.endEffect('imageRipple', {
          type: 'picture',
          index: index || 0
        });
      }, this);
    }
    
    /** 图片哈气扩散 */
    // static imageHalitusEffect({ index }) {
    //   specialEffectModule.startEffect('imageHalitus', { index: index || 0 }, () => {
    //     specialEffectModule.endEffect('imageHalitus', { index: index || 0 });
    //   });
    // }
  }
  window.Utils_Effect = Utils_Effect;


  if (Utils.RPGMAKER_NAME === "MZ") {
    PluginManager.registerCommand(PluginName, 'startEntranceEffect', function(args) {
      Utils_Effect.startEntranceEffect.call(this, args.actor);
    });
    PluginManager.registerCommand(PluginName, 'endEntranceEffect', function(args) {
      Utils_Effect.endEntranceEffect.call(this, args.actor);
    });
    PluginManager.registerCommand(PluginName, 'backgroundRippleEffect', function(args) {
      Utils_Effect.backgroundRippleEffect.call(this);
    });
    PluginManager.registerCommand(PluginName, 'foregroundRippleEffect', function(args) {
      Utils_Effect.foregroundRippleEffect.call(this);
    });
    PluginManager.registerCommand(PluginName, 'pictureRippleEffect', function(args) {
      Utils_Effect.pictureRippleEffect.call(this, { index: parseInt(args.index) - 1 });
    });


    // PluginManager.registerCommand(PluginName, 'imageHalitusEffect', function(args) {
    //   Utils_Effect.imageHalitusEffect({ index: parseInt(args.index) - 1 });
    // });
    
    // * 
    // * @command imageHalitusEffect
    // * @text 图片哈气特效
    // * @desc 图片哈气特效
    // * 
    // * @arg index
    // * @text 图片索引
    // * @desc 图片索引
    // * @type number
    // * @default 1
    // * @min 1
    // * @max 50
    
  }

})();