//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Event.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 集成事件插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】集成事件插件。
 * 
 * 
 * @command endEvent
 * @text 结束事件
 * @desc 结束当前事件
 * 
 */
// #endregion

(() => {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Module_Event";

  /** 
   * @typedef NormalEventItem 标准事件对象
   * @property {number} id 事件ID
   * @property {number?} day 具体天数
   * @property {number?} start_day 开始天数
   * @property {number?} end_day 结束天数
   * @property {number?} start_hour 开始时间（时）
   * @property {number?} end_hour 开始时间（时）
   * @property {number?} start_minute 开始时间（分）
   * @property {number?} end_minute 开始时间（分）.
   * @property {'daytime'|'dusk'|'night'|undefined} time_span 开始时间段
   * @property {string} place 事件发生地点
   * @property {boolean} force_move 是否强制移动
   * @property {string} name 事件名称
   * @property {string} desc 事件描述
   * @property {number} [repeatCount=1] 允许重复次数（大于一则为可重复发生事件）
   * @property {boolean} [is_quick=false] 是否为快速事件（即触发后立即结束）
   * @property {number} [next_event] 快速事件的下一个事件ID
   * @property {()=>void} [exec] 事件执行函数
   * @property {boolean} [repeatAtDay=true] 是否允许每天重复
   * @property {number} common_event 通用事件ID
   * @property {()=>boolean} [condition] 触发条件函数，返回true则触发事件
   * @property {number} [weight=1] 权重，数值越大权重越高
   * @property {'event'|'important'|'task'} [eventType] 权重，数值越大权重越高
   * 
   */

  /** 
   * 完整事件列表 @type {NormalEventItem[]}
   */
  const COMMON_EVENT_LIST = [
    {
      id: 1,
      name: "第一天 - 早上",
      day: 1,
      start_hour: 8,
      end_hour: 10,
      place: "scene_bedroom",
      force: true,
      force_move: true,
      repeatCount: 1,
      weight: 2,
      commonEvent: 105
    }, {
      id: 2,
      name: "第一天 - 傍晚",
      day: 1,
      start_hour: 18,
      end_hour: 19,
      place: "scene_bedroom",
      force: true,
      force_move: true,
      repeatCount: 1,
      commonEvent: 106
    }, {
      id: 3,
      name: "第一天 - 深夜",
      day: 1,
      start_hour: 22,
      end_hour: 24,
      place: "scene_bedroom",
      force: true,
      force_move: true,
      repeatCount: 1,
      commonEvent: 107
    }, {
      id: 4,
      name: "第二天 - 早上",
      day: 2,
      start_hour: 8,
      end_hour: 12,
      place: "scene_bedroom",
      force: true,
      force_move: true,
      weight: 2,
      repeatCount: 1,
      commonEvent: 108
    }, {
      id: 5,
      name: "偷看加奈尿尿",
      start_hour: 20,
      end_hour: 22,
      place: "scene_bedroom",
      start_day: 2,
      force: true,
      force_move: true,
      repeatCount: 1,
      commonEvent: 264,
      exec() {},
      condition({ scene }) {
        return Utils_Scene.sameKana(scene) && $gameData.todayData.useTea;
      }
    }, {
      id: 6,
      name: "买安眠药-前置",
      eventType: 'event',
      start_day: 4,
      place: "scene_shop",
      force: true,
      force_move: true,
      repeatCount: 1,
      commonEvent: 111,
      condition({ scene }) {
        return Utils_Scene.sameChinatsu(scene) && Utils_Favor.chinatsuFavor >= 10;
      }
    }, {
      id: 7,
      name: "【固定-工作日】加奈早上出门上学",
      eventType: 'event',
      start_hour: 8,
      end_hour: 9,
      place: "scene_bedroom",
      start_day: 3,
      force: false,
      force_move: false,
      commonEvent: 251,
      repeatAtDay: false,
      condition({ scene }) {
        return Utils_Time.isWorkDay && Utils_Scene.sameKana(scene);
      }
    },
    // {
    //   id: 8,
    //   name: "【固定】【前置】加奈晚上回家",
    //   eventType: 'event',
    //   is_quick: true,
    //   next_event: 9,
    //   start_hour: 18,
    //   end_hour: 19,
    //   repeatAtDay: false,
    //   exec() {
    //     // 加奈从学校回来
    //     Utils_Scene.actorMove('kana', 'scene_bedroom');
    //     $gameData.isEventBusy = false;
    //     if (Utils_Scene.sameKana() && SceneManager._scene instanceof Scene_Home) {
    //       SceneManager._scene.createChatButtons();
    //     }
    //   },
    //   condition({ scene }) {
    //     return Utils_Time.isWorkDay && Utils_Time.day >= 1;
    //   }
    // },
    {
      id: 9,
      name: "【固定-工作日】加奈晚上回家",
      eventType: 'event',
      start_hour: 18,
      end_hour: 19,
      place: "scene_bedroom",
      start_day: 2,
      commonEvent: 252,
      repeatAtDay: false,
      exec() {
        // 加奈从学校回来
        if (Utils_Scene.currentScene === 'scene_bedroom') {
          Utils_Scene.actorMove('kana', 'scene_bedroom');
          if (Utils_Scene.sameKana() && SceneManager._scene instanceof Scene_Home) {
            SceneManager._scene.createChatButtons();
          }
        }
      },
      condition({ scene }) {
        return Utils_Time.isWorkDay;
      }
    }, {
      id: 10,
      name: "没有给加奈做晚餐",
      eventType: 'event',
      start_hour: 20,
      end_hour: 24,
      place: "scene_bedroom",
      start_day: 2,
      commonEvent: 257,
      repeatAtDay: false,
      exec() {
        Utils_Scene.actorMove('kana', 'scene_bedroom');
      },
      condition({ scene }) {
        return Utils_Time.isWorkDay && !$gameData.todayData.haveDinner;
      }
    },
    // {
    //   id: 10,
    //   name: "晚上要开灯了",
    //   start_hour: 20,
    //   end_hour: 21,
    //   place: "scene_bedroom",
    //   force: true,
    //   commonEvent: 253,
    //   repeatAtDay: false,
    //   condition({ scene }) {
    //     return Utils_Scene.sameKana();
    //   }
    // },
    {
      id: 11,
      name: "要去洗澡了",
      start_hour: 21,
      end_hour: 22,
      place: "scene_bedroom",
      start_day: 2,
      force: true,
      commonEvent: 254,
      repeatAtDay: false,
      exec() {
        $gameData.todayData.havBath = true;
      },
      condition({ scene }) {
        return Utils_Scene.sameKana(scene) && !$gameData.todayData.havBath;
      }
    }, {
      id: 12,
      name: "加奈睡觉",
      start_hour: 22,
      end_hour: 24,
      place: "scene_bedroom",
      start_day: 2,
      force: true,
      force_move: true,
      commonEvent: 255,
      repeatAtDay: false,
      condition({ scene }) {
        return Utils_Scene.sameKana(scene);
      }
    }, 
    // {
    //   id: 13,
    //   name: "【固定-休息日】休息日早上",
    //   start_hour: 8,
    //   end_hour: 9,
    //   place: "scene_bedroom",
    //   start_day: 2,
    //   force: false,
    //   force_move: false,
    //   commonEvent: undefined,
    //   repeatAtDay: false,
    //   condition({ scene }) {
    //     return !Utils_Time.isWorkDay && Utils_Scene.sameKana(scene);
    //   }
    // },
    {
      id: 20,
      name: "来到便利店",
      place: "scene_shop",
      start_day: 2,
      force: true,
      force_move: true,
      commonEvent: 260,
      repeatAtDay: false,
      condition({ scene }) {
        return Utils_Scene.sameChinatsu(scene);
      }
    }, {
      id: 21,
      disabled: true,
      name: "初见千夏",
      eventType: 'event',
      place: "scene_shop",
      start_day: 2,
      start_hour: 8,
      end_hour: 18,
      force: true,
      force_move: true,
      commonEvent: 113,
      repeatAtDay: false,
      weight: 2,
      isFedein: false,
      condition({ scene }) {
        return Utils_Scene.sameChinatsu(scene);
      }
    }, {
      id: 15,
      name: "带着安眠药回家",
      eventType: 'event',
      place: "scene_bedroom",
      force: true,
      force_move: true,
      commonEvent: 112,
      repeatCount: 1,
      condition({ scene }) {
        return Utils_Scene.sameKana(scene) && $gameParty.hasItem($dataItems[14]);
      }
    }, {
      id: 16,
      name: "千夏提到神秘商店",
      eventType: 'event',
      place: "scene_shop",
      start_day: 5,
      force: true,
      force_move: true,
      commonEvent: 115,
      repeatCount: 1,
      condition({ scene }) {
        return Utils_Scene.sameChinatsu(scene) && Utils_Favor.chinatsuFavor >= 20;
      }
    }, {
      id: 17,
      name: "初见由纪",
      eventType: 'event',
      place: "scene_r18_shop",
      start_day: 3,
      force: true,
      force_move: true,
      commonEvent: 120,
      repeatCount: 1,
      condition({ scene }) {
        return Utils_Scene.sameYuki(scene);
      }
    }, {
      id: 18,
      name: "来到神秘商店",
      place: "scene_r18_shop",
      start_day: 5,
      start_hour: 16,
      end_hour: 24,
      force: true,
      force_move: true,
      commonEvent: 262,
      repeatAtDay: false,
      condition({ scene }) {
        return Utils_Scene.sameYuki(scene);
      }
    }, {
      id: 19,
      name: "妹妹逛街前置",
      eventType: 'event',
      place: "scene_bedroom",
      start_day: 5,
      force: true,
      force_move: true,
      commonEvent: 116,
      repeatCount: 1,
      condition({ scene }) {
        return !$gameSwitches.value(14) && Utils_Scene.sameKana(scene) && Utils_Favor.kanaFavor >= 30;
      }
    }, {
      id: 21,
      name: "男主-初见艾露",
      eventType: 'event',
      place: "scene_park",
      start_day: 5,
      start_hour: 8,
      end_hour: 17,
      force: true,
      commonEvent: 122,
      repeatCount: 1,
      condition({ scene }) {
        return true;
      }
    }, {
      id: 22,
      name: "初次来到服装店",
      eventType: 'event',
      place: "scene_clothing_shop",
      force: true,
      commonEvent: 124,
      repeatCount: 1,
      condition({ scene }) {
        return Utils_Scene.sameEre(scene) && Utils_Favor.kanaFavor >= 15;
      }
    }, {
      id: 23,
      name: "男主-艾露剧情1",
      eventType: 'event',
      place: "scene_clothing_shop",
      force: true,
      commonEvent: 125,
      repeatCount: 1,
      condition({ scene }) {
        return Utils_Scene.sameEre(scene) && Utils_Favor.ereFavorLevel >= 2;
      }
    }, {
      id: 24,
      name: "初次和妹妹逛街",
      eventType: 'event',
      place: "scene_street",
      start_hour: 8,
      end_hour: 17,
      start_day: 5,
      force: true,
      force_move: true,
      commonEvent: 117,
      repeatCount: 1,
      condition({ scene }) {
        return !Utils_Time.isWorkDay && $gameSwitches.value(14) && Utils_Favor.kanaFavor >= 30;
      }
    }, {
      id: 25,
      name: "来到服装店",
      eventType: 'event',
      place: "scene_clothing_shop",
      start_day: 5,
      force: true,
      force_move: true,
      commonEvent: 268,
      repeatAtDay: false,
      condition({ scene }) {
        return Utils_Scene.sameEre(scene);
      }
    }, {
      id: 30,
      name: "冒险-初篇",
      eventType: 'event',
      place: "scene_bedroom",
      start_hour: 8,
      end_hour: 9,
      start_day: 6,
      force: true,
      force_move: true,
      commonEvent: 128,
      repeatCount: 1,
      condition({ scene }) {
        return Utils_Scene.sameKana(scene);
      }
    }, 
    // 剧情3 - 晚餐的“甜点”
    {
      id: 100,
      name: "晚餐的“甜点” - 1",
      eventType: 'sex',
      start_hour: 18,
      end_hour: 19,
      place: "scene_bedroom",
      commonEvent: 160,
      repeatCount: 1,
      weight: 3,
      exec() {
        SceneManager._scene.hideTachie();
      },
      condition({ scene }) {
        return Utils_Scene.sameKana(scene) && Utils_Time.isWorkDay && Utils_Favor.kanaFavorLevel >= 2 && Utils_Favor.kanaSex >= 15;
      }
    },
    // 剧情4-1 - 浴室中的亲昵 - 1
    {
      id: 101,
      name: "浴室中的亲昵 - 1",
      eventType: 'sex',
      start_hour: 20,
      end_hour: 23,
      place: "scene_bedroom",
      commonEvent: 163,
      repeatCount: 1,
      weight: 4,
      exec() {
        $gameData.todayData.havBath = true;
        SceneManager._scene.hideTachie();
      },
      condition({ scene }) {
        return Utils_Scene.sameKana(scene) && Utils_Favor.kanaFavorLevel >= 2 && Utils_Favor.kanaSex >= 30;
      }
    },
    // 剧情4-2 - 浴室中的亲昵 - 2
    // {
    //   id: 102,
    //   name: "浴室中的亲昵 - 2",
    //   eventType: 'sex',
    //   start_hour: 20,
    //   end_hour: 23,
    //   place: "scene_bedroom",
    //   commonEvent: 164,
    //   repeatCount: 1,
    //   weight: 3,
    //   exec() {
    //     $gameData.todayData.havBath = true;
    //     SceneManager._scene.hideTachie();
    //   },
    //   condition({ scene }) {
    //     return Utils_Scene.sameKana(scene) && Utils_Favor.kanaFavorLevel >= 3 && Utils_Favor.kanaSex >= 50;
    //   }
    // },
    // 剧情5 - 千夏的报恩～♡
    {
      id: 103,
      name: "千夏的报恩～♡ - 1",
      eventType: 'sex',
      place: "scene_shop",
      commonEvent: 166,
      repeatCount: 1,
      weight: 3,
      isFedein: false,
      condition({ scene }) {
        return Utils_Scene.sameChinatsu(scene) && Utils_Favor.chinatsuFavorLevel >= 2;
      }
    },
    // 剧情6 - 对熟睡之人的恶作剧
    {
      id: 104,
      name: "对熟睡之人的恶作剧",
      eventType: 'sex',
      start_hour: 20,
      end_hour: 23,
      place: "scene_r18_shop",
      commonEvent: 169,
      repeatCount: 1,
      weight: 3,
      condition({ scene }) {
        return Utils_Scene.sameYuki(scene) && Utils_Favor.yukiFavorLevel >= 2;
      }
    },


    // 结局 - 试玩版结局
    {
      id: 203,
      name: "试玩版结局",
      day: 10,
      commonEvent: 134,
      repeatCount: 1,
      weight: 10,
      condition({ scene }) {
        return true;
      }
    },
  ].filter(i => i.disabled !== true).sort((a, b) => b.weight - a.weight > 0 ? 1 : -1);

  /** 公共事件列表 */
  const event_list = COMMON_EVENT_LIST;

  /** 事件模块 */
  const eventModule = {
    /** 获取所有事件 */
    get eventList() {
      return event_list;
    },
    /** 已触发事件 */
    get triggerEventList() {
      return $gameData.triggerEventList;
    },
    /**
     * 触发事件
     * @param {number} time 时间
     * @param {boolean} [force=false] 是否强制触发
     * @param {boolean} [isContinuous=true] 是否连续触发 
     */
    triggerEventByTime(time, force = false, isContinuous = true) {
      // 如果当前正在执行事件，则跳过
      if ($gameData.isEventBusy) return;

      const _event = eventModule.getEventByTime(time);
      if (_event) {
        eventModule.triggerEventById(_event.id, force, () => {
          eventModule.triggerEventByTime(time, force, isContinuous);
        });
      }
      
      return _event;
    },
    /**
     * 触发事件
     * @param {number} event_id 事件ID
     * @param {boolean} [force=false] 是否强制触发
     * @param {Function} [callback] 回调函数 
     */
    triggerEventById(event_id, force = false, callback) {
      // 如果当前正在执行事件，则跳过
      if ($gameData.isEventBusy) return;

      const _event = event_list.find(e => e.id === event_id);
      // 首先查询事件是否存在
      if (!_event) {
        console.error(`找不到事件：${event_id}`);
        return;
      }
      // 判断是否满足触发条件
      if (!this.checkEvent(event_id)) return;

      // 处理事件数据
      let _eventData = $gameData.triggerEventList[_event.id];
      if (!_eventData) {
        $gameData.triggerEventList[_event.id] = {
          trigger_count: 0,
          common_event: _event.id,
        }
        _eventData = $gameData.triggerEventList[_event.id];
      }

      // 执行通用事件
      _eventData.trigger_count++;
      _eventData.is_completed = true;
      _eventData.prev_trigger_time = Utils_Time.hour;
      _eventData.prev_trigger_date = Utils_Time.day;
      $gameData.isEventBusy = true;
      if (SceneManager._scene instanceof Scene_MainScene) {
        SceneManager._scene.hideGameUI();
      }

      console.warn(`触发事件【${_event.name}】`);

      if (_event.exec) {
        _event.exec();
      }

      if (_event.is_quick) {
        if (_event.next_event) {
          eventModule.triggerEventById(_event.next_event);
        }
      } else {
        if (_event.commonEvent) {
          console.warn('开始执行事件', _event.commonEvent)
          $gameTemp.execCommonEvent(_event.commonEvent, () => {
            if (callback) {
              callback();
            }
          });
        }
      }
    },
    /**
     * 查询当前时间点的事件
     */
    getEventByTime() {
      // 如果当前正在执行事件，则跳过
      if ($gameData.isEventBusy) return;

      const event = event_list.find(e => this.checkEvent(e.id));

      return event;
    },
    /**
     * 校验事件是否可以触发
     * @returns {boolean}
     */
    checkEvent(event_id, scene) {
      const event = event_list.find(e => e.id === event_id);
      // 首先查询事件是否存在
      if (!event) {
        console.error(`找不到事件：${event_id}`);
        return;
      }
      const _scene = scene || Utils_Scene.currentScene;
      
      // 判断是否满足触发条件
      if (event.condition && !event.condition({ scene: _scene })) {
        // console.log(`事件【${event.name}】未触发条件`);
        return;
      }
      // 判断是否已满足触发天数
      if (event.day && Utils_Time.day !== event.day) {
        return;
      }
      if (event.start_day && Utils_Time.day < event.start_day) {
        // console.log(`事件【${event.name}】未达到触发天数`);
        return;
      }
      if (event.end_day && Utils_Time.day > event.end_day) {
        // console.log(`事件【${event.name}】已超过触发天数`);
        return;
      }
      // 判断是否已满足触发时间
      if (event.start_hour && Utils_Time.hour < event.start_hour) {
        // console.log(`事件【${event.name}】未达到触发时间`);
        return;
      }
      if (event.end_hour && Utils_Time.hour > event.end_hour) {
        // console.log(`事件【${event.name}】已超过触发时间`);
        return;
      }
      // 判断是否已满足触发分钟
      if (event.start_minute !== undefined && event.start_minute <= Utils_Time.minute) {
        // console.log(`事件【${event.name}】未达到触发分钟数`);
        return;
      }
      if (event.end_minute !== undefined && event.end_minute >= Utils_Time.minute) {
        // console.log(`事件【${event.name}】已超过触发分钟数`);
        return;
      }
      // 判断触发地点
      if (event.place && event.place !== _scene) {
        return;
      }

      let _eventData = $gameData.triggerEventList[event.id];
      if (_eventData) {

        // 判断当天是否重复
        if (event.repeatAtDay === false && _eventData.prev_trigger_date === Utils_Time.day) {
          return;
        }

        // 判断触发次数
        if (event.repeatCount !== undefined && event.repeatCount != -1) {
          const trigger_count = _eventData ? _eventData.trigger_count : 0;
          if (trigger_count >= event.repeatCount) {
            // console.log(`事件【${event.name}】已达到最大触发次数`);
            return;
          }
          // $gameData.triggerEventList[event_id].trigger_count = trigger_count + 1;
        }
      }
      return event;
    },
  };

  /** 事件工具类 */
  class Utils_Event {
    /** 事件列表 */
    static get eventList() {
      return event_list;
    }
    /** 已触发事件列表 */
    static get triggerEventList() {
      return eventModule.triggerEventList;
    }
    /**
     * 校验事件是否可以触发
     * @returns {boolean}
     */
    static checkEvent(event_id, scene) {
      return eventModule.checkEvent(event_id, scene);
    }
    /**
     * 触发事件
     * @param {number} event_id 事件ID
     * @param {boolean} [force=false] 是否强制触发
     */
    static triggerEventById(event_id, force) {
      eventModule.triggerEventById(event_id, force);
    }
    /**
     * 校验事件是否可以触发
     */
    static getEventByTime(time) {
      return eventModule.getEventByTime(time);
    }
    /**
     * 直接触发事件
     */
    static triggerEventByTime(time) {
      return eventModule.triggerEventByTime(time);
    }
    /** 结束事件 */
    static endEvent() {
      $gameData.isEventBusy = false;
    }
  }
  window.Utils_Event = Utils_Event;

  if (Utils.RPGMAKER_NAME === "MZ") {
    PluginManager.registerCommand(PluginName, 'endEvent', (args) => {
      Utils_Event.endEvent();
    });
  }

})();