//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Favor.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 好感度插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】好感度相关插件。
 * 
 * 
 * @command setKanaMood
 * @text 设置加奈的心情
 * @desc 设置加奈的心情
 * 
 * @arg value
 * @text 心情
 * @type select
 * @option 普通 - normal
 * @value normal
 * @option 开心 - happy
 * @value happy
 * @option 糟糕 - sad
 * @value sad
 * 
 * 
 * @command addFavor
 * @text 设置好感度
 * 
 * @arg value
 * @text 好感度值
 * @type number
 * @min -100
 * @max 100
 * @default 0
 * 
 * @arg actor
 * @text 目标角色
 * @type select
 * @option 加奈（加奈/カナ）
 * @value kana
 * @option 千夏（千夏/ちなつ）
 * @value chinatsu
 * @option 由纪（由紀/ゆき）
 * @value yuki
 * @option 艾露（エーレ）
 * @value ere
 * 
 * @arg operation
 * @text 操作类型
 * @desc 操作类型
 * @type select
 * @option 增加 - add
 * @value add
 * @option 减少 - minus
 * @value minus
 * @option 设为固定值 - set
 * @value set
 * @default add
 * 
 * 
 * @command setSex
 * @text 设置加奈的性欲
 * 
 * @arg value
 * @text 性欲值
 * @type number
 * @min -100
 * @max 100
 * @default 0
 * 
 * @arg operation
 * @text 操作类型
 * @desc 操作类型
 * @type select
 * @option 增加 - add
 * @value add
 * @option 减少 - minus
 * @value minus
 * @option 设为固定值 - set
 * @value set
 * @default add
 * 
 * 
 * 
 * @command isUnLockEvent
 * @text 判断事件是否已解锁
 * 
 * @arg eventId
 * @text 公共事件ID
 * @type common_event
 * 
 * 
 * @command unlockEvent
 * @text 解锁事件
 * 
 * @arg eventId
 * @text 公共事件ID
 * @type common_event
 * 
 * 
 * 
 * @param kana
 * @text 加奈（カナ）
 * 
 * @param kana_mood
 * @parent kana
 * @type variable
 * @text 心情
 * @desc 心情绑定变量
 * 
 * @param kana_favor
 * @parent kana
 * @type variable
 * @text 好感度
 * @desc 好感度绑定变量
 * 
 * @param kana_max_favor
 * @parent kana
 * @type number
 * @text 最大好感度
 * @desc 最大好感度
 * 
 * @param kana_favor_event
 * @parent kana
 * @type common_event
 * @text 好感度变化事件
 * @desc 好感度变化时触发的事件
 * 
 * @param kana_sex
 * @parent kana
 * @type variable
 * @text 色情值
 * @desc 色情值绑定变量
 * 
 * @param kana_max_sex
 * @parent kana
 * @type number
 * @text 最大色情值
 * @desc 最大色情值
 * 
 * 
 * @param chinatsu
 * @text 千夏（ちなつ）
 * 
 * @param chinatsu_favor
 * @parent chinatsu
 * @type variable
 * @text 好感度
 * @desc 好感度绑定变量
 * 
 * @param chinatsu_max_favor
 * @parent chinatsu
 * @type number
 * @text 最大好感度
 * @desc 最大好感度
 * 
 * @param chinatsu_favor_event
 * @parent chinatsu
 * @type common_event
 * @text 好感度变化事件
 * @desc 好感度变化时触发的事件
 * 
 * 
 * @param yuki
 * @text 由纪（ゆき）
 * 
 * @param yuki_favor
 * @parent yuki
 * @type variable
 * @text 好感度
 * @desc 好感度绑定变量
 * 
 * @param yuki_max_favor
 * @parent yuki
 * @type number
 * @text 最大好感度
 * @desc 最大好感度
 * 
 * @param yuki_favor_event
 * @parent yuki
 * @type common_event
 * @text 好感度变化事件
 * @desc 好感度变化时触发的事件
 * 
 * 
 * @param ere
 * @text 艾露（エーレ）
 * 
 * @param ere_favor
 * @parent ere
 * @type variable
 * @text 好感度
 * @desc 好感度绑定变量
 * 
 * @param ere_max_favor
 * @parent ere
 * @type number
 * @text 最大好感度
 * @desc 最大好感度
 * 
 * @param ere_favor_event
 * @parent ere
 * @type common_event
 * @text 好感度变化事件
 * @desc 好感度变化时触发的事件
 * 
 */
// #endregion
(() => {

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Module_Favor";
  
  const typeDefine = {
  };
  // #endregion

  // #region 插件参数

  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);

  /** 好感度配置类 */
  const favorConfig = {
    /** 加奈好感度操作 */
    kana: {
      /** 心情 @type {'normal'|'sad'|'happy'} */
      get mood() {
        return $gameVariables.value(params.kana_mood) || 'normal';
      },
      set mood(value) {
        $gameVariables.setValue(params.kana_mood, value);

        // 记录特殊的心情变化日期
        if (value !== 'normal') {
          $gameData.totalData.kanaMoodDay = Utils_Time.day;
        } else {
          $gameData.totalData.kanaMoodDay = 0;
        }

        const _scene = SceneManager._scene;
        if (_scene.textSexSprite) {
          _scene.textSexSprite.bitmap.clear();
          _scene.textSexSprite.bitmap.drawText(Utils_Favor.kanaMoodStr, 0, 0, 80, 20, 'left');
        }
      },
      get moodStr() {
        switch (favorConfig.kana.mood) {
          case 'normal': return '普通';
          case 'sad': return '不开心';
          case 'happy': return '开心';
          default: return 'XXX';
        }
      },
      /** 好感度 @type {number} */
      get favor() {
        return $gameVariables.value(params.kana_favor) || 0;
      },
      set favor(value) {
        let _value = value;
        if (value < 0) _value = 0;
        else if (value >= favorConfig.kana.maxFavor) _value = favorConfig.kana.maxFavor;
        favorConfig.changeFavor('kana', _value);
        $gameVariables.setValue(params.kana_favor, _value);
      },
      /** 最大好感度 @type {number} */
      get maxFavor() {
        return params.kana_max_favor || 300;
      },
      /** 好感度等级 @type {number} */
      get favorLevel() {
        const _favor = favorConfig.kana.favor;
        if (_favor < 50) return 1;
        else if (_favor < 150) return 2;
        else if (_favor <= 300) return 3;
        else return 4;
      },
      /** 色情度 @type {number} */
      get sex() {
        return $gameVariables.value(params.kana_sex) || 0;
      },
      set sex(value) {
        let _value = value;
        if (value < 0) _value = 0;
        else if (value >= favorConfig.kana.maxSex) _value = favorConfig.kana.maxSex;
        favorConfig.changeSex('kana', _value);
        $gameVariables.setValue(params.kana_sex, _value);
      },
      /** 最大色情度 @type {number} */
      get maxSex() {
        return params.kana_max_sex || 100;
      },
      /** 色情度等级 @type {1|2|3} */
      get sexLevel() {
        const _sex = favorConfig.kana.sex;
        if (_sex < 30) return 1;
        else if (_sex < 60) return 2;
        else if (_sex <= 100) return 3;
      }
    },
    /** 千夏好感度操作 */
    chinatsu: {
      /** 好感度 @type {number} */
      get favor() {
        return $gameVariables.value(params.chinatsu_favor) || 0;
      },
      set favor(value) {
        let _value = value;
        if (value < 0) _value = 0;
        else if (value >= favorConfig.chinatsu.maxFavor) _value = favorConfig.chinatsu.maxFavor;
        favorConfig.changeFavor('chinatsu', _value);
        $gameVariables.setValue(params.chinatsu_favor, _value);
      },
      /** 最大好感度 @type {number} */
      get maxFavor() {
        return params.chinatsu_max_favor || 100;
      },
      /** 好感度等级 @type {number} */
      get favorLevel() {
        const _favor = favorConfig.chinatsu.favor;
        if (_favor < 30) return 1;
        else if (_favor < 60) return 2;
        else if (_favor <= 100) return 3;
        else return 4;
      },
    },
    /** 由纪好感度操作 */
    yuki: {
      /** 好感度 @type {number} */
      get favor() {
        return $gameVariables.value(params.yuki_favor) || 0;
      },
      set favor(value) {
        let _value = value;
        if (value < 0) _value = 0;
        else if (value >= favorConfig.yuki.maxFavor) _value = favorConfig.yuki.maxFavor;
        favorConfig.changeFavor('yuki', _value);
        $gameVariables.setValue(params.yuki_favor, _value);
      },
      /** 最大好感度 @type {number} */
      get maxFavor() {
        return params.yuki_max_favor || 100;
      },
      /** 好感度等级 @type {number} */
      get favorLevel() {
        const _favor = favorConfig.yuki.favor;
        if (_favor < 30) return 1;
        else if (_favor < 60) return 2;
        else if (_favor <= 100) return 3;
        else return 4;
      },
    },
    /** 艾露好感度操作 */
    ere: {
      /** 好感度 @type {number} */
      get favor() {
        return $gameVariables.value(params.ere_favor) || 0;
      },
      set favor(value) {
        let _value = value;
        if (value < 0) _value = 0;
        else if (value >= favorConfig.ere.maxFavor) _value = favorConfig.ere.maxFavor;
        favorConfig.changeFavor('ere', _value);
        $gameVariables.setValue(params.ere_favor, _value);
      },
      /** 最大好感度 @type {number} */
      get maxFavor() {
        return params.ere_max_favor || 100;
      },
      /** 好感度等级 @type {number} */
      get favorLevel() {
        const _favor = favorConfig.ere.favor;
        if (_favor < 30) return 1;
        else if (_favor < 60) return 2;
        else if (_favor <= 100) return 3;
        else return 4;
      },
    },
    /** 
     * 获得加奈的好感度等级
     * @param {number} favor 好感度值
     */
    getKanaFavorLevel(favor) {
      if (favor < 50) return 1;
      else if (favor < 150) return 2;
      else if (favor <= 300) return 3;
      else return 4;
    },
    /** 
     * 获得其他人的好感度等级
     * @param {number} favor 好感度值
     */
    getElseFavorLevel(favor) {
      if (favor < 30) return 1;
      else if (favor < 60) return 2;
      else if (favor <= 100) return 3;
      else return 4;
    },
    /**
     * 获取阶段好感度
     * @param {string} name 角色名称
     * @param {number} favor 好感度
     */
    getStageFavor(name, favor) {
      if (name === 'kana') {
        switch (favorConfig.getKanaFavorLevel(favor)) {
          case 1: return favor;
          case 2: return favor - 50;
          case 3: return favor - 150;
          case 4: return 300;
        }
      } else {
        return favor;
      }
    },
    /**
     * 获取阶段好感度最大值
     * @param {string} name 名称
     * @param {number} value 值
     * @param {boolean} [isFull=false] 是否为完全好感度
     */
    getStageMaxFavor(name, value, isFull = false) {
      if (name === 'kana') {
        switch (favorConfig.getKanaFavorLevel(value)) {
          case 1: return 50;
          case 2: return isFull ? 150 : 100;
          case 3: return isFull ? 300 : 150;
          case 4: return isFull ? 300 : 150;
        }
      } else {
        return favorConfig[name].maxFavor;
      }
    },
    /**
     * 好感度改变
     * @param {string} name 角色名称
     * @param {number} newValue 新好感度
     */
    changeFavor(name, newValue) {
      const _scene = SceneManager._scene;
      const _oldValue = favorConfig[name].favor;
      if (_oldValue === newValue) return;
      useAnime({
        frameDelay: 0,
        frameCount: 30,
        autoUpdate: true,
        easingType: 'Quadratic',
        inout: 'InOut',
      }, progress => {
        if (!_scene.favorBgSprite || !_scene.textFavorSprite) return;
        const _val = Math.round(_oldValue + (newValue - _oldValue) * progress);
        const _favor = favorConfig.getStageFavor(name, _val);
        const _maxFavor = favorConfig.getStageMaxFavor(name, _val);
        const _progressValue = _favor / _maxFavor;
          
        _scene.textFavorSprite.bitmap.clear();
        _scene.textFavorSprite.bitmap.drawText(`${Math.round(_val)}/${_maxFavor}`, 0, 0, 80, 18, 'center');
        _scene.favorSprite.bitmap.clear();
        _scene.favorSprite.bitmap.blt(_scene.favorBitmap, 
          0, 0, _scene.favorBitmap.width * _progressValue, 20, 
          0, 0, _scene.favorBitmap.width * _progressValue, 20
        );
      });
      if (_scene.favorContainer) {
        createFloatText({
          sprite: _scene.favorContainer,
          x: _scene.favorContainer.x + _scene.favorContainer.width - 15,
          y: _scene.favorContainer.y,
          text: `${_oldValue < newValue ? '+' : ''}${newValue - _oldValue}`
        });
      }
    },
    /**
     * 色情度改变
     * @param {string} name 角色名称
     * @param {number} value 新色情度
     */
    changeSex(name, value) {
      if (name === 'kana') {
        const _scene = SceneManager._scene;
        const _oldValue = favorConfig[name].sex;
        if (_oldValue === value) return;
        useAnime({
          frameDelay: 0,
          frameCount: 30,
          autoUpdate: true,
          easingType: 'Quadratic',
          inout: 'InOut',
        }, progress => {
          if (!_scene.sexBgSprite || !_scene.textSexSprite) return;

          const _val = _oldValue + (value - _oldValue) * progress;
          const _width = Math.round(_scene.sexBgSprite.bitmap.width * _val / favorConfig[name].maxSex);
          
          _scene.textSexSprite.bitmap.clear();
          _scene.textSexSprite.bitmap.drawText(`${Math.round(_val)}/${favorConfig[name].maxSex}`, 0, 0, 80, 18, 'center');
          _scene.sexSprite.bitmap.clear();
          _scene.sexSprite.bitmap.blt(_scene.sexBitmap, 
            0, 0, _width, 20, 
            0, 0, _width, 20
          );
        });
        if (_scene.sisterSexContainer) {
          createFloatText({
            sprite: _scene.sisterSexContainer,
            x: _scene.sisterSexContainer.x + _scene.sisterSexContainer.width - 15,
            y: _scene.sisterSexContainer.y,
            text: `${_oldValue < value ? '+' : ''}${value - _oldValue}`
          });
        }
      } else {
        throw new Error('暂不支持该角色');
      }
    },
    /**
     * 播放事件
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} name 角色名称
     * @param {number} min 最小好感度
     * @param {number} [max] 最大好感度
     */
    inArea(name, min, max) {
      let _favor = 0;
      if (name === 'kana') {
        _favor = favorConfig.kana.favor;
      } else if (name === 'chinatsu') {
        _favor = favorConfig.chinatsu.favor;
      } else if (name === 'yuki') {
        _favor = favorConfig.yuki.favor;
      } else if (name === 'ere') {
        _favor = favorConfig.ere.favor;
      }
      return _favor >= min && (!max || _favor < max);
    },
    /**
     * 是否为第一次动作
     */
    isFirstAction() {

    }
  };

  /** 好感度工具类 */
  class Utils_Favor {
    /** 加奈的好感度 */
    static get kanaFavor() {
      return favorConfig.kana.favor;
    }
    static set kanaFavor(value) {
      favorConfig.kana.favor = value;
    }
    /** 获取加奈的心情文本 */
    static get kanaMoodStr() {
      return favorConfig.kana.moodStr;
    }
    /** 加奈的最大好感度 */
    static get kanaMaxFavor() {
      return favorConfig.kana.maxFavor;
    }
    /** 加奈的好感度等级 @type {number} */
    static get kanaFavorLevel() {
      return favorConfig.kana.favorLevel;
    }
    /** 加奈在当前等级下的好感度 */
    static get kanaStageFavor() {
      return favorConfig.getStageFavor('kana', favorConfig.kana.favor);
    }
    /** 加奈在当前等级下的最大好感度 */
    static get kanaStageMaxFavor() {
      return favorConfig.getStageMaxFavor('kana', favorConfig.kana.favor);
    }
    /** 加奈的色情值 */
    static get kanaSex() {
      return favorConfig.kana.sex;
    }
    static set kanaSex(value) {
      favorConfig.kana.sex = value;
    }
    /** 加奈最大的色情度 */
    static get kanaMaxSex() {
      return favorConfig.kana.maxSex;
    }
    static get kanaSexLevel() {
      return favorConfig.kana.sexLevel;
    }
    /** 千夏的好感度 */
    static get chinatsuFavor() {
      return favorConfig.chinatsu.favor;
    }
    static set chinatsuFavor(value) {
      favorConfig.chinatsu.favor = value;
    }
    /** 千夏的最大好感度 */
    static get chinatsuMaxFavor() {
      return favorConfig.chinatsu.maxFavor;
    }
    /** 千夏的好感度等级 @type {number} */
    static get chinatsuFavorLevel() {
      return favorConfig.chinatsu.favorLevel;
    }
    /** 由纪的好感度 */
    static get yukiFavor() {
      return favorConfig.yuki.favor;
    }
    static set yukiFavor(value) {
      return favorConfig.yuki.favor = value;
    }
    /** 由纪的最大好感度 */
    static get yukiMaxFavor() {
      return favorConfig.yuki.maxFavor;
    }
    /** 千夏的好感度等级 @type {number} */
    static get yukiFavorLevel() {
      return favorConfig.yuki.favorLevel;
    }
    /** 艾露的好感度 */
    static get ereFavor() {
      return favorConfig.ere.favor;
    }
    static set ereFavor(value) {
      return favorConfig.ere.favor = value;
    }
    /** 艾露的最大好感度 */
    static get ereMaxFavor() {
      return favorConfig.ere.maxFavor;
    }
    /** 艾露的好感度等级 @type {number} */
    static get ereFavorLevel() {
      return favorConfig.ere.favorLevel;
    }
    /**
     * 修改好感度
     * @param {number} value 好感度值
     * @param {string} name 角色名称
     * @param {'add'|'minus'|'set'} operation 操作类型
     */
    static addFavor(value, name, operation = 'add') {
      if (!value || !name) return;
      const actor = favorConfig[name];
      if (!actor) return;
      
      let newFavor = actor.favor;
      if (operation === 'add') {
        newFavor = (actor.favor + value).clamp(0, actor.maxFavor);
      } else if (operation === 'minus') {
        newFavor = (actor.favor - value).clamp(0, actor.maxFavor);
      } else if (operation === 'set') {
        newFavor = value.clamp(0, actor.maxFavor);
      }

      actor.favor = newFavor;
    }

    /**
     * 设置加奈的性欲
     * @param {number} value 好感度值
     * @param {'add'|'minus'|'set'} operation 操作类型
     */
    static setSex(value, operation = 'add') {
      if (!value) return;
      const actor = favorConfig.kana;
      
      let newSex = actor.sex;
      if (operation === 'add') {
        newSex = (actor.sex + value).clamp(0, actor.maxSex);
      } else if (operation === 'minus') {
        newSex = (actor.sex - value).clamp(0, actor.maxSex);
      } else if (operation === 'set') {
        newSex = value.clamp(0, actor.maxSex);
      }

      actor.sex = newSex;
    }
    /**
     * 可以播放事件
     * @param {number} eventId 公共事件ID
     * @return {boolean}
     */
    static isUnLockEvent(eventId) {
      if ($gameData.isAllUnlocked) return true;
      return $gameData.triggerEventList[eventId];
    }
    /**
     * 播放事件
     * @param {number} eventId 公共事件ID
     */
    static unlockEvent(eventId) {
      if (!$gameData.triggerEventList[eventId]) {
        $gameData.triggerEventList[eventId] = {
          isCompleted: true, triggerCount: 1, commonEvent: eventId
        };
      } else {
        $gameData.triggerEventList[eventId].triggerCount++;
      }
    }
    /**
     * 好感度是否在范围内
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} name 角色名称
     * @param {number} min 最小好感度
     * @param {number} [max] 最大好感度
     */
    static inArea(name, min, max) {
      return favorConfig.inArea(name, min, max);
    }
    /** 
     * 获取加奈的好感度等级
     * @param {number} value 好感度值
     */
    static getKanaFavorLevel(value) {
      return favorConfig.getKanaFavorLevel(value);
    }
    /** 
     * 获取其他人的好感度等级
     * @param {number} value 好感度值
     */
    static getElseFavorLevel(value) {
      return favorConfig.getElseFavorLevel(value);
    }
    /**
     * 获取阶段好感度最大值
     * @param {string} name 名称
     * @param {number} value 值
     * @param {boolean} [isFull=false] 是否为完全好感度
     */
    static getStageMaxFavor(name, value, isFull = false) {
      return favorConfig.getStageMaxFavor(name, value, isFull);
    }
    /**
     * 交互次数
     * @param {string} interactName 交互名称
     * @param {string} interactCount 交互名称
     */
    static interactCount(interactName, interactCount) {
      if (interactCount !== undefined) {
        if (!$gameData.todayData.kanaInteract[interactName]) $gameData.todayData.kanaInteract[interactName] = 0;
        $gameData.todayData.kanaInteract[interactName] += interactCount;
      } else {
        return $gameData.todayData.kanaInteract[interactName] || 0;
      }
    }
    /**
     * 调整加奈的心情
     * @param {'normal'|'sad'|'happy'} mood 心情
     */
    static get kanaMood() {
      return favorConfig.kana.mood;
    }
    static set kanaMood(mood) {
      favorConfig.kana.mood = mood;
    }
    /**
     * 增加加奈的经验次数
     * @param {'mouth'|'chest'|'pussy'|'ass'} type 类型
     * @param {number} [count=1] 经验次数
     */
    static addKanaSexCount(type, count = 1) {
      const _prop = $gameData.totalData.kanaData;
      const _propName = `${type}Count`;
      if (!_prop[_propName]) _prop[_propName] = 0;
      _prop[_propName] += count;
    }
    /**
     * 获得加奈的经验次数
     * @param {'mouth'|'chest'|'pussy'|'ass'} type 类型
     */
    static kanaSexCount(type) {
      const _prop = $gameData.totalData.kanaData;
      const _propName = `${type}Count`;
      if (!_prop[_propName]) _prop[_propName] = 0;
      return _prop[_propName];
    }
    /**
     * 获得加奈的经验次数
     * @param {'mouth'|'chest'|'pussy'|'ass'} type 类型
     */
    static kanaSexEx(type) {
      const _count = Utils_Favor.kanaSexCount(type) || 0;
      const _ex = Math.floor(Math.min(_count, 100));
      return _ex;
    }
    /**
     * 获得加奈的经验次数
     * @param {'mouth'|'chest'|'pussy'|'ass'} type 类型
     */
    static kanaSexLevelImg(type) {
      const _ex = Utils_Favor.kanaSexEx(type) || 0;
      if (_ex <= 15) return 1;
      else if (_ex <= 30) return 2;
      else if (_ex <= 50) return 3;
      else return 3;
    }
    
  }
  window.Utils_Favor = Utils_Favor;

  if (Utils.RPGMAKER_NAME === "MZ") {
    PluginManager.registerCommand(PluginName, 'addFavor', args => {
      const _value = Number(args.value);
      Utils_Favor.addFavor(_value, args.actor, args.operation);
    });
    PluginManager.registerCommand(PluginName, 'setKanaMood', args => {
      Utils_Favor.kanaMood = args.value;
    });
    PluginManager.registerCommand(PluginName, 'setSex', args => {
      const _value = Number(args.value);
      Utils_Favor.setSex(_value, args.operation);
    });
    PluginManager.registerCommand(PluginName, 'isUnLockEvent', args => {
      Utils_Favor.isUnLockEvent(Number(args.eventId));
    });
    PluginManager.registerCommand(PluginName, 'unlockEvent', args => {
      Utils_Favor.unlockEvent(Number(args.eventId));
    });
  }
  
})();