//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Item.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 道具插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】道具插件。
 * 
 * 
 * @command addUsedItem
 * @text 添加物品到已使用列表
 * @desc 添加物品到已使用列表
 * 
 * @arg itemId
 * @text 道具ID
 * @type item
 * 
 */
(() => {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Time";
  
  const typeDefine = {
  };
  
  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);

  /**
   * @typedef Game_Item
   * @property {string} name 道具名称
   * @property {() => boolean} visibleInShop 在商店可购买/显示条件
   * @property {() => boolean} useCondition 使用条件
   */

  /** 道具表 @type {Game_Item[]} */
  const __items = [
    {
      id: 1,
      name: '饭团',
      useEvent: 201,
      visibleInShop() {

      },
      useCondition() {

      }
    }, {
      id: 2,
      name: '豪华便当',
      useEvent: 202,
      visibleInShop() {
      },
      useCondition() {
      }
    }, {
      id: 3,
      name: '绿茶',
      useEvent: 203,
      visibleInShop() {

      },
      useCondition() {
      }
    }, {
      id: 4,
      name: '红酒',
      useEvent: 204,
      visibleInShop() {
        return false;
      },
      useCondition() {
      }
    }, {
      id: 5,
      name: '果汁饮料',
      useEvent: 205,
      visibleInShop() {
        return false;
      },
      useCondition() {
      }
    }, {
      id: 6,
      name: '巧克力',
      useEvent: 206,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 7,
      name: '礼物',
      useEvent: 207,
      visibleInShop() {

      },
      useCondition() {
      }
    }, {
      id: 8,
      name: '锻炼的秘诀',
      useEvent: 208,
      visibleInShop() {

      },
      useCondition() {

      }
    }, {
      id: 9,
      name: '打工的秘诀',
      useEvent: 209,
      visibleInShop() {

      },
      useCondition() {
      }
    }, {
      id: 10,
      name: '锻炼的极意',
      useEvent: 210,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 11,
      name: '打工的极意',
      useEvent: 211,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 12,
      name: '理智书籍',
      useEvent: 212,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 13,
      name: '色色书籍',
      useEvent: 213,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 14,
      name: '安眠药',
      useEvent: 214,
      visibleInShop() {
        return $gameSwitches.value(6) === true;
      },
      useCondition() {
      }
    }, {
      id: 15,
      name: '舒适的枕头',
      useEvent: 215,
      visibleInShop() {

      },
      useCondition() {
      }
    }, {
      id: 16,
      name: '跳蛋',
      useEvent: 216,
      visibleInShop() {

      },
      useCondition() {
      }
    }, {
      id: 17,
      name: '震动棒',
      useEvent: 217,
      visibleInShop() {

      },
      useCondition() {
      }
    }, {
      id: 18,
      name: '蜡烛',
      useEvent: 218,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 19,
      name: '绳子',
      useEvent: 219,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 20,
      name: '透视眼镜',
      useEvent: 220,
      visibleInShop() {

      },
      useCondition() {
      }
    }, {
      id: 21,
      name: '催眠APP',
      useEvent: 221,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 22,
      name: '死库水',
      useEvent: 222,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 23,
      name: '兔女郎装',
      useEvent: 223,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 24,
      name: '婚纱',
      useEvent: 224,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 25,
      name: '揉肩券',
      useEvent: 225,
      visibleInShop() {
        return false;
      },
      useCondition() {
        return false;
      }
    }, {
      id: 26,
      name: '下厨券',
      useEvent: 226,
      visibleInShop() {
        return false;
      },
      useCondition() {
        return false;
      }
    }, {
      id: 27,
      name: '万能の券',
      useEvent: 227,
      visibleInShop() {
        return false;
      },
      useCondition() {
        return false;
      }
    }, {
      id: 28,
      name: '未知の券',
      useEvent: 228,
      visibleInShop() {
        return false;
      },
      useCondition() {
        return false;
      }
    }, {
      id: 29,
      name: '催乳药剂',
      useEvent: 229,
      visibleInShop() {

      },
      useCondition() {
        return false;
      }
    }, {
      id: 30,
      name: '沉眠喷雾',
      useEvent: 230,
      visibleInShop() {
        return false;
      },
      useCondition() {
        return false;
      }
    }, {
      id: 31,
      name: '荧光剂',
      useEvent: 231,
      visibleInShop() {
        return false;
      },
      useCondition() {
        return false;
      }
    }, {
      id: 32,
      name: '招财猫',
      useEvent: 232,
      visibleInShop() {
        return false;
      },
      useCondition() {
        return false;
      }
    }, {
      id: 33,
      name: '时停贴纸',
      useEvent: 233,
      visibleInShop() {
        return false;
      },
      useCondition() {
        return false;
      }
    }
  ];

  /**
   * 道具模块
   */
  const itemModule = {
    /**
     * 道具是否在商店显示
     * @param {number} itemId 
     */
    visibleInShop(itemId) {
      const _item = __items.find(item => item.id === itemId);
      if (!_item) {
        throw new Error(`未找到道具ID为${itemId}的道具。`);
      }
      return _item.visibleInShop();
    }
  };


  /**
   * 道具相关工具类
   */
  class Utils_Item {
    /**
     * 获取所有道具 @type {Game_Item[]}
     */
    static get items() {
      return __items;
    }
    /**
     * 获取库存列表
     * @param {'scene_shop'|undefined} sceneName 场景名称
     */
    static getRepertories(sceneName) {
      if (!sceneName) sceneName = Utils_Scene.currentScene;
      let _keys = [];
      if (sceneName === 'scene_shop') {
        _keys = Object.keys($gameData.repertories.chinatsu);
      } else if (sceneName === 'scene_r18_shop') {
        _keys = Object.keys($gameData.repertories.yuki);
      } else {
        return [];
      }
      return __items.filter(i => {
        return _keys.includes(i.id.toString()) && i.visibleInShop() !== false;
      });
    }
    /**
     * 获取某一个道具的库存数量
     * @param {number} itemId 道具ID
     * @param {'scene_shop'|undefined} sceneName 场景名称
     */
    static getRepertory(itemId, sceneName) {
      if (!sceneName) sceneName = Utils_Scene.currentScene;
      const _item = __items.find(item => item.id === itemId);
      if (!_item) {
        throw new Error(`未找到道具ID为${itemId}的道具。`);
      }
      if (sceneName === 'scene_shop') {
        return $gameData.repertories.chinatsu[itemId] || 0;
      } else if (sceneName === 'scene_r18_shop') {
        return $gameData.repertories.yuki[itemId] || 0;
      } else {
        return 0;
      }
    }
    /**
     * 减少商店道具库存
     * @param {number} itemId 道具ID
     * @param {'scene_shop'|undefined} sceneName 场景名称
     */
    static loseShopItem(itemId, sceneName) {
      if (!sceneName) sceneName = Utils_Scene.currentScene;
      const _item = __items.find(item => item.id === itemId);
      if (!_item) {
        throw new Error(`未找到道具ID为${itemId}的道具。`);
      }
      let _repertory;
      if (sceneName === 'scene_shop') {
        _repertory = $gameData.repertories.chinatsu;
      } else if (sceneName === 'scene_r18_shop') {
        _repertory = $gameData.repertories.yuki;
      }
      if (_repertory && _repertory[itemId]) {
        _repertory[itemId] -= 1;

        if (!_repertory[itemId]) {
          delete _repertory[itemId];
        }
      }
    }
    /**
     * 道具是否在商店显示
     * @param {number} itemId 
     */
    static visibleInShop(itemId) {
      return itemModule.visibleInShop(itemId);
    }
    /**
     * 判断是否是第一次使用某道具
     * @param {number} itemId 道具ID
     */
    static isFirstUse(itemId) {
      return !$gameData.usedItems.includes(itemId);
    }
    /**
     * 添加物品到已使用列表
     * @param {number} itemId 道具ID
     */
    static addUsedItem(itemId) {
      if (!$gameData.usedItems.includes(itemId)) {
        $gameData.usedItems.push(itemId);
      }
    }
    /**
     * 补充库存
     */
    static addStock(actor, items) {
      const _obj = $gameData.repertories[actor];

      if (actor === 'chinatsu') {
        $gameSwitches.setValue(9, true);
      } else if (actor === 'yuki') {
        $gameSwitches.setValue(10, true);
      }

      for (const key in items) {
        const count = items[key];
        _obj[key] = count;
      }
    }
  }
  window.Utils_Item = Utils_Item;


  if (Utils.RPGMAKER_NAME === "MZ") {
    
    PluginManager.registerCommand(PluginName, 'addUsedItem', (args) => {
      Utils_Item.addUsedItem(args.itemId);
    });
  }

})();