//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Quest.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 任务系统插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】任务系统插件。
 * 
 * 
 */
// #endregion
(() => {

  /**
   * @typedef {Object} QuestInfo
   * @property {number} id 任务ID
   * @property {string} title 任务名称/标题
   * @property {string} desc 任务描述
   * @property {'inactive'|'available'|'inprogress'|'pending_review'|'succeeded'|'failed'|'invalid'} state 任务状态
   * @property {string} previewImg 任务预览图
   * @property {number} rewards 任务奖励说明
   * @property {number} progress 任务奖励说明
   * @property {object} config 额外配置
   */

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Module_Quest";
  
  const typeDefine = {
  };
  // #endregion

  // #region 插件参数

  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);

  /** 初始化 */
  const _init = () => {
    // 未初始化修复
    if ($gameData.questModule === undefined) {
      $gameData.questModule = {
        questList: [],
      };
    }

    // 添加两个测试任务
    useTimeout(() => {
      Utils_Quest.claimQuest('1');
      Utils_Quest.claimQuest('2');
    }, 1);
  };

  /** 任务模板列表 */
  const questTemplateList = [
    {
      id: '1', title: '到森林最深处', get content() { return '前进到森林的最深处。'}, 
      get progress() { return $gameSwitches.value(43); }
    }, {
      id: '2', title: '采集3个蜂蜜', get content() { return `「${$gameParty._items[35] || 0}/3」采集3个蜂蜜。` }, 
      get progress() { return ($gameParty._items[35] || 0) / 3; }
    },
  ];

  /** 任务模块 */
  const questModule = {
    /** 任务模板列表 */
    get questTemplateList() {
      return questTemplateList;
    },
    /** 任务列表 */
    get questList() {
      if ($gameData.questModule === undefined) {
        $gameData.questModule = {
          questList: [
            {questId: "1", state: "inprogress"}
          ],
        };
      }
      return $gameData.questModule.questList;
    },
    set questList(value) {
      $gameData.questModule.questList = value;
    },
    /**
     * 领取任务
     * @param {string} questId 任务Id
     * @param {object} [config={}] 额外配置
     */
    claimQuest(questId, config = {}) {
      questModule.questList.push({
        questId: questId,
        state: 'inprogress',
      });
    },
    /** 获取当前的任务列表 */
    getCurrentQuestList(stateList = []) {
      return questModule.questList.filter(quest => {
        return stateList.length === 0 ? true : stateList.includes(quest.state);
      }).map(quest => {
        const _questInfo = {};
        _questInfo.questId = quest.questId;
        _questInfo.state = quest.state;
        _questInfo.info = questTemplateList.find(template => template.id === quest.questId);
        return _questInfo;
      });
    },
    /**
     * 删除任务
     * @param {string} questId 任务Id
     */
    removeQuest(questId) {
      const _index = questModule.questList.findIndex(quest => quest.id === questId);
      if (_index >= 0) {
        questModule.questList.splice(_index, 1);
      }
    },
    /**
     * 接受任务
     * @param {string} questId 任务Id
     */
    acceptQuest(questId) {

    },
    /** 修改任务状态 */
    changeState(questId, state) {
      const _index = questModule.questList.findIndex(quest => quest.id === questId);
      if (_index >= 0) {
        questModule.questList[_index].state = state;
      }
    }
  };

  /** 
   * 好感度工具类
   * @param {QuestInfo} questInfo 任务信息
   * @param {object} config 其他配置
   */
  class Utils_Quest {
    /** 任务列表 */
    static get questList() {
      return questModule.questList;
    }
    /**
     * 创建新任务
     * @param {string} questId 任务Id
     * @param {object} [config={}] 额外配置
     */
    static claimQuest(questId, config = {}) {
      questModule.claimQuest(questId, config);
    }
    /**
     * 删除任务
     * @param {string} questId 任务Id
     */
    static removeQuest(questId) {
      questModule.removeQuest(questId);
    }
    /**
     * 获取当前的任务列表
     * @param {('inactive'|'available'|'inprogress'|'pending_review'|'succeeded'|'failed'|'invalid')[]} stateList 状态列表
     * @returns 
     */
    static getCurrentQuestList(stateList = []) {
      return questModule.getCurrentQuestList(stateList);
    }
  }
  window.Utils_Quest = Utils_Quest;

  if (Utils.RPGMAKER_NAME === "MZ") {
    PluginManager.registerCommand(PluginName, 'addFavor', args => {
      const _value = Number(args.value);
      Utils_Favor.addFavor(_value, args.actor, args.operation);
    });
  }

  const Scene_Boot_create = Scene_Boot.prototype.create;
  Scene_Boot.prototype.create = function() {
    Scene_Boot_create.call(this);
    _init();
  };
  
})();