//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Spine.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - Spine插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】Spine插件。
 * 
 * 
 * @command dialogImgControl
 * @text 对话框图片控制
 * 
 * @arg spineName
 * @text spine缓存名
 * @type string
 * @default my_spine
 * 
 * @arg position
 * @text 图片坐标
 * @type struct<point>
 * @desc 相对于整个屏幕的坐标，左上角为0,0
 * @default {"x":"0","y":"0"}
 * 
 * @arg motion
 * @text spine要设置的动作
 * @type string
 * @default talk
 * 
 * @arg loop
 * @text 动作是否循环
 * @type boolean
 * @on 动作循环
 * @off 动作不循环
 * @default false
 * 
 * @arg direction
 * @text spine的横向朝向
 * @type select
 * @option 正常朝向
 * @value 1
 * @option 反向朝向
 * @value -1
 * @default 1
 * 
 * @arg visible
 * @text 图片显示/隐藏
 * @type boolean
 * @on 显示图片
 * @off 隐藏图片
 * @default true
 * 
 * 
 * @command loadSpine
 * @text 加载Spine动画
 * @desc 加载spine动画并且初始化
 * 
 * @arg propName
 * @text 在当前场景的属性名
 * @desc 在当前场景的属性名，不写则使用spineName
 * @type text
 * 
 * @arg spineName
 * @text Spine动画名称
 * @desc Spine动画名称
 * @type text
 * 
 * @arg skinList
 * @text 默认皮肤
 * @desc 默认皮肤
 * @type text[]
 * 
 * @arg motionName
 * @text 默认动作
 * @desc 默认动作
 * @type text
 * 
 * @arg loop
 * @text 是否循环
 * @desc 是否循环
 * @type boolean
 * @on 循环
 * @off 不循环
 * @default true
 * 
 * @arg visible
 * @text 显示/隐藏
 * @desc 显示/隐藏
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @default true
 * 
 * @arg x
 * @text 坐标X
 * @desc 坐标X
 * @type number
 * @min -10000
 * @default 0
 * 
 * @arg y
 * @text 坐标Y
 * @desc 坐标Y
 * @type number
 * @min -10000
 * @default 0
 * 
 * @arg scale
 * @text 缩放比例
 * @desc 缩放比例，不填写则为默认动画缩放比例
 * @type text
 * 
 * @arg level
 * @text 放置层级
 * @type select
 * @option 最顶层
 * @value top
 * @option 背景层
 * @value back
 * @option 立绘层
 * @value tachie
 * 
 * @arg extraLevel
 * @text 额外层级
 * @type number
 * @min -100
 * @default 0
 * 
 */

(() => {

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Module_Spine";

  const { ParseSystem } = Zaun.Core;
  const { setSkin } = Zaun.SpineSystem;


  const spineModule = {
    /** Spine资源列表 */
    preload: {
      
      /** 睡觉-Q版 */
      sleep: {
        cacheName: "sleep",
        imgNames: ["sleep/sleep.png"],
        skeletonUrl: "sleep/sleep",
        atlasUrl: "sleep/sleep",
        isSkel: false,
        skin: [],
        version: 42,
        timeScale: 1,
        motion: "sleep",
        Direction: 1,
        scale: 0.4,
      },

      /** 加奈 - 静态立绘 */
      kanaTachie: {
        cacheName: "kanaTachie",
        imgNames: ["kana_tachie/kana-tachie.png", "kana_tachie/kana-tachie_2.png"],
        skeletonUrl: "kana_tachie/kana-tachie",
        atlasUrl: "kana_tachie/kana-tachie",
        isSkel: false,
        skin: ["clothes-01", "face-05"],
        version: 42,
        timeScale: 1,
        motion: "idle",
        Direction: 1,
        scale: 1,
      },
      /** 千夏 - 静态立绘 */
      chinatsuTachie: {
        cacheName: "chinatsuTachie",
        imgNames: [
          "chinatsu_tachie/chinatsu-tachie.png"
        ],
        skeletonUrl: "chinatsu_tachie/chinatsu-tachie",
        atlasUrl: "chinatsu_tachie/chinatsu-tachie",
        isSkel: false,
        skin: ["clothes-s-04", "face-01"],
        version: 42,
        timeScale: 1,
        motion: "idle",
        Direction: 1,
        scale: 0.55,
      },
      /** 由纪 - 静态立绘 */
      yukiTachie: {
        cacheName: "yukiTachie",
        imgNames: [
          "yuki_tachie/yuki-tachie.png"
        ],
        skeletonUrl: "yuki_tachie/yuki-tachie",
        atlasUrl: "yuki_tachie/yuki-tachie",
        isSkel: false,
        skin: ["clothes-01", "face-02"],
        version: 42,
        timeScale: 1,
        motion: "idle",
        Direction: 1,
        scale: 0.48,
      },
      /** 艾露 - 静态立绘 */
      ereTachie: {
        cacheName: "ereTachie",
        imgNames: [
          "ere_tachie/ere-tachie.png"
        ],
        skeletonUrl: "ere_tachie/ere-tachie",
        atlasUrl: "ere_tachie/ere-tachie",
        isSkel: false,
        skin: ["clothes_01", "clothes_a1", "face_a0", "face_01"],
        version: 42,
        timeScale: 1,
        motion: "idle",
        Direction: 1,
        scale: 0.9,
      },
      
      /** 加奈 - 床上互动 */
      kanaInteract: {
        cacheName: "kanaInteract",
        imgNames: ["kana_interact/jianai.png", "kana_interact/jianai_2.png"],
        skeletonUrl: "kana_interact/jianai",
        atlasUrl: "kana_interact/jianai",
        isSkel: false,
        skin: ["01"],
        version: 42,
        timeScale: 1,
        motion: "idle_xx",
        Direction: 1,
        scale: 0.84,
      },
      /** 加奈 - 夜袭 */
      kanaYobai: {
        cacheName: "kanaYobai",
        imgNames: [
          "kana_yobai/kana-yobai.png",
          "kana_yobai/kana-yobai_2.png",
        ],
        skeletonUrl: "kana_yobai/kana-yobai",
        atlasUrl: "kana_yobai/kana-yobai",
        isSkel: false,
        skin: [],
        version: 42,
        timeScale: 1,
        motion: "",
        Direction: 1,
        scale: 0.84,
      },
      /** 加奈 - 洗澡 */
      kanaBath: {
        cacheName: "kanaBath",
        imgNames: ["kana_bath/xizao.png", "kana_bath/xizao_2.png"],
        skeletonUrl: "kana_bath/xizao",
        atlasUrl: "kana_bath/xizao",
        atlasUrl: "kana_bath/xizao",
        isSkel: false,
        skin: ["2"],
        version: 42,
        timeScale: 1,
        motion: "idle1",
        Direction: 1,
        scale: 0.67,
      },
      /** 加奈 - 洗澡（无背景） */
      kanaBath_nobg: {
        cacheName: "kanaBath_nobg",
        imgNames: ["kana_bath_nobg/xizao_nobg.png"],
        skeletonUrl: "kana_bath_nobg/xizao_nobg",
        atlasUrl: "kana_bath_nobg/xizao_nobg",
        atlasUrl: "kana_bath_nobg/xizao_nobg",
        isSkel: false,
        skin: ["2"],
        version: 42,
        timeScale: 1,
        motion: "idle1",
        Direction: 1,
        scale: 0.67,
      },

      Duran_ske: {
        cacheName: "Duran_ske",
        imgNames: ["Duran_ske.png"],
        skeletonUrl: "Duran_ske",
        atlasUrl: "Duran_ske",
        isSkel: false,
        skin: ["default"],
        version: 37,
        timeScale: 1,
        motion: "Idle(Combat)",
        Direction: 1,
        scale: 1,
      },
    },
  };

  window.SpineManager = {
    preloadSpine(spineName) {
      const spineOptions = spineModule.preload[spineName];
      const source = ImageManager.loadSpine(spineOptions);
      source.spineOptions = spineOptions;
      return source;
    },
    createSpine(source) {
      const { skeletonData, spineOptions } = source;
      const { skin, timeScale, motion, scale, version } = spineOptions;
      const Spine = version === 42 ? Zaun.Spine42.Spine : Zaun.Spine.Spine;
      const spine = new Spine(skeletonData);

      setSkin(skin, spine, version);
      spine.scale.set(scale, scale);
      spine.state.timeScale = timeScale;
      spine._width = skeletonData.width;
      spine._height = skeletonData.height;

      if (source.cacheName.indexOf("Tachie") >= 0) {
        spine.tachieInfo = { skin, motion, version, spineName: source.cacheName };
      }
      spine.spineInfo = { skin, motion, version, spineName: source.cacheName };

      let anime;
      if (motion) {
        anime = spine.state.setAnimation(0, motion, true);
      }
      
      // $gameData.tempSceneInfo.isInit && 
      if (!$gameData.tempSceneInfo.canUse) {
        if (!$gameData.tempSceneInfo.spineInfos[source.cacheName]) {
          $gameData.tempSceneInfo.spineInfos[source.cacheName] = {
            skin, motion, version, timeScale, scale,
            spineName: source.cacheName, visible: true,
            actor: source.cacheName.indexOf("Tachie") >= 0 ? source.cacheName.replace("Tachie", "") : source.cacheName,
          };
        }
      }


      // spine.state.addListener({
      //   complete: (track, _event) => {
      //     // 如果轨道存在
      //     if (track !== void 0) {
      //       // 轨道不循环的情况下，根据轨道当前的动作名 进行判断，后面要播放什么动作
      //       if (track.trackIndex === 0 && !track.loop && track.isComplete() && !track.next) {
      //         switch (track.animation.name) {
      //           case "": {
      //             //
      //             break;
      //           }
      //           default: {
      //             // SpineManager.clearMotion(spine, track.trackIndex);
      //             // spine.state.setAnimation(track.trackIndex, motion, true);
      //             break;
      //           }
      //         }
      //       }
      //     }
      //   }
      // });
      return { spine, anime };
    },
    changeSkin_basic(spine, skinList) {
      if (spine.tachieInfo) {
        spine.tachieInfo.skin = skinList;
      }
      if (spine.spineInfo) {
        spine.spineInfo.skin = skinList;
      }
      
      setSkin(skinList, spine, 42);
    },
    changeSkin(spine, skinList) {
      if (spine.tachieInfo) {
        spine.tachieInfo.skin = skinList;
      }
      if (spine.spineInfo) {
        spine.spineInfo.skin = skinList;
      }

      if ($gameData.tempSceneInfo.isInit) {
        if ($gameData.tempSceneInfo.spineInfos[spine.spineInfo.spineName]) {
          $gameData.tempSceneInfo.spineInfos[spine.spineInfo.spineName].skin = skinList;
        }
      }
      setSkin(skinList, spine, 42);
    },
    /**
     * 增加新动作
     * @param {string} motion 动作名称 | 动作
     * @param {boolean} loop 是否循环
     * @param {number} [trackIndex=0]  轨道索引
     * @param {'add'} mixBlend 混合模式
     */
    addMotion(spine, motion, loop = true, trackIndex = 0, mixBlend) {
      const _animation = spine.state.addAnimation(trackIndex, motion, loop);
      // if (mixBlend) _animation.mixBlend = Zaun.Spine.MixBlend[mixBlend];
      return _animation;
    },
    /**
     * 切换新动作
     * @param {string} motion 动作名称 | 动作
     * @param {boolean} loop 是否循环
     * @param {number} [trackIndex=0]  轨道索引
     * @param {object} config 混合模式
     * @param {'add'} config.mixBlend 混合模式
     * @param {number} [config.speed=1] 播放速度
     */
    setMotion(spine, motion, loop = true, trackIndex = 0, {
      mixBlend, speed
    } = {}) {
      const _animation = spine.state.setAnimation(trackIndex, motion, loop);
      if (speed) {
        spine.state.timeScale = speed;
      }
      // if (mixBlend) {
      //   _animation.mixBlend = Zaun.Spine.MixBlend[mixBlend];
      //   _animation.alpha = 0;
      // }
      return _animation;
    },
    /** 清空动作 */
    clearMotion(spine, trackIndex) {
      return spine.state.setEmptyAnimation(trackIndex);
      // return spine.state.setEmptyAnimations(trackIndex);
      if (trackIndex === undefined) {
        spine.state.clearTracks();
      } else {
        spine.state.clearTrack(trackIndex);
      }
    },
    /**
     * 获取动画列表
     */
    getAnimationList(spine, trackIndex = 0) {
      let _animeList = [];
      let _anime;
      do {
        _anime = spine.state.getCurrent(trackIndex);
        _animeList.push(_anime);
      } while (_anime);

      return _animeList;
    },
    /** 初始化数据（初始化立绘Spine） */
    initGameData() {
      SpineManager.preloadSpine("kanaTachie");
      SpineManager.preloadSpine("chinatsuTachie");
      SpineManager.preloadSpine("yukiTachie");
      SpineManager.preloadSpine("ereTachie");
    }
  }

  class Utils_Spine {
    /**
     * 加载Spine文件
     * @param {string} spineName spine动画名
     * @param {object} [config] 配置文件
     * @param {string} [config.propName] 保存的属性名
     * @param {string[]} [config.skinList] 皮肤列表
     * @param {string} [config.motionName] 动作名
     * @param {boolean} [config.loop=true] 是否循环
     * @param {boolean} [config.visible=true] 是否可见
     * @param {number} [config.x=0] x坐标
     * @param {number} [config.y=0] y坐标
     * @param {number} [config.scale=1] 缩放比例
     * @param {string} [config.level] 所属层级
     */
    static loadSpine(spineName, config = { propName: '', skinList: [], motionName: '', loop: true, visible: true, x: 0, y: 0, scale: 1, extraLevel: 0, level: 'back' }) {
      const scene = SceneManager._scene;
      const source = SpineManager.preloadSpine(spineName);
      source.addListener(source => {
        const { spine } = SpineManager.createSpine(source);
        spine.visible = config.visible;

        spine.spineInfo = {};
        spine.spineInfo.spineName = spineName;

        spine.position.set(config.x, config.y);
        spine.scale.set(config.scale);

        if (config.motion) {
          spine.state.setAnimation(0, config.motion, config.loop === undefined ? true : config.loop);
          spine.spineInfo.motion = config.motion;
        }
        if (config.skin && config.skin.length > 0) {
          SpineManager.changeSkin(spine, config.skin);
          spine.spineInfo.skin = config.skin;
        }

        scene[config.propName || spineName] = spine;

        const _spineContainer = new SpineContainer();
        _spineContainer.addChild(spine);

        const _extraLevel = config.extraLevel || 0;

        if (typeof config.level === 'function') {
          config.level(_spineContainer, spine);
        } else {
          if (config.level === 'tachie') {
            if (_extraLevel === 0) {
              scene.tachieContainer.addChild(_spineContainer);
            } else if (_extraLevel > 0) {
              scene.tachieContainer.addChildAt(_spineContainer, _extraLevel);
            } else {
              scene.tachieContainer.addChildAt(_spineContainer, scene.tachieContainer.children.length + _extraLevel);
            }
          } else if (config.level === 'back') {
            if (_extraLevel === 0) {
              scene.backUIContainer.addChild(_spineContainer);
            } else if (_extraLevel > 0) {
              scene.backUIContainer.addChildAt(_spineContainer, _extraLevel);
            } else {
              scene.backUIContainer.addChildAt(_spineContainer, scene.backUIContainer.children.length + _extraLevel);
            }
          } else if (config.level === 'top') {
            if (_extraLevel === 0) {
              scene.addChild(_spineContainer);
            } else if (_extraLevel > 0) {
              scene.addChildAt(_spineContainer, _extraLevel);
            } else {
              scene.addChildAt(_spineContainer, scene.children.length + _extraLevel);
            }
          }
        }
      });
    }
    static initGameData() {
      
    }
  }
  window.Utils_Spine = Utils_Spine;

  if ('MZ' === Utils.RPGMAKER_NAME) {
    PluginManager.registerCommand(PluginName, "dialogImgControl", function(arg) {
      if (SceneManager._scene._messageWindow === void 0) return;
      arg = ParseSystem.toParse(arg);
      SceneManager._scene._speakerContainer.changeSpineBySpeakerName(arg);
    });
    // 加载基础Spine动画
    PluginManager.registerCommand(PluginName, 'loadSpine', function(args) {
      const spineOptions = spineModule.preload[args.spineName];
      Utils_Spine.loadSpine.call(this, args.spineName, {
        motion: args.motion || spineOptions.motion,
        propName: args.propName,
        loop: args.loop !== 'false',
        skin: args.skinList ? JSON.parse(args.skinList) : spineOptions.skin,
        visible: args.visible !== 'false',
        x: Number(args.x || 0),
        y: Number(args.y || 0),
        scale: Number(args.scale || spineOptions.scale || 1),
        level: args.level || 'back',
        extraLevel: Number(args.extraLevel || 0)
      });
    });
  }

})();

