//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_State.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 状态插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】状态相关插件。
 * 
 * 
 */
// #endregion
(() => {

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_State";
  
  const typeDefine = {
  };
  // #endregion

  // #region 插件参数

  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);

  /** 妹妹加奈的评价表 */
  const evaluateMap = [
    // 低好感 低色情 低理智
    [0, 0, 0, '人渣的'],
    // 中好感 低色情 低理智
    [1, 0, 0, '糟糕的'],
    // 高好感 低色情 低理智
    [2, 0, 0, '迷恋着的'],

    // 低好感 中色情 低理智
    [0, 1, 0, '精虫上脑的'],
    // 中好感 中色情 低理智
    [1, 1, 0, '油腔滑调的'],
    // 高好感 中色情 低理智
    [2, 1, 0, '充满魅力的'],

    // 低好感 高色情 低理智
    [0, 2, 0, '变态的'],
    // 中好感 高色情 低理智
    [1, 2, 0, '迷人的'],
    // 高好感 高色情 低理智
    [2, 2, 0, '唯一的'],

    // 低好感 低色情 高理智
    [0, 0, 1, '无可救药的'],
    // 中好感 低色情 高理智
    [1, 0, 1, '努力的'],
    // 高好感 低色情 高理智
    [2, 0, 1, '成熟的'],

    // 低好感 中色情 高理智
    [0, 1, 1, '糟糕的'],
    // 中好感 中色情 高理智
    [1, 1, 1, '温柔的'],
    // 高好感 中色情 高理智
    [2, 1, 1, '帅气的'],

    // 低好感 高色情 高理智
    [0, 2, 1, '变态的'],
    // 中好感 高色情 高理智
    [1, 2, 1, '好色的'],
    // 高好感 高色情 高理智
    [2, 2, 1, '死心塌地的'],
  ];

  /** 妹妹加奈的想法列表 */
  const thoughtList = [
    {
      id: 1,
      once: true,
      triggerTime: 0,
      text: '要和这种笨蛋老哥生活一个月真的好吗……事到如今只能听天由命了呢……',
      priority: 0,
      duration: 60,
      get condition() {
        return Utils_Favor.kanaFavorLevel == 1;
      }
    }, {
      id: 2,
      once: false,
      triggerTime: 0,
      text: '这段时间过得还算不错，没想到笨蛋老哥也没想象中那么糟糕嘛～',
      priority: 0,
      duration: 60,
      get condition() {
        return Utils_Favor.kanaFavorLevel == 2;
      }
    }, {
      id: 3,
      once: false,
      triggerTime: 0,
      text: '与哥哥生活的这几天真是梦幻啊……要是这样的日子能一直持续下去就好了呢～',
      priority: 0,
      duration: 60,
      get condition() {
        return Utils_Favor.kanaFavorLevel == 3;
      }
    }, {
      id: 4,
      once: false,
      triggerTime: 0,
      text: '哥哥最近可真是努力呢～逐渐有个大人的样子了～但总感觉他和千夏是不是走的有点近了？稍微有点在意呢……',
      priority: 1,
      duration: 1440,
      get condition() {
        const _chinatsuFavor = Utils_Favor.chinatsuFavor;
        const _maxFavor = Math.max(
          Utils_Favor.kanaFavor / 3, Utils_Favor.chinatsuFavor,
          Utils_Favor.yukiFavor, Utils_Favor.ereFavor,
        );
        return _chinatsuFavor > _maxFavor && _chinatsuFavor <= 50;
      }
    }, {
      id: 5,
      once: false,
      triggerTime: 0,
      text: '最近老哥他怎么老是大半夜偷偷出去啊，回来的时候也总是鬼鬼祟祟的……该不会是在外面有其他女人了吧？！',
      priority: 1,
      duration: 1440,
      get condition() {
        const _yukiFavor = Utils_Favor.chinatsuFavor;
        const _maxFavor = Math.max(
          Utils_Favor.kanaFavor / 3, Utils_Favor.chinatsuFavor,
          Utils_Favor.yukiFavor, Utils_Favor.ereFavor,
        );
        return _yukiFavor > _maxFavor && _yukiFavor <= 50;
      }
    }, {
      id: 6,
      once: true,
      triggerTime: 0,
      text: '要和这样的老哥一起生活一个月什么的…真的没问题吗？',
      priority: 2,
      duration: 1440,
      get condition() {
        return Utils_Time.day <= 2;
      }
    }, {
      id: 7,
      once: true,
      triggerTime: 0,
      text: '我是知道最近的资金有点紧张啦，但是连续吃三天泡面什么的也太过分了吧…',
      priority: 2,
      duration: 1440,
      get condition() {
        // 连续吃泡面天数
        const _count = $gameVariables.value(41);
        return _count >= 3;
      }
    }, {
      id: 8,
      once: true,
      triggerTime: 0,
      text: '老哥这是中彩票了吗？这几天的伙食有点太好了吧？大方的老哥可真帅～',
      priority: 2,
      duration: 1440,
      get condition() {
        // 连续吃大餐天数
        const _count = $gameVariables.value(43);
        return _count >= 3;
      }
    },
  ];

  /** 成就列表 */
  const achievementList = [
    {
      id: 1,
      title: '今天也要摸头',
      desc: '摸妹妹的头的行为好像越来越自然了，应、应该没关系吧…？',
      get condition() {
        // 连续摸头天数
        const _count = $gameVariables.value(61);
        return true;
      }
    }, {
      id: 2,
      title: '巨乳控',
      desc: '巨乳即是正义，罩杯即是真理！不知道继续揉下去妹妹还会不会变大～',
      get condition() {
        // 连续摸头天数
        const _count = $gameVariables.value(62);
        return _count >= 3;
      }
    }, {
      id: 3,
      title: '精液中毒',
      desc: '虽然射进去的时候确实爽，但……应该不会怀孕吧？',
      get condition() {
        // 连续内射天数
        const _count = $gameVariables.value(63);
        return _count >= 3;
      }
    }, {
      id: 4,
      title: '初次的夜袭',
      desc: '对着睡着的妹妹肆意宣泄欲望的背德感实在是欲罢不能啊～',
      get condition() {
        // 进行了夜袭（有上次夜袭时间）
        return true;
      }
    }, {
      id: 5,
      title: '夜袭狂魔',
      desc: '夜袭的行为越来越熟练了，用不了多久加奈就会将快感用身体记住吧～',
      get condition() {
        // 连续夜袭天数
        const _count = $gameVariables.value(45);
        return true;
      }
    }, {
      id: 6,
      title: '温柔的哥哥',
      desc: '与加奈的气氛越来越好了，继续努力吧✓',
      get condition() {
        // 连续3句连续聊天成功天数
        const _count = $gameVariables.value(50);
        return _count >= 3;
      }
    }, {
      id: 6,
      title: '糟糕的哥哥',
      desc: '与加奈的气氛越来越差了，到底是哪里出了问题……',
      get condition() {
        // 连续3句连续聊天天数
        // const _count = $gameVariables.value(50);
        // return _count >= 3;
        return true;
      }
    }, {
      id: 7,
      title: '胖次收集1',
      desc: '妹妹的胖次令人着迷，最适合作为施法素材了',
      get condition() {
        return false;
      }
    }, {
      id: 8,
      title: '胖次收集2',
      desc: '妹妹的胖次无与伦比，最适合作为宝物珍藏了',
      get condition() {
        return false;
      }
    }, {
      id: 9,
      title: '胖次收集3',
      desc: '身为妹妹胖次收藏家的我对于妹妹的每条胖次都了如指掌～',
      get condition() {
        return false;
      }
    }, {
      id: 9,
      title: '森林攻略完成',
      desc: '虽然蚊虫有点多了，但宁静祥和的氛围更令人陶醉。',
      get condition() {
        return false;
      }
    }, {
      id: 10,
      title: '垃圾山攻略完成',
      desc: '垃圾堆里也有宝物，这是我和妹妹儿时的宝藏。',
      get condition() {
        return false;
      }
    },
  ];

  const stateModule = {
    /** 检查是否有新的成就 */
    checkAchievement() {
      const _list = achievementList.slice(0);
      for (let i = 0; i < _list.length; i++) {
        const _item = _list[i];
        if (!$gameData.achievements.includes(_item.id) && _item.condition) {
          $gameData.achievements.push(_item.id);
        }
      }
    },
    /** 获取现有的成就 */
    getAchievements() {
      return achievementList.filter(i => i.condition);
    },
    /** 加奈 */
    kana: {
      /** 评价 @type {string} */
      get evaluate() {
        // 1. 好感度(3级)  2.色情度(3级)  3.理智(2级)
        const _evaluate = evaluateMap.find(i => {
          return i[0] === Utils_Favor.kanaFavorLevel - 1 &&
            i[1] === Utils_Favor.kanaSexLevel - 1 &&
            i[2] === Utils_Actor.sanLevel;
        });
        return TranslateUtils.getText(_evaluate ? _evaluate[3] : '[ERROR]') + TranslateUtils.getText('哥哥');
      },
      /** 想法 @type {string} */
      get thought() {
        let _currentThought = undefined;
        // 首先遍历现有的状态，判断是否有符合要求的
        const _thoughtList = thoughtList.slice().sort((a, b) => b.priority - a.priority);
        for (let i = 0; i < _thoughtList.length; i++) {
          const _thought = _thoughtList[i];
          
          if (_thought.condition) {
            _currentThought = _thought;
            break;
          }
        }

        // 然后判断当前是否有想法，且是否在时间范围内
        const _oldThought = $gameData.thought.kana;
        if (_oldThought.currentThoughtId === 0) {
          // 之前如果没有想法，则将新想法覆盖
          $gameData.thought.kana.currentThoughtId = _currentThought.id;
          $gameData.thought.kana.execTime = Utils_Time.time;
          $gameData.thought.kana.duration = _currentThought.duration;
          return _currentThought.text;
        } else if (_oldThought.currentThoughtId === _currentThought.id) {
          // 之前想法相同，则直接返回当前想法
          return _currentThought.text;
        } else if (_oldThought.priority >= _currentThought.priority) {
          // 如果旧想法的优先级高于或者等于新想法，则覆盖
          $gameData.thought.kana.currentThoughtId = _currentThought.id;
          $gameData.thought.kana.execTime = Utils_Time.time;
          $gameData.thought.kana.duration = _currentThought.duration;
          return _currentThought.text;
        } else {
          // 否则返回旧想法
          const _thought = thoughtList.find(i => i.id === _oldThought.currentThoughtId);
          return _thought.text;
        }
      }
    },
    /** 千夏 */
    chinatsu: {
      /** 是否认识 */
      get isKnow() {
        return $gameSwitches.value(28) || false;
      },
      /** 评价 @type {string} */
      get evaluate() {
        return TranslateUtils.getText('是个有意思的人呢');
      },
    },
    /** 由纪 */
    yuki: {
      /** 是否认识 */
      get isKnow() {
        return $gameSwitches.value(29) || false;
      },
      /** 评价 @type {string} */
      get evaluate() {
        return TranslateUtils.getText('是个温柔的小哥呢～');
      },
    },
    /** 艾露 */
    ere: {
      /** 是否认识 */
      get isKnow() {
        return $gameSwitches.value(30) || false;
      },
      /** 评价 @type {string} */
      get evaluate() {
        return TranslateUtils.getText('温柔的前辈…只能是我一个人的～♡');
      },
    }
  };

  class Utils_State {
    /** 检查是否有新的成就 */
    static checkAchievement() {
      stateModule.checkAchievement();
    }
    /** 获取已经获得的成就 */
    static getAchievements() {
      return stateModule.getAchievements();
    }
    /** 加奈对哥哥的评价 @type {string} */
    static get kanaEaluate() {
      return stateModule.kana.evaluate;
    }
    /** 加奈对哥哥的想法 @type {string} */
    static get kanaThought() {
      return stateModule.kana.thought;
    }
    /** 千夏对哥哥的评价 @type {string} */
    static get chinatsuEaluate() {
      if (stateModule.chinatsu.isKnow) {
        return stateModule.chinatsu.evaluate;
      } else {
        return TranslateUtils.getText('???');
      }
    }
    /** 由纪对哥哥的评价 @type {string} */
    static get yukiEaluate() {
      if (stateModule.yuki.isKnow) {
        return stateModule.yuki.evaluate;
      } else {
        return TranslateUtils.getText('???');
      }
    }
    /** 艾露对哥哥的评价 @type {string} */
    static get ereEaluate() {
      if (stateModule.ere.isKnow) {
        return stateModule.ere.evaluate;
      } else {
        return TranslateUtils.getText('???');
      }
    }
  }
  window.Utils_State = Utils_State;

})();