//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Tachie.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 立绘操作插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】立绘处理相关插件。
 * 包含表情、基础位置、气泡效果、特殊效果等操作。
 * 
 * 
 * @command showTachie
 * @text 加载立绘
 * @desc 加载spine动画并且初始化立绘
 * 
 * @arg location
 * @text 立绘位置
 * @type select
 * @option 左边
 * @value left
 * @option 右边
 * @value right
 * @option 中间
 * @value center
 * @default center
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg motion
 * @text 默认动作
 * @type text
 * @default idle
 * 
 * @arg skin
 * @text 默认皮肤
 * @desc 注意第一个是衣服，第二个是表情，第三个是附加表情
 * @type text[]
 * @default []
 * 
 * @arg alpha
 * @text 透明度
 * @desc 立绘透明度
 * @type number
 * @min 0
 * @max 1
 * @default 1
 * 
 * 
 * @command action_fadeIn
 * @text 立绘动作 - 渐显
 * @desc 立绘动作 - 从某个方向渐显
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg duration
 * @text 帧数
 * @type number
 * @default 10
 * 
 * @arg rx
 * @text X坐标
 * @type number
 * @min -10000
 * @max 10000
 * @default 20
 * 
 * @arg ry
 * @text Y坐标
 * @type number
 * @min -10000
 * @max 10000
 * @default 0
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command action_move
 * @text 立绘动作 - 移动
 * @desc 立绘动作 - 往某个坐标移动，逻辑等同渐隐或渐显
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg duration
 * @text 帧数
 * @type number
 * @default 10
 * 
 * @arg rx
 * @text X坐标
 * @type number
 * @min -10000
 * @max 10000
 * @default 20
 * 
 * @arg ry
 * @text Y坐标
 * @type number
 * @min -10000
 * @max 10000
 * @default 0
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command action_fadeOut
 * @text 立绘动作 - 渐隐
 * @desc 立绘动作 - 从某个方向渐隐
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg duration
 * @text 帧数
 * @type number
 * @default 10
 * 
 * @arg rx
 * @text X坐标
 * @type number
 * @min -10000
 * @max 10000
 * @default 20
 * 
 * @arg ry
 * @text Y坐标
 * @type number
 * @min -10000
 * @max 10000
 * @default 0
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command showBalloon
 * @text 显示气泡 - 通用
 * 
 * @arg balloonName
 * @text 气泡名称
 * @desc 气泡名称
 * @type select
 * @option 兴奋（左
 * @value e01_L,兴奋（左
 * @option 兴奋（右
 * @value e01_R,兴奋（右
 * @option 惊讶1
 * @value e02,惊讶1
 * @option 惊讶2
 * @value e03,惊讶2
 * @option 新主意
 * @value e04,新主意
 * @option 晕眩
 * @value e05,晕眩
 * @option 疑问1
 * @value e06,疑问1
 * @option 疑问2
 * @value e07,疑问2
 * @option 喜欢
 * @value e08,喜欢
 * @option 鲜花
 * @value e09,鲜花
 * @option 混乱1
 * @value e10,混乱1
 * @option 生气
 * @value e11,生气
 * @option 流汗
 * @value e12,流汗
 * @option 慌张（左
 * @value e13_L,慌张（左
 * @option 慌张（右
 * @value e13_R,慌张（右
 * @option 轻微生气（左
 * @value e14_L,轻微生气（左
 * @option 轻微生气（右
 * @value e14_R,轻微生气（右
 * @option 心碎
 * @value e15,心碎
 * @option 音符
 * @value e16,音符
 * @option 冒泡
 * @value e17,冒泡
 * @option 麻了（左
 * @value e18_L,麻了（左
 * @option 麻了（右
 * @value e18_R,麻了（右
 * @option 兴高采烈（左
 * @value e19_L,兴高采烈（左
 * @option 兴高采烈（右
 * @value e19_R,兴高采烈（右
 * @option 糟心
 * @value e20,糟心
 * @option 睡觉
 * @value e21,睡觉
 * @option 混乱
 * @value e22,混乱
 * @option 思考
 * @value e23,思考
 * @option 星星
 * @value e24,星星
 * @option 爆炸
 * @value e25,爆炸
 * @option 生气惊讶（左
 * @value e26_L,生气惊讶（左
 * @option 生气惊讶（右
 * @value e26_R,生气惊讶（右
 * 
 * @arg actor
 * @text 角色名称
 * @desc 角色名称
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg loc
 * @text 气泡位置
 * @desc 气泡位置
 * @type select
 * @option 左边
 * @value left
 * @option 右边
 * @value right
 * @default left
 * 
 * 
 * @command changeFace
 * @text 修改表情 - 通用
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg face
 * @text 默认表情
 * @type number
 * 
 * 
 * @command changeFaceByKana
 * @text 修改表情 - 加奈
 * 
 * @arg face
 * @text 默认表情
 * @type select
 * @option 尴尬 - 01
 * @value 01,尴尬
 * @option 鄙视 - 03
 * @value 03,鄙视
 * @option 不满 - 04
 * @value 04,不满
 * @option 呆滞 - 05
 * @value 05,呆滞
 * @option 爱心眼 - 06
 * @value 06,爱心眼
 * @option 不开心 - 07
 * @value 07,不开心
 * @option 大哭 - 08
 * @value 08,大哭
 * @option 委屈 - 09
 * @value 09,委屈
 * @option 流汗 - 10
 * @value 10,流汗
 * @option 轻微生气 - 11
 * @value 11,轻微生气
 * @option 生气 - 12
 * @value 12,生气
 * @option 普通 - 13
 * @value 13,普通
 * @option 可爱猫嘴 - 14
 * @value 14,可爱猫嘴
 * @option 眨眼 - 15
 * @value 15,眨眼
 * @option 开心 - 17
 * @value 17,开心
 * @option 眯眼笑 - 18
 * @value 18,眯眼笑
 * @option 微笑 - 19
 * @value 19,微笑
 * @option 叹气 - 20
 * @value 20,叹气
 * 
 * @arg attach
 * @text 额外表情
 * @type select
 * @option 无
 * @value 
 * @option 脸红1 - a1
 * @value a1,脸红1
 * @option 脸红2 - a2
 * @value a2,脸红2
 * @option 脸黑 - a3
 * @value a3,脸黑
 * @option 哭泣 - a4
 * @value a4,哭泣
 * @option 汗 - a5
 * @value a5,汗
 * 
 * 
 * @command changeFaceByChinatsu
 * @text 修改表情 - 千夏
 * 
 * @arg face
 * @text 默认表情
 * @type select
 * @option 普通 - 04
 * @value 04,普通
 * @option [x]开心 - 02
 * @value 02,开心
 * @option 开心 - 03
 * @value 03,开心
 * @option 生气 - 04
 * @value 04,生气
 * @option 开心 - 05
 * @value 05,开心
 * @option 吃惊 - 06
 * @value 06,吃惊
 * @option 认真 - 07
 * @value 07,认真
 * @option 委屈 - 08
 * @value 08,委屈
 * @option 爱心眼 - 09
 * @value 09,爱心眼
 * @option 生气 - 10
 * @value 10,生气
 * @option 惊讶 - 11
 * @value 11,惊讶
 * @option 看向一侧 - 12
 * @value 12,看向一侧
 * @option 发呆 - 13
 * @value 13,发呆
 * @option 爱心眼2 - 14
 * @value 14,爱心眼2
 * @option 困扰 - 15
 * @value 15,困扰
 * @option 无奈 - 16
 * @value 16,无奈
 * @option 看着 - 17
 * @value 17,看着
 * @option 洗脑 - 18
 * @value 18,洗脑
 * @option 晕眩 - 19
 * @value 19,晕眩
 * 
 * @arg attach
 * @text 额外表情
 * @type select
 * @option 无
 * @value 
 * @option 眼泪1 - a1
 * @value a1,眼泪1
 * @option 眼泪2 - a4
 * @value a4,眼泪2
 * @option 脸红1 - a3
 * @value a3,脸红1
 * @option 脸红2 - a2
 * @value a2,脸红2
 * 
 * 
 * @command changeFaceByYuki
 * @text 修改表情 - 由纪
 * 
 * @arg face
 * @text 默认表情
 * @type select
 * @option 爱心眼 - 01
 * @value 01,爱心眼
 * @option 微笑 - 02
 * @value 02,微笑
 * @option 慌张 - 03
 * @value 03,慌张
 * @option 迷糊 - 04
 * @value 04,迷糊
 * @option 委屈 - 05
 * @value 05,委屈
 * @option 生气 - 06
 * @value 06,生气
 * @option 开心 - 07
 * @value 07,开心
 * @option 皱眉 - 08
 * @value 08,皱眉
 * @option 吃惊 - 09
 * @value 09,吃惊
 * @option 眩晕 - 10
 * @value 10,眩晕
 * @option 张嘴 - 11
 * @value 11,张嘴
 * @option 叹气 - 12
 * @value 12,叹气
 * @option 催眠 - 13
 * @value 13,催眠
 * @option 责怪 - 14
 * @value 14,责怪
 * @option 敷衍 - 15
 * @value 15,敷衍
 * 
 * @arg attach
 * @text 额外表情
 * @type select
 * @option 无
 * @value 
 * @option 脸红 - a1
 * @value a1,脸红
 * @option 脸红 - a3
 * @value a3,脸红
 * @option 黑眼圈 - a2
 * @value a2,黑眼圈
 * 
 * 
 * @command changeFaceByEre
 * @text 修改表情 - 艾露
 * 
 * @arg face
 * @text 默认表情
 * @type select
 * @option 普通表情 - 01
 * @value 01,普通表情
 * @option 爱心眼1 - 02
 * @value 02,爱心眼1
 * @option 生气 - 03
 * @value 03,生气
 * @option 尴尬 - 04
 * @value 04,尴尬
 * @option 吃惊 - 05
 * @value 05,吃惊
 * @option 开心 - 06
 * @value 06,开心
 * @option 无奈 - 07
 * @value 07,无奈
 * @option 微笑 - 08
 * @value 08,微笑
 * @option 爱心眼2 - 09
 * @value 09,爱心眼2
 * @option 阴险（带眼镜） - 10
 * @value 10,阴险
 * 
 * @arg attach
 * @text 额外表情
 * @type select
 * @option 无
 * @value 
 * @option 黑脸 - a2
 * @value a2,黑脸
 * @option 哭泣 - a3
 * @value a3,哭泣
 * @option 脸红 - a4
 * @value a4,脸红
 * 
 * 
 * @command changeClothesByKana
 * @text 修改衣服 - 加奈
 * 
 * @arg clothes
 * @text 衣服
 * @type select
 * @option 校服 - uniform - 01
 * @value 01,校服
 * @option 浴巾 - towel - 02
 * @value 02,浴巾
 * @option 内衣 - underwear - 03
 * @value 03,内衣
 * @option 裸体 - nude - 04
 * @value 04,裸体
 * 
 * 
 * @command changeClothesByChinatsu
 * @text 修改衣服 - 千夏
 * 
 * @arg clothes
 * @text 衣服
 * @type select
 * @option 常服 - normal - 01
 * @value 01,常服
 * @option 内衣 - underwear - 02
 * @value 02,内衣
 * @option 裸体 - nude - 03
 * @value 03,裸体
 * @option 工作服 - uniform - 04
 * @value 04,工作服
 * 
 * 
 * @command changeChestByChinatsu
 * @text 修改胸部尺寸 - 千夏
 * 
 * @arg chest
 * @text 胸部大小
 * @type select
 * @option 巨乳 - large
 * @value l
 * @option 贫乳 - small
 * @value s
 * 
 * 
 * @command changeClothesByYuki
 * @text 修改衣服 - 由纪
 * 
 * @arg clothes
 * @text 衣服
 * @type select
 * @option 常服 - normal - 01
 * @value 01,常服
 * @option 裸体 - nude - 02
 * @value 02,裸体
 * @option 裸体凹陷乳头 - nude - 02
 * @value 03,裸体凹陷乳头
 * 
 * 
 * @command changeClothesByEre
 * @text 修改衣服 - 艾露
 * 
 * @arg clothes
 * @text 衣服
 * @type select
 * @option 常服 - normal - 01
 * @value 01,常服
 * @option 内衣 - underwear - 02
 * @value 02,内衣
 * @option 裸体 - nude - 03
 * @value 03,裸体
 * 
 * 
 * @command changeGlassesByEre
 * @text 修改是否戴眼镜 - 艾露
 * 
 * @arg hasGlasses
 * @text 是否戴眼镜
 * @type boolean
 * @on 戴眼镜
 * @off 不戴眼镜
 * @default true
 * 
 * 
 * @command changeCapByEre
 * @text 修改是否戴帽子 - 艾露
 * 
 * @arg hasCap
 * @text 是否戴帽子
 * @type boolean
 * @on 戴帽子
 * @off 不戴帽子
 * @default true
 * 
 * 
 * @command action_shake
 * @text 立绘动作 - 震动
 * @desc 立绘动作 - 立绘震动
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg duration
 * @text 帧数
 * @type number
 * @default 30
 * 
 * @arg loop
 * @text 循环次数
 * @desc 循环次数，注意需要是双数
 * @type number
 * @default 1
 * 
 * @arg power
 * @text 强度
 * @desc 震动强度，默认为10
 * @type number
 * @max 100
 * @default 10
 * 
 * @arg frequency
 * @text 频率
 * @desc 震动频率，默认为2
 * @type number
 * @max 100
 * @default 2
 * 
 * @arg dir
 * @text 方向
 * @desc 震动方向，默认为水平
 * @type select
 * @option horizontal - 水平
 * @value horizontal
 * @option vertical - 竖直
 * @value vertical
 * @default horizontal
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command action_rumble
 * @text 立绘动作 - 随机震动
 * @desc 立绘动作 - 立绘随机震动
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg duration
 * @text 帧数
 * @type number
 * @default 50
 * 
 * @arg loop
 * @text 循环次数
 * @desc 循环次数，注意需要是双数
 * @type number
 * @default 1
 * 
 * @arg power
 * @text 强度
 * @desc 震动强度，默认为12
 * @type number
 * @max 100
 * @default 12
 * 
 * @arg frequency
 * @text 频率
 * @desc 震动频率，默认为1，同时强烈建议保持1不变
 * @type number
 * @max 100
 * @default 1
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command action_nod
 * @text 立绘动作 - 点头
 * @desc 立绘动作 - 点头动作
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg loop
 * @text 循环次数
 * @type number
 * @default 1
 * 
 * @arg duration
 * @text 帧数
 * @type number
 * @default 30
 * 
 * @arg power
 * @text 强度
 * @desc 震动强度（像素），默认为60
 * @type number
 * @max 1000
 * @default 60
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command action_jump
 * @text 立绘动作 - 跳跃
 * @desc 立绘动作 - 跳跃动作
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg loop
 * @text 循环次数
 * @type number
 * @default 1
 * 
 * @arg duration
 * @text 帧数
 * @type number
 * @default 30
 * 
 * @arg power
 * @text 强度
 * @desc 震动强度（像素），默认为40
 * @type number
 * @max 100
 * @default 40
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command action_breath
 * @text 立绘动作 - 呼吸
 * @desc 立绘动作 - 呼吸动作
 * 
 * @arg actor
 * @text 角色
 * @type select
 * @option 加奈 - kana
 * @value kana
 * @option 千夏 - chinatsu
 * @value chinatsu
 * @option 由纪 - yuki
 * @value yuki
 * @option 艾露 - ere
 * @value ere
 * @default kana
 * 
 * @arg loop
 * @text 循环次数
 * @type number
 * @default 1
 * 
 * @arg duration
 * @text 帧数
 * @type number
 * @default 30
 * 
 * @arg power
 * @text 强度
 * @desc 震动强度（像素），默认为1
 * @type number
 * @max 10
 * @default 1
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 */
// #endregion
(() => {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Module_Tachie";
  
  const typeDefine = {
  };
  
  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);

  const locations = {
    'left': { x: 400, y: 1000 },
    'center': { x: 650, y: 1000 },
    'right': { x: 900, y: 1000 }
  };

  
  // #region 命令列表

  /** 命令列表 */
  const Commands = {
    /** 设定当前焦点角色 */
    active: {
      exec(element, action, config) {
        if (typeof config.name === 'string') {
          skitModule.active(config.name);
        } else if (Array.isArray(config.name)) {
          skitModule.active.apply(skitModule, config.name);
        }
      },
      /**
       * 
       * @param {*} element 行动节点
       * @param {*} action 动作
       * @param {*} progress 百分比进度
       * @param {*} config 配置项
       */
      update(element, action, progress, config) {
      }
    },
    /** 切换状态 */
    state: {
      exec(element, action, config) {
        if (config.duration <= 1) {
          skitModule.changeElementState(element.name, config.state);
          action.isComplete = true;
        } else {
          const _elementIndex = skitInfo.children.findIndex(child => child && child.name === element.name);
          if (_elementIndex < 0) throw new Error(`Element ${element.name} not found`);

          const _oldElement = skitInfo.children[_elementIndex];
          const _newElement = skitModule.getElement(element.name, config.state || _oldElement.state, true);
          _newElement.isTemp = true;
          _newElement.container.x = _oldElement.container.x;
          _newElement.container.y = _oldElement.container.y;
          _newElement.container._isGray = _oldElement.container._isGray;
          _newElement.onComplete(() => {
            _newElement.container.canRemove = true;
            element.newElement = _newElement;
            skitInfo.container.addChildAt(element.newElement.container, _elementIndex);
          });
        }
      },
      /**
       * 
       * @param {*} element 行动节点
       * @param {*} action 动作
       * @param {*} progress 百分比进度
       * @param {*} config 配置项
       */
      update(element, action, progress, config) {
        if (!element || action.isComplete) return;
        element.container.alpha = 1 - progress;
        element.newElement.container.alpha = Math.min(progress * 2, 1);

        if (progress >= 1) {

          const _elementIndex = skitInfo.children.findIndex(child => child && child.name === element.name && !child.isTemp);
          if (_elementIndex >= 0) {
            skitInfo.children.splice(_elementIndex, 1, element.newElement);

            const _containerIndex = skitInfo.container.children.findIndex(child => child && child === element.container && !child.canRemove);
            if (_containerIndex >= 0) {
              skitInfo.container.removeChildAt(_containerIndex);
            }

            const _newElement = skitInfo.children.find(child => child && child.name === element.name);
            if (_newElement) {
              delete _newElement.isTemp;
            }
          }
        }
      }
    },
    
    /** 呼吸动画 */
    breath: {
      exec(element, action, config) {
        element.scale.x = 1;
        element.scale.y = 1;
        action.scaleX = element.scale.x;
        action.scaleY = element.scale.y;
      },
      update(element, action, progress, config) {
        // 计算当前的偏移量
        const _power = config.power || 1;

        // 使用余弦波计算缩放偏移量
        const scaleOffset = (Math.cos(2 * Math.PI * progress)) * _power / 80;
        
        element.scale.x = action.scaleX + scaleOffset / 1.2;
        element.scale.y = action.scaleY + scaleOffset;


        
        // const easeInOutSine = (breath) => config.breathSpeed * Math.cos(Math.PI * breath); // 缓动函数

        // const breathEffectX = 0.005 * easeInOutSine(Graphics.frameCount / 180) / (element.scale.x * element.scale.x);
        // const breathEffectY = 0.005 * easeInOutSine(Graphics.frameCount / 60) / (element.scale.y * element.scale.y);

        // element.scale.x = 1 + breathEffectX; // 应用呼吸效果
        // element.scale.y = 1 + breathEffectY;
      }
    },
    /**
     * 镜像
     */
    mirror: {
      exec(element, action, config) {
        action.prevScaleX = element.container.scale.x || 0;
        action.prevScaleY = element.container.scale.y || 0;
      },
      update(element, action, progress, config) {
        const _startX = action.prevScaleX;
        const _startY = action.prevScaleY;

        let _endX = _startX == -1 ? 1 : -1;
        let _endY = _startY == -1 ? 1 : -1;

        switch (config.dir) {
          case 'x':
            element.container.scale.x = _startX + (_endX - _startX) * progress;
            break;
          case 'y':
            element.container.scale.y = _startY + (_endY - _startY) * progress;
            break;
          case 'xy':
            element.container.scale.x = _startX + (_endX - _startX) * progress;
            element.container.scale.y = _startY + (_endY - _startY) * progress;
            break;
        }

        if (progress >= 1) {
          element.container._isMirror = _endX == -1;
        }
      }
    },
    /**
     * 跳跃
     */
    jump: {
      exec(element, action, config) {
        action.prevX = element.x;
        action.prevY = element.y;
      },
      /**
       * 
       * @param {*} element 行动节点
       * @param {*} action 动作
       * @param {*} progress 百分比进度
       * @param {*} config 配置项
       */
      update(element, action, progress, config) {
        const _power = config.power || 60;

        const curve = -4 * _power * progress * (progress - 1); // 简单的抛物线方程

        element.y = action.prevY - curve;
      }
    },
    /**
     * 变换
     */
    transform: {
      exec(element, action, config) {
        const firstNode = element.container.children[0];
        if (config.scale !== undefined) {
          action.scaleX = firstNode.scale.x || 1;
          action.scaleY = firstNode.scale.y || 1;
        }
        if (config.rotate !== undefined) {
          action.rotate = firstNode.rotation || 0;
        }
        if (config.x !== undefined) {
          action.x = firstNode.x;
        }
        if (config.y !== undefined) {
          action.y = firstNode.y;
        }
      },
      /**
       * 
       * @param {*} element 行动节点
       * @param {*} action 动作
       * @param {*} progress 百分比进度
       * @param {*} config 配置项
       */
      update(element, action, progress, config) {

        let x;
        let y;
        let scaleX;
        let scaleY;
        let rotation;

        if (action.x !== undefined) {
          const _startX = action.x;
          const _endX = config.x;
          x = _startX + (_endX - _startX) * progress;
        }
        if (action.y !== undefined) {
          const _startY = action.y;
          const _endY = config.y;
          y = _startY + (_endY - _startY) * progress;
        }

        if (action.scaleX !== undefined) {
          const _startScaleX = action.scaleX;
          const _startScaleY = action.scaleY;
          const _endScaleX = config.scale;
          const _endScaleY = config.scale;

          scaleX = _startScaleX + (_endScaleX - _startScaleX) * progress;
          scaleY = _startScaleY + (_endScaleY - _startScaleY) * progress;
        }

        if (action.rotate !== undefined) {
          rotation = action.rotate + (config.rotate - action.rotate) * progress;
        }

        element.container.setTransform(
          x !== undefined ? x : element.container.x, y !== undefined ? y : element.container.y,
          scaleX, scaleY,
          rotation * (Math.PI / 180),
          0, 0,
          element.container.pivot.x, element.container.pivot.y
        );

      }
    },
    /**
     * 点头/下降
     */
    nod: {
      exec(element, action, config) {
        action.prevX = element.x;
        action.prevY = element.y;
      },
      /**
       * 
       * @param {*} element 行动节点
       * @param {*} action 动作
       * @param {*} progress 百分比进度
       * @param {*} config 配置项
       */
      update(element, action, progress, config) {
        const _power = config.power || 40;

        const curve = _power * progress * (progress - 1); // 简单的抛物线方程

        element.y = action.prevY - curve;
      }
    },
    /** 变换色调 */
    hue: {
      exec(element, action, config) {
        action.endR = 0;
        action.endG = 0;
        action.endB = 0;
      },
      /**
       * 
       * @param {*} element 行动节点
       * @param {*} action 动作
       * @param {*} progress 百分比进度
       * @param {*} config 配置项
       */
      update(element, action, progress, config) {
        let _endR = 0;
        let _endG = 0;
        let _endB = 0;

        if (config.r) {
          const _sr = config.r / config.duration * 2;
          if (config.bounce && progress > 0.5) {
            _endR = -_sr;
          } else {
            _endR = _sr;
          }
          if (action.endR + _endR < 0) _endR = action.endR;
          else if (action.endR + _endR > 255) _endR = 255 - action.endR;
          action.endR += _endR;
        }
        if (config.g) {
          const _sg = config.g / config.duration * 2;
          if (config.bounce && progress > 0.5) {
            _endG = -_sg;
          } else {
            _endG = _sg;
          }
          if (action.endG + _endG < 0) _endG = action.endG;
          else if (action.endG + _endG > 255) _endG = 255 - action.endG;
          action.endG += _endG;
        }
        if (config.b) {
          const _sb = config.b / config.duration * 2;
          if (config.bounce && progress > 0.5) {
            _endB = -_sb;
          } else {
            _endB = _sb;
          }
          if (action.endB + _endB < 0) _endB = action.endB;
          else if (action.endB + _endB > 255) _endB = 255 - action.endB;
          action.endB += _endB;
        }

        for (let i = 0; i < element.container.children.length; i++) {
          const child = element.container.children[i];
          if (child.constructor === Sprite) {
            let index = child.filters.findIndex(filter => filter instanceof PIXI.filters.ColorMatrixFilter);
            if (index >= 0) {
              child.filters[index].adjustTone.call(child.filters[index], _endR, _endG, _endB);
              child._refresh();
            }
          } else if (child.constructor === PIXI.Container) {
            for (let o = 0; o < child.children.length; o++) {
              const leafChild = child.children[o];
              let index = leafChild.filters.findIndex(filter => filter instanceof PIXI.filters.ColorMatrixFilter);
              if (index >= 0) {
                leafChild.filters[index].adjustTone.call(leafChild.filters[index], _endR, _endG, _endB);
                leafChild._refresh();
              }
            }
          }
        }
      }
    },
    /**
     * 震动
     */
    shake: {
      exec(element, action, config) {
        action.prevX = element.x;
        action.prevY = element.y;
      },
      update(element, action, progress, config) {
        const phase = progress < 0.5 ? 'strong' : 'fade';
        const _direction = config.dir || 'horizontal';
        const _frequency = config.frequency || 10;
        const _power = config.power || 8;

        // 计算当前的偏移量
        const sinFactor = Math.sin(progress * Math.PI * 2 * _frequency);
        let _offset;

        if (phase === 'strong') {
          // 猛烈摇动阶段
          const strongPower = _power * (1 - Math.pow(1 - progress, 2));
          _offset = sinFactor * strongPower;
        } else {
          // 减弱摇动阶段
          const fadePower = _power * (1 - (progress - 0.5) * 2);
          _offset = sinFactor * fadePower;
        }

        if (_direction === 'horizontal') {
          element.x = action.prevX + _offset;
        } else {
          element.y = action.prevY + _offset;
        }
      }
    },
    /**
     * 从高处掉落并反弹多次
     * @param {number} height - 掉落的初始高度
     * @param {number} count - 反弹的次数 (不包括初始掉落)
     * @param {number} power - 反弹力道/能量保留率 (0到1之间, 建议0.4-0.7)
     */
    dropBounce: {
      exec(element, action, config) {
        // 记录元素的最终静止位置（地面位置）
        action.groundY = element.y;
        // 获取配置参数，并设置默认值
        const _height = config.height || 100;
        // 动画开始时，将元素直接置于最高点
        element.y = action.groundY - _height;
      },
      update(element, action, progress, config) {
        const _height = config.height || 100;
        const _count = config.count || 3;
        const _power = config.power || 0.6;

        // 总共有 1次掉落 + count次反弹，所以总段数是 count + 1
        const totalSegments = _count + 1;
        // 计算每一段动画所占的时间比例
        const segmentDuration = 1.0 / totalSegments;

        // 确定当前 progress 处于第几段动画
        // Math.min 是为了防止 progress === 1.0 时，index 超出范围
        const currentIndex = Math.min(Math.floor(progress / segmentDuration), _count);

        // 计算当前这段动画的内部进度 (0.0 to 1.0)
        const progressInSegment = (progress - (currentIndex * segmentDuration)) / segmentDuration;

        let offset;

        if (currentIndex === 0) {
          // === 阶段0: 初始掉落 ===
          // 这是一个从1到0的二次方缓动（ease-in-quad），模拟重力加速
          const currentHeight = _height;
          offset = currentHeight * Math.pow(1 - progressInSegment, 2);
        } else {
          // === 阶段 1...count: 反弹 ===
          // 计算当前这次反弹的理论峰值高度
          // 第一次反弹高度是 height * power, 第二次是 height * power^2 ...
          // 所以第 N 次反弹 (currentIndex = N) 的高度是 height * power^N
          const currentHeight = _height * Math.pow(_power, currentIndex);
          
          // 使用一个 4x(1-x) 的抛物线公式来模拟一次完整的弹跳
          // 当 progressInSegment 从 0 -> 0.5 -> 1
          // 抛物线的值会从 0 -> 1 -> 0
          const parabola = 4 * progressInSegment * (1 - progressInSegment);
          offset = currentHeight * parabola;
        }

        // 更新元素的 Y 坐标
        // action.groundY 是地面位置，offset 是当前高于地面的距离
        element.y = action.groundY - offset;
      }
    },
    /**
     * 随机方向震动
     */
    rumble: {
      exec(element, action, config) {
        action.originX = element.x;
        action.originY = element.y;
        
        // 震动间隔的起点和目标点
        action.rumbleStartX = 0;
        action.rumbleStartY = 0;
        action.rumbleTargetX = 0;
        action.rumbleTargetY = 0;
        
        // 上一个间隔开始的时间
        action.lastIntervalProgress = 0;

        // 辅助函数：线性插值 (Lerp)
        action.lerp = (start, end, t) => {
          return start * (1 - t) + end * t;
        }

        // 辅助函数：平滑曲线，让过渡更自然
        action.easeInOutQuad = (x) => {
          return x < 0.5 ? 2 * x * x : 1 - Math.pow(-2 * x + 2, 2) / 2;
        }
      },
      update(element, action, progress, config) {
        
        // 1. 获取配置参数
        const _power = config.power || 12;
        const _duration = config.duration || 50; // 总帧数，默认60帧
        // 每隔多少帧更新一次震动目标，默认1帧
        const _interval = config.frequency || 1;
        const _minPowerFactor = 0.7;

        // 2. 计算出每个小间隔占总进度的比例
        const intervalAsProgress = _interval / _duration;

        // 3. 检查是否进入了下一个新的震动间隔
        if (progress >= action.lastIntervalProgress + intervalAsProgress) {
            // 将上一个目标点设为新的起点
            action.rumbleStartX = action.rumbleTargetX;
            action.rumbleStartY = action.rumbleTargetY;

            // a. 计算当前衰减后的总强度
            const currentPower = _power * (1 - progress);
    
            // b. 生成一个随机方向 (0 to 2π 弧度)
            const angle = Math.random() * 2 * Math.PI;
    
            // c. 生成一个随机强度系数，范围在 [minPowerFactor, 1.0] 之间
            const randomStrength = Math.random() * (1 - _minPowerFactor) + _minPowerFactor;
    
            // d. 结合方向和强度，计算出新的目标偏移量
            action.rumbleTargetX = Math.cos(angle) * randomStrength * currentPower;
            action.rumbleTargetY = Math.sin(angle) * randomStrength * currentPower;
    
            action.lastIntervalProgress += intervalAsProgress;
        }

        // 4. 计算当前在“小间隔”内的进度 (0 to 1)
        const progressWithinInterval = (progress - action.lastIntervalProgress) / intervalAsProgress;
        
        // 5. 使用平滑曲线美化小间隔内的过渡，让运动不死板
        const smoothedIntervalProgress = action.easeInOutQuad(progressWithinInterval);

        // 6. 使用线性插值，计算出当前帧从起点到目标点的平滑位置
        const offsetX = action.lerp(action.rumbleStartX, action.rumbleTargetX, smoothedIntervalProgress);
        const offsetY = action.lerp(action.rumbleStartY, action.rumbleTargetY, smoothedIntervalProgress);

        // 7. 应用最终计算出的偏移量到元素的原始位置上
        element.x = action.originX + offsetX;
        element.y = action.originY + offsetY;

        // 8. 动画结束时，强制将元素归位，消除任何浮点数误差
        if (progress === 1) {
          element.x = action.originX;
          element.y = action.originY;
        }
      }
    },
    /** 震动屏幕 */
    shakeScreen: {
      exec(element, action, config) {
        $gameScreen.startShake(
          config.power,
          config.speed,
          config.duration
        );
      },
      update(element, action, progress, config) {
      }
    },
    /** 播放背景音乐 */
    bgm: {
      exec(element, action, config) {
        AudioManager.playBgm({
          name: config.name,
          volume: config.volume || 100,
          pitch: 100,
          pan: 0,
        });
        AudioManager.fadeInBgm(10);
      },
      update(element, action, progress, config) {
        if (progress >= 1) {
          AudioManager.fadeOutBgm(10);
          AudioManager.stopBgm();
        }
      }
    },
    /** 播放声音 */
    sound: {
      exec(element, action, config) {
        AudioManager.playSe({
          name: config.name,
          volume: config.volume || ConfigManager.seVolume,
          pitch: 100,
          pan: 0,
        });
      },
      update(element, action, progress, config) {
        if (progress >= 1) {
          AudioManager.stopSe();
        }
      }
    },
    move: {
      exec(element, action, config) {
        if (config.rx) {
          action.prevX = element.x;
          action.nextX = element.x + config.rx;
        }
        if (config.ry) {
          action.prevY = element.y;
          action.nextY = element.y + config.ry;
        }
      },
      update(element, action, progress, config) {
        if (config.rx) {
          element.x = action.prevX + (action.nextX - action.prevX) * progress;
        }
        if (config.ry) {
          element.y = action.prevY + (action.nextY - action.prevY) * progress;
        }

        if (progress >= 1) {
          if (config.rx) element.x = action.nextX;
          if (config.ry) element.y = action.nextY;
        }
      }
    },
    /**
     * 渐显
     */
    fadeIn: {
      exec(element, action, config) {
        if (config.rx) {
          action.prevX = element.x - config.rx;
          action.nextX = element.x;
        }
        if (config.ry) {
          action.prevY = element.y - config.ry;
          action.nextY = element.y;
        }
      },
      update(element, action, progress, config) {
        // if (!element || !element.parent) return;
        element.alpha = progress;

        if (config.rx) {
          element.x = action.prevX + (action.nextX - action.prevX) * progress;
        }
        if (config.ry) {
          element.y = action.prevY + (action.nextY - action.prevY) * progress;
        }

        if (progress >= 1) {
          element.alpha = 1;
          if (config.rx) element.x = action.nextX;
          if (config.ry) element.y = action.nextY;
        }
      }
    },
    /**
     * 渐隐
     * @param { {  } } config 
     */
    fadeOut: {
      exec(element, action, config) {
        if (config.rx) {
          action.prevX = element.x;
          action.nextX = element.x + config.rx;
        }
        if (config.ry) {
          action.prevY = element.y;
          action.nextY = element.y + config.ry;
        }
      },
      update(element, action, progress, config) {
        element.alpha = 1 - progress;

        if (config.rx) {
          element.x = action.prevX + (action.nextX - action.prevX) * progress;
        }
        if (config.ry) {
          element.y = action.prevY + (action.nextY - action.prevY) * progress;
        }

        if (progress >= 1) {
          element.alpha = 0;
          if (config.rx) element.x = action.nextX;
          if (config.ry) element.y = action.nextY;
        }
      }
    },
    /**
     * 淡入淡出，后续回到原位
     * @param { {  } } config 
     */
    fade: {
      exec(element, action, config) {
        if (config.x) {
          action.prevX = element.container.x;
          action.nextX = element.container.x + config.x;
        }
        if (config.y) {
          action.prevY = element.container.y;
          action.nextY = element.container.y + config.y;
        }
        element.canFadeIn = element.container.alpha < 0.5 ? true : false;
      },
      update(element, action, progress, config) {
        let _progress = progress / (1 - config.loopDelay / 100);
        let phase = _progress < 0.5 ? 'in' : 'out';

        if (phase === 'in') {
          if (element.canFadeIn) {
            element.container.alpha = _progress * 2;
          } else {
            element.container.alpha = 1 - _progress * 2;
          }
        } else if (phase === 'out') {
          if (element.canFadeIn) {
            element.container.alpha = 2 - _progress * 2;
          } else {
            element.container.alpha = 1 - _progress * 2;
          }
        }

        if (config.x) {
          element.container.x = action.prevY + (action.nextX - action.prevY) * _progress;
        }
        if (config.y) {
          element.container.y = action.prevY + (action.nextY - action.prevY) * _progress;
        }

        if (progress >= 1) {
          if (config.x) element.container.x = action.prevX;
          if (config.y) element.container.y = action.prevY;
        }
      }
    },
    /**
     * 从一侧进入
     * @param { { dir: 'top'|'left'|'right'|'bottom', loc: string } } config 
     */
    slideIn: {
      exec(element, action, config) {
        let _startLoc = 0;
        let _endLoc = 0;
        const _tachieConfig = locConfigList.find(child => child.configTag === config.loc);

        if (!config.dir) throw new Error('Direction is required');
        if (!config.loc) throw new Error('Location Config is required');

        if (config.dir === 'left') {
          _startLoc = -element.container.width * element.container.anchorX * element.container.scale.x;
          if (config.x) {
            _endLoc = config.x;
          } else if (_tachieConfig) {
            _endLoc = _tachieConfig.tachieLocX;
          }
        } else if (config.dir === 'right') {
          _startLoc = (Graphics.width + element.container.width * element.container.anchorX) * element.container.scale.x;
          if (config.x) {
            _endLoc = config.x;
          } else if (_tachieConfig) {
            _endLoc = _tachieConfig.tachieLocX;
          }
        } else if (config.dir === 'top') {
          _startLoc = -element.container.height * element.container.anchorY * element.container.scale.y;
          if (config.y) {
            _endLoc = config.y;
          } else if (_tachieConfig) {
            _endLoc = _tachieConfig.tachieLocY;
          }
        } else if (config.dir === 'bottom') {
          _startLoc = (Graphics.height + element.container.height * element.container.anchorY) * element.container.scale.y;
          if (config.y) {
            _endLoc = config.y;
          } else if (_tachieConfig) {
            _endLoc = _tachieConfig.tachieLocY;
          }
        }

        action.startLoc = _startLoc;
        action.endLoc = _endLoc;
      },
      update(element, action, progress, config) {
        let _startLoc = action.startLoc;
        let _endLoc = action.endLoc;

        if (config.dir === 'left') {
          element.container.x = _startLoc + (_endLoc - _startLoc) * progress;
        } else if (config.dir === 'right') {
          element.container.x = _startLoc + (_endLoc - _startLoc) * progress;
        } else if (config.dir === 'top') {
          element.container.y = _startLoc + (_endLoc - _startLoc) * progress;
        } else if (config.dir === 'bottom') {
          element.container.y = _startLoc + (_endLoc - _startLoc) * progress;
        }
      }
    },
    slideOut: {
      exec(element, action, config) {
        action.prevX = element.container.x;
        action.prevY = element.container.y;
      },
      update(element, action, progress, config) {
        let _startLoc = 0;
        let _endLoc = 0;

        if (config.dir === 'left') {
          _startLoc = action.prevX;
          _endLoc = -element.container.width * element.container.anchorX * element.container.scale.x;
          element.container.x = _startLoc + (_endLoc - _startLoc) * progress;
        } else if (config.dir === 'right') {
          _startLoc = action.prevX;
          _endLoc = (Graphics.width + element.container.width * element.container.anchorX) * element.container.scale.x;
          element.container.x = _startLoc + (_endLoc - _startLoc) * progress;
        } else if (config.dir === 'top') {
          _startLoc = action.prevY;
          _endLoc = -element.container.height * element.container.anchorY * element.container.scale.y;
          element.container.y = _startLoc + (_endLoc - _startLoc) * progress;
        } else if (config.dir === 'bottom') {
          _startLoc = action.prevY;
          _endLoc = (Graphics.height + element.container.height * element.container.anchorY) * element.container.scale.y;
          element.container.y = _startLoc + (_endLoc - _startLoc) * progress;
        }
      }
    },
    /** 缓存 */
    cache: {
      exec(element, action, config) {
        if (config.images && config.images.length) {
          action.imageIndex = 0;
          action.imageCount = config.images.length;
          for (let i = 0; i < config.images.length; i++) {
            const img = config.images[i];
            let _imgInstance;
            if (img.indexOf("img/") === 0) {
              _imgInstance = ImageManager.loadBitmap(img.substring(0, img.lastIndexOf("/") + 1), img.substring(img.lastIndexOf("/") + 1), 0, true);
            } else if (img.indexOf("pictures/") === 0) {
              _imgInstance = ImageManager.loadBitmap("img/", img, 0, true);
            } else {
              _imgInstance = ImageManager.loadBitmap("img/pictures/", img, 0, true);
            }
            if (_imgInstance.isReady()) {
              action.imageIndex++;
            } else {
              _imgInstance.addLoadListener(() => {
                action.imageIndex++;
              });
            }
          }
        }
      },
      update(element, action, progress, config, timeline) {
        if (action.imageIndex >= action.imageCount) {
          timeline.frameIndex = 0;
        }
      }
    },
    /** 修改开关 */
    switch: {
      exec(element, action, config) {
        if (!config.id) throw new Error('Switch ID is required');
        if (isNaN(config.value)) {
          $gameSwitches.setValue(config.id, +config.value);
        } else {
          $gameSwitches.setValue(config.id, config.value);
        }
      },
      update(element, action, progress, config) {
      }
    },
    /** 修改变量 */
    variable: {
      exec(element, action, config) {
        if (!config.id) throw new Error('Variable ID is required');
        if (isNaN(config.value)) {
          $gameVariables.setValue(config.id, +config.value);
        } else {
          $gameVariables.setValue(config.id, config.value);
        }
      },
      update(element, action, progress, config) {
      }
    },
    /** 添加日志/信息（左上角显示的内容） */
    log: {
      exec(element, action, config) {
        if (!SceneManager._scene._logWindow) {
          throw new Error('Log Window not found');
        }
        const _win = SceneManager._scene._logWindow;
        _win.addText(config.content);
        if (_win._lines.length >= _win.maxLines()) {
          _win._lines.pop();
        }
        _win.refresh();
      },
      update(element, action, progress, config) { }
    },
    /** 延时 */
    wait: {
      exec(element, action, config) { },
      update(element, action, progress, config) { }
    },
    /** 结束 */
    clear: {
      exec(element, action, config) {
        skitModule.clear();
      },
      update(element, action, progress, config) { }
    },
    /** 组合动作 */
    group: {
      exec(element, action, config) {
      },
      update(element, action, progress, config) {

        const _actions = action.actions;

        for (let i = _actions.length - 1; i >= 0; i--) {
          const _action = _actions[i];

          if (!_action.isStart) {
            Commands.exec(_action.action, _action, skitInfo.groupInfo[element.name].timeline, _action.config);
            _action.isStart = true;
          }
          if (_action.isStart) {
            _action.frameIndex -= 1;
            const _progress = (_action.duration - _action.frameIndex) / _action.duration;
            Commands.update(_action.action, _action, skitInfo.groupInfo[element.name].timeline, _progress, _action.config);
          }

          if (_action.frameIndex <= 0) {
            if (_action.loop === true) {
              _action.isStart = false;
              _action.frameIndex = _action.duration;
            } else if (!isNaN(_action.loop) && _action.loop > 1) {
              _action.isStart = false;
              _action.frameIndex = _action.duration;
              _action.loop--;
            } else {
              _actions.splice(i, 1);

              if (_actions.length) {
                _action.frameIndex = _action.duration;
              }
            }
          }
        }

        if (progress >= 1) return;
      }
    },
    /** 更新图层 */
    update(actionName, action, timeline, progress, config) {
      const _childrenIndex = skitInfo.children.findIndex(child => child && child.name === timeline.elementName);
      Commands[actionName].update(skitInfo.children[_childrenIndex], action, progress, config, timeline);
    },
    /** 执行 */
    exec(actionName, action, timeline, config) {
      if (Commands[actionName]) {
        if (timeline.elementName === 'main') {
          Commands[actionName].exec(undefined, action, config);
        } else {
          const _childrenIndex = skitInfo.children.findIndex(child => child && child.name === timeline.elementName);
          if (_childrenIndex < 0) throw new Error(`Element ${timeline.elementName} not found`);

          Commands[actionName].exec(skitInfo.children[_childrenIndex], action, config);
        }
      } else {
        throw new Error(`Command ${actionName} not found`);
      }
    }
  };

  // #endregion

  /**
   * 立绘处理模块
   */
  const tachieModule = {
    /**
     * 开始动作
     * @param {string} action 动作名称
     * @param {string} actor 执行动作的角色
     * @param {object} config 动作配置
     * @param {Function} callback 动作回调函数
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    startAction(action, actor, config = {}, callback, interpreter) {
      let _actorElement;
      let _loop = config.loop === undefined ? 1 : config.loop;
      let _easingType = config.easingType || 'Linear';
      let _inout = config.inout || 'None';
      let _action = {};
      if (actor === 'kana') {
        _actorElement = SceneManager._scene.spine;
      } else if (actor === 'chinatsu') {
        _actorElement = SceneManager._scene.spine;
      } else if (actor === 'yuki') {
        _actorElement = SceneManager._scene.spine;
      } else if (actor === 'ere') {
        _actorElement = SceneManager._scene.spine;
      } else if ((actor instanceof Sprite) || (actor instanceof PIXI.Container)) {
        _actorElement = actor;
      }

      if (!_actorElement) {
        console.error('Actor not found', actor);
        return;
      }
      
      const _fn = () => {
        if (_loop === 0) {
          if (callback) callback();
          return;
        }
        _loop--;
        
        if (interpreter && config.isWait === true) {
          interpreter.wait(config.duration);
        }

        Commands[action].exec(_actorElement, _action, config);
        useTimeout(() => {
          Commands[action].update(_actorElement, _action, 1, config);
          _fn();
        }, config.duration, (progress, frameIndex) => {
          if (!_actorElement || !_actorElement.position) return;
          
          const _progress = MotionEasing.getEasing(_easingType, _inout)(progress);
          Commands[action].update(_actorElement, _action, _progress, config);
        });
      }

      _fn();
    },
    /**
     * 加载立绘
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} actor 立绘角色
     * @param {string} defaultMotion 默认动作
     * @param {object} config 配置
     * @param {string} config.location 立绘位置
     * @param {string} config.motion 默认动作
     * @param {string[]} config.skin 默认皮肤
     * @param {number} config.alpha 透明度
     * @param {Spine => void} config.callback 回调函数
     */
    loadTachie(actor, config = {}) {
      const scene = SceneManager._scene;
      const spineName = actor + "Tachie";
      const source = SpineManager.preloadSpine(spineName);
      source.addListener(source => {
        const { spine } = SpineManager.createSpine(source);
        spine.visible = true;

        spine.tachieInfo.spineName = spineName;

        if (config.x && config.y) {
          spine.position.set(config.x, config.y);
        } else {
          if (config.location) {
            spine.tachieInfo.location = config.location;
            spine.position.set(locations[config.location].x, locations[config.location].y);
          } else {
            spine.tachieInfo.location = 'center';
            spine.position.set(locations.center.x, locations.center.y);
          }
        }

        if (config.motion) {
          spine.state.setAnimation(0, config.motion, true);
          spine.tachieInfo.motion = config.motion;
        }
        if (config.skin && config.skin.length > 0) {
          SpineManager.changeSkin(spine, config.skin);
          spine.tachieInfo.skin = config.skin;
          spine.spineInfo.skin = config.skin;
        }
        if (config.alpha !== undefined) {
          spine.alpha = config.alpha;
          // spine.visible = config.alpha === 0 ? false : true;
        }

        scene.tachieMap[spineName] = spine;
        scene.spine = spine;
        scene.tachieContainer.addChild(spine);

        if (!$gameData.tempSceneInfo.canUse) {
          const _alpha = config.alpha === undefined ? spine.alpha : config.alpha;
          $gameData.tempSceneInfo.spineInfos[spineName] = {
            skin: config.skin || spine.spineInfo.skin, motion: config.motion || spine.spineInfo.motion,
            spineName: spineName, x: config.x, y: config.y,
            alpha: _alpha,
            actor: actor,
          };
          if (_alpha == 1 && !$gameData.tempSceneInfo.spineList.includes(spineName)) {
            $gameData.tempSceneInfo.spineList.push(spineName);
          }
        }
        
        // 透视眼镜效果
        Utils_Tachie.glassesTransform(spine, config.skin || spine.spineInfo.skin);

        if (config.callback) config.callback(spine);
      });
    },
    /**
     * 隐藏立绘
     */
    hideTachie(actor, config) {
      const scene = SceneManager._scene;
      const spineName = actor + "Tachie";
      if (scene.tachieMap[spineName]) {
        let _spine = scene.tachieMap[spineName];
        if (_spine) {
          _spine.alpha = 0;
          const _index = $gameData.tempSceneInfo.spineList.indexOf(spineName);
          $gameData.tempSceneInfo.spineList.splice(_index);
        }
      }
    },
    /**
     * 卸载立绘
     */
    destroyTachie(actor, config) {
      const scene = SceneManager._scene;
      const spineName = actor + "Tachie";
      if (scene.tachieMap[spineName]) {
        let _spine = scene.tachieMap[spineName];
        if (_spine) {
          _spine.destroy();
          delete scene.tachieMap[spineName];
          scene.spine.destroy();
          scene.spine = null;
        }
      }
    },
    /**
     * 修改表情
     * @param {number} face 表情编号
     * @param {number} attach 额外表情编号
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} actor 角色名称
     */
    changeFace(face, attach, actor = 'kana') {
      const scene = SceneManager._scene;
      const spineName = actor + "Tachie";

      if (scene.spine && spineName === scene.spine.tachieInfo.spineName) {
        scene.spine.tachieInfo.skin[1] = 'face-' + face;
        if (attach) scene.spine.tachieInfo.skin[2] = 'face-' + attach;
        else scene.spine.tachieInfo.skin.splice(2, 1);
        SpineManager.changeSkin(scene.spine, scene.spine.tachieInfo.skin);
      }
    },
    /**
     * 修改表情
     * @param {number} face 表情编号
     * @param {number} attach 额外表情编号
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} actor 角色名称
     */
    changeFaceByEre(face, attach, actor = 'kana') {
      const scene = SceneManager._scene;
      const spineName = actor + "Tachie";

      if (scene.spine && spineName === scene.spine.tachieInfo.spineName) {
        scene.spine.tachieInfo.skin[3] = 'face_' + face;
        if (attach) scene.spine.tachieInfo.skin[4] = 'face_' + attach;
        else scene.spine.tachieInfo.skin.splice(4, 1);
        SpineManager.changeSkin(scene.spine, scene.spine.tachieInfo.skin);
      }
    },
    /**
     * 修改衣服
     */
    changeClothes(clothes, actor = 'kana') {
      const scene = SceneManager._scene;
      const spineName = actor + "Tachie";

      if (scene.spine && spineName === scene.spine.tachieInfo.spineName) {
        if (actor === 'chinatsu') {
          const _chest = scene.spine.tachieInfo.skin[0].match(/-(s|l)-/)[0];
          scene.spine.tachieInfo.skin[0] = 'clothes' + _chest + clothes;
        } else if (actor === 'ere') {
          scene.spine.tachieInfo.skin[0] = 'clothes_' + clothes;
        } else {
          scene.spine.tachieInfo.skin[0] = 'clothes-' + clothes;
        }

        // 透视眼镜效果
        if (Utils_Tachie.useGlasses()) {
          Utils_Tachie.glassesTransform(scene.spine, scene.spine.tachieInfo.skin);
        } else {
          SpineManager.changeSkin(scene.spine, scene.spine.tachieInfo.skin);
        }
      }
    },
    /**
     * 修改胸部（千夏）
     * @param {'s'|'l'} chest 胸部尺寸
     */
    changeChest(chest) {
      const scene = SceneManager._scene;

      if (scene.spine && scene.spine.tachieInfo.spineName === 'chinatsuTachie') {
        scene.spine.tachieInfo.skin[0] = scene.spine.tachieInfo.skin[0].replace(/-(s|l)-/g, (a,b,c) => {
          return '-' + chest + '-';
        });
        SpineManager.changeSkin(scene.spine, scene.spine.tachieInfo.skin);
      }
    },
    /**
     * 修改是否戴帽子（艾露）
     */
    changeCap(hasCap) {
      const scene = SceneManager._scene;

      if (scene.spine && scene.spine.tachieInfo.spineName === 'ereTachie') {
        scene.spine.tachieInfo.skin[1] = hasCap ? 'clothes_a1' : 'clothes_a2';
        SpineManager.changeSkin(scene.spine, scene.spine.tachieInfo.skin);
      }
    },
    /**
     * 修改是否戴眼镜（艾露）
     */
    changeGlasses(hasGlasses) {
      const scene = SceneManager._scene;

      if (scene.spine && scene.spine.tachieInfo.spineName === 'ereTachie') {
        scene.spine.tachieInfo.skin[2] = hasGlasses ? 'face_a0' : '';
        SpineManager.changeSkin(scene.spine, scene.spine.tachieInfo.skin);
      }
    },
    /**
     * 显示气泡 - 通用
     * @param {string} balloonName 气泡名称
     * @param {string} actor 角色名称
     * @param {'left'|'right'} [loc='left'] 气泡方位
     */
    showBalloon(balloonName, actor, loc = 'left') {
      const scene = SceneManager._scene;
      const spineName = actor + "Tachie";
      let _left = 0;
      let _top = 0;

      if (scene.spine && spineName === scene.spine.tachieInfo.spineName) {
        const spine = scene.spine;

        if (actor === 'kana') {
          _top = 80;
        } else if (actor === 'chinatsu') {
          _top = 100;
        } else if (actor === 'yuki') {
          _top = 70;
        }
  
        if (spine.tachieInfo.location === 'left') {
          _left = 200;
        } else if (spine.tachieInfo.location === 'center') {
          _left = 460;
        } else if (spine.tachieInfo.location === 'right') {
          _left = 650;
        }
        
        if (loc === 'right') {
          _left += 200;
        }

        Utils_Balloon.showByLoc(balloonName, { left: _left, top: _top, parent: SceneManager._scene, loopCount: 1, speed: 3 });
      }
    },
    /**
     * 初始化场景立绘
     */
    initSceneTachie() {
      if ($gameData.tempSceneInfo.canUse && $gameData.tempSceneInfo.spineList && $gameData.tempSceneInfo.spineList.length) return;
      if (SceneManager._scene.sceneInfo) {
        if (SceneManager._scene.sceneInfo.hideTachie) {
          return;
        }
      }
      if (Utils_Scene.sameKana()) {
        Utils_Tachie.loadTachie('kana', { alpha: 0 });
      } else if (Utils_Scene.sameChinatsu()) {
        Utils_Tachie.loadTachie('chinatsu', { alpha: 0 });
      } else if (Utils_Scene.sameYuki()) {
        Utils_Tachie.loadTachie('yuki', { alpha: 0, x: 340, y: 1000 });
      } else if (Utils_Scene.sameEre()) {
        Utils_Tachie.loadTachie('ere', { alpha: 0 });
      }
    },
    /** 初始化数据（初始化立绘Spine） */
    initGameData() {
      // SpineManager.preloadSpine("kanaTachie");
      // SpineManager.preloadSpine("chinatsuTachie");
      // SpineManager.preloadSpine("kanaInteract");
    }
  };

  /** 立绘工具类 */
  class Utils_Tachie {
    /**
     * 开始动作
     * @param {string} action 动作名称
     * @param {string} actor 执行动作的角色
     * @param {object} config 动作配置
     * @param {Function} callback 动作回调函数
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    static startAction(action, actor, config, callback, interpreter) {
      tachieModule.startAction(action, actor, config, callback, interpreter);
    }
    /**
     * 加载立绘
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} actor 立绘角色
     * @param {string} defaultMotion 默认动作
     * @param {object} config 配置
     * @param {string} config.location 立绘位置
     * @param {string} config.motion 默认动作
     * @param {string[]} config.skin 默认动作
     * @param {number} config.alpha 透明度
     */
    static loadTachie(actor, config) {
      tachieModule.loadTachie(actor, config, this);
    }
    /**
     * 隐藏立绘
     */
    static hideTachie(actor, config) {
      tachieModule.hideTachie(actor, config, this);
    }
    /**
     * 销毁立绘
     */
    static destroyTachie(actor, config) {
      tachieModule.destroyTachie(actor, config, this);
    }
    /**
     * 修改表情
     * @param {number} face 表情编号
     * @param {number} attach 额外表情编号
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} actor 角色名称
     */
    static changeFace(face, attach, actor = 'kana') {
      if (actor === 'ere') {
        tachieModule.changeFaceByEre(face, attach, actor);
      } else {
        tachieModule.changeFace(face, attach, actor);
      }
    }
    /**
     * 修改衣服
     * @param {number} face 表情编号
     * @param {number} attach 额外表情编号
     * @param {'kana'|'chinatsu'|'yuki'|'ere'} actor 角色名称
     */
    static changeClothes(face, attach, actor = 'kana') {
      tachieModule.changeClothes(face, attach, actor);
    }
    /**
     * 修改胸部（千夏）
     * @param {'s'|'l'} chest 胸部尺寸
     */
    static changeChest(chest) {
      tachieModule.changeChest(chest);
    }
    
    /**
     * 初始化场景立绘
     */
    static initSceneTachie() {
      tachieModule.initSceneTachie();
    }
    /**
     * 初始化数据（初始化立绘Spine）
     */
    static initGameData() {
      tachieModule.initGameData();
    }
    /**
     * 显示气泡 - 通用
     */
    static showBalloon(balloonName, actor, loc = 'left') {
      tachieModule.showBalloon(balloonName, actor, loc);
    }
    /** 开启透视眼镜 */
    static openGlasses() {
      const _scene = SceneManager._scene;
      if (_scene.spine && Utils_Tachie.useGlasses()) {
        Utils_Tachie.glassesTransform(_scene.spine, _scene.spine.tachieInfo.skin);
      }
    }
    /**
     * 是否使用了眼镜
     * @return {boolean}
     */
    static useGlasses() {
      return $gameSwitches.value(17) || false;
    }
    /**
     * 透视眼镜效果
     * @param {object} spine Spine对象
     * @param {string[]} skin 皮肤名称数组
     * @param {boolean} [restore=false] 是否还原
     */
    static glassesTransform(spine, skin, restore = false) {
      if (!spine || !spine.tachieInfo || skin.length <= 0) return;

      if (Utils_Tachie.useGlasses()) {
        let _skin = skin.slice();
        const _actor = spine.tachieInfo.spineName.replace('Tachie', '');
        switch (_actor) {
          case 'kana': _skin[0] = 'clothes-04'; break;
          case 'chinatsu': 
            const _chest = spine.tachieInfo.skin[0].match(/-(s|l)-/)[0];
            _skin[0] = 'clothes' + _chest + '03';
            break;
          case 'yuki': _skin[0] = 'clothes-02'; break;
          case 'ere': _skin[0] = 'clothes_03'; break;
        }

        SpineManager.changeSkin(spine, _skin);
      } else {
        SpineManager.changeSkin(spine, skin.slice());
      }
    }
  }
  window.Utils_Tachie = Utils_Tachie;


  if (Utils.RPGMAKER_NAME === "MZ") {
    // 加载立绘
    PluginManager.registerCommand(PluginName, 'showTachie', function(args) {
      Utils_Tachie.loadTachie.call(this, args.actor, {
        location: args.location,
        motion: args.motion,
        skin: JSON.parse(args.skin),
        alpha: Number(args.alpha === undefined ? 1 : Number(args.alpha))
      });
    });
    // 显示气泡 - 通用
    PluginManager.registerCommand(PluginName, 'showBalloon', function(args) {
      tachieModule.showBalloon.call(this, args.balloonName.split(',')[0], args.actor, args.loc);
    });
    // 修改表情 - 通用
    PluginManager.registerCommand(PluginName, 'changeFace', function(args) {
      tachieModule.changeFace.call(this, args.face, args.attach ? args.attach.split(',')[0] : '', args.actor);
    });
    // 修改表情 - 加奈
    PluginManager.registerCommand(PluginName, 'changeFaceByKana', function(args) {
      tachieModule.changeFace.call(this, args.face.split(',')[0], args.attach ? args.attach.split(',')[0] : '', 'kana');
    });
    // 修改表情 - 千夏
    PluginManager.registerCommand(PluginName, 'changeFaceByChinatsu', function(args) {
      tachieModule.changeFace.call(this, args.face.split(',')[0], args.attach ? args.attach.split(',')[0] : '', 'chinatsu');
    });
    // 修改表情 - 由纪
    PluginManager.registerCommand(PluginName, 'changeFaceByYuki', function(args) {
      tachieModule.changeFace.call(this, args.face.split(',')[0], args.attach ? args.attach.split(',')[0] : '', 'yuki');
    });
    // 修改表情 - 艾露
    PluginManager.registerCommand(PluginName, 'changeFaceByEre', function(args) {
      tachieModule.changeFaceByEre.call(this, args.face.split(',')[0], args.attach ? args.attach.split(',')[0] : '', 'ere');
    });

    
    // 修改衣服 - 加奈
    PluginManager.registerCommand(PluginName, 'changeClothesByKana', function(args) {
      tachieModule.changeClothes.call(this, args.clothes.split(',')[0], 'kana');
    });
    // 修改衣服 - 千夏
    PluginManager.registerCommand(PluginName, 'changeClothesByChinatsu', function(args) {
      tachieModule.changeClothes.call(this, args.clothes.split(',')[0], 'chinatsu');
    });
    // 修改胸部尺寸 - 千夏
    PluginManager.registerCommand(PluginName, 'changeChestByChinatsu', function(args) {
      tachieModule.changeChest.call(this, args.chest);
    });
    // 修改衣服 - 由纪
    PluginManager.registerCommand(PluginName, 'changeClothesByYuki', function(args) {
      tachieModule.changeClothes.call(this, args.clothes.split(',')[0], 'yuki');
    });
    // 修改衣服 - 艾露
    PluginManager.registerCommand(PluginName, 'changeClothesByEre', function(args) {
      tachieModule.changeClothes.call(this, args.clothes.split(',')[0], 'ere');
    });
    // 修改是否戴眼镜 - 艾露
    PluginManager.registerCommand(PluginName, 'changeGlassesByEre', function(args) {
      tachieModule.changeGlasses.call(this, args.hasGlasses == 'true');
    });
    // 修改是否戴帽子 - 艾露
    PluginManager.registerCommand(PluginName, 'changeCapByEre', function(args) {
      tachieModule.changeCap.call(this, args.hasCap == 'true');
    });

    
    // 立绘动作 - 渐显
    PluginManager.registerCommand(PluginName, 'action_fadeIn', function(args) {
      const _info = $gameData.tempSceneInfo;
      const _spineName = args.actor + 'Tachie';
      if (_info.spineInfos[_spineName]) {
        _info.spineInfos[_spineName].alpha = 1;
      }
      if (!_info.spineList.includes(_spineName)) _info.spineList.push(_spineName);

      tachieModule.startAction.call(this, 'fadeIn', args.actor, {
        duration: Number(args.duration),
        rx: Number(args.rx),
        ry: Number(args.ry),
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    
    // 立绘动作 - 移动
    PluginManager.registerCommand(PluginName, 'action_move', function(args) {
      tachieModule.startAction.call(this, 'move', args.actor, {
        duration: Number(args.duration),
        rx: Number(args.rx),
        ry: Number(args.ry),
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    // 立绘动作 - 渐隐
    PluginManager.registerCommand(PluginName, 'action_fadeOut', function(args) {
      const _info = $gameData.tempSceneInfo;
      const _spineName = args.actor + 'Tachie';
      if (_info.spineInfos[_spineName]) {
        _info.spineInfos[_spineName].alpha = 0;
        // const _index = _info.spineList.findIndex(i => i ===_spineName);
        // if (_index >= 0) _info.spineList.splice(_index, 1);
      }

      tachieModule.startAction.call(this, 'fadeOut', args.actor, {
        duration: Number(args.duration),
        rx: Number(args.rx),
        ry: Number(args.ry),
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    // 立绘动作 - 立绘震动
    PluginManager.registerCommand(PluginName, 'action_shake', function(args) {
      tachieModule.startAction.call(this, 'shake', args.actor, {
        duration: Number(args.duration),
        loop: Number(args.loop),
        power: Number(args.power),
        frequency: Number(args.frequency),
        dir: args.dir,
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    // 立绘动作 - 立绘随机震动
    PluginManager.registerCommand(PluginName, 'action_rumble', function(args) {
      tachieModule.startAction.call(this, 'rumble', args.actor, {
        duration: Number(args.duration),
        loop: Number(args.loop),
        power: Number(args.power),
        frequency: Number(args.frequency),
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    // 立绘动作 - 点头
    PluginManager.registerCommand(PluginName, 'action_nod', function(args) {
      tachieModule.startAction.call(this, 'nod', args.actor, {
        duration: Number(args.duration),
        loop: Number(args.loop),
        power: Number(args.power),
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    // 立绘动作 - 跳跃
    PluginManager.registerCommand(PluginName, 'action_jump', function(args) {
      tachieModule.startAction.call(this, 'jump', args.actor, {
        duration: Number(args.duration),
        loop: Number(args.loop),
        power: Number(args.power),
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    // 立绘动作 - 呼吸效果
    PluginManager.registerCommand(PluginName, 'action_breath', function(args) {
      tachieModule.startAction.call(this, 'breath', args.actor, {
        duration: Number(args.duration),
        loop: Number(args.loop),
        power: Number(args.power),
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    
    
    
  }
})();