//=============================================================================
// ** RPG Maker MZ - Hakubox_Module_Topic.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制模块 - 聊天插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】聊天相关插件。
 * 
 * 
 */
// #endregion
(() => {

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Topic";
  
  const typeDefine = {
  };
  // #endregion

  // #region 插件参数

  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);

  /** 妹妹加奈的话题列表 */
  const allTopicList = [
    [],
    // 低好感度
    [
      { id: 1, disabled: false, eventId: 31, title: '学校的生活感觉怎么样呢？' }, 
      { id: 2, disabled: false, eventId: 32, title: '最近有喜欢的人吗？' },
      { id: 3, disabled: false, eventId: 33, title: '有什么喜欢吃的东西吗？' },
      { id: 4, disabled: false, eventId: 34, title: '今天过的怎么样呢？' },
      { id: 5, disabled: false, eventId: 35, title: '有什么喜欢的游戏吗？' },
      { id: 6, disabled: false, eventId: 36, title: '有什么想要的礼物吗？' },
      { id: 7, disabled: false, eventId: 37, title: '有点担心老哥最近的状态呢' },
      { id: 8, disabled: false, eventId: 38, title: '最近好像有内衣不见了' },
      { id: 9, disabled: false, eventId: 39, title: '学校里最近来了一位帅气的老师' },
      { id: 10, disabled: false, eventId: 40, title: '关于昨晚洗澡丢在外面的内裤' },
      { id: 11, disabled: false, eventId: 41, title: '偷看妹妹的胸部' },
      { id: 12, disabled: false, eventId: 42, title: '妹妹最近发育的真的不错呢' },
    ],
    // 中好感度
    [
      { id: 13, disabled: false, eventId: 44, title: '最近有什么让你开心的事情吗？' }, 
      { id: 14, disabled: false, eventId: 45, title: '今天一起去逛街怎么样？' },
      { id: 15, disabled: false, eventId: 46, title: '所以说真的没有喜欢的人吗？' },
      { id: 16, disabled: false, eventId: 47, title: '偶尔也来一起做饭怎么样？' },
      { id: 17, disabled: false, eventId: 48, title: '我是说如果，以后要一起搬去大城市生活吗？' },
      { id: 18, disabled: false, eventId: 49, title: '这几天又挣了不少钱呢' },
      { id: 19, disabled: false, eventId: 50, title: '老哥最近的厨艺愈发进步了呢' },
      { id: 20, disabled: false, eventId: 51, title: '我知道有一家不错的店…' },
      { id: 21, disabled: false, eventId: 52, title: '哥哥和千夏，最近是不是走的有点太近了' },
      { id: 22, disabled: false, eventId: 53, title: '有点怀念小时候一起洗澡的日子了' },
      { id: 23, disabled: false, eventId: 54, title: '果然还是有些在意妹妹的胸部呢' },
      { id: 24, disabled: false, eventId: 55, title: '如果最近老哥好好工作的话，也不是不可以让老哥摸一下作为奖励的…' },
    ]
  ];

  const topicModule = {
    /** 获取3个话题列表 @type {object[]} */
    getTopicList() {
      let _arr = allTopicList[Utils_Favor.kanaFavorLevel > 2 ? 2 : Utils_Favor.kanaFavorLevel];
      let _arrRe = [];
      let _item = 0;
      while (_arrRe.length < 3) {
        _item = _arr[Math.randomInt(_arr.length)];

        if (!_arrRe.includes(_item) && _item.disabled === false) {
          _arrRe.push(_item);
        }
      }

      return _arrRe;
    }
  };

  class Utils_Topic {
    /** 获取3个话题列表 @type {object[]} */
    static getTopicList() {
      return topicModule.getTopicList();
    }
  }
  window.Utils_Topic = Utils_Topic;

})();
