//=============================================================================
// ** RPG Maker MZ - Scene_Haku_BuyGoods.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 商店购买页场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /**
   * 商品购买场景
   */
  class Scene_Haku_BuyGoods extends Scene_Game {
    initialize() {
      super.initialize();

      this._disabledFade = true;

      this.pageIndex = 0;
      this.maxPageIndex = 2;

      this.pageWidth = 827;
      this.pageHeight = 628;

      const _repertories = Utils_Item.getRepertories();

      this.animeType = 'in';

      this.animeInOutInfo = useAnime({
        frameDelay: 0,
        frameCount: 20,
        easingType: 'Quadratic',
        inout: 'InOut',
      }, progress => {
        const _baseY = (Graphics.height - this.pageHeight) / 2 + 75;
        if (this.animeType === 'in') {
          this.mainContainer.alpha = progress;
          this.mainContainer.y = parseInt(-30 + progress * 30);
          this._shopWindow.alpha = progress;
          this._shopWindow.y = parseInt(_baseY - 30 + progress * 30);
          if (_repertories.length > 4) this.scroll.contents.alpha = progress;
          this.scroll.y = parseInt(160 - 30 + progress * 30);
        } else if (this.animeType === 'out') {
          this.mainContainer.alpha = 1 - progress;
          this.mainContainer.y = parseInt(-progress * 30);
          this._shopWindow.alpha = 1 - progress;
          this._shopWindow.y = parseInt(_baseY - progress * 30);
          if (_repertories.length > 4) this.scroll.contents.alpha = 1 - progress;
          this.scroll.y = parseInt(160 - progress * 30);
          if (progress >= 1) {
            $gameSystem.enableMenu();
            SceneManager.pop();
          }
        }
      });
    }

    create() {
      $gameSystem.disableMenu();
      super.create();

      this.mainContainer = new HakuContainer();
      this.mainContainer.alpha = 0;
      this.addChildAt(this.mainContainer, 1);

      this.createCloseButton();
      this.createBackground();
      this.createShopWindow();

      this.scroll = useScrollBar(new Rectangle(1000, 160, 30, 450), {
        barImage: 'ui/common/scroll_vertical_bar',
        thumbImage: 'ui/common/scroll_vertical_thumb',
        pageHeight: this._shopWindow.height,
      });
      this.scroll.contents.alpha = 0;
      this.addChild(this.scroll.contents);
      this._shopWindow.bindScroll(this.scroll);
    }

    update() {
      super.update();

      this.animeInOutInfo.update();

      if (TouchInput.isCancelled() || Input.isTriggered('cancel')) {
        SoundManager.playCancel();
        this.animeInOutInfo.start();
        this.animeType = 'out';
      }
    }

    setBackgroundOpacity(opacity) {
      this._backgroundSprite.opacity = opacity;
    }

    /** 透明背景 */
    createBackground() {
      this._backgroundFilter = new PIXI.filters.BlurFilter();
      this._backgroundSprite = new Sprite();
      this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
      this._backgroundSprite.filters = []; // this._backgroundFilter
      this.addChildAt(this._backgroundSprite, 0);
      this.setBackgroundOpacity(192);
    }

    /** 获取道具窗口的矩形 */
    shopWindowRect() {
      const wx = (Graphics.width - this.pageWidth) / 2 + 75;
      const wy = (Graphics.height - this.pageHeight) / 2 + 75;
      const ww = this.pageWidth - 130;
      const wh = this.pageHeight - 95;
      return new Rectangle(wx, wy, ww, wh);
    }

    /** 创建关闭按钮 */
    createCloseButton() {
      this._closeButton = new HakuSprite({
        x: 1070, y: 90,
        useHover: true,
        normalBitmap: ImageManager.loadPicture('ui/close_button'),
        hoverBitmap: ImageManager.loadPicture('ui/close_button_active'),
        onTap: () => {
          SoundManager.playCancel();
          this.animeInOutInfo.start();
          this.animeType = 'out';
        }
      });
      this.mainContainer.addChild(this._closeButton);
    }

    /** 创建道具页面 */
    createShopWindow() {
      const rect = this.shopWindowRect();
      this._shopWindow = new Window_Haku_Shop(rect, this.pageWidth, this.pageHeight);
      this._shopWindow.alpha = 0;
      this.addChild(this._shopWindow);
      this.animeInOutInfo.start();
    }
  }
  window.Scene_Haku_BuyGoods = Scene_Haku_BuyGoods;

  /** 道具栏页面 */
  class Window_Haku_Shop extends Window_Selectable {
    initialize(rect, pageWidth, pageHeight) {
      super.initialize(rect);
      // this.openness = 0;
      this.opacity = 0;
      this.pageWidth = pageWidth;
      this.pageHeight = pageHeight;

      this.contents.smooth = false;
      
      this.activeIndex = -1;
      this._index = -1;
      this._hoverIndexes = [];

      this._list = Utils_Item.getRepertories();
      this.items = cloneLoop($gameParty.items());

      this.windowContainer = new PIXI.Container();
      this.addChildAt(this.windowContainer, 0);
      this.createBackground();
      this.drawSaving();
      
      this.refresh();
    }

    dragMove(scrollTop, smooth = false) {
      if (smooth) {
        this.smoothScrollTo(0, scrollTop);
      } else {
        this.scrollTo(0, scrollTop);
      }
    }

    destroy() {
      super.destroy();

      if (this.scroll) {
        this.scroll.destroy();
      }
    }

    /** 绑定滚动条 */
    bindScroll(scroll) {
      this.scroll = scroll;
      this.scroll._dragMove = this.dragMove.bind(this);
      this.scroll.contentHeight = this.overallHeight();
    }

    updatePadding() {
      this.padding = 6;
    }

    itemHeight() {
      return 130;
    }
    rowSpacing() {
      return 20;
    }

    maxItems() {
      return this._list.length;
    }

    refresh() {
      super.refresh();
      this.drawSaving();
      
      if (this.scroll) {
        this.scroll.contentHeight = this.overallHeight();
      }
    }

    /** 购买物品 */
    buyItem(index) {
      const _item = this._list[index];
      const _price = $dataItems[_item.id].price;
      // console.log(_item);

      if (Utils_Item.getRepertory(_item.id) <= 0) {
        SoundManager.playBuzzer();
        useAlert({ text: '这个道具已卖完了哦' });
        return;
      }

      if ($gameParty.gold() >= _price) {
        SoundManager.playOk();
        $gameParty.loseGold(_price);
        $gameParty.gainItem($dataItems[_item.id], 1);
        Utils_Item.loseShopItem(_item.id);
        useAlert({ text: TranslateUtils.getText('$1 已购入', [$dataItems[_item.id].name]) });
        this.refresh();
      } else {
        useAlert({ text: '存款已经不够了哦' });
        SoundManager.playBuzzer();
      }
    }

    updateOrigin() {
      const blockWidth = this.scrollBlockWidth() || 1;
      const blockHeight = 1; // this.scrollBlockHeight() || 
      const baseX = this._scrollX - (this._scrollX % blockWidth);
      const baseY = this._scrollY - (this._scrollY % blockHeight);
      if (baseX !== this._scrollBaseX || baseY !== this._scrollBaseY) {
        this.updateScrollBase(baseX, baseY);
        this.paint();
      }
      this.origin.x = this._scrollX % blockWidth;
      this.origin.y = this._scrollY % blockHeight;
    }

    update() {
      super.update();

      const _x = TouchInput.x;
      const _y = TouchInput.y;
      const _itemWidth = 101;
      const _itemHeight = 50;
      
      const topIndex = this.topIndex();
      for (let i = 0; i < this.maxVisibleItems(); i++) {
        const index = topIndex + i;
        if (index < this.maxItems()) {
          const rect = this.itemLineRect(index);

          const _itemX = this.x + 8;
          const _itemY = this.y + 8;
          const _isEmpty = Utils_Item.getRepertory(this._list[index].id) <= 0;

          let _btnSrc = 'ui/button/shop_item_btn'

          if (_isEmpty) {
            _btnSrc = 'ui/button/shop_item_btn_disabled';
          }

          if (
            _x > rect.x + _itemX + 540 && _x < rect.x + _itemX + _itemWidth + 540 && 
            _y > rect.y + _itemY - 20 && _y < rect.y + _itemY + _itemHeight - 20
          ) {
            this.activeIndex = index;
            if (!_isEmpty && !this._hoverIndexes[index]) {
              SoundManager.playCursor();
              this.contents.clearRect(rect.x + 540, rect.y - 20, _itemWidth, _itemHeight);
              this.contents.bltImg('ui/button/shop_item_btn_active', undefined, {
                x: rect.x + 540,
                y: rect.y - 20,
                width: _itemWidth,
                height: _itemHeight
              }, () => {
                this.contents.fontSize = 20;
                this.contents.textColor = '#C95D14';
                this.contents.drawText('购买', rect.x + 540, rect.y - 20, 101, 50, 'center');
              });
            }
            
            this._hoverIndexes[index] = true;

            if (TouchInput.isTriggered()) {
              if (_isEmpty) {
                SoundManager.playBuzzer();
              } else {
                this.buyItem(index);
              }
            }
          } else if (this._hoverIndexes[index]) {
            this.contents.clearRect(rect.x + 540, rect.y - 20, _itemWidth, _itemHeight);
            this.contents.bltImg(_btnSrc, undefined, {
              x: rect.x + 540,
              y: rect.y - 20,
              width: _itemWidth,
              height: _itemHeight
            }, () => {
              this.contents.fontSize = 20;
              if (_isEmpty) {
                this.contents.textColor = '#686868';
              } else {
                this.contents.textColor = '#EC6D18';
              }
              this.contents.drawText('购买', rect.x + 540, rect.y - 20, 101, 50, 'center');
            });
            this._hoverIndexes[index] = false;
          }
        }
      }

      if (this.scroll) {
        this.scroll.update(this._scrollY);
      }

    }

    /** 创建背景 */
    createBackground() {
      this._bgSprite = new Sprite(ImageManager.loadPicture('ui/shop/shop_panel_bg'));
      this._bgSprite.x = -45;
      this._bgSprite.y = -45;
      this.windowContainer.addChild(this._bgSprite);

      // 所持金钱币图标
      this._moneyIconSprite = new Sprite(ImageManager.loadPicture('ui/icon/money_middle'));
      this._moneyIconSprite.bitmap.smooth = false;
      this._moneyIconSprite.x = 660;
      this._moneyIconSprite.y = -32;
      this.windowContainer.addChild(this._moneyIconSprite);

      // 所持金标签
      this._savingLabelSprite = new Sprite(new Bitmap(100, 30));
      this._savingLabelSprite.x = 460;
      this._savingLabelSprite.y = -30;
      this.windowContainer.addChild(this._savingLabelSprite);

      // 所持金钱文本
      this._savingSprite = new Sprite(new Bitmap(100, 30));
      this._savingSprite.x = 550;
      this._savingSprite.y = -30;
      this.windowContainer.addChild(this._savingSprite);
    }

    drawBackgroundRect(rect) {
      const x = rect.x;
      const y = rect.y;
      
      this.contentsBack.bltImg('ui/shop/shop_item_bg', undefined, {
        x, y, width: 678, height: 123
      });
    }

    /** 绘制所持金 */
    drawSaving() {
      const _labelText = '所持金：';
      const _valueText = $gameParty.gold() + '';
      let _startX = 460;

      this._savingLabelSprite.bitmap.clear();
      this._savingLabelSprite.bitmap.fontSize = 24;
      const _labelWidth = this._savingLabelSprite.bitmap.measureTextWidth(_labelText);
      this._savingLabelSprite.bitmap = new Bitmap(_labelWidth, 30);
      this._savingLabelSprite.bitmap.smooth = false;
      this._savingLabelSprite.bitmap.fontSize = 22;
      this._savingLabelSprite.bitmap.textColor = '#e16410';
      this._savingLabelSprite.bitmap.outlineWidth = 5;
      this._savingLabelSprite.bitmap.outlineColor = '#FFFFFF';
      this._savingLabelSprite.bitmap.drawText(_labelText, 0, 0, _labelWidth, 30, 'right');

      _startX += _labelWidth;

      this._savingSprite.bitmap.clear();
      this._savingSprite.bitmap.fontSize = 24;
      const _width = this._savingSprite.bitmap.measureTextWidth(_valueText);
      this._savingSprite.bitmap = new Bitmap(_width, 30);
      this._savingSprite.bitmap.smooth = false;
      this._savingSprite.x = _startX;
      this._savingSprite.bitmap.fontSize = 24;
      this._savingSprite.bitmap.textColor = '#e16410';
      this._savingSprite.bitmap.outlineWidth = 5;
      this._savingSprite.bitmap.outlineColor = '#FFFFFF';
      this._savingSprite.bitmap.drawText(_valueText, 0, 0, _width, 30, 'left');

      this._savingSprite.x = _startX;
      this._moneyIconSprite.x = _startX + this._savingSprite.width + 5;
    }

    drawItem(index) {
      const rect = this.itemLineRect(index);
      this.resetTextColor();

      const _item = this._list[index];
      
      
      let _btnSrc = 'ui/button/shop_item_btn'
      const _isEmpty = Utils_Item.getRepertory(_item.id) <= 0;

      if (_isEmpty) {
        _btnSrc = 'ui/button/shop_item_btn_disabled';
      }
      
      // 道具名称
      this.contents.fontSize = 22;
      this.contents.textColor = '#ec4f18';
      this.contents.outlineWidth = 5;
      this.contents.outlineColor = '#FFFFFF';
      this.drawText(_item.name, rect.x + 125, rect.y - 25, rect.width, 'left');
      
      // 道具描述
      this.drawTextEx($dataItems[_item.id].description, rect.x + 125, rect.y + 10, 370, {
        fontSize: 16,
        textColor: '#e16410',
        outlineWidth: 5,
        outlineColor: '#FFFFFF',
      });
      
      // 价格文本
      this.contents.fontSize = 20;
      this.contents.textColor = '#e16410';
      this.contents.outlineWidth = 5;
      this.contents.outlineColor = '#FFFFFF';
      this.drawText($dataItems[_item.id].price + '', rect.x + 540, rect.y + 32, 60, 'right');

      // 库存背景
      this.contents.bltImg('ui/shop/shop_item_prop_bg', undefined, {
        x: rect.x + 280,
        y: rect.y - 22,
        width: 210,
        height: 29
      }, () => {
        this.contents.fontSize = 15;
        this.contents.textColor = '#e16410';
        this.contents.outlineWidth = 5;
        this.contents.outlineColor = '#FFFFFF';

        // 库存数量
        const _textWidth = this.contents.measureTextWidth('库存：');
        this.contents.textColor = '#e16410';
        this.drawText('库存：', rect.x + 285 + 20, rect.y - 25, 60, 'left');
        this.contents.textColor = '#ec4f18';
        this.drawText(Utils_Item.getRepertory(_item.id) + '', rect.x + 285 + 20 + _textWidth, rect.y - 25, 60, 'left');
        
        // 持有数量
        const _text2Width = this.contents.measureTextWidth('持有：');
        this.contents.textColor = '#e16410';
        this.drawText('持有：', rect.x + 385 + 20, rect.y - 25, 60, 'left');
        this.contents.textColor = '#ec4f18';
        this.drawText($gameParty._items[_item.id] || 0, rect.x + 385 + 20 + _text2Width, rect.y - 25, 60, 'left');
      });

      this.contents.bltImg(_btnSrc, undefined, {
        x: rect.x + 540,
        y: rect.y - 20,
        width: 101,
        height: 50
      }, () => {
        this.contents.fontSize = 20;
        if (_isEmpty) {
          this.contents.textColor = '#686868';
        } else {
          this.contents.textColor = '#EC6D18';
        }
        this.contents.drawText('购买', rect.x + 540, rect.y - 20, 101, 50, 'center');
      });
      
      // 物品图片
      this.contents.bltImg(`items/` + _item.id, undefined, {
        x: rect.x + 16,
        y: rect.y - 23,
        width: 90,
        height: 90
      });
      
      // 金钱图片
      this.contents.bltImg(`ui/icon/money_small`, undefined, {
        x: rect.x + 605,
        y: rect.y + 35,
        width: 30,
        height: 30
      });
      
    }
  }
  window.Window_Haku_Shop = Window_Haku_Shop;

})();