//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_Clothing_Shop.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 服装店场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /** 男主行为菜单 */
  const __actorMenus = [
    {
      name: '艾露的回忆',
      text: '艾露的回忆',
      icon: 'icon_recall',
      tooltip: '这是艾露的回忆，要看一下吗？',
      get visible() {
        return [
          $gameSwitches.value(23), 
          $gameSwitches.value(24)
        ].some(i => i);
      },
      onTap() {
        $gameData.isEventBusy = true;

        const _topicList = [
          { title: '艾露视角「初见艾露」', eventId: 123, visible: $gameSwitches.value(23) },
          { title: '艾露视角「名为艾露的陷阱」', eventId: 172, visible: $gameSwitches.value(24) },
        ].filter(i => i.visible);

        const _commandList = [
          { code: 102, indent: 0, parameters: [ _topicList.map(i => i.title).concat(TranslateUtils.getText('还是算了吧…')), 1, 0, 2, 0 ] }
        ];
        
        for (let i = 0; i < _topicList.length; i++) {
          const _topic = _topicList[i];
          _commandList.push({ code: 402, indent: 0, parameters: [
            i, _topic.title
          ] });
          _commandList.push({ code: 117, indent: 1, parameters: [ _topic.eventId ] });
          // _commandList.push({ code: 117, indent: 1, parameters: [ 27 ] });
          _commandList.push({ code: 355, indent:1, parameters:[`
            $gameData.isEventBusy = false;
          `] });
        }

        _commandList.push({ code: 402, indent: 0, parameters: [
          _topicList.length, TranslateUtils.getText('没什么')
        ] });
        _commandList.push({code:355,indent:0,parameters:[`
          $gameData.isEventBusy = false;
          Utils_Tachie.changeFace('13', null, 'kana');
        `]});

        // _commandList.push({ code: 117, indent: 1, parameters: [ 1 ] });

        startTalk([{ text: '（可以从艾露的视角查看过往的事件…）' }], _commandList);

        Utils_Cursor.cursorType = 'default';
      }
    }, {
      name: '随便聊聊',
      text: '随便聊聊',
      icon: 'icon_chat',
      tooltip: '要和艾露增进感情吗？希望不要被捉弄才好呢',
      get disabled() { return Utils_Actor.live <= 10; },
      onTap() {
        $gameData.isEventBusy = true;
        $gameTemp.reserveCommonEvent(267);
      }
    }, {
      name: '使用道具',
      text: '使用道具',
      icon: 'icon_box',
      get tooltip() {
        return '看看还有些什么可以用的东西…';
      },
      get disabled() { return false; },
      onTap() {
        SceneManager.push(Scene_Haku_Item);
      }
    }, {
      name: '离开',
      text: '离开',
      icon: 'icon_goout',
      tooltip: '那就先离开吧',
      onTap() {
        if (Utils_Scene.sameYuki()) {
          this.showTachie();
          startTalk(Utils_ChatMessage.getChat('艾露-路上小心'), [], () => {
            Utils_Scene.changeScene({ sceneName: 'scene_map' });
          });
        } else {
          Utils_Scene.changeScene({ sceneName: 'scene_map' });
        }
      }
    }
  ];



  /**
   * 服装店场景
   */
  class Scene_Haku_Clothing_Shop extends Scene_MainScene {
    initialize() {
      super.initialize();

    }
    
    gotoScene() {
      if (!$gameData.isEventBusy) {
        this.showTachie();
      }
    }

    create() {
      super.create();
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      /** 男主行为菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.actorMenus = __actorMenus;
    }

    update() {
      super.update();

    }
  }
  window.Scene_Haku_Clothing_Shop = Scene_Haku_Clothing_Shop;

})();