//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_Diary.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 妹妹的日记场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 * 
 * @command addDiary
 * @text 新增日记
 * @desc 新增日记
 * 
 * @arg id
 * @type text
 * @text 日记ID
 * @desc 日记的ID
 * 
 * @arg day
 * @type text
 * @text 日期
 * @desc 日期，数字，不填则完为当前日期
 * 
 */
// #endregion
(() => {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Scene_Diary";

  const DiaryList = [
    {
      id: 'a_1',
      remark: '随机日记1',
      text: '哈….又收到了奇怪的情书，真是困扰呢，可千万不能让哥哥看到呢…不过还是会有点高兴的，笨蛋哥哥什么时候才会给我写…嘛，他那种只知道色色的榆木脑袋还是算了吧……',
    }, {
      id: 'a_2',
      remark: '随机日记2',
      text: '放学和稍微有一点点喜欢的同学一起回的家，和哥哥比的话..果然哥哥会顺眼的多，虽然他在一般人眼里就是平平无奇的死宅吧，不过不知道为什么会这么喜欢…每天装作不喜欢也很难啊，真是的…',
    }, {
      id: 'a_3',
      remark: '随机日记3',
      text: '今天在学校里趁着大家放学之后用桌角自慰了….真是舒服呢，不过做的时候还想着哥哥这点也很害羞就是了..不知道那个时候笨蛋哥哥在做什么呢…',
    }, {
      id: 'a_4',
      remark: '随机日记4',
      text: '今晚在被子里自慰了…反正笨蛋哥哥也会看到这篇日记的吧，一边揉着阴蒂一边想着哥哥的肉棒…真是舒服又让人害羞呢…下次要不要去夜袭哥哥好了…哥哥你说呢？（ 笑',
    }, {
      id: 'a_5',
      remark: '随机日记5',
      text: '早上起来的时候看到了哥哥的晨勃，脑子里的那个场景挥之不去，一整天小穴都是湿的…之后在学校厕所里手不自觉的就伸向了小穴，然后耐不住寂寞的我还是在厕所自慰了….结果一整天穿着湿透的内裤真的好难受啊…下次还是随身带一条换洗内裤吧…',
    }, {
      id: 'a_6',
      remark: '随机日记6',
      text: '班上的男生好烦，一天到晚就知道在那无事献殷勤，我还不知道他们在想什么吗…不如笨蛋老哥一星半点儿！呜！真是的，生气生气！姆…',
    }, {
      id: 'a_7',
      remark: '随机日记7',
      text: '和同学聊关于自己喜欢的类型，结果脑子里全都是哥哥的样子，最后还是被嘲笑是兄控了啊…我到底喜欢上笨蛋哥哥哪里了…羞死了！',
    }, {
      id: 'a_8',
      remark: '随机日记8',
      text: '昨天晚上自慰的时候一直在用手指插小穴，然而这点尺寸完全不如哥哥的大，好不容易高潮了之后才睡下，第二天的手好酸啊…要不要试试看买点小玩具用呢…',
    }, {
      id: 'a_9',
      remark: '随机日记9',
      text: '色狼哥哥，满脑子都是色色，搞得我心里都痒痒的，时不时就会幻想把我按在墙上强奸，把他的那根又粗又长的肉棒插进我的小穴里…但这个胆小鬼又不会实施…要不然下次试着只穿内裤和T恤在他面前诱惑他吧～♡',
    }, {
      id: 'a_10',
      remark: '随机日记10',
      text: '今天又在哥哥的房间里找到我的内裤了呢，上面还沾着黄黄的精斑，因为好奇就闻了一下，结果没忍住闻着这个自慰了呢…用沾着哥哥精液的内裤自慰什么的，我可真是没救了呢～♡',
    }, 
    
    
    {
      id: 'b_1',
      remark: '完成了吃饭时揉胸剧情1',
      text: '没想到那个胆小鬼哥哥居然真的出手了！居然在吃饭的时候干那种事情，真的是个大色狼！色情狂！变态！也不知道什么时候该干什么…至少给我注意一下场合啊！',
    }, {
      id: 'b_2',
      remark: '给加奈送礼（第一次）',
      text: '那个榆木脑袋的笨蛋哥哥居然也会给我送礼物吗？真是吓了我一跳，我还以为是什么特别重要的日子我给忘了…不过嘛～嘿嘿嘿～♡老哥也会开始在意我给我送东西了呢～♡好开心啊～♡',
    }, {
      id: 'b_3',
      remark: '给加奈喂安眠药（第一次）',
      text: '今天喝的那个东西…很明显有问题嘛，那个笨蛋老哥真的是，真以为我什么都看不出来吗？笨蛋～满脑子都是色色的笨蛋！没办法呢…这次就算我倒霉吧，稍微配合一下他吧。',
    }, {
      id: 'b_4',
      remark: '交互模式 - 摸头（第一次）',
      text: '昨天哥哥摸了我的头啊…哥哥的手好大，好温暖啊…嘿嘿～印象里已经很久没有和哥哥有过亲密互动了，这样似乎也不错嘛～',
    }, {
      id: 'b_5',
      remark: '交互模式 - 摸腿（第一次）',
      text: '总感觉哥哥的手有点糙糙的，摸到敏感带的时候稍微有点感觉了…大腿内侧那边酥酥麻麻的，有点舒服呢…今天晚上继续用哥哥当配菜吧！',
    }, {
      id: 'b_6',
      remark: '交互模式 - 揉胸（第一次）',
      text: '第一次被哥哥当着面的玩弄胸部，真的是非常害羞呢，但是被哥哥揉捏胸部的感觉真的很舒服啊…差点在哥哥面前去了啊…♡',
    }, {
      id: 'b_7',
      remark: '交互模式 - 连续三天摸头（第一次）',
      text: '哥哥最近…是什么奇怪的养成游戏玩多了吗？怎么总喜欢摸我的头啊，嘛…虽然不讨厌就是啦～',
    }, {
      id: 'b_8',
      remark: '连续三天对话三次均选择正确（第一次）',
      text: '总觉得老哥最近很帅很迷人呢～口才也变好了不少，这就是所谓社会人的余韵吗？稍微有点被迷住了呢～',
    }, {
      id: 'b_9',
      remark: '连续三天对话三次均选择错误（第一次）',
      text: '最近老哥为什么这么烦人呢…一看到他的脸就心情不好！也不知道是不是他故意老是说那些话来气我！真的是！笨蛋笨蛋笨蛋笨蛋！',
    }, {
      id: 'b_10',
      remark: '偷看加奈洗澡（第一次，未被发现）',
      text: '洗澡的时候总感觉被谁盯着似得，应该只是错觉吧，如果真的有人…多半也是笨蛋哥哥在看着吧。真是个色情笨蛋啊…还是稍微注意一点吧…',
    }, {
      id: 'b_11',
      remark: '偷窥小便（第一次，未被发现）',
      text: '为什么总感觉上厕所的时候有被注视的感觉…难道说厕所里面有老鼠吗？回头和哥哥说一下吧…',
    }, {
      id: 'b_12',
      remark: '偷窥小便（第一次，被发现）',
      text: '我早该想到，绝对是那个笨蛋色情狂老哥在门口啊…真的是…最差劲了…有色心没色胆的笨蛋笨蛋笨蛋！！！',
    }, {
      id: 'b_13',
      remark: '带着逛街（第一次，买了小熊）',
      text: '很久没有和哥哥一起逛街了啊，真是有点怀念呢，今天哥哥还给我买了我最喜欢的小熊…虽然已经不是小孩子了，会有点害羞呢…♡嘿嘿～最喜欢哥哥了…',
    }, {
      id: 'b_14',
      remark: '带着逛街（第一次，没买小熊）',
      text: '很久没有和哥哥一起逛街了啊，真是有点怀念呢，路过商店的时候看到了一款很喜欢的小熊玩偶呢…不过价格有点贵，还是放弃了呢…没办法，为了和哥哥的生活，稍微忍忍吧。',
    }, {
      id: 'b_15',
      remark: '常规夜袭（第一次、惊醒）',
      text: '昨晚真是被吓了一跳呢，唔…真是人渣哥哥…果然今天给他摆一天臭脸好了，哼！虽然喜欢…但是这种事情还是很过分呢……不行的话下、下次和我商量一下嘛…笨蛋笨蛋笨蛋！',
    }, {
      id: 'b_16',
      remark: '常规夜袭（第一次、未惊醒）',
      text: '早上起来的时候总感觉哪里奇奇怪怪的，但又说不上是哪里有问题…大概是我多疑了吧～',
    }, {
      id: 'b_17',
      remark: '完成了千夏剧情1',
      text: '最近哥哥终于找到兼职了，在千夏酱那边干活的话我也放心呢～要是千夏酱先我一步拿下哥哥的话…那我也只能勉为其难的和千夏酱一起共享哥哥了呢～♡',
    }, {
      id: 'b_18',
      remark: '完成了由纪剧情1',
      text: '老哥他果然…在外面有别的女人了！是那个叫由纪的家伙是吧！偷腥猫…胸部居然还比我大！真是不可饶恕啊！下次去哪个店里会会她吧！哥哥是我的！哼！',
    },
  ];

  /**
   * 妹妹的日记场景
   */
  class Scene_Haku_Diary extends Scene_Game {
    initialize() {
      super.initialize();

      this._disabledFade = true;

      this.pageWidth = 743;
      /** 标签列表 */
      this.diaryList = Utils_Diary.getDiaryList();
      /** 当前页数 */
      const _tryPageIndex = this.diaryList.findIndex(i => i.day === Utils_Time.day);
      this.pageIndex = _tryPageIndex === undefined ? 0 : _tryPageIndex > 0 ? _tryPageIndex - 1 : 0;

      this.animeType = 'in';

      this.animeInOutInfo = useAnime({
        frameDelay: 0,
        frameCount: 30,
        easingType: 'Quadratic',
        inout: 'InOut',
      }, progress => {
        if (this.animeType === 'in') {
          this.winContainer.x = parseInt(Graphics.width - progress * this.pageWidth);
          this._backgroundSprite.opacity = 255 - progress * 80;
        } else if (this.animeType === 'out') {
          this.winContainer.x = parseInt(Graphics.width - this.pageWidth + progress * this.pageWidth);
          this._backgroundSprite.opacity = 255 - 80 + progress * 80;
          if (progress >= 1) {
            $gameSystem.enableMenu();
            SceneManager.pop();
            setTimeout(() => {
              SceneManager._scene._useMask = false;
            }, 50);
          }
        }
      });
    }

    get realDate() {
      return `6月 ${this.diaryList[this.pageIndex].day}日`
    }

    /** 最大页数 */
    get maxPageCount() {
      return this.diaryList.length - 1;
    }

    create() {
      $gameSystem.disableMenu();
      super.create();
      this.createBackground();

      this.changePage();
      this.animeInOutInfo.start();
    }

    setBackgroundOpacity(opacity) {
      this._backgroundSprite.opacity = opacity;
    }

    /** 半透明背景 */
    createBackground() {
      // this._backgroundFilter = new PIXI.filters.BlurFilter();
      this._backgroundSprite = new Sprite();
      this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
      this._backgroundSprite.filters = []; // this._backgroundFilter
      this.addChildAt(this._backgroundSprite, 0);
      this.setBackgroundOpacity(192);

      this.winContainer = new PIXI.Container();
      this.winContainer.x = Graphics.width;
      this.addChild(this.winContainer);

      this.bgContainer = new PIXI.Container();
      this.winContainer.addChild(this.bgContainer);

      this.contentContainer = new PIXI.Container();
      this.winContainer.addChild(this.contentContainer);

      this.fgContainer = new PIXI.Container();
      this.winContainer.addChild(this.fgContainer);

      // 添加背景
      this._mainBgSprite = new Sprite(ImageManager.loadPicture('ui/diary/background'));
      this.bgContainer.addChild(this._mainBgSprite);

      // 添加内容
      this._contentSprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
      this._contentBitmap = this._contentSprite.bitmap;
      this.contentContainer.addChild(this._contentSprite);

      // 添加前景
      this._mainFgSprite = new Sprite();
      this.fgContainer.addChild(this._mainFgSprite);

      this.createButtons();
    }

    /**
     * 创建按钮
     */
    createButtons() {
      let _isFirstPage = this.pageIndex === 0;
      let _prevUrl = _isFirstPage ? 'ui/diary/btn_disabled' : 'ui/diary/btn';
      let _isLastPage = this.pageIndex >= this.maxPageCount;
      let _nextUrl = _isLastPage ? 'ui/diary/btn_disabled' : 'ui/diary/btn';

      // 添加按钮
      this.prevButtonBg = new Sprite(ImageManager.loadPicture(_prevUrl));
      this.prevButtonBg.x = 100;
      this.prevButtonBg.y = Graphics.height - 100;
      
      this.prevButtonText = new Sprite(new Bitmap(220, 50));
      this.prevButtonText.bitmap.fontSize = 22;
      this.prevButtonText.bitmap.textColor = _isFirstPage ? '#999999' : '#665258';
      this.prevButtonText.bitmap.outlineColor = 'rgba(0,0,0,0)';
      this.prevButtonText.bitmap.drawText(`◀ ${TranslateUtils.getText('上一页')}`, 0, 0, 220, 50, 'center');
      this.prevButtonText.x = 100;
      this.prevButtonText.y = Graphics.height - 100;

      this.nextButtonBg = new Sprite(ImageManager.loadPicture(_nextUrl));
      this.nextButtonBg.x = 470;
      this.nextButtonBg.y = Graphics.height - 100;
      
      this.nextButtonText = new Sprite(new Bitmap(220, 50));
      this.nextButtonText.bitmap.fontSize = 22;
      this.nextButtonText.bitmap.textColor = _isLastPage ? '#999999' : '#665258';
      this.nextButtonText.bitmap.outlineColor = 'rgba(0,0,0,0)';
      this.nextButtonText.bitmap.drawText(`${TranslateUtils.getText('下一页')} ▶`, 0, 0, 220, 50, 'center');
      this.nextButtonText.x = 470;
      this.nextButtonText.y = Graphics.height - 100;

      this.fgContainer.addChild(this.prevButtonBg);
      this.fgContainer.addChild(this.prevButtonText);
      this.fgContainer.addChild(this.nextButtonBg);
      this.fgContainer.addChild(this.nextButtonText);
    }

    /**
     * 切换页面
     */
    changePage() {
      this._contentBitmap.clear();

      // 标题部分
      this._contentBitmap.fontFace = 'Kose';
      this._contentBitmap.fontSize = 30;
      this._contentBitmap.fontBold = true;
      this._contentBitmap.textColor = '#665258';
      this._contentBitmap.outlineColor = 'rgba(255,255,255,0)';
      this._contentBitmap.outlineWidth = 3;
      this._contentBitmap.drawText(`${this.realDate} 上午`, 80, 22, this.pageWidth, 48, 'left');
      this._contentBitmap.drawText(`加奈`, 80, 22, this.pageWidth - 120, 48, 'right');
      
      // 内容部分
      this._contentBitmap.fontSize = 24;
      this._contentBitmap.fontBold = false;

      const _currentDiary = this.diaryList[this.pageIndex];
      if (_currentDiary) {
        this._contentSprite.drawTextEx(
          _currentDiary.text, 
          80, 80, this.pageWidth - 130
        );
      }
    }

    update() {
      super.update();

      this.animeInOutInfo.update();

      if (TouchInput.isCancelled() || Input.isTriggered('cancel')) {
        this.animeInOutInfo.start();
        this.animeType = 'out';
      }

      const _x = TouchInput.x;
      const _y = TouchInput.y;

      let _touchName = 'default';
      let _isFirstPage = this.pageIndex === 0;
      let _prevUrl = _isFirstPage ? 'ui/diary/btn_disabled' : 'ui/diary/btn';
      let _isLastPage = this.pageIndex >= this.maxPageCount;
      let _nextUrl = _isLastPage ? 'ui/diary/btn_disabled' : 'ui/diary/btn';

      this.prevButtonText.bitmap.clear();
      this.prevButtonText.bitmap.textColor = _isFirstPage ? '#999999' : '#665258';
      this.prevButtonText.bitmap.drawText(`◀ ${TranslateUtils.getText('上一页')}`, 0, 0, 220, 50, 'center');
      
      this.nextButtonText.bitmap.clear();
      this.nextButtonText.bitmap.textColor = _isLastPage ? '#999999' : '#665258';
      this.nextButtonText.bitmap.drawText(`${TranslateUtils.getText('下一页')} ▶`, 0, 0, 220, 50, 'center');

      
      if (this.prevButtonBg.inArea(_x, _y, Graphics.width - this.pageWidth)) {
        _touchName = 'pointer';

        if (_isFirstPage) {
          _touchName = 'disabled';
          // SoundManager.playBuzzer();
        } else if (!this.prevButtonBg.isHover) {
          SoundManager.playCursor();
          this.prevButtonBg.bitmap = ImageManager.loadPicture('ui/diary/btn_active');
        }

        if (TouchInput.isTriggered()) {
          if (_isFirstPage) {
            SoundManager.playBuzzer();
            // this.pageIndex = this.maxPageCount;
          } else {
            this.pageIndex--;
            this.changePage();
            SoundManager.playOk();
          }
        }

        this.prevButtonBg.isHover = true;
      } else if (this.prevButtonBg.isHover) {
        this.prevButtonBg.bitmap = ImageManager.loadPicture(_prevUrl);
        this.prevButtonBg.isHover = false;
      }

      if (this.nextButtonBg.inArea(_x, _y, Graphics.width - this.pageWidth)) {
        _touchName = 'pointer';
        
        if (_isLastPage) {
          _touchName = 'disabled';
          // SoundManager.playBuzzer();
        } else if (!this.nextButtonBg.isHover) {
          SoundManager.playCursor();
          this.nextButtonBg.bitmap = ImageManager.loadPicture('ui/diary/btn_active');
        }

        if (TouchInput.isTriggered()) {
          if (_isLastPage) {
            SoundManager.playBuzzer();
            // this.pageIndex = 0;
          } else {
            this.pageIndex++;
            this.changePage();
            SoundManager.playOk();
          }
        }
        
        this.nextButtonBg.isHover = true;
      } else if (this.nextButtonBg.isHover) {
        this.nextButtonBg.bitmap = ImageManager.loadPicture(_nextUrl);
        this.nextButtonBg.isHover = false;
      }

      Utils_Cursor.cursorType = _touchName;
    }

  }
  window.Scene_Haku_Diary = Scene_Haku_Diary;

  /** 日记工具类 */
  class Utils_Diary {
    /**
     * 获取所有日记的列表
     * @return {{ contents: string[], day: number, stateList: number[], text: string }[]}
     */
    static getDiaryList() {
      const _list = $gameData.diaryList.map((item, index) => {

        const _obj = {
          pageIndex: index,
          contents: item.contents,
          day: item.day,
          stateList: item.stateList,
        };
        _obj.text = item.contents.map(i => {
          const _diaryItem = DiaryList.find(item => item.id === i);
          if (_diaryItem) {
            return _diaryItem.text;
          } else {
            return '';
          }
        }).join('\n\n');
        return _obj;
      });

      return _list;
    }
    /**
     * 获取指定天数的日记
     * @param {number} day 日期（天数）
     * @return {{ contents: string[], day: number, stateList: number[], text: string }[]}
     */
    static getDiary(day) {
      const _diary = $gameData.diaryList.find(i => i.day === day);
      if (!_diary) return undefined;

      const _obj = {
        contents: _diary.contents,
        day: _diary.day,
        stateList: _diary.stateList,
      };
      _obj.text = _diary.contents.map(i => {
        const _diaryItem = DiaryList.find(item => item.id === i);
        if (_diaryItem) {
          return _diaryItem.text;
        } else {
          return '';
        }
      }).join('\n\n');
      return _obj;
    }
    /**
     * 增加新日记
     * @param {string} id 日记id
     * @param {number} day 天数
     */
    addDiary(id, day) {
      if (!day) day = Utils_Time.day;

      const _diaryItem = DiaryList.find(item => item.id === id);

      _diary.contents.push({id});
      if (_diary) {
        _diary.contents.push(_diary.id);
        if (_diaryItem.state) _diary.stateList.push(_diaryItem.state);
      } else {
        $gameData.diaryList.push({
          contents: [_diary.id], day, stateList: _diary.state ? [_diary.state] : [],
        });
      }
    }
  }
  window.Utils_Diary = Utils_Diary;

  if (Utils.RPGMAKER_NAME === "MZ") {
    PluginManager.registerCommand(PluginName, 'addDiary', (args) => {
      Utils_Diary.addDiary(args.id, args.day);
    });
  }

})();