//=============================================================================
// ** RPG Maker MZ - Scene_Haku_Forest.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 森林场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /** 男主行为菜单 */
  const __actorMenus = [
    {
      name: '邀请加奈',
      text: '邀请加奈',
      icon: 'icon_home',
      get tooltip() {
        return Utils_Scene.sameKana() ? '现在出去吗，顺便给加奈买点礼物怎么样？' : '那现在就出门吧';
      },
      get disabled() { return false; },
      get visible() {
        return !Utils_Scene.sameKana() && ['scene_bedroom'].includes(Utils_Scene.kanaScene) && !Utils_Time.isWorkday;
      },
      onTap() {
        if (Utils_Favor.kanaMood === 'sad') {
          startTalk([{ text: '加奈似乎还在生气的样子…还是等她消气之后再叫她过来吧……' }], []);
          return;
        }

        Utils_Scene.actorMove('kana', 'scene_forest');
        
        $gameTemp.execCommonEvent(130, () => {

        });
      }
    }, {
      name: '开始冒险',
      text: '开始冒险',
      icon: 'icon_sign',
      get tooltip() {
        return '来开始冒险吧…';
      },
      get disabled() { return false; },
      onTap() {
        // 时间太晚的话
        if (Utils_Time.hour >= 19) {
          startTalk([{ text: '（这么晚还是不要去森林了吧…）' }]);
          return;
        }
        // 要到周末才能进森林
        if (Utils_Time.isWorkDay) {
          startTalk([{ text: '（还是周末和加奈一起去森林吧…）' }]);
          return;
        }
        // 要和加奈一起才能进森林
        if (!Utils_Scene.sameKana()) {
          startTalk([{ text: '（还是叫上加奈一起再来森林吧…）' }]);
          return;
        }

        // 判断是否进入过森林
        if ($gameSwitches.value(41)) {
          startTalk([{ text: '那我们走吧，要注意安全哦…', actor: 'kana' }], [], () => {
            $gameData.adventure_map_id = 1; // 冒险地图ID
            this.changeRMScene(Scene_Haku_Adventure, { fade: 60 });
          });
        } else {
          $gameTemp.execCommonEvent(129, () => {
            $gameData.adventure_map_id = 1; // 冒险地图ID
            this.changeRMScene(Scene_Haku_Adventure, { fade: 60 });
          });
        }
      }
    }, {
      name: '使用道具',
      text: '使用道具',
      icon: 'icon_box',
      get tooltip() {
        return '看看还有些什么可以用的东西…';
      },
      get disabled() { return false; },
      onTap() {
        SceneManager.push(Scene_Haku_Item);
      }
    }, {
      name: '离开',
      text: '离开',
      icon: 'icon_goout',
      tooltip: '那就先离开吧',
      onTap() {
        if (Utils_Scene.sameKana()) {
          startTalk([{ text: '咦？现在就回家吗？唔…真是不懂哥哥在想什么呢……', actor: 'kana', face: '05' }], [], () => {
            Utils_Scene.withMove('kana', 'scene_bedroom');
          });
        } else {
          Utils_Scene.changeScene({ sceneName: 'scene_map' });
        }
      }
    }
  ];



  /**
   * 森林场景
   */
  class Scene_Haku_Forest extends Scene_MainScene {
    initialize() {
      super.initialize();
    }
    
    gotoScene() {
      if (!$gameData.isEventBusy) {
        this.showTachie();
      }
    }

    create() {
      super.create();
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      /** 男主行为菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.actorMenus = __actorMenus;
    }

    update() {
      super.update();
    }
  }
  window.Scene_Haku_Forest = Scene_Haku_Forest;

})();