//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_Game.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - Game场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  // #region 游戏主场景

  /**
   * 游戏主场景
   */
  class Scene_Game extends Scene_Message {
    initialize() {
      super.initialize();
      this._waitCount = 0;
      this._encounterEffectDuration = 0;
      this._menuEnabled = false;
      this._isBusy = false;
      this._useMask = false;
      this._visibleQImage = false;
      $gameSystem.enableMenu();

      /** 当前节点ID */
      this._hoverElementId = undefined;
      /** 当前节点ID */
      this._hoverElement = undefined;
      /** 当前节点ID */
      this._tempHoverElementId = undefined;
      /** 当前节点ID */
      this._activeElementId = undefined;

      /** 元素列表 */
      this._elements = [];
    }

    /** 当前鼠标移动节点 */
    get hoverElementId() {
      return this._hoverElementId;
    }
    set hoverElementId(value) {
      this._hoverElementId = value;
    }
    /** 当前鼠标移动节点 */
    get hoverElement() {
      return this._hoverElement;
    }
    set hoverElement(value) {
      this._hoverElement = value;
    }

    /** 是否显示Q版图 */
    get visibleQImage() {
      return this._visibleQImage;
    }
    set visibleQImage(value) {
      this._visibleQImage = value;
      // if (this.qContainer) {
      //   this.qContainer.visible = !!value;
      // }
    }

    /** 判断繁忙 */
    isBusy() {
      return this._isBusy || this.isFading();
    }

    create() {
      super.create();
      // 添加一个背景UI框
      this.backUIContainer = new SpineContainer();
      this.backUIContainer.cid = 'backUIContainer';
      this.addChild(this.backUIContainer);
      this.createOverallFilters();
      // 添加一个UI框
      this.uiContainer = new HakuContainer();
      this.addChild(this.uiContainer);
      // 添加一个前景UI框
      this.foreUIContainer = new PIXI.Container();
      this.addChild(this.foreUIContainer);
      // 创建黑幕
      this.createBlackMask();

      this.createTopUI();

      this.createPictures();
      this.createTimer();
      
      this.transferBlackMask();

      this._transfer = $gamePlayer.isTransferring();
      this.createDisplayObjects();

      this.createUI();
      // 绘制Q版图位置
      this.createQImage();
      
      this.addChild(this.topUIContainer);
    }

    createUI() {

    }

    createTopUI() {
      this.topUIContainer = new PIXI.Container();
      this.topUIContainer.__remark = 'Top UI Container';
    }

    transferBlackMask(useMask) {
      if (useMask !== undefined) this._useMask = useMask;
      if (!this.blackMask) this.createBlackMask();
      if (this.uiContainer.children.length > 1) {
        this.uiContainer.setChildIndex(this.blackMask, this.uiContainer.children.length - 1);
      }
      if (this._useMask !== undefined) this.blackMask.opacity = this._useMask ? 255 : 0;
      else this.blackMask.opacity = 255 - $gameScreen._brightness;
    }

    /** 设置亮度 */
    setBrightness(value, duration = 20, callback) {
      const _startValue = $gameScreen._brightness;
      const _endValue = value || 0;
      if (duration) {
        useTimeout(() => {
          $gameScreen._brightness = _endValue;
          callback && callback();
        }, duration, (progress) => {
          const _val = _startValue + (_endValue - _startValue) * progress;
          $gameScreen._brightness = Math.round(_val);
        });
      } else {
        callback && callback();
      }
    }

    /**
     * 创建黑幕（遮罩）
     */
    createBlackMask() {
      if (!this.blackMask) {
        this.blackMask = new Sprite(new Bitmap(0, 0));
        if (this._useMask) this.blackMask.opacity = 255;
        else this.blackMask.opacity = 255 - $gameScreen._brightness;
        this.blackMask.bitmap.fillAll('#000000');
        this.uiContainer.addChild(this.blackMask);
      }

      // 创建Filter
      // this._overallColorFilter = new ColorFilter();
      // this.blackMask.filters = [this._overallColorFilter];
      // this._overallColorFilter.uniforms.brightness = 0;
    }

    /** 创建Q版动画或静态图 */
    createQImage() {
      if (!this.qContainer) {
        this.qContainer = new PIXI.Container();
        this.qContainer.alpha = 0;

        this.qBackground = new Sprite(ImageManager.loadPicture('q/q_bg'));
        this.qBackground.x = Graphics.width / 2 - 808 / 2;
        this.qBackground.y = Graphics.height / 2 - 600 / 2;
        this.qBackground.alpha = 1;
        this.qContainer.addChild(this.qBackground);
        
        this.qImage = new Sprite(new Bitmap(400, 400));
        this.qImage.x = Graphics.width / 2 - 400 / 2;
        this.qImage.y = Graphics.height / 2 - 400 / 2;
        this.qImage.alpha = 1;
        this.qContainer.addChild(this.qImage);

        this.uiContainer.addChild(this.qContainer);
      }
    }

    /**
     * 显示Q版图 // 'q/q_sleep_1'
     */
    showQImage(qImgs = [], duration = 330) {
      this.visibleQImage = true;
      let _index = 0;
      let _animeIndex = 0;
      const _animeCount = qImgs.length;
      this.qContainer.alpha = 0;
      useTimeout(() => {
        this.visibleQImage = false;
      }, duration, progress => {
        const _frameIndex = duration * progress;

        if (_frameIndex <= 30) {
          this.qContainer.alpha = _frameIndex / 30;
        } else if (_frameIndex >= duration - 30) {
          this.qContainer.alpha = (duration - _frameIndex) / 30;
        } else if (_frameIndex - _index >= 20) {
          this.qImage.bitmap = ImageManager.loadPicture(qImgs[_animeIndex]);
          if (_animeIndex < _animeCount - 1) {
            _animeIndex++;
          } else {
            _animeIndex = 0;
          }
          _index += 20;
        }
      });
    }

    /**
     * 加载Q版图列表
     * @param {string[]} imgs 
     */
    loadQImage(imgs = []) {

    }

    // #region Update部分
    update() {

      this._tempHoverElementId = undefined;

      this.updateMainMultiply();
      super.update();
      // this.updateVisibility();
      this.updateWaitCount();
      if (this.isSceneChangeOk()) {
        this.updateScene();
      }

      this.updateBlackMask();
      this.updatePosition();
      this.updateOverallFilters();

      this.updateBackUITransform();
    };

    /** 更新背景变化尺寸 */
    updateBackUITransform() {
      if (this.backUIContainer && $gameScreen._gameTransformDuration >= 0) {
        this.backUIContainer.scale.x = $gameScreen._bgScale;
        this.backUIContainer.scale.y = $gameScreen._bgScale;
        this.backUIContainer.x = $gameScreen._bgTransformX;
        this.backUIContainer.y = $gameScreen._bgTransformY;
      }
    }
    
    createPictures() {
      const rect = this.pictureContainerRect();
      this._pictureContainer = new Sprite();
      this._pictureContainer.setFrame(rect.x, rect.y, rect.width, rect.height);
      const _maxCount = $gameScreen.maxPictures();
      for (let i = 1; i <= _maxCount; i++) {
        this._pictureContainer.addChild(new Sprite_Picture(i));
      }
      this.addChild(this._pictureContainer);
    };
    pictureContainerRect() {
      return new Rectangle(0, 0, Graphics.width, Graphics.height);
    };
    createTimer() {
      this._timerSprite = new Sprite_Timer();
      this.addChild(this._timerSprite);
    };
    createOverallFilters() {
      this.backUIContainer.filters = [];
      // this.filters = [];
      this._overallColorFilter = new ColorFilter();
      this.backUIContainer.filters.push(this._overallColorFilter);
      // $gameScreen._brightness = 0;
      // this.updateOverallFilters();
    };
    
    updateOverallFilters() {
      const filter = this._overallColorFilter;
      filter.setColorTone($gameScreen.tone());
      filter.setBlendColor($gameScreen.flashColor());
      filter.setBrightness($gameScreen.brightness());
    };
    
    updatePosition() {
      const screen = $gameScreen;
      const scale = screen.zoomScale();
      this.scale.x = scale;
      this.scale.y = scale;
      this.x = Math.round(-screen.zoomX() * (scale - 1));
      this.y = Math.round(-screen.zoomY() * (scale - 1));
      this.x += Math.round(screen.shake());
    };

    updateBlackMask() {
      if (255 - this.blackMask.opacity !== $gameScreen._brightness) {
        this.blackMask.opacity = 255 - $gameScreen._brightness;
      }

      // const filter = this._overallColorFilter;
      // filter.setBlendColor($gameScreen.flashColor());
      // filter.setBrightness($gameScreen.brightness());
    }

    /** 在范围内 */
    inArea(sprite, x, y, ox = 0, oy = 0, ow = 0, oh = 0) {
      const _isSprite = (sprite instanceof Sprite) || (sprite instanceof PIXI.Container);
      if (_isSprite && !sprite.transform) return false;
      
      return (
        x >= sprite.x + ox && x <= sprite.x + sprite.width + ow + ox && 
        y >= sprite.y + oy && y <= sprite.y + sprite.height + oh + oy
      );
    }
    // #endregion

    isFastForward() {
      return (
        $gameMap.isEventRunning() &&
        !SceneManager.isSceneChanging() &&
        (Input.isLongPressed("ok") || TouchInput.isLongPressed())
      );
    }

    updateMainMultiply() {
      if (this.isFastForward()) {
        this.cancelMessageWait();
        this.updateMain();
      }
      this.updateMain();
    }

    updateMain() {
      $gameMap.updateGame(this.isActive());
      // $gamePlayer.update(this.isPlayerActive());
      $gameTimer.update(this.isActive());
      $gameScreen.update();
    }

    isSceneChangeOk() {
      return this.isActive() && !$gameMessage.isBusy();
    }

    isMenuEnabled() {
      return $gameSystem.isMenuEnabled() && !$gameMap.isEventRunning() && !this.visibleDialog;
    }

    updateScene() {
      this.checkGameover();
      if (!SceneManager.isSceneChanging()) {
        this.updateCallMenu();
      }
      // if (!SceneManager.isSceneChanging()) {
      //   this.updateCallDebug();
      // }
    }

    checkGameover() {
      if ($gameParty.isAllDead()) {
        SceneManager.goto(Scene_Gameover);
      }
    }

    updateCallMenu() {
      if (!this._isBusy && this.isMenuEnabled()) {
        this.menuCalling = this.isMenuCalled();
        if (this.menuCalling && !$gamePlayer.isMoving()) {
          // this.visibleSisterTachie = false;
          this.visibleSisterTachieMenu = false;
          this.callMenu();
        }
      } else {
        this.menuCalling = false;
      }
    }

    updateTime() {
      console.warn('updateTime的调用场景错误');
    }

    isMenuCalled() {
      return Input.isTriggered("menu") || TouchInput.isCancelled();
    }
    
    /** 保存临时信息 */
    saveTempInfo() {
      const _scene = SceneManager._scene;
      
      if (!_scene.sceneInfo) return;
      
      $gameData.tempSceneInfo.sceneName = _scene.constructor.name;
      $gameData.tempSceneInfo.gameSceneName = _scene.sceneInfo.name;

      $gameData.tempSceneInfo.canUse = true;
      $gameData.tempSceneInfo.background = $gameData.tempBackground || _scene.sceneInfo.background;
      $gameData.tempSceneInfo.foreground = $gameData.tempForeground || _scene.sceneInfo.foreground;
      
      if (AudioManager._bgmBuffer && AudioManager._bgmBuffer.isPlaying()) {
        $gameData.tempSceneInfo.bgmName = AudioManager._bgmBuffer.name;
        $gameData.tempSceneInfo.bgmPosition = AudioManager._bgmBuffer.seek();
      }
      if (AudioManager._bgsBuffer && AudioManager._bgsBuffer.isPlaying()) {
        $gameData.tempSceneInfo.bgsName = AudioManager._bgsBuffer.name;
        $gameData.tempSceneInfo.bgsPosition = AudioManager._bgsBuffer.seek();
      }
      
      // if (_scene.spine && _scene.spine.tachieInfo) {
      //   $gameData.tempSceneInfo.spineName = _scene.spine.tachieInfo.spineName;
      //   $gameData.tempSceneInfo.spineSkin = _scene.spine.tachieInfo.skin;
      // }

      if (_scene instanceof Scene_Home) {
        $gameData.tempSceneInfo.sisterLoc = _scene._sisterLoc;
      }
    }

    callMenu() {
      if (!this._isBusy) {
        SoundManager.playOk();
        // this.saveTempInfo();
        
        SceneManager.push(Scene_Haku_SysMenu);
        Window_MenuCommand.initCommandPosition();
        // $gameTemp.clearDestination();
        // this._mapNameWindow.hide();
        this._waitCount = 2;
      }
    };

    isBusy() {
      return (
        this.isMessageWindowClosing() ||
        this._waitCount > 0 ||
        this._encounterEffectDuration > 0 ||
        Scene_Message.prototype.isBusy.call(this)
      );
    };

    terminate() {
      super.terminate();
      // this._mapNameWindow.hide();
      // this.hideMenuButton();
      SceneManager.snapForBackground();
      // $gameScreen.clearZoom();
    }

    needsFadeIn() {
      return (
        SceneManager.isPreviousScene(Scene_Battle) ||
        SceneManager.isPreviousScene(Scene_Load)
      );
    };

    needsSlowFadeOut() {
      return (
        SceneManager.isNextScene(Scene_Title) ||
        SceneManager.isNextScene(Scene_Gameover)
      );
    };

    updateWaitCount() {
      if (this._waitCount > 0) {
        this._waitCount--;
        return true;
      }
      return false;
    };

    createDisplayObjects() {
      this.createWindowLayer();
      this.createAllWindows();
    };

    displayName() {
      return '';
    }

    fadeInForTransfer() {
      const fadeType = $gamePlayer.fadeType();
      switch (fadeType) {
        case 0:
        case 1:
          this.startFadeIn(this.fadeSpeed(), fadeType === 1);
          break;
      }
    };

    mapNameWindowRect() {
      const wx = 0;
      const wy = 0;
      const ww = 360;
      const wh = this.calcWindowHeight(1, false);
      return new Rectangle(wx, wy, ww, wh);
    };

    createAllWindows() {
      // this.createMapNameWindow();
      super.createAllWindows();
    };

    createMapNameWindow() {
      const rect = this.mapNameWindowRect();
      this._mapNameWindow = new Window_MapName(rect);
      this.addChild(this._mapNameWindow);
    };

    onTransferEnd() {
      // this._mapNameWindow.open();
      // $gameMap.autoplay();
      // if (this.shouldAutosave()) {
      //   this.requestAutosave();
      // }
    }

    autoplay() {
      $gameSystem.onBeforeSave();
      DataManager.saveGame(0)
        .then(() => this.onAutosaveSuccess())
        .catch(() => this.onAutosaveFailure());
    };

    start() {
      super.start();
      if (this._disabledFade !== true) {
        if (this._transfer) {
          this.fadeInForTransfer();
          this.onTransferEnd();
        } else if (this.needsFadeIn()) {
          this.startFadeIn(this.fadeSpeed(), false);
        }
      }
      this.menuCalling = false;
    };
  }
  window.Scene_Game = Scene_Game;

  // #endregion



  // #region 系统菜单

  /** 系统菜单场景 */
  class Scene_Haku_SysMenu extends Scene_Base {
    initialize() {
      super.initialize();

      this.animeType = 'in';

      this.btns = [
        {
          text: '保存',
          icon: 'ui/icon/icon_menu_save',
          onTap() {
            SceneManager.push(Scene_Save);
          }
        }, {
          text: '读取',
          icon: 'ui/icon/icon_menu_load',
          get disabled() { return !DataManager.isAnySavefileExists(); },
          onTap() {
            SceneManager.push(Scene_Load);
          }
        }, {
          text: '设置',
          icon: 'ui/icon/icon_menu_config',
          onTap() {
            SceneManager.push(Scene_Options);
          }
        }, {
          text: '返回标题',
          icon: 'ui/icon/icon_menu_exit',
          onTap() {
            SceneManager.clearSceneInfo();
            SceneManager.goto(Scene_Title);
          }
        },
      ]

      this.animeInOutInfo = useAnime({
        frameDelay: 0,
        frameCount: 15,
        easingType: 'Quadratic',
        inout: 'InOut',
      }, progress => {
        const _baseX = Graphics.width - 310;
        const _baseX2 = Graphics.width - 420;
        if (this.animeType === 'in') {
          this.menuContainer.alpha = progress;
          this.menuContainer.x = parseInt(_baseX + 50 - progress * 50);
          
          this._windowBgSprite.alpha = progress;
          this._windowBgSprite.x = parseInt(_baseX2 + 50 - progress * 50);
          
          this._backgroundSprite.opacity = 255 - progress * 80;
        } else if (this.animeType === 'out') {
          this.menuContainer.alpha = 1 - progress;
          this.menuContainer.x = parseInt(_baseX + progress * 50);
          
          this._windowBgSprite.alpha = 1 - progress;
          this._windowBgSprite.x = parseInt(_baseX2 + progress * 50);
          
          this._backgroundSprite.opacity = 255 - 80 + progress * 80;
          if (progress >= 1) {
            $gameData.tempSceneInfo.canUse = false;
            SceneManager.pop();
          }
        }
      });
    }

    start() {
      super.start();
      // this.startFadeOut(this.fadeSpeed(), false);
    }

    create() {
      super.create();
      this.createBackground();
      this.createWindowBackground();
      this.createWindowLayer();
      this.createCommandWindow();
    }

    /** 半透明背景 */
    createBackground() {
      // this._backgroundFilter = new PIXI.filters.BlurFilter();
      this._backgroundSprite = new Sprite();
      this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
      this._backgroundSprite.filters = []; // this._backgroundFilter
      this.addChild(this._backgroundSprite);
      // this.setBackgroundOpacity(192);
    }

    /** 系统窗口背景 */
    createWindowBackground() {
      // this._windowMaskSprite = new Sprite();
      // this._windowMaskSprite.bitmap = ImageManager.loadPicture('ui/sys_menu/menu_mask');
      // this._windowMaskSprite.alpha = 0;
      // this.addChild(this._windowMaskSprite);

      this._windowBgSprite = new Sprite();
      this._windowBgSprite.bitmap = ImageManager.loadPicture('ui/sys_menu/menu_panel');
      this._windowBgSprite.alpha = 0;
      this._windowBgSprite.x = Graphics.width - 420;
      this.addChild(this._windowBgSprite);
    }

    setBackgroundOpacity(opacity) {
      this._backgroundSprite.opacity = opacity;
    }

    sysMenuBgRect() {
      const ww = 690;
      const wh = 428;
      const wx = Graphics.width / 2 - ww / 2;
      const wy = Graphics.height / 2 - wh / 2;
      return new Rectangle(wx, wy, ww, wh);
    }

    sysMenuRect() {
      const ww = 345;
      const wh = 300;
      const wx = Graphics.width / 2 - ww / 2 + 22;
      const wy = Graphics.height / 2 - wh / 2 + 70;
      return new Rectangle(wx, wy, ww, wh);
    }

    createCommandWindow() {
      if (this.menuContainer) {
        this.menuContainer.removeChildren();
      } else {
        this.menuContainer = new HakuContainer({
          x: Graphics.width - 320,
          y: 0
        });
        this.menuContainer.alpha = 0;
        this.addChild(this.menuContainer);
      }
      
      // 关闭按钮
      const _closeBtn = new HakuSprite({
        useHover: true, x: 220, y: 30, me: this, isSys: true,
        normalBitmap: ImageManager.loadPicture('ui/sys_menu/sys_btn_close'),
        hoverBitmap: ImageManager.loadPicture('ui/sys_menu/sys_btn_close_active'),
        onTap: () => {
          this.animeInOutInfo.start();
          this.animeType = 'out';
        }
      });
      this.menuContainer.addChild(_closeBtn);

      for (let i = 0; i < this.btns.length; i++) {
        const item = this.btns[i];
        
        const _btnContainer = new HakuContainer({
          useHover: true, x: 0, y: 145 + i * 120, me: this, isSys: true,
          onHover() {
            item.bgSprite.bitmap = ImageManager.loadPicture(`ui/button/sys_item_btn_active`);
          },
          disabled() { return item.disabled; },
          onBlur() {
            item.bgSprite.bitmap = ImageManager.loadPicture(`ui/button/sys_item_btn`);
          },
          onTap() {
            if (item.onTap) item.onTap.call(this.me);
          }
        });
        this.btns[i].container = _btnContainer;

        // 添加背景
        const _disabledSrc = item.disabled ? `ui/button/sys_item_btn_disabled` : 'ui/button/sys_item_btn';
        const _sprite = new Sprite(ImageManager.loadPicture(_disabledSrc));
        _sprite.bitmap.smooth = false;
        this.btns[i].bgSprite = _sprite;
        _btnContainer.addChild(_sprite);
        
        // 添加图标
        const _iconSprite = new Sprite(ImageManager.loadPicture(item.icon));
        _iconSprite.bitmap.smooth = false;
        this.btns[i].iconSprite = _iconSprite;
        _iconSprite.x = 18;
        _iconSprite.y = 31;
        _btnContainer.addChild(_iconSprite);
        
        // 添加文字
        const _textSprite = new Sprite(new Bitmap(194, 60));
        _textSprite.bitmap.smooth = false;
        this.btns[i].textSprite = _textSprite;
        _textSprite.x = 52;
        _textSprite.y = 8;
        _textSprite.bitmap.fontFace = 'ChillRoundF';
        _textSprite.bitmap.fontSize = 24;
        _textSprite.bitmap.outlineWidth = 5;
        _textSprite.bitmap.outlineColor = '#665258';
        _textSprite.bitmap.drawText(item.text, 0, 0, 194, 60, 'center');
        _btnContainer.addChild(_textSprite);

        this.menuContainer.addChild(_btnContainer);
      }

      this.animeInOutInfo.start();
    }

    commandSave() {
      SceneManager.push(Scene_Save);
    }

    commandLoad() {
      SceneManager.push(Scene_Load);
    }

    commandOptions() {
      SceneManager.push(Scene_Options);
    }

    commandReturnTitle() {
      SceneManager.goto(Scene_Title);
    }

    update() {
      super.update();

      this._tempHoverElement = undefined;
      this._tempHoverElementId = undefined;

      this.animeInOutInfo.update();

      if (TouchInput.isCancelled() || Input.isTriggered('cancel')) {
        SoundManager.playCancel();
        this.animeInOutInfo.start();
        this.animeType = 'out';
      }

      const _x = TouchInput.x;
      const _y = TouchInput.y;

      if (TouchInput.isTriggered() && _x < Graphics.width - 420) {
        SoundManager.playCancel();
        this.animeInOutInfo.start();
        this.animeType = 'out';
      }
    }
  }
  window.Scene_Haku_SysMenu = Scene_Haku_SysMenu;

  // #endregion

})();