//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_Home.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 家里卧室场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 * 
 */
// #endregion
(() => {

  /** 妹妹行为菜单（同样适用其他角色） */
  const __sisterMenus = [
    {
      name: 'touch',
      title: '身体接触',
      imageNormal: 'ui/sister_handler/actor_btn_touch',
      imageActive: 'ui/sister_handler/actor_btn_touch_active',
      imageDisabled: 'ui/sister_handler/actor_btn_touch_disabled',
      direction: 'left',
      tooltip: '和可爱的妹妹一起亲近亲近吧～♡',
      disabled() { return false; },
      onTap() {
        this.visibleSisterTachieMenu = false;
        this.visibleSisterTachie = true;
        this.changeSisterLoc('stand');
        $gameTemp.reserveCommonEvent(90);
      },
      _x: -70,
      _y: 100,
      x: -70,
      y: 100,
      angle: 200
    }, {
      name: 'sex',
      title: '色色',
      imageNormal: 'ui/sister_handler/actor_btn_sex',
      imageActive: 'ui/sister_handler/actor_btn_sex_active',
      imageDisabled: 'ui/sister_handler/actor_btn_sex_disabled',
      direction: 'left',
      get tooltip() {
        if (Utils_Favor.kanaFavorLevel >= 2) {
          return '等下，色色是不可以的哦！啊…虽然如果能好好拜托的话…也不是不可以啦…';
        } else {
          return '笨蛋哥哥在想什么啦！怎么可能同意做这种事情…哼………笨蛋…还不是时候哦～';
        }
      },
      disabled() {
        // return true;
        return Utils_Actor.live < 50 || Utils_Favor.kanaFavorLevel < 2;
      },
      onTap() {
        this.visibleSisterTachieMenu = false;
        this.visibleSisterTachie = true;
        this.changeSisterLoc('stand');

        startTalk(Utils_ChatMessage.getChat('加奈做爱'), [], () => {
          Utils_Scene.changeScene({ sceneName: 'scene_bedroom_yobai', props: {
            isFreeMode: false,
            isSleepMode: false
          } });
        });
      },
      _x: -70,
      _y: 360,
      x: -70,
      y: 360,
      angle: 150
    }, {
      name: 'diary',
      title: '日记',
      imageNormal: 'ui/sister_handler/actor_btn_diary',
      imageActive: 'ui/sister_handler/actor_btn_diary_active',
      imageDisabled: 'ui/sister_handler/actor_btn_diary_disabled',
      direction: 'right',
      get visible() { return true; },
      disabled() { return true; },
      // disabled() { return Utils_Favor.kanaFavorLevel < 2; },
      onTap() {
        SceneManager.push(Scene_Haku_Diary);
      },
      _x: 80,
      _y: 50,
      x: 80,
      y: 50,
      angle: -40,
      // _x: -40,
      // _y: 450,
      // x: -40,
      // y: 450,
      // angle: 150
    },
    // {
    //   name: 'dressUp',
    //   title: '换装',
    //   imageNormal: 'ui/sister_handler/actor_btn_dressUp',
    //   imageActive: 'ui/sister_handler/actor_btn_dressUp_active',
    //   imageDisabled: 'ui/sister_handler/actor_btn_dressUp_disabled',
    //   direction: 'right',
    //   get visible() { return false; },
    //   disabled() { return true; },
    //   _x: 80,
    //   _y: 50,
    //   x: 80,
    //   y: 50,
    //   angle: -40
    // },
    {
      name: 'chat',
      title: '聊天',
      imageNormal: 'ui/sister_handler/actor_btn_chat',
      imageActive: 'ui/sister_handler/actor_btn_chat_active',
      imageDisabled: 'ui/sister_handler/actor_btn_chat_disabled',
      direction: 'right',
      get visible() { return true; },
      disabled() { return Utils_Actor.live < 10; },
      onTap() {
        // this.visibleSisterTachie = false;
        this.visibleSisterTachieMenu = false;

        if (Utils_Time.hour >= 22 || Utils_Time.hour < 2) {
          startTalk(Utils_ChatMessage.getChat('有什么事情明天再说'), [], () => {
            Utils_Tachie.changeFace('13', null, 'kana');
            this.visibleSisterTachie = false;
            this.randomSisterLoc();
          });
          return;
        }

        if (Utils_Favor.kanaMood === 'sad') {
          startTalk(Utils_ChatMessage.getChat('现在加奈什么都不想说'), [], () => {
            Utils_Tachie.changeFace('13', null, 'kana');
            this.visibleSisterTachie = false;
            this.randomSisterLoc();
          });
          return;
        }

        const _topicList = Utils_Topic.getTopicList();
        
        $gameData.isEventBusy = true;

        const _commandList = [
          { code: 102, indent: 0, parameters: [ _topicList.map(i => {
            return TranslateUtils.getText(i.title, [TranslateUtils.getText($dataActors[1].name)]);
          }).concat(TranslateUtils.getText('没什么')), 1, 0, 2, 0 ] }
        ];
        
        for (let i = 0; i < _topicList.length; i++) {
          const _topic = _topicList[i];
          _commandList.push({ code: 402, indent: 0, parameters: [
            i, TranslateUtils.getText(_topic.title, [TranslateUtils.getText($dataActors[1].name)])
          ] });
          _commandList.push({ code: 355, indent:1, parameters:[`
            Utils_Actor.live -= 10;
          `] });
          _commandList.push({ code: 117, indent: 1, parameters: [ _topic.eventId ] });
          // _commandList.push({ code: 117, indent: 1, parameters: [ 27 ] });
          _commandList.push({ code: 355, indent:1, parameters:[`
            $gameData.isEventBusy = false;
            Utils_Time.timeElapse(30, { isSleep: false, mask: false, delay: 6 });
          `] });
        }

        _commandList.push({ code: 402, indent: 0, parameters: [
          _topicList.length, TranslateUtils.getText('没什么')
        ] });
        _commandList.push({code:355,indent:0,parameters:[`
          $gameData.isEventBusy = false;
          Utils_Tachie.changeFace('13', null, 'kana');
          SceneManager._scene.randomSisterLoc();
        `]});

        // _commandList.push({ code: 117, indent: 1, parameters: [ 1 ] });

        startTalk(Utils_ChatMessage.getChat('准备和加奈聊天'), _commandList);

        Utils_Cursor.cursorType = 'default';
      },
      _x: 140,
      _y: 230,
      x: 140,
      y: 230,
      angle: 0
    },
    // {
    //   name: 'gift',
    //   title: '送礼',
    //   imageNormal: 'ui/sister_handler/actor_btn_gift',
    //   imageActive: 'ui/sister_handler/actor_btn_gift_active',
    //   imageDisabled: 'ui/sister_handler/actor_btn_gift_disabled',
    //   direction: 'right',
    //   get visible() { return true; },
    //   x: 120,
    //   y: 330,
    //   angle: 35
    // },
    {
      name: 'back',
      title: '返回',
      imageNormal: 'ui/sister_handler/actor_btn_back',
      imageActive: 'ui/sister_handler/actor_btn_back_active',
      imageDisabled: 'ui/sister_handler/actor_btn_back_disabled',
      direction: 'right',
      get visible() { return true; },
      disabled() { return false; },
      onTap() {
        this.randomSisterLoc();
      },
      _x: 90,
      _y: 460,
      x: 90,
      y: 460,
      angle: 70
    }
  ];

  /** 男主行为菜单 */
  const __actorMenus = [
    {
      name: '安慰加奈',
      text: '安慰加奈',
      icon: 'icon_heart',
      get tooltip() {
        return '就好好的安慰一下生气的加奈吧…';
      },
      get visible() {
        return Utils_Scene.sameKana() && Utils_Favor.kanaMood === 'sad';
      },
      get disabled() { return Utils_Actor.live < 20; },
      onTap() {
        $gameData.isEventBusy = true;
        const _talkList = [];
        _talkList.push(Utils_ChatMessage.getChat('安慰生气的加奈')[0]);
        
        if (Math.random() >= 0.6) {
          Utils_Favor.kanaMood = 'normal';
          Utils_Actor.kanaFavor += 1;
          Utils_Actor.live -= 20;
          _talkList.push(Utils_ChatMessage.getChat('安慰生气的加奈-成功')[0]);
        } else {
          Utils_Actor.kanaFavor += 1;
          Utils_Actor.live -= 20;
          _talkList.push(Utils_ChatMessage.getChat('安慰生气的加奈-失败')[0]);
        }

        startTalk(_talkList, [], () => {
          $gameData.isEventBusy = false;
          this.randomSisterLoc();
          
          Utils_Time.timeElapse(60, { isSleep: false, mask: true, delay: 3 });
          // this.createActorMenuUI();
        });
      }
    }, {
      name: '小憩片刻',
      text: '小憩片刻',
      icon: 'icon_zzz',
      get tooltip() {
        return Utils_Scene.sameKana() ? '稍微休息一会再来继续与妹妹的日常吧～' : '难得妹妹不在家，就好好休息一下吧';
      },
      get disabled() { return false; },
      // get visible() {
      //   return Utils_Time.hour < 20 && Utils_Scene.currentScene === 'scene_bedroom';
      // },
      onTap() {
        Utils_Actor.live += 20;
        Utils_Time.timeElapse(60 * 2, { mask: true, isSleep: false, delay: 5, callback: () => {
          this.randomSisterLoc();
        } });
      }
    }, {
      name: '睡到黄昏',
      text: '睡到黄昏',
      icon: 'icon_moon',
      get tooltip() {
        return Utils_Scene.sameKana() ? '哥哥就好好的休息吧，剩下的事情就交给妹妹我好了～' : '好累啊…就算是白天也好好的睡一觉吧…';
      },
      get disabled() { return false; },
      get visible() {
        return Utils_Time.hour >= 8 && Utils_Time.hour < 18;
      },
      onTap() {
        Utils_Time.timeElapseTo(18, 0, { mask: true, isSleep: false, delay: 2, addLive: true, callback: () => {
          this.randomSisterLoc();
        } });
      }
    }, {
      name: '锻炼身体',
      text: '锻炼身体',
      icon: 'icon_exercise',
      get tooltip() {
        return Utils_Scene.sameKana() ? '哥哥偶尔也要锻炼下身体哦～' : '闲来无事锻炼一下也好呢';
      },
      get disabled() { return Utils_Actor.live < 30; },
      get visible() {
        return Utils_Time.hour >= 8 && Utils_Time.hour < 19;
      },
      onTap() {
        $gameTemp.reserveCommonEvent(256);
      }
    }, {
      name: '睡到第二天',
      text: '睡到第二天',
      icon: 'icon_moon',
      get tooltip() {
        return Utils_Scene.sameKana() ? '是时候睡觉了，哥哥，早睡早起是个好习惯哦' : '有点困了，该睡觉了呢';
      },
      get visible() {
        return Utils_Time.day >= 2 && (Utils_Time.hour < 6 || Utils_Time.hour >= 20);
      },
      onTap() {
        $gameTemp.reserveCommonEvent(258);
      }
    }, {
      name: '使用道具',
      text: '使用道具',
      icon: 'icon_box',
      get tooltip() {
        return Utils_Scene.sameKana() ? '要给加奈送点什么礼物吗？' : '看看还有些什么可以用的东西…';
      },
      get disabled() { return false; },
      get visible() {
        return Utils_Time.day >= 2;
      },
      onTap() {
        SceneManager.push(Scene_Haku_Item);
      }
    }, {
      name: '出门',
      text: '出门',
      icon: 'icon_home',
      get tooltip() {
        return Utils_Scene.sameKana() ? '现在出去吗，顺便给加奈买点礼物怎么样？' : '那现在就出门吧';
      },
      get disabled() { return false; },
      get visible() {
        return ['scene_bedroom'].includes(Utils_Scene.currentScene) && $gameSwitches.value(2);
      },
      onTap() {
        if (Utils_Scene.sameKana()) {
          // this._banLocChange = true;
          this.visibleSisterTachie = true;
          this.changeSisterLoc('stand');
          if (Utils_Time.hour >= 20 || Utils_Time.hour <= 5) {
            startTalk(Utils_ChatMessage.getChat('晚上出门的担心'), [], () => {
              Utils_Scene.changeScene({ sceneName: 'scene_map' });
            });
          } else {
            startTalk(Utils_ChatMessage.getChat('加奈-路上小心'), [], () => {
              Utils_Scene.changeScene({ sceneName: 'scene_map' });
            });
          }
        } else {
          Utils_Scene.changeScene({ sceneName: 'scene_map' });
        }
      }
    }, 
  ];

  const getMiniFace = () => {
    switch (Utils_Favor.kanaMood) {
      case 'normal': return '00';
      case 'happy': return '01';
      case 'sad': return '02';
      default: return '03';
    };
  }

  const getMiniCloth = () => {
    if (Utils_Tachie.useGlasses()) return 'nude';
    if (!SceneManager._scene.spine || !SceneManager._scene.spine.tachieInfo) return 'uniform';
    const _skin = SceneManager._scene.spine.tachieInfo.skin;
    if (_skin.includes('clothes-01')) return 'uniform';
    else if (_skin.includes('clothes-02') || _skin.includes('clothes-03')) return 'underwear';
    else return 'uniform';
  }

  /** 妹妹的状态 */
  const __sisterStates = [
    {
      name: 'bed-sit',
      remark: '在床上坐着',
      type: 'mini',
      x: 295,
      y: 240,
      image() {
        return [
          `tachie/mini-kana/bedsit-${getMiniCloth()}`,
          `tachie/mini-kana/face-bedsit/${getMiniFace()}`,
        ];
      }
    }, {
      name: 'bed-lieprone',
      remark: '在床上趴着',
      type: 'mini',
      x: 290,
      y: 317,
      image() {
        return [
          `tachie/mini-kana/bed-${getMiniCloth()}`,
          ''
        ];
      }
    }, {
      name: 'floor-sit',
      remark: '在地上坐着',
      x: 485,
      y: 375,
      type: 'mini',
      image() {
        return [
          `tachie/mini-kana/floorsit-${getMiniCloth()}`,
          `tachie/mini-kana/face-floorsit/${getMiniFace()}`,
        ];
      }
    }, {
      name: 'chair-sit',
      remark: '在椅子上坐着',
      x: 916,
      y: 248,
      type: 'mini',
      image() {
        return [
          `tachie/mini-kana/chair-${getMiniCloth()}`,
          `tachie/mini-kana/face-chair/00`,
        ];
      }
    }
  ];


  // #region 游戏家里卧室场景

  /**
   * 游戏家里卧室场景
   */
  class Scene_Home extends Scene_MainScene {
    initialize() {
      super.initialize();
      this._touchCount = 0;
      this._disabledFade = true;
      this._prevHoverButton = '';
      this._prevTimeSpan = Utils_Time.timeSpan;
      /** 是否显示大立绘 */
      this._visibleSisterTachie = false;
      /** 是否显示大立绘菜单 */
      this._visibleSisterTachieMenu = false;
      /** 妹妹的衣服 */
      this._sisterCloth = 'uniform';
      /** 妹妹的位置 */
      this._sisterLoc = 'stand';
      /** 妹妹的上一个位置 */
      this._prevSisterLoc = 'stand';
      /** 上一个鼠标划入交互行为 */
      this._prevHoverAction = '';
      /** 【临时变量】是否和加奈在一起 */
      this._withKana = true;
      /** 禁止位置变化 */
      this._banLocChange = false;
      
      // 显示隐藏UI
      /** 动画进行中的UI类型：in/out */
      this.uiAnimeType = 'in';
      /** 动画进行中的UI名称 */
      this.uiAnimeName = '';
      this.uiAnime = useAnime({
        description: '[uiAnime]切换菜单',
        frameDelay: 0,
        frameCount: 15,
        easingType: 'Quadratic',
        inout: 'InOut',
      }, progress => {
        if (this.uiAnimeName === 'sisterMenu') {
          if (!this.sisterMenuContainer) return;

          if (this.uiAnimeType === 'in') {
            this.sisterMenuContainer.alpha = progress;
          } else if (this.uiAnimeType === 'out') {
            this.sisterMenuContainer.alpha = 1 - progress;
          }

          // 调整所有子菜单的坐标
          for (let i = 0; i < this.sisterMenus.length; i++) {
            const _item = this.sisterMenus[i];
            if (!_item.sprite) continue;
            if (_item.angle !== undefined) {
              const { x, y } = calculateAnglePosition(
                _item.angle, _item.x, _item.y, 
                this.uiAnimeType === 'in' ? (1 - progress) * 30 : progress * 30,
              );
              _item.container.x = Math.round(x);
              _item.container.y = Math.round(y);
            }
          }
        } else if (this.uiAnimeName === 'sisterMenuItem') {

        }
      });
    }

    /** 进入当前场景 */
    gotoScene() {
      if (
        !$gameData.isEventBusy && 
        Utils_Scene.sameKana() && 
        !Utils_Scene.checkSameLoc('scene_bedroom', Utils_Scene.prevSceneName)
      ) {
        this.changeSisterLoc('stand');
        this.visibleSisterTachie = true;
        if (Utils_Time.hour >= 22 || Utils_Time.hour < 2) {
          startTalk(Utils_ChatMessage.getChat('回家太晚的担心'), [], () => {
            this.randomSisterLoc();
            Utils_Tachie.changeFace('13', null, 'kana');
          });
        } else {
          startTalk(Utils_ChatMessage.getChat('欢迎回家'), [], () => {
            this.randomSisterLoc();
            Utils_Tachie.changeFace('13', null, 'kana');
          });
        }
      } else {
        this.visibleSisterTachie = false;
      }
    }
    
    /**
     * 校验妹妹的状态
     */
    checkSisterState() {
      super.checkSisterState();

      // 校验妹妹的立绘是否显示
      const _withKana = Utils_Scene.sameKana();
      if (_withKana !== this._withKana) {
        this._withKana = _withKana;

        if (!this._miniTachieContainer && this.createGameTachie) {
          this.createGameTachie();
        }

        if (this._miniTachieContainer) {
          this._miniTachieContainer.alpha = _withKana ? 1 : 0;
          // this._miniTachieContainer.visible = _withKana;
        }

        // 隐藏妹妹交互菜单
        if (!_withKana) {
          this.visibleSisterTachie = false;
          this.visibleSisterTachieMenu = false;
        }
      }
    }

    /** 触发事件前预处理 */
    checkEventTrigger() {
      super.checkEventTrigger();
      
      this.visibleSisterTachie = false;
      this.visibleSisterTachieMenu = false;
    }

    /**
     * 随机切换妹妹的位置/状态
     * @param {string} loc 位置
     */
    randomSisterLoc(loc) {
      if (this.visibleSisterTachie) {
        this.visibleSisterTachie = false;
        this.visibleSisterTachieMenu = false;
      }

      let _loc = loc || '';
      
      if (!_loc) {
        const _index = Math.floor(Math.random() * __sisterStates.length);
        _loc = __sisterStates[_index].name;
      }

      this.changeSisterLoc(_loc);
    }

    toggleTachieVisible(value) {
      if (this.spine) {
        const _spineName = this.spine.tachieInfo.spineName;
        const _tempInfo = $gameData.tempSceneInfo;
        if (!_tempInfo.spineList) _tempInfo.spineList = [];

        if (value) {
          this.spine.alpha = 1;
          // this.spine.visible = true;

          if (_tempInfo.spineInfos[_spineName]) {
            _tempInfo.spineInfos[_spineName].alpha = 1;
            // _tempInfo.spineInfos[_spineName].visible = true;
          }
          if (!_tempInfo.spineList.includes(_spineName)) {
            _tempInfo.spineList.push(_spineName);
          }
        } else {
          this.spine.alpha = 0;
          // this.spine.visible = false;
          
          if (_tempInfo.spineInfos[_spineName]) {
            _tempInfo.spineInfos[_spineName].alpha = 0;
            // _tempInfo.spineInfos[_spineName].visible = false;
            const _index = _tempInfo.spineList.findIndex(i => i ===_spineName);
            if (_index >= 0) _tempInfo.spineList.splice(_index, 1);
          }
        }
      }
    }

    /**
     * 切换妹妹的位置/状态
     */
    changeSisterLoc(loc) {
      if (this._banLocChange) return;

      if (!$gameData.isEventBusy && Utils_Scene.sameKana()) {
        this._prevSisterLoc = this._sisterLoc;
        this._sisterLoc = loc;
        
        $gameData.tempSceneInfo.sisterLoc = loc;
        
        this.toggleTachieVisible(this._sisterLoc === 'stand');

        if (this._sisterLoc === 'stand') {
          this.hoverElementId = '';
          this._miniTachieContainer.alpha = 0;
          // this._miniTachieContainer.visible = false;
        } else {
          this._miniTachieContainer.alpha = 1;
          // this._miniTachieContainer.visible = true;
          const _miniCGInfo = __sisterStates.find(i => i.name === this._sisterLoc);
          this._miniTachieContainer.removeChildren();
          const _imgs = _miniCGInfo.image.call(this);
          for (let i = 0; i < _imgs.length; i++) {
            this._miniTachieContainer.addChild(new Sprite(ImageManager.loadPicture(_imgs[i])));
          }
          this._miniTachieContainer.baseSprite = this._miniTachieContainer.children[0];
          this._miniTachieContainer.faceSprite = this._miniTachieContainer.children[1];
          this._miniTachieContainer.baseSpriteUrl = _imgs[0];
          this._miniTachieContainer.faceSpriteUrl = _imgs[1];
          this._miniTachieContainer.x = _miniCGInfo.x;
          this._miniTachieContainer.y = _miniCGInfo.y;
        }
      } else {
        this._prevSisterLoc = this._sisterLoc;
        this._sisterLoc = loc;
      }
    }

    createUI() {
      super.createUI();

      // if (!$gameData.tempSceneInfo) {
      //   $gameData.tempSceneInfo = { canUse: false };
      // }

      if (Utils_Scene.sameKana()) {
        if ($gameData.tempSceneInfo.canUse) {

          if ($gameData.tempSceneInfo.visibleSisterTachie !== undefined) {
            this.visibleSisterTachie = $gameData.tempSceneInfo.visibleSisterTachie;
            $gameData.tempSceneInfo.visibleSisterTachie = undefined;
          }
          
          if ($gameData.tempSceneInfo.sisterLoc) {
            this.changeSisterLoc($gameData.tempSceneInfo.sisterLoc);

            if ($gameData.tempSceneInfo.sisterLoc === 'stand') {
              this.visibleSisterTachie = true;
              if (!$gameData.isEventBusy && !$gameMessage.isBusy()) {
                this.visibleSisterTachieMenu = true;
              }
            }
            $gameData.tempSceneInfo.sisterLoc = undefined;
          } else {
            if ($gameData.tempSceneInfo.spineList.length) {
              this.visibleSisterTachie = true;
              if (!$gameData.isEventBusy && !$gameMessage.isBusy()) {
                this.visibleSisterTachieMenu = true;
              }
            }
          }

          if ($gameData.tempSceneInfo.visibleSisterTachieMenu !== undefined) {
            this.visibleSisterTachieMenu = $gameData.tempSceneInfo.visibleSisterTachieMenu;
          }
          
        } else if (!$gameData.isEventBusy && !$gameMessage.isBusy()) {
          this.randomSisterLoc();
        }
      }
      //     this.visibleSisterTachie = true;
      //     $gameSystem.resetTachie();
      //   } else {
      //     if (!$gameData.tempSceneInfo.canUse && $gameSystem._savedTachie) {
      //       this.changeSisterLoc('stand');
      //       this.visibleSisterTachie = true;
      //       if (!$gameData.isEventBusy) {
      //         this.visibleSisterTachieMenu = true;
      //       }
      //       $gameSystem.resetTachie();
      //     } else {
      //       this.randomSisterLoc();
      //     }
      //   }
      // }

    }

    /** 获取女角色交互菜单列表 */
    getSisterMenus() {
      /** 界面中的女角色菜单列表 */
      this.sisterMenus = __sisterMenus;
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      /** 男主行为菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.actorMenus = __actorMenus;
    }

    /** 绘制界面 */
    drawViewer() {
      // 1. 绘制背景
      this.drawBackground();
      // 2. 绘制可交互物品
      this.drawSceneObjects();
      // 3. 绘制前景
      this.drawForeground();
      // 4. 绘制游戏组件
      this.drawGameComponents();
    }

    // #region 绘制UI部分
    /** 绘制游戏UI */
    drawGameComponents() {
      this.setTooltip();
      this.setSceneName(this.sceneInfo.title);
    }
    // #endregion

    /** 创建界面 */
    createViewer() {
      // 1. 绘制背景（之前已经创建过了）
      this.drawBackground();
      // 2. 创建立绘区域
      this.createTachieContainer();
      
      // 3. 创建立绘
      this.createGameTachie();

      // if (Utils_Scene.sameKana()) {
        // 4. 创建立绘交互按钮列表
        this.createChatButtons();
      // }

      // 5. 创建前景
      this.createForeground();
      this.drawForeground();
      this.createFilter();
      // 6. 创建游戏组件
      this.createGameComponents();
      // 7. 绘制右上角日期时间UI
      this.createDateTimeUI();
    }

    /** 显示妹妹的立绘及菜单 */
    showSisterTachie() {
      this.visibleSisterTachie = true;
      this.visibleSisterTachieMenu = true;
    }
    /** 隐藏所有立绘 */
    hideTachie() {
      this.visibleSisterTachie = false;
      this.visibleSisterTachieMenu = false;
      this._miniTachieContainer.alpha = 0;
      // this._miniTachieContainer.visible = false;
    }

    /** 是否已经睡觉了 @type {boolean} */
    get isSleep() {
      return $gameData.isSleep === undefined ? false : $gameData.isSleep;
    }
    set isSleep(value) {
      $gameData.isSleep = value;
    }
    /** 是否亮灯 @type {boolean} */
    get isOnLight() {
      return $gameData.isOnLight === undefined ? true : $gameData.isOnLight;
    }
    set isOnLight(value) {
      $gameData.isOnLight = value;
    }

    /** 是否显示妹妹大立绘 */
    get visibleSisterTachie() {
      return this._visibleSisterTachie;
    }
    set visibleSisterTachie(value) {
      if (this._banLocChange) return;

      $gameData.tempSceneInfo.visibleSisterTachie = value;
      this._visibleSisterTachie = value;
      if (this.spine) {
        if (value && this.spine.alpha === 0) {
          this.toggleTachieVisible(1);
        } else if (!value && this.spine.alpha === 1) {
          this.toggleTachieVisible(0);
        }
        // this.sisterMenuContainer.alpha = value ? 0 : 1;
      }
    }

    /** 是否显示妹妹大立绘交互菜单 */
    get visibleSisterTachieMenu() {
      return SceneManager._scene._visibleSisterTachieMenu;
    }
    set visibleSisterTachieMenu(value) {
      $gameData.tempSceneInfo.visibleSisterTachieMenu = value;

      if (value !== SceneManager._scene._visibleSisterTachieMenu) {
        SceneManager._scene._visibleSisterTachieMenu = value;
        // SceneManager._scene.sisterMenuContainer.alpha = value ? 0 : 1;
        SceneManager._scene.uiAnimeType = value ? 'in' : 'out';
        SceneManager._scene.uiAnimeName = 'sisterMenu';
        SceneManager._scene.uiAnime.start();
      }
    }

    /** 创建立绘交互按钮列表 */
    createChatButtons() {
      if (this.sisterMenuContainer) {
        this.sisterMenuContainer.removeChildren();
      } else {
        this.sisterMenuContainer = new HakuContainer();
        this.sisterMenuContainer.x = 0;
        this.sisterMenuContainer.y = 0;
      }
      this.sisterMenuContainer.alpha = this.visibleSisterTachieMenu ? 1 : 0;

      const _itemWidth = 113;
      
      for (let i = 0; i < this.sisterMenus.length; i++) {
        const item = this.sisterMenus[i];

        const _container = new HakuContainer({
          useHover: true, x: 0, y: 0, me: this,
          disabled() { return item.disabled() === true; },
          onHover() {
            if (item.imageActive) {
              item.sprite.bitmap = ImageManager.loadPicture(item.imageActive);
            }
            if (item.tooltip) {
              this.me.setTooltip(item.tooltip);
            }
          },
          onBlur() {
            if (!item.disabled() && item.imageNormal) {
              item.sprite.bitmap = ImageManager.loadPicture(item.imageNormal);
            }
            this.me.setTooltip();
          },
          onTap() {
            if (item.onTap) item.onTap.call(this.me);
          }
        });
        _container.index = i;
        this.sisterMenus[i].container = _container;

        let _itemBg = item.imageNormal;
        if (item.disabled() === true) {
          _itemBg = item.imageDisabled;
        }
        const _sprite = new Sprite(ImageManager.loadPicture(_itemBg));
        _sprite.bitmap.smooth = false;
        this.sisterMenus[i].sprite = _sprite;

        const _spriteText = new Sprite(new Bitmap(_itemWidth, 30));
        _spriteText.bitmap.smooth = false;
        this.sisterMenus[i].textSprite = _spriteText;

        _spriteText.bitmap.fontFace = 'Source Han Sans VF';
        _spriteText.bitmap.fontWeight = 'bold';
        if (item.disabled()) {
          _spriteText.bitmap.textColor = '#666666';
        } else {
          _spriteText.bitmap.textColor = '#ab2525';
        }
        _spriteText.bitmap.fontSize = 16;
        _spriteText.bitmap.outlineColor = '#ffffff';
        _spriteText.bitmap.outlineWidth = 4;
        _spriteText.bitmap.drawText(item.title, 0, 0, _itemWidth, 30, 'center');


        if (item.direction === 'left') {
          _container.x = 400 + item._x;
          _container.y = 50 + item._y;
          _spriteText.y = _itemWidth - 60;
        } else if (item.direction === 'right') {
          _container.x = 250 + 500 + item._x;
          _container.y = 50 + item._y;
          _spriteText.y = _itemWidth - 60;
        }
        item.x = _container.x;
        item.y = _container.y;
        _container.addChild(_sprite);
        _container.addChild(_spriteText);

        this.sisterMenuContainer.addChild(_container);
      }

      this.uiContainer.addChild(this.sisterMenuContainer);
    }

    /** 显示游戏UI */
    // showGameUI() {
    //   if ($gameData.isEventBusy) return;

    //   if (this.titleContainer) this.titleContainer.alpha = 1;
    //   if (this.menuContainer) this.menuContainer.alpha = 1;
    //   // if (this.actorInfoContainer) this.actorInfoContainer.alpha = 1;
    //   if (this.actorMenuContainer) this.actorMenuContainer.alpha = 1;
    //   this.showNormalTooltip();
    // }
    
    /** 隐藏游戏UI */
    // hideGameUI() {
    //   this.setTooltip();
    //   if (this.titleContainer) this.titleContainer.alpha = 0;
    //   if (this.menuContainer) this.menuContainer.alpha = 0;
    //   // if (this.actorInfoContainer) this.actorInfoContainer.alpha = 0;
    //   if (this.actorMenuContainer) this.actorMenuContainer.alpha = 0;
    //   this.showFullTooltip();
    // }

    // #endregion

    // #region 绘制立绘部分
    /** 绘制游戏立绘 */
    createGameTachie() {
      // 创建加奈的迷你立绘
      if (this._miniTachieContainer) {
        this._miniTachieContainer.removeChildren();
      } else {
        this._miniTachieContainer = new HakuContainer({
          useHover: true, me: this,
          readonly() { return !this.visible; },
          onHover() {
            this.baseSprite.bitmap = ImageManager.loadPicture(this.baseSpriteUrl + '_hover');
            if (['floor-sit', 'bed-sit'].includes(this.me._sisterLoc) && this.faceSpriteUrl) {
              this.faceSprite.bitmap = ImageManager.loadPicture(this.faceSpriteUrl + '_hover');
            }
            // if (item.tooltip) {
            //   this.me.setTooltip(item.tooltip);
            // }
          },
          onBlur() {
            if (this.baseSprite.bitmap._url.includes('_hover')) {
              this.baseSprite.bitmap = ImageManager.loadPicture(this.baseSpriteUrl);
              
              if (['floor-sit', 'bed-sit'].includes(this.me._sisterLoc) && this.faceSpriteUrl) {
                this.faceSprite.bitmap = ImageManager.loadPicture(this.faceSpriteUrl);
              }
            }
            // this.me.setTooltip();
          },
          onTap() {
            this.me.changeSisterLoc('stand');

            // 开始对话
            startTalk(Utils_ChatMessage.getChat('加奈的随机对话'), [], () => {
              this.me.showSisterTachie();
            });
            Utils_Cursor.cursorType = 'default';
          }
        });
      }
      
      this._miniTachieContainer.alpha = 0;
      // this._miniTachieContainer.visible = false;
      this.backUIContainer.addChild(this._miniTachieContainer);
    }
    // #endregion

    // #region Update部分
    update() {
      super.update();

      this.uiAnime.update();
      
      this.updateSisterTachie();

      if (!this._isBusy) {

        this.updateSisterMenu();
      }
    };

    /** 妹妹立绘交互 */
    updateSisterTachie() {
      if (!Utils_Scene.sameKana() || $gameData.isEventBusy || this._isBusy) return;
        
      const _x = TouchInput.x;
      const _y = TouchInput.y;
      const _isTriggered = TouchInput.isTriggered();

      if (this._sisterLoc === 'stand') {
        // 状态站立
        if (this.spine) {
          if (this.spine.inArea(_x, _y, -this.spine.width / 2 - 30, -this.spine.height - 30, 60, 60)) {
            if (this.spine.inArea(_x, _y, -this.spine.width / 2, -this.spine.height)) {
              if (this._prevHoverAction !== 'stand_tachie') {
                SoundManager.playCursor();
                Utils_Cursor.cursorType = 'pointer';
                this._prevHoverAction = 'stand_tachie';
              }

              if (_isTriggered) {
                SoundManager.playOk();
              }
            } else {
              this._prevHoverAction = '';
              Utils_Cursor.cursorType = 'default';
            }
          }
        }
      }
    }

    /**
     * 更新妹妹互动菜单
     */
    updateSisterMenu() {
      if (!this.visibleSisterTachieMenu) return;

      const _x = TouchInput.x;
      const _y = TouchInput.y;
      const _isTriggered = TouchInput.isTriggered();

      // 全局检测是否在妹妹立绘范围内触发，检测是否应该显示菜单
      if (_isTriggered && this.spine) {
        const _inSpineArea = this.spine.inArea(_x, _y,
          -this.spine.width / 2,
          -this.spine.height
        );
        if (_inSpineArea) {
          if (this.spine) {
            this.showSisterTachie();
            // TODO: 这里做角色点击交互
          }
        } else if (this.hoverElementId == '' && this.visibleSisterTachie && !_inSpineArea) {
          if (this.spine) {
            this.randomSisterLoc();
          }
        }
      }
    }

    /** 设置说明文本 */
    setTooltip(text) {
      this.tooltipSprite.bitmap.clear();
      if (text) {
        this.tooltipSprite.bitmap.drawText(text, 5, 5, this.tooltipSprite.width - 40 - 30, 20);
      }
    }
    // #endregion
  }
  window.Scene_Home = Scene_Home;

  // #endregion

})();