//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_Init.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 初始页场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /**
   * 开始场景
   */
  class Scene_Haku_Init extends Scene_MainScene {
    initialize() {
      if (!$gameData.isEventBusy && SceneManager._scene instanceof Scene_Haku_Init) {
        $gameScreen._brightness = 0;
        AudioManager.stopBgm();
      }
      super.initialize();
    }

    create() {
      $gameScreen._brightness = 0;
      super.create();

      if (!$gameData.isEventBusy) {
        this.hideGameUI();
        this.hideActorInfoUI();
        
        Utils_Event.triggerEventByTime();
      }
      
      this.startInputName();

      // if ($gameSystem._savedTachie) {
      //   $gameSystem.resetTachie();
      // }

      this.loadTempInfo();
    }

    /** 开始输入角色名称 */
    startInputName() {
      startTalk([
        { text: '你的名字叫什么呢？', name: 'SYSTEM', face: '' },
      ], [], () => {

        inputText('请输入角色名称', '哥哥', text => {

          useConfirm({
            content: TranslateUtils.getText(`是否使用「$1」作为主角名称？`, [text]),
            okHandler() {
              this.close();
              $dataActors[1].name = text;
              $gameActors.actor(1)._name = text;
              SceneManager.go(Scene_Home, () => {
                SceneManager._scene.hideTachie();
                $gameTemp.reserveCommonEvent(101);
              });
            },
            cancelHandler: () => {
              this.startInputName();
            }
          });
        });
      });
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      this.actorMenus = [];
    }

    update() {
      super.update();

    }
  }
  window.Scene_Haku_Init = Scene_Haku_Init;

})();