//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_Interact.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 妹妹交互场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /** 动画列表 */
  const __animeList = {
    // 摸头
    motou: {
      live: 10,
      /** 每天的最大次数 */
      maxCountInDay: 3,
      /** 超出次数 */
      exceedCount() {
        this.isAnger = true;
        startTalk([ { text: '呜！已经够了哦！', name: '加奈', face: '' } ], [], () => {
          $gameData.isEventBusy = false;
          Utils_Scene.changeScene({ sceneName: 'scene_bedroom' });
        });
      },
      condition() {
        return true;
      },
      resolve() {
        Utils_Favor.kanaFavor += 1;
        Utils_Favor.kanaSex += 1;
        // const _state = ({ on: 1, half: 2, off: 3, foot: 4 })[this._clothName];
        SpineManager.setMotion(this.spineInteract, `motou_xx`, false, 2);
        $gameTemp.execCommonEvent(66, () => {
          this.checkState();
        });
      },
    },

    // 摸腿
    motui: {
      live: 10,
      maxCountInDay: 3,
      exceedCount() {
        this.isAnger = true;
        startTalk([ { text: '呜！已经够了哦！', name: '加奈', face: '' } ], [], () => {
          $gameData.isEventBusy = false;
          Utils_Scene.changeScene({ sceneName: 'scene_bedroom' });
        });
      },
      condition() {
        return Utils_Favor.kanaFavor >= 20;
      },
      resolve() {
        Utils_Favor.kanaFavor += 1;
        Utils_Favor.kanaSex += 1;
        SpineManager.setMotion(this.spineInteract, `motui_xx`, false, 2);
        $gameTemp.execCommonEvent(67, () => {
          this.checkState();
        });
      },
      reject() {
        $gameTemp.execCommonEvent(68, () => {
          this.checkState();
        });
      }
    },
    // 揪乳头
    jiurutou: {
      live: 15,
      maxCountInDay: 3,
      exceedCount() {
        this.isAnger = true;
        startTalk([ { text: '笨蛋哥哥…一直这样可是会痛的～！', name: '加奈', face: '' } ], [], () => {
          $gameData.isEventBusy = false;
          Utils_Scene.changeScene({ sceneName: 'scene_bedroom' });
        });
      },
      condition() {
        return Utils_Favor.kanaFavor >= 50;
      },
      resolve() {
        Utils_Actor.san -= 1;
        Utils_Favor.kanaSex += 2;
        SpineManager.setMotion(this.spineInteract, `jiurutou_03`, false, 2);
        Utils_Favor.addKanaSexCount('chest', 1);
        $gameTemp.execCommonEvent(71, () => {
          this.checkState();
        });
      },
      reject() {
        $gameTemp.execCommonEvent(72, () => {
          this.checkState();
        });
      }
    },
    // 舔乳
    tianru: {
      live: 15,
      maxCountInDay: 3,
      exceedCount() {
        this.isAnger = true;
        startTalk([ { text: '已经够了哦！真是的……', name: '加奈', face: '' } ], [], () => {
          $gameData.isEventBusy = false;
          Utils_Scene.changeScene({ sceneName: 'scene_bedroom' });
        });
      },
      condition() {
        return Utils_Favor.kanaFavor >= 50;
      },
      resolve() {
        Utils_Actor.san -= 1;
        Utils_Favor.kanaSex += 2;
        SpineManager.setMotion(this.spineInteract, `tianru_03`, false, 2);
        Utils_Favor.addKanaSexCount('chest', 1);
        $gameTemp.execCommonEvent(73, () => {
          this.checkState();
        });
      },
      reject() {
        $gameTemp.execCommonEvent(74, () => {
          this.checkState();
        });
      }
    },
    // 鹿
    lu: {
      live: 15,
      condition() {
        return Utils_Favor.kanaFavor >= 100;
      },
      resolve() {
        Utils_Actor.san -= 2;
        SpineManager.setMotion(this.spineInteract, `lu_1_03`, true, 2);
        $gameTemp.execCommonEvent(69, () => {
          this.checkState();
          startTalk([ { text: '看着满身精液的加奈，今天就先这样好了…', name: '\\N[1]', face: '' } ], [], () => {
            $gameData.isEventBusy = false;
            Utils_Scene.changeScene({ sceneName: 'scene_bedroom' });
          });
        });
      },
      reject() {
        $gameTemp.execCommonEvent(70, () => {
          this.checkState();
        });
      }
    },
    // 揉胸
    rounai: {
      live: 15,
      visible() {
        return ['half', 'off'].includes(this._clothName);
      },
      condition() {
        return Utils_Favor.kanaFavor >= 50;
      },
      resolve() {
        Utils_Actor.san -= 1;
        Utils_Favor.kanaSex += 2;
        Utils_Favor.addKanaSexCount('chest', 1);
        if (this._clothName === 'half') {
          SpineManager.setMotion(this.spineInteract, `rounai_02`, false, 2);
          $gameTemp.execCommonEvent(75, () => {
            this.checkState();
          });
        } else {
          SpineManager.setMotion(this.spineInteract, `rounai_03`, false, 2);
          $gameTemp.execCommonEvent(77, () => {
            this.checkState();
          });
        }
      },
      reject() {
        if (this._clothName === 'half') {
          $gameTemp.execCommonEvent(76, () => {
            this.checkState();
          });
        } else {
          $gameTemp.execCommonEvent(78, () => {
            this.checkState();
          });
        }
      }
    },
    // 乳交
    rujiao: {
      live: 20,
      condition() {
        return Utils_Favor.kanaFavor >= 150;
      },
      resolve() {
        Utils_Actor.san -= 1;
        Utils_Favor.kanaSex += 3;
        Utils_Favor.addKanaSexCount('chest', 1);
        SpineManager.clearMotion(this.spineInteract, 1);
        SpineManager.setMotion(this.spineInteract, `rujiao_1_03`, true, 2);
        $gameTemp.execCommonEvent(79, () => {
          this.checkState();
          startTalk([ { text: '看着满身精液的加奈，今天就先这样好了…', name: '\\N[1]', face: '' } ], [], () => {
            $gameData.isEventBusy = false;
            Utils_Scene.changeScene({ sceneName: 'scene_bedroom' });
          });
        });
      },
      reject() {
        $gameTemp.execCommonEvent(80);
      }
    },
    // 足交
    zujiao: {
      live: 20,
      visible() {
        return this._clothName === 'foot';
      },
      condition() {
        return Utils_Favor.kanaFavor >= 150;
      },
      resolve() {
        Utils_Actor.san -= 1;
        Utils_Favor.kanaSex += 3;
        SpineManager.clearMotion(this.spineInteract, 1);
        SpineManager.setMotion(this.spineInteract, `zhujiao_1_04`, true, 2);
        $gameTemp.execCommonEvent(81, () => {
          this.checkState();
          SpineManager.setMotion(this.spineInteract, `face_${this.kanaFace}`, true, 1);
        });
      },
      reject() {
        $gameTemp.execCommonEvent(82);
      }
    },
  };

  /** 衣服状态列表 */
  const __clothList = [
    {
      name: 'on',
      title: '校服',
      icon: 'ui/icon/icon_clothes_on',
      iconDisabled: 'ui/icon/money_large',
      resolve() {
        $gameTemp.execCommonEvent(83);
      },
      reject() {}
    }, {
      name: 'half',
      title: '胸部',
      icon: 'ui/icon/icon_clothes_half',
      iconDisabled: 'ui/icon/money_large',
      visible() {
        return Utils_Favor.kanaFavor >= 50;
      },
      resolve() {
        $gameTemp.execCommonEvent(84);
      },
      reject() {
        $gameTemp.execCommonEvent(85);
      }
    }, {
      name: 'off',
      title: '裸体',
      icon: 'ui/icon/icon_clothes_off',
      iconDisabled: 'ui/icon/money_large',
      visible() {
        return Utils_Favor.kanaFavorLevel >= 3;
      },
      resolve() {
        $gameTemp.execCommonEvent(86);
      },
      reject() {
        $gameTemp.execCommonEvent(87);
      }
    }
  ];

  /** 动作菜单列表 */
  const __actionList = [
    {
      name: 'hand',
      icon: 'ui/icon/icon_hand_normal_large',
      iconDisabled: 'ui/icon/icon_hand_disabled_large',
      visible() {
        return true;
      },
      disabled() {
        return false;
      },
      title: '双手',
      tooltip: '',
      actions: [
        {
          name: 'motou',
          x: 211, y: 50, width: 270, height: 70,
          title: '摸头',
          tooltip: '温柔的摸摸妹妹的头吧',
          cursor: 'hand1',
        }, {
          name: 'motui',
          x: 305, y: 542, width: 300, height: 120,
          title: '摸腿',
          tooltip: '好好的感受妹妹腿的柔软吧',
          cursor: 'hand1',
        }, {
          name: 'rounai',
          visible() {
            return ['half', 'off'].includes(this._clothName);
          },
          x: 304, y: 340, width: 190, height: 120,
          title: '揉胸',
          tooltip: '就算会害羞也请好好摸摸吧',
          cursor: 'hand1',
        }, {
          name: 'jiurutou',
          visible() {
            return ['off'].includes(this._clothName);
          },
          x: 497, y: 354, width: 40, height: 60,
          title: '揪乳头',
          tooltip: '咦！等等，这里不可以…',
          cursor: 'hand2',
        }
      ]
    }, {
      name: 'tongue',
      icon: 'ui/icon/icon_mouth_normal_large',
      iconDisabled: 'ui/icon/icon_mouth_disabled_large',
      visible() {
        return Utils_Favor.kanaFavorLevel >= 2 && Utils_Actor.san <= 85 && this._clothName === 'off';
      },
      disabled() {
        return false;
      },
      cursor: 'cursor_tongue',
      title: '舌头',
      tooltip: '',
      actions: [
        {
          name: 'tianru',
          visible() {
            return this._clothName === 'off';
          },
          x: 304, y: 340, width: 200, height: 120,
          title: '舔乳头',
          tooltip: '就好好舔妹妹柔软的胸部吧',
          cursor: 'tongue',
          // disabled() {
          //   return true;
          // },
          favor: 0,
        }
      ]
    }, {
      name: 'dick',
      icon: 'ui/icon/icon_dick_normal_large',
      iconDisabled: 'ui/icon/icon_dick_disabled_large',
      visible() {
        return Utils_Favor.kanaFavorLevel >= 3 && Utils_Actor.san <= 70 && this._clothName === 'off';
      },
      disabled() {
        return true;
      },
      cursor: 'cursor_dick',
      title: '肉棒',
      tooltip: '',
      actions: [
        {
          name: 'lu',
          visible() {
            return this._clothName === 'off';
          },
          x: 605, y: 600, width: 300, height: 300,
          title: '撸一发',
          tooltip: '对着妹妹射一发…没关系吗？',
          cursor: 'dick',
          // disabled() {
          //   return true;
          // },
          favor: 0,
        }, {
          name: 'rujiao',
          visible() {
            return this._clothName === 'off';
          },
          x: 304, y: 340, width: 200, height: 120,
          title: '乳交',
          tooltip: '用肉棒好好感受妹妹最温柔的部位吧…',
          cursor: 'dick',
          // disabled() {
          //   return true;
          // },
          favor: 0,
        }
      ]
    }
  ];

  /** 男主行为菜单 */
  const __actorMenus = [
    {
      name: '离开',
      text: '离开',
      icon: 'icon_goout',
      onTap() {
        Utils_Scene.changeScene({ sceneName: 'scene_bedroom' });
      }
    }
  ];

  /**
   * 加奈交互场景
   */
  class Hakubox_Scene_Interact extends Scene_MainScene {
    initialize() {
      super.initialize();

      this._useFoot = false;
      this._cameraName = 'top';
      /** 上一次衣服的状态 */
      this._prevClothState = '';
      /** 当前衣服的状态 @type { 'on'|'half'|'off' } */
      this._clothName = '';
      this.cameras = {
        // 上半身
        top: { x: 750, y: 910, scale: 0.84 },
        // 下半身（足）
        down: { x: 720, y: 810, scale: 0.76 },
      };
      this._actionName = '';
      /** 子动作列表 */
      this.subActions = [];
      /** 当前播放动画 */
      this._currentAnime = '';

      this._isAnger = false;

      // 禁用菜单
      $gameSystem._menuEnabled = false;
    }

    /**
     * 加奈是否生气
     */
    get isAnger() {
      return this._isAnger;
    }
    set isAnger(value) {
      if (value !== this._isAnger) {
        this._isAnger = value;
        SpineManager.setMotion(this.spineInteract, `face_${this.kanaFace}`, true, 1);
      }
    }

    /**
     * 获得加奈的当前表情
     */
    get kanaFace() {
      if (this.isAnger) {
        return 'xianqi';
      } else {
        if (Utils_Favor.kanaMood === 'happy') {
          return 'kaixin';
        } else if (Utils_Favor.kanaMood === 'sad') {
          return 'xianqi';
        } else {
          switch (Utils_Favor.kanaFavorLevel) {
            case 1: return 'xianqi';
            case 2: return 'putong';
            case 3: return 'lianhong';
          }
        }
      }
    }

    create() {
      this.clothList = __clothList;
      this.actionList = __actionList;
      this.setAction('hand');

      super.create();

      /** 是否播放中 */
      this._isPlaying = false;
      /** 是否允许到下一步 */
      this._canNext = false;
      this.blackMask.opacity = 255;
      this.visibleMoney = false;

      // 隐藏菜单
      this.menuContainer.alpha = 0;
      this.menuContainer.visible = false;
      // 禁用菜单
      $gameSystem._menuEnabled = false;
    }

    update() {
      super.update();

      if (this._isPlaying) {
        if (this._canNext && TouchInput.isTriggered()) {
          this._isPlaying = false;
        }
      } else {
        this.updateActionList();
      }
    }

    /** 查看状态 */
    checkState() {
      $gameData.isEventBusy = false;

      // 晚上超过22点自动去睡觉
      if (Utils_Time.hour >= 22) {
        startTalk([ { text: '好了我也该睡觉去了……', name: '加奈', face: '' } ], [], () => {
          Utils_Scene.changeScene({ sceneName: 'scene_bedroom', isFadeout: false, callback() {
            this.hideTachie();
            Utils_Time.timeElapseTo(8, 0, { isSleep: true, mask: true, addLive: true, delay: 5 });
          } });
        });
      }
    }
    
    showGameUI() {
      if ($gameData.isEventBusy) return;

      super.showGameUI();
      if (this._clothListContainer) this._clothListContainer.alpha = 1;
      if (this._actionListContainer) this._actionListContainer.alpha = 1;
    }
    
    hideGameUI() {
      super.hideGameUI();
      if (this._clothListContainer) this._clothListContainer.alpha = 0;
      if (this._actionListContainer) this._actionListContainer.alpha = 0;
    }

    /** 获取默认的动画 */
    setDefaultAnime() {
      this._currentAnime = '';
    }

    /** 更新行为列表 */
    updateActionList() {
      if (!this._actionListContainer || $gameData.isEventBusy) return;

      const _mouseX = TouchInput.x;
      const _mouseY = TouchInput.y;
      let _hoverButton = false;
      let _activeAction = '';

      // 判断子动作列表
      const _actions = this.subActions.filter(i => i.visible !== false);
      for (let i = 0; i < _actions.length; i++) {
        const item = _actions[i];
        
        if (this._currentAnime === item.name) continue;
        if (item.visible && item.visible.call(this) === false) continue;

        // 光标进入范围内
        if (this.inArea(item, _mouseX, _mouseY)) {
          // 点击
          if (TouchInput.isTriggered()) {
            _activeAction = item.name;
            // 禁用状态
            if (item.disabled === true) {
              SoundManager.playBuzzer();
              continue;
            } else {
              if (!_hoverButton) this.setTooltip();
              SoundManager.playOk();
              // 将动作设置为当前item
              this.setAnime(item);
            }
          }
          if (item.disabled !== true) {
            if (!item.isHover) {
              Utils_Cursor.cursorType = item.cursor || 'pointer';
              if (item.tooltip) {
                this.setTooltip(item.tooltip);
              }
              _hoverButton = true;
              SoundManager.playCursor();
            }
            item.isHover = true;
          } else {
            Utils_Cursor.cursorType = 'disabled';
          }
        } else {
          if (item.isHover) {
            Utils_Cursor.cursorType = 'default';
            if (!_hoverButton) this.setTooltip();
            item.isHover = false;
          }
        }
      }

      if (TouchInput.isTriggered() && !_activeAction && !this._currentAnime) {
        this.setAnime();
      }
    }

    callMenu() {}

    /** 设置行为 */
    setAction(itemName) {
      if (this._actionName === itemName) return;

      const _item = this.actionList.find(i => i.name === itemName);

      this._actionName = _item.name;
      this.subActions = cloneLoop(_item.actions);
    }

    /** 设置动画 */
    setAnime(animeItem) {
      const animeName = animeItem ? animeItem.name : '';
      if (this._currentAnime === animeName) return;
      if (animeName) {
        const _anime = __animeList[animeName];

        if (!['motou', 'motui'].includes(animeName)) {
          const _index = Math.randomInt(9) + 1;
          AudioManager.playCv(`fragment/kana-groan-fragment-${_index}`, { volume: 0.8 });
        }

        if (_anime.maxCountInDay && Utils_Favor.interactCount(animeName) > _anime.maxCountInDay) {
          $gameData.isEventBusy = true;
          _anime.exceedCount.call(this);
          useTimeout(() => {
            animeItem.isHover = false;
            Utils_Cursor.cursorType = 'default';
          }, 10);
        } else if (!_anime.condition || _anime.condition && _anime.condition.call(this) !== false) {

          if (_anime.live && _anime.live > Utils_Actor.live) {
            useAlert({ text: `体力值不足` });
            SoundManager.playBuzzer();
            return;
          } else {
            Utils_Actor.live -= 10;
          }
          this._isPlaying = true;
          this._currentAnime = animeName;
          $gameData.isEventBusy = true;
          SpineManager.setMotion(this.spineInteract, this._clothName === 'off' ? `idle_03` : `idle_xx`, true, 0);
          _anime.resolve.call(this);
          useTimeout(() => {
            animeItem.isHover = false;
            Utils_Cursor.cursorType = 'default';
          }, 10);
        } else if (_anime.reject) {
          $gameData.isEventBusy = true;
          _anime.reject.call(this);
          useTimeout(() => {
            animeItem.isHover = false;
            Utils_Cursor.cursorType = 'default';
          }, 10);
        }
      } else if (this._currentAnime !== '') {
        this._currentAnime = '';
        // SpineManager.setMotion(this.spineInteract, `idle_${Utils_Favor.kanaFavorLevel + 1}_xx`, true, 0);
      }
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      /** 男主行为菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.actorMenus = __actorMenus;
    }

    /**
     * 修改状态
     * @param {'on'|'half'|'foot'} clothState 衣服状态
     */
    changeState(clothState) {
      // 是否修改了足交状态
      let _changeFootState = false;
      const useFoot = clothState === 'foot';
      if (useFoot === true && this._useFoot !== useFoot) {
        this._useFoot = true;
        _changeFootState = true;
        this.setCamera('down');
        this.setCloth('foot');
      } else if (useFoot === false && this._useFoot !== useFoot) {
        this._useFoot = false;
        _changeFootState = true;
        this.setCamera('top');
        if (!this._clothName) {
          this.setCloth(this._prevClothState);
        }
      }

      // 如果修改了足交状态
      if (_changeFootState) {
        // 如果修改了衣服的状态
        if (clothState !== undefined && this._clothName !== clothState) {
          this._prevClothState = clothState;
          this.setCloth(clothState);
        }
      }
    }

    /**
     * 设置衣服
     * @param {'on'|'half'|'off'|'foot'} clothState 衣服状态
     */
    setCloth(clothState) {
      if (this._clothName !== clothState) {
        this.setDefaultAnime();
        this._clothName = clothState;
        if (this._clothName === 'on') {
          SpineManager.changeSkin(this.spineInteract, ['01']);
        } else if (this._clothName === 'half') {
          SpineManager.changeSkin(this.spineInteract, ['02']);
        } else if (this._clothName === 'off') {
          SpineManager.changeSkin(this.spineInteract, ['03']);
        }
      }
    }

    /**
     * 设置相机位
     * @param {'top'|'down'} name 相机名称
     */
    setCamera(name) {
      if (!his.cameras[name]) throw new Error(`未知相机名称：${name}`);

      this._cameraName = name;
      if (this.spineInteract) {
        const _camera = this.cameras[name];
        const spine = this.spineInteract;
        spine.position.set(_camera.x, _camera.y);
        spine.scale.set(_camera.scale, _camera.scale);
      }
    }

    /** 创建界面 */
    createViewer() {
      super.createViewer();
      
      if (Utils_Scene.sameOne()) {
        // 2. 创建立绘
        this.createGameTachie();
      }
      // 创建右侧的动作选项UI
      this.createActionUI();

      Utils_Course.showCourse('interact');
    }

    /** 创建右侧的衣服选项UI */
    createClothUI() {
      if (!this._clothListContainer) {
        this._clothListContainer = new HakuContainer();
      }

      const _clothMenus = this.clothList.filter(i => !i.visible || i.visible.call(this) !== false);

      if (_clothMenus.length <= 1) {
        this._clothListContainer.visible = false;
      }

      const _normal_bg = `ui/interact/interact_item_bg`;
      const _hover_bg = `ui/interact/interact_item_bg_hover`;
      const _active_bg = `ui/interact/interact_item_bg_active`;

      for (let i = 0; i < _clothMenus.length; i++) {
        const _item = _clothMenus[i];

        _item.container = new HakuContainer({
          useHover: true, x: Graphics.width - 160, y: 200 + i * 65, me: this,
          disabled() { return _item.disabled === true; },
          onHover() {
            if (_item.name !== this.me._clothName) {
              _item.spriteBg.bitmap = ImageManager.loadPicture(_hover_bg);
            }
            if (_item.tooltip) this.me.setTooltip(_item.tooltip);
          },
          onBlur() {
            this.me.setTooltip();
            if (this.me._clothName === _item.name) {
              _item.spriteBg.bitmap = ImageManager.loadPicture(_active_bg);
            } else {
              _item.spriteBg.bitmap = ImageManager.loadPicture(_normal_bg);
            }
          },
          onTap() {
            this.me.setTooltip();
            if (_item.condition && _item.condition.call(this.me) === false) {
              _item.reject.call(this.me);
            } else {
              _item.spriteBg.bitmap = ImageManager.loadPicture(`ui/interact/interact_item_bg_active`);
              // 还原旧的背景
              const _oldItem = _clothMenus.find(i => i.name === this.me._clothName);
              if (_oldItem && _item.name !== _oldItem.name) {
                _oldItem.spriteBg.bitmap = ImageManager.loadPicture(`ui/interact/interact_item_bg`);
              }
              // 将动作设置为当前item
              this.me.setCloth(_item.name);
              this.me.createActionUI();
              _item.resolve.call(this.me);
            }
          }
        });

        // 创建背景
        let _imgPath = '';
        if (_item.name === this._clothName) {
          _imgPath = _active_bg;
        } else {
          _imgPath = _normal_bg;
        }
        const _bgSprite = new Sprite(ImageManager.loadPicture(_imgPath));
        _bgSprite.x = 0;
        _bgSprite.y = 0;
        _item.spriteBg = _bgSprite;
        _item.container.addChild(_bgSprite);

        // 创建图标
        const _iconSprite = new Sprite(ImageManager.loadPicture(_item.icon));
        _iconSprite.x = -5;
        _iconSprite.y = -5;
        _item.spriteIcon = _iconSprite;
        _item.container.addChild(_iconSprite);

        // 创建文字
        const _textSprite = new Sprite(new Bitmap(120, 50));
        _textSprite.x = 60;
        _textSprite.y = 2;
        _textSprite.bitmap.fontFace = 'Source Han Sans VF';
        _textSprite.bitmap.fontSize = 18;
        _textSprite.bitmap.textColor = '#c4541c';
        _textSprite.bitmap.outlineWidth = 4;
        _textSprite.bitmap.outlineColor = '#FFFFFF';
        _textSprite.bitmap.drawText(_item.title, 0, 0, 120, 50, 'left');
        _item.spriteText = _textSprite;
        _item.container.addChild(_textSprite);

        this._clothListContainer.addChild(_item.container);
      }

      this.backUIContainer.addChild(this._clothListContainer);
    }

    /** 创建右侧的动作选项UI */
    createActionUI() {
      if (!this._actionListContainer) {
        this._actionListContainer = new HakuContainer();
        this.backUIContainer.addChild(this._actionListContainer);
      } else {
        this._actionListContainer.removeChildren();
      }

      const _actionMenus = this.actionList.filter(i => i.visible.call(this) !== false);

      const _normal_bg = `ui/interact/interact_item_bg`;
      const _hover_bg = `ui/interact/interact_item_bg_hover`;
      const _active_bg = `ui/interact/interact_item_bg_active`;

      for (let i = 0; i < _actionMenus.length; i++) {
        const _item = _actionMenus[i];
        
        _item.container = new HakuContainer({
          useHover: true, x: Graphics.width - 160, y: 440 + i * 65, me: this,
          disabled() { return _item.disabled === true; },
          onHover() {
            if (_item.name !== this.me._actionName) {
              _item.spriteBg.bitmap = ImageManager.loadPicture(_hover_bg);
            }
            if (_item.tooltip) {
              this.me.setTooltip(_item.tooltip);
            }
          },
          onBlur() {
            this.me.setTooltip();
            if (this.me._actionName === _item.name) {
              _item.spriteBg.bitmap = ImageManager.loadPicture(_active_bg);
            } else {
              _item.spriteBg.bitmap = ImageManager.loadPicture(_normal_bg);
            }
          },
          onTap() {
            _item.spriteBg.bitmap = ImageManager.loadPicture(_active_bg);
            // 还原旧的背景
            const _oldItem = _actionMenus.find(i => i.name === this.me._actionName);
            if (_oldItem && _item.name !== _oldItem.name) {
              _oldItem.spriteBg.bitmap = ImageManager.loadPicture(_normal_bg);
            }
            // 将动作设置为当前item
            this.me.setAction(_item.name);
          }
        });

        // 创建背景
        let _imgPath = '';
        if (_item.name === this._actionName) {
          _imgPath = `ui/interact/interact_item_bg_active`;
        } else {
          _imgPath = `ui/interact/interact_item_bg`;
        }
        const _bgSprite = new Sprite(ImageManager.loadPicture(_imgPath));
        _bgSprite.x = 0;
        _bgSprite.y = 0;
        _item.spriteBg = _bgSprite;
        _item.container.addChild(_bgSprite);

        // 创建图标
        const _iconSprite = new Sprite(ImageManager.loadPicture(_item.icon));
        _iconSprite.x = -5;
        _iconSprite.y = -5;
        _item.spriteIcon = _iconSprite;
        _item.container.addChild(_iconSprite);

        // 创建文字
        const _textSprite = new Sprite(new Bitmap(120, 50));
        _textSprite.x = 60;
        _textSprite.y = 2;
        _textSprite.bitmap.fontFace = 'Source Han Sans VF';
        _textSprite.bitmap.fontSize = 18;
        _textSprite.bitmap.textColor = '#c4541c';
        _textSprite.bitmap.outlineWidth = 4;
        _textSprite.bitmap.outlineColor = '#FFFFFF';
        _textSprite.bitmap.drawText(_item.title, 0, 0, 120, 50, 'left');
        _item.spriteText = _textSprite;
        _item.container.addChild(_textSprite);

        this._actionListContainer.addChild(_item.container);
      }
    }

    // #region 绘制动画部分
    /** 绘制动画 */
    createGameTachie() {
      const source = SpineManager.preloadSpine("kanaInteract");
      const _camera = this.cameras[this._cameraName];
      source.addListener(source => {
        const { spine } = SpineManager.createSpine(source);
        spine.visible = true;
        spine.position.set(_camera.x, _camera.y);
        spine.scale.set(_camera.scale, _camera.scale);
        spine.state.addListener({
          complete: (track, _event) => {
            // 如果轨道存在
            if (track !== void 0) {
              // 轨道不循环的情况下，根据轨道当前的动作名 进行判断，后面要播放什么动作
              if (!track.loop && track.isComplete() && !track.next) {
                if (!track.animation.name.startsWith("idle_") && track.trackIndex === 0) {
                  SpineManager.setMotion(this.spineInteract, this._clothName === 'off' ? `idle_03` : `idle_xx`, true, 0);
                } else if (!['lu_3_03','rujiao_2_03','zhujiao_3_04'].includes(track.animation.name)) {
                  SpineManager.clearMotion(this.spineInteract, track.trackIndex);
                }
              }
            }
          }
        });
        this.backUIContainer.addChildAt(spine, 1);
        this.spineInteract = spine;
        SpineManager.setMotion(this.spineInteract, this._clothName === 'off' ? `idle_03` : `idle_xx`, true, 0);
        SpineManager.setMotion(this.spineInteract, `face_${this.kanaFace}`, true, 1);

        this.setCloth('on');
        // 创建右侧的衣服选项UI
        this.createClothUI();
      });
    }
    // #endregion
  }
  window.Hakubox_Scene_Interact = Hakubox_Scene_Interact;
})();