//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_Item.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 道具栏场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /**
   * 道具栏场景
   */
  class Scene_Haku_Item extends Scene_Game {
    initialize() {
      super.initialize();

      this._disabledFade = true;

      this.pageIndex = 0;
      this.maxPageIndex = 2;

      this.pageWidth = 980;
      this.pageHeight = 460;

      this.animeType = 'in';

      this.animeInOutInfo = useAnime({
        frameDelay: 0,
        frameCount: 15,
        easingType: 'Quadratic',
        inout: 'InOut',
      }, progress => {
        const _baseY = (Graphics.height - 460) / 2;
        if (this.animeType === 'in') {
          this._itemWindow.alpha = progress;
          this._itemWindow.y = parseInt(_baseY - 20 + progress * 20);
        } else if (this.animeType === 'out') {
          this._itemWindow.alpha = 1 - progress;
          this._itemWindow.y = parseInt(_baseY - progress * 20);
          if (progress >= 1) {
            $gameSystem.enableMenu();
            SceneManager.pop();
          }
        }
      });
    }

    create() {
      $gameSystem.disableMenu();
      super.create();
      this.createBackground();
      this.createItemWindow();
    }

    update() {
      super.update();

      this.animeInOutInfo.update();

      if (TouchInput.isCancelled() || Input.isTriggered('cancel')) {
        SoundManager.playCancel();
        this.animeInOutInfo.start();
        this.animeType = 'out';
      }
    }

    setBackgroundOpacity(opacity) {
      this._backgroundSprite.opacity = opacity;
    }

    /** 透明背景 */
    createBackground() {
      // this._backgroundFilter = new PIXI.filters.BlurFilter();
      this._backgroundSprite = new Sprite();
      this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
      this._backgroundSprite.filters = []; // this._backgroundFilter
      this.addChildAt(this._backgroundSprite, 0);
      this.setBackgroundOpacity(192);
    }

    /** 获取道具窗口的矩形 */
    itemWindowRect() {
      const wx = (Graphics.width - this.pageWidth) / 2 - 50;
      const wy = (Graphics.height - this.pageHeight) / 2;
      const ww = this.pageWidth;
      const wh = this.pageHeight;
      return new Rectangle(wx, wy, ww, wh);
    }

    /** 创建道具页面 */
    createItemWindow() {
      const rect = this.itemWindowRect();
      this._itemWindow = new Window_Haku_Item(rect);
      this._itemWindow.alpha = 0;
      this.addChild(this._itemWindow);
      this.animeInOutInfo.start();
    }
  }
  window.Scene_Haku_Item = Scene_Haku_Item;

  /** 道具栏页面 */
  class Window_Haku_Item extends Window_Base {
    initialize(rect) {
      super.initialize(rect);
      this.openness = 0;
      this.opacity = 1;

      this._pageIndex = 0;
      this._index = 0;

      this.windowContainer = new PIXI.Container();
      this.addChild(this.windowContainer);

      this.itemsContainer = new PIXI.Container();
      this.addChild(this.itemsContainer);

      // $gameParty.gainItem($dataItems[1], 1);
      // $gameParty.gainItem($dataItems[2], 3);
      // $gameParty.gainItem($dataItems[3], 3);
      // $gameParty.gainItem($dataItems[4], 3);
      // $gameParty.gainItem($dataItems[5], 3);
      // $gameParty.gainItem($dataItems[6], 3);
      // $gameParty.gainItem($dataItems[7], 3);
      // $gameParty.gainItem($dataItems[8], 3);
      // $gameParty.gainItem($dataItems[9], 3);
      // $gameParty.gainItem($dataItems[10], 3);
      // $gameParty.gainItem($dataItems[11], 3);
      // $gameParty.gainItem($dataItems[12], 3);
      // $gameParty.gainItem($dataItems[13], 3);
      // $gameParty.gainItem($dataItems[14], 3);
      // $gameParty.gainItem($dataItems[15], 3);
      // $gameParty.gainItem($dataItems[16], 3);
      // $gameParty.gainItem($dataItems[17], 3);
      // $gameParty.gainItem($dataItems[18], 3);
      // $gameParty.gainItem($dataItems[19], 3);
      // $gameParty.gainItem($dataItems[20], 3);
      // $gameParty.gainItem($dataItems[21], 3);
      // $gameParty.gainItem($dataItems[22], 3);
      // $gameParty.gainItem($dataItems[23], 3);
      // $gameParty.gainItem($dataItems[24], 3);
      // $gameParty.gainItem($dataItems[25], 3);
      // $gameParty.gainItem($dataItems[26], 3);
      // $gameParty.gainItem($dataItems[27], 3);

      this.items = cloneLoop($gameParty.items());

      this.createBackground();
      this.createItemTooltip();
      this.createItemList();
      this.createItemPageTurn();
      this.createCloseButton();
      
      this.pageIndex = 0;
    }

    /** 当前道具索引 @type {number} */
    get itemIndex() {
      return this._itemIndex;
    }
    set itemIndex(itemIndex) {
      this._itemIndex = itemIndex;
    }

    /** 当前页面索引 @type {number} */
    get pageIndex() {
      return this._pageIndex;
    }
    set pageIndex(pageIndex = 0) {
      if (this._pageIndex !== pageIndex) {
        SoundManager.playOk();
        this._pageIndex = pageIndex;
        this.createItemList();
      }
    }

    /**
     * 是否为第一页
     * @param {number} pageIndex
     * @return {boolean}
     */
    isFirstPage(pageIndex) {
      return pageIndex === 0;
    }
    /**
     * 是否为最后一页
     * @param {number} pageIndex
     * @return {boolean}
     */
    isLastPage(pageIndex) {
      if ($gameParty.items() <= 10) return true;
      return pageIndex === Math.ceil($gameParty.items().length / 10) - 1;
    }

    /** 创建背景 */
    createBackground() {
      this._bgSprite = new Sprite(ImageManager.loadPicture('ui/item/item_panel'));
      this._bgSprite.x = 0;
      this._bgSprite.y = 0;
      this.windowContainer.addChild(this._bgSprite);

      this._emptySprite = new Sprite(ImageManager.loadPicture('ui/item/item_empty'));
      this._emptySprite.x = this.width / 2 - 760 / 2;
      this._emptySprite.y = 140;
      this.windowContainer.addChild(this._emptySprite);
    }

    /** 创建物品提示 */
    createItemTooltip() {
      this._tooltipSprite = new Sprite(ImageManager.loadPicture('ui/item/item_desc'));
      this._tooltipSprite.x = this.width / 2 - 778 / 2;
      this._tooltipSprite.y = 30;
      this.windowContainer.addChild(this._tooltipSprite);

      // 提示Bitmap
      this._tooltipBitmap = new Bitmap(778, Graphics.height);
      this._tooltipBitmap.smooth = false;
      this._tooltipBitmap.fontSize = 20;
      this._tooltipBitmap.textColor = '#665258';
      this._tooltipBitmap.outlineWidth = 4;
      this._tooltipBitmap.outlineColor = 'white';
      this._textSprite = new Sprite(this._tooltipBitmap);
      this._textSprite.x = this.width / 2 - 778 / 2 + 15;
      this._textSprite.y = 35;
      this.windowContainer.addChild(this._textSprite);
    }

    /** 翻页按钮 */
    createItemPageTurn() {
      // 左翻页按钮
      this._arrowLeftSprite = new Sprite(ImageManager.loadPicture('ui/item/item_arrow_left'));
      this._arrowLeftSprite.x = 20;
      this._arrowLeftSprite.y = 205;
      this.windowContainer.addChild(this._arrowLeftSprite);

      // 右翻页按钮
      this._arrowRightSprite = new Sprite(ImageManager.loadPicture('ui/item/item_arrow_right'));
      this._arrowRightSprite.x = this.width - 88;
      this._arrowRightSprite.y = 205;
      this.windowContainer.addChild(this._arrowRightSprite);
    }

    /** 创建关闭按钮 */
    createCloseButton() {
      this._btnCloseSprite = new Sprite(ImageManager.loadPicture('ui/item/item_close'));
      this._btnCloseSprite.x = this.width - 40;
      this._btnCloseSprite.y = -20;
      this.windowContainer.addChild(this._btnCloseSprite);
    }

    /** 创建物品列表 */
    createItemList() {
      this.itemsContainer.removeChildren();
      const _items = $gameParty.items().filter(item => ![35].includes(item.id));
      for (let i = 0; i < 5; i++) {
        for (let o = 0; o < 2; o++) {
          const _index = this.pageIndex * 10 + o * 5 + i;
          const _item = _items[_index];
          
          if (_item) {

            // 物品框
            const _itemBorderSprite = new Sprite(ImageManager.loadPicture(`ui/item/item_cell`));
            _itemBorderSprite.x = this.width / 2 - 778 / 2 + 9 + i * 158;
            _itemBorderSprite.y = 140 + o * 145;
            this.items[_index].borderSprite = _itemBorderSprite;
            this.itemsContainer.addChild(_itemBorderSprite);

            // 物品图片
            const _itemSprite = new Sprite(ImageManager.loadPicture(`items/` + _item.id));
            _itemSprite.x = this.width / 2 - 778 / 2 + 22 + i * 158;
            _itemSprite.y = 150 + o * 145;
            this.itemsContainer.addChild(_itemSprite);

            // 物品名称
            const _itemTextSprite = new Sprite(new Bitmap(120, 30));
            _itemTextSprite.bitmap.fontSize = 18;
            _itemTextSprite.bitmap.textColor = '#665258';
            _itemTextSprite.bitmap.outlineWidth = 4;
            _itemTextSprite.bitmap.outlineColor = 'white';
            _itemTextSprite.x = this.width / 2 - 778 / 2 + 22 + i * 158;
            _itemTextSprite.y = 230 + o * 145;
            _itemTextSprite.bitmap.drawText(_item.name, 0, 0, 104, 40, 'center')
            this.itemsContainer.addChild(_itemTextSprite);

            // 物品数量
            const _itemCountSprite = new Sprite(new Bitmap(120, 30));
            _itemCountSprite.bitmap.fontSize = 18;
            _itemCountSprite.bitmap.textColor = '#665258';
            _itemCountSprite.bitmap.outlineWidth = 4;
            _itemCountSprite.bitmap.outlineColor = 'white';
            _itemCountSprite.x = this.width / 2 - 778 / 2 + 85 + i * 158;
            _itemCountSprite.y = 145 + o * 145;
            _itemCountSprite.bitmap.drawText(`×${$gameParty._items[_item.id]}`, 0, 0, 50, 40, 'center')
            this.itemsContainer.addChild(_itemCountSprite);
          }
        }
      }
    }

    /** 设置物品文本提示 */
    setTooltip(text) {
      this._tooltipBitmap.clear();
      if (text) {
        text.split('\n').forEach((line, index) => {
          this._tooltipBitmap.drawText(line, 5, index * 30, 750, 48, 'left');
        });
      }
    }

    update() {
      super.update();
      const _x = TouchInput.x;
      const _y = TouchInput.y;

      // #region 左右翻页按钮
      let _isCanLeft = false;
      let _isCanRight = false;
      const _isInAreaLeft = this.inArea(this._arrowLeftSprite, _x, _y, this.x, this.y);
      const _isInAreaRight = this.inArea(this._arrowRightSprite, _x, _y, this.x, this.y);

      if (!this.isFirstPage(this.pageIndex)) {
        if (_isInAreaLeft) {
          this._arrowLeftSprite.changePic('ui/item/item_arrow_left_active');
          _isCanLeft = true;
        } else {
          this._arrowLeftSprite.changePic('ui/item/item_arrow_left');
        }
      } else {
        this._arrowLeftSprite.changePic('ui/item/item_arrow_left_disabled');
      }

      if (!this.isLastPage(this.pageIndex)) {
        if (_isInAreaRight) {
          this._arrowRightSprite.changePic('ui/item/item_arrow_right_active');
          _isCanRight = true;
        } else {
          this._arrowRightSprite.changePic('ui/item/item_arrow_right');
        }
      } else {
        this._arrowRightSprite.changePic('ui/item/item_arrow_right_disabled');
      }
      
      if (TouchInput.isTriggered()) {
        if (_isInAreaLeft) {
          if (_isCanLeft) {
            this.pageIndex--;
            SoundManager.playOk();
          } else {
            SoundManager.playBuzzer();
          }
        }
        if (_isInAreaRight) {
          if (_isCanRight) {
            this.pageIndex++;
            SoundManager.playOk();
          } else {
            SoundManager.playBuzzer();
          }
        }
      }
      // #endregion


      // #region 右上角关闭按钮
      if (this._btnCloseSprite.inArea(_x, _y, this.x, this.y)) {
        this._btnCloseSprite.changePic('ui/item/item_close_active');
        if (TouchInput.isTriggered()) {
          SoundManager.playCancel();
          SceneManager._scene.animeInOutInfo.start();
          SceneManager._scene.animeType = 'out';
        }
      } else {
        this._btnCloseSprite.changePic('ui/item/item_close');
      }
      // #endregion


      // #region 物品框点击
      const _itemIndexes = this.items.slice(this.pageIndex * 10, (this.pageIndex + 1) * 10);
      let _showTxt = false;
      
      for (let i = 0; i < _itemIndexes.length; i++) {
        const item = _itemIndexes[i];
        const _index = this.pageIndex * 10 + i;
        if (!this.items[_index].borderSprite) continue;
        // 光标进入范围内
        if (this.items[_index].borderSprite.inArea(_x, _y, this.x, this.y)) {
          // 点击
          if (TouchInput.isTriggered()) {
            if (!_showTxt) this.setTooltip();
            SoundManager.playOk();
            const _item = Utils_Item.items.find(i => i.id === item.id);
            if (_item.useCondition() === false) {
              useAlert({ text: '道具目前无法使用' });
              return;
            }
            // 消耗道具
            // $gameParty.loseItem($dataItems[item.id], 1);
            // 退出当前场景后完成事件
            SceneManager.back(() => {
              const _scene = SceneManager._scene;
              if (_scene instanceof Scene_Home && Utils_Scene.sameKana()) {
                // _scene.changeSisterLoc('stand');
                _scene._miniTachieContainer.alpha = 0;
                _scene.hideTachie();
              }
              if (_item && _item.useEvent) {
                $gameData.isEventBusy = true;
                $gameTemp.execCommonEvent(_item.useEvent, () => {
                  // 事件完成后恢复事件状态
                  $gameData.isEventBusy = false;
                  if (_scene instanceof Scene_Home && Utils_Scene.sameKana()) {
                    _scene.checkSisterState();
                    // Utils_Tachie.changeFace('13', null, 'kana');
                    _scene.randomSisterLoc();
                  }
                });
              }
            });
          }
          if (!item.isHover) {
            this.items[_index].borderSprite.changePic(`ui/item/item_cell_active`);
            if ($dataItems[item.id].description) {
              this.setTooltip($dataItems[item.id].description);
              _showTxt = true;
            }
            SoundManager.playCursor();
          }
          item.isHover = true;
        } else {
          if (item.isHover) {
            if (!_showTxt) this.setTooltip();
            item.isHover = false;
            this.items[_index].borderSprite.changePic(`ui/item/item_cell`);
          }
        }
      }

      // #endregion
    }

    refresh() {
      super.refresh();
    }
  }
  window.Window_Haku_Item = Window_Haku_Item;

})();