//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_MainScene.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - Main场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 * 
 */
// #endregion
(() => {

  /** 系统菜单 */
  const __sysMenus = [
    {
      text: '状态',
      icon: 'icon_status',
      tooltip: '关心一下妹妹的情况，了解她的一切吧～',
      onTap() {
        SceneManager.push(Scene_Haku_State);
      }
    }, {
      text: '设置',
      icon: 'icon_config',
      tooltip: '来看一下额外的设置吧~',
      // get disabled() { return true; },
      onTap() {
        SceneManager.push(Scene_Haku_Extras_Switch);
      }
    }, {
      text: '菜单',
      icon: 'icon_menu',
      tooltip: '接下来要做些什么呢？',
      onTap() {
        SceneManager._scene.saveTempInfo();
        SceneManager.push(Scene_Haku_SysMenu);
      }
    }
  ];

  /** 男主行为菜单 */
  const __actorMenus = [];


  /** 金钱变化修改 */
  const Game_Party_gainGold = Game_Party.prototype.gainGold;
  Game_Party.prototype.gainGold = function(amount) {
    const _scene = SceneManager._scene;
    const _oldValue = this._gold;
    const _newValue = (this._gold + amount).clamp(0, this.maxGold());
    if (_oldValue === _newValue) return;

    useAnime({
      frameDelay: 0,
      frameCount: 30,
      autoUpdate: true,
      easingType: 'Quadratic',
      inout: 'InOut',
    }, progress => {
      if (!_scene.moneyValueSprite) return;
      const _money = _oldValue + (_newValue - _oldValue) * progress;
      const _moneyText = Math.round(_money);
      _scene.moneyValueSprite.bitmap.clear();
      _scene.moneyValueSprite.bitmap.drawText(_moneyText + '', 2, 0, 200, 36, 'left');

      if (progress >= 1) {
        _scene.moneyValueSprite.bitmap.clear();
        _scene.moneyValueSprite.bitmap.drawText(_newValue + '', 2, 0, 200, 36, 'left');
      }
    });

    if (_scene.moneySprite) {
      createFloatText({
        sprite: _scene.moneySprite,
        x: 210,
        y: _scene.moneySprite.y,
        text: `${_oldValue < _newValue ? '+' : ''}${_newValue - _oldValue}`
      });
    }
    Game_Party_gainGold.call(this, amount);
  };

  // #region 游戏主场景

  /**
   * 游戏主场景
   */
  class Scene_MainScene extends Scene_Game {
    initialize() {
      super.initialize();
      this._touchCount = 0;
      this._disabledFade = true;
      this._prevHoverButton = '';
      this._prevTimeSpan = Utils_Time.timeSpan;
      this._prevFavor = Utils_Favor.kanaFavor;
      /** 当前场景的立绘 */
      this.tachieMap = {};
      /** 当前hover的按钮 */
      this.hoverBtn = '';
      
      // 显示隐藏UI
      /** 动画进行中的UI类型：in/out */
      this.uiAnimeType = 'in';
      /** 动画进行中的UI名称 */
      this.uiAnimeName = '';
      /** 动画进行中的UI索引 */
      this.uiAnimeIndex = 0;
      /** 显示金钱 */
      this._visibleMoney = true; 
    }

    uiAnimeCallback(uiAnimeName, progress) {

    }

    /** 显示金钱 @type {boolean} */
    get visibleMoney() {
      return this._visibleMoney;
    }
    set visibleMoney(value) {
      if (this._visibleMoney !== value) {
        this._visibleMoney = value;
        this.moneyContainer.alpha = value ? 1 : 0;
      }
    }

    createUI() {
      super.createUI();

      this._transfer = $gamePlayer.isTransferring();
      this.createBackground();
      this.createSceneObjects();

      this.refreshData();

      // 获取当前场景
      this.sceneInfo = Utils_Scene.getSceneInfo();
      if (!this.sceneInfo) throw new Error(`场景[${this.currentScene}]不存在`);
      // 绘制界面
      this.createViewer();

      // 切换背景音乐
      if (!SceneManager.isGameScene(SceneManager._previousClass) && $gameSystem._savedBgm) {
        $gameSystem.replayBgm();
      } else if (this.sceneInfo.bgm) {
        AudioManager.playBgm({ name: this.sceneInfo.bgm, volume: 100, pitch: 100, pan: 0 });
      }

      if (!SceneManager.isGameScene(SceneManager._previousClass) && $gameSystem._savedBgs) {
        $gameSystem.replayBgs();
      }

      // 添加角色立绘
      Utils_Tachie.initSceneTachie();
      
      // 修改滤镜
      this.drawFilter();

      this.loadTempInfo();

      useTimeout(() => {

        Utils_Time.timeElapse();
      }, 1);
    }

    /** 刷新数据 */
    refreshData() {
      this.getSysMenus();
      this.getActorMenus();
      this.getSisterMenus();
    }

    /** 读取临时信息 */
    loadTempInfo() {
      
      $gameData.tempSceneInfo.isInit = true;
      
      if ($gameData.tempSceneInfo.sceneName !== this.constructor.name || !$gameData.tempSceneInfo.canUse) return;

      $gameData.tempSceneInfo.canUse = false;

      const _scene = SceneManager._scene;

      // 处理背景和前景
      if ($gameData.tempSceneInfo.background !== this.sceneInfo.background) {
        this.changeBackground.call(_scene, $gameData.tempSceneInfo.background, 0);
      }
      if ($gameData.tempSceneInfo.foreground !== this.sceneInfo.foreground) {
        this.changeForeground.call(_scene, $gameData.tempSceneInfo.foreground, 0);
      }
      // if ($gameData.tempSceneInfo.filter !== this.sceneInfo.filter) {
      //   this.drawFilter.call(_scene, $gameData.tempSceneInfo.filter, 0);
      // }
      
      // 处理BGM
      if ($gameData.tempSceneInfo.bgmName) {
        AudioManager.playBgm({ name: $gameData.tempSceneInfo.bgmName, volume: 100, pitch: 100, pan: 0 }, $gameData.tempSceneInfo.bgmPosition);
      }
      // 处理BGS
      if ($gameData.tempSceneInfo.bgsName) {
        AudioManager.playBgs({ name: $gameData.tempSceneInfo.bgsName, volume: 100, pitch: 100, pan: 0 }, $gameData.tempSceneInfo.bgsPosition);
      }

      // 处理立绘 $gameSystem.hasTachie() && 
      if ($gameData.tempSceneInfo.spineList.length) {
        // TODO: 暂时没处理不同立绘

        // 第一个立绘
        const _spine = $gameData.tempSceneInfo.spineInfos[$gameData.tempSceneInfo.spineList[0]];

        //  && _scene.spine && !_scene.spine.alpha
        if (_spine) {
          const _spineInstance = SceneManager._scene.spine;
          if (!_spineInstance) {

            Utils_Tachie.loadTachie.call(this, _spine.spineName.replace('Tachie', ''), {
              location: _spine.location,
              motion: _spine.motion,
              skin: _spine.skin,
              alpha: _spine.alpha,
              x: _spine.x,
              y: _spine.y,
              callback() {
                // 透视眼镜效果
                Utils_Tachie.glassesTransform(_spine, _spine.skin);
              }
            });
          } else {
            if (_spine.motion !== undefined) SpineManager.setMotion(_spineInstance, _spine.motion, true);
            if (_spine.skin !== undefined) SpineManager.changeSkin_basic(_spineInstance, _spine.skin);
            if (_spine.alpha !== undefined) _spineInstance.alpha = _spine.alpha;
            if (_spine.x !== undefined) _spineInstance.x = _spine.x;
            if (_spine.y !== undefined) _spineInstance.y = _spine.y;


            // 透视眼镜效果
            Utils_Tachie.glassesTransform(_scene.spine, _scene.spine.tachieInfo.skin);
          }
          this._savedTachie = null;
        } else if (_spine && _scene.spine && _scene.spine.alpha) {
          if (_spine.motion) {
            SpineManager.setMotion(_scene.spine, _spine.motion, true);
          }
          if (_spine.skin) {
            SpineManager.changeSkin_basic(_scene.spine, _spine.skin);
          }
          
        }
      }

      // if ((SsceneManager._scene instanceof Scene_Haku_Home) && $gameData.tempSceneInfo.visibleSisterTachie !== undefined) {
      //   SsceneManager._scene.visibleSisterTachie = $gameData.tempSceneInfo.visibleSisterTachie;
      // }

      // $gameData.tempSceneInfo = {
      //   canUse: false,
      // };
    }

    /** 获取女角色交互菜单列表 */
    getSisterMenus() {
      /** 界面中的女角色菜单列表 */
      this.sisterMenus = [];
    }

    /** 获取系统菜单列表 */
    getSysMenus() {
      /** 系统菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.sysMenus = cloneLoop(__sysMenus);
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      /** 男主行为菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.actorMenus = __actorMenus;
    }

    /** 创建背景 */
    createBackground() {
      this.gameBackground = new PIXI.Container();
      this.backUIContainer.addChildAt(this.gameBackground, 0);
    }
    /** 绘制前景 */
    createForeground() {
      this.gameForeground = new PIXI.Container();
      this.backUIContainer.addChild(this.gameForeground);
    }

    start() {
      super.start();
      SceneManager.clearStack();
    }

    /**
     * 切换场景
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    changeScene({ speed = 30, sceneName, isFadeout = true, isFadein = true, isWait = true, props, notGotoScene, callback }, interpreter) {
      let _triggerEvent = Utils_Event.getEventByTime();
      if (speed === 0) {
        if (isFadeout === true) $gameScreen._brightness = 0;
        $gameData.tempBackground = '';
        $gameData.tempForeground = '';
        // 获取当前场景
        this.sceneInfo = Utils_Scene.getSceneInfo(sceneName);
        $gameData.currentScene = this.sceneInfo.scene;
        if (this.sceneInfo.scene) {
          SceneManager.go(this.sceneInfo.scene, function() {
            if (props) {
              for (let key in props) {
                this[key] = props[key];
              }
            }

            this.transferBlackMask(true);
            // this.refreshData();
            this.drawViewer();
            this.createSysMenuUI();
            this.createActorMenuUI();

            if (notGotoScene !== true) {
              this.gotoScene();
            }

            useTimeout(() => {
              Utils_Event.triggerEventByTime();
            }, 10);

            callback && callback.call(this);
          });
        }
        // 切换背景音乐
        if (this.sceneInfo.bgm) {
          AudioManager.playBgm({ name: this.sceneInfo.bgm, volume: 100, pitch: 100, pan: 0 });
        }
        // 淡入场景
        if (isFadein === true && (!_triggerEvent || _triggerEvent.isFedein !== false)) $gameScreen.startFadeIn(Game_Interpreter.prototype.fadeSpeed());
      } else {
        // 淡出场景
        const _duration = speed || Game_Interpreter.prototype.fadeSpeed();
        if (isFadeout === true) $gameScreen.startFadeOut(_duration);

        if (isWait && interpreter && interpreter instanceof Game_Interpreter) {
          interpreter.wait(_duration);
        }

        return useTimeout(() => {
          $gameData.tempBackground = '';
          $gameData.tempForeground = '';
          // 获取当前场景
          this.sceneInfo = Utils_Scene.getSceneInfo();
          $gameData.currentScene = this.sceneInfo.scene;
          if (this.sceneInfo.scene) {
            SceneManager.go(this.sceneInfo.scene, function() {
              if (props) {
                for (let key in props) {
                  this[key] = props[key];
                }
              }

              this.transferBlackMask(true);
              // this.refreshData();
              this.drawViewer();
              this.createSysMenuUI();
              this.createActorMenuUI();

              if (notGotoScene !== true) {
                this.gotoScene();
              }

              useTimeout(() => {
                Utils_Event.triggerEventByTime();
              }, 10);

              callback && callback.call(this);
            });
          }
          // 切换背景音乐
          if (this.sceneInfo.bgm) {
            AudioManager.playBgm({ name: this.sceneInfo.bgm, volume: 100, pitch: 100, pan: 0 });
          }
          // 淡入场景
          if (isFadein === true && (!_triggerEvent || _triggerEvent.isFedein !== false)) $gameScreen.startFadeIn(_duration);
        }, _duration);
      }
    }
    
    /** 进入当前场景 */
    gotoScene() {
      console.log('进入MainScene场景');
    }

    /** 绘制界面 */
    drawViewer() {
      // 1. 绘制背景
      this.drawBackground();
      // 2. 绘制可交互物品
      this.drawSceneObjects();
      // 3. 绘制前景
      this.drawForeground();
      // 4. 绘制环境
      this.drawFilter();
      // 5. 绘制游戏组件
      this.drawGameComponents();
    }

    // #region 绘制UI部分
    /** 绘制游戏UI */
    drawGameComponents() {
      this.setTooltip();
      this.setSceneName(this.sceneInfo.title);
    }
    // #endregion

    /** 创建界面 */
    createViewer() {
      // 1. 绘制背景（之前已经创建过了）
      this.drawBackground();
      // 2. 创建场景物品容器
      this.drawSceneObjects();
      // 3. 创建立绘区域
      this.createTachieContainer();
      // 4. 绘制自定义部分
      this.createCustom1();
      // 5. 创建前景和前景
      this.createForeground();
      // 6. 绘制前景
      this.drawForeground();
      // 7. 创建光照滤镜
      this.createFilter();
      // 8. 创建游戏组件
      this.createGameComponents();
      // 9. 绘制右上角日期时间UI
      this.createDateTimeUI();
      // 10. 绘制自定义部分
      this.createCustom2();
    }

    /** 创建场景物品容器 */
    createSceneObjects() {
      const _container = new HakuContainer();
      this.objectsContainer = _container;
      this.backUIContainer.addChild(_container);
    }

    /** 重置场景内物品 */
    // resetSceneObjects() {
    //   if (!this.sceneInfo || !this.sceneInfo.sceneObjects) return;

    // }

    /** 清空场景物品 */
    clearSceneObjects() {
      if (this.objectsContainer) {
        this.objectsContainer.removeChildren();
      }
    }

    /** 创建场景物品 */
    drawSceneObjects() {
      if (!this.sceneInfo || !this.sceneInfo.sceneObjects) return;

      this.objectsContainer.removeChildren();

      const _objs = this.sceneInfo.sceneObjects;

      for (let i = 0; i < _objs.length; i++) {
        const _item = _objs[i];
        if (_item.condition && !_item.condition.call(this)) continue;

        const _sprite = new HakuSprite({
          useHover: true, x: _item.x, y: _item.y,
          hoverBitmap: _item.hoverImg,
          normalBitmap: _item.normalImg,
          readonly() {
            if (this.scene && (this.scene instanceof Scene_Home) && this.scene.visibleSisterTachie) {
              return true;
            }
          },
          onTap() {
            if (_item.onTap) _item.onTap.call(this);
          },
        });
        this.objectsContainer.addChild(_sprite);
      }
    }

    /** 创建环境 */
    createFilter() {
      const _container = new PIXI.Container();
      this.gameFilter = _container;
      this.backUIContainer.addChild(_container);
    }

    /** 绘制环境 */
    drawFilter(duration = 0) {
      if (this.sceneInfo.hasFilter) {
        if (this.sceneInfo.customFilter) {
          const _sprites = this.sceneInfo.customFilter();
          changeImgs(this.gameFilter, _sprites, duration);
        } else {
          let _path = '';
          let _blendMode = 0;

          switch (Utils_Time.timeSpan) {
            case 'daytime': break;
            case 'dusk':
              _path = 'bg/background_dusk_mask';
              _blendMode = 2;
              break;
            case 'night':
              _path = 'bg/background_night_mask';
              _blendMode = 2;
              // return `${_base}/bedroom_night${_scene.isOnLight ? "_light" : ""}${_scene.isSleep ? "_sleep" : ""}`;
            default:
              break;
          }
          const _sprite = new Sprite(_path ? ImageManager.loadPicture(_path) : undefined);
          if (_blendMode) {
            _sprite.blendMode = _blendMode;
          }
          changeImgs(this.gameFilter, _sprite, duration);
        }
      }
    }

    /**
     * 切换过滤器（动画）
     * @param {{ path: string, blendMode: number }[]} filterConfig 过滤器配置
     * @param {number} duration 切换时间（帧数）
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    changeFilter(filterConfig, duration = 30, interpreter) {
      // 事件中的等待
      if (interpreter && duration) {
        interpreter.wait(duration);
      }

      this.drawFilter(duration);
    }

    /**
     * 清理时段滤镜（动画）
     * @param {string|string[]} url 背景图片路径 
     * @param {number} duration 切换时间（帧数）
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    clearFilter(duration = 30, interpreter) {
      if (!this.gameFilter) return;
      // 事件中的等待
      if (interpreter && duration) {
        interpreter.wait(duration);
      }

      const _sprite = new Sprite();
      _sprite.blendMode = 2;
      changeImgs(this.gameFilter, _sprite, duration);
    }

    /** 绘制自定义部分1 */
    createCustom1() {

    }

    /** 绘制自定义部分2 */
    createCustom2() {

    }
    
    createTachieContainer() {
      if (!this.tachieContainer) {
        this.tachieContainer = new SpineContainer();
        this.backUIContainer.addChild(this.tachieContainer);
      }
    }

    /** 显示立绘 */
    showTachie(callback) {
      useWait((cb) => {
        if (this.spine) {
          cb();
          this.spine.alpha = 1;
          
          const _info = $gameData.tempSceneInfo;
          const _spineName = this.spine.spineInfo.spineName;
          if (_info.spineInfos[_spineName]) {
            _info.spineInfos[_spineName].visible = true;
            _info.spineInfos[_spineName].alpha = 1;
            if (!_info.spineList.includes(_spineName)) _info.spineList.push(_spineName);
          }

          if (callback) callback.call(this);
        }
      });
    }
    /** 隐藏立绘 */
    hideTachie(callback) {
      useWait((cb) => {
        if (this.spine) {
          cb();
          this.spine.alpha = 0;
          
          const _info = $gameData.tempSceneInfo;
          const _spineName = this.spine.spineInfo.spineName;
          if (_info.spineInfos[_spineName]) {
            _info.spineInfos[_spineName].visible = false;
            _info.spineInfos[_spineName].alpha = 0;
            const _index = _info.spineList.findIndex(i => i ===_spineName);
            if (_index >= 0) _info.spineList.splice(_index, 1);
          }

          if (callback) callback.call(this);
        }
      });
    }

    /** 绘制图片 */
    drawImages(container, imgObj, { isClear = true, duration } = { isClear: true, duration: 0 }) {
      if (!duration) {
        if (typeof imgObj === 'string') {
          ImageManager.loadImgCb(imgObj, (bitmap) => {
            if (isClear) container.removeChildren();
            container.addChild(new Sprite(bitmap));
          });
        } else if (Array.isArray(imgObj)) {
          if (isClear) {
            let _count = imgObj.length;
            let _index = 0;
            const _complete = () => {
              container.removeChildren();

              for (let i = 0; i < imgObj.length; i++) {
                const _img = imgObj[i];
                if (typeof _img === 'string') {
                  container.addChild(new Sprite(ImageManager.loadPicture(_img)));
                } else if (_img instanceof Sprite) {
                  container.addChild(_img);
                } else if (_img instanceof PIXI.Container) {
                  container.addChild(_img);
                } else if (typeof _img === 'object') {
                  const _sprite = new Sprite(ImageManager.loadPicture(_img.path));
                  if (_img.blendMode) {
                    _sprite.blendMode = _img.blendMode;
                  }
                  container.addChild(_sprite);
                }
              }
            };

            if (imgObj.length === 0) {
              container.removeChildren();
            }

            for (let i = 0; i < imgObj.length; i++) {
              const _img = imgObj[i];
              if (typeof _img === 'string') {
                ImageManager.loadImgCb(_img, (bitmap) => {
                  _index++;
                  if (_index === _count) _complete();
                });
              } else if (_img instanceof Sprite) {
                _index++;
                if (_index === _count) _complete();
              } else if (_img instanceof PIXI.Container) {
                _index++;
                if (_index === _count) _complete();
              } else if (typeof _img === 'object') {
                const _bitmap = ImageManager.loadPicture(_img.path);
                if (_bitmap.isReady()) {
                  _index++;
                  if (_index === _count) _complete();
                } else {
                  _bitmap.addLoadListener(() => {
                    _index++;
                    if (_index === _count) _complete();
                  });
                }
              }
            }

          } else {
            for (let i = 0; i < imgObj.length; i++) {
              const _img = imgObj[i];
              if (typeof _img === 'string') {
                container.addChild(new Sprite(ImageManager.loadPicture(_img)));
              } else if (_img instanceof Sprite) {
                container.addChild(_img);
              } else if (_img instanceof PIXI.Container) {
                container.addChild(_img);
              } else if (typeof _img === 'object') {
                const _sprite = new Sprite(ImageManager.loadPicture(_img.path));
                if (_img.blendMode) {
                  _sprite.blendMode = _img.blendMode;
                }
                container.addChild(_sprite);
              }
            }
          }
        }
      } else {
        const _newContainer = new PIXI.Container();
        const _oldContainer = new PIXI.Container();
        _newContainer.alpha = 0;

        for (let i = 0; i < container.children.length;) {
          const _item = container.children[i];
          _oldContainer.addChild(_item);
        }
        
        if (typeof imgObj === 'string') {
          _newContainer.addChild(new Sprite(ImageManager.loadPicture(imgObj)));
        } else if (Array.isArray(imgObj)) {
          for (let i = 0; i < imgObj.length; i++) {
            const _img = imgObj[i];
            if (typeof _img === 'string') {
              _newContainer.addChild(new Sprite(ImageManager.loadPicture(_img)));
            } else if (typeof _img === 'object') {
              const _sprite = new Sprite(ImageManager.loadPicture(_img.path));
              if (_img.blendMode) {
                _sprite.blendMode = _img.blendMode;
              }
              _newContainer.addChild(_sprite);
            }
          }
        }

        container.addChild(_oldContainer);
        container.addChild(_newContainer);

        useTimeout(() => {
          _newContainer.alpha = 1;
          _oldContainer.alpha = 0;
          while (_newContainer.children.length > 0) {
            const _item = _newContainer.children[0];
            container.addChild(_item);
          }
          _newContainer.destroy();
          _oldContainer.destroy();
        }, duration, progress => {
          _newContainer.alpha = progress;
          _oldContainer.alpha = 1 - progress;
        }, {
          easingType: 'Quadratic',
          inout: 'InOut'
        });
      }
    }

    /** 绘制背景 */
    drawBackground() {
      if ((!this.sceneInfo.background && !$gameData.tempBackground) || !this.gameBackground) return;
      
      this.updateBlackMask();
      this.updateOverallFilters();

      if ($gameData.tempBackground) {
        this.drawImages(this.gameBackground, $gameData.tempBackground);
      } else {
        this.drawImages(this.gameBackground, this.sceneInfo.background);
      }

      if (isSameImage($gameData.tempBackground, this.sceneInfo.background)) {
        this.drawSceneObjects();
      } else {
        this.clearSceneObjects();
      }
    }

    /** 绘制前景 */
    drawForeground() {
      if ((!this.sceneInfo.foreground && !$gameData.tempForeground) || !this.gameForeground) return;

      if ($gameData.tempForeground) {
        this.drawImages(this.gameForeground, $gameData.tempForeground);
      } else {
        this.drawImages(this.gameForeground, this.sceneInfo.foreground);
      }
    }

    /** 清空背景 */
    clearBackground() {
      this.gameBackground.bitmap.clear();
    }
    /** 清空背景 */
    clearForeground() {
      this.gameForeground.bitmap.clear();
    }
    /** 切换BGM */
    changeBGM() {
      if (this.sceneInfo.bgm) {
        const _oldBgm = AudioManager._currentBgm;
        const _newBgmName = this.sceneInfo.bgm;

        if (!_oldBgm || (_oldBgm && _oldBgm.name !== _newBgmName)) {
          AudioManager.playBgm({ name: _newBgmName, volume: 100, pitch: 100, pan: 0 });
        }
        // { name: this.sceneInfo.bgm, volume: ConfigManager.bgmVolume, pitch: 100, pan: 0 }
      }
    }
    /**
     * 切换背景（动画）
     * @param {string|string[]} url 背景图片路径 
     * @param {number} duration 切换时间（帧数）
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    changeBackground(url, duration = 30, interpreter) {
      if ((!url && !this.sceneInfo.background) || !this.gameBackground) return;

      if (url && Array.isArray(url)) {
        if (url.length === 0) {
          url = undefined;
        } else if (url.length === 1) {
          url = url[0];
        }
      }

      $gameData.tempBackground = url === '' ? '' : !!url ? url : undefined;

      // 事件中的等待
      if (interpreter && duration) {
        interpreter.wait(duration);
      }

      if ($gameData.tempBackground) {
        this.drawImages(this.gameBackground, $gameData.tempBackground, { clear: true, duration });
        if (isSameImage($gameData.tempBackground, this.sceneInfo.background)) {
          this.drawSceneObjects();
        } else {
          this.clearSceneObjects();
        }
      } else {
        this.drawImages(this.gameBackground, this.sceneInfo.background, { clear: true, duration });
        this.drawSceneObjects();
      }
    }
    /**
     * 切换前景（动画）
     * @param {string|string[]} url 背景图片路径 
     * @param {number} duration 切换时间（帧数）
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    changeForeground(url, duration = 30, interpreter) {
      if ((!url && !this.sceneInfo.foreground) || !this.gameForeground) return;

      if (url && Array.isArray(url)) {
        if (url.length === 0) {
          url = undefined;
        } else if (url.length === 1) {
          url = url[0];
        }
      }

      $gameData.tempForeground = url === '' ? '' : !!url ? url : undefined;

      // 事件中的等待
      if (interpreter && duration) {
        interpreter.wait(duration);
      }
      
      if ($gameData.tempForeground) {
        this.drawImages(this.gameForeground, $gameData.tempForeground, { clear: true, duration });
      } else {
        this.drawImages(this.gameForeground, this.sceneInfo.foreground, { clear: true, duration });
      }
    }

    /** 显示游戏UI */
    showGameUI() {
      if ($gameData.isEventBusy) return;

      if (this.titleContainer) this.titleContainer.alpha = 1;
      if (this.menuContainer) this.menuContainer.alpha = 1;
      if (this.actorMenuContainer) this.actorMenuContainer.alpha = 1;
      this.showNormalTooltip();
    }
    
    /** 隐藏游戏UI */
    hideGameUI() {
      this.setTooltip();
      if (this.titleContainer) this.titleContainer.alpha = 0;
      if (this.menuContainer) this.menuContainer.alpha = 0;
      if (this.actorMenuContainer) this.actorMenuContainer.alpha = 0;
      this.showFullTooltip();
    }

    showActorInfoUI() {
      if (this.actorInfoContainer) this.actorInfoContainer.alpha = 1;
    }

    hideActorInfoUI() {
      if (this.actorInfoContainer) this.actorInfoContainer.alpha = 0;
    }

    hideAllUI() {
      this._hideAllUIList = [];

      if (this.titleContainer) {
        this._hideAllUIList.push(this.titleContainer);
        this.titleContainer.alpha = 0;
      }
      if (this.menuContainer) {
        this._hideAllUIList.push(this.menuContainer);
        this.menuContainer.alpha = 0;
      }
      if (this.actorMenuContainer) {
        this._hideAllUIList.push(this.actorMenuContainer);
        this.actorMenuContainer.alpha = 0;
      }
      if (this.actorInfoContainer) {
        this._hideAllUIList.push(this.actorInfoContainer);
        this.actorInfoContainer.alpha = 0;
      }
      if (this.sisterInfoContainer) {
        this._hideAllUIList.push(this.sisterInfoContainer);
        this.sisterInfoContainer.alpha = 0;
      }
      if (this.dateContainer) {
        this._hideAllUIList.push(this.dateContainer);
        this.dateContainer.alpha = 0;
      }
    }

    showAllUI() {
      for (let i = 0; i < this._hideAllUIList.length; i++) {
        const _item = this._hideAllUIList[i];
        _item.alpha = 1;
      }
      this._hideAllUIList = [];
    }

    // #region 创建UI部分
    /** 创建游戏UI */
    createGameComponents() {
      // 1. 绘制最下方文本提示
      this.createTooltip();
      // 2. 绘制中上的场景标题
      if (this.sceneInfo.title) {
        this.createSceneTitle();
      }

      // 3. 绘制左上角信息
      this.createActorInfoUI();
      this.createSisterInfoUI();

      // 4. 绘制右上角菜单按钮
      this.createSysMenuUI();
      // 5. 绘制男主行为菜单
      this.createActorMenuUI();

      

      // 6. 绘制通向其他房间的箭头 TODO: 待定
      // this.drawMoveArrowUI();
    }

    
    /** 显示全宽度提示 */
    showFullTooltip() {
      if (!this.tooltipBgSprite || this.isFullTooltip === true) return;
      this.tooltipBgSprite.bitmap = ImageManager.loadPicture('ui/tooltip_bg_full');
      // this.tooltipBgSprite._refresh();
      this.isFullTooltip = true;
    }
    /** 显示普通宽度提示 */
    showNormalTooltip() {
      if (!this.tooltipBgSprite || this.isFullTooltip === false) return;
      this.tooltipBgSprite.bitmap = ImageManager.loadPicture('ui/tooltip_bg');
      // this.tooltipBgSprite._refresh();
      this.isFullTooltip = false;
    }

    /** 绘制最下方文本提示 */
    createTooltip() {
      this.tooltipContainer = new PIXI.Container();

      // 绘制背景
      const _bgSprite = new Sprite(ImageManager.loadPicture('ui/tooltip_bg'));
      _bgSprite.x = 0;
      _bgSprite.y = Graphics.height - 30;
      _bgSprite.uid = 'tooltip_bg';
      this.tooltipContainer.addChild(_bgSprite);
      this.tooltipBgSprite = _bgSprite;
      this.isFullTooltip = false;

      // 绘制图标
      this.tooltipIconSprite = new Sprite(ImageManager.loadPicture('ui/tooltip_icon'));
      this.tooltipIconSprite.x = 15;
      this.tooltipIconSprite.y = Graphics.height - 27;
      this.tooltipContainer.addChild(this.tooltipIconSprite);

      // 绘制文本Sprite
      const _textSprite = new Sprite(new Bitmap(Graphics.width - 40 - 30, 30));
      _textSprite.x = 40;
      _textSprite.y = Graphics.height - 30;
      _textSprite.bitmap.textColor = '#D6D0CD';
      _textSprite.bitmap.drawText('', 5, 5, _textSprite.width - 40 - 30, 20);
      this.tooltipSprite = _textSprite;
      this.tooltipContainer.addChild(_textSprite);

      this.uiContainer.addChild(this.tooltipContainer);
    }

    /** 绘制场景标题 */
    createSceneTitle() {
      if (this.titleContainer) {
        this.titleContainer.destroy();
        this.titleContainer = null;
        this.titleSprite = null;
      }

      this.titleContainer = new PIXI.Container();

      // 绘制背景
      const _bgSprite = new Sprite(ImageManager.loadPicture('ui/title_name'));
      _bgSprite.x = (Graphics.width - 500);
      _bgSprite.y = 0;
      this.titleContainer.addChild(_bgSprite);

      if (this.sceneInfo.title && !$gameMessage.hasText()) {
        this.titleContainer.alpha = 1;
        // this.titleContainer.children.forEach(i => i.alpha = 1);
      } else {
        this.titleContainer.alpha = 0;
        // this.titleContainer.children.forEach(i => i.alpha = 0);
      }

      // 绘制文本Sprite
      const _textSprite = new Sprite(new Bitmap(240, 36));
      _textSprite.x = (Graphics.width - 500);
      _textSprite.y = 0;
      _textSprite.bitmap.fontSize = 20;
      _textSprite.bitmap.textColor = '#dd7e54';
      _textSprite.bitmap.outlineWidth = 3;
      _textSprite.bitmap.outlineColor = '#FFFFFF';
      _textSprite.bitmap.drawText(this.sceneInfo.title || '', 5, 5, 240 - 10, 28, 'center');
      this.titleSprite = _textSprite;
      this.titleContainer.addChild(_textSprite);

      this.uiContainer.addChild(this.titleContainer);
    }

    /** 绘制日期时间UI */
    createDateTimeUI() {
      this.dateContainer = new PIXI.Container();
      this.dateContainer.x = Graphics.width - 245;
      this.dateContainer.y = 0;

      // 判断使用哪张图片作为背景
      let _bgImageName = 'ui/time_panel_daytime';
      if (Utils_Time.isDusk()) _bgImageName = 'ui/time_panel_dusk';
      else if (Utils_Time.isNight()) _bgImageName = 'ui/time_panel_night';

      // 绘制背景
      this.dateBgSprite = new Sprite(ImageManager.loadPicture(_bgImageName));
      this.dateBgSprite.x = 15;
      this.dateBgSprite.y = -30;
      this.dateContainer.addChild(this.dateBgSprite);

      // 绘制日期文本Sprite
      this.daySprite = new Sprite(new Bitmap(240, 40));
      this.daySprite.x = 10 + 130 - 2;
      this.daySprite.y = 10;
      this.daySprite.bitmap.fontFace = 'Source Han Sans VF';
      this.daySprite.bitmap.fontSize = 30;
      this.daySprite.bitmap.textColor = '#FFFFFF';
      this.daySprite.bitmap.outlineWidth = 5;
      this.daySprite.bitmap.outlineColor = 'rgba(0, 0, 0, 0.1)';
      this.daySprite.bitmap.drawText(Utils_Time.dateStr, 5, 5, 100, 30, 'center');
      this.dateContainer.addChild(this.daySprite);

      // 绘制时间文本Sprite
      this.timeSprite = new Sprite(new Bitmap(240, 40));
      this.timeSprite.x = 10 + 130;
      this.timeSprite.y = 50;
      this.timeSprite.bitmap.fontFace = 'Source Han Sans VF';
      this.timeSprite.bitmap.fontSize = 28;
      this.timeSprite.bitmap.textColor = '#FFFFFF';
      this.timeSprite.bitmap.outlineWidth = 5;
      this.timeSprite.bitmap.outlineColor = 'rgba(0, 0, 0, 0.1)';
      this.timeSprite.bitmap.drawText(Utils_Time.timeStr, 5, 5, 100, 30, 'center');
      this.dateContainer.addChild(this.timeSprite);

      // 绘制星期文本Sprite
      this.weekSprite = new Sprite(new Bitmap(240, 40));
      this.weekSprite.x = 10 + 35;
      this.weekSprite.y = 5;
      this.weekSprite.bitmap.fontFace = 'Source Han Sans VF';
      this.weekSprite.bitmap.fontSize = 22;
      this.weekSprite.bitmap.textColor = '#FFFFFF';
      this.weekSprite.bitmap.outlineWidth = 4;
      this.weekSprite.bitmap.outlineColor = 'rgba(0, 0, 0, 0.1)';
      this.weekSprite.bitmap.drawText(Utils_Time.weekStr, 5, 5, 100, 30, 'center');
      this.dateContainer.addChild(this.weekSprite);
      

      this.topUIContainer.addChild(this.dateContainer);
    }

    /** 时间流逝更新 */
    updateTime() {
      this.daySprite.bitmap.clear();
      this.daySprite.bitmap.drawText(Utils_Time.dateStr, 5, 5, 100, 30, 'center');

      this.timeSprite.bitmap.clear();
      this.timeSprite.bitmap.drawText(Utils_Time.timeStr, 5, 5, 100, 30, 'center');

      this.weekSprite.bitmap.clear();
      this.weekSprite.bitmap.drawText(Utils_Time.weekStr, 5, 5, 100, 30, 'center');
      
      if (this._prevTimeSpan !== Utils_Time.timeSpan) {

        if (Utils_Time.timeSpan === 'night') {
          $gameData.isOnLight = true;
        }

        // 判断使用哪张图片作为背景
        let _bgImageName = 'ui/time_panel_daytime';
        if (Utils_Time.isDusk()) _bgImageName = 'ui/time_panel_dusk';
        else if (Utils_Time.isNight()) _bgImageName = 'ui/time_panel_night';
        // 绘制背景
        this.dateBgSprite.bitmap = ImageManager.loadPicture(_bgImageName);

        // 切换场景背景
        this.changeBackground();
        this.changeForeground();
        this.changeFilter();
        this.changeBGM();
        this.drawSceneObjects();

        this._prevTimeSpan = Utils_Time.timeSpan;
      }
    }
    
    /** 当前场景的NPC角色 */
    get npcActor() {
      if (Utils_Scene.sameKana()) return 'kana';
      else if (Utils_Scene.sameChinatsu()) return 'chinatsu';
      else if (Utils_Scene.sameYuki()) return 'yuki';
      else if (Utils_Scene.sameEre()) return 'ere';
    }

    /** 绘制系统菜单UI */
    createSysMenuUI() {
      if (this.menuContainer) {
        this.menuContainer.removeChildren();
      } else {
        this.menuContainer = new HakuContainer({
          x: Graphics.width - 65 - 63 * (this.sysMenus.length - 1),
          y: 125
        });

        if ($gameMessage.hasText()) {
          this.menuContainer.alpha = 0;
        }
      }
      
      for (let i = 0; i < this.sysMenus.length; i++) {
        const item = this.sysMenus[i];
        let _itemBg = 'ui/button/button_5';
        if (item.disabled === true) {
          _itemBg = 'ui/button/button_5_disabled';
        }
        
        const _container = new HakuContainer({
          useHover: true, x: i * 63, y: 0, width: 54, height: 62, me: this,
          onHover() {
            item.maskSprite.alpha = 1;
            this.me.setTooltip(item.tooltip);
          },
          disabled() { return item.disabled; },
          onBlur() {
            item.maskSprite.alpha = 0;
            this.me.setTooltip();
          },
          onTap() {
            if (item.onTap) item.onTap.call(this.me);
          }
        });

        this.sysMenus[i].container = _container;

        // 添加背景
        const _sprite = new Sprite(ImageManager.loadPicture(_itemBg));
        _sprite.bitmap.smooth = false;
        this.sysMenus[i].sprite = _sprite;
        _container.addChild(_sprite);

        // 绘制图标
        let _itemIcon = 'ui/icon/menu/' + item.icon;
        if (item.disabled === true) {
          _itemIcon = 'ui/icon/menu/' + item.icon + '_disabled';
        }
        const _iconSprite = new Sprite(ImageManager.loadPicture(_itemIcon));
        _iconSprite.bitmap.smooth = false;
        this.sysMenus[i].iconSprite = _iconSprite;
        _iconSprite.x = 9;
        _iconSprite.y = 8;
        _container.addChild(_iconSprite);

        // 绘制遮罩
        const _maskSprite = new Sprite(ImageManager.loadPicture('ui/button/button_5_mask'));
        _maskSprite.bitmap.smooth = false;
        this.sysMenus[i].maskSprite = _maskSprite;
        _maskSprite.alpha = 0;
        _maskSprite.x = 0;
        _maskSprite.y = 0;
        _container.addChild(_maskSprite);

        // 绘制文字
        const _textSprite = new Sprite(new Bitmap(75, 34));
        _textSprite.bitmap.smooth = false;
        _textSprite.bitmap.fontFace = 'Source Han Sans VF';
        _textSprite.bitmap.fontSize = 12;
        if (item.disabled === true) {
          _textSprite.bitmap.textColor = '#888888';
        } else {
          _textSprite.bitmap.textColor = '#C4541C';
        }
        _textSprite.bitmap.outlineWidth = 6;
        _textSprite.bitmap.outlineColor = '#FFFFFF';
        _textSprite.bitmap.drawText(item.text, 0, 0, 74, 30, 'center');
        _textSprite.x = -10;
        _textSprite.y = 35;
        this.sysMenus[i].textSprite = _textSprite;
        _container.addChild(_textSprite);

        
        this.menuContainer.addChild(_container);
      }

      this.backUIContainer.addChild(this.menuContainer);
    }

    /** 获取当前场景的角色好感度 */
    get favor() {
      switch (this.npcActor) {
        case 'kana': return Utils_Favor.kanaFavor;
        case 'chinatsu': return Utils_Favor.chinatsuFavor;
        case 'yuki': return Utils_Favor.yukiFavor;
        case 'ere': return Utils_Favor.ereFavor;
        default: 0;
      }
    }
    set favor(value) {
      switch (this.npcActor) {
        case 'kana': Utils_Favor.kanaFavor = value; break;
        case 'chinatsu': Utils_Favor.chinatsuFavor = value; break;
        case 'yuki': Utils_Favor.yukiFavor = value; break;
        case 'ere': Utils_Favor.ereFavor = value; break;
        default: 0;
      }
    }
    get maxFavor() {
      switch (this.npcActor) {
        case 'kana': return Utils_Favor.kanaMaxFavor;
        case 'chinatsu': return Utils_Favor.chinatsuMaxFavor;
        case 'yuki': return Utils_Favor.yukiMaxFavor;
        case 'ere': return Utils_Favor.ereMaxFavor;
        default: 0;
      }
    }
    get sex() {
      switch (this.npcActor) {
        case 'kana': return Utils_Favor.kanaSex;
        default: 0;
      }
    }
    

    /** 获取当前场景的好感度进度 */
    getFavor() {
      if (!this.npcActor) return 0;

      if (this.npcActor === 'kana') {
        return Utils_Favor.kanaStageFavor;
      } else {
        return this.favor;
      }
    }
    /** 获取当前场景的好感度进度 */
    getMaxFavor() {
      if (!this.npcActor) return 0;

      if (this.npcActor === 'kana') {
        return Utils_Favor.kanaStageMaxFavor;
      } else {
        return 100;
      }
    }

    /** 获取当前场景的好感度进度 */
    getFavorProgress() {
      if (this.npcActor === 'kana') {
        return Utils_Favor.kanaStageFavor / Utils_Favor.kanaStageMaxFavor;
      } else {
        return this.favor / 100;
      }
    }

    getSexProgress() {
      return this.sex / 100;
    }

    /** 创建妹妹信息 */
    createSisterInfoUI() {
      if (!this.sisterInfoContainer) {
        this.sisterInfoContainer = new HakuContainer({ x: 300, y: 5 });
        this.uiContainer.addChild(this.sisterInfoContainer);
      } else {
        this.sisterInfoContainer.removeChildren();
      }

      // #region 好感度相关
      this.favorContainer = new HakuContainer({
        get useHover() { return !!this.me.tooltipBgSprite; }, x: 0, y: 0, me: this,
        onForceHover() {
          if (this.me.tooltipBgSprite) {
            SoundManager.playCursor();
            this.me.setTooltip('当前角色的好感度');
          }
        },
        onBlur() { this.me.setTooltip(); }
      });
      
      // 绘制好感度背景
      this.favorBgSprite = new Sprite(ImageManager.loadPicture('ui/prop_thumb'));
      this.favorContainer.addChild(this.favorBgSprite);
      // 绘制好感度图标
      const favorIconSprite = new Sprite(ImageManager.loadPicture('ui/icon/icon_state_heart2'));
      favorIconSprite.x = -2;
      favorIconSprite.y = -3;
      this.favorContainer.addChild(favorIconSprite);
      // 绘制好感度数值文本
      this.textFavorSprite = new Sprite(new Bitmap(80, 18));
      this.textFavorSprite.x = 41;
      this.textFavorSprite.y = 11;
      this.textFavorSprite.bitmap.fontSize = 16;
      this.textFavorSprite.bitmap.fontFace = 'ChillRoundF';
      this.textFavorSprite.bitmap.drawText(`${this.getFavor()}/${this.getMaxFavor()}`, 0, 0, 80, 18, 'center');
      this.favorContainer.addChild(this.textFavorSprite);
      // 当前好感度
      this.favorSprite = new Sprite(new Bitmap(79, 2));
      this.favorSprite.x = 41;
      this.favorSprite.y = 31;
      ImageManager.loadImgCb('ui/info_favor_bar', bitmap => {
        this.favorBitmap = bitmap;
        const _progress = this.getFavorProgress();
        this.favorSprite.bitmap.blt(this.favorBitmap, 
          0, 0, bitmap.width * _progress, 20, 
          0, 0, bitmap.width * _progress, 20
        );
        this.favorContainer.addChild(this.favorSprite);
      });
      this.sisterInfoContainer.addChild(this.favorContainer);
      // #endregion

      // #region 性欲相关
      this.sisterSexContainer = new HakuContainer({
        get useHover() { return !!this.me.tooltipBgSprite; }, x: 145, y: 0, me: this,
        onForceHover() {
          if (this.me.tooltipBgSprite) {
            SoundManager.playCursor();
            this.me.setTooltip('当前角色的性欲');
          }
        },
        onBlur() { this.me.setTooltip(); }
      });
      // 绘制性欲背景
      this.sexBgSprite = new Sprite(ImageManager.loadPicture('ui/prop_thumb'));
      this.sisterSexContainer.addChild(this.sexBgSprite);
      // 绘制性欲图标
      const sexIconSprite = new Sprite(ImageManager.loadPicture('ui/icon/icon_state_sex'));
      sexIconSprite.x = -2;
      sexIconSprite.y = -3;
      this.sisterSexContainer.addChild(sexIconSprite);
      // 绘制性欲数值文本
      this.textSexSprite = new Sprite(new Bitmap(80, 18));
      this.textSexSprite.x = 41;
      this.textSexSprite.y = 11;
      this.textSexSprite.bitmap.fontSize = 16;
      this.textSexSprite.bitmap.fontFace = 'ChillRoundF';
      this.textSexSprite.bitmap.drawText(`${Utils_Favor.kanaSex}/${Utils_Favor.kanaMaxSex}`, 0, 0, 80, 18, 'center');
      this.sisterSexContainer.addChild(this.textSexSprite);
      // 当前性欲
      ImageManager.loadImgCb('ui/info_sex_bar', bitmap => {
        this.sexSprite = new Sprite(new Bitmap(bitmap.width, bitmap.height));
        this.sexSprite.x = 41;
        this.sexSprite.y = 31;
        this.sexBitmap = bitmap;
        this.sexSprite.bitmap.blt(this.sexBitmap, 
          0, 0, bitmap.width * Utils_Favor.kanaSex / Utils_Favor.kanaMaxSex, 20, 
          0, 0, bitmap.width * Utils_Favor.kanaSex / Utils_Favor.kanaMaxSex, 20
        );
        this.sisterSexContainer.addChild(this.sexSprite);
      });
      this.sisterInfoContainer.addChild(this.sisterSexContainer);
      // #endregion
      
      // #region 心情相关
      this.moodContainer = new HakuContainer({
        get useHover() { return !!this.me.tooltipBgSprite; }, x: 290, y: 0, me: this,
        onForceHover() {
          if (this.me.tooltipBgSprite) {
            SoundManager.playCursor();
            this.me.setTooltip('当前角色的心情');
          }
        },
        onBlur() { this.me.setTooltip(); }
      });
      // 绘制心情背景
      const moodBgSprite = new Sprite(ImageManager.loadPicture('ui/state_thumb'));
      this.moodContainer.addChild(moodBgSprite);
      // 绘制心情图标
      const moodIconSprite = new Sprite(ImageManager.loadPicture('ui/icon/icon_state_heart'));
      moodIconSprite.x = -2;
      moodIconSprite.y = -3;
      this.moodContainer.addChild(moodIconSprite);
      // 绘制心情文本
      this.textMoodSprite = new Sprite(new Bitmap(80, 20));
      this.textMoodSprite.x = 45;
      this.textMoodSprite.y = 12;
      this.textMoodSprite.bitmap.fontSize = 16;
      this.textMoodSprite.bitmap.fontFace = 'ChillRoundF';
      this.textMoodSprite.bitmap.drawText(Utils_Favor.kanaMoodStr, 0, 0, 80, 20, 'left');
      this.moodContainer.addChild(this.textMoodSprite);
      this.sisterInfoContainer.addChild(this.moodContainer);
      // #endregion

      this.checkSisterState();
    }

    /** 校验是否应该显示妹妹的UI */
    checkSisterState() {
      // 校验妹妹状态栏显示
      if (this.sisterInfoContainer) {
        if (Utils_Scene.sameOne()) {
          this.sisterInfoContainer.alpha = 1;

          useTimeout(() => {
            if (this.favorSprite && this.textFavorSprite) {
              const _progressValue = this.getFavor() / this.getMaxFavor();
              this.textFavorSprite.bitmap.clear();
              this.textFavorSprite.bitmap.drawText(`${this.getFavor()}/${this.getMaxFavor()}`, 0, 0, 80, 18, 'center');
              this.favorSprite.bitmap.clear();
              this.favorSprite.bitmap.blt(this.favorBitmap, 
                0, 0, this.favorSprite.bitmap.width * _progressValue, 20, 
                0, 0, this.favorSprite.bitmap.width * _progressValue, 20
              );
            }
          }, 10);
          
          if (Utils_Scene.sameKana()) {
            this.sisterSexContainer.alpha = 1;
            this.moodContainer.alpha = 1;
          } else {
            this.sisterSexContainer.alpha = 0;
            this.moodContainer.alpha = 0;
          }
        } else {
          this.sisterInfoContainer.alpha = 0;
        }
      }

      if (this.createActorMenuUI) this.createActorMenuUI();
    }

    /** 触发事件前预处理 */
    checkEventTrigger() {

    }

    /** 绘制左上角信息 */ 
    createActorInfoUI() {
      if (!this.actorInfoContainer) {
        this.actorInfoContainer = new HakuContainer({ x: 10, y: 5 });
        this.uiContainer.addChild(this.actorInfoContainer);
      } else {
        this.actorInfoContainer.removeChildren();
      }

      // #region 体力相关
      this.liveContainer = new HakuContainer({
        get useHover() { return !!this.me.tooltipBgSprite; }, x: 0, y: 0, me: this,
        onForceHover() {
          if (this.me.tooltipBgSprite) {
            SoundManager.playCursor();
            this.me.setTooltip('玩家当前的体力值');
          }
        },
        onBlur() { this.me.setTooltip(); }
      });
      // 绘制体力背景
      const liveBgSprite = new Sprite(ImageManager.loadPicture('ui/prop_thumb'));
      this.liveContainer.addChild(liveBgSprite);
      // 绘制体力图标
      const liveIconSprite = new Sprite(ImageManager.loadPicture('ui/icon/icon_state_power'));
      liveIconSprite.x = -2;
      liveIconSprite.y = -3;
      this.liveContainer.addChild(liveIconSprite);
      // 绘制体力数值文本
      this.textLiveSprite = new Sprite(new Bitmap(80, 18));
      this.textLiveSprite.x = 41;
      this.textLiveSprite.y = 11;
      this.textLiveSprite.bitmap.fontSize = 16;
      this.textLiveSprite.bitmap.fontFace = 'ChillRoundF';
      // this.textLiveSprite.bitmap.outlineWidth = 3;
      // this.textLiveSprite.bitmap.outlineColor = '#520b0b';
      this.textLiveSprite.bitmap.drawText(`${Utils_Actor.live}/${Utils_Actor.maxLive}`, 0, 0, 80, 18, 'center');
      this.liveContainer.addChild(this.textLiveSprite);
      // 当前体力
      ImageManager.loadImgCb('ui/info_live_bar', bitmap => {
        this.liveSprite = new Sprite(new Bitmap(bitmap.width, bitmap.height));
        this.liveSprite.x = 41;
        this.liveSprite.y = 31;
        this.liveBitmap = bitmap;
        this.liveSprite.bitmap.blt(this.liveBitmap, 
          0, 0, bitmap.width * Utils_Actor.live / Utils_Actor.maxLive, 20, 
          0, 0, bitmap.width * Utils_Actor.live / Utils_Actor.maxLive, 20
        );
        this.liveContainer.addChild(this.liveSprite);
      });
      this.actorInfoContainer.addChild(this.liveContainer);
      // #endregion

      // #region 理智相关
      this.sanContainer = new HakuContainer({
        get useHover() { return !!this.me.tooltipBgSprite; }, x: 145, y: 0, me: this,
        onForceHover() {
          if (this.me.tooltipBgSprite) {
            SoundManager.playCursor();
            this.me.setTooltip('玩家当前的理智值');
          }
        },
        onBlur() { this.me.setTooltip(); }
      });
      // 绘制理智背景
      const sanBgSprite = new Sprite(ImageManager.loadPicture('ui/prop_thumb'));
      this.sanContainer.addChild(sanBgSprite);
      // 绘制理智图标
      const sanIconSprite = new Sprite(ImageManager.loadPicture('ui/icon/icon_state_brain'));
      sanIconSprite.x = -2;
      sanIconSprite.y = -3;
      this.sanContainer.addChild(sanIconSprite);
      // 绘制理智数值文本
      this.textSanSprite = new Sprite(new Bitmap(80, 18));
      this.textSanSprite.x = 41;
      this.textSanSprite.y = 11;
      this.textSanSprite.bitmap.fontSize = 16;
      this.textSanSprite.bitmap.fontFace = 'ChillRoundF';
      // this.textSanSprite.bitmap.outlineWidth = 3;
      // this.textSanSprite.bitmap.outlineColor = '#520b0b';
      this.textSanSprite.bitmap.drawText(`${Utils_Actor.san}/${Utils_Actor.maxSan}`, 0, 0, 80, 18, 'center');
      this.sanContainer.addChild(this.textSanSprite);
      // 当前理智
      ImageManager.loadImgCb('ui/info_san_bar', bitmap => {
        this.sanSprite = new Sprite(new Bitmap(bitmap.width, bitmap.height));
        this.sanSprite.x = 41;
        this.sanSprite.y = 31;
        this.sanBitmap = bitmap;
        this.sanSprite.bitmap.blt(this.sanBitmap, 
          0, 0, bitmap.width * Utils_Actor.san / Utils_Actor.maxSan, 20, 
          0, 0, bitmap.width * Utils_Actor.san / Utils_Actor.maxSan, 20
        );
        this.sanContainer.addChild(this.sanSprite);
      });
      this.actorInfoContainer.addChild(this.sanContainer);
      // #endregion

      // #region 金钱相关
      this.moneyContainer = new HakuContainer({
        get useHover() { return !!this.me.tooltipBgSprite; }, x: -40, y: 50, me: this,
        onForceHover() {
          if (this.me.tooltipBgSprite) {
            SoundManager.playCursor();
            this.me.setTooltip('玩家当前的金钱，可以通过打工等方式获得');
          }
        },
        onBlur() { this.me.setTooltip(); }
      });
      // 绘制金钱背景
      const _moneyBgSprite = new Sprite(ImageManager.loadPicture('ui/info_glass_panel'));
      this.moneyContainer.addChild(_moneyBgSprite);
      // 绘制金钱图标
      const _moneyIconSprite = new Sprite(ImageManager.loadPicture('ui/icon/money_middle'));
      _moneyIconSprite.x = 40;
      _moneyIconSprite.y = 3;
      this.moneyContainer.addChild(_moneyIconSprite);

      // 绘制金钱文本Sprite
      this.moneySprite = new Sprite(new Bitmap(150, 36));
      this.moneySprite.x = 82;
      this.moneySprite.y = 2;
      this.moneySprite.bitmap.fontFace = 'Source Han Sans VF';
      this.moneySprite.bitmap.fontSize = 18;
      this.moneySprite.bitmap.textColor = '#c4541c';
      this.moneySprite.bitmap.outlineWidth = 4;
      this.moneySprite.bitmap.outlineColor = '#FFFFFF';
      this.moneySprite.bitmap.drawText(`所持金：`, 3, 2, 250, 36, 'left');
      this.moneyContainer.addChild(this.moneySprite);
      const _moneyLabelWidth = this.moneySprite.bitmap.measureTextWidth(`所持金：`);

      this.moneyValueSprite = new Sprite(new Bitmap(150 - _moneyLabelWidth, 36));
      this.moneyValueSprite.x = this.moneySprite.x + _moneyLabelWidth;
      this.moneyValueSprite.y = this.moneySprite.y + 2;
      this.moneyValueSprite.bitmap.fontFace = 'Source Han Sans VF';
      this.moneyValueSprite.bitmap.fontSize = 18;
      this.moneyValueSprite.bitmap.textColor = '#c4541c';
      this.moneyValueSprite.bitmap.outlineWidth = 4;
      this.moneyValueSprite.bitmap.outlineColor = '#FFFFFF';
      this.moneyValueSprite.bitmap.drawText($gameParty._gold, 2, 0, 200, 36, 'left');
      this.moneyContainer.addChild(this.moneyValueSprite);
      
      this.actorInfoContainer.addChild(this.moneyContainer);

      this.moneyContainer.alpha = this._visibleMoney ? 1 : 1;
      // #endregion
    }

    /** 绘制男主行为菜单UI */
    createActorMenuUI() {
      if (this.actorMenuContainer) {
        this.actorMenuContainer.removeChildren();
      } else {
        this.actorMenuContainer = new HakuContainer();
      }
      
      const _menus = this.actorMenus.filter(i => i.visible !== false);
      
      this.actorMenuContainer.x = Graphics.width - 195;
      this.actorMenuContainer.y = Graphics.height - _menus.length * 55;

      for (let i = _menus.length - 1; i >= 0; i--) {
        const item = _menus[i];
        
        const _container = new HakuContainer({
          useHover: true, x: 0, y: i * 55, me: this,
          disabled() { return item.disabled === true; },
          onHover() {
            item.maskSprite.alpha = 1;
            if (item.tooltip) {
              this.me.setTooltip(item.tooltip);
            }
          },
          onBlur() {
            item.maskSprite.alpha = 0;
            this.me.setTooltip();
          },
          onTap() {
            if (item.onTap) item.onTap.call(this.me);
          }
        });
        _container.index = i;

        let _itemBg = 'ui/button/button_4';
        if (item.disabled === true) {
          _itemBg = 'ui/button/button_4_disabled';
        }

        _menus[i].container = _container;

        // 绘制背景
        const _sprite = new Sprite(ImageManager.loadPicture(_itemBg));
        _sprite.bitmap.smooth = false;
        _menus[i].bgSprite = _sprite;
        _sprite.x = 0;
        _sprite.y = 0;
        _container.addChild(_sprite);

        // 绘制图标
        const _iconSprite = new Sprite(ImageManager.loadPicture('ui/icon/white/' + item.icon));
        _iconSprite.bitmap.smooth = false;
        _menus[i].iconSprite = _iconSprite;
        _iconSprite.x = 20;
        _iconSprite.y = 6;
        _container.addChild(_iconSprite);

        // 绘制文字
        const _textSprite = new Sprite(new Bitmap(240, 34));
        _textSprite.bitmap.smooth = false;
        _textSprite.bitmap.fontFace = 'Source Han Sans VF';
        _textSprite.bitmap.fontSize = 17;
        if (item.disabled === true) {
          _textSprite.bitmap.textColor = '#888888';
        } else {
          _textSprite.bitmap.textColor = '#C4541C';
        }
        _textSprite.bitmap.outlineWidth = 6;
        _textSprite.bitmap.outlineColor = '#FFFFFF';
        _textSprite.bitmap.drawText(item.text, 5, 5, 200, 30, 'left');
        _textSprite.x = 62;
        _textSprite.y = 4;
        _menus[i].textSprite = _textSprite;
        _container.addChild(_textSprite);

        // 绘制遮罩
        const _maskSprite = new Sprite(ImageManager.loadPicture('ui/button/button_4_mask'));
        _maskSprite.bitmap.smooth = false;
        _menus[i].maskSprite = _maskSprite;
        _maskSprite.alpha = 0;
        _maskSprite.x = 0;
        _maskSprite.y = 0;
        _container.addChild(_maskSprite);

        this.actorMenuContainer.addChild(_container);
      }

      this.backUIContainer.addChild(this.actorMenuContainer);
    }

    /** 绘制指向其他房间的箭头 */
    createMoveArrowUI() {
      throw new Error('暂未实现，延后');
    }
    // #endregion

    // #region Update部分
    update() {
      super.update();

      // 【暂时弃用】自动时间流逝
      // if (!$gameData.isEventBusy && $gameData.autoPlayTime) {
      //   Utils_Time.timeElapse($gameData.autoPlayTime, {
      //     isSleep: false,
      //     delay: $gameData.audoPlayTimeDelay
      //   });
      //   $gameData.autoPlayTime = 0;
      // }

      // this.updateMainMultiply();
      // // this.updateVisibility();
      // Scene_Message.prototype.update.call(this);
      // this.updateWaitCount();
      // if (this.isSceneChangeOk()) {
      //   this.updateScene();
      // }
      // if (this.isMenuEnabled()) {
      //   this.updateButtons();
      // }
    };

    terminate() {
      super.terminate();
      if (!(SceneManager._nextScene instanceof Scene_MainScene)) {
        SceneManager.screenShot();
      }
    }

    /** 设置说明文本 */
    setTooltip(text) {
      if (!this.tooltipSprite) return;

      this.tooltipSprite.bitmap.clear();
      if (text) {
        this.tooltipSprite.bitmap.drawText(text, 5, 5, this.tooltipSprite.width - 40 - 30, 20);
      }
    }

    /** 设置场景名称 */
    setSceneName(name) {
      if (this.titleContainer) {
        this.titleSprite.bitmap.clear();
        if (name) {
          console.log('场景名称', name);
          this.titleContainer.alpha = 1;
          this.titleSprite.bitmap.drawText(name, 5, 5, 240 - 10, 28, 'center');
          // this.titleContainer.children.forEach(i => i.alpha = 1);
        } else {
          this.titleContainer.alpha = 0;
          // this.titleContainer.children.forEach(i => i.alpha = 0);
        }
      }
    }
    // #endregion
  }
  window.Scene_MainScene = Scene_MainScene;

  // #endregion

})();