//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_Map.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 大地图场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /** 系统菜单 */
  const __buildList = [
    {
      x: 790,
      y: 350,
      imageNormal: 'map/bar_normal',
      imageActive: 'map/bar_active',
      imageDisabled: 'map/bar_disabled',
      imageUnOpen: 'map/bar_unopen',
      title: '酒吧',
      name: 'scene_bar',
      // get unopen() { return true; },
      tooltip: '',
      onTap() {
      }
    }, {
      x: 950,
      y: 210,
      imageNormal: 'map/building_site_normal',
      imageActive: 'map/building_site_active',
      imageDisabled: 'map/building_site_disabled',
      imageUnOpen: 'map/building_site_unopen',
      title: '工地',
      name: 'scene_building_site',
      // get unopen() { return true; },
      tooltip: '',
      onTap() {
      }
    }, {
      x: 70,
      y: 300,
      imageNormal: 'map/park_normal',
      imageActive: 'map/park_active',
      imageDisabled: 'map/park_disabled',
      imageUnOpen: 'map/park_unopen',
      // get unopen() { return true; },
      title: '公园',
      name: 'scene_park',
      // get disabled() {
      //   return $gameSwitches.value(13) !== true;
      // },
      tooltip: '',
      onTap() {
        Utils_Scene.changeScene({ sceneName: 'scene_park' });
      }
    }, {
      x: 500,
      y: 250,
      imageNormal: 'map/street_normal',
      imageActive: 'map/street_active',
      imageDisabled: 'map/street_disabled',
      imageUnOpen: 'map/street_unopen',
      title: '街道',
      name: 'scene_street',
      get disabled() {
        return $gameSwitches.value(14) !== true;
      },
      tooltip: '',
      onTap() {
        Utils_Scene.changeScene({ sceneName: 'scene_street' });
      }
    }, {
      x: 750,
      y: 170,
      imageNormal: 'map/clothing_normal',
      imageActive: 'map/clothing_active',
      imageDisabled: 'map/clothing_disabled',
      imageUnOpen: 'map/clothing_unopen',
      title: '服装店',
      name: 'scene_clothing_shop',
      get disabled() {
        return $gameSwitches.value(15) !== true;
      },
      tooltip: '',
      onTap() {
        if (Utils_Time.hour >= 8 && Utils_Time.hour < 18) {
          Utils_Scene.changeScene({ sceneName: 'scene_clothing_shop' });
        } else {
          useConfirm({
            hasCancel: false,
            content: `服装店在08:00～18:00之间营业`,
            okHandler() {
              this.close();
            }
          });
        }
      }
    }, {
      x: 1090,
      y: 360,
      imageNormal: 'map/dust_heap_normal',
      imageActive: 'map/dust_heap_active',
      imageDisabled: 'map/dust_heap_disabled',
      imageUnOpen: 'map/dust_heap_unopen',
      title: '垃圾山',
      name: 'scene_dust_heap',
      // get unopen() { return true; },
      tooltip: '',
      onTap() {
      },
      get disabled() { return true; },
      onDisabledTap() {
        if (DataManager.isClearAllScene()) return;
        if (!this.count) this.count = 0;
        this.count++;

        if (this.count >= this.maxCount) {
          this.count = 0;
          Utils_Cursor.cursorType = 'default';

          useConfirm({
            hasCancel: true,
            content: `是否开启全部回想事件？`,
            okHandler() {
              DataManager.clearAllScene();

              DataManager.clearScene('1');
              DataManager.clearScene('2');
              DataManager.clearScene('3-1');
              DataManager.clearScene('4-1');
              DataManager.clearScene('5-1');

              this.close();
            }
          });
        }
      },
    }, {
      x: 480,
      y: 450,
      imageNormal: 'map/home_normal',
      imageActive: 'map/home_active',
      imageDisabled: 'map/home_disabled',
      imageUnOpen: 'map/home_unopen',
      title: '「家」',
      name: 'scene_bedroom',
      tooltip: '',
      onTap() {
        Utils_Scene.changeScene({ sceneName: 'scene_bedroom' });
      }
    }, {
      x: 900,
      y: 60,
      imageNormal: 'map/mystical_normal',
      imageActive: 'map/mystical_active',
      imageDisabled: 'map/mystical_disabled',
      imageUnOpen: 'map/mystical_unopen',
      title: '神秘商店',
      name: 'scene_r18_shop',
      get disabled() {
        return $gameSwitches.value(3) !== true;
      },
      tooltip: '',
      onTap() {
        if (Utils_Time.hour >= 18 && Utils_Time.hour < 24) {
          Utils_Scene.changeScene({ sceneName: 'scene_r18_shop' });
        } else {
          useConfirm({
            hasCancel: false,
            content: `神秘商店在18:00～24:00之间营业`,
            okHandler() {
              this.close();
            }
          });
        }
      }
    }, {
      x: 700,
      y: 540,
      imageNormal: 'map/shop_normal',
      imageActive: 'map/shop_active',
      imageDisabled: 'map/shop_disabled',
      imageUnOpen: 'map/shop_unopen',
      title: '便利店',
      name: 'scene_shop',
      tooltip: '',
      onTap() {
        if (Utils_Time.hour >= 8 && Utils_Time.hour < 20) {
          // 是否初识千夏
          if ($gameSwitches.value(5) !== true) {
            $gameData.isEventBusy = true;
            $gameTemp.reserveCommonEvent(113);
          } else {
            Utils_Scene.changeScene({ sceneName: 'scene_shop' });
          }
        } else {
          useConfirm({
            hasCancel: false,
            content: `便利店在08:00～20:00之间营业`,
            okHandler() {
              this.close();
            }
          });
        }
      }
    }, {
      x: 240,
      y: 100,
      imageNormal: 'map/woods_normal',
      imageActive: 'map/woods_active',
      imageDisabled: 'map/woods_disabled',
      imageUnOpen: 'map/woods_unopen',
      // get unopen() { return true; },
      get disabled() {
        return $gameSwitches.value(44) !== true;
      },
      title: '森林',
      name: 'scene_forest',
      tooltip: '',
      onTap() {
        Utils_Scene.changeScene({ sceneName: 'scene_forest' });
      }
    }
  ];

  /**
   * 大地图场景
   */
  class Scene_Haku_Map extends Scene_MainScene {
    initialize() {
      super.initialize();
      this._isNight = Utils_Time.timeSpan === 'night';
    }

    create() {
      super.create();

      this.count = 0;
      this.maxCount = 10;

      this.tipCounterIndex = 0;
      this.tipCounterCount = 3;
      this.tipFrameIndex = 0;
      this.tipFrameCount = 15;
      this.tipEndFrameIndex = 0;
      this.tipEndFrameCount = 30;
    }

    createCustom1() {
      this.buildList = cloneLoop(__buildList);

      this.mapContainer = new HakuContainer();
      this.backUIContainer.addChild(this.mapContainer);

      this.createMapBackground();
      this.createMapBuildings();

      // 创建关灯黑幕
      // this.createNightMask();
    }

    /** 创建背景 */
    createMapBackground() {
      this.mapBackgroundSprite = new Sprite(ImageManager.loadPicture('map/map_bg'));

      this.mapContainer.addChild(this.mapBackgroundSprite);
    }

    /** 是否夜晚 */
    get isNight() {
      return this._isNight;
    }
    set isNight(value) {
      if (value !== this._isNight) {
        this._isNight = value;
        
        useAnime({
          frameDelay: 0,
          frameCount: 20,
          autoUpdate: true,
          easingType: 'Quadratic',
          inout: 'InOut',
        }, progress => {
          if (value) {
            this.nightMask.alpha = progress;
          } else {
            this.nightMask.alpha = 1 - progress;
          }
        });
      }
    }

    /**
     * 创建黑幕（遮罩，用于表现晚上或黄昏）
     */
    createNightMask() {
      if (!this.nightMask) {
        this.nightMask = new Sprite(ImageManager.loadPicture('ui/interact/light_off_bg'));
        this.nightMask.alpha = this.isNight ? 1 : 0;
        this.nightMask.blendMode = 2;
        this.backUIContainer.addChild(this.nightMask);
      }
    }
    
    /** 
     * 根据位置显示气泡
     * @param {string} tipIndex 气泡名称
     * @param {Object} param1 
     * @param {'left'|'right'} [param1.loc='left'] 气泡方位
     * @param {Sprite|Container} [param1.parent] 父容器
     */
    // showTip(tipIndex, { left, top, parent }) {
    //   ImageManager.loadImg(`ui/event_tip_${tipIndex}`).then(img => {
    //     const _cellScale = 2;
    //     const _cellWidth = img.width / 5;
    //     const _cellHeight = img.height / 3;
    //     const _frameCount = 5 * 3 * 3;
        
    //     const _sprite = new Sprite(new Bitmap(_cellWidth / _cellScale, _cellHeight / _cellScale));
    //     _sprite.x = left;
    //     _sprite.y = top;
    //     parent.addChild(_sprite);

    //     const _timer = useTimeout(() => {
    //       _sprite.destroy();
    //     }, 5 * 3 * 3, progress => {
    //       if (progress * _frameCount % 5 != 0) return;
          
    //       const _cellIndex = Math.floor(progress * _frameCount / 3);
    //       const _cellX = (_cellIndex % 5) * _cellWidth;
    //       const _cellY = Math.floor(_cellIndex / 5) * _cellHeight;

    //       _sprite.bitmap.clear();
    //       _sprite.bitmap.blt(img, 
    //         _cellX, _cellY, _cellWidth, _cellHeight,
    //         0, 0, _cellWidth / _cellScale, _cellHeight / _cellScale
    //       );
    //     });

    //     this.timer = _timer;
    //     return _timer;
    //   });
    // }

    getBuildingEvent(buildingName) {
      const _sceneList = Utils_Scene.sceneList;
      if (!_sceneList.some(item => item.name === buildingName)) return '';

      const event = Utils_Event.eventList.find(e => e.eventType && Utils_Event.checkEvent(e.id, buildingName));

      if (event && event.eventType) {
        switch (event.eventType) {
          case 'event': return '1';
          case 'important': return '2';
          case 'sex': return '3';
          default: return '';
        }
      } else {
        return '';
      }
    }

    /** 创建各个建筑 */
    createMapBuildings() {

      for (let i = 0; i < this.buildList.length; i++) {
        const _item = this.buildList[i];

        let _imgBuild = _item.imageNormal;

        if (_item.unopen) {
          _imgBuild = _item.imageUnOpen;
        } else if (_item.disabled) {
          _imgBuild = _item.imageDisabled;
        }

        
        _item.sprite = new HakuSprite({
          x: _item.x, y: _item.y, me: this,
          useHover: true,
          normalBitmap: _imgBuild,
          // hoverBitmap: _item.imageActive,
          disabled() { return _item.disabled; },
          onHover() {
            if (_item.tooltip) {
              this.me.setTooltip(_item.tooltip);
            }
            if (_item.unopen !== true) {
              this.setImg(_item.imageActive);
            }
          },
          onBlur() {
            this.me.setTooltip();
          },
          onTap() {
            // 禁用状态
            if (_item.unopen === true) {
              useConfirm({
                hasCancel: false,
                content: `${_item.title}暂未开启`,
                okHandler() {
                  this.close();
                }
              });
            } else {
              if (_item.onTap) _item.onTap.call(this);
            }
          },
          onDisabledTap() {
            if (_item.onDisabledTap) {
              _item.onDisabledTap.call(this.me);
            }
          }
        });
        this.mapContainer.addChild(_item.sprite);

        ImageManager.loadImgCb(_imgBuild, img => {
          const _spriteTextBg = new Sprite(ImageManager.loadPicture('map/textbox_2_normal'));
          _spriteTextBg.x = _item.x + img.width / 2 - 167 / 2;
          _spriteTextBg.y = _item.y + img.height;
          this.mapContainer.addChild(_spriteTextBg);

          // 获取当前会触发的事件
          if (_item.disabled !== true) {
            const _tipIndex = this.getBuildingEvent(_item.name);
            if (_tipIndex) {
              const _spriteTip = new Sprite(new Bitmap(60, 60));
              _spriteTip.x = _item.x + img.width / 2 + 35;
              _spriteTip.y = _item.y + img.height - 15;
              this.mapContainer.addChild(_spriteTip);
              _item.tipIndex = _tipIndex;
              _item.tipSprite = _spriteTip;
            }
          }

  
          const _spriteText = new Sprite(new Bitmap(167, 30));
          _spriteText.x = _item.x + img.width / 2 - _spriteText.width / 2;
          _spriteText.y = _item.y + img.height;

          _spriteText.bitmap.smooth = false;
          _spriteText.bitmap.fontSize = 16;
          _spriteText.bitmap.textColor = '#FFFFFF';
          _spriteText.bitmap.outlineWidth = 4;
          _spriteText.bitmap.outlineColor = '#c4541c';
          _spriteText.bitmap.fontFace = 'Source Han Sans VF';
          // console.log(`在${_spriteText.x}:${_spriteText.y}绘制文本：${_item.title}`)
          _spriteText.bitmap.drawText(_item.title, 0, 0, _spriteText.width, _spriteText.height, 'center');

          _item.textSprite = _spriteText;
          this.mapContainer.addChild(_spriteText);
        });
      }
    }

    update() {
      super.update();

      if (!this.isNight && Utils_Time.timeSpan === 'night') {
        this.isNight = true;
      } else if (this.isNight && Utils_Time.timeSpan !== 'night') {
        this.isNight = false;
      }

      let _isChange = false;

      this.tipCounterIndex++;
      if (this.tipCounterIndex >= this.tipCounterCount) {
        this.tipCounterIndex = 0;
        if (this.tipFrameIndex < this.tipFrameCount - 3) {
          this.tipFrameIndex++;
          _isChange = true;
        } else if (this.tipFrameIndex === this.tipFrameCount - 3) {
          if (this.tipEndFrameIndex < this.tipEndFrameCount) {
            this.tipEndFrameIndex++;
          } else {
            this.tipFrameIndex++;
          }
        } else if (this.tipFrameIndex >= this.tipFrameCount - 2) {
          this.tipEndFrameIndex = 0;
          this.tipFrameIndex = 0;
          _isChange = true;
        }
      }
      
      if (_isChange) {
        const _x = 60 * (this.tipFrameIndex % 5);
        const _y = 60 * Math.floor(this.tipFrameIndex / 5);

        for (let i = 0; i < this.buildList.length; i++) {
          const _item = this.buildList[i];

          if (_item.tipIndex) {
            _item.tipSprite.bitmap.bltImg(`ui/event_tip_${_item.tipIndex}`, undefined, { x2: _x, y2: _y, width2: 60, height2: 60, clear: true });
          }
        }
      }
    }
  }
  window.Scene_Haku_Map = Scene_Haku_Map;
})();