//=============================================================================
// ** RPG Maker MZ - Scene_Haku_Park.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 公园场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /** 男主行为菜单 */
  const __actorMenus = [
    {
      name: '翻垃圾桶',
      text: '翻垃圾桶',
      icon: 'icon_ashbin',
      tooltip: '可以翻到什么好东西也说不定呢？',
      get disabled() { return Utils_Actor.live <= 10; },
      onTap() {
        $gameData.isEventBusy = true;
        $gameTemp.reserveCommonEvent(266);
      }
    }, {
      name: '小憩片刻',
      text: '小憩片刻',
      icon: 'icon_zzz',
      get tooltip() {
        return '在公园的长椅上好好的休息一下吧';
      },
      get disabled() { return false; },
      get visible() {
        return Utils_Time.hour < 20;
      },
      onTap() {
        Utils_Actor.live += 20;
        Utils_Time.timeElapse(60 * 2, { mask: true, isSleep: false, delay: 5 });
      }
    }, {
      name: '使用道具',
      text: '使用道具',
      icon: 'icon_box',
      get tooltip() {
        return '看看还有些什么可以用的东西…';
      },
      get disabled() { return false; },
      onTap() {
        SceneManager.push(Scene_Haku_Item);
      }
    }, {
      name: '离开',
      text: '离开',
      icon: 'icon_goout',
      tooltip: '那就先离开吧',
      onTap() {
        Utils_Scene.changeScene({ sceneName: 'scene_map' });
      }
    }
  ];



  /**
   * 公园场景
   */
  class Scene_Haku_Park extends Scene_MainScene {
    initialize() {
      super.initialize();

    }
    
    gotoScene() {
    }

    create() {
      super.create();
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      /** 男主行为菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.actorMenus = __actorMenus;
    }

    update() {
      super.update();

    }
  }
  window.Scene_Haku_Park = Scene_Haku_Park;

})();