//=============================================================================
// ** RPG Maker MZ - Scene_Haku_R18_Shop.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 神秘商店页场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /** 男主行为菜单 */
  const __actorMenus = [
    {
      name: '随便聊聊',
      text: '随便聊聊',
      icon: 'icon_chat',
      tooltip: '和由纪增进感情的良好时机哦～今天又有哪些趣事和由纪分享呢？',
      get disabled() { return Utils_Actor.live <= 10; },
      onTap() {
        $gameData.isEventBusy = true;
        $gameTemp.reserveCommonEvent(263);
      }
    }, {
      name: '买点什么',
      text: '买点什么',
      icon: 'icon_shopping',
      tooltip: '要买点什么色色的小东西吗？',
      get disabled() { return false; },
      get visible() {
        return Utils_Scene.sameYuki();
      },
      onTap() {
        SceneManager.push(Scene_Haku_BuyGoods);
      }
    }, {
      name: '使用道具',
      text: '使用道具',
      icon: 'icon_box',
      get tooltip() {
        return '看看还有些什么可以用的东西…';
      },
      get disabled() { return false; },
      onTap() {
        SceneManager.push(Scene_Haku_Item);
      }
    }, {
      name: '离开',
      text: '离开',
      icon: 'icon_goout',
      tooltip: '那就先离开吧',
      onTap() {
        if (Utils_Scene.sameYuki()) {
          this.showTachie();
          startTalk(Utils_ChatMessage.getChat('由纪-路上小心'), [], () => {
            Utils_Scene.changeScene({ sceneName: 'scene_map' });
          });
        } else {
          Utils_Scene.changeScene({ sceneName: 'scene_map' });
        }
      }
    }
  ];



  /**
   * 神秘商店场景
   */
  class Scene_Haku_R18_Shop extends Scene_MainScene {
    initialize() {
      super.initialize();

    }
    
    gotoScene() {
      if (!$gameData.isEventBusy) {
        this.showTachie();
      }
    }

    create() {
      super.create();
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      /** 男主行为菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.actorMenus = __actorMenus;
    }

    update() {
      super.update();

    }
  }
  window.Scene_Haku_R18_Shop = Scene_Haku_R18_Shop;

})();