//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 存/读档场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  // #region 读档场景相关

  Scene_Load.prototype.onLoadSuccess = function() {
    // SoundManager.playLoad();
    this.fadeOutAll();
    $gameScreen._brightness = 0;
    AudioManager.playCv('Already_Load', 0);
    $gameData.__loadSaveSuccess = false;
    // SceneManager.go(Scene_MainScene, () => {
    //   Utils_Scene.changeScene.call(this, {
    //     duration: 30,
    //     sceneName: $gameData.tempSceneInfo.gameSceneName,
    //     isFadeout: true,
    //     isFadein: true,
    //     isWait: false,
    //     callback: () => {
    //       $gameData.isLoading = false;
    //       this._loadSuccess = true;
    //     }
    //   });
    //   // SceneManager._scene.changeScene({ speed: 0, isFadeout: true });
    // });
    SceneManager.go(new Function("return " + ($gameData.tempSceneInfo.sceneName || 'Scene_MainScene'))(), function() {
      // $gameSystem._tempInitEvent = true;
      this.sceneInfo = Utils_Scene.getSceneInfo();
      $gameData.__loadSaveSuccess = true;
      if (!$gameData.isEventBusy) {
        Utils_Event.triggerEventByTime();
      }
      $gameScreen.startFadeIn(30);
    });
  };

  
  // Scene_Save.prototype.onSavefileOk = function() {
  //   Scene_File.prototype.onSavefileOk.call(this);
  //   const savefileId = this.savefileId();
  //   if (this.isSavefileEnabled(savefileId)) {
  //     if (DataManager.savefileExists(savefileId)) {
  //       useConfirm({
  //         hasCancel: true,
  //         content: '是否覆盖当前存档？',
  //         okHandler: () => {
  //           this.executeSave(savefileId);
  //         },
  //         cancelHandler: () => {
  //           this.activateListWindow();
  //         }
  //       });
  //     }
  //   } else {
  //     this.onSaveFailure();
  //   }
  // };

  Scene_Save.prototype.executeSave = function(savefileId) {
    if (DataManager.savefileExists(savefileId)) {
      useConfirm({
        hasCancel: true,
        content: '是否覆盖当前存档？',
        okHandler: () => {
          $gameSystem.setSavefileId(savefileId);
          $gameSystem.onBeforeSave();
          DataManager.saveGame(savefileId)
              .then(() => this.onSaveSuccess())
              .catch(() => this.onSaveFailure());
        },
        cancelHandler: () => {
          useTimeout(() => {
            this._listWindow.activate();
          }, 30);
        }
      });
    } else {
      $gameSystem.setSavefileId(savefileId);
      $gameSystem.onBeforeSave();
      DataManager.saveGame(savefileId)
          .then(() => this.onSaveSuccess())
          .catch(() => this.onSaveFailure());
    }
  };
  
  Scene_Save.prototype.onSaveSuccess = function() {
    // SoundManager.playSave();
    AudioManager.playCv('Already_Save', 0);
    this.popScene();
  };

  /** 截图 */
  SceneManager.screenShot = function() {
    let _spines = [];
    if (SceneManager._scene.spine) {
      _spines.push(SceneManager._scene.spine);
    }
    
    SceneManager._screenShotBase64 = DataManager.getScreenShotBase64(220, 124, _spines);
  }

  DataManager.makeSavefileInfo = function() {
    const info = {};
    
    // 游戏版本
    info.gameVersion = window.gameVersion || '*';

    // 天数
    info.day = Utils_Time.day;
    // 时间
    info.timeStr = Utils_Time.timeStr;
    // 缩略图
    info.screenShot = SceneManager._screenShotBase64;
    // 金钱
    info.gold = $gameParty._gold;
    // 体力
    info.live = Utils_Actor.live;
    // 加奈好感度
    info.kanaFavor = Utils_Favor.kanaFavor;
    // 加奈YL度
    info.kanaSex = Utils_Favor.kanaSex;

    info.title = TranslateUtils.getText($dataSystem.gameTitle) + ' v' + gameVersion;
    info.characters = $gameParty.charactersForSavefile();
    info.faces = $gameParty.facesForSavefile();
    info.playtime = $gameSystem.playtimeText();
    info.timestamp = Date.now();
    return info;
  };

  DataManager.extractSaveContents = function(contents) {
    // 读取存档内容
    $gameData = mergeMissing(contents.$gameData || {}, cloneLoop(window.__TEMP_GAME_DATA));
    
    $gameSystem = contents.system;
    $gameScreen = contents.screen;
    $gameTimer = contents.timer;
    $gameSwitches = contents.switches;
    $gameVariables = contents.variables;
    $gameSelfSwitches = contents.selfSwitches;
    $gameActors = contents.actors;
    $gameParty = contents.party;
    $gameMap = contents.map;
    $gamePlayer = contents.player;
    
    
    // $gameScreen.__brightness = $gameScreen._brightness;
    // Object.defineProperty($gameScreen, '_brightness', {
    //     get() {
    //         return $gameScreen.__brightness;
    //     },
    //     set(value) {
    //         if ($gameScreen.__brightness !== value) {
    //             console.warn('修改亮度：.', value);
    //         }
    //         $gameScreen.__brightness = value;
    //     },
    //     configurable: true
    // });
  };

  // #endregion

  // #region 存档场景相关

  DataManager.loadSavefileImages = function(info) {

  };

  /**
   * 获取截图的Base64编码
   * @param {Spine[]} spines 需要额外渲染的Spine动画
   */
  DataManager.getScreenShotBase64 = function(width, height, spines = []) {
    // 额外处理spine动画，让动画显示出来
    for (let i = 0; i < spines.length; i++) {
      const _spine = spines[i];
      for (let o = 0; o < _spine.children.length; o++) {
        const child = _spine.children[o];
        child.visible = true;
      }
    }

    const _snapImage = SceneManager.snap();
    if (!_snapImage) return null;

    const reBitmap = new Bitmap(width, height);
    reBitmap.blt(_snapImage, 0, 0, _snapImage.width, _snapImage.height, 0, 0, width, height);

    const _reBase64 = reBitmap._canvas.toDataURL('image/jpeg', 0.9);

    // const _bitmap1 = SceneManager.snap();

    // const _bitmap2 = ImageManager.loadBitmapFromUrl(_newBitmap._canvas.toDataURL('image/' + 'png', 1));
    
    // const reSprite = new Sprite(_bitmap2);

    // const renderTexture = PIXI.RenderTexture.create({ width: _w, height: _h });

    // 计算缩放比例
    // const scaleX = _w / Graphics.width;
    // const scaleY = _h / Graphics.height;

    // const matrix = new PIXI.Matrix();
    // matrix.scale(scaleX, scaleY);

    // Graphics.app.renderer.render(reSprite, renderTexture, false, matrix);
    // const imageData = Graphics.app.renderer.extract.base64(renderTexture);

    // const node = document.createElement('img');
    // node.setAttribute('src', imageData);
    // node.setAttribute('style', `
    // position: absolute;
    // top: 30px;
    // left: 30px;
    // z-index: 999;
    // `);
    // document.body.appendChild(node);

    return _reBase64;
  }

  Scene_File.prototype.create = function () {
    this._maxPageCount = 10;
    this._currentPageIndex = 0;

    Scene_MenuBase.prototype.create.call(this);
    DataManager.loadAllSavefileImages();
    this.createBackground();
    this.createSplitComponent();
    this.createTitle();
    this.createBackBtn();
    this.createListWindow();

  };

  /**
   * 创建翻页组件
   */
  Scene_File.prototype.createSplitComponent = function() {
    // 左右翻页按钮
    this.prevBtnSprite = new Sprite(ImageManager.loadPicture(`ui/button/page_prev_btn${this.isFirstPage() ? '_disabled' : ''}`));
    this.prevBtnSprite.x = 10;
    this.prevBtnSprite.y = (Graphics.height - 128) / 2;
    this.addChild(this.prevBtnSprite);
    
    this.nextBtnSprite = new Sprite(ImageManager.loadPicture(`ui/button/page_next_btn${this.isLastPage() ? '_disabled' : ''}`));
    this.nextBtnSprite.x = Graphics.width - 72 - 10;
    this.nextBtnSprite.y = (Graphics.height - 128) / 2;
    this.addChild(this.nextBtnSprite);


    // 数字翻页器
    this.numSplitContainer = new PIXI.Container();
    this._pageNumSpriteList = [];
    let _startX = 340;
    let _startY = Graphics.height - 70;

    for (let i = 0; i < this._maxPageCount; i++) {
      let _bitmap;
      if (this._currentPageIndex === i) {
        _bitmap = ImageManager.loadPicture('ui/button/page_num_item_active');
      } else {
        _bitmap = ImageManager.loadPicture('ui/button/page_num_item');
      }

      const _pageNumSprite = new Sprite(_bitmap);
      _pageNumSprite.x = _startX + i * 60;
      _pageNumSprite.y = _startY;
      this.numSplitContainer.addChild(_pageNumSprite);

      const _pageNumTextSprite = new Sprite(new Bitmap(50, 50));
      _pageNumTextSprite.x = _startX + i * 60;
      _pageNumTextSprite.y = _startY;
      
      _pageNumTextSprite.bitmap.fontSize = 26;
      _pageNumTextSprite.bitmap.outlineWidth = 3;
      if (this._currentPageIndex === i) {
        _pageNumTextSprite.bitmap.textColor = '#ffffff';
        _pageNumTextSprite.bitmap.outlineColor = 'rgba(0,0,0,0)';
      } else {
        _pageNumTextSprite.bitmap.textColor = '#fc8919';
        _pageNumTextSprite.bitmap.outlineColor = '#ffffff';
      }
      _pageNumTextSprite.bitmap.drawText((i + 1) + '', 0, 0, 50, 50, 'center');
      this.numSplitContainer.addChild(_pageNumTextSprite);

      this._pageNumSpriteList.push({
        bgSprite: _pageNumSprite,
        textSprite: _pageNumTextSprite,
        x: _startX + i * 60,
        y: _startY,
        index: i
      });
    }

    this.addChild(this.numSplitContainer);
  }

  Scene_File.prototype.changePage = function(newPageIndex) {
    if (newPageIndex < 0) newPageIndex = 0;
    else if (newPageIndex >= this._maxPageCount) newPageIndex = this._maxPageCount - 1;

    if (this._currentPageIndex === newPageIndex) return;

    this._currentPageIndex = newPageIndex;
    this._listWindow.setPageIndex(newPageIndex);
    this.refreshPage();
  };

  Scene_File.prototype.refreshPage = function() {
    this._listWindow.refresh();

    
    // 左右翻页按钮
    if (this.isFirstPage()) {
      this.prevBtnSprite.bitmap = ImageManager.loadPicture('ui/button/page_prev_btn_disabled');
    } else {
      this.prevBtnSprite.bitmap = ImageManager.loadPicture('ui/button/page_prev_btn');
    }

    if (this.isLastPage()) {
      this.nextBtnSprite.bitmap = ImageManager.loadPicture('ui/button/page_next_btn_disabled');
    } else {
      this.nextBtnSprite.bitmap = ImageManager.loadPicture('ui/button/page_next_btn');
    }

    // 数字翻页器
    for (let i = 0; i < this._maxPageCount; i++) {
      const _item = this._pageNumSpriteList[i];

      if (_item.autoSprite) {
        if (this._currentPageIndex === 0 && i <= 1) {
          _item.autoSprite.bitmap = ImageManager.loadPicture('ui/load/load_btn_auto');
        } else {
          _item.autoSprite.bitmap = ImageManager.loadPicture('ui/blank');
        }
      }

      if (this._currentPageIndex === i) {
        _item.bgSprite.bitmap = ImageManager.loadPicture('ui/button/page_num_item_active');
        if (_item.textSprite.bitmap.textColor !== '#ffffff') {
          _item.textSprite.bitmap.clear();
          _item.textSprite.bitmap.textColor = '#ffffff';
          _item.textSprite.bitmap.outlineColor = 'rgba(0,0,0,0)';
          _item.textSprite.bitmap.drawText((i + 1) + '', 0, 0, 50, 50, 'center');
        }
      } else {
        _item.bgSprite.bitmap = ImageManager.loadPicture('ui/button/page_num_item');
        if (_item.textSprite.bitmap.textColor !== '#fc8919') {
          _item.textSprite.bitmap.clear();
          _item.textSprite.bitmap.textColor = '#fc8919';
          _item.textSprite.bitmap.outlineColor = '#ffffff';
          _item.textSprite.bitmap.drawText((i + 1) + '', 0, 0, 50, 50, 'center');
        }
      }
    }
  };

  Scene_File.prototype.isFirstPage = function() {
    return this._currentPageIndex <= 0;
  };

  Scene_File.prototype.isLastPage = function() {
    return this._currentPageIndex >= this._maxPageCount - 1;
  };
  
  const Scene_File_update = Scene_File.prototype.update;
  Scene_File.prototype.update = function () {
    Scene_File_update.call(this);
    
    const _x = TouchInput.x;
    const _y = TouchInput.y;
    let _inAreaName = '';

    // 判断左右两侧按钮
    if (!_inAreaName && this.prevBtnSprite.inArea(_x, _y)) {
      _inAreaName = 'prev';
      if (!this.prevBtnSprite.isHover) {
        this.prevBtnSprite.isHover = true;
        SoundManager.playCursor();
        this.prevBtnSprite.bitmap = ImageManager.loadPicture(`ui/button/page_prev_btn_${this.isFirstPage() ? 'disabled' : 'active'}`);
      }
      if (TouchInput.isTriggered()) {
        if (this.isFirstPage()) {
          SoundManager.playBuzzer();
        } else {
          SoundManager.playOk();
          this.changePage(this._currentPageIndex - 1);
        }
      }
    } else if (this.prevBtnSprite.isHover) {
      this.prevBtnSprite.isHover = false;
      this.prevBtnSprite.bitmap = ImageManager.loadPicture(`ui/button/page_prev_btn${this.isFirstPage() ? '_disabled' : ''}`);
    }
    
    if (!_inAreaName && this.nextBtnSprite.inArea(_x, _y)) {
      _inAreaName = 'next';
      if (!this.nextBtnSprite.isHover) {
        this.nextBtnSprite.isHover = true;
        SoundManager.playCursor();
        this.nextBtnSprite.bitmap = ImageManager.loadPicture(`ui/button/page_next_btn_${this.isLastPage() ? 'disabled' : 'active'}`);
      }
      if (TouchInput.isTriggered()) {
        if (this.isLastPage()) {
          SoundManager.playBuzzer();
        } else {
          SoundManager.playOk();
          this.changePage(this._currentPageIndex + 1);
        }
      }
    } else if (this.nextBtnSprite.isHover) {
      this.nextBtnSprite.isHover = false;
      this.nextBtnSprite.bitmap = ImageManager.loadPicture(`ui/button/page_next_btn${this.isLastPage() ? '_disabled' : ''}`);
    }


    // 判断下方数字翻页器
    for (let i = 0; i < this._pageNumSpriteList.length; i++) {
      if (this._currentPageIndex === i) continue;

      const item = this._pageNumSpriteList[i];
      
      if (!_inAreaName && item.bgSprite.inArea(_x, _y)) {
        _inAreaName = 'page_' + (i + 1);
        if (!item.isHover) {
          item.isHover = true;
          SoundManager.playCursor();
          item.bgSprite.bitmap = ImageManager.loadPicture('ui/button/page_num_item_hover');
        }
        if (TouchInput.isTriggered()) {
          SoundManager.playOk();
          this.changePage(i);
        }
      } else if (item.isHover) {
        item.isHover = false;
        item.bgSprite.bitmap = ImageManager.loadPicture('ui/button/page_num_item');
      }
    }

    if (!this._listWindow.inArea(_x, _y)) {
      if (_inAreaName && Utils_Cursor.cursorType !== 'pointer') {
        Utils_Cursor.cursorType = 'pointer';
      } else if (!_inAreaName && Utils_Cursor.cursorType !== 'default') {
        Utils_Cursor.cursorType = 'default';
      }
    }
  }

  /**
   * 更新翻页组件
   */
  Scene_File.prototype.udpateSplitComponent = function() {

  }

  Scene_File.prototype.createTitle = function() {
    const _bitmapIcon = ImageManager.loadPicture(`ui/load/page_${this.mode() === 'save' ? 'save' : 'load'}_icon`);
    this._gameIconSprite = new Sprite(_bitmapIcon);
    this._gameIconSprite.x = 20;
    this._gameIconSprite.y = 12;
    this.addChild(this._gameIconSprite);
    
    const _bitmapTitle = ImageManager.loadPicture(`ui/title_txt/${this.mode() === 'save' ? 'save' : 'load'}_title_zh-CN`);
    this._gameTitleSprite = new Sprite(_bitmapTitle);
    this._gameTitleSprite.x = 85;
    this._gameTitleSprite.y = 30;
    this.addChild(this._gameTitleSprite);
  };
  
  Scene_File.prototype.createBackBtn = function() {
    const btn = new HakuComponent.Button({
      style: {
        backgroundImage: '/img/pictures/ui/common/btn_back'
      },
      'hover:style': {
        backgroundImage: '/img/pictures/ui/common/btn_back_active'
      },
      'tap:style': {
        backgroundImage: '/img/pictures/ui/common/btn_back_active'
      },
    });
    btn.width = 200;
    btn.height = 64;
    btn.x = 1090;
    btn.y = 20;
    btn.on('tap', () => {
      $gameSystem._tempEventType = undefined;
      $gameSystem._tempEventIndex = undefined;

      SoundManager.playCancel();
      SceneManager.pop();
    });
    this.addChild(btn);
  };

  Scene_File.prototype.listWindowRect = function () {
    const wx = 65;
    const wy = 126;
    const ww = Graphics.boxWidth - 150;
    const wh = 540;
    return new Rectangle(wx, wy, ww, wh);
  };

  Scene_File.prototype.createButtons = function () { };

  Scene_File.prototype.createBackground = function () {
    const _bitmap = ImageManager.loadPicture('ui/background');
    const _sprite = new Sprite(_bitmap);
    _sprite.x = 0;
    _sprite.y = 0;
    this.addChildAt(_sprite, 0);
  };

  Scene_File.prototype.createListWindow = function() {
    const rect = this.listWindowRect();
    this._listWindow = new Window_NewSavefileList(rect);
    this._listWindow.scene = this;
    this._listWindow.setHandler("ok", this.onSavefileOk.bind(this));
    this._listWindow.setHandler("cancel", this.popScene.bind(this));
    this._listWindow.setMode(this.mode(), this.needsAutosave());
    this._listWindow.selectSavefile(this.firstSavefileId());
    this._listWindow.refresh();
    this.addWindow(this._listWindow);
  };


  class Window_NewSavefileList extends Window_Selectable {

    initialize(rect) {
      this._list = [];
      Window_Selectable.prototype.initialize.call(this, rect);
      this.activate();
      this._pageIndex = 0;
      this.opacity = 0;
      this._mode = null;
      this._autosave = false;
      this._padding = 0;

      this.itemsContainer = new PIXI.Container();
      this.addChild(this.itemsContainer);
    }

    update() {
      if (this.scene && this.scene._listWindow) {
        if (Input.isTriggered('left')) {
          if (this._index === 0) {
            if (this.scene.isFirstPage()) {
              SoundManager.playBuzzer();
            } else {
              SoundManager.playOk();
              this.scene.changePage(this.scene._currentPageIndex - 1);
              useTimeout(() => {
                this.select(5);
              }, 2)
            }
          }
        } else if (Input.isTriggered('right')) {
          if (this._index === 5) {
            if (this.scene.isLastPage()) {
              SoundManager.playBuzzer();
            } else {
              SoundManager.playOk();
              this.scene.changePage(this.scene._currentPageIndex + 1);
              useTimeout(() => {
                this.select(0);
              }, 2)
            }
          }
        }
      }

      super.update();
    }

    /**
     * 设置页面索引
     * @param {number} index 
     */
    setPageIndex(index) {
      this._pageIndex = index;
      this._list = [];
      this.itemsContainer.removeChildren();
      this.refresh();
    }

    select(index) {
      if (index < 0) return;
      const _oldIndex = this._index;
      this._index = index;
      // this.refreshCursor();
      // this.callUpdateHelp();

      if (_oldIndex !== index) {
        const _item = this._list[index];
        if (_oldIndex >= 0 && index >= 0 && _item) {
          if (this._mode === "save" && (index >= 2 || this._pageIndex > 0) || this._mode === "load") {
            SoundManager.playCursor();
          }
        }
      }

      if (_oldIndex >= 0) {
        const _oldItem = this._list[_oldIndex];
        const _oldSpriteItem = this._list[_oldIndex];
        if (_oldIndex !== index && _oldItem) {
          if (this._mode === "save") {
            _oldSpriteItem.bgSprite.bitmap = ImageManager.loadPicture('ui/load/save_item_default_2');
          } else {
            _oldSpriteItem.bgSprite.bitmap = ImageManager.loadPicture('ui/load/load_item_default_2');
          }
        }
      }
      const _item = this._list[index];
      if (index >= 0 && _item) {
        if (this._mode === "save") {
          if (index >= 2 || this._pageIndex > 0) {
            this._list[index].bgSprite.bitmap = ImageManager.loadPicture('ui/load/save_item_active_2');
          } else {
            this._list[index].bgSprite.bitmap = ImageManager.loadPicture('ui/load/save_item_default_2');
          }
        } else {
          this._list[index].bgSprite.bitmap = ImageManager.loadPicture('ui/load/load_item_active_2');
        }
      }
    };
    maxCols() {
      return 2;
    };
    numVisibleRows() {
      return 3;
    };
    itemPadding() {
      return 0;
    };
    itemHeight() {
      return 170;
    };
    colSpacing() {
      return 70;
    };
    rowSpacing() {
      return 30;
    };
    maxItems() {
      return 6;
    }
    drawTitle(savefileId, x, y) {
      if (savefileId === 0) {
        this.drawText('每日自动保存', x, y, 180);
      } else if (savefileId === 1) {
        this.drawText('每周自动保存', x, y, 180);
      } else {
        this.drawText(TextManager.file + " " + savefileId, x, y, 180);
      }
    };
    redrawItem(index) {
      if (index >= 0) {
        this.clearItem(index);
        this.drawItem(index);
        this.drawItemBackground(index);
      }
    };
    drawItemBackground(index) {}

    drawItem(index) {
      this.contentsBack.clear();
      const savefileId = this.indexToSavefileId(index);
      const info = DataManager.savefileInfo(savefileId);

      const rect = this.itemRectWithPadding(index);
      
      let _bitmap;
      if (this._mode === "save") {
        if (index === 0) {
          _bitmap = ImageManager.loadPicture('ui/load/save_item_default_2');
        } else if (this._index === index) {
          _bitmap = ImageManager.loadPicture('ui/load/save_item_active_2');
        } else {
          _bitmap = ImageManager.loadPicture('ui/load/save_item_default_2');
        }
      } else {
        if (this._index === index) {
          _bitmap = ImageManager.loadPicture('ui/load/load_item_active_2');
        } else {
          _bitmap = ImageManager.loadPicture('ui/load/load_item_default_2');
        }
      }
      const _bgSprite = new Sprite(_bitmap);
      _bgSprite.x = rect.x;
      _bgSprite.y = rect.y;
      this.itemsContainer.addChild(_bgSprite);


      const _fgSprite = new Sprite(new Bitmap(rect.width, rect.height));
      _fgSprite.x = rect.x;
      _fgSprite.y = rect.y;
  
      this.resetTextColor();

      _fgSprite.bitmap.fontFace = "Source Han Sans VF";
      _fgSprite.bitmap.textColor = "#665258";
      _fgSprite.bitmap.fontBold = true;
      _fgSprite.bitmap.fontSize = 20;
      _fgSprite.bitmap.outlineWidth = 4;
      _fgSprite.bitmap.outlineColor = "white";

      if (savefileId === 101) {
        _fgSprite.bitmap.drawText('自动保存 - 每日', rect.width / 2 - 180, 4, 410, 40, 'right');
      } else if (savefileId === 102) {
        _fgSprite.bitmap.drawText('自动保存 - 每周', rect.width / 2 - 180, 4, 410, 40, 'right');
      } else {
        _fgSprite.bitmap.drawText(TranslateUtils.getText(TextManager.file) + " " + savefileId, rect.width / 2 - 180, 4, 410, 40, 'right');
      }

      if (info) {
        this.drawContents(_fgSprite.bitmap, info, rect);
      }
      
      const _autoSprite = new Sprite();
      _autoSprite.x = rect.x - 30;
      _autoSprite.y = rect.y - 30;
      if (savefileId >= 100) {
        _autoSprite.bitmap = ImageManager.loadPicture('ui/load/load_btn_auto');
      } else {
        _autoSprite.bitmap = ImageManager.loadPicture('ui/blank');
      }
      this.itemsContainer.addChild(_autoSprite);
      
      this._list[index] = { bgSprite: _bgSprite, fgSprite: _fgSprite, autoSprite: _autoSprite };
      this.itemsContainer.addChild(_fgSprite);
      
      _bitmap.addLoadListener(() => {
        _bgSprite.bitmap.paintOpacity = this.isEnabled(savefileId) ? 255 : 150;
        _fgSprite.bitmap.paintOpacity = this.isEnabled(savefileId) ? 255 : 150;
      });

      if (info && info.screenShot) {
        const _screenShotSprite = new Sprite(Bitmap.load(info.screenShot));
        _screenShotSprite.scale.x = 0.8;
        _screenShotSprite.scale.y = 0.8;
        _screenShotSprite.x = rect.x + 30;
        _screenShotSprite.y = rect.y + 21;
        this.itemsContainer.addChild(_screenShotSprite);
      }
    }

    setMode(mode, autosave) {
      this._mode = mode;
      this._autosave = autosave;
      this.refresh();
    }

    indexToSavefileId(index) {
      if (this._pageIndex === 0 && index < 2) {
        return 100 + (index + 1);
      } else {
        return index + this._pageIndex * 6;
      }
    }

    savefileIdToIndex(savefileId) {
      return savefileId;
    }

    // isHoverEnabled() {
    //   return this._mode === "save" ? this.index() > 0 : true;
    // }

    isOkEnabled() {
      return this.isHandled("ok");
    }

    isCurrentItemEnabled() {
      if (this._mode === "save") {
        return this.index() + this._pageIndex * 6 >= 2;
      } else {
        return true;
      }
    }

    isEnabled(savefileId) {
      if (this._mode === "save") {
        return savefileId >= 1;
      } else {
        return !!DataManager.savefileInfo(savefileId);
      }
    }

    savefileId() {
      return this.indexToSavefileId(this.index());
    }
    
    selectSavefile(savefileId) {
      const index = Math.max(0, this.savefileIdToIndex(savefileId));
      if (index >= 100) {
        this.select(savefileId - 101);
      } else {
        const _page = Math.floor(index / 6);
        const _index = index % 6;
        this.scene.changePage(_page);
        this.select(_index);
      }
      // this.setTopRow(index - 2);
    }
    
    drawContents(bitmap, info, rect) {
      const bottom = rect.height;

      // TODO: 这块逻辑没太明白
      const lineHeight = this.lineHeight();
      const y2 = bottom - lineHeight - 60;
      if (y2 >= lineHeight) {
        this.drawPlaytime(bitmap, info, 0, y2, rect.width);
        
        this.drawInfo(bitmap, info, 0, y2, rect.width);
      }
    }
    
    drawPartyCharacters(info, x, y) {
      if (info.characters) {
        let characterX = x;
        for (const data of info.characters) {
          this.drawCharacter(data[0], data[1], characterX, y);
          characterX += 48;
        }
      }
    }
    
    /**
     * 绘制时间
     */
    drawPlaytime(bitmap, info, x, y, width) {
      if (info.timestamp) {
        bitmap.fontSize = 20;
        bitmap.drawText(new Date(info.timestamp).toLocaleString(), x + 225, y, width - 225, 40, "left");
      }
    }
    
    /**
     * 绘制金钱、体力、好感度、态度
     */
    drawInfo(bitmap, info, x, y, width) {
      const _iconWidth = 36;
      
      bitmap.fontSize = 20;
      // 日期
      bitmap.bltImg('ui/icon/icon_state_date', undefined, {
        x: x + 220, y: y + 45 + 2, width: _iconWidth, height: _iconWidth,
      });
      bitmap.drawText(TranslateUtils.getText(`第$1天`, info.day) + ' ' + info.timeStr, x + 40 + 220, y + 45, 100, 40, "left");
      
      // 加奈好感度
      bitmap.bltImg('ui/icon/icon_state_heart2', undefined, {
        x: x + 400, y: y + 45 + 2, width: _iconWidth, height: _iconWidth,
      });
      bitmap.drawText('' + info.kanaFavor, x + 40 + 400, y + 45, 100, 40, "left");
    }
    
    playOkSound() {
      //
    }

  }

  // #endregion


  // #region 存档场景窗口相关



  // #endregion


  // #region 存档场景选项窗口相关


  // #endregion


})();