//=============================================================================
// ** RPG Maker MZ - Scene_Haku_Shop.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 商店页场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /** 男主行为菜单 */
  const __actorMenus = [
    {
      name: '随便聊聊',
      text: '随便聊聊',
      icon: 'icon_chat',
      tooltip: '和千夏增进感情的良好时机哦～今天又有哪些趣事和千夏分享呢？',
      get disabled() { return Utils_Actor.live < 10; },
      onTap() {
        // 和千夏聊天
        $gameData.isEventBusy = true;
        $gameTemp.reserveCommonEvent(261);
      }
    }, {
      name: '打工',
      text: '打工',
      icon: 'icon_coin_plus',
      tooltip: '赚钱之后应该做点什么好呢？',
      get disabled() {
        return Utils_Time.hour < 8 || Utils_Time.hour > 14 || Utils_Actor.live < 20;
      },
      get visible() {
        return $gameSwitches.value(4) === true && Utils_Scene.sameChinatsu();
      },
      onTap() {
        this._isBusy = true;
        this.actorMenuContainer.visible = false;
        Utils_Actor.live -= 20;
        Utils_Favor.chinatsuFavor += 1;
        Utils_Time.timeElapse(240, {
          mask: true,
          force: true,
          delay: 5,
          qImages: ['q/q_work1_1', 'q/q_work1_2'],
          callback: () => {
            AudioManager.playSe({ name: 'get-money-2', volume: 100, pitch: 100, pan: 0 });
            this.actorMenuContainer.visible = true;
            const _gold = 1500 * Utils_Actor.makeMoneyRate * (1 + Utils_Favor.chinatsuFavorLevel * 0.2);
            $gameParty.gainGold(_gold);
            this._isBusy = false;
          }
        });
      }
    }, {
      name: '买点什么',
      text: '买点什么',
      icon: 'icon_shopping',
      tooltip: '要不要给千夏带点礼物呢？',
      get disabled() { return false; },
      get visible() {
        return Utils_Scene.sameChinatsu();
      },
      onTap() {
        SceneManager._scene.moneyContainer.alpha = 0;
        
        startTalk([
          { text: '哥哥要买点什么吗？', name: '千夏', face: '' }
        ], [], () => {
          SceneManager.push(Scene_Haku_BuyGoods);
        });
      }
    }, {
      name: '使用道具',
      text: '使用道具',
      icon: 'icon_box',
      get tooltip() {
        return '看看还有些什么可以用的东西…';
      },
      get disabled() { return false; },
      onTap() {
        SceneManager.push(Scene_Haku_Item);
      }
    }, {
      name: '离开',
      text: '离开',
      icon: 'icon_goout',
      tooltip: '那就先离开吧',
      onTap() {
        if (Utils_Scene.sameChinatsu()) {
          this.showTachie();
          startTalk(Utils_ChatMessage.getChat('千夏-路上小心'), [], () => {
            Utils_Scene.changeScene({ sceneName: 'scene_map' });
          });
        } else {
          Utils_Scene.changeScene({ sceneName: 'scene_map' });
        }
      }
    }
  ];



  /**
   * 商店场景
   */
  class Scene_Haku_Shop extends Scene_MainScene {
    initialize() {
      super.initialize();

      this._banLocChange = false;
    }

    /** 是否显示千夏的立绘 */
    get visibleTachie() {
      return this.spine ? this.spine.alpha === 1 : false;
    }
    set visibleTachie(value) {
      if (this._banLocChange) return;

      if (this.spine) {
        this.spine.alpha = value ? 1 : 0;

        
        const _info = $gameData.tempSceneInfo;
        const _spineName = this.spine.spineInfo.spineName;

        if (value) {
          if (_info.spineInfos[_spineName]) {
            _info.spineInfos[_spineName].visible = true;
            _info.spineInfos[_spineName].alpha = 1;
            if (!_info.spineList.includes(_spineName)) _info.spineList.push(_spineName);
          }
        } else {
          if (_info.spineInfos[_spineName]) {
            _info.spineInfos[_spineName].visible = false;
            _info.spineInfos[_spineName].alpha = 0;
            const _index = _info.spineList.findIndex(i => i ===_spineName);
            if (_index >= 0) _info.spineList.splice(_index, 1);
          }
        }
      }
    }

    gotoScene() {
      if (!$gameData.isEventBusy) {
        this.showTachie();
        // this.visibleTachie = true;
      }
    }

    create() {
      super.create();

      if (!$gameData.isEventBusy || $gameSystem._savedTachie) {
        this.showTachie();
      }

      // if ($gameSystem._savedTachie) {
      //   this.changeSisterLoc('stand');
      //   this.visibleSisterTachie = true;
      //   this.visibleSisterTachieMenu = true;
      //   $gameSystem.resetTachie();
      // }
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      /** 男主行为菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.actorMenus = __actorMenus;
    }

    update() {
      super.update();

    }
  }
  window.Scene_Haku_Shop = Scene_Haku_Shop;

})();