//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene_State.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 妹妹的状态场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /**
   * 妹妹的状态场景
   */
  class Scene_Haku_State extends Scene_Game {
    initialize() {
      super.initialize();

      this._disabledFade = true;

      /** 当前页数 */
      this.pageIndex = 0;
      /** 最大页数 */
      this.maxPageCount = 4;
      /** 标签列表 */
      this.tagList = [
        { name: '加奈', index: 0, pageIndex: 0, bgSprite: undefined, textSprite: undefined },
        { name: '千夏', index: 1, pageIndex: 2, bgSprite: undefined, textSprite: undefined },
        { name: '由纪', index: 1, pageIndex: 3, bgSprite: undefined, textSprite: undefined },
        { name: '艾露', index: 1, pageIndex: 4, bgSprite: undefined, textSprite: undefined },
      ];

      this.animeInOutInfo = useAnime({
        frameDelay: 0,
        frameCount: 30,
        easingType: 'Quadratic',
        inout: 'InOut',
      }, progress => {
        if (this.animeType === 'in') {
          this.mainContainer.y = parseInt(-(1 - progress) * 20);
          this.mainContainer.alpha = progress;
          this._backgroundSprite.opacity = 255 - progress * 80;
        } else if (this.animeType === 'out') {
          this.mainContainer.alpha = 1 - progress;
          this.mainContainer.y = parseInt(-progress * 20);
          this._backgroundSprite.opacity = 255 - 80 + progress * 80;
          if (progress >= 1) {
            $gameSystem.enableMenu();
            SceneManager.pop();
            setTimeout(() => {
              SceneManager._scene._useMask = false;
            }, 50);
          }
        }
      });

      this.animeType = 'in';
      this.animeInOutInfo.start();
    }

    create() {
      $gameSystem.disableMenu();
      super.create();
      this.createBackground();
      this.createPagination();
      this.createCloseButton();
      // this.createStateWindow();

      this.changePage();
    }

    update() {
      super.update();

      this.animeInOutInfo.update();

      if (TouchInput.isCancelled() || Input.isTriggered('cancel')) {
        SoundManager.playCancel();
        this.animeInOutInfo.start();
        this.animeType = 'out';
      }


      // #region 点击左侧书签



      // #endregion
    }

    setBackgroundOpacity(opacity) {
      this._backgroundSprite.opacity = opacity;
    }

    /**
     * 是否为第一页
     * @param {number} pageIndex
     * @return {boolean}
     */
    isFirstPage(pageIndex) {
      return (pageIndex === undefined ? this.pageIndex : pageIndex) === 0;
    }
    /**
     * 是否为最后一页
     * @param {number} pageIndex
     * @return {boolean}
     */
    isLastPage(pageIndex) {
      return (pageIndex === undefined ? this.pageIndex : pageIndex) === 4;
    }

    /** 创建关闭按钮 */
    createCloseButton() {
      this._closeButton = new HakuSprite({
        x: 1094, y: 40,
        useHover: true,
        normalBitmap: ImageManager.loadPicture('ui/close_button'),
        hoverBitmap: ImageManager.loadPicture('ui/close_button_active'),
        onTap: () => {
          SoundManager.playCancel();
          this.animeInOutInfo.start();
          this.animeType = 'out';
        }
      });
      this.mainContainer.addChild(this._closeButton);
    }

    /** 创建翻页器 */
    createPagination() {
      if (this.paginationContainer && this.paginationContainer.parent) {
        this.mainContainer.paginationContainer.removeChildren();
      } else {
        this.paginationContainer = new PIXI.Container();
        this.mainContainer.addChild(this.paginationContainer);
      }

      // 左翻页按钮
      this._arrowLeftSprite = new HakuSprite({
        x: 200, y: 285, me: this,
        useHover: true,
        normalBitmap: 'ui/state/arrow_left',
        hoverBitmap: 'ui/state/arrow_left_active',
        disabledBitmap: 'ui/state/arrow_left_disabled',
        disabled() { return this.isFirstPage() },
        onTap: () => {
          this.pageIndex--;
          SoundManager.playOk();
          this._arrowLeftSprite.refresh();
          this._arrowRightSprite.refresh();
          this.changePage();
        }
      });
      this.mainContainer.addChild(this._arrowLeftSprite);
      
      this._arrowRightSprite = new HakuSprite({
        x: this.width - 304, y: 285, me: this,
        useHover: true,
        normalBitmap: 'ui/state/arrow_right',
        hoverBitmap: 'ui/state/arrow_right_active',
        disabledBitmap: 'ui/state/arrow_right_disabled',
        disabled() { return this.isLastPage() },
        onTap: () => {
          this.pageIndex++;
          SoundManager.playOk();
          this._arrowLeftSprite.refresh();
          this._arrowRightSprite.refresh();
          this.changePage();
        }
      });
      this.mainContainer.addChild(this._arrowRightSprite);
    }

    /** 半透明背景 */
    createBackground() {
      // this._backgroundFilter = new PIXI.filters.BlurFilter();
      this._backgroundSprite = new Sprite();
      this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
      this._backgroundSprite.filters = []; // this._backgroundFilter
      this.addChildAt(this._backgroundSprite, 0);

      this.mainContainer = new HakuContainer();
      this.mainContainer.alpha = 0;
      this.addChildAt(this.mainContainer, 1);

      // 添加背部侧边卡片
      this._slidebarSprite = new Sprite(ImageManager.loadPicture('ui/state/background_slidebar'));
      this.mainContainer.addChild(this._slidebarSprite);

      this.slidebarContainer = new HakuContainer();
      this.mainContainer.addChild(this.slidebarContainer);

      this.createTags();

      this.bgContainer = new PIXI.Container();
      this.mainContainer.addChild(this.bgContainer);

      this.contentContainer = new PIXI.Container();
      this.mainContainer.addChild(this.contentContainer);

      this.fgContainer = new PIXI.Container();
      this.mainContainer.addChild(this.fgContainer);

      // 添加背景
      this._mainBgSprite = new Sprite();
      this.bgContainer.addChild(this._mainBgSprite);

      // 添加内容
      this._contentSprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
      this._contentBitmap = this._contentSprite.bitmap;
      this.contentContainer.addChild(this._contentSprite);

      // 添加前景
      this._mainFgSprite = new Sprite();
      this.fgContainer.addChild(this._mainFgSprite);

      // 添加顶级文字
      this._topTextSprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
      this._topTextBitmap = this._topTextSprite.bitmap;
      this.fgContainer.addChild(this._topTextSprite);
    }

    /** 获取标题页名称 */
    get titleName() {
      return ['加奈', '加奈', '千夏', '由纪', '艾露'][this.pageIndex];
    }

    /** 获取成就列表 */
    get achievements() {
      return Utils_State.getAchievements();
    }

    /**
     * 切换页面
     */
    changePage() {
      this._contentBitmap.clear();
      this._topTextBitmap.clear();
      this._mainFgSprite.bitmap = ImageManager.loadPicture('blank');
      
      // 页面基础信息
      this._topTextBitmap.fontFace = 'ChillRoundF';
      this._contentBitmap.fontSize = 20;
      this._contentBitmap.textColor = '#8e6a5b';
      this._contentBitmap.outlineColor = 'rgba(0,0,0,0)';
      const _noTextWidth = this._contentBitmap.measureTextWidth(`No.01 - `);
      const _noText = this.pageIndex < 2 ? 1 : this.pageIndex;

      this._contentBitmap.drawText(`No.0${_noText} - `, 260, 38, 300, 30, 'left');
      this._contentBitmap.drawText(this.titleName, 260 + _noTextWidth, 38, 300, 30, 'left');
      
      this._contentBitmap.drawText(`No.0${_noText}`, 716, 38, 300, 30, 'right');

      // 第一页
      if (this.pageIndex === 0) {
        this._mainBgSprite.bitmap = ImageManager.loadPicture('ui/state/background_1');

        this._contentBitmap.bltImg('ui/state/tachie/kana_1', undefined, { x: 310, y: 85, width: 265, height: 551, clear: false });
        this._contentBitmap.bltImg('ui/state/mini-cg/cg1_1', undefined, { x: 657, y: 26, width: 318, height: 270, clear: false });

        const _level = Utils_Favor.getKanaFavorLevel(Utils_Favor.kanaFavor);
        this._contentBitmap.bltImg(`ui/state/level_${_level}`, undefined, { x: 253, y: 79, width: 80, height: 80, clear: false });
        
        this._mainFgSprite.bitmap = ImageManager.loadPicture('ui/state/foreground_1');

        this._contentBitmap.fontSize = 20;
        this._contentBitmap.textColor = 'white';
        this._contentBitmap.outlineColor = '#8e6a5b';
        this._contentBitmap.outlineWidth = 4;
        this._contentBitmap.drawText(`对${$gameActors.actor(1)._name}的评价`, 698, 320, 200, 30, 'left');
        this._contentBitmap.drawText(`此刻的想法`, 698, 439, 200, 30, 'left');
        
        
        this._contentBitmap.fontSize = 18;
        this._contentBitmap.textColor = '#8e6a5b';
        this._contentBitmap.outlineColor = 'rgba(0,0,0,0)';
        // 对哥哥的评价
        this._contentSprite.drawTextEx(Utils_State.kanaEaluate, 668, 362, 320);
        // 此刻的想法
        Utils_State.kanaThought.split('\n').forEach((line, index) => {
          this._contentSprite.drawTextEx(line, 668, 482 + index * 34, 320);
        });

        // 加奈的信息
        this._topTextBitmap.fontSize = 26;
        this._topTextBitmap.textColor = 'white';
        this._topTextBitmap.outlineColor = '#8e6a5b';
        this._topTextBitmap.outlineWidth = 6;
        this._topTextBitmap.drawText(this.titleName, 270, 580, 130, 30, 'center');
        
        this._topTextBitmap.fontSize = 20;
        this._topTextBitmap.textColor = '#8e6a5b';
        this._topTextBitmap.outlineColor = 'rgba(0,0,0,0)';
        this._topTextBitmap.drawText('好感度', 380, 565, 120, 30, 'right');
        this._topTextBitmap.drawText('性欲', 380, 595, 120, 30, 'right');
        this._topTextBitmap.fontBold = true;
        this._topTextBitmap.drawText(`${Utils_Favor.kanaStageFavor} / ${Utils_Favor.kanaStageMaxFavor}`, 510, 565, 120, 30, 'left');
        this._topTextBitmap.drawText(`${Utils_Favor.kanaSex} / ${Utils_Favor.kanaMaxSex}`, 510, 595, 120, 30, 'left');
      } else if (this.pageIndex === 1) {

        this._mainBgSprite.bitmap = ImageManager.loadPicture('ui/state/background_2');

        this._contentBitmap.fontSize = 20;
        this._contentBitmap.textColor = '#FFFFFF';
        this._contentBitmap.outlineColor = '#8e6a5b';
        this._contentBitmap.outlineWidth = 4;
        this._contentBitmap.drawText(`已获得的成就`, 310, 100, 200, 30, 'left');
        this._contentBitmap.drawText(`部位开发度`, 310, 418, 200, 30, 'left');
        
        this._contentBitmap.fontSize = 26;
        this._contentBitmap.drawText(`口部`, 268, 497, 170, 30, 'center');
        this._contentBitmap.drawText(`小穴`, 658, 115, 170, 30, 'center');
        this._contentBitmap.drawText(`胸部`, 839, 309, 170, 30, 'center');
        this._contentBitmap.drawText(`臀部`, 658, 497, 170, 30, 'center');
        
        // 成就列表
        let _x = 278;
        let _currentLine = 0;
        if (!this.achievements.length) {
          this._contentBitmap.fontSize = 16;
          this._contentBitmap.textColor = '#FFFFFF';
          this._contentBitmap.outlineColor = '#8e6a5b';
          this._contentBitmap.outlineWidth = 4;
          this._contentBitmap.drawText('暂未获得任何成就', _x, 160, 330, 24, 'center');
        } else {
          this._contentBitmap.fontSize = 16;
          this._contentBitmap.textColor = '#8e6a5b';
          this._contentBitmap.outlineColor = 'rgba(0,0,0,0)';
          for (let i = 0; i < this.achievements.length; i++) {
            const _item = this.achievements[i];
            
            this._contentBitmap.bltImg('ui/state/icon_heart', undefined, {
              x: _x + (i % 2 === 1 ? 180 : 0), 
              y: 153 + _currentLine * 34 + 2, 
              width: 24,
              height: 21
            });
            this._contentBitmap.drawText(_item.title, _x + (i % 2 === 1 ? 180 : 0) + 30, 153 + _currentLine * 34, 150, 24, 'left');
            
            if (i % 2 === 1) {
              _currentLine++;
            }
          }
        }

        // 次数和开发度
        
        const _countWidth = this._contentBitmap.measureTextWidth('次数：');
        const _degreeWidth = this._contentBitmap.measureTextWidth('开发度：');

        // 口部
        this._contentBitmap.drawText(`次数：`, 306, 555, 250, 30, 'left');
        this._contentBitmap.drawText(`开发度：`, 306, 586, 250, 30, 'left');
        // 口部数据
        this._contentBitmap.drawText(TranslateUtils.getText(`$1次`, [Utils_Favor.kanaSexCount('mouth')]), 306 + _countWidth, 555, 250, 30, 'left');
        this._contentBitmap.drawText(`${Math.floor(Utils_Favor.kanaSexEx('mouth') / 2)}%`, 306 + _degreeWidth, 586, 250, 30, 'left');
        // 口部图片
        this._contentBitmap.bltImg(`ui/state/part/mouth_${Utils_Favor.kanaSexLevelImg('mouth')}`, undefined, { x: 452, y: 465, width: 172, height: 172, clear: false });

        // 小穴
        this._contentBitmap.drawText(`次数：`, 694, 173, 250, 30, 'left');
        this._contentBitmap.drawText(`开发度：`, 694, 205, 250, 30, 'left');
        // 小穴数据
        this._contentBitmap.drawText(TranslateUtils.getText(`$1次`, [Utils_Favor.kanaSexCount('pussy')]), 694 + _countWidth, 173, 250, 30, 'left');
        this._contentBitmap.drawText(`${Math.floor(Utils_Favor.kanaSexEx('pussy') / 2)}%`, 694 + _degreeWidth, 205, 250, 30, 'left');
        // 小穴图片
        this._contentBitmap.bltImg(`ui/state/part/pussy_${Utils_Favor.kanaSexLevelImg('pussy')}`, undefined, { x: 845, y: 81, width: 172, height: 172, clear: false });

        // 胸部
        this._contentBitmap.drawText(`次数：`, 863, 367, 250, 30, 'left');
        this._contentBitmap.drawText(`开发度：`, 863, 399, 250, 30, 'left');
        // 胸部数据
        this._contentBitmap.drawText(TranslateUtils.getText(`$1次`, [Utils_Favor.kanaSexCount('chest')]), 863 + _countWidth, 367, 250, 30, 'left');
        this._contentBitmap.drawText(`${Math.floor(Utils_Favor.kanaSexEx('chest') / 2)}%`, 863 + _degreeWidth, 399, 250, 30, 'left');
        // 胸部图片
        this._contentBitmap.bltImg(`ui/state/part/chest_${Utils_Favor.kanaSexLevelImg('chest')}`, undefined, { x: 651, y: 277, width: 172, height: 172, clear: false });

        // 臀部
        this._contentBitmap.drawText(`次数：`, 694, 556, 250, 30, 'left');
        this._contentBitmap.drawText(`开发度：`, 694, 587, 250, 30, 'left');
        // 臀部数据
        this._contentBitmap.drawText(TranslateUtils.getText(`$1次`, [Utils_Favor.kanaSexCount('ass')]), 694 + _countWidth, 556, 250, 30, 'left');
        this._contentBitmap.drawText(`${Math.floor(Utils_Favor.kanaSexEx('ass') / 2)}%`, 694 + _degreeWidth, 587, 250, 30, 'left');
        // 臀部图片
        this._contentBitmap.bltImg(`ui/state/part/ass_${Utils_Favor.kanaSexLevelImg('ass')}`, undefined, { x: 844, y: 465, width: 172, height: 172, clear: false });
      } else if (this.pageIndex === 2) {
        // 千夏

        this._mainBgSprite.bitmap = ImageManager.loadPicture('ui/state/background_3');

        this._contentBitmap.bltImg('ui/state/tachie/chinatsu_3', undefined, { x: 243, y: 85, width: 400, height: 551, clear: false });

        const _level = Utils_Favor.getElseFavorLevel(Utils_Favor.chinatsuFavor);
        this._contentBitmap.bltImg(`ui/state/level_${_level}`, undefined, { x: 253, y: 79, width: 80, height: 80, clear: false });
        
        this._mainFgSprite.bitmap = ImageManager.loadPicture('ui/state/foreground_3');

        this._contentBitmap.fontSize = 20;
        this._contentBitmap.textColor = 'white';
        this._contentBitmap.outlineColor = '#8e6a5b';
        this._contentBitmap.outlineWidth = 4;
        this._contentBitmap.drawText(`对${$gameActors.actor(1)._name}的评价`, 698, 354, 300, 30, 'left');
        
        // 对哥哥的评价
        this._contentBitmap.fontSize = 18;
        this._contentBitmap.textColor = '#8e6a5b';
        this._contentBitmap.outlineColor = 'rgba(0,0,0,0)';
        this._contentSprite.drawTextEx(Utils_State.chinatsuEaluate, 670, 398, 320);
        

        // 千夏的信息
        this._topTextBitmap.fontSize = 26;
        this._topTextBitmap.textColor = 'white';
        this._topTextBitmap.outlineColor = '#8e6a5b';
        this._topTextBitmap.outlineWidth = 6;
        this._topTextBitmap.drawText(this.titleName, 270, 581, 130, 30, 'center');
        
        this._topTextBitmap.fontSize = 20;
        this._topTextBitmap.textColor = '#8e6a5b';
        this._topTextBitmap.outlineColor = 'rgba(0,0,0,0)';
        this._topTextBitmap.drawText('好感度', 380, 580, 120, 30, 'right');
        this._topTextBitmap.fontBold = true;
        this._topTextBitmap.drawText(`${Utils_Favor.chinatsuFavor} / 100`, 510, 580, 120, 30, 'left');

        // 迷你CG照片
        if (DataManager.isClearScene('5-1')) {
          this._contentBitmap.bltImg('ui/state/mini-cg/cg5_1', undefined, { x: 660, y: 50, width: 337, height: 293, clear: false });
        }
      } else if (this.pageIndex === 3) {
        // 由纪

        this._mainBgSprite.bitmap = ImageManager.loadPicture('ui/state/background_3');

        this._contentBitmap.bltImg('ui/state/tachie/yuki_1', undefined, { x: 285, y: 77, width: 325, height: 514, clear: false });
        // this._contentBitmap.bltImg('ui/state/mini-cg/cg3_1', undefined, { x: 660, y: 50, width: 338, height: 293, clear: false });

        const _level = Utils_Favor.getElseFavorLevel(Utils_Favor.yukiFavor);
        this._contentBitmap.bltImg(`ui/state/level_${_level}`, undefined, { x: 253, y: 79, width: 80, height: 80, clear: false });
        
        this._mainFgSprite.bitmap = ImageManager.loadPicture('ui/state/foreground_4');

        this._contentBitmap.fontSize = 20;
        this._contentBitmap.textColor = 'white';
        this._contentBitmap.outlineColor = '#8e6a5b';
        this._contentBitmap.outlineWidth = 4;
        this._contentBitmap.drawText(`对${$gameActors.actor(1)._name}的评价`, 698, 354, 300, 30, 'left');
        
        // 对哥哥的评价
        this._contentBitmap.fontSize = 18;
        this._contentBitmap.textColor = '#8e6a5b';
        this._contentBitmap.outlineColor = 'rgba(0,0,0,0)';
        this._contentSprite.drawTextEx(Utils_State.yukiEaluate, 670, 398, 320);

        // 由纪的信息
        this._topTextBitmap.fontSize = 26;
        this._topTextBitmap.textColor = 'white';
        this._topTextBitmap.outlineColor = '#8e6a5b';
        this._topTextBitmap.outlineWidth = 6;
        this._topTextBitmap.drawText(this.titleName, 270, 581, 130, 30, 'center');
        
        this._topTextBitmap.fontSize = 20;
        this._topTextBitmap.textColor = '#8e6a5b';
        this._topTextBitmap.outlineColor = 'rgba(0,0,0,0)';
        this._topTextBitmap.drawText('好感度', 380, 580, 120, 30, 'right');
        this._topTextBitmap.fontBold = true;
        this._topTextBitmap.drawText(`${Utils_Favor.yukiFavor} / 100`, 510, 580, 120, 30, 'left');
        
        // 迷你CG照片
        if (DataManager.isClearScene('6-1')) {
          this._contentBitmap.bltImg('ui/state/mini-cg/cg6_1', undefined, { x: 680, y: 85, width: 295, height: 236, clear: false });
        }
      } else if (this.pageIndex === 4) {
        // 艾露

        this._mainBgSprite.bitmap = ImageManager.loadPicture('ui/state/background_3');

        this._contentBitmap.bltImg('ui/state/tachie/ere_1', undefined, { x: 305, y: 91, width: 270, height: 503, clear: false });
        // this._contentBitmap.bltImg('ui/state/mini-cg/cg3_1', undefined, { x: 660, y: 50, width: 338, height: 293, clear: false });

        const _level = Utils_Favor.getElseFavorLevel(Utils_Favor.ereFavor);
        this._contentBitmap.bltImg(`ui/state/level_${_level}`, undefined, { x: 253, y: 79, width: 80, height: 80, clear: false });
        
        this._mainFgSprite.bitmap = ImageManager.loadPicture('ui/state/foreground_5');

        this._contentBitmap.fontSize = 20;
        this._contentBitmap.textColor = 'white';
        this._contentBitmap.outlineColor = '#8e6a5b';
        this._contentBitmap.outlineWidth = 4;
        this._contentBitmap.drawText(`对${$gameActors.actor(1)._name}的评价`, 698, 354, 300, 30, 'left');
        
        // 对哥哥的评价
        this._contentBitmap.fontSize = 18;
        this._contentBitmap.textColor = '#8e6a5b';
        this._contentBitmap.outlineColor = 'rgba(0,0,0,0)';
        this._contentSprite.drawTextEx(Utils_State.ereEaluate, 670, 398, 320);
        

        // 艾露的信息
        this._topTextBitmap.fontSize = 26;
        this._topTextBitmap.textColor = 'white';
        this._topTextBitmap.outlineColor = '#8e6a5b';
        this._topTextBitmap.outlineWidth = 6;
        this._topTextBitmap.drawText(this.titleName, 270, 581, 130, 30, 'center');
        
        this._topTextBitmap.fontSize = 20;
        this._topTextBitmap.textColor = '#8e6a5b';
        this._topTextBitmap.outlineColor = 'rgba(0,0,0,0)';
        this._topTextBitmap.drawText('好感度', 380, 580, 120, 30, 'right');
        this._topTextBitmap.fontBold = true;
        this._topTextBitmap.drawText(`${Utils_Favor.ereFavor} / 100`, 510, 580, 120, 30, 'left');
        
        // 迷你CG照片
        if (DataManager.isClearScene('7-1')) {
          this._contentBitmap.bltImg('ui/state/mini-cg/cg7_1', undefined, { x: 670, y: 65, width: 321, height: 268, clear: false });
        }
      }
    }

    get tagIndex() {
      let _currentIndex = 0;
      if (this.pageIndex === 0 || this.pageIndex === 1) _currentIndex = 0;
      else _currentIndex = this.pageIndex - 1;

      return _currentIndex;
    }

    /**
     * 创建左侧切换人物的标签纸
     */
    createTags() {
      if (this.slidebarContainer) {
        this.slidebarContainer.removeChildren();
      }

      for (let i = 0; i < this.tagList.length; i++) {
        const item = this.tagList[i];

        const _itemContainer = new HakuContainer({
          useHover: true, x: 78, y: 70 + i * 73, width: 130, me: this,
          onTap() {
            if (this.me.tagIndex === this.index) return;

            SoundManager.playOk();
            if (this.index === 0) {
              this.me.pageIndex = 0;
            } else {
              this.me.pageIndex = this.index + 1;
            }
            this.me.changePage();
            this.me._arrowLeftSprite.refresh();
            this.me._arrowRightSprite.refresh();
          },
          update() {
            if (this.me.tagIndex === this.index) {
              item.bgSprite.bitmap = ImageManager.loadPicture(`ui/state/tag_${this.index <= 1 ? 1 : this.index}_active`);
              item.textSprite.bitmap.outlineColor = item.disabled ? '#777777' : '#8e5b65';
              if (this.x !== 40) this.x = 40;
            } else {
              item.bgSprite.bitmap = ImageManager.loadPicture(`ui/state/tag_${this.index <= 1 ? 1 : this.index}`);
              item.textSprite.bitmap.outlineColor = item.disabled ? '#777777' : '#8e6a5b';
              if (this.x !== 78) this.x = 78;
            }
            item.textSprite.bitmap.drawText(item.name, 0, 0, 140, 65, 'center');
          }
        });
        _itemContainer.index = i;
        
        const _itemSprite = new Sprite(ImageManager.loadPicture(`ui/state/tag_${i + 1}`));
        item.bgSprite = _itemSprite;
        _itemContainer.addChild(_itemSprite);
        
        const _textSprite = new Sprite(new Bitmap(140, 67));
        item.textSprite = _textSprite;
        _textSprite.bitmap.smooth = true;
        _textSprite.bitmap.fontFace = 'ChillRoundF';
        _textSprite.bitmap.fontSize = 26;
        _textSprite.bitmap.textColor = 'white';
        _textSprite.bitmap.outlineColor = item.disabled ? '#777777' : '#8e6a5b';
        _textSprite.bitmap.outlineWidth = 6;
        _textSprite.bitmap.drawText(item.name, 0, 0, 140, 65, 'center');
        _itemContainer.addChild(_textSprite);
        
        // const _maskSprite = new Sprite(ImageManager.loadPicture(`ui/state/tag_${i + 1}`));
        // item.maskSprite = _itemSprite;
        // _itemContainer.addChild(_maskSprite);

        
        this.slidebarContainer.addChild(_itemContainer);
      }
    }

    /** 获取妹妹状态页窗口的矩形 */
    stateWindowRect() {
      const wx = Graphics.width;
      const wy = 0;
      const ww = this.pageWidth;
      const wh = Graphics.height;
      return new Rectangle(wx, wy, ww, wh);
    }

    /** 创建状态页面 */
    createStateWindow() {
      const rect = this.stateWindowRect();
      this._stateWindow = new Window_Haku_State(rect, this.pageWidth);
      this.addChild(this._stateWindow);
      this.animeInOutInfo.start();
    }

  }
  window.Scene_Haku_State = Scene_Haku_State;

  /** 状态页面 */
  class Window_Haku_State extends Window_Base {
    initialize(rect, pageWidth) {
      this.achievements = Utils_State.getAchievements();

      super.initialize(rect);
      this.openness = 0;
      this.opacity = 1;
      this.pageWidth = pageWidth;

      this.pageContainer = new PIXI.Container();
      this.addChild(this.pageContainer);

      this.createBackground();
      this.createContent();
    }

    /** 创建背景 */
    createBackground() {
      this._bgSprite = new Sprite(ImageManager.loadPicture('ui/state/state_panel_bg'));
      this._bgSprite.x = 0;
      this._bgSprite.y = 0;
      this.pageContainer.addChild(this._bgSprite);

      this._textBitmap = new Bitmap(this.pageWidth, Graphics.height);
      this._textSprite = new Sprite(this._textBitmap);
      this._textSprite.x = 0;
      this._textSprite.y = 0;
      this.pageContainer.addChild(this._textSprite);
    }

    /** 创建内容 */
    createContent() {
      let _x = 90;

      // 标题部分
      this._textBitmap.fontFace = 'Kose';
      this._textBitmap.fontSize = 28;
      this._textBitmap.textColor = '#AE4AA6';
      this._textBitmap.outlineColor = 'white';
      this._textBitmap.outlineWidth = 3;

      this._textBitmap.drawText(`属性`, _x, 30, this.pageWidth, 48, 'left');
      this._textBitmap.drawText(`对哥哥的评价`, _x, 192, this.pageWidth, 48, 'left');
      this._textBitmap.drawText(`此时的想法`, _x, 310, this.pageWidth, 48, 'left');
      this._textBitmap.drawText(`日记1`, _x, 468, this.pageWidth, 48, 'left');


      // 内容部分
      this._textBitmap.fontSize = 24;
      this._textBitmap.textColor = '#665258';
      this._textBitmap.outlineColor = 'white';
      this._textBitmap.outlineWidth = 3;

      // 属性
      const _prop1 = TranslateUtils.getText('好感度');
      const _prop1Width = this.textWidth(_prop1);
      this._textBitmap.drawText(_prop1, _x, 85, this.pageWidth, 48, 'left');

      const _prop1Value = `${Utils_Favor.kanaFavor} / ${Utils_Favor.getStageMaxFavor('kana', Utils_Favor.kanaFavor, true)}`;
      const _prop1Width2 = this.textWidth(_prop1);
      this._textBitmap.drawText(_prop1Value, _x + _prop1Width + 30, 85, this.pageWidth, 48, 'left');

      const _levelStr = [
        '', 'Ⅰ级', 'Ⅱ级', 'Ⅲ级',
      ][Utils_Favor.getKanaFavorLevel(Utils_Favor.kanaFavor)];
      this._textBitmap.drawText(_levelStr, _x + _prop1Width + _prop1Width2 + 30, 85, this.pageWidth, 48, 'left');


      // 属性值
      const _prop2 = TranslateUtils.getText('性欲');
      const _prop2Width = this.textWidth(_prop2);
      this._textBitmap.drawText(_prop2, _x, 130, this.pageWidth, 48, 'left');
      this._textBitmap.drawText(Utils_Favor.kanaSex, _x + _prop2Width + 30, 130, this.pageWidth, 48, 'left');


      // 对哥哥的评价
      this._textBitmap.drawText(Utils_State.kanaEaluate, _x, 240, this.pageWidth, 48, 'left');

      // 此时的想法
      Utils_State.kanaThought.split('\n').forEach((line, index) => {
        this._textBitmap.drawText(line, _x, 360 + index * 34, this.pageWidth, 48, 'left');
      });

      // 成就列表
      let _currentLine = 0;
      let _currentX = 0;
      for (let i = 0; i < this.achievements.length; i++) {
        const _item = this.achievements[i];
        
        this._textBitmap.drawText(_item.title, _x + _currentX, 520 + _currentLine * 34, this.pageWidth, 48, 'left');
        
        _currentX += this.textWidth(_item.title) + 25;
        const _nextTitle = this.achievements[i + 1] ? this.achievements[i + 1].title : '';
        if (_currentX + this.textWidth(_nextTitle) > this.pageWidth - 120) {
          _currentLine++;
          _currentX = 0;
        }
      }

      // this._textSprite.drawTextEx(
      //   `今天开始要和哥哥两个人一起生活呢，稍微有点担心啊，哥哥现在这种样子没问题吗…是不是给哥哥一点动力比较好呢 ♪\n\n …不过要说到动力的话，果然得是色色的事情吗…`, 
      //   _x, 520, this.pageWidth - 70
      // );
      
    }

    update() {
      super.update();
    }

    refresh() {
      super.refresh();
    }
  }
  window.Window_Haku_State = Window_Haku_State;

})();