//=============================================================================
// ** RPG Maker MZ - Scene_Haku_Street.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 街道场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  /** 男主行为菜单 */
  const __actorMenus = [
    {
      name: '使用道具',
      text: '使用道具',
      icon: 'icon_box',
      get tooltip() {
        return '看看还有些什么可以用的东西…';
      },
      get disabled() { return false; },
      onTap() {
        SceneManager.push(Scene_Haku_Item);
      }
    }, {
      name: '离开',
      text: '离开',
      icon: 'icon_goout',
      tooltip: '那就先离开吧',
      onTap() {
        Utils_Scene.changeScene({ sceneName: 'scene_map' });
      }
    }
  ];



  /**
   * 街道场景
   */
  class Scene_Haku_Street extends Scene_MainScene {
    initialize() {
      super.initialize();

    }
    
    gotoScene() {
      if (!$gameData.isEventBusy) {
        this.showTachie();
      }
    }

    create() {
      super.create();
    }

    /** 获取男主行为菜单列表 */
    getActorMenus() {
      /** 男主行为菜单列表 @type {{ imageNormal: string, imageDisabled: string, disabled: boolean, onTap: () => void }[]} */
      this.actorMenus = __actorMenus;
    }

    update() {
      super.update();

    }
  }
  window.Scene_Haku_Street = Scene_Haku_Street;

})();