//=============================================================================
// ** RPG Maker MZ - Hakubox_Scene.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 标题场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 */
// #endregion
(() => {

  Scene_Boot.prototype.adjustBoxSize = function() {
    const uiAreaWidth = $dataSystem.advanced.uiAreaWidth;
    const uiAreaHeight = $dataSystem.advanced.uiAreaHeight;
    const boxMargin = 0;
    Graphics.boxWidth = uiAreaWidth - boxMargin * 2;
    Graphics.boxHeight = uiAreaHeight - boxMargin * 2;
  };

  Window_Command.prototype.addCommandEx = function({
    name = '', text = '', symbol, enabled = true, ext = null,
    normalBg, hoverBg, activeBg, disabledBg
  }) {
    this._list.push({ name, text, symbol, enabled, ext, normalBg, hoverBg, activeBg, disabledBg });
  };

  // #region 标题场景相关

  Scene_Title.prototype.createScreenNoise = function() {
  };

  Scene_Title.prototype.create = function() {
    Scene_Base.prototype.create.call(this);


    /**********************************************************/
    /**********************************************************/
    // this.createCommandWindow();
    // // TODO: 跳转到冒险场景
    // Utils_Scene.actorMove('kana', '123');
    // Utils_Scene.actorMove('chinatsu', '123');
    // Utils_Scene.actorMove('yuki', '123');
    // Utils_Scene.actorMove('ere', '123');
    // $gameData.adventure_map_id = 1; // 冒险地图ID
    // SceneManager.push(Hakubox_Scene_Yobai_Temp);
    // return;
    /**********************************************************/
    /**********************************************************/



    this.createBackground();
    this.createWindowLayer();
    this.createScreenNoise();

    this.createTitle();

    this.bgContainer = new HakuContainer();
    this.addChildAt(this.bgContainer, 3);

    
    // 播放BGM
    // AudioManager.playBgm({ name: 'BGM_title', volume: 100, pitch: 100, pan: 0 });

    // 点击LOGO的效果
    this.logoAnime = useAnime({
      frameDelay: 0,
      frameCount: 15,
      easingType: 'Quadratic',
      inout: 'InOut',
    }, progress => {
      let _scale;

      if (this.logoAnime.type === 'hover') {
        if (progress <= 0.5) {
          _scale = 1 + progress * 0.1;
        } else {
          _scale = 1.1 - progress * 0.1;
        }
      } else if (this.logoAnime.type === 'tap') {
        if (progress <= 0.5) {
          _scale = 1 + progress * 0.3;
        } else {
          _scale = 1.3 - progress * 0.3;
        }
      }

      let _left = this._gameTitleSprite.initX - (_scale - 1) * this._gameTitleSprite.width / 2;
      let _top = this._gameTitleSprite.initY - (_scale - 1) * this._gameTitleSprite.height / 2;

      this._gameTitleSprite.scale.x = _scale;
      this._gameTitleSprite.scale.y = _scale;
      this._gameTitleSprite.x = _left;
      this._gameTitleSprite.y = _top;
    });
    this.logoAnime.type = 'hover';

    let _anime = undefined;
    
    const source = SpineManager.preloadSpine("kanaBath_nobg");
    source.addListener(source => {
      this.createVersion();

      const { spine, anime } = SpineManager.createSpine(source);
      this.spine = spine;
      this.spine.visible = true;
      this.spine.position.set(480, 720);
      this.testSpine = this.spine;

      _anime = anime;
      // anime.timeScale = 0;
      
      this.createCommandWindow();
      
      this.bgContainer.addChildAt(new Sprite(ImageManager.loadPicture('bg/home-else/shower_cgbg')), 0);

      this.bgContainer.addChildAt(this.spine, 1);

      
      this.bgContainer.addChild(new VideoSprite('雾气'));

      // createVideo('effect/effect_01_fog', { parent: this.bgContainer }, ({ sprite }) => {
        // sprite.blendMode = PIXI.BLEND_MODES.SCREEN;
        // const adjustmentFilter = new PIXI.filters.AdjustmentFilter();
        // sprite.filters = [adjustmentFilter];
        // // 大幅增加对比度。这会使亮部更亮，暗部更暗。
        // adjustmentFilter.contrast = 1.8; // 从 2 开始尝试，逐步增加
        // // 增加伽马值。这会主要压暗中间色调和暗部。
        // adjustmentFilter.gamma = 2.8; // 从 1.5 开始尝试，逐步增加

      // 半关的门（右边）
      this.doorLeft = new Sprite(ImageManager.loadPicture('ui/title/door-2-left'));
      this.doorLeft.alpha = 0.8;
      this.doorLeft.x = -150;
      this.doorLeft.y = 0;
      this.bgContainer.addChild(this.doorLeft);

      // 半关的门（右边）
      this.doorRight = new Sprite(ImageManager.loadPicture('ui/title/door-2-right'));
      this.doorRight.alpha = 0.8;
      this.doorRight.x = Graphics.width - 700;
      this.doorRight.y = 0;
      this.bgContainer.addChild(this.doorRight);
      
      // 背景图
      this._gameBgSprite = new Sprite(ImageManager.loadPicture("ui/title/bg"));
      this._gameBgSprite.x = 0;
      this._gameBgSprite.y = 0;
      this.bgContainer.addChild(this._gameBgSprite);
      // });

      // this._link_cien = new Sprite(ImageManager.loadSystem('link_cien'));
      // this._link_cien.x = 20;
      // this._link_cien.y = Graphics.height - 126; // 215
      // this.addChild(this._link_cien);
      
      // this._link_dlsite = new Sprite(ImageManager.loadSystem('link_dlsite'));
      // this._link_dlsite.x = 20;
      // this._link_dlsite.y = Graphics.height - 126;
      // this.addChild(this._link_dlsite);
      
      // this._link_discord = new Sprite(ImageManager.loadSystem('link_discord'));
      // this._link_discord.x = 20;
      // this._link_discord.y = Graphics.height - 215;
      // this.addChild(this._link_discord);
    });


    // 测试控制动画功能
    // let isDragging = false;
    // let lastX = -1, lastY = -1;
    // let prevX = 0, prevY = 0;
    
    // document.addEventListener('mousedown', (e) => {
    //   isDragging = true;
    //   lastX = Math.round(e.x) / 50;
    //   lastY = Math.round(e.y) / 50;
    // });

    // document.addEventListener('mousemove', (e) => {
    //   if (isDragging) {

    //     if (Math.round(e.x) !== prevX || Math.round(e.y) !== prevY) {
    //       const _x = Math.round(e.x) / 50;
    //       const _y = Math.round(e.y) / 50;
  
    //       console.log('x', e.x, '播放时长', Number((_x - lastX).toFixed(2)), '→', _anime.trackTime);
    //       _anime.trackTime = Number((_x - lastX).toFixed(2));
  
    //       prevX = Math.round(e.x);
    //       prevY = Math.round(e.y);
    //     }
    //   }
    // });

    // document.addEventListener('mouseup', (e) => {
    //   isDragging = false;
    // });
  };

  Scene_Title.prototype.terminate = function() {
    Scene_Base.prototype.terminate.call(this);
    SceneManager.snapForBackground();
    if (this._gameTitleSprite) {
      this._gameTitleSprite.bitmap = undefined;
    }
  };

  Scene_Title.prototype.createTitle = function() {
    ImageManager.loadImg(TranslateUtils.getPath("ui/title/title_zh-CN")).then(img => {
      this._gameTitleSprite = new Sprite(img);
      const _x = 884;
      const _y = 50 - img.height + 182;
      this._gameTitleSprite.initX = _x;
      this._gameTitleSprite.initY = _y;
      this._gameTitleSprite.initWidth = img.width;
      this._gameTitleSprite.initHeight = img.height;
      this._gameTitleSprite.x = _x;
      this._gameTitleSprite.y = _y;
      this.addChild(this._gameTitleSprite);
    });
  };
  Scene_Title.prototype.createVersion = function() {
    const _bitmap = new Bitmap(100, 50);
    this._gameVersionSprite = new Sprite(_bitmap);
    this._gameVersionSprite.x = Graphics.width - 120;
    this._gameVersionSprite.y = Graphics.height - 50;
    _bitmap.textColor = '#665258';
    _bitmap.fontSize = 20;
    _bitmap.outlineWidth = 1;
    _bitmap.drawText(`Ver ${gameVersion}`, 0, 0, 100, 50, 'right');
    this.addChild(this._gameVersionSprite);
  };
  
  Scene_Title.prototype.commandWindowRect = function() {
    const offsetX = 448;
    const offsetY = -15;
    const ww = 336;
    const wh = Window_TitleCommand.prototype.fittingHeight(5);
    const wx = (Graphics.boxWidth - ww) / 2 + offsetX;
    const wy = Graphics.boxHeight - wh - 80 + offsetY;
    return new Rectangle(wx, wy, ww, wh);
  };

  Scene_Title.prototype.createCommandWindow = function() {
    const background = $dataSystem.titleCommandWindow.background;
    const rect = this.commandWindowRect();
    this._commandWindow = new Window_TitleCommand(rect);
    this._commandWindow.setBackgroundType(background);
    this._commandWindow.setHandler("newGame", this.commandNewGame.bind(this));
    this._commandWindow.setHandler("continue", this.commandContinue.bind(this));
    this._commandWindow.setHandler("extras", this.commandExtras.bind(this));
    this._commandWindow.setHandler("options", this.commandOptions.bind(this));
    this._commandWindow.setHandler("exit", this.commandExit.bind(this));
    
    this.addChild(this._commandWindow);
  };

  Scene_Title.prototype.commandExit = function() {
    AudioManager.playCv('g031', 0, () => {
      SceneManager.exit();
    });
  };
  /** 跳转到回想场景 */
  Scene_Title.prototype.commandExtras = function() {
    SceneManager.push(Scene_Extras);
  };
  Scene_Title.prototype.commandNewGame = function () {
    AudioManager.playCv('g042_1', 0, () => {
      DataManager.setupNewGame();
      this._commandWindow.close();
      this.fadeOutAll();

      if (!$gameData.gameCore.isInit) {
        this.initGameData();
      }
      SceneManager.goto(Scene_Haku_Init);
    });
    // SceneManager.goto(Scene_Home);
  };
  /** 初始化游戏数据 */
  Scene_Title.prototype.initGameData = function() {
    $gameData.gameCore.isInit = true;
    /** 初始化主角状态数据 */
    Utils_Actor.initGameData();
    /** 初始化场景数据 */
    Utils_Scene.initGameData();
    /** 初始化时间数据 */
    Utils_Time.initGameData();
    /** 初始化立绘数据 */
    // setTimeout(() => {
    // Utils_Tachie.initGameData();
    // }, 900);
  }


  // 三块泡沫的信息
  Scene_Title.prototype.hotPoints = [
    { left: 363, top: 265, width: 180, height: 180, index: 1, aname: 'paomo1', isHover: false },
    { left: 183, top: 275, width: 180, height: 180, index: 2, aname: 'paomo2', isHover: false },
    { left: 399, top: 478, width: 180, height: 180, index: 3, aname: 'paomo3', isHover: false },
  ];

  /** 鼠标移动影响大门效果进度 */
  let _mouseProgress = 0;

  const Scene_Title_update = Scene_Title.prototype.update;
  Scene_Title.prototype.update = function() {
    Scene_Title_update.call(this);

    this.logoAnime.update();

    const x = TouchInput.x;
    const y = TouchInput.y;

    // 大门打开效果
    let _progress = Math.max(Math.min(x / (Graphics.width - 300), 1), 0.05);
    if (Math.abs(_mouseProgress - _progress) > 0.03) {
      _mouseProgress = _mouseProgress + (_progress > _mouseProgress ? 0.03 : -0.03);

      if (this.doorLeft) this.doorLeft.x = 0 - _mouseProgress * 60;
      if (this.doorRight) this.doorRight.x = Graphics.width - 800 + _mouseProgress * 60;
      this.spine.scale.set(0.63 + _mouseProgress * 0.04, 0.63 + _mouseProgress * 0.04);
    }


    // 按钮点击操作
    for (let i = 0; i < this.hotPoints.length; i++) {
      const { index, left, top, width, height, aname, isHover } = this.hotPoints[i];

      if (x >= left && x <= left + width && y >= top && y <= top + height) {
        if (!isHover) {
          this.spine.state.setAnimation(index, aname + '_1', false);
          this.hotPoints[i].isHover = true;
        }
      } else if (isHover) {
        this.spine.state.addAnimation(index, aname, false);
        this.hotPoints[i].isHover = false;
      }
    }

    if (this._link_cien) {
      if (inArea(x, y, this._link_cien.x, this._link_cien.y, this._link_cien.width, this._link_cien.height)) {
        if (!this._cienHover) {
          this._cienHover = true;
          SoundManager.playCursor();
          Utils_Cursor.cursorType = 'pointer';
          this._link_cien.bitmap = ImageManager.loadSystem('link_cien_hover');
        }
        if (TouchInput.isTriggered()) {
          SoundManager.playOk();
          AudioManager.playCv('g080', 0);
          openUrl('https://ci-en.dlsite.com/creator/28598');
        }
      } else if (this._cienHover) {
        this._link_cien.bitmap = ImageManager.loadSystem('link_cien');
        Utils_Cursor.cursorType = 'default';
        this._cienHover = false;
      }
    }

    // if (this._link_dlsite) {
    //   if (inArea(x, y, this._link_dlsite.x, this._link_dlsite.y, this._link_dlsite.width, this._link_dlsite.height)) {
    //     if (!this._dlsiteHover) {
    //       this._dlsiteHover = true;
    //       SoundManager.playCursor();
    //       Utils_Cursor.cursorType = 'pointer';
    //       this._link_dlsite.bitmap = ImageManager.loadSystem('link_dlsite_hover');
    //     }
    //     if (TouchInput.isTriggered()) {
    //       SoundManager.playOk();
    //       AudioManager.playCv('g080', 0);
    //       openUrl('https://ci-en.dlsite.com/creator/28598');
    //     }
    //   } else if (this._dlsiteHover) {
    //     this._link_dlsite.bitmap = ImageManager.loadSystem('link_dlsite');
    //     Utils_Cursor.cursorType = 'default';
    //     this._dlsiteHover = false;
    //   }
    // }
    
    if (this._link_discord) {
      if (inArea(x, y, this._link_discord.x, this._link_discord.y, this._link_discord.width, this._link_discord.height)) {
        if (!this._discordHover) {
          this._discordHover = true;
          SoundManager.playCursor();
          Utils_Cursor.cursorType = 'pointer';
          this._link_discord.bitmap = ImageManager.loadSystem('link_discord_hover');
        }
        if (TouchInput.isTriggered()) {
          SoundManager.playOk();
          openUrl('https://discord.gg/ruHDVUUHhU');
        }
      } else if (this._discordHover) {
        this._link_discord.bitmap = ImageManager.loadSystem('link_discord');
        Utils_Cursor.cursorType = 'default';
        this._discordHover = false;
      }
    }

    if (this._gameTitleSprite) {
      if (inArea(x, y, this._gameTitleSprite.initX, this._gameTitleSprite.initY, this._gameTitleSprite.initWidth, this._gameTitleSprite.initHeight)) {
        if (!this._logoHover) {
          AudioManager.playCv('g047', 0);
          SoundManager.playCursor();
          this.logoAnime.type = 'hover';
          this.logoAnime.start();
          Utils_Cursor.cursorType = 'pointer';
        }
        this._logoHover = true;

        if (TouchInput.isTriggered()) {
          SoundManager.playOk();
          this.logoAnime.type = 'tap';
          this.logoAnime.start();
          AudioManager.playCv('g080', 0);
          openUrl('https://ci-en.dlsite.com/creator/28598');
        }
      } else if (this._logoHover) {
        this._logoHover = false;
        Utils_Cursor.cursorType = 'default';
      }
    }
  };
  // #endregion

  
  // #region 标题场景窗口相关
  
  Window_TitleCommand.prototype.initialize = function(rect) {
    this.spriteItems = [];
    Window_Selectable.prototype.initialize.call(this, rect);
    if (!this._list) this._list = [];
    this.refresh();
    this.select(0, false);
    this.activate();
    this.openness = 0;
    this.selectLast(false);
  }

  Window_TitleCommand.prototype.selectLast = function(playSound = true) {
    if (Window_TitleCommand._lastCommandSymbol) {
      this.selectSymbol(Window_TitleCommand._lastCommandSymbol, playSound);
    } else if (this.isContinueEnabled()) {
      this.selectSymbol("continue", playSound);
    }
  };

  Window_Command.prototype.selectSymbol = function(symbol, playSound = true) {
    const index = this.findSymbol(symbol);
    if (index >= 0) {
      this.forceSelect(index, playSound);
    } else {
      this.forceSelect(0, playSound);
    }
  };

  Window_Selectable.prototype.forceSelect = function(index, playSound = true) {
    this.select(index, playSound);
    this.ensureCursorVisible(false);
  };

  // Window_TitleCommand.prototype.initialize = function(rect) {
  //   Window_Selectable.prototype.initialize.call(this, rect);
  //   this.refresh();
  //   this.select(0, false);
  //   this.activate();
  // };
  
  Window_TitleCommand.prototype.itemHeight = function() {
    return 66;
  };
  // Window_TitleCommand.prototype.refreshCursor = function() {
  //   const _index = this.index();
  //   const rect = this.itemLineRect(_index);
  // };
  Window_TitleCommand.prototype.select = function(index, isNormal = true) {
    const _oldIndex = this._index;
    this._index = index;
    // this.refreshCursor();
    // this.callUpdateHelp();

    if (isNormal) {
      if (_oldIndex !== index) {
        const _item = this._list[index];
        if (_oldIndex >= 0 && index >= 0 && _item) {
          if (_item.enabled) {
            SoundManager.playCursor();
          }
        }
      }
    }

    if (_oldIndex >= 0) {
      const _oldItem = this._list[_oldIndex];
      const _oldSpriteItem = this.spriteItems[_oldIndex];
      if (_oldIndex !== index && _oldItem) {
        _oldSpriteItem.textSprite.bitmap.clear();
        if (!_oldItem.enabled) {
          _oldSpriteItem.textSprite.bitmap.textColor = '#908789';
          _oldSpriteItem.textSprite.bitmap.drawText(this._list[_oldIndex].text, 0, 0, 300, 60, 'center');
          _oldSpriteItem.bgSprite.bitmap = ImageManager.loadPicture(`ui/title/btn_disabled`);
        } else {
          _oldSpriteItem.textSprite.bitmap.textColor = '#665258';
          _oldSpriteItem.textSprite.bitmap.drawText(this._list[_oldIndex].text, 0, 0, 300, 60, 'center');
          _oldSpriteItem.bgSprite.bitmap = ImageManager.loadPicture(`ui/title/btn_normal`);
        }
      }
    }
    const _item = this.spriteItems[index];
    if (index >= 0 && _item) {
      this.spriteItems[index].textSprite.bitmap.clear();
      if (!this._list[index].enabled) {
        this.spriteItems[index].textSprite.bitmap.textColor = '#908789';
        this.spriteItems[index].textSprite.bitmap.drawText(this._list[index].text, 0, 0, 300, 60, 'center');
        this.spriteItems[index].bgSprite.bitmap = ImageManager.loadPicture(`ui/title/btn_disabled`);
      } else {
        this.spriteItems[index].textSprite.bitmap.textColor = '#D17C5E';
        this.spriteItems[index].textSprite.bitmap.drawText(this._list[index].text, 0, 0, 300, 60, 'center');
        this.spriteItems[index].bgSprite.bitmap = ImageManager.loadPicture(`ui/title/btn_active`);
      }
    }
  };
  Window_TitleCommand.prototype.drawItemBackground = function(index) {
  };
  Window_TitleCommand.prototype.redrawItem = function(index) {
    if (index >= 0) {
      this.clearItem(index);
      // this.drawItemBackground(index);
      this.drawItem(index);
    }
  };
  Window_TitleCommand.prototype.drawItem = function(index) {
    const rect = this.itemLineRect(index);
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
    let _bgBitmap;
    let _textBitmap = new Bitmap(300, 60);
    if (TranslateUtils.currentLanguage === 'ja-JP') {
      _textBitmap.fontFace = 'ChillRoundF';
      _textBitmap.fontBold = true;
      _textBitmap.fontSize = 22;
    } else if (TranslateUtils.currentLanguage === 'en-US') {
      _textBitmap.fontFace = 'Source Han Sans VF';
      _textBitmap.fontBold = true;
      _textBitmap.fontSize = 22;
    } else if (TranslateUtils.currentLanguage === 'zh-TW') {
      _textBitmap.fontFace = 'ChillRoundF';
      _textBitmap.fontBold = true;
      _textBitmap.fontSize = 22;
    } else {
      _textBitmap.fontBold = false;
      _textBitmap.fontFace = 'HYCuYuanJ';
      _textBitmap.fontSize = 24;
    }
    _textBitmap.smooth = false;
    // _textBitmap.fontBold = true;
    _textBitmap.outlineWidth = 6;
    _textBitmap.outlineColor = '#FFFFFF';
    if (!this._list[index].enabled) {
      _bgBitmap = ImageManager.loadPicture(`ui/title/btn_disabled`);

      _textBitmap.textColor = '#908789';
      setTimeout(() => {
        _textBitmap.clear();
        _textBitmap.drawText(this._list[index].text, 0, 0, _textBitmap.width, _textBitmap.height, 'center');
      }, 100);
    } else {
      _bgBitmap = ImageManager.loadPicture(`ui/title/btn_normal`);

      _textBitmap.textColor = '#665258';
      setTimeout(() => {
        _textBitmap.clear();
        _textBitmap.drawText(this._list[index].text, 0, 0, _textBitmap.width, _textBitmap.height, 'center');
      }, 100);
    }
    _bgBitmap.smooth = false;
    const _item = {
      bgSprite: new Sprite(_bgBitmap),
      textSprite: new Sprite(_textBitmap),
    };
    _item.bgSprite.x = rect.x;
    _item.bgSprite.y = rect.y;
    _item.textSprite.x = rect.x;
    _item.textSprite.y = rect.y;
    this.addChild(_item.bgSprite);
    this.addChild(_item.textSprite);
    this.spriteItems.push(_item);
  };
  Window_TitleCommand.prototype.fittingHeight = function(numLines) {
    return numLines * this.itemHeight() + $gameSystem.windowPadding() * 2;
  };
  Window_TitleCommand.prototype.makeCommandList = function() {
    const me = this;
    this.addCommandEx({
      symbol: "newGame",
      text: "新游戏",
    });
    this.addCommandEx({
      symbol: "continue",
      text: "读取",
      get enabled() { return me.isContinueEnabled(); },
    });
    this.addCommandEx({
      symbol: "extras",
      text: "额外内容",
    });
    this.addCommandEx({
      symbol: "options",
      text: "设置",
    });
    this.addCommandEx({
      symbol: "exit",
      text: "退出游戏",
    });
  };

  
  // setTimeout(() => {
  //   useAlert({ text: navigator.userAgent.substring(30), duration: 3000 });
  // }, 3000);
  // if (typeof navigator !== 'undefined' && navigator.userAgent) {
  //   const userAgent = navigator.userAgent.toLowerCase();
  //   useAlert({ text: userAgent });
  //   if (userAgent.includes('joiplay') || userAgent.includes('crosswalk') /* JoiPlay 旧版可能使用 Crosswalk 内核 */) {
  //     useConfirm({
  //       hasCancel: true,
  //       content: `使用Joiplay将无法使用部分功能，建议使用APP版本游玩。`,
  //       okHandler: (info) => {
  //         SoundManager.playOk();
  //         info.close();
  //         useTimeout(() => {
  //           this.finishSceneThink();
  //         }, 20);
  //       }
  //     });
  //   }
  // }

  // #endregion

})();