//=============================================================================
// MPP_MessageEX_AutoLineBreak_Patch.js
//=============================================================================
// Copyright (c) 2022 Mokusei Penguin
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MV
 * @plugindesc DarkPlasma_AutoLineBreak.js の自動改行機能を有効にします。
 * @author 木星ペンギン
 * @url 
 *
 * @help 制作日: 2022/05/15
 * - このプラグインはRPGツクールMV用です。
 * 
 * - DarkPlasmaさん制作のプラグイン DarkPlasma_AutoLineBreak.js と
 *   MPP_MessageEX.js(文章の表示拡張)を併用した際、
 *   自動改行を行うようにします。
 * - 仕様上、ルビの高さが上手く反映されないことがあります。
 * - 一部制御文字では行頭&行末禁則文字が無視されます。
 * - 一部制御文字では自動改行によるページ送りポーズに対応していません。
 * - これら２つのプラグインより下に導入してください。
 * 
 *  対応プラグイン:
 *    DarkPlasma_AutoLineBreak.js     # version: 1.0.1   作者: DarkPlasma
 *    MPP_MessageEX.js                # version: 4.2.2   作者: 木星ペンギン
 *  
 *  ※上記以外のバージョンでの動作は保証しません。
 * 
 * ================================
 * Mail : wood_penguin＠yahoo.co.jp (＠は半角)
 * Blog : http://woodpenguin.blog.fc2.com/
 * License : MIT license
 *
 */

(() => {
    'use strict';

    const _Window_Message_processNormalCharacter = Window_Message.prototype.processNormalCharacter;
    Window_Message.prototype.processNormalCharacter = function(textState) {
        if (this.mustLineBreak && this.mustLineBreak(textState)) {
            textState.index--;
            this.processNewLine(textState);
        } else {
            _Window_Message_processNormalCharacter.apply(this, arguments);
        }
    };

    const _Window_Message_processDrawIcon = Window_Message.prototype.processDrawIcon;
    Window_Message.prototype.processDrawIcon = function(iconIndex, textState) {
        const pw = Window_Base._iconWidth || ImageManager.iconWidth;
        if (this.mustLineBreakForMessageEx(textState, pw + 4)) {
            textState.index--;
            this.processNewLine(textState);
        }
        _Window_Message_processDrawIcon.call(this, iconIndex, textState);
    };

    const _Window_Message_processGroupCharacter = Window_Message.prototype.processGroupCharacter;
    Window_Message.prototype.processGroupCharacter = function(textState, texts) {
        const width = this.textWidth(texts[0]);
        if (this.mustLineBreakForMessageEx(textState, width)) {
            textState.index--;
            this.processNewLine(textState);
        }
        _Window_Message_processGroupCharacter.call(this, textState, texts);
    };

    const _Window_Message_processRubyCharacter = Window_Message.prototype.processRubyCharacter;
    Window_Message.prototype.processRubyCharacter = function(textState, texts) {
        const [ c, r ] = texts;
        const cw = this.textWidth(c);
        const rubyBitmap = this._rubyBitmap;
        rubyBitmap.fontBold = this.contents.fontBold;
        rubyBitmap.fontItalic = this.contents.fontItalic;
        const rw = rubyBitmap.measureTextWidth(r);
        const width = Math.max(cw, rw);
        if (this.mustLineBreakForMessageEx(textState, width)) {
            textState.index--;
            this.processNewLine(textState);
            textState.rubyHeight = this.baseRubyHeight();
            textState.y += textState.rubyHeight;
        }
        _Window_Message_processRubyCharacter.call(this, textState, texts);
    };

    Window_Message.prototype.mustLineBreakForMessageEx = function (textState, textWidth) {
        // 禁則文字未対応
        return (
            textState &&
            textState.index > 0 &&
            this.isAutoLineBreakEnabled() &&
            textWidth + textState.x > this.lineBreakWidth()
        );
    };

})();
