(() => {

  /** 点击模块 */
  const touchModule = {
    info: {
      container: null,
      /** 是否开始 */
      isStart: false,
      /** 当前动作 */
      currentAction: '',
      updateSprite() {}
    },
    /** 点击数据 */
    touchData: [],
    /**
     * 当前状态
     */
    stateList: {
      // 开灯
      light_on: true,
      // 脱衣
      take_off: { value: false, progress: 0 },
    },
    /**
     * 是否包含状态
     * @param {string} id 状态ID
     */
    includeState() {
      const _stateList = Array.from(arguments);
      return _stateList.every(id => {
        const _state = touchModule.stateList[id];
        if (_state) {
          if (typeof _state === 'boolean') return true;
          else return _state.value;
        }
        return false;
      });
    },
    /** 设置状态 */
    setState(id, value, config) {
      touchModule.addState(id, value, config);
    },
    /** 增加状态 */
    addState(id, value, config) {
      if (touchModule.stateList[id]) {
        if (config) {
          touchModule.stateList[id] = { value, ...config };
        } else {
          touchModule.stateList[id] = value;
        }
      }
      touchModule.updateSprite();
    },
    /** 移除状态 */
    removeState(id) {
      if (touchModule.stateList[id]) {
        delete touchModule.stateList[id];
      }
      touchModule.updateSprite();
    },
    /** 更新精灵 */
    updateSprite() {
      /** 更新精灵图片数据 */
      if (touchModule.info.updateSprite) {
        touchModule.info.updateSprite();
      }
    },
    /** 更新 */
    update() {
      if (touchModule.info.updateSprite) touchModule.info.updateSprite();
      if (touchModule.info.update) touchModule.info.update();

      if (!touchModule.info.container || !touchModule.info.container.worldTransform) throw new Error('请传入有效的父级元素');
      
      // let _x = touchModule.info.container.worldTransform.tx;
      // let _y = touchModule.info.container.worldTransform.ty;

      if (TouchPlugin.isTapDown()) {
        for (let i = 0; i < touchModule.touchData.length; i++) {
          const _item = touchModule.touchData[i];
          if (_item.condition && !_item.condition()) continue;

          if (_item.dragInfo) {
            /** @type { false | { progress: number, speed: number } } */
            const _dragResult = TouchPlugin.isDrag(_item.dragInfo);
            if (_dragResult !== false) {
              // touchModule.setState(_item.state, {
              //   progress: _dragResult.progress + _item.tempProgress,
              //   value: _dragResult.progress >= 1
              // });
              const { x, y } = calculateAnglePosition(
                _item.dragInfo.angle, _item.x, _item.y, 
                _item.dragInfo.distance * (_dragResult.progress + _item.tempProgress),
              );
              if (!_item.transform) _item.transform = { x: 0, y: 0 };
              _item.transform.x = x;
              _item.transform.y = y;

              if (_item.onDrag) _item.onDrag(_dragResult.progress + _item.tempProgress);
              if (_dragResult.progress >= 1 && _item.onComplete) _item.onComplete();
            }
          } else {
            if (_item.onTap) _item.onTap();
            // touchModule.setState(_item.state, true);
          }
        }
      }
    },
    /** 安装 */
    setup({ touchData, container, onUpdateSprite, onUpdate }) {
      if (!container) throw new Error('请传入父级元素');
      else if (typeof onUpdate !== 'function') throw new Error('请传入更新函数');
      else if (!touchData || !Array.isArray(touchData) || touchData.length === 0) throw new Error('请传入有效的点击数据');

      if (onUpdateSprite) touchModule.info.updateSprite = onUpdateSprite;
      touchModule.info.update = onUpdate;
      touchModule.info.container = container;

      return {
        update: touchModule.update,
        start() { touchModule.info.isStart = true; },
        stop() { touchModule.info.isStart = false; },
        setState: touchModule.setState,
        removeState: touchModule.removeState,
        addState: touchModule.addState,
        includeState: touchModule.includeState,
        get isStart() { return touchModule.info.isStart; },
      };
    }
  };
  window.TouchModule = touchModule;

})();