//=============================================================================
// X_DOMMenuWindow.js
// 作者: X
//=============================================================================

/*:
 * @plugindesc 使用 DOM 创建主菜单窗口，在地图场景中显示，按住按键时显示菜单，松开时关闭菜单。
 * @author X
 *
 * @param shortCutKey
 * @type string
 * @desc 快捷方式窗口的调用键。
 * 初始值: E
 * @default E
 * 
 * @help
 * 该插件会在地图场景中使用 DOM 创建一个主菜单窗口，并允许按住菜单键时显示菜单，松开时关闭菜单。
 *
 * 使用方法：
 * 1. 将此插件添加到项目中。
 * 2. 按住菜单按钮时，菜单会显示在地图场景上，松开时关闭菜单。
 */

(function() {
    var parameters = PluginManager.parameters('X_DomMenu');
    var DomMenuOpenKey = parameters['DomMenuKey'] || 'E';

    Input.keyMapper[DomMenuOpenKey.charCodeAt()] = 'DomMenuOpenKey';

    // 添加变量来跟踪当前选中的菜单项
    var currentSelection = 0;

    // 菜单项列表
    var menuItems = ['物品', '技能', '装备', '状态', '保存', '退出'];

    // 创建DOM菜单窗口
    Scene_Map.prototype.createDOMMenuWindow = function() {
        if (!this._domMenuWindow) {
            this._domMenuWindow = document.createElement('div');
            this._domMenuWindow.id = 'domMenuWindow';
            this._domMenuWindow.style.position = 'absolute';
            this._domMenuWindow.style.top = `100px`;
            this._domMenuWindow.style.left = `100px`;
            this._domMenuWindow.style.transform = 'translateX(-50%)';
            this._domMenuWindow.style.backgroundColor = 'rgba(0, 0, 0, 0.7)';
            this._domMenuWindow.style.color = 'white';
            this._domMenuWindow.style.padding = '20px';
            this._domMenuWindow.style.borderRadius = '10px';
            this._domMenuWindow.style.zIndex = '1000';

            var ul = document.createElement('ul');
            ul.style.listStyleType = 'none';
            ul.style.padding = '0';

            // 使用普通函数并且绑定正确的上下文
            menuItems.forEach(function(item, index) {
                var li = document.createElement('li');
                li.style.margin = '10px 0';
                li.style.cursor = 'pointer';
                li.innerHTML = item;

                // 确保绑定的函数能正确处理
                li.addEventListener('click', this.onDOMMenuItemClick.bind(this, index));
                ul.appendChild(li);
            }, this);

            this._domMenuWindow.appendChild(ul);
            document.body.appendChild(this._domMenuWindow);
        }

        // 显示菜单
        this._domMenuWindow.style.display = 'block';
        this.updateMenuHighlight();
    };

    // 更新菜单项的高亮显示
    Scene_Map.prototype.updateMenuHighlight = function() {
        var items = this._domMenuWindow.getElementsByTagName('li');
        for (var i = 0; i < items.length; i++) {
            if (i === currentSelection) {
                items[i].style.backgroundColor = 'rgba(255, 255, 255, 0.3)';
            } else {
                items[i].style.backgroundColor = '';
            }
        }
    };

    // 处理点击菜单项
    Scene_Map.prototype.onDOMMenuItemClick = function(index) {
        console.log('点击了菜单项：', menuItems[index]); 
        this.executeMenuAction(index);
        this.hideDOMMenuWindow();
    };

    // 执行菜单项对应的操作
    Scene_Map.prototype.executeMenuAction = function(index) {
        switch (index) {
            case 0:
                SceneManager.push(Scene_Item);
                break;
            case 1:
                SceneManager.push(Scene_Skill);
                break;
            case 2:
                SceneManager.push(Scene_Equip);
                break;
            case 3:
                SceneManager.push(Scene_Status);
                break;
            case 4:
                SceneManager.push(Scene_Save);
                break;
            case 5:
                SceneManager.push(Scene_Gameover);
                break;
            default:
                console.log('未知菜单项:', menuItems[index]);
                break;
        }
    };

    // 隐藏DOM菜单窗口
    Scene_Map.prototype.hideDOMMenuWindow = function() {
        if (this._domMenuWindow && this._domMenuWindow.style.display !== 'none') {
            this._domMenuWindow.style.display = 'none';
        }
    };

    // 监听方向键和确定键的按下事件
    Scene_Map.prototype.updateCallMenu = function() {
        if (this.isMenuEnabled()) {
            if (Input.isPressed('DomMenuOpenKey') && !$gameMap._isMenuOpen) {
                this.createDOMMenuWindow();
                $gameMap._isMenuOpen = true;
            }
            if (!Input.isPressed('DomMenuOpenKey') && $gameMap._isMenuOpen) {
                this.hideDOMMenuWindow();
                $gameMap._isMenuOpen = false;
            }

            // 监听方向键
            if (Input.isPressed('up') && currentSelection > 0) {
                currentSelection--;
                this.updateMenuHighlight();
            } else if (Input.isPressed('down') && currentSelection < menuItems.length - 1) {
                currentSelection++;
                this.updateMenuHighlight();
            }

            // 监听确定键
            if (Input.isTriggered('ok')) {
                this.executeMenuAction(currentSelection);
                this.hideDOMMenuWindow();
            }
        }
    };

    // 禁止在菜单打开时移动
    var Alias_Game_Player_canMove = Game_Player.prototype.canMove;
    Game_Player.prototype.canMove = function() {
        if ($gameMap._isMenuOpen) return false;
        return Alias_Game_Player_canMove.call(this);
    };
})();
