/***************************************************************************************
 PH - Warehouse/Storage
 ---------------------------------------------------------------------------------------
 This work is licensed under the Creative Commons Attribution 4.0 International License.
 To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/
 ---------------------------------------------------------------------------------------
****************************************************************************************/

/*:
 * @plugindesc Create a warehouse where you can store items in the game.
 * @target MV MZ
 * @author PrimeHover & PNDK_LC Support Alteration：Nyatama
 * 
 * @command create
 * @text Create Warehouse
 * @desc Create a warehouse
 * 
 * @arg create_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse you want to create.
 * @default 
 * 
 * @arg create_capacity
 * @text Warehouse Capacity
 * @desc Enter the maximum capacity of the warehouse
 * ※If you omit the input, 50 will be set automatically.
 * @type number
 * default 
 * 
 * @arg create_rule
 * @text Warehouse Rule
 * @desc Enter the rules for the warehouse.
 * ※If you omit the input, no rule will be applied.
 * 
 * @command show
 * @text Show Warehouse
 * @desc Show warehouse scene
 * 
 * @arg show_title
 * @text Wharehouse Title
 * @desc Enter the name of the warehouse to be displayed.
 * @default 
 * 
 * @command remove
 * @text Remove Warehouse
 * @desc Delete warehouse
 * 
 * @arg remove_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse to be deleted.
 * @default 
 *
 * 
 * @command addItem
 * @text Add Item
 * @desc Add items to the warehouse.
 *
 * @arg addItem_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse to be added.
 * @default 
 * 
 * @arg addItem_itemId
 * @tex Item ID
 * @desc Select the items to be added.
 * @type item
 * @default 0
 * 
 * @arg addItem_quantity
 * @text Number to add
 * @desc Enter how many you want to add
 * @type number
 * @default 1
 * 
 * 
 * @command addWeapon
 * @text Add Weapon
 * @desc Add weapons to the warehouse
 *
 * @arg addWeapon_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse to be added.
 * @default 
 * 
 * @arg addWeapon_itemId
 * @text Weapon ID
 * @desc Select the weapon to be added.
 * @type weapon
 * @default 0
 * 
 * @arg addWeapon_quantity
 * @text Weapon Quantity
 * @desc Enter how many you want to add.
 * @type number
 * @default 1
 * 
 * 
 * @command addArmor
 * @text Add Armor
 * @desc Add armour to the warehouse.
 *
 * @arg addArmor_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse to be added.
 * @default 
 * 
 * @arg addArmor_itemId
 * @text Armor ID
 * @desc Select the armour to be added.
 * @type armor
 * @default 0
 * 
 * @arg addArmor_quantity
 * @text Armor Quantity
 * @desc Enter how many you want to add.
 * @type number
 * @default 1
 * 
 * 
 * @command capacitySet
 * @text Capacity Setting
 * @desc Change the maximum capacity of the warehouse.
 * 
 * @arg capacitySet_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse for which you want to change the maximum capacity.
 * @default 
 *
 * @arg capaitySet_quantity
 * @text Capacity Quantity
 * @desc Enter the maximum capacity.
 * @default 
 * 
 * 
 * @command capacityInc
 * @text Capacity Increase
 * @desc Increase the maximum capacity of your warehouse
 * 
 * @arg capacityInc_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse for which you want to increase the maximum capacity.
 * @default 
 *
 * @arg capacityInc_quantity
 * @text Capacity Amount
 * @desc Enter the amount you want to increase.
 * @default 
 * 
 * 
 * @command capacityDec
 * @text Capacity Decrease
 * @desc Reduces the maximum capacity of the warehouse
 * 
 * @arg capacityDec_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse where you want to reduce the maximum capacity.
 * @default 
 *
 * @arg capacityDec_quantity
 * @text Capacity Amount
 * @desc Enter the amount you want to reduce.
 * @default 
 * 
 * @command bgSet
 * @text Background Setting
 * @desc Specify a background image for the warehouse screen, place it in img/pictures.
 *
 * @arg bgSet_file
 * @text Background File
 * @desc Enter the name of the warehouse for which you want to change the background image.
 * @type file
 * @require 1
 * @dir img/pictures
 * @default
 *
 * 
 * @command bgReset
 * @text Background Reset
 * @desc Resets the background image of the warehouse screen to its default value.
 * 
 * 
 * @command setRule
 * @text Rule Setting
 * @desc You can change the rules of the warehouse
 * 
 * @arg setRule_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse where you want to reduce the maximum capacity.
 * @default 
 * 
 * @arg setRule_rule
 * @text Rule
 * @desc Enter the rules you want to set.
 * 
 * @command collectiveDeposit
 * @text Collective Deposit
 * @desc Deposit all belongings of a given category together.
 * 
 * @arg collectiveDeposit_title
 * @text Warehouse Title
 * @desc Enter the name of the warehouse where you want to deposit.
 * @default Deposit Room
 *
 * @arg collectiveDeposit_category
 * @text Target Categories
 * @desc Specify the categories you wish to deposit.
 * @type combo
 * @option item
 * @option weapon
 * @option armor
 * @option keyItem
 * @option all
 * @default all
 *
 * @arg collectiveDeposit_rule
 * @text Rule
 * @desc Specify the rules for depositing.
 * ※If no rules are specified, the current rules will be followed
 * @default 
 * 
 * 
 * @param --- Options ---
 * @desc Use the spaces below to customize the options of the plugin
 * @default
 *
 * @param All Together
 * @desc Defines whether or not you want to show the items in separated categories (0: false, 1: true)
 * @type boolean
 * @on Enable
 * @off Disable
 * @default false
 *
 * @param All Text
 * @desc Text shown in option "All" if the parameter "All Together" is set as true.
 * @default All
 * @parent All Together
 * 
 * @param Info Type
 * @desc Format to be displayed in the information window。
 * (Default:Used Space)
 * @type boolean
 * @on Used Space
 * @off Free Spaces
 * @default true
 *
 * @param Info Space Text
 * @desc Text shown in the information window
 * @default Used Space:
 * @parent Info Type
 * 
 * @param Info Space Format
 * @desc %1:Current(NotUsed/Used)%2:Max※Control characters allowed
 * Default【\C[16]Used Space\C[0]  %1 \C[16]/\C[0] %2】
 * @type string
 * @default \C[16]Used Space\C[0]  %1 \C[16]/\C[0] %2
 * @parent Info Type
 * 
 * @param Stack Item Quantity
 * @desc Defines whether or not you want to consider stacked items as a single space in the capacity (0: false, 1: true)
 * @type boolean
 * @on Enable
 * @off Disable
 * @default false
 * 
 * @param Auto Discard
 * @desc When adding to the warehouse, the excess capacity of the warehouse is automatically destroyed.(default:Enable)
 * @type boolean
 * @on Enable
 * @off Disable
 * @default true
 * 
 * @param Max Item Quantity
 * @desc Number of items that can be deposited for each item type (0:infinity)
 * @default 99
 * @type number
 * 
 * @param Max Item Color
 * @desc Colors when deposit is restricted Color (HEX) #ff80ff
 * @default #ff80ff
 * @type string
 * @parent Max Item Quantity
 * 
 * @param Over Quantity title
 * @desc Window title when the item limit is exceeded
 * @default Item number limit exceeded
 * @type string
 * @parent Max Item Quantity
 * 
 * @param Over Quantity message
 * @desc Window message when the item limit is exceeded
 * @default "You have reached the limit of possession of this type of item\nYou can't put this item anymore"
 * @type note
 * @parent Max Item Quantity
 * 
 * @param Exit Confirm
 * @desc Display a confirmation window when leaving the warehouse
 * @type boolean
 * @on Enable
 * @off Disable
 * @default false
 * 
 * @param Exit Confirm Title
 * @desc Title of exit confirmation dialog
 * @default Exit confirmation
 * @type string
 * @parent Exit Confirm
 * 
 * @param Exit Confirm Message
 * @desc Message of confirmation dialog when leaving
 * @default "Are you sure you want to leave?\n"
 * @type note
 * @parent Exit Confirm
 * 
 * @param Exit Confirm Btn Ok
 * @desc Exit button in the exit confirmation window
 * @default Exit
 * @type string
 * @parent Exit Confirm
 * 
 * @param Exit Confirm Btn Cancel
 * @desc Non-exit button in the exit confirmation window
 * @default Do not leave
 * @type string
 * @parent Exit Confirm
 * 
 * @param Add Rule Violation
 * @desc If any one of this list of expressions is true, it is a violation of the rules. Each element can be referenced from the variable [item].
 * @type combo[]
 * @default ["item.price === 0 // Items that cannot be sold in the store cannot be deposited.", "item.itypeId === 2 // Key items cannot be deposited."]
 * @option item.price === 0 // Items that cannot be sold in the store cannot be deposited.
 * @option item.itypeId === 2 // Key items cannot be deposited. 
 * 
 * @param Deposit Sound File
 * @text Deposit Sound File
 * @desc SE when a deposit is successfull.
 * ※If not specified,the SE of the equipment will be played.
 * @type file
 * @require 1
 * @dir audio/se
 * @default
 * @parent otherType
 * 
 * @param Withdraw Sound File
 * @text Withdraw Sound File
 * @desc SE when a withdrawal is successful.
 * ※If not specified,the SE of the equipment will be played.
 * @type file
 * @require 1
 * @dir audio/se
 * @default
 * @parent otherType
 * 
 * @param Buzzer Sound File
 * @text Buzzer Sound File
 * @desc SE when a deposit is failure.
 * ※If not specified, the SE of the buzzer will be played.
 * @type file
 * @require 1
 * @dir audio/se
 * @default
 * @parent otherType
 * 
 * @param --- Display Options ---
 * 
 * @param ItemList DrawScript
 * @text Item List Draw Script
 * @desc This is a script for drawing items. Each element can be referenced from the variable [item].
 * @default ["this.drawIcon(item.iconIndex, r.x + 2, r.y + 2);", "this.drawText(this.getItemName(item), r.x + this.iconBoxWidth(), r.y, r.width - this.numberWidth() - this.iconBoxWidth(), 'left');", "this.drawWarehouseItemColon(r.x, r.y, r.width, 2);", "this.drawWarehouseItemNumber(item, r.x, r.y, r.width, 2);"]
 * @type combo[]
 * @option ------------(Default Settings)-------------
 * @option this.drawIcon(item.iconIndex, r.x + 2, r.y + 2); // Default Line 1
 * @option this.drawText(item.name, r.x + this.iconBoxWidth(), r.y, r.width - this.numberWidth() - this.iconBoxWidth(), 'left'); // Default Line 2
 * @option this.drawWarehouseItemColon(r.x, r.y, r.width, 2); // Default Line 3
 * @option this.drawWarehouseItemNumber(item, r.x, r.y, r.width, 2); // Default Line 4
 * @option -------(When PNDK_LC is installed)---------
 * @option this.drawText(this.getItemNameWithCP(item), r.x + this.iconBoxWidth(), r.y, r.width - this.numberWidth() - this.iconBoxWidth(), 'left'); // // Name of weight included
 * @option ----------------(Sample)-------------------
 * @option this.drawNoteText('noteValue', r.x, r.y); //  Draw the contents of the specified memo field.
 * @option this.drawIcon(item.iconIndex, r.x, r.y, r.width); // Icon
 * @option this.drawItemName(item, r.x, r.y, r.width); // ItemName
 * @option this.drawWarehouseItemNumber(item, r.x, r.y, r.width, 0); // Number of items including:
 * @option this.drawTextEx(`Text:${item.name}`, r.x, r.y, r.width); // Arbitrary text drawing(With control character conversion)
 * @option this.drawText(`Text:${item.name}`, r.x, r.y, r.width, 'right'); // Arbitrary text drawing(No control character conversion. Right justification)
 * @option this.changeTextColor(this.textColor(1)); // Change text color(Only valid for drawText)
 * 
 * @param Show Item Info
 * @type boolean
 * @default false
 * 
 * @param ItemInfo DrawScript
 * @parent Show Item Info
 * @text Item Info Draw Script
 * @desc This is a script for drawing items. Each element can be referenced from the variable [item].
 * @default ["this.drawText(item.name, r.x, r.y, r.width, 'center');", "this.drawItemPicture(r.x, r.y + this.lineHeight())", "this.drawCP(r.x, r.y + 270, r.width);"]
 * @type combo[]
 * @option ---------------(Default Settings)----------------
 * @option this.drawText(item.name, r.x, r.y, r.width, 'center'); // Default Line 1
 * @option this.drawItemPicture(r.x, r.y + this.lineHeight()) // Default Line 2
 * @option this.drawCP(r.x, r.y + 270, r.width); // drawCP Default Line 3 (CP Format)
 * @option -----------(When PNDK_LC is installed)------------
 * @option this.drawText(this.getItemNameWithCP(this._item), r.x, r.y, r.width, 'center'); // Name of weight included
 * @option ---------------------(Sample)---------------------
 * @option this.drawNoteText('noteValue', r.x, r.y); // Draw the contents of the specified memo field.
 * @option this.drawIcon(item.iconIndex, r.x, r.y, r.width); // Icon
 * @option this.drawItemName(item, r.x, r.y, r.width); // ItemName(Left-aligned)
 * @option this.drawTextEx(`Text:${item.name}`, r.x, r.y, r.width); // Arbitrary text drawing(With control character conversion)
 * @option this.drawText(`Text:${item.name}`, r.x, r.y, r.width, 'right'); // Arbitrary text drawing(No control character conversion. Right justification)
 * @option this.changeTextColor(this.textColor(1)); // Change text color(Only valid for drawText)
 * @option this.drawItemPicture(r.x, r.y); // Draws a picture of the specified tag
 * @option this.drawNotePicture('noteValue', r.x, r.y); // Draws a picture of the specified memo field.(4th argument:width 5th argument:height default:236)
 * @option this.drawPicture('pictureFileName', r.x, r.y); // Draws the specified picture.(4th argument:width 5th argument:height default:236)
 *
 * @param Withdraw Text
 * @desc Text shown in option "Withdraw"
 * @default Withdraw
 *
 * @param Deposit Text
 * @desc Text shown in option "Deposit"
 * @default Deposit
 * 
 * @param Window StartPosition
 * @text [MZ]Window Start Position
 * @desc true:Drawing from the ScreenTopAria
 * false:Drawing from the MainTopAria
 * @type boolean
 * @on ScreenTopAria
 * @off MainTopAria
 * @default false
 * 
 * @param Title Text Hide
 * @desc Makes the title text transparent. (Default: Disabled)
 * @type boolean
 * @on Enable
 * @off Disable
 * @default false
 * 
 * @param Title Window BG Hide
 * @desc Makes the background of the title window transparent. (Default: Disabled)
 * @type boolean
 * @on Enable
 * @off Disable
 * @default false
 * 
 * @param All Window BG Hide
 * @desc Makes the background of the window transparent.
 * Make your own background.(default:Enable)
 * @type boolean
 * @on Enable
 * @off Disable
 * @default false
 * 
 * @param Background Image
 * @desc Specifies the background image.
 * Please place them in img/pictures.
 * @type file
 * @require 1
 * @dir img/pictures/
 * @default
 * 
 * @param Item Folder
 * @text Item Image Folder
 * @desc Specify the folder for the item images.
 * Defalt: pictures
 * @type file
 * @require 1
 * @dir img
 * @default pictures
 * @parent Show Item Info
 * 
 * @param Item Tag Name
 * @desc If you put <(tag name):apple> in the memo field of an item, "apple.png" in the picture folder will be read and displayed.
 * @default image
 * @parent Show Item Info
 * 
 * @param EmptyItem Picture File
 * @text Empty Item Image
 * @desc Image file to be displayed when there is no item image
 * @type file
 * @require 1
 * @dir img
 * @default pictures/EmptyImage
 * @parent Show Item Info
 * 
 * @param CP Format
 * @text [PNDK_LC]CP Format
 * @desc %1:Attribute name %2:CP %3:Unit【Default:%1 %2\C[16]%3】
 * ※Some control characters can be used 
 * @default %1 %2\C[16]%3
 * @parent Show Item Info
 * 
 * @param --- PNDK_LC Settings ---
 * 
 * @param CP Layout Top For MZ
 * @desc [MZ Only] Set CP position to the top
 * @type boolean
 * @on Enable
 * @off Disable
 * @default true
 *
 * @param CP Layout
 * @desc [1]Right to "Deposit / Withdraw". 
 * [2]Right to "category". [3]Right to "Info".
 * @type select
 * @option Right to "Deposit / Withdraw"
 * @value 1
 * @option Right to "category"
 * @value 2
 * @option Right to "Info"
 * @value 3
 * @default 2
 * @parent PNDK_LC
 * 
 * @param CP Width
 * @type number
 * @min 0
 * @max 816
 * @decimals 0
 * @default 250
 * @parent PNDK_LC
 * 
 * @param --- Special Options ---
 * 
 * @param Category Auto Hidden
 * @desc Automatically hide a category when there is only one category.(Default:Disable)
 * @type boolean
 * @on Enable
 * @off Disable
 * @default false
 *
 * 
 @help

 Warehouse/Storage Plugin
 created by PrimeHover

 Check out the full documentation at: https://github.com/PrimeHover/Warehouse
 Check out an illustrative example of using the commands and rules at: http://forums.rpgmakerweb.com/index.php?/topic/50503-ph-warehousestorage/
 Check out the portuguese example at: http://www.mundorpgmaker.com.br/topic/114053-ph-warehousestorage/

 ----------------------------------------------------------------------------------------------------------------------------------

 Plugin Commands:

 - PHWarehouse create <Title of the Warehouse>                      # Creates a warehouse
 - PHWarehouse create <Title of the Warehouse:50>                   # Creates a warehouse and sets its maximum capacity to 50
 - PHWarehouse create <Title of the Warehouse:50:rule>              # Creates a warehouse, sets its maximum capacity to 50 and sets a rule

 - PHWarehouse show <Title of the Warehouse>                        # Shows a warehouse
 - PHWarehouse remove <Title of the Warehouse>                      # Removes a warehouse

 - PHWarehouse add item <Title of the Warehouse:id:quantity>        # Add an item immediately inside a created warehouse
 - PHWarehouse add weapon <Title of the Warehouse:id:quantity>      # Add a weapon immediately inside a created warehouse
 - PHWarehouse add armor <Title of the Warehouse:id:quantity>       # Add an armor immediately inside a created warehouse
 - PHWarehouse add keyItem <Title of the Warehouse:id:quantity>     # Add a key item immediately inside a created warehouse

 - PHWarehouse capacity set <Title of the Warehouse:quantity>       # Set a new maximum capacity for a warehouse already created
 - PHWarehouse capacity increase <Title of the Warehouse:quantity>  # Increase the maximum capacity for a warehouse already created
 - PHWarehouse capacity decrease <Title of the Warehouse:quantity>  # Decrease the maximum capacity for a warehouse already created

 - PHWarehouse setRule <Title of the Warehouse:rule>                # Set warehouse rules
----------------------------------------------------------------------------------------------------------------------------------

Script Commands:

 - PHPlugins.PHWarehouse.prototype.exist("Title of the Warehouse");                                # Verifies if a warehouse exists

 - PHPlugins.PHWarehouse.prototype.getMaxCapacity("Title of the Warehouse");                       # Gets the maximum capacity of a warehouse
 - PHPlugins.PHWarehouse.prototype.getCurrentCapacity("Title of the Warehouse");                   # Gets the current capacity of a warehouse

 - PHPlugins.PHWarehouse.prototype.hasItem("Title of the Warehouse", id);                          # Verifies if a warehouse has a particular item and returns the quantity of this item inside the warehouse
 - PHPlugins.PHWarehouse.prototype.hasWeapon("Title of the Warehouse", id);                        # Verifies if a warehouse has a particular weapon and returns the quantity of this item inside the warehouse
 - PHPlugins.PHWarehouse.prototype.hasArmor("Title of the Warehouse", id);                         # Verifies if a warehouse has a particular armor and returns the quantity of this item inside the warehouse
 - PHPlugins.PHWarehouse.prototype.hasKeyItem("Title of the Warehouse", id);                       # Verifies if a warehouse has a particular key item and returns the quantity of this item inside the warehouse

 ----------------------------------------------------------------------------------------------------------------------------------

Rule Commands:

    Rules are a simple way to manage which items you can store in a specific warehouse.
    In order to create a rule for your warehouse, you have to create a Common Event in the database called "PHWarehouse".
    Inside of that Common Event, you will create some comments in order to populate the rules for warehouses.
    These comments must have the following format:

    {Title of the Rule}
    [commands]

    The [commands] you can specify are as follow:

    item: 1 (Just allow the storage of the item with id 1)
    item: 1, 2, 3, 4 (Allows the storage of items with id 1, 2, 3 and 4)
    item: no (Does not allow the storage of items)
    item-n: 1 (Allows the storage of any item except the one with id 1)
    (If you don't specify the command "item" in the rule, all items will be allowed to be stored)

    weapon: 1 (Just allow the storage of the weapon with id 1)
    weapon: 1, 2, 3, 4 (Allows the storage of weapons with id 1, 2, 3 and 4)
    weapon: no (Does not allow the storage of weapons)
    weapon-n: 1 (Allows the storage of any weapon except the one with id 1)
    (If you don't specify the command "weapon" in the rule, all weapons will be allowed to be stored)

    armor: 1 (Just allow the storage of the armor with id 1)
    armor: 1, 2, 3, 4 (Allows the storage of armors with id 1, 2, 3 and 4)
    armor: no (Does not allow the storage of armors)
    armor-n: 1 (Allows the storage of any armor except the one with id 1)
    (If you don't specify the command "armor" in the rule, all armors will be allowed to be stored)

    keyItem: 1 (Just allow the storage of the key item with id 1)
    keyItem: 1, 2, 3, 4 (Allows the storage of key items with id 1, 2, 3 and 4)
    keyItem: no (Does not allow the storage of key items)
    keyItem-n: 1 (Allows the storage of any key item except the one with id 1)
    (If you don't specify the command "keyItem" in the rule, all key items will be allowed to be stored)

 */
/*:ja
 *
 * PH - Warehouse/Storage
 * @plugindesc アイテムを保管できる倉庫を作成できます。にゃたま改変版 V1.4.3
 * @target MV MZ
 * @author PrimeHover & にゃたま
 *
 * ■にゃたま版更新履歴
 * 
 * v1.4.3b  [2024/03/17]  自分でバグ修正（https://tm.lucky-duet.com/viewtopic.php?t=13689
 * v1.4.3  [2022/04/26]  YEP_CoreEngineが有効だとアイテム名の幅が圧縮されるので修正しました。
 *                       this.drawWarehouseItemNumberの桁数指定のない以前のバージョンを復活させました。
 * v1.4.2  [2022/04/11]  小数点以下の表示桁数を常にウィンドウに反映させました。
 * v1.4.1  [2022/04/10]  最大預入アイテム数に達した時、アイテム数の色を変更できるようにしました。
 * v1.4.0  [2022/04/09]  アイテムの種類ごとに上限数量を設定できるようにしました。０だとこれまで同様無制限です。
 *                       但しADDコマンドで上限を超えて入れることはできます。更に退出時確認ウィンドウが表示可能になりました。
 * v1.3.28 [2022/04/03]  NYA_PNDK_LC v1.0.17以上 小数点以下の表示桁数に対応＆アイテム数の表示形式を変更しました。
 * v1.3.27 [2022/02/23]  drawItemNameWithCPが廃止されたことに伴い記入例を削除しました。
 * v1.3.26 [2021/10/07]  倉庫生成時、最大容量を0とした時、最大容量を無制限となるようにしました。
 * v1.3.25 [2021/10/06]  MV版のみYanaさんのItemSortプラグインに対応しました。
 * v1.3.24 [2021/10/05]  プラグインリストでこのプラグインが他のプラグインより上でも動作するようにしました。
 * v1.3.23 [2021/10/04]  タイトル文字の透明化を設定できるようにしました。
 * v1.3.22 [2021/10/02]  タイトルウィンドウの背景透明化を設定できるようにしました。
 * v1.3.21 [2021/10/02]  MZ版のみ画面最上部位置にCPウィンドウを設定できるようにしました。
 * v1.3.20 [2021/09/30]  トリアコンタンさんのThroughFailedToLoadに対応しました。タグ画像がなくてもEmptyImageを表示します。
 * v1.3.19 [2021/09/28]  ルール違反に入力例を追加しました。
 * v1.3.18 [2021/09/27]  ルール違反追加機能を追加しました。
 * v1.3.17 [2021/09/26]  アイテム(リスト＆情報)描画ｽｸﾘﾌﾟﾄを追加しました。NYA_PNDK_LuggageCapacityは1.0.9以上を導入必須です。
 * v1.3.16 [2021/09/24]  v1.3.15の修正でアイテムの初期画像が表示されない問題を修正しました。
 * v1.3.15 [2021/09/23]  一部の不要なメソッドを削除しました。若干レスポンスが向上したかもしれません。
 * v1.3.14 [2021/09/22]  情報スペース（倉庫容量）のフォーマットをユーザー設定可能にしました。制御文字が使用可能です
 * v1.3.13 [2021/09/22]  アイテム画像表示する時にCP表示のフォーマットをユーザー設定可能にしました。制御文字が使用可能です
 * v1.3.12 [2021/09/19]  預入引出時のサウンドファイルを指定できるようにしました
 * v1.3.11 [2021/09/17]  武器、防具をADDコマンドで追加できない問題を修正しました
 * v1.3.10 [2021/09/17]  MZ版のみ倉庫画面のウィンドウ開始位置を画面最上部に変更できる設定を追加
 * v1.3.9  [2021/09/16]  ヘルプの記述を微妙に修正
 * v1.3.8  [2021/09/16]  MZ版のレイアウトを右上のボタンと重ならないように少々修正＆パラメータのテキストを少々変更
 * v1.3.7  [2021/09/13]  一部パラメータのデフォルト設定を修正しました＆預けたり引き出す時に枠が残ってたのを修正
 * v1.3.6  [2021/09/07]  英語のパラメータ名に関する表記を追加
 * v1.3.5  [2021/09/05]  倉庫画面に関する各種バグ修正
 * v1.3.4  [2021/09/04]  StackItemQuantityが有効時エラーしていたのを修正しました
 * v1.3.3  [2021/09/04]  AllTogether有効時のバグ修正＆リファクタリング
 * v1.3.2  [2021/09/04]  アイテム画像を表示できる機能を追加しました
 * v1.3.1  [2021/09/03]  背景画像の設定を変えられないバグを修正しました
 * v1.3.0  [2021/09/02]  ツクールMZに対応し大幅にリファクタリング及び改修しました
 * v1.2.7  [2020/04/26]  シンプルモード機能廃止、カテゴリ自動非表示機能追加
 * v1.2.6  [2020/04/08]  バグ修正＆カテゴリごとに一括で預ける機能の追加
 * v1.2.5  [2020/04/05]  TM_ItemCategoryExのファイル名を指定できるようにした
 * v1.2.4  [2020/04/03]  ヘルプにTM_ItemCategoryExとFTKR_MenuEventの改変方法を追記
 * v1.2.3  [2020/04/02]  ルールに該当しないものは倉庫に追加できないようにした
 * v1.2.2  [2020/03/31]  All Together有効時にエラーがあったので修正
 * v1.2.1  [2020/03/30]  背景画像設定等付加機能追加＆バグ修正
 * v1.2.0  [2020/03/30]  TM_ItemCategoryExに対応しました。
 * 
 * ----------------------------------------------------------------------------
 * This work is licensed under the Creative Commons Attribution 4.0 International License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/
 * ----------------------------------------------------------------------------
 *
 * @command create
 * @text 倉庫作成
 * @desc 倉庫を作成します
 * 
 * @arg create_title
 * @text 倉庫名
 * @desc 作成する倉庫の名前を入力します
 * @default 
 * 
 * @arg create_capacity
 * @text 最大容量
 * @desc 倉庫の最大容量を入力します(0にすると無制限になります)
 * ※入力を省略すると自動的に50が設定されます
 * @type number
 * default 50
 * 
 * @arg create_rule
 * @text ルール
 * @desc 倉庫のルールを入力します
 * ※入力を省略するとルール無しとされます
 * 
 * @command show
 * @text 倉庫表示
 * @desc 倉庫シーンを表示します
 * 
 * @arg show_title
 * @text 倉庫名
 * @desc 倉庫表示する倉庫名を入力します
 * @default 
 * 
 * @command remove
 * @text 倉庫削除
 * @desc 倉庫を削除します
 * 
 * @arg remove_title
 * @text 倉庫名
 * @desc 倉庫削除する倉庫名を入力します
 * @default 
 *
 * 
 * @command addItem
 * @text 倉庫にアイテムを追加
 * @desc 倉庫にアイテムを追加します
 *
 * @arg addItem_title
 * @text 倉庫名
 * @desc 追加する対象の倉庫名を入力します
 * @default 
 * 
 * @arg addItem_itemId
 * @text 追加するアイテム
 * @desc 追加するアイテムを選択します
 * @type item
 * @default 0
 * 
 * @arg addItem_quantity
 * @text 追加する数
 * @desc いくつ追加するかを入力します
 * @type number
 * @default 1
 * 
 * 
 * @command addWeapon
 * @text 倉庫に武器を追加
 * @desc 倉庫に武器を追加します
 *
 * @arg addWeapon_title
 * @text 倉庫名
 * @desc 追加する対象の倉庫名を入力します
 * @default
 * 
 * @arg addWeapon_itemId
 * @text 追加する武器
 * @desc 追加する武器を選択します
 * @type weapon
 * @default 0
 * 
 * @arg addWeapon_quantity
 * @text 追加する数
 * @desc いくつ追加するかを入力します
 * @type number
 * @default 1
 * 
 * 
 * @command addArmor
 * @text 倉庫に防具を追加
 * @desc 倉庫に防具を追加します
 *
 * @arg addArmor_title
 * @text 倉庫名
 * @desc 追加する対象の倉庫名を入力します
 * @default
 * 
 * @arg addArmor_itemId
 * @text 追加する防具
 * @desc 追加する防具を選択します
 * @type armor
 * @default 0
 * 
 * @arg addArmor_quantity
 * @text 追加する数
 * @desc いくつ追加するかを入力します
 * @type number
 * @default 1
 * 
 * 
 * @command capacitySet
 * @text 倉庫の最大容量を変更
 * @desc 倉庫の最大容量を変更します
 * 
 * @arg capacitySet_title
 * @text 倉庫名
 * @desc 最大容量を変更する対象の倉庫名を入力します
 * @default 
 *
 * @arg capacitySet_quantity
 * @text 最大容量
 * @desc 倉庫の最大容量を入力します
 * @default 
 * 
 * 
 * @command capacityInc
 * @text 倉庫の最大容量を増やす
 * @desc 倉庫の最大容量を増やします
 * 
 * @arg capacityInc_title
 * @text 倉庫名
 * @desc 最大容量を増やす対象の倉庫名を入力します
 * @default 
 *
 * @arg capacityInc_quantity
 * @text 増やす量
 * @desc 増やしたい量を入力します
 * @default 
 * 
 * 
 * @command capacityDec
 * @text 倉庫の最大容量を減らす
 * @desc 倉庫の最大容量を減らします
 * 
 * @arg capacityDec_title
 * @text 倉庫名
 * @desc 最大容量を減らす対象の倉庫名を入力します
 * @default 
 *
 * @arg capacityDec_quantity
 * @text 減らす量
 * @desc 減らしたい量を入力します
 * @default 
 * 
 * @command bgSet
 * @text 背景画像を設定
 * @desc 倉庫画面に背景画像を指定します。img/pictures に置いてください。
 *
 * @arg bgSet_file
 * @text 背景画像ファイル
 * @desc 背景画像を変更する対象の倉庫名を入力します
 * @type file
 * @require 1
 * @dir img/pictures
 * @default
 *
 * 
 * @command bgReset
 * @text 背景画像をリセット
 * @desc 倉庫画面の背景画像を初期値にリセットします
 * 
 * 
 * @command setRule
 * @text 倉庫にルールを設定
 * @desc 倉庫のルールを変更できます
 * 
 * @arg setRule_title
 * @text 倉庫名
 * @desc 最大容量を減らす対象の倉庫名を入力します
 * @default 
 * 
 * @arg setRule_rule
 * @text ルール
 * @desc 設定したいルールを入力します
 * 
 * @command collectiveDeposit
 * @text カテゴリごとにまとめて預ける
 * @desc 指定カテゴリの所持物全てまとめて預けます
 * 
 * @arg collectiveDeposit_title
 * @text 倉庫名
 * @desc 最大容量を減らす対象の倉庫名を入力します
 * @default 
 *
 * @arg collectiveDeposit_category
 * @text 預けたいカテゴリ
 * @desc 預けたいカテゴリを指定します
 * @type combo
 * @option item
 * @option weapon
 * @option armor
 * @option keyItem
 * @option all
 * @default all
 *
 * @arg collectiveDeposit_rule
 * @text 預けるルール
 * @desc 預けるルールを指定します
 * ※ルールを指定しない場合現在のルールに従って預けます
 * @default 
 * 
 *
 * 
 * @param --- OPTION ---
 * @text --- オプション ---
 *
 * @param All Together
 * @text カテゴリ統一
 * @desc 全カテゴリを統一する。
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 *
 * @param All Text
 * @text カテゴリ統一テキスト
 * @desc パラメータ "All Together"がtrueに設定されている場合、オプション "All"の表示テキスト
 * @default 全て
 * @parent All Together
 * 
 * @param Info Type
 * @text 情報ウィンドウの表示形式
 * @desc 情報ウィンドウに表示する形式。
 * Default【true:利用済み】
 * @type boolean
 * @on 利用済み
 * @off 利用可能
 * @default true
 * 
 * @param Info Space Format
 * @text 情報ウィンドウの書式
 * @desc %1:現在値(空き/含む)  %2:最大値  ※一部制御文字可能
 * Default【\C[16]利用済みスペース\C[0]  %1 \C[16]/\C[0] %2】
 * @type string
 * @default \C[16]利用済みスペース\C[0]  %1 \C[16]/\C[0] %2
 * @parent Info Type
 * 
 * @param Stack Item Quantity
 * @text 1種類で1スペース
 * @desc 同種の複数のアイテムを容量の1つのスペースと見なす
 * (有効: 1種類で1スペース, 無効: 1個で1スペース)
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * 
 * @param Auto Discard
 * @text 容量オーバー時自動破棄
 * @desc addコマンドで倉庫に追加する時、倉庫の容量をオーバー
 * した分自動破棄します。(デフォルト:有効)
 * @type boolean
 * @on 有効
 * @off 無効
 * @default true
 * 
 * @param Max Item Quantity
 * @text 最大預入アイテム数量
 * @desc アイテム種別ごとに預入可能なアイテム数です(0で無制限)
 * @default 99
 * @type number
 * 
 * @param Max Item Color
 * @text 最大預入アイテム色
 * @desc アイテム種別ごとに預入限界に達したときに
 * 該当アイテムの数量がこの色に変わります Color(HEX) #ff80ff
 * @default #ff80ff
 * @type string
 * @parent Max Item Quantity
 * 
 * @param Over Quantity title
 * @text タイトル
 * @desc アイテム預入上限数オーバー時の警告ウィンドウのタイトル
 * @default アイテム預入上限オーバー
 * @type string
 * @parent Max Item Quantity
 * 
 * @param Over Quantity message
 * @text 本文メッセージ
 * @desc アイテム預入上限数オーバー時の警告ウィンドウのメッセージ
 * @default "このアイテムの預入上限に達しました\nこれ以上このアイテムを預けることはできません"
 * @type note
 * @parent Max Item Quantity
 * 
 * @param Exit Confirm
 * @text 退出時確認ウィンドウ表示
 * @desc 倉庫から退出時に確認ウィンドウを表示します
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * 
 * @param Exit Confirm Title
 * @text タイトル
 * @desc 退出時確認ダイアログのタイトル
 * @default 退出確認
 * @type string
 * @parent Exit Confirm
 * 
 * @param Exit Confirm Message
 * @text 本文メッセージ
 * @desc 退出時確認ダイアログの本文メッセージ
 * @default "本当に退出してもよろしいですか？\n"
 * @type note
 * @parent Exit Confirm
 * 
 * @param Exit Confirm Btn Ok
 * @text 退出ボタン名
 * @desc 退出時確認ダイアログの退出ボタン
 * @default 退出する
 * @type string
 * @parent Exit Confirm
 * 
 * @param Exit Confirm Btn Cancel
 * @text 非退出ボタン名
 * @desc 退出時確認ダイアログの非退出ボタン
 * @default 退出しない
 * @type string
 * @parent Exit Confirm
 * 
 * @param Add Rule Violation
 * @text ルール違反追加
 * @desc この式リストのうちいずれか１つでも成立したらルール違反となる。変数[item]から各要素が参照できます。
 * @type combo[]
 * @default ["item.meta['NoDeposit'] // ｱｲﾃﾑのﾒﾓ欄に<NoDeposit>ﾀｸﾞのあるｱｲﾃﾑ"]
 * @option item.price === 0 // 金額ゼロの売却不可アイテム
 * @option item.itypeId === 2 // 大事なもの
 * @option item.meta['NoDeposit'] // ｱｲﾃﾑのﾒﾓ欄に<NoDeposit>ﾀｸﾞのあるｱｲﾃﾑ
 * @option item.meta['NoDepositSW3'] && $gameSwitches.value(3) // ｱｲﾃﾑのﾒﾓ欄に<NoDepositSW3>ﾀｸﾞがありｹﾞｰﾑｽｲｯﾁ3がONのとき違反
 * 
 * @param Deposit Sound File
 * @text 預けれた時のSE
 * @desc 預けれた時のSEを指定します。
 * ※指定の無い場合は装備時のSEになります
 * @type file
 * @require 1
 * @dir audio/se
 * @default
 * @parent otherType
 * 
 * @param Withdraw Sound File
 * @text 引き出した時のSE
 * @desc 引き出した時のSEを指定します。
 * ※指定の無い場合は装備時のSEになります
 * @type file
 * @require 1
 * @dir audio/se
 * @default
 * @parent otherType
 * 
 * @param Buzzer Sound File
 * @text 預入引出失敗時のSE
 * @desc 預入引出に失敗した時のSEを指定します。
 * ※指定の無い場合はブザーのSEになります
 * @type file
 * @require 1
 * @dir audio/se
 * @default
 * @parent otherType
 * 
 * @param --- Display Options ---
 * @text --- 表示設定 ---
 * 
 * @param ItemList DrawScript
 * @text アイテムリスト描画ｽｸﾘﾌﾟﾄ
 * @desc 項目を描画するスクリプトです。変数[item]から各要素が参照できます。
 * @default ["this.drawIcon(item.iconIndex, r.x + 2, r.y + 2);", "this.drawText(this.getItemName(item), r.x + this.iconBoxWidth(), r.y, r.width - this.numberWidth() - this.iconBoxWidth(), 'left');", "this.drawWarehouseItemColon(r.x, r.y, r.width, 2);", "this.drawWarehouseItemNumber(item, r.x, r.y, r.width, 2);"]
 * @type combo[]
 * @option ------------(デフォルト設定)-------------
 * @option this.drawIcon(item.iconIndex, r.x + 2, r.y + 2); // デフォルト１行目
 * @option this.drawText(this.getItemName(item), r.x + this.iconBoxWidth(), r.y, r.width - this.numberWidth() - this.iconBoxWidth(), 'left'); // デフォルト２行目
 * @option this.drawWarehouseItemColon(r.x, r.y, r.width, 2); // デフォルト ３行目
 * @option this.drawWarehouseItemNumber(item, r.x, r.y, r.width, 2); // デフォルト ４行目
 * @option this.drawWarehouseItemNumber(item, r.x, r.y, r.width); // 旧デフォルト ３行目（以前の仕様,桁数を省略すると自動で:を付与）
 * @option --------------(サンプル)----------------
 * @option this.drawText(this.getItemName(item), r.x + this.iconBoxWidth(), r.y, r.width - this.numberWidth() - this.iconBoxWidth(), 'left'); // アイテムの名称(左揃え)
 * @option this.drawText(this.getItemNameWithCP(item), r.x + this.iconBoxWidth(), r.y, r.width - this.numberWidth() - this.iconBoxWidth(), 'left'); // アイテムの名称(左揃え、PNDK_LC対応)
 * @option this.drawItemName(item, r.x, r.y, r.width - this.numberWidth()); // アイテムの名称(左揃え、アイコン含む)
 * @option this.drawWarehouseItemNumber(item, r.x, r.y, r.width); // :を含んだアイテム数
 * @option this.drawNoteText('noteValue', r.x, r.y); // 指定したメモ欄の内容を描画
 * @option this.drawIcon(item.iconIndex, r.x, r.y, r.width); // アイコン
 * @option this.drawTextEx(`Text:${item.name}`, r.x, r.y, r.width); // 任意のテキスト描画(制御文字変換あり)
 * @option this.drawText(`Text:${item.name}`, r.x, r.y, r.width, 'right'); // 任意のテキスト描画(制御文字変換なし。右揃え)
 * @option this.changeTextColor(this.textColor(1)); // テキストカラー変更(drawTextでのみ有効)
 * 
 * 
 * @param Show Item Info
 * @text アイテム情報ｳｨﾝﾄﾞｳ表示
 * @desc アイテムの画像を表示したりメモ欄の情報などを表示したり様々な活用が可能。表示内容は[ｱｲﾃﾑ情報描画ｽｸﾘﾌﾟﾄ]項目で設定。
 * @type boolean
 * @default false
 * 
 * @param ItemInfo DrawScript
 * @parent Show Item Info
 * @text アイテム情報描画ｽｸﾘﾌﾟﾄ
 * @desc 項目を描画するスクリプトです。変数[item]から各要素が参照できます。
 * @default ["this.drawText(item.name, r.x, r.y, r.width, 'center');", "this.drawItemPicture(r.x, r.y + this.lineHeight())", "this.drawCP(r.x, r.y + 270, r.width);"]
 * @type combo[]
 * @option ------------(デフォルト設定)-------------
 * @option this.drawText(item.name, r.x, r.y, r.width, 'center'); // デフォルト１行目
 * @option this.drawItemPicture(r.x, r.y + this.lineHeight()) // デフォルト２行目
 * @option this.drawCP(r.x, r.y + 270, r.width); // デフォルト３行目 (CP Format書式値)
 * @option ---------------(サンプル)---------------
 * @option this.drawText(this.getItemName(item), r.x, r.y, r.width, 'center'); // アイテムの名称(中央揃え)
 * @option this.drawText(this.getItemNameWithCP(item), r.x, r.y, r.width, 'center'); // アイテムの名称(中央揃え、PNDK_LC対応)
 * @option this.drawItemName(item, r.x, r.y, r.width); // アイテムの名称(左揃え、アイコン含む)
 * @option this.drawNoteText('noteValue', r.x, r.y); // 指定したメモ欄の内容を描画
 * @option this.drawIcon(item.iconIndex, r.x, r.y, r.width); // アイコン
 * @option this.drawTextEx(`Text:${item.name}`, r.x, r.y, r.width); // 任意のテキスト描画(制御文字変換あり)
 * @option this.drawText(`Text:${item.name}`, r.x, r.y, r.width, 'right'); // 任意のテキスト描画(制御文字変換なし。右揃え)
 * @option this.changeTextColor(this.textColor(1)); // テキストカラー変更(drawTextでのみ有効)
 * @option this.drawItemPicture(r.x, r.y); // 指定タグのピクチャを描画
 * @option this.drawNotePicture('noteValue', r.x, r.y); // 指定したメモ欄のピクチャを描画(第４引数:width 第５引数:height 省略時236)
 * @option this.drawPicture('pictureFileName', r.x, r.y); // 指定したメモ欄のピクチャを描画(第４引数:width 第５引数:height 省略時236)
 *
 * @param Withdraw Text
 * @desc オプション "Withdraw"の表示テキスト
 * @default 引き出す
 *
 * @param Deposit Text
 * @desc オプション "Deposit"の表示テキスト
 * @default 預ける
 * 
 * @param Window StartPosition
 * @text [MZ]ｳｨﾝﾄﾞｳ開始位置最上部
 * @desc true:倉庫画面の最上部から描画します
 * false:メインエリアの最上部から描画します
 * @type boolean
 * @on 画面の最上部から
 * @off メインエリアの最上部から
 * @default false
 * 
 * @param Title Text Hide
 * @text タイトル文字の透明化
 * @desc タイトル文字を透明化します。(デフォルト:無効)
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * 
 * @param Title Window BG Hide
 * @text ﾀｲﾄﾙｳｨﾝﾄﾞｳの背景透明化
 * @desc タイトルウィンドウの背景(枠)を透明化します。(デフォルト:無効)
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * 
 * @param All Window BG Hide
 * @text 全てのｳｨﾝﾄﾞｳの背景透明化
 * @desc 全てのウィンドウの背景(枠)を透明化します。自作背景にしたいとき
 * 便利にご利用いただけます。(デフォルト:無効)
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * 
 * @param Background Image
 * @text 背景画像
 * @desc 背景画像を指定します。img/pictures に置いてください。
 * @type file
 * @require 1
 * @dir img/pictures/
 * @default
 * 
 * 
 * @param Item Folder
 * @text アイテム画像のあるﾌｫﾙﾀﾞ
 * @desc アイテム画像のフォルダを指定します
 * Defalt: pictures
 * @type file
 * @require 1
 * @dir img
 * @default pictures
 * @parent Show Item Info
 * 
 * @param Item Tag Name
 * @text アイテム画像のタグ名
 * @desc アイテムのメモ欄に<(タグ名):apple>で「apple.png」を読み込みます。
 * @default image
 * @parent Show Item Info
 * 
 * @param EmptyItem Picture File
 * @text ｱｲﾃﾑ画像無し時の画像
 * @desc アイテム画像のタグが設定されてない時に表示する画像ファイル
 * @type file
 * @require 1
 * @dir img
 * @default pictures/EmptyImage
 * @parent Show Item Info
 * 
 * @param CP Format
 * @text [PNDK_LC]重量表示の書式
 * @desc %1:重さの用語 %2:重さ %3:重さの単位
 * Default【\C[16]%1\C[0] %2\C[16]%3】※一部の制御文字が使用可能です 
 * @default \C[16]%1\C[0] %2\C[16]%3
 * @parent Show Item Info
 * 
 * @param --- PNDK_LC Setting ---
 * @text --- PNDK_LC有効時設定 ---
 *
 * @param CP Layout Top For MZ
 * @text [MZ]CP位置を最上部設定
 * @desc MZ版のみCPの位置を最上部にします
 * @type boolean
 * @on 有効
 * @off 無効
 * @default true
 *
 * @param CP Layout
 * @text PNDK_LC有効時のCP位置
 * @desc [1]預ける／引き出すの右 [2]カテゴリの右 [3]インフォの右
 * @type select
 * @option 預ける／引き出すの右
 * @value 1
 * @option カテゴリの右
 * @value 2
 * @option インフォの右
 * @value 3
 * @default 2
 * @parent PNDK_LC
 * 
 * @param CP Width
 * @text PNDK_LC有効時のCP横幅
 * @type number
 * @min 0
 * @max 816
 * @decimals 0
 * @default 250
 * @parent PNDK_LC
 * 
 * @param --- Special Options ---
 * @text --- 特殊オプション ---
 * 
 * @param Category Auto Hidden
 * @text カテゴリ自動非表示
 * @desc カテゴリが１つのときカテゴリを自動的に隠す(Default:無効)
 * 注:有効にするとCP位置が強制的に[インフォの右]に設定される
 * @type boolean
 * @on 有効
 * @off 無効
 * @default false
 * 
 * 
 * 
 * @help
 *
 * Warehouse/Storage Plugin
 * 作者: PrimeHover 改変: Nyatama
 * 
 * -----------------------------------------------------------------------------
 * 改変者にゃたまによる補足事項
 * -----------------------------------------------------------------------------
 * 【連携可能な対応プラグイン】※動作を確認しているリストです
 * NYA_TMItemCategoryEx
 * NYA_FTKR_ItemSubCommand
 * NYA_PNDK_LuggageCapacity
 * NYA_PH_Warehouse（このプラグイン）
 * ＜上記プラグイン順での動作を推奨します＞
 * 
 * 【改変箇所説明】 
 * ・PNDK_LuggageCapacityに対応しました（メイン）
 * ・「預ける」と「引き出す」のコマンド位置を逆にしました
 * ・情報ウィンドウの表示タイプを「利用可能スペース」と「利用済みスペース」で
 *   選択できるようにしました(デフォルト：利用済みスペース)
 * ・TMItemCategoryExに対応しました
 * ・背景画像を設定できるようにしました
 *   （上記に伴いプラグインパラメータとプラグインコマンド追加）
 * ・ウィンドウ背景（枠）を透明化できるようにしました
 * ・カテゴリごとにルールに基づき一括で預ける機能を追加しました
 * ・倉庫ウィンドウ内にアイテム画像を表示できる機能を追加しました。
 *   プラグインパラメータItem Tag Nameに指定したタグ(Defaultで<image:apple>)を
 *   アイテムのメモ欄に記載することで画像を表示可能。(拡張子.pngの記載は不要)
 *   画像サイズは256x256の正方形となります。各自ご用意ください。
 *   プラグインパラメータEmptyItem Picture Fileに同サイズのピクチャを指定
 *   するとアイテム画像が存在しないときにこちらに指定した画像を表示します。
 *   デフォルトの保存フォルダはimg/pictures/となります。
 * ・PNDK_LuggageCapacityが有効の場合はアイテム画像の下にCPを
 *   表示できます。MVではtextSizeEx()関数が使えない都合で左寄せになります。
 *   中央近くに表示したい場合は先頭にスペースを入れて対応してください。
 * 
 * 【TMItemCategoryExとの連携時の補足】
 * ・プラグインリストでこのプラグインの前にTMItemCategoryExを配置します。
 * 
 * 
 * 【改変バージョン利用の上での補足】
 * 万一この改変バージョンが役に立ってゲーム内で実際に使われお役に立てたのなら
 * 改変者として「にゃたま」をクレジットいただけると嬉しいです。
 * 本家作者様を掲載するついでに是非よろしくお願いします♪
 * 寄付いただける場合は以下のリンクより可能です。
 * 感謝の気持ちをカタチにしていただけましたらツクールでの活動を強化し皆様に還元できるかもしれません。
 * [300円寄付]https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=X2MUGB4EZPPX2
 * [500円寄付]https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=LBXHTG2CDZARL
 * [1,000円寄付]https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RH7PVVNZRVB4J
 * [3,000円寄付]https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=G9GW253AAJZXU
 * [5,000円寄付]https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=WBCV8MX7JKV9J
 * [1万円寄付]https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=8ASUWC8W65JEL
 * 
 * ----------------------------------------------------------------------------
 *
 * 詳細説明: https://github.com/PrimeHover/Warehouse
 * 次のURLにあるコマンドとルールの使用例を確認してください。
 * http://forums.rpgmakerweb.com/index.php?/topic/50503-ph-warehousestorage/
 * ポルトガル語の例を確認してください。
 * http://www.mundorpgmaker.com.br/topic/114053-ph-warehousestorage/
 *
 * 翻訳:ムノクラ
 * https://munokura.tk/
 * https://twitter.com/munokura/
 *
 * ----------------------------------------------------------------------------
 *
 * プラグインコマンド
 *
 * - PHWarehouse create <預かり所の名前>
 *     # 倉庫を作成
 * - PHWarehouse create <預かり所の名前:50>
 *     # 倉庫を作成し、その最大容量を50に設定
 * - PHWarehouse create <預かり所の名前:50:rule>
 *     # 倉庫を作成し、最大容量を50に設定し、ルールを設定
 *
 * - PHWarehouse show <預かり所の名前>
 *     # 倉庫を表示
 * - PHWarehouse remove <預かり所の名前>
 *     # 倉庫を削除
 *
 * - PHWarehouse add item <預かり所の名前:id:quantity>
 *     # 作成した倉庫内にアイテムを追加
 * - PHWarehouse add weapon <預かり所の名前:id:quantity>
 *     # 作成した倉庫内に武器を追加
 * - PHWarehouse add armor <預かり所の名前:id:quantity>
 *     # 作成した倉庫内に防具を追加
 * 注：倉庫内にアイテムを追加する際、容量内にアイテムが入らない場合は
 *    その分は追加されません。入らなかった分は自動的に破棄されます。
 *  （例えば残り容量２で重量１のものを３個以上入れようとしても
 *    ３個目以降は破棄されます）
 *    しかし、プラグインパラメータ容量オーバー時自動破棄を無効(false)にすると
 *    容量オーバーしても破棄されなくなります。
 *    つまりは倉庫の容量を超えて入れられます
 *
 * - PHWarehouse capacity set <預かり所の名前:quantity>
 *     # すでに作成されている倉庫の新しい最大容量を設定
 * - PHWarehouse capacity increase <預かり所の名前:quantity>
 *     # すでに作成されている倉庫の最大容量を増やす
 * - PHWarehouse capacity decrease <預かり所の名前:quantity>
 *     # すでに作成されている倉庫の最大容量を減らす
 *
 * - PHWarehouse bg set <ims/pictures/の画像ファイル名(拡張子なし)>
 *     # 背景画像を指定した画像ファイルに変更します(pngファイル)
 * - PHWarehouse bg reset
 *     # 背景画像をプラグインパラメータで指定した画像ファイルに変更します
 * 
 * - PHWarehouse setRule <預かり所の名前:rule>
 *     # すでに作成されている倉庫のルールを設定
 * 
 * - PHWarehouse deposit item <預かり所の名前:rule>
 *     # ルールで許可されているアイテムすべてを預けます
 * - PHWarehouse deposit weapon <預かり所の名前:rule>
 *     # ルールで許可されている武器すべてを預けます
 * - PHWarehouse deposit armor <預かり所の名前:rule>
 *     # ルールで許可されている防具すべてを預けます
 * - PHWarehouse deposit keyItem <預かり所の名前:rule>
 *     # ルールで許可されているキーアイテムすべてを預けます
 * - PHWarehouse deposit all <預かり所の名前:rule>
 *     # ルールで許可されている全カテゴリのすべてを預けます
 * 注1：上記depositコマンドはTM_ItemCategoryExが導入されていれば
 *     カスタムカテゴリでも可能です。
 * 注2：PNDK_LuggageCapacityが導入されている時、
 *     預けたことによって倉庫の容量をオーバーしても強制的に倉庫に入ります
 * 注3: ruleを指定するとそのルールで預けることができます。
 *     ruleを省略して<預かり所の名前>のみにする場合その倉庫に適用しているルールとなります。
 *       
 * ----------------------------------------------------------------------------
 *
 * スクリプトコマンド
 *
 * - PHPlugins.PHWarehouse.exist("Title of the Warehouse");
 *    # 倉庫が存在するかどうかを確認
 *
 * - PHPlugins.PHWarehouse.getMaxCapacity("Title of the Warehouse");
 *    # 倉庫の最大容量を取得
 * - PHPlugins.PHWarehouse.getCurrentCapacity("Title of the Warehouse");
 *    # 倉庫の現在の容量を取得
 * - PHPlugins.PHWarehouse.getSurplusCapacity("Title of the Warehouse");
 *    # 倉庫の余剰容量を取得
 * 
 * - PHPlugins.PHWarehouse.hasItem("Title of the Warehouse", id);
 *    # 倉庫に特定のアイテムの数量を返す
 * - PHPlugins.PHWarehouse.hasWeapon("Title of the Warehouse", id);
 *    # 倉庫に特定の武器の数量を返す
 * - PHPlugins.PHWarehouse.hasArmor("Title of the Warehouse", id);
 *    # 倉庫に特定の防具の数量を返す
 * - PHPlugins.PHWarehouse.hasKeyItem("Title of the Warehouse", id);
 *    # 倉庫に特定の主要アイテムの数量を返す
 * 
 * - PHPlugins.PHWarehouse.isDepositItem("Title of the Warehouse", id, category);
 *    # 倉庫に特定のアイテムが入るかどうかを返す
 * 
 * - PHPlugins.PHWarehouse.currentRule("Title of the Warehouse");
 *    # 倉庫に設定されているルールを取得
 *
 * ----------------------------------------------------------------------------
 *
 * ルール
 *
 * ルールは、特定の倉庫に保管できるアイテムを管理するための簡単な方法です。
 *
 * 倉庫の規則を作成するために、
 * "PHWarehouse"という名前のコモンイベントの中に
 * 記述規則に即した注釈タグを作成しなければなりません。
 * 
 * 【POINT】このコモンイベントは複数作ることで
 * ゲーム内でプラグインコマンドによりルールの変更を行うことができます。
 *
 * 【POINT】これらの注釈タグは次の形式でなければなりません。
 * ▼▼▼▼▼注釈最上部▼▼▼▼▼
 * {Title of the Rule}
 * commands
 * commands
 *    :
 *    :
 * ▲▲▲▲▲注釈最下部▲▲▲▲▲
 * 
 * ー＜記述例＞ー
 * 
 * 注釈は２つを組み合わせることができます
 * 以下２つの注釈を同じコモンイベント 「PHWarehouse」内に記述
 * ▼▼▼▼注釈１最上部▼▼▼▼
 * {預かり所}
 * item: 2, 4
 * weapon: no
 * armor: ok
 * ▲▲▲▲注釈１最下部▲▲▲▲
 * 
 * ▼▼▼▼注釈２最上部▼▼▼▼
 * keyItem-n: no
 * カスタムカテゴリA: ok
 * カスタムカテゴリB: no
 * ▲▲▲▲注釈２最下部▲▲▲▲
 *
 * 指定できる[commands]は次のとおりです。
 *
 * item: 1
 *   (ただIDを持つアイテムの保管を許可する1)
 *
 * item: 1, 2, 3, 4
 *   (idが1、2、3、4のアイテムを保管できます)
 *
 * item: no
 *   (アイテムの保管はできません)
 *
 * item-n: 1
 *   (IDが1のアイテム以外のアイテムの保管を許可)
 *   (ルールで'item'というコマンドを指定しなければ、
 *    全てのアイテムを保管することができます)
 *
 * weapon: 1
 *   (ID 1の武器の保管を許可)
 *
 * weapon: 1, 2, 3, 4
 *   (ID 1、2、3、4の武器を保管可能)
 *
 * weapon: no
 *   (武器の保管を拒否)
 *
 * weapon-n: 1
 *   (IDが1の武器以外の武器の保管を許可)
 *   (ルールで "weapon"コマンドを指定しないと、
 *    全ての武器を保管することができます)
 *
 * armor: 1
 *   (ID 1の防具の保管を許可)
 *
 * armor: 1, 2, 3, 4
 *   (id 1、2、3、4の防具を保管可能)
 *
 * armor: no
 *   (防具の保管を拒否)
 *
 * armor-n: 1
 *   (IDが1の防具を除く全ての防具を保管可能)
 *   (ルールで"armor"コマンドを指定しなかった場合、
 *    全ての防具を保管することが許可されます)
 *
 * keyItem: 1
 *   (ID 1の大事なものの保管を許可するだけです)
 *
 * keyItem: 1, 2, 3, 4
 *   (IDが1、2、3、4の大事なものを保管できます)
 *
 * keyItem: no
 *   (大事なものの保管はできません)
 *
 * keyItem-n: 1
 *   (IDが1のものを除く全ての大事なものの保管を許可)
 *   (ルール内でコマンド"keyItem"を指定しないと、
 *    全ての大事なものの保管が許可されます)
 */

/* Global variable for PH Plugins */
var PHPlugins = PHPlugins || {};
PHPlugins.PluginName = 'NYA_PH_Warehouse';
PHPlugins.Parameters = PluginManager.parameters(PHPlugins.PluginName);
PHPlugins.Params = PHPlugins.Params || {};

var Imported = Imported || {};
Imported.PH_Warehouse = true;

/* Global variable for the list of quests */
PHPlugins.PHWarehouse = null;

/* Getting the parameters */
//String
PHPlugins.Params.PHWarehouseWithdrawText = String(PHPlugins.Parameters['Withdraw Text']);
PHPlugins.Params.PHWarehouseDepositText = String(PHPlugins.Parameters['Deposit Text']);
PHPlugins.Params.PHWarehouseWindowStartPosition = Boolean(eval(PHPlugins.Parameters['Window StartPosition']));

PHPlugins.Params.PHWarehouseInfoType = String(PHPlugins.Parameters['Info Type']);
PHPlugins.Params.PHWarehouseInfoSpaceFormat = String(PHPlugins.Parameters['Info Space Format']);

PHPlugins.Params.PHWarehouseAllText = String(PHPlugins.Parameters['All Text']);
PHPlugins.Params.PHWarehouseBackgroundImage = PHPlugins.Parameters['Background Image'];

PHPlugins.Params.PHWarehouseAddRuleViolation = PHPlugins.Parameters['Add Rule Violation'];

PHPlugins.Params.PHWarehouseDepositSoundFile = PHPlugins.Parameters['Deposit Sound File'];
PHPlugins.Params.PHWarehouseWithdrawSoundFile = PHPlugins.Parameters['Withdraw Sound File'];
PHPlugins.Params.PHWarehouseBuzzerSoundFile = PHPlugins.Parameters['Buzzer Sound File'];

PHPlugins.Params.PHWarehouseShowPicture = Boolean(eval(PHPlugins.Parameters['Show Item Info']));
PHPlugins.Params.PHWarehouseItemFolder = PHPlugins.Parameters['Item Folder'];
PHPlugins.Params.PHWarehouseItemTagName = PHPlugins.Parameters['Item Tag Name'];
PHPlugins.Params.PHWarehouseEmptyItemPictureFile = PHPlugins.Parameters['EmptyItem Picture File'];
PHPlugins.Params.PHWarehouseCpFormat = PHPlugins.Parameters['CP Format'];
PHPlugins.Params.PHWarehouseListItemNameFormat = PHPlugins.Parameters['(List) Item Name Format'];
PHPlugins.Params.PHWarehouseInfoItemNameFormat = PHPlugins.Parameters['(Info) Item Name Format'];
PHPlugins.Params.PHWarehouseItemListDrawScript = PHPlugins.Parameters['ItemList DrawScript'];
PHPlugins.Params.PHWarehouseItemInfoDrawScript = PHPlugins.Parameters['ItemInfo DrawScript'];

PHPlugins.Params.PHWarehouseMaxItemColor = PHPlugins.Parameters['Max Item Color'];
PHPlugins.Params.PHWarehouseOverQuantityTitle = PHPlugins.Parameters['Over Quantity title'];
PHPlugins.Params.PHWarehouseOverQuantityMessage = PHPlugins.Parameters['Over Quantity message'];

PHPlugins.Params.PHWarehouseExitConfirmTitle = PHPlugins.Parameters['Exit Confirm Title'];
PHPlugins.Params.PHWarehouseExitConfirmMessage = PHPlugins.Parameters['Exit Confirm Message'];
PHPlugins.Params.PHWarehouseExitConfirmBtnOk = PHPlugins.Parameters['Exit Confirm Btn Ok'];
PHPlugins.Params.PHWarehouseExitConfirmBtnCancel = PHPlugins.Parameters['Exit Confirm Btn Cancel'];

//Number
PHPlugins.Params.PHWarehouseCpLayout = Number(PHPlugins.Parameters['CP Layout']) || 2;
PHPlugins.Params.PHWarehouseCpWidth = Number(PHPlugins.Parameters['CP Width']) || 300;
PHPlugins.Params.PHWarehouseMaxItemQuantity = Number(PHPlugins.Parameters['Max Item Quantity']);

//Boolean
PHPlugins.Params.PHWarehouseCPLayoutTopForMZ = Boolean(eval(PHPlugins.Parameters['CP Layout Top For MZ']));
PHPlugins.Params.PHWarehouseTitleTextHide = Boolean(eval(PHPlugins.Parameters['Title Text Hide']));
PHPlugins.Params.PHWarehouseTitleWindowBgHide = Boolean(eval(PHPlugins.Parameters['Title Window BG Hide']));
PHPlugins.Params.PHWarehouseAllWindowBgHide = Boolean(eval(PHPlugins.Parameters['All Window BG Hide']));
PHPlugins.Params.PHWarehouseAllTogether = Boolean(eval(PHPlugins.Parameters['All Together']));
PHPlugins.Params.PHWarehouseStackItemQuantity = Boolean(eval(PHPlugins.Parameters['Stack Item Quantity']));
PHPlugins.Params.PHWarehouseAutoDiscard = Boolean(eval(PHPlugins.Parameters['Auto Discard']));
PHPlugins.Params.PHWarehouseCategoryAutoHidden = Boolean(eval(PHPlugins.Parameters['Category Auto Hidden']));
PHPlugins.Params.PHWarehouseCategoryExitConfirm = Boolean(eval(PHPlugins.Parameters['Exit Confirm']));

(function() {
    'use strict';
    var TMPlugins = TMPlugins || {};
    var PNDKPlugins = PNDKPlugins || {};

    function round(number, n) {
        if(!n) n = 0;
		const m = Math.pow(10.0, n);
		return (Math.round(number * m) / m).toFixed(n);
	}

    //"_sentence"(ダブルクォーテーション)を除去する
	function checkSentence(_sentence) {
        var regExp = /\"([^)]+)\"/;
        var matches = regExp.exec(_sentence);
        if (matches != null) {
            return matches[1];
        } else {
            return null;
        }
    };

    //配列から最長取得
    function findLong(str){
		var arr = checkSentence(str).split('\\n');
		var len = 0;
		var longest;
		for(var i=0; i < arr.length; i++){
			if(arr[i].length > len){
				var len = arr[i].length;
				longest = arr[i];
			}      
		} 
		return len;
	}
    
    /* ---------------------------------------------------------- *
     *                      WAREHOUSE MANAGER                     *
     * ---------------------------------------------------------- */

    function PHWarehouseManager() {
        this._rules = {};
        this._warehouses = {};
        this._lastActive = "";
        this._lastOption = null; // (default:0) 0 = Deposit(預ける), 1 = Withdraw(引き出す)
        this._lastCategory = ""; // (default:"item")

        if(Imported.TMItemCategoryEx){
            TMPlugins.Parameters = PluginManager.parameters('NYA_TMItemCategoryEx');
            if(!TMPlugins.Parameters['categoryList']) 
                console.error('NYA_TMItemCategoryExプラグインからcategoryListを取得できません');
            TMPlugins.Params = TMPlugins.Params || {};
            TMPlugins.Params.TMICexCategoryList = (TMPlugins.Parameters['categoryList'] || 
                'item weapon armor keyItem').split(' ');
        }
        if(Imported.PNDK_LuggageCapacity){
            PNDKPlugins.Parameters = PluginManager.parameters('NYA_PNDK_LuggageCapacity');
            PNDKPlugins.Params = PNDKPlugins.Params || {};
            PNDKPlugins.Params.wUnit = PNDKPlugins.Parameters['Unit'];
            PNDKPlugins.Params.wText = PNDKPlugins.Parameters['Attribute name'];
            PNDKPlugins.Params.decimalDigits = PNDKPlugins.Parameters['Decimal digits'];
            
        }
    }

    /* ---- BASIC OPERATIONS ---- */

    /* 倉庫が存在しない場合は作成します */
    /* Creates a warehouse if it does not exist */
    PHWarehouseManager.prototype.createWarehouse = function(_sentence) {
        //プラグインコマンドにcreateがある<>で囲まれたタグが_sentenceに入ってくる
        var matches = this.checkSentence(_sentence);
        var results;
        var title;
        var infinity = false;
        var rule = null;
        var capacity = 50;
        //<アイテム箱:10:itemOnly>
        if (matches != null) {
            //<>をとったアイテム箱:10:itemOnlyがmatchesに入ってくる
            //:区切りの配列をresultsに代入
            results = matches.split(":");
            //results[0]: title
            //results[1]: capacity
            //results[2]: rule
            title = results[0];
            if (!this._warehouses.hasOwnProperty(title)) {
                if (results.length >= 2) {
                    capacity = parseInt(results[1]);
                    if (isNaN(capacity)) {
                        capacity = 50;
                    }
                    if (capacity <= 0) {
                        capacity = 0;
                        infinity = true;
                    }
                    if (typeof results[2] !== "undefined" && this._rules.hasOwnProperty(results[2])) {
                        rule = results[2];
                    }
                }
                this._warehouses[title] = {
                    title: title,
                    infinity: infinity,
                    maxCapacity: capacity,
                    currentCapacity: 0,
                    rule: rule,
                    items: {
                        item: [],
                        weapon: [],
                        armor: [],
                        keyItem: []
                    },
                    qtty: {
                        item: [],
                        weapon: [],
                        armor: [],
                        keyItem: []
                    }
                };
                //TMItemCategoryExにより追加されたカテゴリの配列を生成する
                if(Imported.TMItemCategoryEx){
                    for (var j = 0; j < TMPlugins.Params.TMICexCategoryList.length; j++) {
                        var symbol = TMPlugins.Params.TMICexCategoryList[j];
                        this._warehouses[title].items[symbol] = [];
                        this._warehouses[title].qtty[symbol] = [];
                    }
                }
                console.log(results[0]+'を作成しました');
            }
            this._lastActive = title;
        }
    };

    /* 倉庫を開く */
    /* Opens a warehouse */
    PHWarehouseManager.prototype.openWarehouse = function(_sentence) {
        //プラグインコマンドにshowがある<>で囲まれたタグが_sentenceに入ってくる
        var matches = this.checkSentence(_sentence);
        if (matches != null) {
            //titleをthis._lastActiveに代入
            this._lastActive = matches;
        }
    };

    /* 倉庫を削除する */
    /* Remove a warehouse */
    PHWarehouseManager.prototype.removeWarehouse = function(_sentence) {
        var matches = this.checkSentence(_sentence);
        if (matches != null) {
            if (this._warehouses.hasOwnProperty(matches)) {
                delete this._warehouses[matches];
                console.log(matches+'を削除しました');
            }
        }
    };

    /* 倉庫にアイテムを追加する */
    /* Add item to a warehouse */
    PHWarehouseManager.prototype.addItems = function(_sentence, category) {
        //プラグインコマンドにaddがある<>で囲まれたタグが_sentenceに入ってくる&categoryにitem,weapon,armorのカテゴリ名が入ってくる
        var matches = this.checkSentence(_sentence);
        var results;
        
        //<預かり所の名前:id:quantity>
        if (matches != null) {
            results = matches.split(":");
            //results[0]: title （預かり所の名前）
            //results[1]: id
            //results[2]: quantity
            if(!results[1] || parseInt(results[1]) === 0){
                console.warn('アイテムIDが設定されてないので'+category+'を追加できません');
                return;
            }
            if(!results[2] || parseInt(results[2]) === 0){
                console.warn('アイテムの個数が設定されてないので'+category+'を追加できません');
                return;
            }
            //預かり所の名前、アイテムID、アイテム数が全て設定されていれば
            if (this._warehouses.hasOwnProperty(results[0]) && typeof results[1] !== "undefined" && typeof results[2] !== "undefined") {
                results[1] = parseInt(results[1]);
                results[2] = parseInt(results[2]);
                if(Imported.PNDK_LuggageCapacity) {
                    var weight;
                    if(category === 'item' || category === 'keyItem'){
                        weight = $gameSystem.getItemWeights(results[1]);
                        category = this.convertItemIdToCategory(results[1]);
                        //ルールに該当しないものはリターンして倉庫に入れないようにする
                        if(!PHPlugins.PHWarehouse.verifyItem($dataItems[results[1]])) {
                            console.warn(TextManager.item+'ID:'+results[1]+'「'+$dataItems[results[1]].name+'」は「'+results[0]+'」のルールで引出預入が許可されていません');
                            return;
                        }
                    } else if(category === 'weapon'){
                        weight = $gameSystem.getWeaponWeights(results[1]);
                        //ルールに該当しないものはリターンして倉庫に入れないようにする
                        if(!PHPlugins.PHWarehouse.verifyItem($dataWeapons[results[1]])) {
                            console.warn(TextManager.weapon+'ID:'+results[1]+'「'+$dataWeapons[results[1]].name+'」は「'+results[0]+'」のルールで引出預入が許可されていません');
                            return;
                        }
                    } else if(category === 'armor'){
                        weight = $gameSystem.getArmorWeights(results[1]);
                        //ルールに該当しないものはリターンして倉庫に入れないようにする
                        if(!PHPlugins.PHWarehouse.verifyItem($dataArmors[results[1]])) {
                            console.warn(TextManager.armor+'ID:'+results[1]+'「'+$dataArmors[results[1]].name+'」は「'+results[0]+'」のルールで引出預入が許可されていません');
                            return;
                        }
                    }
                    this._lastActive = results[0];
                    this._lastCategory = category;
                    //追加するアイテムの個数分ループ
                    for(var i=0;i<results[2];i++){
                        if (weight > this._warehouses[results[0]].maxCapacity - this._warehouses[results[0]].currentCapacity && !this._warehouses[results[0]].infinity) {
                            //倉庫の残り容量をアイテムの重量がオーバーしていて自動削除が有効ならアイテムを入れない
                            if(PHPlugins.Params.PHWarehouseAutoDiscard) {
                                console.log('倉庫の残り容量をアイテムの重量がオーバーした分は切り捨てられました');
                                return;
                            }
                        }
                        if (this._warehouses[results[0]].items[category].indexOf(results[1]) === -1) {
                            this._warehouses[results[0]].items[category].push(results[1]);
                        }
                        if (this._warehouses[results[0]].qtty[category][results[1]] === undefined){
                            this._warehouses[results[0]].qtty[category][results[1]] = 1;
                        }else{
                            this._warehouses[results[0]].qtty[category][results[1]] += 1;
                        }
                        this._warehouses[results[0]].currentCapacity += weight;
                    }
                }else{
                    if(category === 'item' || category === 'keyItem'){
                        category = this.convertItemIdToCategory(results[1]);
                        //ルールに該当しないものはリターンして倉庫に入れないようにする
                        if(!PHPlugins.PHWarehouse.verifyItem($dataItems[results[1]])) {
                            console.warn(TextManager.item+'ID:'+results[1]+'「'+$dataItems[results[1]].name+'」は「'+results[0]+'」のルールで引出or預入が許可されていません');
                            return;
                        }
                    } else if(category === 'weapon'){
                        //ルールに該当しないものはリターンして倉庫に入れないようにする
                        if(!PHPlugins.PHWarehouse.verifyItem($dataWeapons[results[1]])) {
                            console.warn(TextManager.weapon+'ID:'+results[1]+'「'+$dataWeapons[results[1]].name+'」は「'+results[0]+'」のルールで引出or預入が許可されていません');
                            return;
                        }
                    } else if(category === 'armor'){
                        //ルールに該当しないものはリターンして倉庫に入れないようにする
                        if(!PHPlugins.PHWarehouse.verifyItem($dataArmors[results[1]])) {
                            console.warn(TextManager.armor+'ID:'+results[1]+'「'+$dataArmors[results[1]].name+'」は「'+results[0]+'」のルールで引出or預入が許可されていません');
                            return;
                        }
                    }
                    this._lastActive = results[0];
                    this._lastCategory = category;
                    
                    //アイテム数が残り容量をオーバーするときは溢れた分を切り捨てる
                    if (results[2] > this._warehouses[results[0]].maxCapacity - this._warehouses[results[0]].currentCapacity && !this._warehouses[results[0]].infinity) {
                        results[2] = this._warehouses[results[0]].maxCapacity - this._warehouses[results[0]].currentCapacity;
                        console.warn('倉庫の容量をオーバーした分は切り捨てられました');
                    }
                    if (this._warehouses[results[0]].items[category].indexOf(results[1]) > -1) {
                        this._warehouses[results[0]].qtty[category][results[1]] += results[2];
                    } else {
                        this._warehouses[results[0]].items[category].push(results[1]);
                        this._warehouses[results[0]].qtty[category][results[1]] = results[2];
                    }
                    this._warehouses[results[0]].currentCapacity += results[2];
                }
                switch(category){
                    case 'item':
                        console.log(results[0]+'にアイテムカテゴリの「'+$dataItems[results[1]].name+'」を'+results[2]+'個追加しました');
                        break;
                    case 'weapon':
                        console.log(results[0]+'に武器カテゴリの「'+$dataWeapons[results[1]].name+'」を'+results[2]+'個追加しました');
                        break;
                    case 'armor':
                        console.log(results[0]+'に防具カテゴリの「'+$dataWeapons[results[1]].name+'」を'+results[2]+'個追加しました');
                        break;
                    case 'keyItem':
                        console.log(results[0]+'に大事なものカテゴリの「'+$dataItems[results[1]].name+'」を'+results[2]+'個追加しました');
                        break;
                    default:
                        console.log(results[0]+'に'+category+'カテゴリの「'+$dataItems[results[1]].name+'」を'+results[2]+'個追加しました');
                        break;
                }
            }
        }
    };

    PHWarehouseManager.prototype.convertItemIdToCategory = function(id){
        var item = $dataItems[id];
        if(Imported.TMItemCategoryEx) {
            //categoryにitemが入っているときmeta.itemCategoryに値が入っていればその値でcategoryを置き換える
            if(item.meta.itemCategory) return item.meta.itemCategory;
        }
        if(item.itypeId === 1) return 'item';
        if(item.itypeId === 2) return 'keyItem';
        return false;//例外でfalseを返す
    }

    PHWarehouseManager.prototype.bgSet = function(_sentence){
        var matches = this.checkSentence(_sentence);
        PHPlugins.Params.PHWarehouseBackgroundImage = matches;
    }

    PHWarehouseManager.prototype.bgReset = function(){
        PHPlugins.Params.PHWarehouseBackgroundImage = PHPlugins.Parameters['Background Image'];
    }

    /* カテゴリごとに倉庫に預ける */
    /* Deposit a warehouse */
    PHWarehouseManager.prototype.depositByCategory = function(_sentence, category) {
        //プラグインコマンドにshowがある<>で囲まれたタグが_sentenceに入ってくる
        var matches = this.checkSentence(_sentence);
        if (matches != null) {
            var results = matches.split(":");
            var title = results[0];
            var rule = results[1];
            //results[0]: title （預かり所の名前）
            
            //預かり所の名前が設定されていれば
            if (this._warehouses.hasOwnProperty(results[0])) {
                if(category === 'item' || category === 'keyItem'){
                    //itemカテゴリのアイテムを預ける
                    for(var id in $gameParty._items){
                        var num = $gameParty._items[id];
                        var item = $dataItems[id];
                        if(Imported.TMItemCategoryEx && item.meta.itemCategory) continue;
                        if(category === 'keyItem' && item.itypeId !== 2) continue;
                        if(category === 'item' && item.itypeId !== 1) continue;
                        this._lastCategory = category;
                        this._lastActive = title;
                        if (!PHPlugins.PHWarehouse.verifyItem(item, rule)) continue;
                        for(var i=0;i<num;i++){
                            PHPlugins.PHWarehouse.deposit(item);
                            $gameParty.loseItem(item, 1);
                            console.log('アイテムカテゴリの'+item.name+'を預けました');
                        }
                    }
                }else if(category === 'weapon'){
                    for(var id in $gameParty._weapons){
                        var num = $gameParty._weapons[id];
                        var item = $dataWeapons[id];
                        this._lastCategory = category;
                        this._lastActive = title;
                        if (!PHPlugins.PHWarehouse.verifyItem(item, rule)) continue;
                        for(var i=0;i<num;i++){
                            PHPlugins.PHWarehouse.deposit(item);
                            $gameParty.loseItem(item, 1);
                            console.log('武器カテゴリの'+item.name+'を預けました');
                        }
                    }
                }else if(category === 'armor'){
                    for(var id in $gameParty._armors){
                        var num = $gameParty._armors[id];
                        var item = $dataArmors[id];
                        this._lastCategory = category;
                        this._lastActive = title;
                        if (!PHPlugins.PHWarehouse.verifyItem(item, rule)) continue;
                        for(var i=0;i<num;i++){
                            PHPlugins.PHWarehouse.deposit(item);
                            $gameParty.loseItem(item, 1);
                            console.log('防具カテゴリの'+item.name+'を預けました');
                        }
                    }
                }else{
                    //item, weapon, armor以外のカスタムカテゴリ
                    for(var id in $gameParty._items){
                        var num = $gameParty._items[id];
                        var item = $dataItems[id];
                        if(Imported.TMItemCategoryEx && item.meta.itemCategory !== category) continue;
                        this._lastCategory = category;
                        this._lastActive = title;
                        if (!PHPlugins.PHWarehouse.verifyItem(item, rule)) continue;
                        for(var i=0;i<num;i++){
                            PHPlugins.PHWarehouse.deposit(item);
                            $gameParty.loseItem(item, 1);
                            console.log(category+'カテゴリの'+item.name+'を預けました');
                        }
                    }
                }
            }
        }
    };

    /* ---- RULE METHODS ---- */

    /* ルールを読み込む */
    /* Load rules */
    PHWarehouseManager.prototype.loadRules = function() {
        var warehouseVar = null;
        if ($dataCommonEvents) {
            for (var i = 0; i < $dataCommonEvents.length; i++) {
                if ($dataCommonEvents[i] instanceof Object && $dataCommonEvents[i].name == "PHWarehouse") {
                    warehouseVar = $dataCommonEvents[i].list;
                    if (warehouseVar != null) {
                        //ルールを設定する
                        this.populateRules(warehouseVar);
                    }
                }
            }
        }
        if(!this._rules){
            console.warn('ルールが一つも設定されていません');
        }
    };

    /* ルールを設定する */
    /* Populate rules */
    PHWarehouseManager.prototype.populateRules = function(warehouseVar) {
        var str = '';
        var index = -1;
        var rule;
        for (var i = 0; i < warehouseVar.length; i++) {
            if (warehouseVar[i].parameters[0]) {
                str = warehouseVar[i].parameters[0].trim();
                if (this.checkTitle(str)) {
                    str = str.slice(1, str.length-1);
                    this._rules[str] = {
                        enabledItems: {
                            item: [],
                            weapon: [],
                            armor: [],
                            keyItem: []
                        },
                        disabledItems: {
                            item: [],
                            weapon: [],
                            armor: [],
                            keyItem: []
                        }
                    };
                    //TMItemCategoryExにより追加されたカテゴリの配列を生成する
                    if(Imported.TMItemCategoryEx){
                        for (var j = 0; j < TMPlugins.Params.TMICexCategoryList.length; j++) {
                            var symbol = TMPlugins.Params.TMICexCategoryList[j];
                            this._rules[str].enabledItems[symbol] = [];
                            this._rules[str].disabledItems[symbol] = [];
                        }
                    }
                    index = str;
                } else if (this._rules[index]) {
                    rule = str.split(":");
                    rule[0] = rule[0].trim();
                    rule[1] = rule[1].trim();
                    if (rule[0].indexOf('-n') > -1) {
                        rule[0] = rule[0].replace("-n", "");
                        if (this._rules[index].disabledItems.hasOwnProperty(rule[0])) {
                            this._rules[index].disabledItems[rule[0]] = this.getItemsId(rule[1]);
                        }
                    } else {
                        if (this._rules[index].enabledItems.hasOwnProperty(rule[0])) {
                            if (rule[1].indexOf("no") > -1) {
                                this._rules[index].enabledItems[rule[0]] = false;
                            } else if(rule[1].indexOf("ok") > -1) {

                            } else {
                                this._rules[index].enabledItems[rule[0]] = this.getItemsId(rule[1]);
                            }
                        } 
                    }
                    this._rules['']
                }
            }
        }
    };

    /* 文字列がタイトルか説明かをチェックします */
    /* Checks if the string is a title or a description */
    PHWarehouseManager.prototype.checkTitle = function(str) {
        if (str.charAt(0) == "{" && str.charAt(str.length - 1) == "}") {
            return true;
        }
        return false;
    };

    /* idsを区切って配列にする */
    /* Separate ids and make it an array */
    PHWarehouseManager.prototype.getItemsId = function(str) {
        var arr = str.split(",");
        for (var i = 0; i < arr; i++) {
            arr[i] = parseInt(arr[i], 10);
        }
        return arr;
    };

    /* アイテムが有効かどうかをチェックします */
    /* Checks if items are enabled */
    PHWarehouseManager.prototype.isItemEnabled = function() {
        if (this._warehouses[this._lastActive].rule == null || 
            (this._rules.hasOwnProperty(this._warehouses[this._lastActive].rule) && 
            Array.isArray(this._rules[this._warehouses[this._lastActive].rule].enabledItems.item)) ){

            return true;
        }
        return false;
    };

    /* 武器が有効かどうかをチェックします */
    /* Checks if weapons are enabled */
    PHWarehouseManager.prototype.isWeaponEnabled = function() {
        if (this._warehouses[this._lastActive].rule == null || 
            (this._rules.hasOwnProperty(this._warehouses[this._lastActive].rule) && 
            Array.isArray(this._rules[this._warehouses[this._lastActive].rule].enabledItems.weapon))) {
            return true;
        }
        return false;
    };

    /* 防具が有効かどうかをチェックします */
    /* Checks if armors are enabled */
    PHWarehouseManager.prototype.isArmorEnabled = function() {
        if (this._warehouses[this._lastActive].rule == null || 
            (this._rules.hasOwnProperty(this._warehouses[this._lastActive].rule) && 
            Array.isArray(this._rules[this._warehouses[this._lastActive].rule].enabledItems.armor))) {
            return true;
        }
        return false;
    };

    /* キーアイテムが有効かどうかをチェックします */
    /* Checks if key items are enabled */
    PHWarehouseManager.prototype.isKeyItemEnabled = function() {
        if (this._warehouses[this._lastActive].rule == null || 
            (this._rules.hasOwnProperty(this._warehouses[this._lastActive].rule) && 
            Array.isArray(this._rules[this._warehouses[this._lastActive].rule].enabledItems.keyItem))) {
            return true;
        }
        return false;
    };
    
    /* (ADD)TMItemCategoryExにより追加されたアイテムが有効かどうかをチェックします */
    PHWarehouseManager.prototype.isItemCategoryEx = function(symbol) {
        if (this._warehouses[this._lastActive].rule == null || 
            (this._rules.hasOwnProperty(this._warehouses[this._lastActive].rule) && 
            Array.isArray(this._rules[this._warehouses[this._lastActive].rule].enabledItems[symbol]))) {
            return true;
        }
        return false;
    };

    //種別アイテム制限数をオーバーしていたらダイアログ表示
    PHWarehouseManager.prototype.checkOverItemQuantity = function(item) {
        if (PHPlugins.Params.PHWarehouseMaxItemQuantity === 0) return true;
        if (item == undefined) return false;
        if (this._warehouses[this._lastActive].qtty[this._lastCategory][item.id] >= PHPlugins.Params.PHWarehouseMaxItemQuantity) {
            SceneManager._scene.createDialogWindow(SceneManager._scene.dialogWindowRect(PHPlugins.Params.PHWarehouseOverQuantityMessage));
            SceneManager._scene._dialogWindow.setDialog(PHPlugins.Params.PHWarehouseOverQuantityTitle, PHPlugins.Params.PHWarehouseOverQuantityMessage);
            SceneManager._scene._dialogCommand.setDialogCommand(['OK']);
            SceneManager._scene._dialogCommand.setHandler('ok', SceneManager._scene.onDialogOverItemQuantityOk.bind(SceneManager._scene));
            SceneManager._scene._dialogCommand.setHandler('cancel', SceneManager._scene.onDialogOverItemQuantityCancel.bind(SceneManager._scene));
            SceneManager._scene.activeDialogWindow();
            return false;
        }
        return true;
    };

    /* アイテムの引出または預入が許可されているかどうかを確認します true:ルールクリア false:ルール違反*/
    /* Verifies if an item is allowed to be withdrawn or deposited */
    PHWarehouseManager.prototype.verifyItem = function(item, rule) {
        if (item == undefined) return false;
        this.changeLastCategory(item);
        if (this._lastCategory === 'all') return false;
        if (!rule) rule = this._warehouses[this._lastActive].rule;

        if (this._warehouses[this._lastActive].rule == null ||
            (this._rules.hasOwnProperty(rule) &&
            Array.isArray(this._rules[rule].enabledItems[this._lastCategory]) &&
            (this._rules[rule].enabledItems[this._lastCategory].indexOf(item.id) > -1) ||
            this._rules[rule].enabledItems[this._lastCategory].length == 0)) {

            /* Makes a second checking to see if this item is disabled */
            if (rule !== null &&
                Array.isArray(this._rules[rule].disabledItems[this._lastCategory]) &&
                this._rules[rule].disabledItems[this._lastCategory].indexOf(item.id) > -1) {

                return false;
            }
            /* 追加したルールのうちいずれか成立したら選択不可 */
            const scriptList = eval(PHPlugins.Params.PHWarehouseAddRuleViolation);
            if (scriptList && scriptList.length > 0) {
                var conclusion = false;
                scriptList.forEach(script => {
                    try {
                        if(!conclusion) conclusion = eval(script);
                    } catch (e) {
                        console.error(e);
                        outputError(e);
                    }
                });
                if(conclusion) return false;
            }
            return true;
        }
        return false;
    };

    /* 最後のカテゴリを変更します */
    /* Changes the last category */
    PHWarehouseManager.prototype.changeLastCategory = function(item) {
        
            if (DataManager.isItem(item) && item.itypeId === 1) {
                this._lastCategory = 'item';
            } else if (DataManager.isArmor(item)) {
                this._lastCategory = 'armor';
            } else if (DataManager.isWeapon(item)) {
                this._lastCategory = 'weapon';
            } else if (DataManager.isItem(item) && item.itypeId === 2) {
                this._lastCategory = 'keyItem';
            }
            if(Imported.TMItemCategoryEx){
                for(var i = 0; i < TMPlugins.Params.TMICexCategoryList.length; i++){
                    var category = TMPlugins.Params.TMICexCategoryList[i];
                    if (DataManager.isItem(item) && item.meta.itemCategory === category) {
                        this._lastCategory = category;
                    }
                }
            }
        // }
    };

    /* 指定したタイトルの倉庫の最大容量を変更します */
    /* Changes the maximum capacity of the warehouse for the given title */
    PHWarehouseManager.prototype.setMaxCapacity = function(_sentence) {
        var matches = this.checkSentence(_sentence);
        if (matches != null) {
            var results = matches.split(":");
            if (results.length == 2) {
                var title = results[0];
                var capacity = parseInt(results[1]);
                if (this._warehouses[title].infinity) {
                    console.warn(title + 'は容量無制限の為、最大容量を変更できません');
                    return;
                }
                if (this._warehouses.hasOwnProperty(title) && !isNaN(capacity) && capacity >= this.getCurrentCapacity(title)) {
                    this._warehouses[title].maxCapacity = capacity;
                    if (this._warehouses[title].maxCapacity < 0) {
                        this._warehouses[title].maxCapacity = 0;
                    }
                }
            }
        }
    };

    /* 指定したタイトルの倉庫の最大容量を増やす */
    /* Increases the maximum capacity of the warehouse for the given title */
    PHWarehouseManager.prototype.increaseMaxCapacity = function(_sentence) {
        var matches = this.checkSentence(_sentence);
        if (matches != null) {
            var results = matches.split(":");
            if (results.length == 2) {
                var title = results[0];
                var capacity = parseInt(results[1]);
                if (this._warehouses[title].infinity) {
                    console.warn(title + 'は容量無制限の為、最大容量を増やすことができません');
                    return;
                }
                if (this._warehouses.hasOwnProperty(title) && !isNaN(capacity) && (this._warehouses[title].maxCapacity + capacity) >= this.getCurrentCapacity(title)) {
                    this._warehouses[title].maxCapacity += capacity;
                    if (this._warehouses[title].maxCapacity < 0) {
                        this._warehouses[title].maxCapacity = 0;
                    }
                }
            }
        }
    };

    /* 指定したタイトルの倉庫の最大容量を減らす */
    /* Decreases the maximum capacity of the warehouse for the given title */
    PHWarehouseManager.prototype.decreaseMaxCapacity = function(_sentence) {
        var matches = this.checkSentence(_sentence);
        if (matches != null) {
            var results = matches.split(":");
            if (results.length == 2) {
                var title = results[0];
                var capacity = parseInt(results[1]);
                if (this._warehouses[title].infinity) {
                    console.warn(title + 'は容量無制限の為、最大容量を減らすことができません');
                    return;
                }
                if (this._warehouses.hasOwnProperty(title) && !isNaN(capacity) && (this._warehouses[title].maxCapacity - capacity) >= this.getCurrentCapacity(title)) {
                    this._warehouses[title].maxCapacity -= capacity;
                    if (this._warehouses[title].maxCapacity < 0) {
                        this._warehouses[title].maxCapacity = 0;
                    }
                }
            }
        }
    };

    /* (ADD)指定したタイトルの倉庫のルールを設定 */
    PHWarehouseManager.prototype.setRule = function(_sentence) {
        var matches = this.checkSentence(_sentence);
        if (matches != null) {
            var results = matches.split(":");
            if (results.length == 2) {
                var title = results[0];
                var rule = results[1];
                if (this._warehouses.hasOwnProperty(title) && typeof rule !== "undefined" && this._rules.hasOwnProperty(rule)) {
                    this._warehouses[title].rule = rule;
                    console.log(rule+'ルールに設定しました');
                }else{
                    console.warn(rule+'ルールは見つからない為設定できませんでした');
                }
            }
        }
    }

    /* ---- MANAGEMENT METHODS ---- */

    /* 現在の倉庫からすべての所持アイテムを取得する（引き出す選択後） */
    /* Get all the items from the current warehouse */
    PHWarehouseManager.prototype.getItems = function() {
        var totalItems = this.getCommonItems();
        totalItems = totalItems.concat(this.getArmors());
        totalItems = totalItems.concat(this.getWeapons());
        totalItems = totalItems.concat(this.getKeyItems());
        //ADD
        if(Imported.TMItemCategoryEx) totalItems =  totalItems.concat(this.getCustomItems());
        return totalItems;
    };

    /* 通常アイテムを取得する */
    /* Get common items */
    PHWarehouseManager.prototype.getCommonItems = function() {
        var totalItems = [];
        for (var i = 0; i < this._warehouses[this._lastActive].items.item.length; i++) {
            for (var j = 0; j < $dataItems.length; j++) {
                if ($dataItems[j] != null && this._warehouses[this._lastActive].items.item[i] == $dataItems[j].id) {
                    totalItems.push($dataItems[j]);
                }
            }
        }
        return totalItems;
    };

    /* 武器アイテムを入手する */
    /* Get weapon items */
    PHWarehouseManager.prototype.getWeapons = function() {
        var totalItems = [];
        for (var i = 0; i < this._warehouses[this._lastActive].items.weapon.length; i++) {
            for (var j = 0; j < $dataWeapons.length; j++) {
                if ($dataWeapons[j] != null && this._warehouses[this._lastActive].items.weapon[i] == $dataWeapons[j].id) {
                    totalItems.push($dataWeapons[j]);
                }
            }
        }
        return totalItems;
    };

    /* 防具アイテムを取得する */
    /* Get armor items */
    PHWarehouseManager.prototype.getArmors = function() {
        var totalItems = [];
        for (var i = 0; i < this._warehouses[this._lastActive].items.armor.length; i++) {
            for (var j = 0; j < $dataArmors.length; j++) {
                if ($dataArmors[j] != null && this._warehouses[this._lastActive].items.armor[i] == $dataArmors[j].id) {
                    totalItems.push($dataArmors[j]);
                }
            }
        }
        return totalItems;
    };

    /* キーアイテムを取得する */
    /* Get key items */
    PHWarehouseManager.prototype.getKeyItems = function() {
        var totalItems = [];
        for (var i = 0; i < this._warehouses[this._lastActive].items.keyItem.length; i++) {
            for (var j = 0; j < $dataItems.length; j++) {
                if ($dataItems[j] != null && this._warehouses[this._lastActive].items.keyItem[i] == $dataItems[j].id) {
                    totalItems.push($dataItems[j]);
                }
            }
        }
        return totalItems;
    };

    /* (ADD)カスタムアイテムを取得する */
    /* Get custom items */
    PHWarehouseManager.prototype.getCustomItems = function() {
        var totalItems = [];
        for(var z = 0; z < TMPlugins.Params.TMICexCategoryList.length; z++){
            var category = TMPlugins.Params.TMICexCategoryList[z];
            var totalItemsTemp = [];
            if(category === 'item' || category === 'keyItem' || category === 'armor' || category === 'weapon') continue;
            for (var i = 0; i < this._warehouses[this._lastActive].items[category].length; i++) {
                for (var j = 0; j < $dataItems.length; j++) {
                    if ($dataItems[j] != null && this._warehouses[this._lastActive].items[category][i] == $dataItems[j].id) {
                        totalItemsTemp.push($dataItems[j]);
                    }
                }
            }
            totalItems = totalItems.concat(totalItemsTemp);
        }
        return totalItems;
    };

    /* 対応するアイテムの数量を取得する */
    /* Get the quantity for the corresponding item */
    PHWarehouseManager.prototype.getQuantity = function(item) {
        this.changeLastCategory(item);
        var qtty = this._warehouses[this._lastActive].qtty[this._lastCategory][item.id];
        if(qtty === undefined) qtty = 0;
        return qtty;
    };

    /* 倉庫がすでに満杯かどうかをチェックします */
    /* Checks whether or not the warehouse is already full */
    PHWarehouseManager.prototype.checkCapacity = function() {
        var capacity = this.getCurrentCapacity(this._lastActive);
        if (capacity < this._warehouses[this._lastActive].maxCapacity || this._warehouses[this._lastActive].infinity) {
            return true;
        }
        return false;
    };

    /* (ADD)アイテムをの重量を加味して倉庫がすでに満杯かどうかをチェックします */
    PHWarehouseManager.prototype.checkCapacity2 = function(item) {
        var weight;
        if(Imported.PNDK_LuggageCapacity){
            weight = $gameSystem.getWeight(item);//装備していない時や全部解除したときに0が返る
        }else{
            weight = 1;
        }
        var capacity = this.getCurrentCapacity(this._lastActive);
        if (capacity + weight <= this._warehouses[this._lastActive].maxCapacity || this._warehouses[this._lastActive].infinity) {
            return true;
        }
        return false;
    };

    /* ---- OPERATION METHODS ---- */

    /* 倉庫に預ける */
    /* Deposit on warehouse */
    PHWarehouseManager.prototype.deposit = function(item) {
        this.changeLastCategory(item);
        if (this._lastCategory != 'all') {
            var hasItem = false;
            if (this._warehouses[this._lastActive].items[this._lastCategory].indexOf(item.id) > -1) {
                hasItem = true;
            }

            if (hasItem) {
                this._warehouses[this._lastActive].qtty[this._lastCategory][item.id]++;
            } else {
                this._warehouses[this._lastActive].items[this._lastCategory].push(item.id);
                this._warehouses[this._lastActive].qtty[this._lastCategory][item.id] = 1;
            }
            
            //this._warehouses[this._lastActive].currentCapacity++;
            //(EDIT)上記を下記に変更しました
            if(Imported.PNDK_LuggageCapacity) {
                this._warehouses[this._lastActive].currentCapacity += $gameSystem.getWeight(item);
            }else{
                this._warehouses[this._lastActive].currentCapacity++;
            }
        }
    };

    /* 倉庫から引き出す */
    /* Withdraw from a warehouse */
    PHWarehouseManager.prototype.withdraw = function(item) {
        this.changeLastCategory(item);
        if (this._lastCategory === 'all') return;
        var hasItem = false;
        var index = this._warehouses[this._lastActive].items[this._lastCategory].indexOf(item.id);
        if (index > -1) {
            hasItem = true;
        }
        if (hasItem) {
            this._warehouses[this._lastActive].qtty[this._lastCategory][item.id]--;
            if (this._warehouses[this._lastActive].qtty[this._lastCategory][item.id] == 0) {
                this._warehouses[this._lastActive].items[this._lastCategory].splice(index, 1);
                delete this._warehouses[this._lastActive].qtty[this._lastCategory][item.id];
            }
            //this._warehouses[this._lastActive].currentCapacity--;
            //(EDIT)上記を下記に修正しました
            if(Imported.PNDK_LuggageCapacity) {
                //改変バージョン
                this._warehouses[this._lastActive].currentCapacity -= $gameSystem.getWeight(item);
            }else{
                //オリジナル
                this._warehouses[this._lastActive].currentCapacity--;
            }
        }
    };

    /* ---- INTERNAL METHODS ---- */

    /* Check sentences coming from the arguments */
    PHWarehouseManager.prototype.checkSentence = function(_sentence) {
        var regExp = /\<([^)]+)\>/;
        var matches = regExp.exec(_sentence);
        if (matches != null) {
            return matches[1];
        } else {
            return null;
        }
    };

    /* 倉庫内のアイテムをチェックする主な方法 */
    /* Main method for checking items inside warehouses */
    PHWarehouseManager.prototype.hasItems = function(title, id, category) {
        if (this._warehouses.hasOwnProperty(title) && this._warehouses[title].items[category].indexOf(id) > -1) {
            return this._warehouses[title].qtty[category][id];
        }
        return 0;
    };



    /* ---- ACCESSOR METHODS ---- */

    /* 指定されたタイトルの倉庫の最大容量の値を返します */
    /* Return the value of the maximum capacity of the warehouse for the given title */
    PHWarehouseManager.prototype.getMaxCapacity = function(title) {
        if (this._warehouses.hasOwnProperty(title)) {
            return this._warehouses[title].maxCapacity;
        }
        return 0;
    };

    /* 指定されたタイトルの倉庫内のアイテム容量の値を返します */
    /* Return the value of the quantity of items in the warehouse for the given title */
    PHWarehouseManager.prototype.getCurrentCapacity = function(title) {
        if (this._warehouses.hasOwnProperty(title)) {
            if (PHPlugins.Params.PHWarehouseStackItemQuantity == true) {
                if(Imported.TMItemCategoryEx){
                    var customItemLength = 0;
                    for(var i=0; i<TMPlugins.Params.TMICexCategoryList.length; i++){
                        const category = TMPlugins.Params.TMICexCategoryList[i];
                        customItemLength += this._warehouses[title].items[category].length;
                    }
                    return customItemLength;
                }else{
                    return (this._warehouses[title].items.item.length + this._warehouses[title].items.weapon.length + 
                        this._warehouses[title].items.keyItem.length + this._warehouses[title].items.armor.length);
                }
            } else {
                return this._warehouses[title].currentCapacity;
            }
        }
        return 0;
    };

    /* 指定されたタイトルの倉庫内の余剰アイテム容量の値を返します */
    PHWarehouseManager.prototype.getSurplusCapacity = function(title) {
        if (this._warehouses.hasOwnProperty(title)) {
            return this._warehouses[title].maxCapacity - this._warehouses[title].currentCapacity;
        }
        // console.warn('倉庫「'+title+'」が存在しないので余剰アイテム容量を取得できません');
        return 0;
    };

    /* 指定されたタイトルの倉庫が存在するかどうかを返します */
    /* Return whether or not the warehouse for the given title exists */
    PHWarehouseManager.prototype.exist = function(title) {
        if (this._warehouses.hasOwnProperty(title) && this._warehouses[title] !== undefined) {
            return true;
        }
        return false;
    };

    /* (ADD)指定された倉庫のルールを取得します */
    PHWarehouseManager.prototype.currentRule = function(title) {
        if(!title){
            console.warn('倉庫の名前が取得できない為倉庫のルールを取得できません');
            return;
        }
        if(!this._warehouses.hasOwnProperty(title)){
            console.warn(title+'が存在しない為倉庫のルールを取得できません。'+title+'は作成されていますか？');
            return '倉庫取得エラー';
        }
        return this._warehouses[title].rule;
    };

    /* 指定された倉庫にアイテムがあるかどうかをチェックします */
    /* Checks if the given warehouse has an item */
    PHWarehouseManager.prototype.hasItem = function(title, id) {
        return this.hasItems(title, id, 'item');
    };

    /* 指定された倉庫に武器があるかどうかをチェックします */
    /* Checks if the given warehouse has a weapon */
    PHWarehouseManager.prototype.hasWeapon = function(title, id) {
        return this.hasItems(title, id, 'weapon');
    };

    /* 指定された倉庫に防具があるかどうかをチェックします */
    /* Checks if the given warehouse has an armor */
    PHWarehouseManager.prototype.hasArmor = function(title, id) {
        return this.hasItems(title, id, 'armor');
    };

    /* 指定された倉庫にキーアイテムがあるかどうかをチェックします */
    /* Checks if the given warehouse has a key item */
    PHWarehouseManager.prototype.hasKeyItem = function(title, id) {
        return this.hasItems(title, id, 'keyItem');
    };

    /* (ADD)アイテムの引出または預入が許可されているかどうかを確認します（外部スクリプト用）*/
    PHWarehouseManager.prototype.isDepositItem = function(title, id, category) {
        if(category === 'item' || category === 'keyItem'){
            //カスタムカテゴリが有効なら変換
            category = this.convertItemIdToCategory(id);
        }
        this._lastCategory = category;
        this._lastActive = title;
        
        return PHPlugins.PHWarehouse.verifyItem($dataItems[id]);
    };

    /* ---------------------------------------------------------- *
     *                      LOADING PROCESS                       *
     * ---------------------------------------------------------- */

    /* データベース全体をロードした後のPHWarehouse変数の作成 */
    /* Creating PHWarehouse variable after loading the whole database */
    var _DataManager_createGameObjects_ = DataManager.createGameObjects;
    DataManager.createGameObjects = function() {
        _DataManager_createGameObjects_.call(this);
        PHPlugins.PHWarehouse = new PHWarehouseManager();
        PHPlugins.PHWarehouse.loadRules();
    };

    /* プレーヤーがゲームを保存するときに倉庫を保存します */
    /* Saves the warehouses when the player saves the game */
    var _DataManager_makeSaveContents_ = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function() {
        var contents = _DataManager_makeSaveContents_.call(this);
        contents.phwarehouse = PHPlugins.PHWarehouse._warehouses;
        return contents;
    };

    /* 保存コンテンツから倉庫を取得する */
    /* Retrieve the warehouses from the save content */
    var _DataManager_extractSaveContents_ = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents_.call(this, contents);
        PHPlugins.PHWarehouse = new PHWarehouseManager();
        if(!contents.phwarehouse) {
            //倉庫が存在しなければエラー
            // throw 'データをロードしましたが倉庫データ（_warehouses）が存在しませんでした\n'+
            // 'このセーブデータはロードできません';
            console.log('データをロードしましたが倉庫データ（_warehouses）が存在しませんでした');
            console.log('新しく作成してロードします');
        }
        PHPlugins.PHWarehouse._warehouses = contents.phwarehouse || {};
        PHPlugins.PHWarehouse.loadRules();
    };

    //ADD
    DataManager.isCustomItem = function(item){
        //(DataManager.isItem元ソース)return item && $dataItems.contains(item)
        var hitFlag = false;
        for(var i = 0; i < TMPlugins.Params.TMICexCategoryList.length; i++){
            var category = TMPlugins.Params.TMICexCategoryList[i];
            if(category === 'item' || category === 'keyItem' || category === 'armor' || category === 'weapon') continue;
            if (item.meta.itemCategory === category) {
                hitFlag = true;
            }
        }
        return item && hitFlag;
    }

    var getAllArguments = function(args, startIndex) {
        var str = args[startIndex].toString();
        for (var i = (startIndex+1); i < args.length; i++) {
            str += ' ' + args[i].toString();
        }
        return str;
    };

    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === 'PHWarehouse') {
            switch (args[0]) {
                case 'create':
                    var _sentence = getAllArguments(args, 1);//<aa:aa:aa>タグ取得
                    var matches = this.checkSentence(_sentence);
                    var results = matches.split(':');
                    if(!results[0]) {
                        console.warn('作成する倉庫の倉庫名が設定されていません');
                        return;
                    }
                    if(PHPlugins.PHWarehouse.exist(results[0])) {
                        console.warn(results[0]+'は既に存在するので作成できません');
                        return;
                    }
                    PHPlugins.PHWarehouse.createWarehouse(getAllArguments(args, 1));
                    
                    break;
                case 'show':
                    var _sentence = getAllArguments(args, 1);//<aa:aa:aa>タグ取得
                    var matches = this.checkSentence(_sentence);
                    var results = matches.split(':');
                    if(!results[0]) {
                        console.warn('表示する倉庫の倉庫名が設定されていません');
                        return;
                    }
                    if(!PHPlugins.PHWarehouse.exist(results[0])){
                        console.log(results[0]+'が存在しないので表示できません');
                        return;
                    }
                    PHPlugins.PHWarehouse.openWarehouse(getAllArguments(args, 1));
                    SceneManager.push(Scene_Warehouse);
                    break;
                case 'remove':
                    var _sentence = getAllArguments(args, 1);//<aa:aa:aa>タグ取得
                    var matches = this.checkSentence(_sentence);
                    var results = matches.split(':');
                    if(!results[0]) {
                        console.warn('削除する倉庫の倉庫名が設定されていません');
                        return;
                    }
                    if(!PHPlugins.PHWarehouse.exist(results[0])) {
                        console.warn(results[0]+'が存在しないので倉庫削除できません');
                        return;
                    }
                    PHPlugins.PHWarehouse.removeWarehouse(getAllArguments(args, 1));
                    break;
                case 'add':
                    var _sentence = getAllArguments(args, 2);//<aa:aa:aa>タグ取得
                    var matches = this.checkSentence(_sentence);
                    var results = matches.split(':');
                    if(!results[0]) {
                        console.warn('アイテム追加する倉庫の倉庫名が設定されていません');
                        return;
                    }
                    if(!PHPlugins.PHWarehouse.exist(results[0])) {
                        console.warn(results[0]+'が存在しないので倉庫に追加できません');
                        return;
                    }
                    switch (args[1]) {
                        case 'item':
                            PHPlugins.PHWarehouse.addItems(getAllArguments(args, 2), 'item');
                            break;
                        case 'weapon':
                            PHPlugins.PHWarehouse.addItems(getAllArguments(args, 2), 'weapon');
                            break;
                        case 'armor':
                            PHPlugins.PHWarehouse.addItems(getAllArguments(args, 2), 'armor');
                            break;
                        case 'keyItem':
                            PHPlugins.PHWarehouse.addItems(getAllArguments(args, 2), 'keyItem');
                            break;
                    }
                    break;
                case 'capacity':
                    var _sentence = getAllArguments(args, 2);//<aa:aa:aa>タグ取得
                    var matches = this.checkSentence(_sentence);
                    var results = matches.split(':');
                    if(!results[0]) {
                        console.warn('アイテム追加する倉庫の倉庫名が設定されていません');
                        return;
                    }
                    if(!PHPlugins.PHWarehouse.exist(results[0])) {
                        console.warn(results[0]+'が存在しないので倉庫に追加できません');
                        return;
                    }
                    switch (args[1]) {
                        case 'increase':
                            PHPlugins.PHWarehouse.increaseMaxCapacity(getAllArguments(args, 2));
                            break;
                        case 'decrease':
                            PHPlugins.PHWarehouse.decreaseMaxCapacity(getAllArguments(args, 2));
                            break;
                        case 'set':
                            PHPlugins.PHWarehouse.setMaxCapacity(getAllArguments(args, 2));
                            break;
                    }
                    break;
                case 'bg':
                    switch (args[1]) {
                        case 'set':
                            var _sentence = getAllArguments(args, 2);//<aa:aa:aa>タグ取得
                            var matches = this.checkSentence(_sentence);
                            var results = matches.split(':');
                            if(!results[0]) {
                                console.warn('画像ファイルが設定されていません');
                                return;
                            }
                            PHPlugins.PHWarehouse.bgSet(getAllArguments(args, 2));
                            break;
                        case 'reset':
                            PHPlugins.PHWarehouse.bgReset();
                            break;
                    }
                    break;
                case 'setRule':
                    var _sentence = getAllArguments(args, 1);//<aa:aa:aa>タグ取得
                    var matches = this.checkSentence(_sentence);
                    var results = matches.split(':');
                    if(!results[0]) {
                        console.warn('ルール設定する倉庫の倉庫名が設定されていません');
                        return;
                    }
                    if(!PHPlugins.PHWarehouse.exist(results[0])) {
                        console.warn(results[0]+'が存在しないので倉庫のルールを設定できません');
                        return;
                    }
                    PHPlugins.PHWarehouse.setRule(getAllArguments(args, 1));
                    break;
                case 'deposit':
                    var _sentence = getAllArguments(args, 2);//<aa:aa:aa>タグ取得
                    var matches = this.checkSentence(_sentence);
                    var results = matches.split(':');
                    if(!results[0]) {
                        console.warn('アイテム追加する倉庫の倉庫名が設定されていません');
                        return;
                    }
                    if(!PHPlugins.PHWarehouse.exist(results[0])) {
                        console.warn(results[0]+'が存在しないので倉庫に追加できません');
                        return;
                    }
                    if(Imported.TMItemCategoryEx){
                        for(var i = 0; i < TMPlugins.Params.TMICexCategoryList.length; i++){
                            var category = TMPlugins.Params.TMICexCategoryList[i];
                            if(category === args[1] || 'all' === args[1]){
                                PHPlugins.PHWarehouse.depositByCategory(getAllArguments(args, 2), category);
                            }
                        }
                    }else{
                        switch (args[1]) {
                            case 'item':
                                PHPlugins.PHWarehouse.depositByCategory(getAllArguments(args, 2), 'item');
                                break;
                            case 'weapon':
                                PHPlugins.PHWarehouse.depositByCategory(getAllArguments(args, 2), 'weapon');
                                break;
                            case 'armor':
                                PHPlugins.PHWarehouse.depositByCategory(getAllArguments(args, 2), 'armor');
                                break;
                            case 'keyItem':
                                PHPlugins.PHWarehouse.depositByCategory(getAllArguments(args, 2), 'keyItem');
                                break;
                            case 'all':
                                PHPlugins.PHWarehouse.depositByCategory(getAllArguments(args, 2), 'item');
                                PHPlugins.PHWarehouse.depositByCategory(getAllArguments(args, 2), 'weapon');
                                PHPlugins.PHWarehouse.depositByCategory(getAllArguments(args, 2), 'armor');
                                PHPlugins.PHWarehouse.depositByCategory(getAllArguments(args, 2), 'keyItem');
                                break;
                        }
                    }
                    break;
            }
        }
    };

    Game_Interpreter.prototype.checkSentence = function(_sentence) {
        var regExp = /\<([^)]+)\>/;
        var matches = regExp.exec(_sentence);
        if (matches != null) {
            return matches[1];
        } else {
            return null;
        }
    };

    //MZプラグインコマンド
    if(Utils.RPGMAKER_NAME==="MZ"){
        PluginManager.registerCommand(PHPlugins.PluginName, 'create', args => {
            if(!args.create_title) console.warn('作成する倉庫の倉庫名が設定されていません');
            if(PHPlugins.PHWarehouse.exist(args.create_title)) console.warn(args.create_title+'は既に存在するので作成できません');
            var command = '<' + args.create_title;
            if(args.create_capacity) command += ':' + args.create_capacity;
            if(args.create_rule) command += ':' + args.create_rule;
            command += '>';
            PHPlugins.PHWarehouse.createWarehouse(command);
        });
        PluginManager.registerCommand(PHPlugins.PluginName, 'show', args => {
            if(!args.show_title) console.warn('表示する倉庫の倉庫名が設定されていません');
            if(!PHPlugins.PHWarehouse.exist(args.show_title)) console.warn(args.show_title+'が存在しないので表示できません');
            const command = '<' + args.show_title + '>';
            PHPlugins.PHWarehouse.openWarehouse(command);
            if(PHPlugins.PHWarehouse.exist(args.show_title)) SceneManager.push(Scene_Warehouse);
        });
        PluginManager.registerCommand(PHPlugins.PluginName, 'remove', args => {
            if(!args.remove_title) console.warn('削除する倉庫の倉庫名が設定されていません');
            if(!PHPlugins.PHWarehouse.exist(args.remove_title)) console.warn(args.remove_title+'が存在しないので削除できません');
            const command = '<' + args.remove_title + '>';
            PHPlugins.PHWarehouse.removeWarehouse(command);
        });
        //倉庫にアイテム追加
        PluginManager.registerCommand(PHPlugins.PluginName, 'addItem', args => {
            if(!args.addItem_title) console.warn('アイテム追加する倉庫の倉庫名が設定されていません');
            if(!PHPlugins.PHWarehouse.exist(args.addItem_title)) console.warn(args.addItem_title+'が存在しないのでアイテム追加できません');
            const command = '<' + args.addItem_title + ':' + args.addItem_itemId + 
                ':' + args.addItem_quantity + '>';
            PHPlugins.PHWarehouse.addItems(command, 'item');
        });
        PluginManager.registerCommand(PHPlugins.PluginName, 'addWeapon', args => {
            if(!args.addWeapon_title) console.warn('武器を追加する倉庫の倉庫名が設定されていません');
            if(!PHPlugins.PHWarehouse.exist(args.addWeapon_title)) console.warn(args.addWeapon_title+'が存在しないので武器追加できません');
            const command = '<' + args.addWeapon_title + ':' + args.addWeapon_itemId + 
                ':' + args.addWeapon_quantity + '>';
            PHPlugins.PHWarehouse.addItems(command, 'weapon');
        });
        PluginManager.registerCommand(PHPlugins.PluginName, 'addArmor', args => {
            if(!args.addArmor_title) console.warn('防具を追加する倉庫の倉庫名が設定されていません');
            if(!PHPlugins.PHWarehouse.exist(args.addArmor_title)) console.warn(args.addArmor_title+'が存在しないので防具追加できません');
            const command = '<' + args.addArmor_title + ':' + args.addArmor_itemId + 
                ':' + args.addArmor_quantity + '>';
            PHPlugins.PHWarehouse.addItems(command, 'armor');
        });
        //既存の倉庫の最大容量を設定
        PluginManager.registerCommand(PHPlugins.PluginName, 'capacitySet', args => {
            if(!args.capacitySet_title) console.warn('最大容量を変更する倉庫の倉庫名が設定されていません');
            if(!PHPlugins.PHWarehouse.exist(args.capacitySet_title)) console.warn(args.capacitySet_title+'が存在しないので最大容量変更できません');
            const command = '<' + args.capacitySet_title + ':' + args.capacitySet_quantity + '>';
            PHPlugins.PHWarehouse.setMaxCapacity(command);
        });
        PluginManager.registerCommand(PHPlugins.PluginName, 'capacityInc', args => {
            if(!args.capacityInc_title) console.warn('最大容量を変更する倉庫の倉庫名が設定されていません');
            if(!PHPlugins.PHWarehouse.exist(args.capacityInc_title)) console.warn(args.capacityInc_title+'が存在しないので最大容量変更できません');
            const command = '<' + args.capacityInc_title + ':' + args.capacityInc_quantity + '>';
            PHPlugins.PHWarehouse.increaseMaxCapacity(command);
        });
        PluginManager.registerCommand(PHPlugins.PluginName, 'capacityDec', args => {
            if(!args.capacityDec_title) console.warn('最大容量を減らす倉庫の倉庫名が設定されていません');
            if(!PHPlugins.PHWarehouse.exist(args.capacityDec_title)) console.warn(args.capacityDec_title+'が存在しないので最大容量減らせません');
            const command = '<' + args.capacityDec_title + ':' + args.capacityDec_quantity + '>';
            PHPlugins.PHWarehouse.decreaseMaxCapacity(command);
        });
        //背景画像を設定
        PluginManager.registerCommand(PHPlugins.PluginName, 'bgSet', args => {
            const command = '<' + args.bgSet_file + '>';
            PHPlugins.PHWarehouse.bgSet(command);
        });
        PluginManager.registerCommand(PHPlugins.PluginName, 'bgReset', args => {
            PHPlugins.PHWarehouse.bgReset();
        });
        //倉庫のルールを設定
        PluginManager.registerCommand(PHPlugins.PluginName, 'setRule', args => {
            if(!args.setRule_title) console.warn('ルール設定を変更する倉庫の倉庫名が設定されていません');
            if(!PHPlugins.PHWarehouse.exist(args.setRule_title)) console.warn(args.setRule_title+'が存在しないのでルール設定できません');
            var command = '<' + args.setRule_title + ':' + args.setRule_rule + '>';
            PHPlugins.PHWarehouse.setRule(command);
        });
        //強制的に預ける
        PluginManager.registerCommand(PHPlugins.PluginName, 'collectiveDeposit', args => {
            if(!args.collectiveDeposit_title) {console.warn('まとめて預ける対象の倉庫の倉庫名が設定されていません'); return;}
            const command = '<' + args.collectiveDeposit_title + ':' + args.collectiveDeposit_rule + '>';
            if(Imported.TMItemCategoryEx){
                for(var i = 0; i < TMPlugins.Params.TMICexCategoryList.length; i++){
                    var category = TMPlugins.Params.TMICexCategoryList[i];
                    if(category === args.collectiveDeposit_category || 'all' === args.collectiveDeposit_category){
                        PHPlugins.PHWarehouse.depositByCategory(command, category);
                    }
                }
            }else{
                switch (args.collectiveDeposit_category) {
                    case 'item':
                        PHPlugins.PHWarehouse.depositByCategory(command, 'item');
                        break;
                    case 'weapon':
                        PHPlugins.PHWarehouse.depositByCategory(command, 'weapon');
                        break;
                    case 'armor':
                        PHPlugins.PHWarehouse.depositByCategory(command, 'armor');
                        break;
                    case 'keyItem':
                        PHPlugins.PHWarehouse.depositByCategory(command, 'keyItem');
                        break;
                    case 'all':
                        PHPlugins.PHWarehouse.depositByCategory(command, 'item');
                        PHPlugins.PHWarehouse.depositByCategory(command, 'weapon');
                        PHPlugins.PHWarehouse.depositByCategory(command, 'armor');
                        PHPlugins.PHWarehouse.depositByCategory(command, 'keyItem');
                        break;
                }
            }
        });
        
    }

    /* ---------------------------------------------------------- *
     *                       WINDOW PROCESS                       *
     * ---------------------------------------------------------- */
    //ADD
    function leftWindow_width(layout){
        if(Imported.PNDK_LuggageCapacity) {
            if(PHPlugins.Params.PHWarehouseCPLayoutTopForMZ && Utils.RPGMAKER_NAME==="MZ") {
                return Graphics.boxWidth;
            }
            if(PHPlugins.Params.PHWarehouseCpLayout === layout) {
                return Graphics.boxWidth - PHPlugins.Params.PHWarehouseCpWidth;
            }else{
                return Graphics.boxWidth;
            }
        }else{
            return Graphics.boxWidth;
        }
    }

    function Window_WarehouseTitle() {
        this.initialize.apply(this, arguments);
    }
    Window_WarehouseTitle.prototype = Object.create(Window_Base.prototype);
    Window_WarehouseTitle.prototype.constructor = Window_WarehouseTitle;

    Window_WarehouseTitle.prototype.initialize = function(rect) {
        if(Utils.RPGMAKER_NAME==="MZ"){
            Window_Base.prototype.initialize.call(this, rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            Window_Base.prototype.initialize.call(this, 0, 0, Graphics.boxWidth, this.fittingHeight(1));
        }
        this.refresh();
    };

    Window_WarehouseTitle.prototype.refresh = function() {
        this.contents.clear();
        if(Utils.RPGMAKER_NAME==="MZ"){
            this.changeTextColor(ColorManager.textColor(17));
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            this.changeTextColor(this.crisisColor());
        }
        if(!PHPlugins.Params.PHWarehouseTitleTextHide){
            this.drawText(PHPlugins.PHWarehouse._lastActive, 0, 0, Graphics.boxWidth, "center");
        }
    };



    function Window_WarehouseOption() {
        this.initialize.apply(this, arguments);
    }
    Window_WarehouseOption.prototype = Object.create(Window_Selectable.prototype);
    Window_WarehouseOption.prototype.constructor = Window_WarehouseOption;

    Window_WarehouseOption.prototype.initialize = function(rect) {
        if(Utils.RPGMAKER_NAME==="MZ"){
            Window_Selectable.prototype.initialize.call(this, rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            Window_Selectable.prototype.initialize.call(this, 0, this.fittingHeight(1), leftWindow_width(1), this.fittingHeight(1));
        }
        this.withdrawText = PHPlugins.Params.PHWarehouseWithdrawText;
        this.depositText = PHPlugins.Params.PHWarehouseDepositText;
        PHPlugins.PHWarehouse._lastOption = null;//（ADD）初期状態でDepositもWithdrawも選択されてない（リストが空の）状態
        this.refresh();

        this.select(0);
        this.activate();

        // this.deselect();
        // this.deactivate();
    };

    Window_WarehouseOption.prototype.maxItems = function() {
        return 2;
    };

    Window_WarehouseOption.prototype.maxCols = function() {
        return 2;
    };

    Window_WarehouseOption.prototype.changeOption = function() {
        PHPlugins.PHWarehouse._lastOption = this._index;
    };

//    Window_WarehouseOption.prototype.refresh = function() {
//        var rectWithdraw = this.itemRectForText(0);
//        var rectDeposit = this.itemRectForText(1);
//        this.drawText(this.withdrawText, rectWithdraw.x, rectWithdraw.y, rectWithdraw.width, "center");
//        this.drawText(this.depositText, rectDeposit.x, rectDeposit.y, rectDeposit.width, "center");
//    };
    //(ADD)上記メソッドを以下に変更
    Window_WarehouseOption.prototype.refresh = function() {
        var rectDeposit, rectWithdraw;
        if(Utils.RPGMAKER_NAME==="MZ"){
            rectDeposit = this.itemLineRect(0);
            rectWithdraw = this.itemLineRect(1);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            rectDeposit = this.itemRectForText(0);
            rectWithdraw = this.itemRectForText(1);
        }
        this.drawText(this.depositText, rectDeposit.x, rectDeposit.y, rectDeposit.width, "center");
        this.drawText(this.withdrawText, rectWithdraw.x, rectWithdraw.y, rectWithdraw.width, "center");
    };

    function Window_WarehouseCategory() {
        this.initialize.apply(this, arguments);
    }
    Window_WarehouseCategory.prototype = Object.create(Window_ItemCategory.prototype);
    Window_WarehouseCategory.prototype.constructor = Window_WarehouseCategory;

    Window_WarehouseCategory.prototype.initialize = function(rect) {
        if(Utils.RPGMAKER_NAME==="MZ"){
            Window_ItemCategory.prototype.initialize.call(this, rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            Window_ItemCategory.prototype.initialize.call(this);
            this.y = this.fittingHeight(3);
        }
        this.deselect();
        this.deactivate();
    };

    // Window_WarehouseCategory.prototype.changeCategory = function() {
    //     PHPlugins.PHWarehouse._lastCategory = this.currentSymbol() || "item";
    // };

    Window_WarehouseCategory.prototype.maxCols = function() {
        if (PHPlugins.Params.PHWarehouseAllTogether == true) return 1;
        var cols = 0;
        if(Imported.TMItemCategoryEx){
            var symbol;
            for (var i = 0; i < TMPlugins.Params.TMICexCategoryList.length; i++) {
                symbol = TMPlugins.Params.TMICexCategoryList[i];
                if (symbol === 'item') {
                    if (PHPlugins.PHWarehouse.isItemEnabled()) {
                        cols++;
                    }
                } else if (symbol === 'weapon') {
                    if (PHPlugins.PHWarehouse.isWeaponEnabled()) {
                        cols++;
                    }
                } else if (symbol === 'armor') {
                    if (PHPlugins.PHWarehouse.isArmorEnabled()) {
                        cols++;
                    }
                } else if (symbol === 'keyItem') {
                    if (PHPlugins.PHWarehouse.isKeyItemEnabled()) {
                        cols++;
                    }
                } else {
                    //ItemCategoryEXで追加したカテゴリがあれば列追加
                    if (PHPlugins.PHWarehouse.isItemCategoryEx(symbol)) {
                        cols++;
                    }
                }
            }
        }else{
            if (PHPlugins.PHWarehouse.isItemEnabled()) {
                cols++;
            }
            if (PHPlugins.PHWarehouse.isWeaponEnabled()) {
                cols++;
            }
            if (PHPlugins.PHWarehouse.isArmorEnabled()) {
                cols++;
            }
            if (PHPlugins.PHWarehouse.isKeyItemEnabled()) {
                cols++;
            }
        }
        return cols;
    };
    
    Window_WarehouseCategory.prototype.makeCommandList = function() {
        if (PHPlugins.Params.PHWarehouseAllTogether == true) {
            this.addCommand(PHPlugins.Params.PHWarehouseAllText, 'all');
        } else {
            if(Imported.TMItemCategoryEx){
                var symbol;
                for (var i = 0; i < TMPlugins.Params.TMICexCategoryList.length; i++) {
                    symbol = TMPlugins.Params.TMICexCategoryList[i];
                    if (symbol === 'item') {
                        if (PHPlugins.PHWarehouse.isItemEnabled()) {
                            this.addCommand(TextManager.item, 'item');
                        }
                    } else if (symbol === 'weapon') {
                        if (PHPlugins.PHWarehouse.isWeaponEnabled()) {
                            this.addCommand(TextManager.weapon, 'weapon');
                        }
                    } else if (symbol === 'armor') {
                        if (PHPlugins.PHWarehouse.isArmorEnabled()) {
                            this.addCommand(TextManager.armor, 'armor');
                        }
                    } else if (symbol === 'keyItem') {
                        if (PHPlugins.PHWarehouse.isKeyItemEnabled()) {
                            this.addCommand(TextManager.keyItem, 'keyItem');
                        }
                    } else {
                        //ItemCategoryEXで追加したカテゴリがあればコマンド追加
                        if (PHPlugins.PHWarehouse.isItemCategoryEx(symbol)) {
                            this.addCommand(symbol, symbol);
                        }
                    }
                }
            }else{
                if (PHPlugins.PHWarehouse.isItemEnabled()) {
                    this.addCommand(TextManager.item, 'item');
                }
                if (PHPlugins.PHWarehouse.isWeaponEnabled()) {
                    this.addCommand(TextManager.weapon, 'weapon');
                }
                if (PHPlugins.PHWarehouse.isArmorEnabled()) {
                    this.addCommand(TextManager.armor, 'armor');
                }
                if (PHPlugins.PHWarehouse.isKeyItemEnabled()) {
                    this.addCommand(TextManager.keyItem, 'keyItem');
                }
            }
        }
    };

    //ADD
    Window_WarehouseCategory.prototype.windowWidth = function() {
        return leftWindow_width(2);
    };

    function Window_WarehouseItemList() {
        this.initialize.apply(this, arguments);
    }
    Window_WarehouseItemList.prototype = Object.create(Window_ItemList.prototype);
    Window_WarehouseItemList.prototype.constructor = Window_WarehouseItemList;

    Window_WarehouseItemList.prototype.initialize = function(rect) {
        if(Utils.RPGMAKER_NAME==="MZ"){
            Window_ItemList.prototype.initialize.call(this, rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            const wx = 0;
            var ww;
            var wy, wh;
            if(PHPlugins.Params.PHWarehouseShowPicture){
                ww = 540;
            }else{
                ww = Graphics.boxWidth;
            }
            if(PHPlugins.Params.PHWarehouseItemListEx){
                wy = this.fittingHeight(3);
                wh = Graphics.boxHeight - this.fittingHeight(5);
            }else{
                wy = this.fittingHeight(5);
                wh = Graphics.boxHeight - this.fittingHeight(7);
            }
            Window_ItemList.prototype.initialize.call(this, wx, wy, ww, wh);
        }
    };

    //引き出し時
    Window_WarehouseItemList.prototype.makeWarehouseItemList = function() {
        var data = PHPlugins.PHWarehouse.getItems();
        this._data = data.filter(function(item) {
            if (PHPlugins.Params.PHWarehouseAllTogether == true) {
                return this.includesWarehouseAll(item);
            } else {
                return this.includes(item);
            }
        }, this);
        
        if (this.includes(null)) {
            this._data.push(null);
        }
    };
    //引き出し時
    Window_WarehouseItemList.prototype.includesWarehouseAll = function(item) {
        if(Imported.TMItemCategoryEx){
            return ( (DataManager.isItem(item) && item.itypeId === 1) || 
            (DataManager.isWeapon(item)) || (DataManager.isArmor(item)) || 
            (DataManager.isItem(item) && item.itypeId === 2) ||
            (DataManager.isItem(item) && DataManager.isCustomItem(item) ));

        }else{
            return ( (DataManager.isItem(item) && item.itypeId === 1) || 
            (DataManager.isWeapon(item)) || (DataManager.isArmor(item)) || 
            (DataManager.isItem(item) && item.itypeId === 2) );
        }
        
    };

    Window_WarehouseItemList.prototype.makeDepositAllItemList = function() {
        // this._data = $gameParty.allItems()
        // 上記を下記に書き換え
        // 隠しアイテムを除いたアイテムのみアイテムリストに表示
        this._data = $gameParty.allItems().filter(function (item){
            return (DataManager.isItem(item) && item.itypeId <= 2 || DataManager.isWeapon(item) || DataManager.isArmor(item));
        });
    };

    //(ADD)以下メソッドを一部変更
    // Window_WarehouseItemList.prototype.loadItems = function() {
    //     // Deposit(預ける)
    //     if (PHPlugins.PHWarehouse._lastOption == 0) {//(EDIT)DepositとWithdrawを入れ替えるべく1を0にしました
    //         if (PHPlugins.Params.PHWarehouseAllTogether == true) {
    //             this.makeDepositAllItemList();
    //         } else {
    //             this.makeItemList();
    //         }
    //     }
    //     // Withdraw(引き出す)
    //     else if (PHPlugins.PHWarehouse._lastOption == 1) {//(EDIT)DepositとWithdrawを入れ替えるべく0を1にしました
    //         this.makeWarehouseItemList();
    //     }
    // };

    //(ADD)以下メソッドを一部変更
    Window_WarehouseItemList.prototype.drawItem = function(index) {
        var item = this._data[index];
        if (item) {
            this.changePaintOpacity(PHPlugins.PHWarehouse.verifyItem(item));
            var rect = this.itemRect(index);
            if(Utils.RPGMAKER_NAME==="MZ") rect.width -= this.itemPadding();
            if(Utils.RPGMAKER_NAME==="MV") rect.width -= this.textPadding();
            this.drawItemSub(item, rect, index);
        }
    };

    Window_WarehouseItemList.prototype.iconBoxWidth = function() {
        if(Utils.RPGMAKER_NAME==="MZ") return ImageManager.iconWidth + 4;
        if(Utils.RPGMAKER_NAME==="MV") return Window_Base._iconWidth + 4;
    }

    Window_WarehouseItemList.prototype.drawItemSub = function(item, r, index) {
        const scriptList = eval(PHPlugins.Params.PHWarehouseItemListDrawScript);
        if (scriptList && scriptList.length > 0) {
            scriptList.forEach(script => {
                try {
                    eval(script)
                } catch (e) {
                    console.error(e);
                    outputError(e);
                }
            });
        } else if (item === String(item)) {
            this.drawTextEx(item, r.x, r.y);
        } else if (item.hasOwnProperty('iconIndex')) {
            this.drawItemName(item, r.x, r.y, r.width);
        } else if (item.hasOwnProperty('name')) {
            this.drawTextEx(item.name, r.x, r.y);
        } else {
            this.drawTextEx(item.toString(), r.x, r.y);
            console.warn(item);
        }
    }

    // YEP_CoreEngineが有効のときこれを入れないと幅が圧縮されてしまう
    Window_WarehouseItemList.prototype.numberWidth = function() {
        return this.textWidth('000');
    };

    var _Window_ItemList_drawItemNumber = Window_ItemList.prototype.drawItemNumber;
    Window_WarehouseItemList.prototype.drawItemNumber = function(item, x, y, width, digit) {
        if (typeof Yanfly !== "undefined" && Imported.YEP_CoreEngine){
            _Window_ItemList_drawItemNumber.call(this, item, x, y, width, digit);
        }else{
            if (this.needsNumber()) {
                if(digit === undefined){
                    this.drawText(':', x, y, width - this.textWidth('00'), 'right');
                }else{
                    this.drawWarehouseItemColon(x, y, width, digit);
                }
                this.drawText($gameParty.numItems(item), x, y, width, 'right');
            }
        }
    };

    Window_WarehouseItemList.prototype.drawWarehouseItemColon = function(x, y, width, digit) {
        const numberWidth = this.textWidth('0') * digit;
        const colonWidth = this.textWidth(':');
        const colonX = x + (width - (numberWidth + colonWidth));
        this.drawText(':', colonX, y, colonWidth, 'right');
    };

    Window_WarehouseItemList.prototype.drawWarehouseItemNumber = function(item, x, y, width, digit) {
        if(digit === undefined){
            var qtty = PHPlugins.PHWarehouse.getQuantity(item);
            if (PHPlugins.PHWarehouse._lastOption == 0) {//(EDIT)DepositとWithdrawを入れ替えるべく1を0にしました
                //預けるアイテムのアイテム数付与
                if(PHPlugins.Params.PHWarehouseMaxItemQuantity && qtty >= PHPlugins.Params.PHWarehouseMaxItemQuantity) {
                    this.changeTextColor(PHPlugins.Params.PHWarehouseMaxItemColor);
                }
                this.drawItemNumber(item, x, y, width);
            } else if (PHPlugins.PHWarehouse._lastOption == 1) {//(EDIT)DepositとWithdrawを入れ替えるべく0を1にしました
                //引き出すアイテムのアイテム数付与
                if (typeof Yanfly !== "undefined" && Imported.YEP_CoreEngine) {
                    this.contents.fontSize = Yanfly.Param.ItemQuantitySize;
                    this.drawText('\u00d7' + qtty, x, y, width, 'right');
                    this.resetFontSettings();
                } else {
                    this.drawText(':', x, y, width - this.textWidth('00'), 'right');
                    this.drawText(qtty, x, y, width, 'right');
                }
            }
         }else{
            const numberWidth = this.textWidth('0') * digit;
            const numberX = x + (width - numberWidth);
            //預けてあるアイテムのアイテム数付与
            var qtty = PHPlugins.PHWarehouse.getQuantity(item);
            if (PHPlugins.PHWarehouse._lastOption == 0) {//(EDIT)DepositとWithdrawを入れ替えるべく1を0にしました
                //預けるアイテムのアイテム数付与
                if(PHPlugins.Params.PHWarehouseMaxItemQuantity && qtty >= PHPlugins.Params.PHWarehouseMaxItemQuantity) {
                    this.changeTextColor(PHPlugins.Params.PHWarehouseMaxItemColor);
                }
                this.drawItemNumber(item, numberX, y, numberWidth, digit);
            } else if (PHPlugins.PHWarehouse._lastOption == 1) {//(EDIT)DepositとWithdrawを入れ替えるべく0を1にしました
                //引き出すアイテムのアイテム数付与
                if (typeof Yanfly !== "undefined" && Imported.YEP_CoreEngine) {
                    this.contents.fontSize = Yanfly.Param.ItemQuantitySize;
                    this.drawText('\u00d7' + qtty, numberX, y, numberWidth, 'right');
                    this.resetFontSettings();
                } else {
                    this.drawWarehouseItemColon(x, y, width, digit);
                    this.drawText(qtty, numberX, y, numberWidth, 'right');
                }
            }
         }
         this.resetTextColor();
    };

    

    // Window_WarehouseItemList.prototype.refresh = function() {
    //     this.contents.clear();
    //     this.loadItems();
    //     this.drawAllItems();
    // };

    //ADD
    const _Window_ItemList_makeItemList = Window_ItemList.prototype.makeItemList;
    Window_WarehouseItemList.prototype.makeItemList = function() {
        // Deposit(預ける)
        if (PHPlugins.PHWarehouse._lastOption == 0) {//(EDIT)DepositとWithdrawを入れ替えるべく1を0にしました
            if (PHPlugins.Params.PHWarehouseAllTogether == true) {
                this.makeDepositAllItemList();
                if(Imported['ItemSort']) this.itemSort();
            } else {
                _Window_ItemList_makeItemList.call(this);
            }
        }
        // Withdraw(引き出す)
        else if (PHPlugins.PHWarehouse._lastOption == 1) {//(EDIT)DepositとWithdrawを入れ替えるべく0を1にしました
            this.makeWarehouseItemList();
            if(Imported['ItemSort'])this.itemSort();
        }
    };

    //(ADD)以下メソッドを一部変更
    // アイテムを選択
    Window_WarehouseItemList.prototype.moveItem = function() {
        var item = this.item();
        // Deposit(預ける)
        if (PHPlugins.PHWarehouse._lastOption == 0) {//(EDIT)DepositとWithdrawを入れ替えるべく1を0にしました
            if (PHPlugins.PHWarehouse.checkCapacity2(item) && PHPlugins.PHWarehouse.verifyItem(item) 
                && PHPlugins.PHWarehouse.checkOverItemQuantity(item)) {//(EDIT)checkCapacityをcheckCapacity2にしました

                if(PHPlugins.Params.PHWarehouseDepositSoundFile){
                    AudioManager.playStaticSe({"name":PHPlugins.Params.PHWarehouseDepositSoundFile,"volume":90,"pitch":100,"pan":0});
                }else{
                    SoundManager.playEquip();
                }
                PHPlugins.PHWarehouse.deposit(item);
                $gameParty.loseItem(item, 1);
            } else {
                if(PHPlugins.Params.PHWarehouseBuzzerSoundFile){
                    AudioManager.playStaticSe({"name":PHPlugins.Params.PHWarehouseBuzzerSoundFile,"volume":90,"pitch":100,"pan":0});
                }else{
                    SoundManager.playBuzzer();
                }
            }
        }

        // Withdraw(引き出す)
        else if (PHPlugins.PHWarehouse._lastOption == 1) {//(EDIT)DepositとWithdrawを入れ替えるべく0を1にしました
            if ((PHPlugins.PHWarehouse.verifyItem(item) && !Imported.PNDK_LuggageCapacity) || 
                (PHPlugins.PHWarehouse.verifyItem(item) && Imported.PNDK_LuggageCapacity && $gameSystem.getSurplusCP() >= $gameSystem.getWeight(item,1))) {
                var numItems = $gameParty.numItems(item);
                $gameParty.gainItem(item, 1);
                if (numItems < $gameParty.numItems(item)) {
                    if(PHPlugins.Params.PHWarehouseWithdrawSoundFile){
                        AudioManager.playStaticSe({"name":PHPlugins.Params.PHWarehouseWithdrawSoundFile,"volume":90,"pitch":100,"pan":0});
                    }else{
                        SoundManager.playEquip();
                    }
                    PHPlugins.PHWarehouse.withdraw(item);
                } else {
                    SoundManager.playBuzzer();
                }
            } else {
                if(PHPlugins.Params.PHWarehouseBuzzerSoundFile){
                    AudioManager.playStaticSe({"name":PHPlugins.Params.PHWarehouseBuzzerSoundFile,"volume":90,"pitch":100,"pan":0});
                }else{
                    SoundManager.playBuzzer();
                }
            }
        }
    };

    Window_WarehouseItemList.prototype.select = function(index) {
        Window_Selectable.prototype.select.call(this, index);
        if(SceneManager._scene._infoItemWindow){
            SceneManager._scene._infoItemWindow.setInfo(this.item());
            SceneManager._scene._infoItemWindow.refresh();
        }
    }

    Window_WarehouseItemList.prototype.playOkSound = function() { };

    //(ADD)アイテム情報ウィンドウ(ピクチャ画像表示用)
    function Window_WarehouseInfoItem() {
        this.initialize.apply(this, arguments);
    }

    Window_WarehouseInfoItem.prototype = Object.create(Window_Base.prototype);
    Window_WarehouseInfoItem.prototype.constructor = Window_WarehouseInfoItem;
    
    Window_WarehouseInfoItem.prototype.initialize = function(rect) {
        if(Utils.RPGMAKER_NAME==="MZ"){
            Window_Base.prototype.initialize.call(this, rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            const wx = 540;
            const ww = Graphics.boxWidth - 540;
            var wy, wh;
            if(PHPlugins.Params.PHWarehouseItemListEx){
                wy = this.fittingHeight(3);
                wh = Graphics.boxHeight - this.fittingHeight(5);
            }else{
                wy = this.fittingHeight(5);
                wh = Graphics.boxHeight - this.fittingHeight(7);
            }
            Window_Base.prototype.initialize.call(this, wx, wy, ww, wh);
        }
        this._name = '';
        this._image = null;
        this._item = null;
    };

    Window_WarehouseInfoItem.prototype.setInfo = function(item) {
        if (this._item !== item) {
            this._item = item;
        }
    };

    Window_WarehouseInfoItem.prototype.drawItemSub = function(item, r, index) {
        const scriptList = eval(PHPlugins.Params.PHWarehouseItemInfoDrawScript);
        if (scriptList && scriptList.length > 0) {
            scriptList.forEach(script => {
                try {
                    eval(script)
                } catch (e) {
                    console.error(e);
                    outputError(e);
                }
            });
        } else if (item === String(item)) {
            this.drawTextEx(item, r.x, r.y);
        } else if (item.hasOwnProperty('iconIndex')) {
            this.drawItemName(item, r.x, r.y, r.width);
        } else if (item.hasOwnProperty('name')) {
            this.drawTextEx(item.name, r.x, r.y);
        } else {
            this.drawTextEx(item.toString(), r.x, r.y);
            console.warn(item);
        }
    }

    Window_WarehouseInfoItem.prototype.drawNoteText = function(metaValue, x, y, width) {
        const meta = this._item.meta;
        if (meta[metaValue]) {
            const text = this._item.meta[metaValue];
            this.drawTextEx(text, x, y, width);
        }
    }

    Window_WarehouseInfoItem.prototype.drawNotePicture = function(metaValue, x, y, width = 236, height = 236) {
        const meta = this._item.meta;
        if (!meta[metaValue]) {
            return;
        }
        const fileName = meta[metaValue];
        if (fileName) {
            this.drawPicture(fileName, x, y, width, height);
        }
    };

    Window_WarehouseInfoItem.prototype.drawPicture = function(file, x, y, width = 236, height = 236) {
        const bitmap = ImageManager.loadPicture(file);
        bitmap.addLoadListener(function() {
            if (((bitmap._beforeUrl || bitmap._url).includes(this._image)) && bitmap.isReady()) {
                this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, /* x */ x, /* y */ y, /* width */width, /* height */height);
            }
        }.bind(this));
    }

    Window_WarehouseInfoItem.prototype.drawCP = function(x, y, width) {
        
        if(Imported.PNDK_LuggageCapacity && PHPlugins.Params.PHWarehouseCpFormat){
            this._cpFormat = PHPlugins.Params.PHWarehouseCpFormat.format(PNDKPlugins.Params.wText, this._item.meta.weight ? this._item.meta.weight : '1', PNDKPlugins.Params.wUnit);
            if(Utils.RPGMAKER_NAME==="MZ"){
                this.drawTextEx(`${this._cpFormat}`, /* x */ (width - this.textSizeEx(this._cpFormat).width) / 2, /* y */ y);
            }  
            if(Utils.RPGMAKER_NAME==="MV"){
                this.drawTextEx(`${this._cpFormat}`, /* x */ x, /* y */ y);
            }
            this.resetFontSettings();
        }
    }

    Window_WarehouseInfoItem.prototype.refresh = function() {
        this.contents.clear();
        if (this._item) this.drawItemSub(this._item, this.contents.rect);
    };
    
    Window_WarehouseInfoItem.prototype.drawItemPicture = function(x, y) {
        var bitmapName;
        if(this._item.meta[PHPlugins.Params.PHWarehouseItemTagName] && PHPlugins.Params.PHWarehouseItemTagName){
            //imageタグがある時
            bitmapName = PHPlugins.Params.PHWarehouseItemFolder + '/' + this._item.meta[PHPlugins.Params.PHWarehouseItemTagName];
        }else{
            //imageタグがない時
            bitmapName = PHPlugins.Params.PHWarehouseEmptyItemPictureFile;
        }
        const bitmap = bitmapName ? ImageManager.loaddx(bitmapName) : null;
        bitmap.addLoadListener(function() {
            if (((bitmap._beforeUrl || bitmap._url).includes(bitmapName)) && bitmap.isReady()) {
                this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, /* x */ x, /* y */ y, /* width */236, /* height */236);
            }
        }.bind(this));
    };

    //ADD
    ImageManager.loaddx = function(filename, hue) {
        return this.loadBitmap('img/', filename, hue, false);
    }

    //ADD
    const failedPicturePath = 'img/' + PHPlugins.Params.PHWarehouseEmptyItemPictureFile + '.png';
    const _Bitmap_onError = Bitmap.prototype._onError;
    Bitmap.prototype._onError = function() {
        _Bitmap_onError.apply(this, arguments);
        //画像がみつからないときに呼ばれる
        if (this._url != failedPicturePath) {
            this._beforeUrl = this._url;
            if(Number(PluginManager.parameters('ThroughFailedToLoad')['無視種別']) === 1 ||
                Number(PluginManager.parameters('ThroughFailedToLoad')['無視種別']) === 3){
                console.warn('タグが存在しているがファイルが存在しないので代替画像に入れ替えます');
                this._requestImage(failedPicturePath);
            }else{
                console.warn('ThroughFailedToLoadを導入することでエラー回避しEmptyImage画像に入れ替えられます');
                throw new Error('アイテム画像タグのファイルが存在しません : ' + this._beforeUrl);
            }
        } else {
            //入れ替えた画像(EmptyImage)も存在しないとき
            throw new Error('Failed to load EmptyImage');
        }
    };

    //最下部情報ウィンドウ
    function Window_WarehouseInfo() {
        this.initialize.apply(this, arguments);
    }
    Window_WarehouseInfo.prototype = Object.create(Window_Base.prototype);
    Window_WarehouseInfo.prototype.constructor = Window_WarehouseInfo;

    Window_WarehouseInfo.prototype.initialize = function(rect) {
        if(Utils.RPGMAKER_NAME==="MZ"){
            Window_Base.prototype.initialize.call(this, rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            Window_Base.prototype.initialize.call(this, 0, Graphics.boxHeight - this.fittingHeight(1), leftWindow_width(3), this.fittingHeight(1));
        }
        this.refresh();
    };

    Window_WarehouseInfo.prototype.refresh = function() {
        this.contents.clear();
        var maxCapacity;
        if(PHPlugins.PHWarehouse._warehouses[PHPlugins.PHWarehouse._lastActive].infinity) {
            maxCapacity = '∞';
        }else{
            maxCapacity = PHPlugins.PHWarehouse._warehouses[PHPlugins.PHWarehouse._lastActive].maxCapacity;
        }
        if(PHPlugins.Params.PHWarehouseInfoType === 'true'){ 
            // 利用済み
            if(Imported.PNDK_LuggageCapacity){
                this._infoSpaceFormat = PHPlugins.Params.PHWarehouseInfoSpaceFormat.format(
                    round(PHPlugins.PHWarehouse.getCurrentCapacity(PHPlugins.PHWarehouse._lastActive), PNDKPlugins.Params.decimalDigits), 
                    maxCapacity);
            }else{
                this._infoSpaceFormat = PHPlugins.Params.PHWarehouseInfoSpaceFormat.format(
                    PHPlugins.PHWarehouse.getCurrentCapacity(PHPlugins.PHWarehouse._lastActive), 
                    maxCapacity);
            }
            
        }else{
            // 空き
            if(Imported.PNDK_LuggageCapacity){
                this._infoSpaceFormat = PHPlugins.Params.PHWarehouseInfoSpaceFormat.format(
                    round(PHPlugins.PHWarehouse._warehouses[PHPlugins.PHWarehouse._lastActive].maxCapacity - PHPlugins.PHWarehouse.getCurrentCapacity(PHPlugins.PHWarehouse._lastActive), PNDKPlugins.Params.decimalDigits), 
                    maxCapacity);
            }else{
                this._infoSpaceFormat = PHPlugins.Params.PHWarehouseInfoSpaceFormat.format(
                    PHPlugins.PHWarehouse._warehouses[PHPlugins.PHWarehouse._lastActive].maxCapacity - PHPlugins.PHWarehouse.getCurrentCapacity(PHPlugins.PHWarehouse._lastActive), 
                    maxCapacity);
            }
            
        }
        if(Utils.RPGMAKER_NAME==="MZ"){
            this.changeTextColor(ColorManager.normalColor());
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            this.changeTextColor(this.normalColor());
        }
        this.drawTextEx(this._infoSpaceFormat, 0, 0, this.x);
    };

    //ADD
    Window_WarehouseItemList.prototype.isEnabled = function(item) {
        return !!item;
    };

    //ダイアログウィンドウ=====================================================================
	function Window_Dialog() {
		this.initialize.apply(this, arguments);
	}
	
	Window_Dialog.prototype = Object.create(Window_Base.prototype);
	Window_Dialog.prototype.constructor = Window_Dialog;
	
	Window_Dialog.prototype.initialize = function(x, y, width, height) {
		if(Utils.RPGMAKER_NAME==="MZ"){
			Window_Base.prototype.initialize.call(this, new Rectangle(x, y, width, height));
		}
		if(Utils.RPGMAKER_NAME==="MV"){
			Window_Base.prototype.initialize.call(this, x, y, width, height);
		}
	};

	/*
     * @param {String} text 
     */
	function noteOrString(text){
        if(text === undefined) return 'none';
        const last = text[text.length-1]
        if(text[0]==='"' && last ==='"'){
            return JSON.parse(text);
        }
        return String(text);
    }

    Window_Dialog.prototype.setDialog = function(title, message) {
        //描画するダイアログの内容を設定
        this._dialogTitle = title;
        this._dialogMessage = message;
        //実際にダイアログに描画
        this.refresh();
    }
	
	Window_Dialog.prototype.refresh = function() {
		var x = 0;
        var y = 0;
        var width;
        if(Utils.RPGMAKER_NAME==="MZ") {
            x = this.itemPadding();
            width =this.contents.width - this.itemPadding() * 2;
        }
        if(Utils.RPGMAKER_NAME==="MV") {
            x = this.textPadding();
            width = this.contents.width - this.textPadding() * 2;
        }
		this.contents.clear();
		this.drawDialogTitle(this._dialogTitle, x, y + this.fittingHeight(0), width);
		this.drawDialogValueMsg(this._dialogMessage, x, y + this.fittingHeight(2), width);
	};
	
	Window_Dialog.prototype.drawDialogTitle = function(value, x, y, width) {
		this.resetFontSettings();
		this.drawText(value, x, y, width, 'center');
	};

	Window_Dialog.prototype.drawDialogValueMsg = function(value, x, y) {
		this.resetFontSettings();
		this.drawTextEx(noteOrString(value), x, y);
	};
	
	//警告ウィンドウ内のOKボタン=====================================================================
	function Window_Dialog_Command() {
		this.initialize.apply(this, arguments);
	}
	
	Window_Dialog_Command.prototype = Object.create(Window_Selectable.prototype);
	Window_Dialog_Command.prototype.constructor = Window_Dialog_Command;

	Window_Dialog_Command.prototype.initialize = function(x, y, w) {
        this._okTextList = ['OK'];
		if(Utils.RPGMAKER_NAME==="MZ"){
			Window_Selectable.prototype.initialize.call(this, new Rectangle(x, y, w, this.fittingHeight(1)));
		}
		if(Utils.RPGMAKER_NAME==="MV"){
			Window_Selectable.prototype.initialize.call(this, x, y, w, this.fittingHeight(1));
		}
	};

    Window_Dialog_Command.prototype.setDialogCommand = function(commands) {
        this._okTextList = commands;
        this.refresh();
    };

	Window_Dialog_Command.prototype.maxItems = function() {
        return this._okTextList.length;
	};

	Window_Dialog_Command.prototype.maxCols = function() {
		return this._okTextList.length;
	};

	Window_Dialog_Command.prototype.refresh = function() {
        this.contents.clear();
        var okRectList = [];
        for(var i=0; i < this._okTextList.length; i++){
            if(Utils.RPGMAKER_NAME==="MV"){
                okRectList[i] = this.itemRectForText(i);
            }
            if(Utils.RPGMAKER_NAME==="MZ"){
                okRectList[i] = this.itemLineRect(i);
            }
            this.drawText(this._okTextList[i], okRectList[i].x, okRectList[i].y, okRectList[i].width, "center");
        }
	};

    /* ---------------------------------------------------------- *
     *                        SCENE PROCESS                       *
     * ---------------------------------------------------------- */

    function Scene_Warehouse() {
        this.initialize.apply(this, arguments);
    }

    Scene_Warehouse.prototype = Object.create(Scene_MenuBase.prototype);
    Scene_Warehouse.prototype.constructor = Scene_Warehouse;

    Scene_Warehouse.prototype.initialize = function() {
        Scene_MenuBase.prototype.initialize.call(this);
    };

    Scene_Warehouse.prototype.create = function() {
        Scene_MenuBase.prototype.create.call(this);

        this.createTitle();
        this.createOptions();
        this.createCategory();
        this.createOptions();
        this.createItemList();
        if(PHPlugins.Params.PHWarehouseShowPicture) this.createInfoItem();
        // if(!PHPlugins.PHWarehouse._warehouses[PHPlugins.PHWarehouse._lastActive].infinity) this.createInfoLocation();
        this.createInfoLocation();
        if(Imported.PNDK_LuggageCapacity) this.createCpWindow();//ADD
        this.setOptionsHandler();

        //ADD
        if(PHPlugins.Params.PHWarehouseTitleWindowBgHide){
            this._titleWindow.opacity = 0;
        }
        if(PHPlugins.Params.PHWarehouseAllWindowBgHide){
            this._titleWindow.opacity = 0;
            this._optionWindow.opacity = 0;
            this._categoryWindow.opacity = 0;
            this._itemWindow.opacity = 0;
            this._infoLocationWindow.opacity = 0;
            this._cpWindow.opacity = 0;
            this._infoItemWindow.opacity = 0;
        }
    };

    Scene_Warehouse.prototype.createTitle = function() {
        if(Utils.RPGMAKER_NAME==="MZ"){
            const rect = this.titleWindowRect();
            this._titleWindow = new Window_WarehouseTitle(rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            this._titleWindow = new Window_WarehouseTitle();
        }
        this.addWindow(this._titleWindow);
    };

    Scene_Warehouse.prototype.titleWindowRect = function() {
        const wx = 0;
        var wy;
        if(PHPlugins.Params.PHWarehouseWindowStartPosition){
            wy = 0;
        }else{
            wy = this.mainAreaTop();
        }
        const ww = Graphics.boxWidth;
        const wh = this.calcWindowHeight(1, false);
        return new Rectangle(wx, wy, ww, wh);
    }

    Scene_Warehouse.prototype.createOptions = function() {
        if(Utils.RPGMAKER_NAME==="MZ"){
            const rect = this.optionWindowRect();
            this._optionWindow = new Window_WarehouseOption(rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            this._optionWindow = new Window_WarehouseOption();
        }
        
        this.addWindow(this._optionWindow);
    };

    Scene_Warehouse.prototype.setOptionsHandler = function() {
        //オプションウィンドウのハンドラを設定
        this._optionWindow.setHandler('ok', this.onOptionOk.bind(this));
        if(PHPlugins.Params.PHWarehouseCategoryExitConfirm){
            this._optionWindow.setHandler('cancel', this.onDialogExit.bind(this));
        }else{
            this._optionWindow.setHandler('cancel', this.popScene.bind(this));
        }
    };

    //ADD 
    Scene_Warehouse.prototype.optionWindowRect = function() {
        const wx = 0;
        const wy = this._titleWindow.y + this._titleWindow.height;
        const ww = leftWindow_width(1);
        const wh = this.calcWindowHeight(1, true);
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Warehouse.prototype.createCategory = function() {
        if(Utils.RPGMAKER_NAME==="MZ"){
            const rect = this.categoryWindowRect();
            this._categoryWindow = new Window_WarehouseCategory(rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            this._categoryWindow = new Window_WarehouseCategory();
        }
        this._categoryWindow.setHandler('cancel', this.onCategoryCancel.bind(this));
        this._categoryWindow.setHandler('ok', this.onCategoryOk.bind(this));
        this.addWindow(this._categoryWindow);
        
        //ADD
        if(PHPlugins.Params.PHWarehouseCategoryAutoHidden && this._categoryWindow.maxCols() === 1) {
            PHPlugins.Params.PHWarehouseItemListEx = true;
            PHPlugins.Params.PHWarehouseCpLayout = 3;
            this._categoryWindow.hide();
        }else{
            PHPlugins.Params.PHWarehouseItemListEx = false;
            PHPlugins.Params.PHWarehouseCpLayout = Number(PHPlugins.Parameters['CP Layout']) || 2;
            this._categoryWindow.show();
        }
    };

    //ADD 
    Scene_Warehouse.prototype.categoryWindowRect = function() {
        const wx = 0;
        const wy = this._optionWindow.y + this._optionWindow.height;
        const ww = leftWindow_width(2);
        const wh = this.calcWindowHeight(1, true);
        return new Rectangle(wx, wy, ww, wh);
    };
    
    //(ADD)倉庫のCPウィンドウ
    Scene_Warehouse.prototype.createCpWindow = function() {
        var cp_width = PHPlugins.Params.PHWarehouseCpWidth; //CPウィンドウの位置やサイズを定義
        var x, y;
        var h;
        if(PHPlugins.Params.PHWarehouseCPLayoutTopForMZ && Utils.RPGMAKER_NAME==="MZ") {
            x = 0;
            y = 0;
            if (PHPlugins.Params.PHWarehouseWindowStartPosition){
                h = this.calcWindowHeight(1, false);
            }else{
                h = 52;
            } 
        }else if(PHPlugins.Params.PHWarehouseCpLayout === 1){
            x = Graphics.boxWidth - cp_width;
            y = this._optionWindow.y;
            h = this._optionWindow.height;
        }else if(PHPlugins.Params.PHWarehouseCpLayout === 3) {
            x = Graphics.boxWidth - cp_width;
            y = this._infoLocationWindow.y;
            h = this._infoLocationWindow.height;
        }else{
            x = this._categoryWindow.x + this._categoryWindow.width;
            y = this._categoryWindow.y;
            h = this._categoryWindow.height;
        } 
        var w = cp_width;
        
        //CPウィンドウを追加
        var Window_CP = Imported.Window_CP;
        this._cpWindow = new Window_CP(x, y, w, h);
        this.addWindow(this._cpWindow);
    };

    Scene_Warehouse.prototype.createItemList = function() {
        if(Utils.RPGMAKER_NAME==="MZ"){
            const rect = this.itemListWindowRect();
            this._itemWindow = new Window_WarehouseItemList(rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            this._itemWindow = new Window_WarehouseItemList();
        }

        this._itemWindow.setHandler('ok', this.onItemOk.bind(this));
        this._itemWindow.setHandler('cancel', this.onItemCancel.bind(this));
        this.addWindow(this._itemWindow);
        this._categoryWindow.setItemWindow(this._itemWindow);
    };

    //ADD 
    Scene_Warehouse.prototype.itemListWindowRect = function() {
        const wx = 0;
        var ww;
        if(PHPlugins.Params.PHWarehouseShowPicture){
            ww = 550;
        }else{
            ww = Graphics.boxWidth;
        }
        var wy;
        if(PHPlugins.Params.PHWarehouseItemListEx){
            wy = this._optionWindow.y + this._optionWindow.height;
        }else{
            wy = this._categoryWindow.y + this._categoryWindow.height;
        }
        const wh = Graphics.boxHeight - wy - this.calcWindowHeight(1, false);
        return new Rectangle(wx, wy, ww, wh);
    };

    //ADD
    Scene_Warehouse.prototype.createInfoItem = function() {
        if(Utils.RPGMAKER_NAME==="MZ"){
            const rect = this.infoItemWindowRect();
            this._infoItemWindow = new Window_WarehouseInfoItem(rect);
            this.addWindow(this._infoItemWindow);
            this._infoItemWindow.refresh();
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            this._infoItemWindow = new Window_WarehouseInfoItem();
            this.addWindow(this._infoItemWindow);
            this._infoItemWindow.refresh();
        }
    };

    //ADD 
    Scene_Warehouse.prototype.infoItemWindowRect = function() {
        const wx = 550;
        const ww = Graphics.boxWidth - 550;
        var wy;
        if(PHPlugins.Params.PHWarehouseItemListEx){
            wy = this._optionWindow.y + this._optionWindow.height;
        }else{
            wy = this._categoryWindow.y + this._categoryWindow.height;
        }
        const wh = Graphics.boxHeight - wy - this.calcWindowHeight(1, false);
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Warehouse.prototype.createInfoLocation = function() {
        if(Utils.RPGMAKER_NAME==="MZ"){
            const rect = this.infoLocationWindowRect();
            this._infoLocationWindow = new Window_WarehouseInfo(rect);
        }
        if(Utils.RPGMAKER_NAME==="MV"){
            this._infoLocationWindow = new Window_WarehouseInfo();
        }
        this.addWindow(this._infoLocationWindow);
    };

    //ADD 
    Scene_Warehouse.prototype.infoLocationWindowRect = function() {
        const wx = 0;
        const wy = this._itemWindow.y + this._itemWindow.height;
        const ww = leftWindow_width(3);
        const wh = this.calcWindowHeight(1, false);
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Warehouse.prototype.onOptionOk = function() {
        this._optionWindow.changeOption();
        this._categoryWindow.activate();
        this._categoryWindow.select(0);
        this._optionWindow.deactivate();
    
        //ADD
        if(this._categoryWindow.maxCols() === 1){
            this._itemWindow.setCategory(this._categoryWindow.currentSymbol());
            this.onCategoryOk();
        }
    };

    Scene_Warehouse.prototype.onCategoryOk = function() {
        this._itemWindow.activate();
        this._itemWindow.select(0);
        this._categoryWindow.deactivate();
    };

    Scene_Warehouse.prototype.onCategoryCancel = function() {
        this._categoryWindow.deselect();
        this._optionWindow.activate();
    };

    Scene_Warehouse.prototype.onItemCancel = function() {
        this._itemWindow.deselect();
        this._categoryWindow.activate();
        //ADD
        if(this._categoryWindow.maxCols() === 1){
            this._categoryWindow.deselect();
            this._categoryWindow.deactivate();
            this._optionWindow.activate();
        }
    };

    Scene_Warehouse.prototype.onItemOk = function() {
        this._itemWindow.activate();
        this._itemWindow.moveItem();
        if(this._infoLocationWindow) this._infoLocationWindow.refresh();
        this._itemWindow.refresh();

        //(ADD)預けたり引き出す時にCPウィンドウを更新する
        if(Imported.PNDK_LuggageCapacity) this._cpWindow.refresh();
    };

    var _Scene_Warehouse_createBackground = Scene_Warehouse.prototype.createBackground;
    Scene_Warehouse.prototype.createBackground = function(){
        if(PHPlugins.Params.PHWarehouseBackgroundImage){
            this._backgroundSprite = new Sprite();
            this._backgroundSprite.bitmap = ImageManager.loadPicture(PHPlugins.Params.PHWarehouseBackgroundImage);
            this.addChild(this._backgroundSprite);
            return;
        }
        // if background file is invalid, it does original process.
        _Scene_Warehouse_createBackground.call(this);
    };

    Scene_Warehouse.prototype.createDialogWindow = function(rect) {
		//警告ウィンドウを表示
		this._dialogWindow = new Window_Dialog(rect.x, rect.y, rect.width, rect.height);
		this.addWindow(this._dialogWindow);
		//ウィンドウ下にボタンを表示
        this._dialogCommand = new Window_Dialog_Command(rect.x, rect.y + rect.height, rect.width);
		this.addWindow(this._dialogCommand);
	};
    
    Scene_Warehouse.prototype.dialogWindowRect = function(message) {
        //ダイアログのサイズを設定
        const lengthRow = findLong(message);
		const countRow = ( message.match( /\\n/g ) || [] ).length ;
        var wx, wy, ww, wh;
		if(Utils.RPGMAKER_NAME==="MZ"){
			ww = lengthRow * 28;
			wh = 200 + 30 * countRow;
		}
		if(Utils.RPGMAKER_NAME==="MV"){
			ww = lengthRow * 31;
			wh = 200 + 32 * countRow;
		}
		wx = Graphics.boxWidth / 2 - ww / 2;
		wy = Graphics.boxHeight / 2 - wh / 2 - 50;
        
        return new Rectangle(wx, wy, ww, wh);
    }

    Scene_Warehouse.prototype.closeDialogWindow = function() {
        this._dialogWindow.hide();
        this._dialogCommand.deactivate();
		this._dialogCommand.hide();
        delete this.dialogWindow;
        delete this.dialogCommand;
    };

    Scene_Warehouse.prototype.activeDialogWindow = function() {
        if(this._itemWindow) this._itemWindow.deactivate();
        this._dialogCommand.select(0);
        this._dialogCommand.activate();
    }

    //退出確認ダイアログを表示
    Scene_Warehouse.prototype.onDialogExit = function() {
        this.createDialogWindow(this.dialogWindowRect(PHPlugins.Params.PHWarehouseExitConfirmMessage));
        this._dialogWindow.setDialog(PHPlugins.Params.PHWarehouseExitConfirmTitle, PHPlugins.Params.PHWarehouseExitConfirmMessage);
        this._dialogCommand.setDialogCommand([PHPlugins.Params.PHWarehouseExitConfirmBtnOk, PHPlugins.Params.PHWarehouseExitConfirmBtnCancel]);
        this._dialogCommand.setHandler('ok', this.onDialogExitOk.bind(this));
        this._dialogCommand.setHandler('cancel', this.onDialogExitCancel.bind(this));
        this.activeDialogWindow();
	}

    //退出確認ダイアログでダイアログボックス内ボタンを押した時
    Scene_Warehouse.prototype.onDialogExitOk = function() {
        if(this._dialogCommand._index === 0) this.popScene();
        else {
            this._optionWindow.activate();
            this.closeDialogWindow();
        }
	}

    //退出確認ダイアログでキャンセルボタン(右クリック等)を押したとき
    Scene_Warehouse.prototype.onDialogExitCancel = function() {
        this._optionWindow.activate();
        this.closeDialogWindow();
	}

    //アイテム個数制限のダイアログでダイアログボックス内ボタンを押した時
    Scene_Warehouse.prototype.onDialogOverItemQuantityOk = function() {
        this._itemWindow.activate();
        this.closeDialogWindow();
	}

    //アイテム個数制限のダイアログでキャンセルボタン(右クリック等)を押したとき
    Scene_Warehouse.prototype.onDialogOverItemQuantityCancel = function() {
        this._itemWindow.activate();
        this.closeDialogWindow();
	}

    //ADD

    Window_Base.prototype.getItemName = function(item) {
		if(item) {
			return item.name;
		}else{
			console.warn('getItemNameにitem要素を入力してください');
			return '(item要素がありません)';
		}
	}

    var _Window_Base_getItemNameWithCP = Window_Base.prototype.getItemNameWithCP;
    Window_Base.prototype.getItemNameWithCP = function(item){
        if(item){
            if(Imported.PNDK_LuggageCapacity) return _Window_Base_getItemNameWithCP.call(this, item);
            else return item.name;
        }
    }

})();