/*:
 * @plugindesc 未鑑定アイテム鑑定プラグイン v1.1
 * @author Mika
 * 
 * @help
 * アイテムのメモ欄に <Identify:X> と書くことで、
 * このアイテムを鑑定すると ID:X のアイテムに変化します。
 * 
 * 鑑定イベントで以下のスクリプトを実行してください：
 *   IdentifyManager.show();
 * 
 * 未鑑定アイテムは自動でリストアップされ、
 * 鑑定後に変化＆メッセージ演出を表示します。
 */

(function() {
  window.IdentifyManager = {
    _items: [],

    show() {
      this._items = $gameParty.allItems().filter(item => this.getTargetId(item));
      if (this._items.length === 0) {
        $gameMessage.add("未鑑定アイテムは持っていません。");
        return;
      }
      const choices = this._items.map(item => item.name);
      choices.push("やめる");
      $gameMessage.setChoices(choices, 0, -1);
      $gameMessage.setChoiceCallback(index => {
        if (index >= 0 && index < this._items.length) {
          $gameTemp._identifyTargetItem = this._items[index];
          $gameTemp.reserveCommonEvent(IdentifyManager._commonEventId);
        }
      });
      $gameMessage.add("どのアイテムを鑑定しますか？");
    },

    getTargetId(item) {
      const match = item.note.match(/<Identify:(\d+)>/);
      return match ? Number(match[1]) : 0;
    },

    runIdentify() {
      const item = $gameTemp._identifyTargetItem;
      if (!item) return;

      const targetId = this.getTargetId(item);
      if (!targetId) return;

      $gameParty.loseItem(item, 1);
      const targetItem = DataManager.itemDatabase()[targetId];
      $gameParty.gainItem(targetItem, 1);

      const sfxList = [
        { name: "Magic2", pitch: 150 },
        { name: "Item3", pitch: 100 },
        { name: "Bell2", pitch: 80 },
      ];
      const sfx = sfxList[Math.floor(Math.random() * sfxList.length)];
      AudioManager.playSe({ name: sfx.name, volume: 90, pitch: sfx.pitch, pan: 0 });

      const msgList = [
        `アイテムの正体は……《${targetItem.name}》だった！`,
        `鑑定完了！ → ${targetItem.name}を入手！`,
        `光に包まれたアイテムは《${targetItem.name}》に変化した！`
      ];
      const msg = msgList[Math.floor(Math.random() * msgList.length)];
      $gameMessage.add(msg);
    },

    _commonEventId: 2  // ← ここに使用するコモンイベントのIDを指定
  };

  DataManager.itemDatabase = function() {
    return $dataItems.concat($dataWeapons).concat($dataArmors);
  };
})();

