/*:
 * @target MZ
 * @plugindesc 所持アイテムだけ選択肢に表示するプラグイン（水・梅酒・血）＋演出付き♪（眼疑まりver）
 * @author サラ
 *
 * @command ShowItemChoices
 * @text アイテム選択肢を表示する
 * @desc 所持しているアイテム（水・梅酒・血）だけを選択肢に出します。
 */

(() => {
  const pluginName = "DynamicItemChoice";

  const ITEM_IDS = {
    "水": 12,
    "梅酒": 17,
    "血": 18
  };

  const VARIABLE_ID = 10; // 選ばれたアイテムIDを格納する変数

  PluginManager.registerCommand(pluginName, "ShowItemChoices", function() {
    const choices = [];
    for (const [name, id] of Object.entries(ITEM_IDS)) {
      if ($gameParty.hasItem($dataItems[id])) {
        choices.push(name);
      }
    }

    if (choices.length === 0) {
      $gameMessage.add("眼疑まりは対抗手段を何も持っていなかった。");

      setTimeout(() => {
        SceneManager.goto(Scene_Gameover);
      }, 3000); // 3秒後にゲームオーバーへ

      return;
    }

    $gameMessage.setChoices(choices, 0, -1);
    $gameMessage.setChoiceCallback(choiceIndex => {
      const selected = choices[choiceIndex];
      const itemId = ITEM_IDS[selected];
      $gameVariables.setValue(VARIABLE_ID, itemId);

      // メッセージで演出！
      $gameMessage.add(`${selected}を手に取った……`);

      // セルフスイッチA を ON！
      const mapId = $gameMap.mapId();
      const eventId = this._eventId;
      $gameSelfSwitches.setValue([mapId, eventId, 'A'], true);
    });
  });
})();
