/*:
 * @target MZ
 * @plugindesc グリーンハーブ(ID:2)とレッドハーブ(ID:15)を合成して丸薬(ID:16)を作るプラグイン（完全動作版）
 * @author サラ
 */

(() => {
    const GREEN_HERB_ID = 2;
    const RED_HERB_ID = 15;
    const PILL_ID = 16;

    // メニューに「ハーブ合成」を追加
    const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
    Window_MenuCommand.prototype.addOriginalCommands = function () {
        _Window_MenuCommand_addOriginalCommands.call(this);
        const hasGreen = $gameParty.hasItem($dataItems[GREEN_HERB_ID]);
        const hasRed = $gameParty.hasItem($dataItems[RED_HERB_ID]);
        this.addCommand("ハーブ合成", "herbSynthesis", hasGreen && hasRed);
    };

    // メニューで合成コマンドが選ばれたときの処理
    const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function () {
        _Scene_Menu_createCommandWindow.call(this);
        this._commandWindow.setHandler("herbSynthesis", this.commandHerbSynthesis.bind(this));
    };

    // 合成の本体処理（メニューを閉じてから実行）
    Scene_Menu.prototype.commandHerbSynthesis = function () {
        const green = $gameParty.numItems($dataItems[GREEN_HERB_ID]);
        const red = $gameParty.numItems($dataItems[RED_HERB_ID]);

        this.popScene();

        setTimeout(() => {
            if (green > 0 && red > 0) {
                $gameParty.loseItem($dataItems[GREEN_HERB_ID], 1);
                $gameParty.loseItem($dataItems[RED_HERB_ID], 1);
                $gameParty.gainItem($dataItems[PILL_ID], 1);
                SoundManager.playUseItem();
                $gameMessage.add("グリーンハーブとレッドハーブを合成して、丸薬を作った！");
            } else {
                $gameMessage.add("材料が足りません！");
            }
        }, 10);
    };
})();