/*:
 * @target MZ
 * @plugindesc 完成版：敵を中心に十字ビーム（2マス×4方向）を180フレーム出すレーザー敵。トゲは無視・壁は通れない・ビームは壁貫通。by サラ
 *
 * @help
 * イベント名が「レーザー敵」のマップイベントが以下の行動を繰り返します：
 * ・240フレーム移動（自律移動：プレイヤーに近づく）
 * ・その場で停止し、180フレーム間、十字（上下左右）2マスずつにビームを表示
 * ・ビーム表示中にSE（Laser1）再生、壁貫通
 * ・プレイヤーがビームに触れると毎フレーム30ダメージ（ログも出力）
 * ・レーザー敵はトゲイベントをすり抜けるが、壁はすり抜けない
 */

(() => {
  const LASER_DURATION = 180;
  const LASER_INTERVAL = 240;
  const LASER_COLOR = 0xffff00;
  const LASER_DAMAGE = 30;
  const LASER_SE = { name: "Laser1", pan: 0, pitch: 100, volume: 90 };

  const activeLasers = [];

  class LaserCross {
    constructor(x, y) {
      this.x = x;
      this.y = y;
      this.timer = LASER_DURATION;
    }

    update() {
      this.timer--;
    }

    isActive() {
      return this.timer > 0;
    }

    tiles() {
      const list = [];
      for (let i = 1; i <= 2; i++) {
        list.push([this.x + i, this.y]);
        list.push([this.x - i, this.y]);
        list.push([this.x, this.y + i]);
        list.push([this.x, this.y - i]);
      }
      return list;
    }
  }

  const _Game_Event_update = Game_Event.prototype.update;
  Game_Event.prototype.update = function() {
    _Game_Event_update.call(this);

    if (this.event().name === "レーザー敵") {
      if (!this._laserPhase) {
        this._laserPhase = "move";
        this._laserTimer = LASER_INTERVAL;
      }

      if (this._laserPhase === "move") {
        this._laserTimer--;
        if (this._laserTimer <= 0) {
          this._laserPhase = "laser";
          this._laserTimer = LASER_DURATION;
          this._originalMoveType = this._moveType;
          this._moveType = 0; // 自律移動停止！
          this.setMoveRoute({ list: [{ code: 0 }], repeat: false, skippable: true, wait: false });
          this.setDirectionFix(true);
          AudioManager.playSe(LASER_SE);
          activeLasers.push(new LaserCross(this.x, this.y));
        }
      } else if (this._laserPhase === "laser") {
        this._laserTimer--;
        if (this._laserTimer <= 0) {
          this._laserPhase = "move";
          this._laserTimer = LASER_INTERVAL;
          if (this._originalMoveType != null) {
            this._moveType = this._originalMoveType;
            this._originalMoveType = null;
          }
          this.setDirectionFix(false);
        }
      }
    }
  };

  const _Game_Event_isCollidedWithEvents = Game_Event.prototype.isCollidedWithEvents;
  Game_Event.prototype.isCollidedWithEvents = function(x, y) {
    if (this.event().name === "レーザー敵") return false;
    return _Game_Event_isCollidedWithEvents.call(this, x, y);
  };

  const _Spriteset_Map_createUpperLayer = Spriteset_Map.prototype.createUpperLayer;
  Spriteset_Map.prototype.createUpperLayer = function() {
    _Spriteset_Map_createUpperLayer.call(this);
    this._laserGraphics = new PIXI.Container();
    this.addChild(this._laserGraphics);
  };

  const _Spriteset_Map_update = Spriteset_Map.prototype.update;
  Spriteset_Map.prototype.update = function() {
    _Spriteset_Map_update.call(this);
    this._laserGraphics.removeChildren();

    for (let i = activeLasers.length - 1; i >= 0; i--) {
      const laser = activeLasers[i];
      laser.update();
      if (!laser.isActive()) {
        activeLasers.splice(i, 1);
        continue;
      }

      for (const [tx, ty] of laser.tiles()) {
        const x = $gameMap.tileWidth() * tx;
        const y = $gameMap.tileHeight() * ty;

        const g = new PIXI.Graphics();
        g.beginFill(LASER_COLOR);
        g.drawRect(0, 0, $gameMap.tileWidth(), $gameMap.tileHeight());
        g.endFill();
        g.blendMode = PIXI.BLEND_MODES.ADD;
        g.x = x;
        g.y = y;
        this._laserGraphics.addChild(g);
      }
    }
  };

  const _Scene_Map_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function() {
    _Scene_Map_update.call(this);

    for (const laser of activeLasers) {
      if (!laser.isActive()) continue;
      for (const [x, y] of laser.tiles()) {
        if ($gamePlayer.x === x && $gamePlayer.y === y) {
          console.log("[レーザー] プレイヤーに30ダメージ");
          $gameParty.members()[0].gainHp(-LASER_DAMAGE);
        }
      }
    }
  };
})();
