/*:
 * @target MZ
 * @plugindesc マップごとにSEとBGMの音量を一括制御できるプラグイン by サラ
 *
 * @help
 * ■使い方
 * マップのメモ欄に以下のように記述してください：
 *
 * <SEVolume:60>  // SEを60%で再生
 * <BGMVolume:80> // BGMを80%で再生
 *
 * 通常の AudioManager.playSe や playBgm をそのまま使っても、
 * 自動的にこの音量に合わせて再生されます。
 *
 * イベントで個別に音量を指定したい場合も、
 * その音量にマップ音量が乗算されます。
 */

(() => {
  const _AudioManager_playSe = AudioManager.playSe;
  AudioManager.playSe = function(se) {
    if (se && se.name) {
      const seVol = getMapVolume('SEVolume');
      const originalVol = se.volume != null ? se.volume : 90;
      se.volume = Math.floor(originalVol * seVol / 100);
    }
    _AudioManager_playSe.call(this, se);
  };

  const _AudioManager_playBgm = AudioManager.playBgm;
  AudioManager.playBgm = function(bgm, pos) {
    if (bgm && bgm.name) {
      const bgmVol = getMapVolume('BGMVolume');
      const originalVol = bgm.volume != null ? bgm.volume : 90;
      bgm.volume = Math.floor(originalVol * bgmVol / 100);
    }
    _AudioManager_playBgm.call(this, bgm, pos);
  };

  function getMapVolume(tagName) {
    if (!$gameMap || !$dataMap) return 100;
    const meta = $dataMap.meta[tagName];
    return meta ? Number(meta) : 100;
  }
})();
