
/*:
 * @target MZ
 * @plugindesc メニュー画面に説明画像（setumei.png）を表示するプラグイン（中央下寄せ・100%）
 * @author サラ
 *
 * @help Sara_Menu説明画像表示.js
 *
 * このプラグインは、メニュー画面（Scene_Menu）に
 * img/pictures/setumei.png を100%サイズで中央下に表示します。
 *
 * 画像がプロジェクトの img/pictures/ フォルダにあることを確認してね！
 */

(() => {
    const _Scene_Menu_create = Scene_Menu.prototype.create;
    Scene_Menu.prototype.create = function() {
        _Scene_Menu_create.call(this);
        this.createSetumeiPicture();
    };

    Scene_Menu.prototype.createSetumeiPicture = function() {
        const sprite = new Sprite();
        const bitmap = ImageManager.loadPicture("setumei");
        sprite.bitmap = bitmap;

        // 表示位置調整（中央下寄せ）
        sprite.anchor.x = 0.5;
        sprite.anchor.y = 1.0;

        bitmap.addLoadListener(() => {
            sprite.x = Graphics.boxWidth / 2;
            sprite.y = Graphics.boxHeight - 20;
            console.log("[Sara_Menu説明画像表示] setumei.png を表示しました✨");
        });

        this.addChild(sprite);
    };
})();
