
/*:
 * @target MZ
 * @plugindesc 背景にMP4動画を再生するプラグイン（ループ対応） ver1.0
 * @author サラちゃん
 * 
 * @help VideoBackground.js
 * 
 * 【使い方】
 * イベントのスクリプトで以下のように書いてください：
 * 
 * VideoBackground.play("magamaga"); // movies/magamaga.mp4 をループ再生
 * 
 * VideoBackground.stop(); // 再生を止める
 */

(() => {
    window.VideoBackground = {
        _video: null,
        _sprite: null,

        play(filename) {
            if (this._video) this.stop();

            const video = document.createElement("video");
            video.src = `movies/${filename}.mp4`;
            video.loop = true;
            video.muted = true;
            video.setAttribute("playsinline", "");
            video.setAttribute("webkit-playsinline", "");
            video.style.display = "none";
            document.body.appendChild(video);

            const texture = PIXI.Texture.from(video);
            const sprite = new PIXI.Sprite(texture);
            sprite.width = Graphics.width;
            sprite.height = Graphics.height;
            sprite.x = 0;
            sprite.y = 0;

            SceneManager._scene.addChildAt(sprite, 0);
            video.play();

            this._video = video;
            this._sprite = sprite;
        },

        stop() {
            if (this._video) {
                this._video.pause();
                this._video.remove();
                this._video = null;
            }
            if (this._sprite && SceneManager._scene.children.includes(this._sprite)) {
                SceneManager._scene.removeChild(this._sprite);
                this._sprite.destroy();
                this._sprite = null;
            }
        }
    };
})();
