/*:
 * @target MZ
 * @plugindesc enemyDamage配列に連動してイベント上にHPバーを表示しますっ💖
 * @author サラ
 */

(() => {
    class HpBarSprite extends Sprite {
        constructor(eventId) {
            super(new Bitmap(48, 6));
            this._eventId = eventId;
            this._maxHp = 3; // 好きな最大HPにしてね！
        }

        updatePosition(event) {
            this.x = event.screenX() - 24;
            this.y = event.screenY() - 48;
        }

        updateHp() {
            const damage = enemyDamage?.[this._eventId - 1] || 0;
            const hp = Math.max(0, this._maxHp - damage);
            const rate = hp / this._maxHp;
            const w = this.bitmap.width;
            const h = this.bitmap.height;

            this.bitmap.clear();
            this.bitmap.fillRect(0, 0, w, h, "#000000"); // 背景（黒）
            this.bitmap.fillRect(1, 1, (w - 2) * rate, h - 2, "#ff6699"); // HP（ピンク）
        }
    }

    const _Spriteset_Map_createCharacters = Spriteset_Map.prototype.createCharacters;
    Spriteset_Map.prototype.createCharacters = function() {
        _Spriteset_Map_createCharacters.call(this);
        this._hpBars = [];

        for (let i = 0; i < $gameMap.events().length; i++) {
            const event = $gameMap.events()[i];
            const eventId = event.eventId();

            // イベント名またはメモ欄などで敵と判断（ここではすべて対象）
            const hpBar = new HpBarSprite(eventId);
            this._tilemap.addChild(hpBar);
            this._hpBars.push({ event, sprite: hpBar });
        }
    };

    const _Spriteset_Map_update = Spriteset_Map.prototype.update;
    Spriteset_Map.prototype.update = function() {
        _Spriteset_Map_update.call(this);

        for (const { event, sprite } of this._hpBars) {
            sprite.updatePosition(event);
            sprite.updateHp();
        }
    };
})();
