/*:
 * @target MZ
 * @plugindesc メモアイテム表示プラグイン：アイテム画面に「メモ」カテゴリを追加し、画像付きで表示します♡
 * @author サラ
 */

(() => {
  // カテゴリウィンドウに「メモ」を追加
  const _Window_ItemCategory_makeCommandList = Window_ItemCategory.prototype.makeCommandList;
  Window_ItemCategory.prototype.makeCommandList = function() {
    _Window_ItemCategory_makeCommandList.call(this);
    this.addCommand("メモ", "note");
  };

  // メモカテゴリ選択時の処理
  const _Scene_Item_createItemWindow = Scene_Item.prototype.createItemWindow;
  Scene_Item.prototype.createItemWindow = function() {
    _Scene_Item_createItemWindow.call(this);
    this._itemWindow.setHandler("ok", this.onItemOk.bind(this));
    this._itemWindow.setHandler("cancel", this.onItemCancel.bind(this));
    this._categoryWindow.setHandler("note", this.onCategoryNote.bind(this));
  };

  Scene_Item.prototype.onCategoryNote = function() {
    this._itemWindow.setCategory("note");
    this._itemWindow.activate();
    this._itemWindow.selectLast();
  };

  // 「メモ」カテゴリ内に表示するアイテム判定（メモタグ含む）
  const _Window_ItemList_includes = Window_ItemList.prototype.includes;
  Window_ItemList.prototype.includes = function(item) {
    if (!item) return false;
    if (this._category === "note") {
      return item.note.includes("<NoteImage:");
    }
    return _Window_ItemList_includes.call(this, item);
  };

  // ピクチャ表示部分の準備
  const _Scene_Item_create = Scene_Item.prototype.create;
  Scene_Item.prototype.create = function() {
    _Scene_Item_create.call(this);
    this.createNoteImageSprite();
  };

  Scene_Item.prototype.createNoteImageSprite = function() {
    this._noteImageSprite = new Sprite();
    this._noteImageSprite.anchor.set(0.5, 0.5);
    this._noteImageSprite.x = Graphics.width / 2;
    this._noteImageSprite.y = Graphics.height / 2;
    this._noteImageSprite.visible = false;
    this.addChild(this._noteImageSprite);
  };

  // ピクチャ表示の更新処理
  const _Scene_Item_update = Scene_Item.prototype.update;
  Scene_Item.prototype.update = function() {
    _Scene_Item_update.call(this);
    this.updateNoteImageDisplay();
  };

  Scene_Item.prototype.updateNoteImageDisplay = function() {
    if (this._categoryWindow.currentSymbol() === "note" && this._itemWindow.active) {
      const item = this._itemWindow.item();
      if (item && item.note.includes("<NoteImage:")) {
        const match = item.note.match(/<NoteImage:(.+?)>/);
        if (match) {
          const filename = match[1].trim();
          if (!this._noteImageSprite.bitmap || this._noteImageSprite.bitmap.url !== filename) {
            this._noteImageSprite.bitmap = ImageManager.loadPicture(filename);
            this._noteImageSprite.bitmap.url = filename;
          }
          this._noteImageSprite.visible = true;
          const scaleX = 280 / this._noteImageSprite.bitmap.width;
          const scaleY = 340 / this._noteImageSprite.bitmap.height;
          this._noteImageSprite.scale.set(scaleX, scaleY);
        }
      } else {
        this._noteImageSprite.visible = false;
      }
    } else {
      this._noteImageSprite.visible = false;
    }
  };
})();
